/*
 * Decompiled with CFR 0.152.
 */
package clearExportGui;

import clearExportGui.BuildTrace;
import clearExportGui.CopyToFile;
import clearExportGui.IOEvent;
import clearExportGui.IOListener;
import clearExportGui.ProcessMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ExportFiles
extends JPanel
implements ActionListener,
IOListener,
DocumentListener,
ItemListener {
    public static String exportCmd = "clearExport_tc";
    public static String type = "-parts";
    public static String where = "";
    public static String out = "partsExport.txt";
    public static String relspec = "";
    public static String partspec = "";
    public static String release = "";
    public static String since = "";
    public static String index = "";
    public static String crlf = "";
    public static String sid = "";
    public static String components = "";
    BorderLayout border = new BorderLayout();
    BorderLayout outputPanelLayout = new BorderLayout();
    FlowLayout fl = new FlowLayout();
    BorderLayout layoutButtons = new BorderLayout();
    FlowLayout fl1 = new FlowLayout();
    JPanel exportTypePanel = new JPanel();
    JPanel outputPanel = new JPanel();
    JPanel boxPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JButton clearButton = new JButton("Clear");
    JButton exitButton = new JButton("Exit");
    JButton exportButton = new JButton("Export");
    JButton saveAsButton = new JButton("Save...");
    JButton outchButton = new JButton("Browse");
    JButton relspecButton = new JButton("Browse");
    JButton partspecButton = new JButton("Browse");
    JRadioButton CMVCButton = new JRadioButton();
    JRadioButton TCButton = new JRadioButton();
    Box labelBox = new Box(1);
    Box textfieldBox = new Box(1);
    Box buttonBox = new Box(1);
    JScrollPane scrollOutput = new JScrollPane();
    JTextArea scrollText = new JTextArea();
    JLabel releaseLab = new JLabel("Release:");
    JLabel relspecLab = new JLabel("RelSpec file:");
    JLabel partspecLab = new JLabel("PartSpecFile:");
    JLabel indexLab = new JLabel("Index:");
    JLabel sinceLab = new JLabel("Update Since:");
    JLabel outfileLab = new JLabel("OutFile:");
    JLabel whereLab = new JLabel("Where:");
    JTextField releaseTxt = new JTextField(20);
    JTextField relspecTxt = new JTextField(20);
    JTextField partspecTxt = new JTextField(20);
    JTextField indexTxt = new JTextField(20);
    JTextField sinceTxt = new JTextField(20);
    JTextField outfileTxt = new JTextField(out, 20);
    JTextField whereTxt = new JTextField(20);
    JCheckBox crlfCheckBox = new JCheckBox("crlf");
    JCheckBox sidCheckBox = new JCheckBox("Label SIDs");
    JCheckBox componentCheckBox = new JCheckBox("Label Components");
    int rc = 0;
    String cmd;
    private boolean mShown = false;

    public ExportFiles() {
        this.setLayout(this.border);
        this.setButtonPanelLayout();
        this.setBoxLayout();
        this.setOutputPanelLayout();
        this.setExportTypePanelLayout();
        this.CMVCButton.addActionListener(this);
        this.TCButton.addActionListener(this);
        this.exitButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.outchButton.addActionListener(this);
        this.relspecButton.addActionListener(this);
        this.partspecButton.addActionListener(this);
        this.saveAsButton.addActionListener(this);
        this.releaseTxt.getDocument().addDocumentListener(this);
        this.relspecTxt.getDocument().addDocumentListener(this);
        this.partspecTxt.getDocument().addDocumentListener(this);
        this.whereTxt.getDocument().addDocumentListener(this);
        this.crlfCheckBox.addItemListener(this);
        this.sidCheckBox.addItemListener(this);
        this.componentCheckBox.addItemListener(this);
        this.add("North", this.exportTypePanel);
        this.add("Center", this.outputPanel);
        this.add("South", this.buttonPanel);
        this.add("West", this.boxPanel);
    }

    private void setExportTypePanelLayout() {
        BuildTrace.println("In setExportTypePanelLayout");
        this.exportTypePanel.setSize(new Dimension(150, 220));
        this.exportTypePanel.setVisible(true);
        this.exportTypePanel.add(this.CMVCButton);
        this.exportTypePanel.add(this.TCButton);
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Export Source");
        this.exportTypePanel.setBorder(titledBorder);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.CMVCButton);
        buttonGroup.add(this.TCButton);
        this.CMVCButton.setVisible(true);
        this.CMVCButton.setText("CMVC");
        this.CMVCButton.setRequestFocusEnabled(false);
        this.TCButton.setVisible(true);
        this.TCButton.setSelected(true);
        this.TCButton.setText("TeamC");
        this.TCButton.setRequestFocusEnabled(false);
        BuildTrace.println("Leaving ExportTypePanelLayout");
    }

    private void setOutputPanelLayout() {
        BuildTrace.println("In setOutputPanelLayout");
        this.outputPanel.setLayout(this.outputPanelLayout);
        this.scrollOutput.setVisible(true);
        this.scrollOutput.setAutoscrolls(true);
        this.scrollOutput.setBackground(new Color(255, 255, 255));
        this.scrollOutput.getViewport().add(this.scrollText);
        this.scrollText.setVisible(true);
        this.outputPanel.add("Center", this.scrollOutput);
        BuildTrace.println("Leaving setOutputPanelLayout");
    }

    private void setButtonPanelLayout() {
        BuildTrace.println("In setButtonPanelLayout");
        this.buttonPanel.setLayout(this.layoutButtons);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 50, 10));
        jPanel2.setLayout(new FlowLayout(1, 50, 10));
        this.buttonPanel.add("West", jPanel);
        this.buttonPanel.add("East", jPanel2);
        jPanel.add(this.exportButton);
        jPanel2.add(this.clearButton);
        jPanel.add(this.exitButton);
        jPanel2.add(this.saveAsButton);
        BuildTrace.println("Leaving setButtonPanelLayout");
    }

    private void setBoxLayout() {
        BuildTrace.println("In setBoxLayout");
        this.boxPanel.setLayout(this.fl1);
        Box.createVerticalBox();
        Box.createVerticalBox();
        Box.createVerticalBox();
        this.labelBox.add(Box.createVerticalStrut(30));
        this.labelBox.add(this.releaseLab);
        this.labelBox.add(Box.createVerticalStrut(22));
        this.labelBox.add(this.relspecLab);
        this.labelBox.add(Box.createVerticalStrut(22));
        this.labelBox.add(this.partspecLab);
        this.labelBox.add(Box.createVerticalStrut(22));
        this.labelBox.add(this.indexLab);
        this.labelBox.add(Box.createVerticalStrut(22));
        this.labelBox.add(this.sinceLab);
        this.labelBox.add(Box.createVerticalStrut(22));
        this.labelBox.add(this.outfileLab);
        this.labelBox.add(Box.createVerticalStrut(22));
        this.labelBox.add(this.whereLab);
        this.labelBox.add(Box.createVerticalStrut(20));
        this.labelBox.add(this.crlfCheckBox);
        this.labelBox.add(Box.createVerticalStrut(12));
        this.labelBox.add(this.sidCheckBox);
        this.sidCheckBox.setVisible(false);
        this.labelBox.add(Box.createVerticalStrut(12));
        this.labelBox.add(this.componentCheckBox);
        this.componentCheckBox.setVisible(false);
        this.labelBox.setSize(((Container)this.labelBox).getPreferredSize());
        ((Component)this.labelBox).setVisible(true);
        this.textfieldBox.add(Box.createVerticalStrut(15));
        this.textfieldBox.add(this.releaseTxt);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(this.relspecTxt);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(this.partspecTxt);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(this.indexTxt);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(this.sinceTxt);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(this.outfileTxt);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(this.whereTxt);
        JTextField jTextField = new JTextField(20);
        jTextField.setVisible(false);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(jTextField);
        JTextField jTextField2 = new JTextField(20);
        jTextField2.setVisible(false);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(jTextField2);
        JTextField jTextField3 = new JTextField(20);
        jTextField3.setVisible(false);
        this.textfieldBox.add(Box.createVerticalStrut(17));
        this.textfieldBox.add(jTextField3);
        this.textfieldBox.setSize(((Container)this.textfieldBox).getPreferredSize());
        ((Component)this.textfieldBox).setVisible(true);
        JButton jButton = new JButton("              ");
        jButton.setBorderPainted(false);
        JButton jButton2 = new JButton("              ");
        jButton2.setBorderPainted(false);
        JButton jButton3 = new JButton("              ");
        jButton3.setBorderPainted(false);
        JButton jButton4 = new JButton("              ");
        jButton4.setBorderPainted(false);
        JButton jButton5 = new JButton("              ");
        jButton5.setBorderPainted(false);
        JButton jButton6 = new JButton("              ");
        jButton6.setBorderPainted(false);
        JButton jButton7 = new JButton("              ");
        jButton7.setBorderPainted(false);
        this.buttonBox.add(Box.createVerticalStrut(20));
        this.buttonBox.add(jButton);
        this.buttonBox.add(Box.createVerticalStrut(12));
        this.buttonBox.add(this.relspecButton);
        this.buttonBox.add(Box.createVerticalStrut(12));
        this.buttonBox.add(this.partspecButton);
        this.buttonBox.add(Box.createVerticalStrut(12));
        this.buttonBox.add(jButton4);
        this.buttonBox.add(Box.createVerticalStrut(12));
        this.buttonBox.add(jButton3);
        this.buttonBox.add(Box.createVerticalStrut(8));
        this.buttonBox.add(this.outchButton);
        this.buttonBox.add(Box.createVerticalStrut(12));
        this.buttonBox.add(jButton2);
        this.buttonBox.add(Box.createVerticalStrut(12));
        this.buttonBox.add(jButton5);
        this.buttonBox.add(Box.createVerticalStrut(12));
        this.buttonBox.add(jButton6);
        this.buttonBox.add(Box.createVerticalStrut(12));
        this.buttonBox.add(jButton7);
        ((Component)this.buttonBox).setVisible(true);
        this.boxPanel.add(this.labelBox);
        this.boxPanel.add(this.textfieldBox);
        this.boxPanel.add(this.buttonBox);
        this.boxPanel.setVisible(true);
        BuildTrace.println("Leaving setBoxLayout");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.TCButton) {
            BuildTrace.println("TC migration radio button selected");
            exportCmd = "clearExport_tc";
            this.sidCheckBox.setVisible(false);
            this.componentCheckBox.setVisible(false);
            if (this.sidCheckBox.isSelected()) {
                this.sidCheckBox.doClick();
            }
            if (this.componentCheckBox.isSelected()) {
                this.componentCheckBox.doClick();
            }
        } else if (object == this.CMVCButton) {
            BuildTrace.println("CMVC migration radio button selected");
            exportCmd = "clearExport_cmvc";
            this.sidCheckBox.setVisible(true);
            this.componentCheckBox.setVisible(true);
        } else if (object == this.exitButton) {
            BuildTrace.println("ExitButton selected");
            System.exit(0);
        } else if (object == this.outchButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("."));
            jFileChooser.setSelectedFile(new File(out));
            int n = jFileChooser.showOpenDialog(this);
            out = jFileChooser.getSelectedFile().getAbsolutePath();
            this.outfileTxt.setText(out);
        } else if (object == this.relspecButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("."));
            jFileChooser.setSelectedFile(new File(relspec));
            int n = jFileChooser.showOpenDialog(this);
            relspec = jFileChooser.getSelectedFile().getAbsolutePath();
            if (this.relspecTxt.isEditable()) {
                this.relspecTxt.setText(relspec);
            }
        } else if (object == this.partspecButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("."));
            jFileChooser.setSelectedFile(new File(partspec));
            int n = jFileChooser.showOpenDialog(this);
            partspec = jFileChooser.getSelectedFile().getAbsolutePath();
            this.partspecTxt.setText(partspec);
        } else if (object == this.clearButton) {
            BuildTrace.println("clear buttonpressed");
            this.scrollText.setText("");
        } else if (object == this.saveAsButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("."));
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                String string2 = this.scrollText.getText();
                CopyToFile copyToFile = new CopyToFile(string2, string);
                copyToFile.print();
            }
        } else if (object == this.exportButton) {
            BuildTrace.println("export button pressed");
            String string = "";
            if (this.releaseTxt.getText().length() > 0) {
                release = "-release";
            }
            if (this.relspecTxt.getText().length() > 0) {
                relspec = "-relspec";
            }
            if (this.partspecTxt.getText().length() > 0) {
                partspec = "-partspec";
            }
            if (this.sinceTxt.getText().length() > 0) {
                since = "-since";
            }
            if (this.whereTxt.getText().length() > 0) {
                where = "-where";
            }
            if (this.indexTxt.getText().length() > 0) {
                index = "-partindex";
            }
            this.cmd = exportCmd.concat(" ").concat(type).concat(" ").concat("  -o ").concat(this.outfileTxt.getText()).concat(" ").concat(release).concat(" ").concat(this.releaseTxt.getText()).concat(" ").concat(relspec).concat(" ").concat(this.relspecTxt.getText()).concat(" ").concat(partspec).concat(" ").concat(this.partspecTxt.getText()).concat(" ").concat(since).concat(" ").concat(this.sinceTxt.getText()).concat(" ").concat(index).concat(" ").concat(this.indexTxt.getText()).concat(" ").concat(where).concat(" ").concat(this.whereTxt.getText()).concat(" ").concat(crlf).concat(" ").concat(sid).concat(" ").concat(components);
            BuildTrace.println("enter program: " + this.cmd);
            this.scrollText.append("Starting " + exportCmd + ".....");
            this.scrollText.append("\r\n");
            this.scrollText.append(this.cmd);
            this.scrollText.append("\r\n");
            this.scrollText.append("\r\n");
            this.rc = this.execPgm(this.cmd);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (this.releaseTxt.getDocument() == documentEvent.getDocument()) {
            this.releaseTxtInsert();
        } else if (this.relspecTxt.getDocument() == documentEvent.getDocument()) {
            this.relspecTxtInsert();
        } else if (this.partspecTxt.getDocument() == documentEvent.getDocument()) {
            this.partspecTxtInsert();
        } else if (this.whereTxt.getDocument() == documentEvent.getDocument()) {
            this.whereTxtInsert();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        BuildTrace.println("removeUpdate called for releaseTxt");
        Document document = documentEvent.getDocument();
        if (this.releaseTxt.getDocument() == documentEvent.getDocument()) {
            this.releaseTxtRemove();
        } else if (this.relspecTxt.getDocument() == documentEvent.getDocument()) {
            this.relspecTxtRemove();
        } else if (this.partspecTxt.getDocument() == documentEvent.getDocument()) {
            this.partspecTxtRemove();
        } else if (this.whereTxt.getDocument() == documentEvent.getDocument()) {
            this.whereTxtRemove();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        BuildTrace.println("not used by text fields");
    }

    public void releaseTxtInsert() {
        BuildTrace.println("insertUpdate called for releaseTxt");
        this.relspecTxt.setBackground(new Color(220, 220, 220));
        if (this.relspecTxt.isEditable()) {
            this.relspecTxt.setText("");
            this.relspecTxt.setEditable(false);
            this.relspecLab.setForeground(new Color(120, 120, 120));
        }
        this.whereTxt.setBackground(new Color(220, 220, 220));
        if (this.whereTxt.isEditable()) {
            this.whereTxt.setText("");
            this.whereTxt.setEditable(false);
            this.whereLab.setForeground(new Color(120, 120, 120));
        }
    }

    public void relspecTxtInsert() {
        BuildTrace.println("insertUpdate called for relspecTxt");
        this.releaseTxt.setBackground(new Color(220, 220, 220));
        if (this.releaseTxt.isEditable()) {
            this.releaseTxt.setText("");
            this.releaseTxt.setEditable(false);
            this.releaseLab.setForeground(new Color(120, 120, 120));
        }
        this.whereTxt.setBackground(new Color(220, 220, 220));
        if (this.whereTxt.isEditable()) {
            this.whereTxt.setText("");
            this.whereTxt.setEditable(false);
            this.whereLab.setForeground(new Color(120, 120, 120));
        }
    }

    public void partspecTxtInsert() {
        BuildTrace.println("insertUpdate called for partspecTxt");
        this.whereTxt.setBackground(new Color(220, 220, 220));
        if (this.whereTxt.isEditable()) {
            this.whereTxt.setText("");
            this.whereTxt.setEditable(false);
            this.whereLab.setForeground(new Color(120, 120, 120));
        }
    }

    public void whereTxtInsert() {
        BuildTrace.println("insertUpdate called for whereTxt");
        this.releaseTxt.setBackground(new Color(220, 220, 220));
        if (this.releaseTxt.isEditable()) {
            this.releaseTxt.setText("");
            this.releaseTxt.setEditable(false);
            this.releaseLab.setForeground(new Color(120, 120, 120));
        }
        this.relspecTxt.setBackground(new Color(220, 220, 220));
        if (this.relspecTxt.isEditable()) {
            this.relspecTxt.setText("");
            this.relspecTxt.setEditable(false);
            this.relspecLab.setForeground(new Color(120, 120, 120));
        }
        this.partspecTxt.setBackground(new Color(220, 220, 220));
        if (this.partspecTxt.isEditable()) {
            this.partspecTxt.setText("");
            this.partspecTxt.setEditable(false);
            this.partspecLab.setForeground(new Color(120, 120, 120));
        }
    }

    public void releaseTxtRemove() {
        BuildTrace.println("Release Length: " + this.releaseTxt.getDocument().getLength());
        if (this.releaseTxt.getDocument().getLength() == 0) {
            this.relspecTxt.setBackground(this.releaseTxt.getBackground());
            if (!this.relspecTxt.isEditable()) {
                this.relspecTxt.setEditable(true);
                this.relspecLab.setForeground(Color.black);
            }
            if (this.relspecTxt.getDocument().getLength() == 0 && this.partspecTxt.getDocument().getLength() == 0) {
                this.whereTxt.setBackground(this.releaseTxt.getBackground());
                if (!this.whereTxt.isEditable()) {
                    this.whereTxt.setEditable(true);
                    this.whereLab.setForeground(Color.black);
                }
            }
        }
    }

    public void relspecTxtRemove() {
        BuildTrace.println("Relspec Length: " + this.relspecTxt.getDocument().getLength());
        if (this.relspecTxt.getDocument().getLength() == 0) {
            this.releaseTxt.setBackground(this.relspecTxt.getBackground());
            if (!this.releaseTxt.isEditable()) {
                this.releaseTxt.setEditable(true);
                this.releaseLab.setForeground(Color.black);
            }
            if (this.releaseTxt.getDocument().getLength() == 0 && this.partspecTxt.getDocument().getLength() == 0) {
                this.whereTxt.setBackground(this.relspecTxt.getBackground());
                if (!this.whereTxt.isEditable()) {
                    this.whereTxt.setEditable(true);
                    this.whereLab.setForeground(Color.black);
                }
            }
        }
    }

    public void partspecTxtRemove() {
        BuildTrace.println("Partspec Length: " + this.partspecTxt.getDocument().getLength());
        if (this.partspecTxt.getDocument().getLength() == 0 && this.releaseTxt.getDocument().getLength() == 0 && this.relspecTxt.getDocument().getLength() == 0) {
            this.whereTxt.setBackground(this.partspecTxt.getBackground());
            if (!this.whereTxt.isEditable()) {
                this.whereTxt.setEditable(true);
                this.whereLab.setForeground(Color.black);
            }
        }
    }

    public void whereTxtRemove() {
        BuildTrace.println("Where Length: " + this.whereTxt.getDocument().getLength());
        if (this.whereTxt.getDocument().getLength() == 0) {
            this.releaseTxt.setBackground(this.whereTxt.getBackground());
            if (!this.releaseTxt.isEditable()) {
                this.releaseTxt.setEditable(true);
                this.releaseLab.setForeground(Color.black);
            }
            this.relspecTxt.setBackground(this.whereTxt.getBackground());
            if (!this.relspecTxt.isEditable()) {
                this.relspecTxt.setEditable(true);
                this.relspecLab.setForeground(Color.black);
            }
            this.partspecTxt.setBackground(this.whereTxt.getBackground());
            if (!this.partspecTxt.isEditable()) {
                this.partspecTxt.setEditable(true);
                this.partspecLab.setForeground(Color.black);
            }
        }
    }

    public int execPgm(String string) {
        int n = 0;
        ProcessMonitor processMonitor = null;
        try {
            if (string.length() > 0) {
                processMonitor = new ProcessMonitor(string);
            } else {
                n = -1;
            }
        }
        catch (Throwable throwable) {
            processMonitor = null;
            n = -1;
        }
        BuildTrace.println("ProcessMonitor created.  Adding Listener.");
        processMonitor.addIoListener(this);
        BuildTrace.println("Listener added.  Waiting for program to complete.");
        BuildTrace.println("Program completed.");
        BuildTrace.println("Exiting: BuildCommand.execPgm(String)");
        return n;
    }

    public void ioPerformed(IOEvent iOEvent) {
        String string;
        iOEvent.getID();
        if (iOEvent.getID() == 1) {
            string = iOEvent.getOutput();
            this.scrollText.append(string);
            this.scrollText.append("\r\n");
        }
        if (iOEvent.getID() == 2) {
            string = iOEvent.getOutput();
            this.scrollText.append(string);
            this.scrollText.append("\r\n");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.crlfCheckBox) {
            crlf = itemEvent.getStateChange() == 2 ? "" : "-crlf";
            BuildTrace.println("crlf = " + crlf);
        } else if (itemSelectable == this.sidCheckBox) {
            sid = itemEvent.getStateChange() == 2 ? "" : "-sidlabels";
            BuildTrace.println("sid = " + sid);
        } else if (itemSelectable == this.componentCheckBox) {
            components = itemEvent.getStateChange() == 2 ? "" : "-componentlabels";
            BuildTrace.println("components = " + components);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        this.mShown = true;
    }
}

