/*
 * Decompiled with CFR 0.152.
 */
package clearExportGui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class BuildTrace {
    private static PrintWriter writer = new PrintWriter(System.out);
    private static boolean trace_active = false;
    private static int trace_size = 0;
    private static boolean new_line = true;
    private static File traceFile = null;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);

    public static void setTraceFile(File file) {
        traceFile = file;
    }

    public static void setTraceFile(String string) {
        BuildTrace.setTraceFile(new File(string));
    }

    public static void println(String string) {
        BuildTrace.printit(string);
        BuildTrace.printit("\n");
        new_line = true;
    }

    public static void print(String string) {
        BuildTrace.printit(string);
        if (string.indexOf("\n") > 0) {
            new_line = true;
        }
    }

    private static void printit(Object object) {
        if (trace_active) {
            if (new_line) {
                writer.print(String.valueOf(df.format(new Date())) + ": ");
                new_line = false;
            }
            writer.print(object);
            writer.flush();
        }
    }

    public static void println(Object object) {
        BuildTrace.print(object);
        BuildTrace.printit("\n");
        new_line = true;
    }

    public static void print(Object object) {
        BuildTrace.printit(object);
    }

    public static void setTraceOn() {
        try {
            if (traceFile == null) {
                String string = System.getProperty("server.root");
                String string2 = System.getProperty("file.separator");
                String string3 = String.valueOf(string) + string2 + "trace.out";
                BuildTrace.setTraceFile(string3);
            }
            writer = new PrintWriter(new FileWriter(traceFile.getAbsolutePath(), true));
            trace_active = true;
        }
        catch (IOException iOException) {}
    }

    public static void setTraceOff() {
        if (writer != null) {
            writer.close();
            writer = null;
        }
        trace_active = false;
    }

    public static void setTraceSize(int n) {
        trace_size = n;
    }

    public static int getTraceSize() {
        return trace_size;
    }

    public static boolean isTraceActive() {
        return trace_active;
    }
}

