/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import com.ibm.vatc.tcadmin.DaemonInfo;
import com.ibm.vatc.tcadmin.ErrorDialog;
import com.ibm.vatc.tcadmin.IOEvent;
import com.ibm.vatc.tcadmin.IOListener;
import com.ibm.vatc.tcadmin.ProcessMonitor;
import com.ibm.vatc.tcadmin.SpinButton;
import com.ibm.vatc.tcadmin.ZeroSizePanel;
import com.ibm.vatc.tcadmin.tcDefaultTableModel;
import com.ibm.vatc.tcadmin.tcadmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class FamMon
extends ZeroSizePanel
implements ActionListener,
IOListener {
    private boolean ongoing = false;
    private int numDaemons;
    private int activeDaemons;
    private int numHits;
    private String famName;
    private JPanel topPanel;
    private JPanel buttonPanel;
    private JButton recycleButton;
    private String hitsLabel;
    private JLabel hitsTitle;
    private JLabel delayTitle;
    private JLabel delayTime;
    private SpinButton delay;
    private JTable myContainer;
    private JScrollPane containerInfo;
    private tcDefaultTableModel containerModel;
    private Frame errFrame;
    private ProcessMonitor monitor;
    private TitledBorder border;
    private int selected = -1;
    private final int numColumns = 5;

    public FamMon(Frame frame) {
        this.border = new TitledBorder("");
        this.border.setTitleFont(tcadmin.getDefaultFont());
        this.setBorder(this.border);
        this.errFrame = frame;
        this.initLayout();
        this.setFont(tcadmin.getDefaultFont());
    }

    public FamMon(String string, Frame frame) {
        this.border = new TitledBorder(string);
        this.border.setTitleFont(tcadmin.getDefaultFont());
        this.setBorder(this.border);
        this.errFrame = frame;
        this.setName(string);
        this.initLayout();
        this.setFont(tcadmin.getDefaultFont());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.recycleButton) {
            this.selected = this.myContainer.getSelectedRow();
            if (this.selected >= 0) {
                DaemonInfo.killDaemon(Integer.parseInt((String)this.containerModel.getValueAt(this.selected, 1)));
            }
        }
    }

    public void ioPerformed(IOEvent iOEvent) {
        String string;
        if (iOEvent.getSource() == this.monitor && iOEvent.getID() != -1 && (string = iOEvent.getOutput()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            String string2 = stringTokenizer.nextToken();
            if (stringTokenizer.countTokens() > 0 || string2.charAt(0) == '.') {
                if (string2.equals("*")) {
                    String string3 = stringTokenizer.nextToken();
                    this.numHits = Integer.parseInt(string3);
                    this.hitsTitle.setText(this.hitsLabel.concat(string3));
                    this.activeDaemons = Integer.parseInt(stringTokenizer.nextToken());
                    this.numDaemons = Integer.parseInt(stringTokenizer.nextToken());
                    this.selected = this.myContainer.getSelectedRow();
                    int n = this.containerModel.getRowCount();
                    while (n > 0) {
                        this.containerModel.removeRow(n - 1);
                        --n;
                    }
                    return;
                }
                if (string2.charAt(0) == '.') {
                    if (this.selected >= 0) {
                        this.myContainer.setRowSelectionInterval(this.selected, this.selected);
                    }
                    this.myContainer.repaint();
                    try {
                        Thread.sleep(this.delay.getValue() * 1000);
                        return;
                    }
                    catch (Throwable throwable) {
                        ErrorDialog errorDialog = ErrorDialog.getErrorDialog(this.errFrame, (String)tcadmin.locResource.handleGetObject("STR_WARN"), (String)tcadmin.locResource.handleGetObject("STR_WARN_INTERRUPTED_SLEEP"));
                        ((Component)errorDialog).setVisible(true);
                        return;
                    }
                }
                if (string2.trim().length() != 0) {
                    try {
                        int n = 1;
                        if (string2.charAt(0) != '-') {
                            int n2 = Integer.parseInt(string2);
                        }
                        Vector<String> vector = new Vector<String>(5);
                        vector.addElement(string2);
                        n = 1;
                        while (n < 5) {
                            String string4 = stringTokenizer.nextToken().trim();
                            vector.addElement(string4);
                            ++n;
                        }
                        this.containerModel.addRow(vector);
                        return;
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception occurred in ioPerformed() of FamMon " + throwable);
                        throwable.printStackTrace();
                        return;
                    }
                }
            } else {
                if (tcadmin.errLog != null) {
                    tcadmin.errLog.println(string);
                    return;
                }
                System.err.println(string);
            }
        }
    }

    public void go() {
        if (!this.ongoing) {
            this.ongoing = true;
            this.delay.setEnabled(false);
            StringBuffer stringBuffer = new StringBuffer("monitor -raw ");
            stringBuffer.append(Integer.toString(this.delay.getValue()));
            int n = ((Hashtable)tcadmin.environment).size();
            int n2 = 0;
            String string = null;
            String string2 = null;
            if (tcadmin.environment.getProperty("TC_FAMILY") == null) {
                ++n;
            }
            String[] stringArray = new String[n];
            Enumeration<?> enumeration = tcadmin.environment.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.compareTo("TC_FAMILY") == 0) continue;
                string2 = tcadmin.environment.getProperty(string);
                stringArray[n2] = new String(string).concat("=").concat(string2);
                ++n2;
            }
            stringArray[n2] = new String("TC_FAMILY=").concat(this.famName);
            ++n2;
            try {
                Thread.sleep(5000L);
            }
            catch (Throwable throwable) {
                ErrorDialog errorDialog = ErrorDialog.getErrorDialog(this.errFrame, (String)tcadmin.locResource.handleGetObject("STR_WARN"), (String)tcadmin.locResource.handleGetObject("STR_WARN_INTERRUPTED_SLEEP"));
                ((Component)errorDialog).setVisible(true);
            }
            this.monitor = new ProcessMonitor(stringBuffer.toString(), stringArray);
            this.monitor.addIoListener(this);
        }
    }

    public void stop() {
        if (this.monitor != null) {
            this.monitor.destroy();
        }
        this.ongoing = false;
        int n = this.containerModel.getRowCount();
        while (n > 0) {
            this.containerModel.removeRow(n - 1);
            --n;
        }
        this.delay.setEnabled(true);
        this.monitor = null;
    }

    public void setTitle(String string) {
        this.border.setTitle(string);
    }

    public void setName(String string) {
        this.famName = string;
    }

    public int getRefresh() {
        return this.delay.getValue();
    }

    public void setRefresh(int n) {
        this.delay.setValue(n);
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new GridLayout());
        this.topPanel.setFont(tcadmin.getDefaultFont());
        this.buttonPanel = new JPanel(new FlowLayout(0));
        this.buttonPanel.setFont(tcadmin.getDefaultFont());
        this.delay = new SpinButton(1, 0, Integer.MAX_VALUE);
        this.delay.setVisible(true);
        this.delay.setValue(5);
        this.delay.setFont(tcadmin.getDefaultFont());
        this.delayTitle = new JLabel((String)tcadmin.locResource.handleGetObject("STR_REFRESH_TITLE"));
        this.delayTitle.setFont(tcadmin.getDefaultFont());
        this.delayTime = new JLabel((String)tcadmin.locResource.handleGetObject("STR_REFRESH_TIME"), 4);
        this.delayTime.setFont(tcadmin.getDefaultFont());
        this.hitsLabel = (String)tcadmin.locResource.handleGetObject("STR_HITS_TITLE");
        this.hitsTitle = new JLabel(this.hitsLabel);
        this.hitsTitle.setFont(tcadmin.getDefaultFont());
        this.recycleButton = new JButton((String)tcadmin.locResource.handleGetObject("STR_BTN_RECYCLE"));
        this.recycleButton.setFont(tcadmin.getDefaultFont());
        this.recycleButton.addActionListener(this);
        this.containerModel = new tcDefaultTableModel();
        this.myContainer = new JTable(this.containerModel);
        this.myContainer.setShowHorizontalLines(false);
        this.myContainer.setCellSelectionEnabled(false);
        this.myContainer.setRowSelectionAllowed(true);
        this.myContainer.setColumnSelectionAllowed(false);
        this.myContainer.setSelectionMode(0);
        this.containerModel.addColumn((String)tcadmin.locResource.handleGetObject("STR_INDEX"));
        this.containerModel.addColumn((String)tcadmin.locResource.handleGetObject("STR_PID"));
        this.containerModel.addColumn((String)tcadmin.locResource.handleGetObject("STR_HITS"));
        this.containerModel.addColumn((String)tcadmin.locResource.handleGetObject("STR_PHASE"));
        this.containerModel.addColumn((String)tcadmin.locResource.handleGetObject("STR_STATUS_LINE"));
        this.containerInfo = JTable.createScrollPaneForTable(this.myContainer);
        this.myContainer.setFont(tcadmin.getDefaultFont());
        this.myContainer.getTableHeader().setFont(tcadmin.getDefaultFont());
        this.topPanel.add(this.hitsTitle);
        this.topPanel.add(this.delayTitle);
        this.topPanel.add(this.delay);
        this.topPanel.add(this.delayTime);
        this.buttonPanel.add(this.recycleButton);
        this.add("North", this.topPanel);
        this.add("South", this.buttonPanel);
        this.add("Center", this.containerInfo);
    }
}

