/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2 = menuElementArray2.length - 1;
            while (n2 >= 0) {
                if (menuElementArray2[n2].getComponent() == container) break;
                --n2;
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        boolean bl;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n2);
                string2 = String.valueOf(string2) + "+";
            }
            string2 = String.valueOf(string2) + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getToolkit().getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getToolkit().getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n, n);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(BasicMenuItemUI.iconRect.x, BasicMenuItemUI.iconRect.y, BasicMenuItemUI.iconRect.width, BasicMenuItemUI.iconRect.height, r);
        boolean bl2 = bl = string2 == null || string2.equals("");
        if (!bl) {
            BasicMenuItemUI.r.width += BasicMenuItemUI.acceleratorRect.width;
            BasicMenuItemUI.r.width += 7 * n;
        }
        BasicMenuItemUI.r.width += BasicMenuItemUI.checkIconRect.width;
        BasicMenuItemUI.r.width += 2 * n;
        BasicMenuItemUI.r.width += 2 * n;
        BasicMenuItemUI.r.width += BasicMenuItemUI.arrowIconRect.width;
        Insets insets = jMenuItem.getInsets();
        if (insets != null) {
            BasicMenuItemUI.r.width += insets.left + insets.right;
            BasicMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (BasicMenuItemUI.r.width % 2 == 0) {
            ++BasicMenuItemUI.r.width;
        }
        if (BasicMenuItemUI.r.height % 2 == 0) {
            ++BasicMenuItemUI.r.height;
        }
        return r.getSize();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(String.valueOf(string) + ".margin"));
        }
        this.defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, String.valueOf(string) + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(String.valueOf(string) + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, String.valueOf(string) + ".background", String.valueOf(string) + ".foreground", String.valueOf(string) + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(String.valueOf(string) + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(String.valueOf(string) + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(String.valueOf(string) + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(String.valueOf(string) + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(String.valueOf(string) + ".acceleratorSelectionForeground");
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(String.valueOf(string) + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(String.valueOf(string) + ".checkIcon");
        }
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
    }

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        boolean bl;
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        boolean bl2 = bl = string2 == null || string2.equals("");
        if (bl) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (icon2 != null) {
            rectangle5.width = icon2.getIconWidth();
            rectangle5.height = icon2.getIconHeight();
        } else {
            rectangle5.height = 0;
            rectangle5.width = 0;
        }
        if (icon3 != null) {
            rectangle6.width = icon3.getIconWidth();
            rectangle6.height = icon3.getIconHeight();
        } else {
            rectangle6.height = 0;
            rectangle6.width = 0;
        }
        rectangle3.x += rectangle5.width + n6;
        rectangle2.x += rectangle5.width + n6;
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        rectangle4.x += rectangle.width - rectangle6.width - n6 - rectangle4.width;
        rectangle4.y = rectangle.y + rectangle.height / 2 - rectangle4.height / 2;
        rectangle6.x += rectangle.width - rectangle6.width;
        rectangle6.y = rectangle.y + rectangle7.height / 2 - rectangle6.height / 2;
        rectangle5.y = rectangle.y + rectangle7.height / 2 - rectangle5.height / 2;
        rectangle5.x += rectangle.x;
        return string;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n2 = jMenuItem.getWidth();
        int n3 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n2, n3);
        BasicMenuItemUI.viewRect.x += insets.left;
        BasicMenuItemUI.viewRect.y += insets.top;
        BasicMenuItemUI.viewRect.width -= insets.right + BasicMenuItemUI.viewRect.x;
        BasicMenuItemUI.viewRect.height -= insets.bottom + BasicMenuItemUI.viewRect.y;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        Color color3 = graphics.getColor();
        if (jComponent.isOpaque()) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n2, n3);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n2, n3);
            }
            graphics.setColor(color3);
        }
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n4 = keyStroke.getModifiers();
            if (n4 > 0) {
                string = KeyEvent.getKeyModifiersText(n4);
                string = String.valueOf(string) + "+";
            }
            string = String.valueOf(string) + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n);
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(jMenuItem.getForeground());
            }
            icon.paintIcon(jComponent, graphics, BasicMenuItemUI.checkIconRect.x, BasicMenuItemUI.checkIconRect.y);
            graphics.setColor(color3);
        }
        if (jMenuItem.getIcon() != null) {
            Icon icon3;
            if (!buttonModel.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
                if (icon3 == null) {
                    icon3 = jMenuItem.getIcon();
                }
            } else {
                icon3 = jMenuItem.getIcon();
            }
            if (icon3 != null) {
                icon3.paintIcon(jComponent, graphics, BasicMenuItemUI.iconRect.x, BasicMenuItemUI.iconRect.y);
            }
        }
        if (string2 != null && !string2.equals("")) {
            if (!buttonModel.isEnabled()) {
                if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                    graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), BasicMenuItemUI.textRect.x, BasicMenuItemUI.textRect.y + fontMetrics.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), BasicMenuItemUI.textRect.x, BasicMenuItemUI.textRect.y + fontMetrics.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), BasicMenuItemUI.textRect.x - 1, BasicMenuItemUI.textRect.y + fontMetrics.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(color2);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                }
                BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), BasicMenuItemUI.textRect.x, BasicMenuItemUI.textRect.y + fontMetrics.getAscent());
            }
        }
        if (string != null && !string.equals("")) {
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(graphics, string, 0, BasicMenuItemUI.acceleratorRect.x, BasicMenuItemUI.acceleratorRect.y + fontMetrics.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string, 0, BasicMenuItemUI.acceleratorRect.x, BasicMenuItemUI.acceleratorRect.y + fontMetrics.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string, 0, BasicMenuItemUI.acceleratorRect.x - 1, BasicMenuItemUI.acceleratorRect.y + fontMetrics.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(graphics, string, 0, BasicMenuItemUI.acceleratorRect.x, BasicMenuItemUI.acceleratorRect.y + fontMetrics.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (!(jMenuItem.getParent() instanceof JMenuBar)) {
                icon2.paintIcon(jComponent, graphics, BasicMenuItemUI.arrowIconRect.x, BasicMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = 0;
        int n2 = menuElementArray.length;
        while (n < n2) {
            int n3 = 0;
            while (n3 <= n) {
                System.out.print("  ");
                ++n3;
            }
            MenuElement menuElement = menuElementArray[n];
            if (menuElement instanceof JMenuItem) {
                System.out.println(String.valueOf(((JMenuItem)menuElement).getText()) + ", ");
            } else if (menuElement == null) {
                System.out.println("NULL , ");
            } else {
                System.out.println(menuElement + ", ");
            }
            ++n;
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuItem = null;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(BasicMenuItemUI.this.getPath());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 1) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                int n = 0;
                int n2 = menuElementArray.length - 1;
                while (n < n2) {
                    menuElementArray2[n] = menuElementArray[n];
                    ++n;
                }
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                menuSelectionManager.clearSelectedPath();
                BasicMenuItemUI.this.menuItem.doClick(0);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                menuSelectionManager.clearSelectedPath();
                BasicMenuItemUI.this.menuItem.doClick(0);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        MenuKeyHandler() {
        }

        private int lower(int n) {
            if (n >= 65 && n <= 90) {
                return n + 97 - 65;
            }
            return n;
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            int n = BasicMenuItemUI.this.menuItem.getMnemonic();
            if (n == 0) {
                return;
            }
            if (this.lower(n) == this.lower(menuKeyEvent.getKeyChar())) {
                MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                menuSelectionManager.clearSelectedPath();
                BasicMenuItemUI.this.menuItem.doClick(0);
                menuKeyEvent.consume();
            }
        }
    }
}

