CREATE TABLE fdcFVTPerson_versn   -- fdcFVTPerson_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     name                      VarChar(254)   ,
     Initial                   Int   ,
     sex                       Int   ,
     bDate                     VarChar(254)   ,
     pSSN                      DBOID   ,
     pOffice                   DBOID   ,
     pMarried_to               DBOID   ,
     pSpouse_of                DBOID   ,
     pHome                     DBOID   ,
     constraint v302KdFTrnvs Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE fdcFVTDog 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     name                      VarChar(254)   ,
     pOwner                    DBOID   ,
     pSSNRel                   DBOID   ,
     constraint v302PKfdcFVTDog Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVTDog AS --Plasma for fdcFVTDog
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVTDog a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVTCompany_vrsn   -- fdcFVTCompany_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     name                      VarChar(254)   ,
     num_employees             Int   ,
     Years_in_business         Int   ,
     constraint v30PfcVCpyvs Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE fdcFVTCar 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     make                      VarChar(254)   ,
     model                     VarChar(254)   ,
     year                      Int   ,
     photo                     Blob(1G) COMPACT    ,
     Milage                    Double   ,
     pPerson                   DBOID   ,
     os_pad                    Int   ,
     constraint v302PKfdcFVTCar Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVTCar AS --Plasma for fdcFVTCar
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVTCar a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVTHouse 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     address                   VarChar(254)   ,
     size                      Int   ,
     built                     Int   ,
     pPerson                   DBOID   ,
     constraint v302PKfdcFVTHouse Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVTHouse AS --Plasma for fdcFVTHouse
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVTHouse a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVTSSN 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     ssNum                     Int   ,
     pPerson                   DBOID   ,
     constraint v302PKfdcFVTSSN Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVTSSN AS --Plasma for fdcFVTSSN
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVTSSN a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVTOffice 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     oNumber                   Int   ,
     oType                     Int   ,
     pBuilding                 DBOID   ,
     constraint v302PKfdcFVTOffice Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVTOffice AS --Plasma for fdcFVTOffice
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVTOffice a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVTComputer 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     cSerial                   VarChar(254)   ,
     cModel                    VarChar(254)   ,
     cType                     VarChar(254)   ,
     cMake                     VarChar(254)   ,
     pOffice                   DBOID   ,
     constraint v302PKfdcFVTComptr Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVTComputer AS --Plasma for fdcFVTComputer
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVTComputer a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVTBuilding 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     bNumber                   Int   ,
     bAaddress                 VarChar(254)   ,
     rNumber                   Int   ,
     constraint v302PKfdcFVTBuldng Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVTBuilding AS --Plasma for fdcFVTBuilding
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVTBuilding a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVTAttrib 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     FVTString                 VarChar(254)   ,
     FVTBoolean                Int   ,
     FVTUshort                 Int   ,
     FVTLong                   Int   ,
     FVTUlong                  Int   ,
     FVTFloat                  Double   ,
     FVTDouble                 Double   ,
     FVTChar                   Int   ,
     FVTCharStar               VarChar(254)   ,
     FVTBulkData               Blob(1G) COMPACT    ,
     os_pad                    Int   ,
     constraint v302PKfdcFVTAttrib Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVTAttrib AS --Plasma for fdcFVTAttrib
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVTAttrib a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVT_person_SSN 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pDog                      DBOID   ,
     constraint v302KdFTps_S Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVT_prsn_SSN AS --Plasma for fdcFVT_person_SSN
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVT_person_SSN a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVT_person_car 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     Miles_driven              Double   ,
     constraint v30PfcV_rnc Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVT_persn_cr AS --Plasma for fdcFVT_person_car
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVT_person_car a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVT_person_prsn   -- fdcFVT_person_person
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     Anniversary_date          VarChar(254)   ,
     constraint v30PfcV_rnps Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fcV_rnps AS --Plasma for fdcFVT_person_person
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVT_person_prsn a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVT_tenant_home 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     Lease_term                Int   ,
     constraint v30PfcV_nth Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_fdcFVT_tennt_hm AS --Plasma for fdcFVT_tenant_home
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVT_tenant_home a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE fdcFVT_persn_cmpny   -- fdcFVT_person_company
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     Years_employed            Int   ,
     constraint v302KdFTps_mn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_dFTps_mn AS --Plasma for fdcFVT_person_company
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    fdcFVT_persn_cmpny a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE Team_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pCity                     DBOID   ,
     pStadium                  DBOID   ,
     constraint v302PKTeam_version Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE Stadium 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     name                      VarChar(254)   ,
     constraint v302PKStadium Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_Stadium AS --Plasma for Stadium
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    Stadium a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE Seat 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     number                    VarChar(254)   ,
     color                     VarChar(254)   ,
     pStadium                  DBOID   ,
     constraint v302PKSeat Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_Seat AS --Plasma for Seat
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    Seat a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

