/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    private static Dimension minSize = new Dimension(0, 0);
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    protected KeyStroke minimizeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke closeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopPaneUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return maxSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return minSize;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void installDefaults() {
        if (this.desktop.getBackground() == null || this.desktop.getBackground() instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("Desktop.background"));
        }
    }

    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new DefaultDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    protected void installKeyboardActions() {
        this.minimizeKey = KeyStroke.getKeyStroke(120, 2);
        this.maximizeKey = KeyStroke.getKeyStroke(121, 2);
        this.closeKey = KeyStroke.getKeyStroke(115, 2);
        this.navigateKey = KeyStroke.getKeyStroke(117, 2);
        this.navigateKey2 = KeyStroke.getKeyStroke(9, 2);
        this.registerKeyboardActions();
    }

    public void installUI(JComponent jComponent) {
        this.desktop = (JDesktopPane)jComponent;
        this.installDefaults();
        this.installDesktopManager();
        this.installKeyboardActions();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void registerKeyboardActions() {
        this.desktop.registerKeyboardAction(new MinimizeAction(), this.minimizeKey, 2);
        this.desktop.registerKeyboardAction(new MaximizeAction(), this.maximizeKey, 2);
        this.desktop.registerKeyboardAction(new CloseAction(), this.closeKey, 2);
        this.desktop.registerKeyboardAction(new NavigateAction(), this.navigateKey2, 2);
        this.desktop.registerKeyboardAction(new NavigateAction(), this.navigateKey, 2);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() == this.desktopManager) {
            this.desktop.setDesktopManager(null);
        }
        this.desktop = null;
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallDesktopManager();
    }

    protected void unregisterKeyboardActions() {
        this.navigateKey2 = null;
        this.navigateKey = null;
        this.closeKey = null;
        this.maximizeKey = null;
        this.minimizeKey = null;
        this.desktop.unregisterKeyboardAction(this.minimizeKey);
        this.desktop.unregisterKeyboardAction(this.maximizeKey);
        this.desktop.unregisterKeyboardAction(this.closeKey);
        this.desktop.unregisterKeyboardAction(this.navigateKey);
        this.desktop.unregisterKeyboardAction(this.navigateKey2);
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getAllFrames()[0];
                if (jInternalFrame == null || !jInternalFrame.isMaximizable()) break block2;
                try {
                    jInternalFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getAllFrames()[0];
                if (jInternalFrame == null || !jInternalFrame.isMaximizable()) break block2;
                try {
                    jInternalFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getAllFrames()[0];
                if (jInternalFrame == null || !jInternalFrame.isClosable()) break block2;
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame[] jInternalFrameArray = BasicDesktopPaneUI.this.desktop.getAllFrames();
            int n = jInternalFrameArray.length;
            if (n >= 1) {
                --n;
            }
            while (jInternalFrameArray[n].isIcon()) {
                if (--n == 0) break;
            }
            BasicDesktopPaneUI.this.desktopManager.activateFrame(jInternalFrameArray[n]);
            try {
                jInternalFrameArray[n].setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

