/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener {
    private Rectangle tmpRect = new Rectangle();
    private KeyStroke altPressedKeyStroke = null;
    private KeyStroke altReleasedKeyStroke = null;
    private KeyStroke nonAltReleasedKeyStroke = null;
    private static KeyStroke spacePressedKeyStroke = null;
    private static KeyStroke spaceReleasedKeyStroke = null;
    private static KeyStroke enterPressedKeyStroke = null;
    private static KeyStroke enterReleasedKeyStroke = null;

    public BasicButtonListener(AbstractButton abstractButton) {
        if (spacePressedKeyStroke == null) {
            spacePressedKeyStroke = KeyStroke.getKeyStroke(32, 0, false);
            spaceReleasedKeyStroke = KeyStroke.getKeyStroke(32, 0, true);
        }
        if (enterPressedKeyStroke == null) {
            enterPressedKeyStroke = KeyStroke.getKeyStroke(10, 0, false);
            enterReleasedKeyStroke = KeyStroke.getKeyStroke(10, 0, true);
        }
    }

    protected void checkOpacity(AbstractButton abstractButton) {
        abstractButton.setOpaque(abstractButton.isContentAreaFilled());
    }

    public void focusGained(FocusEvent focusEvent) {
        JRootPane jRootPane;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultCapable() && (jRootPane = abstractButton.getRootPane()) != null) {
            jRootPane.setDefaultButton((JButton)abstractButton);
        }
        abstractButton.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        abstractButton.repaint();
    }

    public void installKeyboardActions(JComponent jComponent) {
        int n;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        PressedAction pressedAction = new PressedAction(abstractButton);
        ReleasedAction releasedAction = new ReleasedAction(abstractButton);
        abstractButton.registerKeyboardAction(pressedAction, spacePressedKeyStroke, 0);
        abstractButton.registerKeyboardAction(releasedAction, spaceReleasedKeyStroke, 0);
        if (!(abstractButton instanceof JToggleButton)) {
            abstractButton.registerKeyboardAction(pressedAction, enterPressedKeyStroke, 0);
            abstractButton.registerKeyboardAction(releasedAction, enterReleasedKeyStroke, 0);
        }
        if ((n = abstractButton.getMnemonic()) != 0) {
            this.altPressedKeyStroke = KeyStroke.getKeyStroke(n, 8, false);
            this.altReleasedKeyStroke = KeyStroke.getKeyStroke(n, 8, true);
            this.nonAltReleasedKeyStroke = KeyStroke.getKeyStroke(n, 0, true);
            abstractButton.registerKeyboardAction(pressedAction, this.altPressedKeyStroke, 2);
            abstractButton.registerKeyboardAction(releasedAction, this.altReleasedKeyStroke, 2);
            abstractButton.registerKeyboardAction(releasedAction, this.nonAltReleasedKeyStroke, 2);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed()) {
            this.tmpRect.width = abstractButton.getWidth();
            this.tmpRect.height = abstractButton.getHeight();
            if (this.tmpRect.contains(mouseEvent.getPoint())) {
                buttonModel.setArmed(true);
            } else {
                buttonModel.setArmed(false);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        if (abstractButton.isRolloverEnabled()) {
            abstractButton.getModel().setRollover(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        if (abstractButton.isRolloverEnabled()) {
            abstractButton.getModel().setRollover(false);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            if (!abstractButton.hasFocus()) {
                abstractButton.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        buttonModel.setPressed(false);
        buttonModel.setArmed(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("mnemonic")) {
            this.uninstallKeyboardActions((AbstractButton)propertyChangeEvent.getSource());
            this.installKeyboardActions((AbstractButton)propertyChangeEvent.getSource());
        }
        if (string.equals("contentAreaFilled")) {
            this.checkOpacity((AbstractButton)propertyChangeEvent.getSource());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
        abstractButton.repaint();
    }

    public void uninstallKeyboardActions(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (spacePressedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(spacePressedKeyStroke);
        }
        if (spaceReleasedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(spaceReleasedKeyStroke);
        }
        if (enterPressedKeyStroke != null && !(abstractButton instanceof JToggleButton)) {
            abstractButton.unregisterKeyboardAction(enterPressedKeyStroke);
        }
        if (enterReleasedKeyStroke != null && !(abstractButton instanceof JToggleButton)) {
            abstractButton.unregisterKeyboardAction(enterReleasedKeyStroke);
        }
        if (this.altPressedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(this.altPressedKeyStroke);
            this.altPressedKeyStroke = null;
        }
        if (this.altReleasedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(this.altReleasedKeyStroke);
            this.altReleasedKeyStroke = null;
        }
        if (this.nonAltReleasedKeyStroke != null) {
            abstractButton.unregisterKeyboardAction(this.nonAltReleasedKeyStroke);
            this.nonAltReleasedKeyStroke = null;
        }
    }

    static class PressedAction
    extends AbstractAction {
        AbstractButton b = null;

        PressedAction(AbstractButton abstractButton) {
            super("pressedAction");
            this.b = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ButtonModel buttonModel = this.b.getModel();
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            if (!this.b.hasFocus()) {
                this.b.requestFocus();
            }
        }

        public boolean isEnabled() {
            return this.b.getModel().isEnabled();
        }
    }

    static class ReleasedAction
    extends AbstractAction {
        AbstractButton b = null;

        ReleasedAction(AbstractButton abstractButton) {
            super("releasedAction");
            this.b = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.b.getModel().setPressed(false);
        }

        public boolean isEnabled() {
            return this.b.getModel().isEnabled();
        }
    }
}

