/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    protected boolean enabled = true;
    private Hashtable keyTable = new Hashtable(5);
    protected SwingPropertyChangeSupport changeSupport;

    public AbstractAction() {
    }

    public AbstractAction(String string) {
        this.putValue("Name", string);
    }

    public AbstractAction(String string, Icon icon) {
        this(string);
        this.putValue("SmallIcon", icon);
    }

    public abstract void actionPerformed(ActionEvent var1);

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractAction abstractAction = (AbstractAction)super.clone();
        abstractAction.keyTable = (Hashtable)this.keyTable.clone();
        return abstractAction;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public Object getValue(String string) {
        return this.keyTable.get(string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void putValue(String string, Object object) {
        Object var3_3 = null;
        if (this.keyTable.containsKey(string)) {
            var3_3 = this.keyTable.get(string);
        }
        if (object != null) {
            this.keyTable.put(string, object);
        }
        this.firePropertyChange(string, var3_3, object);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        this.firePropertyChange("enabled", new Boolean(bl2), new Boolean(bl));
    }
}

