/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.reuse.awt.support;

import com.ibm.vatc.reuse.awt.Notebook;
import com.ibm.vatc.reuse.awt.support.NBRenderer;
import com.ibm.vatc.reuse.awt.support.Utilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;

public class NBOS2Look
extends NBRenderer {
    private static String Copyright = "\r\n\r\nLicensed Materials - Property of IBM.\r\n(C) Copyright IBM Corporation 1997\r\nAll Rights Reserved US Government Users Restricted Rights -\r\nUse, duplication or disclosure\r\nrestricted by GSA ADP Schedule Contract\r\nwith IBM Corp.\r\n\r\n";
    private int index;

    protected NBOS2Look(Notebook notebook) {
        super(notebook);
    }

    public static boolean isSideSupportedForTabs(int n) {
        return n == 2 || n == 3;
    }

    public Insets getInsets(FontMetrics fontMetrics) {
        int n = this.parent.getOrientation();
        this.insets = new Insets(n == 2 ? 4 : 22, n == 3 ? 4 : 22, 21, 21);
        switch (n) {
            case 2: {
                this.insets.right = this.getMaximumWidth(fontMetrics) + 20;
                break;
            }
            case 3: {
                this.insets.bottom = Utilities.lineHeight(fontMetrics, this.parent.getTabList(), this.parent) + 27;
                break;
            }
        }
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom + fontMetrics.getHeight(), this.insets.right);
    }

    public void paintTheLook(Graphics graphics, FontMetrics fontMetrics, Dimension dimension) {
        int n = this.parent.getOrientation();
        int n2 = n == 2 ? 8 : 2;
        int n3 = n == 2 ? 2 : 8;
        int n4 = dimension.width - this.insets.right;
        int n5 = dimension.height - this.insets.bottom;
        int n6 = fontMetrics.getHeight();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n2, n3, n4 - n2 + 1, n5 - n3 + 1);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n2, n3, n4, n3);
        graphics.drawLine(n4, n3, n4, n5);
        graphics.drawLine(n4, n5, n2, n5);
        graphics.drawLine(n2, n5, n2, n3);
        int n7 = 1;
        while (n7 < 7) {
            int n8 = n7 * 3;
            int n9 = (n7 - 1) * 3;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2 + n8 + 1, n5 + n9 + 1, n4 + n8 - 1, n5 + n9 + 1);
            graphics.drawLine(n4 + n9 + 1, n5 + n9 + 1, n4 + n9 + 1, n3 + n8 + 1);
            graphics.drawLine(n2 + n8 + 1, n5 + n9 + 2, n4 + n8 - 1, n5 + n9 + 2);
            graphics.drawLine(n4 + n9 + 2, n5 + n9 + 1, n4 + n9 + 2, n3 + n8 + 1);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(n2 + n8, n5 + n9, n2 + n8, n5 + n8);
            graphics.drawLine(n2 + n8, n5 + n8, n4 + n8, n5 + n8);
            graphics.drawLine(n4 + n8, n5 + n8, n4 + n8, n3 + n8);
            graphics.drawLine(n4 + n8, n3 + n8, n4 + n9, n3 + n8);
            ++n7;
        }
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n2 + 18, n5 + 19, n4 + 19, n5 + 19);
        graphics.drawLine(n4 + 19, n5 + 19, n4 + 19, n3 + 18);
        if (this.leftButtonEnabled) {
            this.drawLeftArrow(graphics, fontMetrics, new Point(n4 - n6 * 2, n5 - n6 * 2), 3);
        } else {
            this.drawDisabledArrowFrame(graphics, n4 - n6 * 2, n5 - n6, n6);
        }
        if (this.rightButtonEnabled) {
            this.drawRightArrow(graphics, fontMetrics, new Point(n4 - n6, n5 - n6 * 2), 4);
        } else {
            this.drawDisabledArrowFrame(graphics, n4 - n6, n5 - n6, n6);
        }
        if (this.statusText != null) {
            graphics.drawString(this.statusText, this.parent.getOrientation() == 2 ? 24 : 8, Utilities.baseLineFromBottom(fontMetrics, n5, n6));
        }
        if (this.pagingText != null) {
            graphics.drawString(this.pagingText, n4 - n6 * 2 - fontMetrics.stringWidth(String.valueOf(this.pagingText) + " "), Utilities.baseLineFromBottom(fontMetrics, n5, n6));
        }
        switch (n) {
            case 2: {
                this.drawVerticalSpiral(graphics, n3, n5);
                if (this.parent.getTabList() == null) break;
                this.drawTabs(graphics, fontMetrics, new Point(n4, n3 + 18));
                return;
            }
            case 3: {
                this.drawHorizontalSpiral(graphics, n2, n4);
                if (this.parent.getTabList() == null) break;
                this.drawTabs(graphics, fontMetrics, new Point(n2 + 18, n5));
                return;
            }
        }
    }

    protected void drawVerticalSpiral(Graphics graphics, int n, int n2) {
    }

    protected void drawHorizontalSpiral(Graphics graphics, int n, int n2) {
    }

    private void drawTabs(Graphics graphics, FontMetrics fontMetrics, Point point) {
        Object[] objectArray = this.parent.getTabList();
        int n = this.parent.getOrientation();
        Color[] colorArray = this.parent.getBackgroundColors();
        Color[] colorArray2 = this.parent.getForegroundColors();
        int n2 = Utilities.lineHeight(fontMetrics, objectArray, this.parent);
        Point point2 = new Point(point.x, point.y);
        int n3 = this.firstTab;
        int n4 = n == 2 ? this.parent.getSize().height - this.insets.bottom : this.parent.getSize().width - this.insets.right;
        boolean bl = false;
        if (this.firstTab > 0) {
            this.drawBackArrow(graphics, fontMetrics, n, point2);
        }
        int n5 = 0;
        while (n5 < objectArray.length && !bl) {
            switch (n) {
                case 2: {
                    this.drawEastTab(graphics, fontMetrics, objectArray[n3], colorArray[n3], colorArray2[n3], point2, n3, n2);
                    if (n3 >= objectArray.length - 1 || n2 + 2 + (n3 == objectArray.length - 2 ? 0 : fontMetrics.getHeight()) <= n4 - point2.y) break;
                    point2.y = this.parent.getSize().height - fontMetrics.getHeight() - 1;
                    this.drawFwdArrow(graphics, fontMetrics, n, point2);
                    bl = true;
                    break;
                }
                case 3: {
                    this.drawSouthTab(graphics, fontMetrics, objectArray[n3], colorArray[n3], colorArray2[n3], point2, n3, n2);
                    if (n3 >= objectArray.length - 1 || Utilities.itemWidth(fontMetrics, objectArray[n3 + 1], this.parent) + fontMetrics.stringWidth("  ") + 2 <= n4 - point2.x) break;
                    point2.x = this.parent.getSize().width - fontMetrics.getHeight() - 2;
                    this.drawFwdArrow(graphics, fontMetrics, n, point2);
                    bl = true;
                    break;
                }
            }
            ++n3;
            if (!bl) {
                bl = n3 > objectArray.length - 1;
            }
            ++n5;
        }
    }

    private void drawEastTab(Graphics graphics, FontMetrics fontMetrics, Object object, Color color, Color color2, Point point, int n, int n2) {
        int n3 = this.parent.getCurrentTab();
        int n4 = n < n3 ? 18 : (n - n3) * 3;
        int n5 = this.insets.right - 20;
        int n6 = n2 + 4;
        if (n4 > 18) {
            n4 = 18;
        }
        if (n4 > 0) {
            ++n4;
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(point.x + n4, point.y, n5, n6);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(point.x + n4, point.y, point.x + n4 + n5, point.y);
        graphics.drawLine(point.x + n4 + n5, point.y, point.x + n4 + n5, point.y + n6);
        graphics.drawLine(point.x + n4 + n5, point.y + n6, point.x + n4, point.y + n6);
        graphics.setColor(color);
        graphics.fillRect(point.x + n4 + 2, point.y + 2, n5 - 3, n6 - 3);
        graphics.setColor(color2);
        if (object instanceof Image) {
            graphics.drawImage((Image)object, point.x + n4 + 6, point.y + 4, this.parent);
        } else {
            graphics.drawString(object.toString(), point.x + n4 + 6, Utilities.baseLineFromTop(fontMetrics, point.y, n6));
        }
        this.parent.addHotSpot(point.x + n4, point.y, n5, n6, 0, new Integer(n));
        point.y += n6 + 2;
    }

    private void drawSouthTab(Graphics graphics, FontMetrics fontMetrics, Object object, Color color, Color color2, Point point, int n, int n2) {
        int n3 = this.parent.getCurrentTab();
        int n4 = n < n3 ? 18 : (n - n3) * 3;
        int n5 = Utilities.itemWidth(fontMetrics, object, this.parent) + fontMetrics.stringWidth("  ") + 2;
        int n6 = n2 + 4;
        int n7 = point.x + (n5 - Utilities.itemWidth(fontMetrics, object, this.parent)) / 2 + 1;
        if (n4 > 18) {
            n4 = 18;
        }
        if (n4 > 0) {
            ++n4;
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(point.x, point.y + n4, n5, n6);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(point.x, point.y + n4, point.x, point.y + n4 + n6);
        graphics.drawLine(point.x + n5, point.y + n4, point.x + n5, point.y + n4 + n6);
        graphics.drawLine(point.x + n5, point.y + n4 + n6, point.x, point.y + n4 + n6);
        graphics.setColor(color);
        graphics.fillRect(point.x + 2, point.y + n4 + 2, n5 - 3, n6 - 3);
        graphics.setColor(color2);
        if (object instanceof Image) {
            graphics.drawImage((Image)object, n7, point.y + n4 + 4, this.parent);
        } else {
            graphics.drawString(object.toString(), n7, Utilities.baseLineFromTop(fontMetrics, point.y + n4, n6));
        }
        this.parent.addHotSpot(point.x, point.y + n4, n5, n6, 0, new Integer(n));
        point.x += n5 + 2;
    }

    private void drawBackArrow(Graphics graphics, FontMetrics fontMetrics, int n, Point point) {
        Point point2 = new Point(point);
        if (n == 2) {
            point2.x += 4;
            ++point2.y;
            this.drawUpArrow(graphics, fontMetrics, point2);
            point.y += fontMetrics.getHeight() + 2;
            return;
        }
        point2.y += 4;
        ++point2.x;
        this.drawLeftArrow(graphics, fontMetrics, point2, 1);
        point.x += fontMetrics.getHeight() + 2;
    }

    private void drawUpArrow(Graphics graphics, FontMetrics fontMetrics, Point point) {
        int n = fontMetrics.getHeight();
        int n2 = point.x + n;
        int n3 = point.y;
        this.drawArrowFrame(graphics, n2, n3, n);
        this.drawVerticalArrow(graphics, n2, n3, n, 1);
        this.parent.addHotSpot(n2, n3, n, n, 1, null);
        point.y = n3 + n + 2;
    }

    private void drawLeftArrow(Graphics graphics, FontMetrics fontMetrics, Point point, int n) {
        int n2 = fontMetrics.getHeight();
        int n3 = point.x;
        int n4 = point.y + n2;
        this.drawArrowFrame(graphics, n3, n4, n2);
        this.drawHorizontalArrow(graphics, n3, n4, n2, 1);
        this.parent.addHotSpot(n3, n4, n2, n2, n, null);
        point.x = n3 + n2 + 2;
    }

    private void drawFwdArrow(Graphics graphics, FontMetrics fontMetrics, int n, Point point) {
        Point point2 = new Point(point);
        if (n == 2) {
            point2.x += 4;
            this.drawDownArrow(graphics, fontMetrics, point2);
            return;
        }
        point2.y += 4;
        this.drawRightArrow(graphics, fontMetrics, point2, 2);
    }

    private void drawRightArrow(Graphics graphics, FontMetrics fontMetrics, Point point, int n) {
        int n2 = fontMetrics.getHeight();
        int n3 = point.x;
        int n4 = point.y + n2;
        this.drawArrowFrame(graphics, n3, n4, n2);
        this.drawHorizontalArrow(graphics, n3 + n2, n4, n2, -1);
        this.parent.addHotSpot(n3, n4, n2, n2, n, null);
        point.x = n3 + n2 + 2;
    }

    private void drawDownArrow(Graphics graphics, FontMetrics fontMetrics, Point point) {
        int n = fontMetrics.getHeight();
        int n2 = point.x + n;
        int n3 = point.y;
        this.drawArrowFrame(graphics, n2, n3, n);
        this.drawVerticalArrow(graphics, n2, n3 + n - 1, n, -1);
        this.parent.addHotSpot(n2, n3, n, n, 2, null);
    }

    private void drawVerticalArrow(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        nArray[0] = n + n3 / 2;
        nArray2[0] = n2 + 4 * n4;
        nArray[1] = n + n3 - 4;
        nArray2[1] = n2 + n3 / 2 * n4;
        nArray[2] = nArray[0] + 2;
        nArray2[2] = nArray2[1];
        nArray[3] = nArray[2];
        nArray2[3] = n2 + (n3 - 4) * n4;
        nArray[4] = nArray[0] - 2;
        nArray2[4] = nArray2[3];
        nArray[5] = nArray[4];
        nArray2[5] = nArray2[2];
        nArray[6] = n + 3;
        nArray2[6] = nArray2[1];
        graphics.setColor(Color.black);
        graphics.fillPolygon(nArray, nArray2, 7);
    }

    private void drawHorizontalArrow(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        nArray[0] = n + 4 * n4;
        nArray2[0] = n2 + n3 / 2;
        nArray[1] = n + n3 / 2 * n4;
        nArray2[1] = n2 + n3 - 4;
        nArray[2] = nArray[1];
        nArray2[2] = nArray2[0] + 2;
        nArray[3] = n + (n3 - 4) * n4;
        nArray2[3] = nArray2[2];
        nArray[4] = nArray[3];
        nArray2[4] = nArray2[0] - 2;
        nArray[5] = nArray[2];
        nArray2[5] = nArray2[4];
        nArray[6] = nArray[1];
        nArray2[6] = n2 + 3;
        graphics.setColor(Color.black);
        graphics.fillPolygon(nArray, nArray2, 7);
    }
}

