/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sdwb.common.toolcount;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class ToolCount {
    private static final String COPYRIGHT__ = "Tool:toolcount, IBM Confidential, (C) Copyright IBM Corp (This work is unpublished.) All rights reserved.";
    public static final int TC_OS_UNKNOWN = 0;
    public static final int TC_OS_AIX = 1;
    public static final int TC_OS_OS2 = 2;
    public static final int TC_OS_WIN95 = 3;
    public static final int TC_OS_WINNT = 4;
    public static final int TC_OS_WIN = 5;
    public static final int TC_OS_LINUX = 6;
    public static final int TC_OS_OS400 = 7;
    public static final int TC_OS_VM = 8;
    public static final int TC_OS_MVS = 9;
    public static final int TC_MAX_TOOLSET_LEN = 32;
    public static final int TC_MAX_TOOL_LEN = 32;
    public static final int TC_MAX_USER_LEN = 64;
    public static final short TC_DEFAULT_PORT = 16617;
    private static DatagramPacket override_saddr;
    private static DatagramPacket saddr_ptr;
    private static String saddr_toolset;
    private static boolean inited;

    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            ToolCount.toolcount(stringArray[0], stringArray[1]);
        }
    }

    public static void toolcount(String string, String string2) {
        ToolCount.toolcount(string, string2, null, null, 0, 1);
    }

    public static int getOSType() {
        String string = System.getProperty("os.name");
        if (string.equals("AIX")) {
            return 1;
        }
        if (string.equals("OS/2")) {
            return 2;
        }
        if (string.equals("Windows NT")) {
            return 4;
        }
        if (string.equals("OS/400")) {
            return 7;
        }
        return 0;
    }

    public static void setlocation(String string) {
        if (string == null) {
            override_saddr = null;
            return;
        }
        override_saddr = ToolCount.locationAddress(string);
    }

    static void toolcount(String string, String string2, String string3, String string4, int n, int n2) {
        DatagramPacket datagramPacket;
        String string5;
        int n3 = 0;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[128];
        byArray[0] = 2;
        n3 = 1;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string6 = inetAddress.getHostName();
            string5 = string6.substring(string6.indexOf(".") + 1);
            if (string5.indexOf("ibm.com") == -1) {
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            string5 = null;
        }
        if (string == null) {
            return;
        }
        byArray2 = string.getBytes();
        int n4 = 0;
        while (n4 < byArray2.length) {
            byArray[n4 + n3] = byArray2[n4];
            ++n4;
        }
        int n5 = string.length();
        if (n5 > 32) {
            n5 = 32;
        }
        n3 += n5;
        byArray[n3++] = 0;
        if (string2 == null) {
            return;
        }
        byArray2 = string2.getBytes();
        int n6 = 0;
        while (n6 < byArray2.length) {
            byArray[n6 + n3] = byArray2[n6];
            ++n6;
        }
        n5 = string2.length();
        if (n5 > 32) {
            n5 = 32;
        }
        n3 += n5;
        byArray[n3++] = 0;
        if (string3 == null) {
            string3 = System.getProperty("user.name");
        }
        string3 = String.valueOf(string3) + "@" + string5;
        string4 = System.getProperty("userIdentity");
        if (string4 != null) {
            string3 = String.valueOf(string3) + "/" + string4;
        }
        byArray2 = string3.getBytes();
        int n7 = 0;
        while (n7 < byArray2.length) {
            byArray[n7 + n3] = byArray2[n7];
            ++n7;
        }
        n5 = string3.length();
        if (n5 > 64) {
            n5 = 64;
        }
        n3 += n5;
        byArray[n3++] = 0;
        if (n == 0) {
            n = ToolCount.getOSType();
        }
        byArray[n3++] = (byte)(n + 48);
        byArray[n3++] = 0;
        if (n2 == 0) {
            n2 = 1;
        }
        String string7 = new Integer(n2).toString();
        byArray2 = string7.getBytes();
        int n8 = 0;
        while (n8 < byArray2.length) {
            byArray[n8 + n3] = byArray2[n8];
            ++n8;
        }
        n5 = string7.length();
        n3 = n3 + n5 + 1;
        if (override_saddr != null) {
            datagramPacket = override_saddr;
        } else {
            datagramPacket = ToolCount.getTCaddr(string);
            if (datagramPacket == null) {
                return;
            }
        }
        datagramPacket.setData(byArray);
        datagramPacket.setLength(n3);
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.send(datagramPacket);
            datagramSocket.close();
            return;
        }
        catch (SocketException socketException) {
            System.out.println("SocketException: " + socketException);
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
            return;
        }
    }

    private static DatagramPacket getTCaddr(String string) {
        String string2 = string.substring(0, string.length() < 32 ? string.length() : 32);
        if (!inited || !string2.equals(saddr_toolset)) {
            inited = true;
            String string3 = "tc_" + string;
            String string4 = System.getProperty(string3.toUpperCase());
            if (string4 == null) {
                string3 = "tc_" + string + ".rchland.ibm.com";
                string4 = System.getProperty(string3.toUpperCase());
            }
            if (string4 == null) {
                return null;
            }
            saddr_ptr = ToolCount.locationAddress(string4);
            saddr_toolset = string2;
        }
        return saddr_ptr;
    }

    private static DatagramPacket locationAddress(String string) {
        int n = 16617;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (string3 != null) {
            n = new Short(string3).shortValue();
        }
        InetAddress inetAddress = null;
        if (string2 != null) {
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        return new DatagramPacket(new byte[1], 0, inetAddress, n);
    }

    static {
        saddr_toolset = "";
    }
}

