CREATE TABLE Managed_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pTargetMgd                DBOID   ,
     pSourceMgd                DBOID   ,
     pTargetPlumbing           DBOID   ,
     pSourcePlumbing           DBOID   ,
     pTargetMgdRel             DBOID   ,
     pTargetMgdParent          DBOID   ,
     constraint PKManaged_version Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE Plumbing 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     adName                    VarChar(254)   ,
     pTargetMgd                DBOID   ,
     pSourceMgd                DBOID   ,
     pTargetPlumbing           DBOID   ,
     pSourcePlumbing           DBOID   ,
     pTargetMgdRel             DBOID   ,
     pTargetPlumbngPrnt        DBOID   ,
     constraint PKPlumbing Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_Plumbing AS --Plasma for Plumbing
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    Plumbing a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE Mgd2Mgd 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pSourcePlumbing           DBOID   ,
     pSourceManaged            DBOID   ,
     constraint PKMgd2Mgd Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_Mgd2Mgd AS --Plasma for Mgd2Mgd
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    Mgd2Mgd a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

