/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.EButton;
import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.PropertiesGui;
import com.ibm.vatc.tcmerge.PropertiesPage;
import com.ibm.vatc.tcmerge.SaveSchemeDialog;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.YesNoDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EditorPage
extends PropertiesPage {
    PropertiesGui pg;
    PreviewCanvas pCanvas;
    boolean modalOn;
    Vector snames;
    public String fontName;
    public int fontSize = 14;
    public int lineIndex = 1;
    public int tabSize = 8;
    public Color foreInput1;
    public Color backInput1;
    public Color foreInput2;
    public Color backInput2;
    public Color foreInput3;
    public Color backInput3;
    public Color foreCommon;
    public Color backCommon;
    public Color foreEdit;
    public Color backEdit;
    public Color navDiffBlock;
    public Color navCommonBlock;
    Choice fontChoice;
    Choice sizeChoice;
    Choice foreChoice;
    Choice backChoice;
    List codingList;
    Choice schemeChoice;
    ChoiceListener schemeChoiceListener;
    TextField tabField;

    EditorPage(MergeGui mergeGui, PropertiesGui propertiesGui) {
        super(mergeGui);
        this.pg = propertiesGui;
        this.snames = new Vector();
        this.LoadAllProperties();
        this.pCanvas = new PreviewCanvas();
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("STR_FONT")), 2, 1, 1, 1, 0, 0, 17, 0);
        this.fontChoice = new Choice();
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            this.fontChoice.add(stringArray[n]);
            ++n;
        }
        this.fontChoice.addKeyListener(keyboardListener);
        this.fontChoice.addItemListener(new ChoiceListener());
        this.fontChoice.select(this.fontName);
        GridTools.constrain(this, this.fontChoice, 2, 2, 1, 1, 0, 0, 17, 0);
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("STR_SIZE")), 4, 1, 1, 1, 0, 0, 17, 0);
        this.sizeChoice = new Choice();
        this.sizeChoice.add(tcmerge.locResource.getString("STR_EIGHT"));
        this.sizeChoice.add(tcmerge.locResource.getString("STR_NINE"));
        this.sizeChoice.add(tcmerge.locResource.getString("STR_TEN"));
        this.sizeChoice.add(tcmerge.locResource.getString("STR_ELEVEN"));
        this.sizeChoice.add(tcmerge.locResource.getString("STR_TWELVE"));
        this.sizeChoice.add(tcmerge.locResource.getString("STR_THIRTEEN"));
        this.sizeChoice.add(tcmerge.locResource.getString("STR_FOURTEEN"));
        this.sizeChoice.addItemListener(new ChoiceListener());
        this.sizeChoice.addKeyListener(keyboardListener);
        this.sizeChoice.select(Integer.toString(this.fontSize));
        GridTools.constrain(this, this.sizeChoice, 4, 2, 1, 1, 0, 0, 17, 0);
        Label label = new Label(tcmerge.locResource.getString("STR_TABWIDTH"));
        GridTools.constrain(this, label, 6, 1, 1, 1, 0, 0, 17, 0);
        this.tabField = new TextField(10);
        this.tabField.addKeyListener(keyboardListener);
        ((TextComponent)this.tabField).setText(Integer.toString(this.tabSize));
        GridTools.constrain(this, this.tabField, 6, 2, 1, 1);
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("STR_SCHME")), 2, 4, 1, 1, 0, 0, 17, 0);
        this.schemeChoice = new Choice();
        if (this.snames.size() > 0) {
            int n2 = 0;
            while (n2 < this.snames.size()) {
                this.schemeChoice.add((String)this.snames.elementAt(n2));
                ++n2;
            }
            this.schemeChoice.select(this.propertyFile.getLastUsedScheme());
        }
        this.schemeChoice.addKeyListener(keyboardListener);
        this.schemeChoiceListener = new ChoiceListener();
        this.schemeChoice.addItemListener(this.schemeChoiceListener);
        GridTools.constrain(this, this.schemeChoice, 2, 5, 1, 1, 0, 0, 17, 0);
        EButton eButton = new EButton(tcmerge.locResource.getString("STR_SAVEAS"));
        eButton.addKeyListener(keyboardListener);
        eButton.addActionListener(new ButtonListener());
        GridTools.constrain(this, eButton, 4, 5, 1, 1, 0, 0, 17, 0);
        EButton eButton2 = new EButton(tcmerge.locResource.getString("STR_DELETE"));
        eButton2.addKeyListener(keyboardListener);
        eButton2.addActionListener(new ButtonListener());
        GridTools.constrain(this, eButton2, 6, 5, 1, 1, 0, 0, 17, 0);
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("STR_FOREGROUND")), 4, 7, 1, 1, 0, 0, 17, 0);
        this.foreChoice = new Choice();
        this.foreChoice.add(tcmerge.locResource.getString("STR_BLACK"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_BLUE"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_CYAN"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_DARKGRAY"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_GRAY"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_LIGHTGRAY"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_WHITE"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_BURGUNDY"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_STEELBLUE"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_MEDIUMGRAY"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_LIGHTESTGRAY"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_GREEEN"));
        this.foreChoice.add(tcmerge.locResource.getString("STR_BRIGHTBLUE"));
        this.foreChoice.addKeyListener(keyboardListener);
        this.foreChoice.addItemListener(new ChoiceListener());
        GridTools.constrain(this, this.foreChoice, 4, 8, 3, 1, 0, 0, 17, 0);
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("STR_BACKGROUND")), 4, 10, 1, 1, 0, 0, 17, 0);
        this.backChoice = new Choice();
        this.backChoice.add(tcmerge.locResource.getString("STR_BLACK"));
        this.backChoice.add(tcmerge.locResource.getString("STR_BLUE"));
        this.backChoice.add(tcmerge.locResource.getString("STR_CYAN"));
        this.backChoice.add(tcmerge.locResource.getString("STR_DARKGRAY"));
        this.backChoice.add(tcmerge.locResource.getString("STR_GRAY"));
        this.backChoice.add(tcmerge.locResource.getString("STR_LIGHTGRAY"));
        this.backChoice.add(tcmerge.locResource.getString("STR_WHITE"));
        this.backChoice.add(tcmerge.locResource.getString("STR_BURGUNDY"));
        this.backChoice.add(tcmerge.locResource.getString("STR_STEELBLUE"));
        this.backChoice.add(tcmerge.locResource.getString("STR_MEDIUMGRAY"));
        this.backChoice.add(tcmerge.locResource.getString("STR_LIGHTESTGRAY"));
        this.backChoice.add(tcmerge.locResource.getString("STR_GREEEN"));
        this.backChoice.add(tcmerge.locResource.getString("STR_BRIGHTBLUE"));
        this.backChoice.addKeyListener(keyboardListener);
        this.backChoice.addItemListener(new ChoiceListener());
        GridTools.constrain(this, this.backChoice, 4, 11, 3, 1, 0, 0, 17, 0);
        this.codingList = new List(5);
        this.codingList.addKeyListener(keyboardListener);
        this.codingList.addItemListener(new ListListener());
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("STR_COLORCODING")), 2, 7, 1, 1, 0, 0, 17, 0);
        this.codingList.add(tcmerge.locResource.getString("STR_INPUT1"));
        this.codingList.add(tcmerge.locResource.getString("STR_INPUT2"));
        this.codingList.add(tcmerge.locResource.getString("STR_INPUT3"));
        this.codingList.add(tcmerge.locResource.getString("STR_COMMON"));
        this.codingList.add(tcmerge.locResource.getString("STR_EDITINPUT"));
        this.codingList.add(tcmerge.locResource.getString("STR_NAVDIFFBLOCK"));
        this.codingList.add(tcmerge.locResource.getString("STR_NAVCOMBLOCK"));
        this.codingList.addKeyListener(keyboardListener);
        GridTools.constrain(this, this.codingList, 2, 8, 1, 4);
        this.SetCodingListValue();
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("STR_PREVIEW")), 2, 13, 1, 1, 0, 0, 17, 0);
        this.pCanvas.setSize(350, 75);
        this.pCanvas.setBackground(Color.white);
        this.pCanvas.addKeyListener(keyboardListener);
        GridTools.constrain(this, this.pCanvas, 2, 14, 5, 1);
        Canvas canvas = new Canvas();
        canvas.setSize(30, 10);
        GridTools.constrain(this, canvas, 1, 3, 1, 1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(18, 10);
        GridTools.constrain(this, canvas2, 3, 6, 1, 1);
        Canvas canvas3 = new Canvas();
        canvas3.setSize(10, 10);
        GridTools.constrain(this, canvas3, 5, 12, 1, 1);
        Canvas canvas4 = new Canvas();
        canvas4.setSize(30, 10);
        GridTools.constrain(this, canvas4, 7, 15, 1, 1);
        this.schemeChoiceListener.itemStateChanged(new ItemEvent(this.schemeChoice, 0, this.propertyFile.getLastUsedScheme(), 1));
    }

    public void SetCodingListValue() {
        this.codingList.select(0);
        this.foreChoice.select(this.cc.ConvertColorToString(this.foreInput1));
        this.backChoice.select(this.cc.ConvertColorToString(this.backInput1));
    }

    public void requestFocus() {
        this.fontChoice.requestFocus();
    }

    public void LoadEditorProperties(String string) {
        this.fontName = this.propSchemes.getProperty(String.valueOf(string) + ".fontname");
        this.fontSize = Integer.parseInt(this.propSchemes.getProperty(String.valueOf(string) + ".fontsize"));
        this.tabSize = Integer.parseInt(this.propSchemes.getProperty(String.valueOf(string) + ".tabsize"));
        this.foreInput1 = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".zerothcurrentdifffg"));
        this.backInput1 = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".zerothdiff"));
        this.foreInput2 = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".firstcurrentdifffg"));
        this.backInput2 = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".firstdiff"));
        this.foreInput3 = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".secondcurrentdifffg"));
        this.backInput3 = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".seconddiff"));
        this.foreCommon = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".matchedforground"));
        this.backCommon = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".matchedbackground"));
        this.foreEdit = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".outvieweditedfg"));
        this.backEdit = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".outvieweditedbg"));
        this.navDiffBlock = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".navigatordiffblock"));
        this.navCommonBlock = this.cc.ConvertStringToColor(this.propSchemes.getProperty(String.valueOf(string) + ".navigatorcommonblock"));
    }

    public void LoadEditorProperties() {
        this.fontName = this.options.getEditor().getFontName();
        this.fontSize = this.options.getEditor().getFontSize();
        this.tabSize = this.options.getEditor().getTab();
        this.foreInput1 = this.options.getEditor().getZerothCurrentDiffFG();
        this.backInput1 = this.options.getEditor().getZerothDiffColor();
        this.foreInput2 = this.options.getEditor().getFirstCurrentDiffFG();
        this.backInput2 = this.options.getEditor().getFirstDiffColor();
        this.foreInput3 = this.options.getEditor().getSecondCurrentDiffFG();
        this.backInput3 = this.options.getEditor().getSecondDiffColor();
        this.foreCommon = this.options.getEditor().getMatchedForeground();
        this.backCommon = this.options.getEditor().getMatchedBackground();
        this.foreEdit = this.options.getEditor().getOutviewEditedFG();
        this.backEdit = this.options.getEditor().getOutviewEditedColor();
        this.navDiffBlock = this.options.getEditor().getNavigatorDifferenceBlock();
        this.navCommonBlock = this.options.getEditor().getNavigatorCommonBlock();
    }

    public void LoadAllProperties() {
        this.snames = this.propertyFile.getSchemeNames();
        if (this.propertyFile.getLastUsedScheme().equals(tcmerge.locResource.getString("STR_MERGEDEFAULT"))) {
            this.LoadEditorProperties();
            return;
        }
        this.LoadEditorProperties(this.propertyFile.getLastUsedScheme());
    }

    public void SetProperties(String string) {
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".fontname", this.fontName);
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".fontsize", Integer.toString(this.fontSize));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".tabsize", this.tabField.getText());
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".zerothcurrentdifffg", this.cc.ConvertColorToString(this.foreInput1));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".zerothdiff", this.cc.ConvertColorToString(this.backInput1));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".firstcurrentdifffg", this.cc.ConvertColorToString(this.foreInput2));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".firstdiff", this.cc.ConvertColorToString(this.backInput2));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".secondcurrentdifffg", this.cc.ConvertColorToString(this.foreInput3));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".seconddiff", this.cc.ConvertColorToString(this.backInput3));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".matchedforground", this.cc.ConvertColorToString(this.foreCommon));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".matchedbackground", this.cc.ConvertColorToString(this.backCommon));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".outvieweditedfg", this.cc.ConvertColorToString(this.foreEdit));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".outvieweditedbg", this.cc.ConvertColorToString(this.backEdit));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".navigatordiffblock", this.cc.ConvertColorToString(this.navDiffBlock));
        ((Hashtable)this.propertyFile.propSettings).put(String.valueOf(string) + ".navigatorcommonblock", this.cc.ConvertColorToString(this.navCommonBlock));
    }

    public void RemoveOldScheme(String string) {
        Enumeration enumeration = ((Hashtable)this.propertyFile.propSettings).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(String.valueOf(string) + ".")) continue;
            ((Hashtable)this.propertyFile.propSettings).remove(string2);
        }
    }

    public class PreviewCanvas
    extends Canvas {
        PreviewCanvas() {
            EditorPage.this = EditorPage.this;
        }

        public void paint(Graphics graphics) {
            Font font = new Font(EditorPage.this.fontName, 0, EditorPage.this.fontSize);
            graphics.setFont(font);
            Dimension dimension = this.getSize();
            graphics.setColor(EditorPage.this.backInput1);
            int n = dimension.height / 5;
            int n2 = 3;
            graphics.fillRect(0, 0, dimension.width, n);
            graphics.setColor(EditorPage.this.foreInput1);
            graphics.drawString(tcmerge.locResource.getString("STR_INPUT1"), 5, n - n2);
            graphics.setColor(EditorPage.this.backInput2);
            graphics.fillRect(0, n, dimension.width, n);
            graphics.setColor(EditorPage.this.foreInput2);
            graphics.drawString(tcmerge.locResource.getString("STR_INPUT2"), 5, n * 2 - n2);
            graphics.setColor(EditorPage.this.backInput3);
            graphics.fillRect(0, n * 2, dimension.width, n);
            graphics.setColor(EditorPage.this.foreInput3);
            graphics.drawString(tcmerge.locResource.getString("STR_INPUT3"), 5, n * 3 - n2);
            graphics.setColor(EditorPage.this.backCommon);
            graphics.fillRect(0, n * 3, dimension.width, n);
            graphics.setColor(EditorPage.this.foreCommon);
            graphics.drawString(tcmerge.locResource.getString("STR_COMMON"), 5, n * 4 - n2);
            graphics.setColor(EditorPage.this.backEdit);
            graphics.fillRect(0, n * 4, dimension.width, n);
            graphics.setColor(EditorPage.this.foreEdit);
            graphics.drawString(tcmerge.locResource.getString("STR_EDITINPUT"), 5, n * 5 - n2);
        }

        public void setFontSize(int n) {
            EditorPage.this.fontSize = n;
            this.repaint();
        }

        public void setFontName(String string) {
            EditorPage.this.fontName = string;
            this.repaint();
        }

        public void setCodingIndex(int n) {
            EditorPage.this.lineIndex = n;
        }

        public void setForegroundColor(int n) {
            Color color = EditorPage.this.cc.ConvertIntToColor(n);
            switch (EditorPage.this.lineIndex) {
                case 0: {
                    EditorPage.this.foreInput1 = color;
                    break;
                }
                case 1: {
                    EditorPage.this.foreInput2 = color;
                    break;
                }
                case 2: {
                    EditorPage.this.foreInput3 = color;
                    break;
                }
                case 3: {
                    EditorPage.this.foreCommon = color;
                    break;
                }
                case 4: {
                    EditorPage.this.foreEdit = color;
                    break;
                }
            }
            this.repaint();
        }

        public void setBackgroundColor(int n) {
            Color color = EditorPage.this.cc.ConvertIntToColor(n);
            switch (EditorPage.this.lineIndex) {
                case 0: {
                    EditorPage.this.backInput1 = color;
                    break;
                }
                case 1: {
                    EditorPage.this.backInput2 = color;
                    break;
                }
                case 2: {
                    EditorPage.this.backInput3 = color;
                    break;
                }
                case 3: {
                    EditorPage.this.backCommon = color;
                    break;
                }
                case 4: {
                    EditorPage.this.backEdit = color;
                    break;
                }
                case 5: {
                    EditorPage.this.navDiffBlock = color;
                    break;
                }
                case 6: {
                    EditorPage.this.navCommonBlock = color;
                    break;
                }
            }
            this.repaint();
        }

        public void redraw() {
            this.repaint();
        }
    }

    class ButtonListener
    implements ActionListener {
        String savedScheme;

        ButtonListener() {
            EditorPage.this = EditorPage.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPage.this.needToSave = true;
            String string = actionEvent.getActionCommand();
            if (string.equals(tcmerge.locResource.getString("STR_SAVEAS"))) {
                EditorPage.this.setCursor(EditorPage.this.waitCursor);
                SaveSchemeDialog saveSchemeDialog = new SaveSchemeDialog(EditorPage.this.mg);
                EditorPage.this.setCursor(Cursor.getDefaultCursor());
                saveSchemeDialog.show();
                if (!saveSchemeDialog.getAction().equals("OK")) {
                    saveSchemeDialog.dispose();
                    saveSchemeDialog = null;
                } else if (saveSchemeDialog != null) {
                    this.savedScheme = saveSchemeDialog.getSchemeText();
                    char c = ' ';
                    char c2 = '_';
                    this.savedScheme = this.savedScheme.replace(c, c2);
                    if (this.savedScheme.equals(tcmerge.locResource.getString("STR_MERGEDEFAULT"))) {
                        WarningDialog warningDialog = new WarningDialog((Frame)EditorPage.this.mg, tcmerge.locResource.getString("STR_NOSAVESCHEME"));
                        EditorPage.this.modalOn = true;
                        warningDialog.show();
                        EditorPage.this.modalOn = false;
                        warningDialog.dispose();
                    } else {
                        if (((Hashtable)EditorPage.this.propertyFile.propSettings).contains(String.valueOf(this.savedScheme) + ".tabsize")) {
                            EditorPage.this.RemoveOldScheme(this.savedScheme);
                        }
                        EditorPage.this.SetProperties(this.savedScheme);
                        if (!EditorPage.this.snames.contains(this.savedScheme)) {
                            EditorPage.this.schemeChoice.add(this.savedScheme);
                            EditorPage.this.schemeChoice.select(this.savedScheme);
                            EditorPage.this.snames.addElement(this.savedScheme);
                        } else {
                            EditorPage.this.schemeChoice.select(this.savedScheme);
                        }
                        EditorPage.this.propertyFile.setLastUsedScheme(this.savedScheme);
                        saveSchemeDialog = null;
                    }
                }
                EditorPage.this.needToSave = false;
                return;
            }
            if (string.equals(tcmerge.locResource.getString("STR_DELETE"))) {
                String string2 = EditorPage.this.schemeChoice.getSelectedItem();
                if (string2.equals(tcmerge.locResource.getString("STR_MERGEDEFAULT"))) {
                    WarningDialog warningDialog = new WarningDialog((Frame)EditorPage.this.mg, tcmerge.locResource.getString("STR_NODELETE"));
                    EditorPage.this.modalOn = true;
                    warningDialog.show();
                    EditorPage.this.modalOn = false;
                    warningDialog.dispose();
                    return;
                }
                Object[] objectArray = new Object[]{string2};
                MessageFormat messageFormat = new MessageFormat(tcmerge.locResource.getString("STR_SHOULDDELETESCHEME"));
                String string3 = messageFormat.format(objectArray);
                String string4 = tcmerge.locResource.getString("STR_TCMERGE");
                YesNoDialog yesNoDialog = new YesNoDialog((Frame)EditorPage.this.mg, string3, string4);
                yesNoDialog.show();
                if (!yesNoDialog.getAction().equals("Yes")) {
                    yesNoDialog.dispose();
                    yesNoDialog = null;
                    return;
                }
                if (yesNoDialog != null) {
                    EditorPage.this.snames.removeElement(string2);
                    EditorPage.this.schemeChoice.removeAll();
                    EditorPage.this.propertyFile.setLastUsedScheme(tcmerge.locResource.getString("STR_MERGEDEFAULT"));
                    int n = 0;
                    while (n < EditorPage.this.snames.size()) {
                        EditorPage.this.schemeChoice.add((String)EditorPage.this.snames.elementAt(n));
                        ++n;
                    }
                    EditorPage.this.schemeChoice.select(0);
                    this.getSchemeChoiceListener().itemStateChanged(new ItemEvent(EditorPage.this.schemeChoice, 0, tcmerge.locResource.getString("STR_MERGEDEFAULT"), 1));
                }
            }
        }

        public ChoiceListener getSchemeChoiceListener() {
            return EditorPage.this.schemeChoiceListener;
        }
    }

    class ChoiceListener
    implements ItemListener {
        ChoiceListener() {
            EditorPage.this = EditorPage.this;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            EditorPage.this.needToSave = true;
            String string = (String)itemEvent.getItem();
            Choice choice = (Choice)itemEvent.getSource();
            if (choice == EditorPage.this.fontChoice) {
                EditorPage.this.pCanvas.setFontName(string);
                return;
            }
            if (choice == EditorPage.this.sizeChoice) {
                int n = Integer.parseInt(string);
                EditorPage.this.pCanvas.setFontSize(n);
                return;
            }
            if (choice == EditorPage.this.foreChoice || choice == EditorPage.this.backChoice) {
                int n = EditorPage.this.codingList.getSelectedIndex();
                EditorPage.this.pCanvas.setCodingIndex(n);
                if (choice == EditorPage.this.foreChoice) {
                    int n2 = EditorPage.this.foreChoice.getSelectedIndex();
                    EditorPage.this.pCanvas.setForegroundColor(n2);
                    return;
                }
                int n3 = EditorPage.this.backChoice.getSelectedIndex();
                EditorPage.this.pCanvas.setBackgroundColor(n3);
                return;
            }
            if (choice == EditorPage.this.schemeChoice) {
                EditorPage.this.propertyFile.setLastUsedScheme(string);
                if (string.equals(tcmerge.locResource.getString("STR_MERGEDEFAULT"))) {
                    EditorPage.this.options.getEditor().setDefaultValues();
                    EditorPage.this.LoadEditorProperties();
                } else {
                    EditorPage.this.LoadEditorProperties(string);
                }
                EditorPage.this.pCanvas.redraw();
                EditorPage.this.fontChoice.select(EditorPage.this.fontName);
                EditorPage.this.sizeChoice.select(Integer.toString(EditorPage.this.fontSize));
                ((TextComponent)EditorPage.this.tabField).setText(Integer.toString(EditorPage.this.tabSize));
                EditorPage.this.SetCodingListValue();
            }
        }
    }

    class ListListener
    implements ItemListener {
        ListListener() {
            EditorPage.this = EditorPage.this;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (EditorPage.this.codingList.isIndexSelected(5) || EditorPage.this.codingList.isIndexSelected(6)) {
                EditorPage.this.foreChoice.setEnabled(false);
            } else {
                EditorPage.this.foreChoice.setEnabled(true);
            }
            if (EditorPage.this.codingList.isIndexSelected(0)) {
                EditorPage.this.foreChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.foreInput1));
                EditorPage.this.backChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.backInput1));
            }
            if (EditorPage.this.codingList.isIndexSelected(1)) {
                EditorPage.this.foreChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.foreInput2));
                EditorPage.this.backChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.backInput2));
            }
            if (EditorPage.this.codingList.isIndexSelected(2)) {
                EditorPage.this.foreChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.foreInput3));
                EditorPage.this.backChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.backInput3));
            }
            if (EditorPage.this.codingList.isIndexSelected(3)) {
                EditorPage.this.foreChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.foreCommon));
                EditorPage.this.backChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.backCommon));
            }
            if (EditorPage.this.codingList.isIndexSelected(4)) {
                EditorPage.this.foreChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.foreEdit));
                EditorPage.this.backChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.backEdit));
            }
            if (EditorPage.this.codingList.isIndexSelected(5)) {
                EditorPage.this.backChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.navDiffBlock));
            }
            if (EditorPage.this.codingList.isIndexSelected(6)) {
                EditorPage.this.backChoice.select(EditorPage.this.cc.ConvertColorToString(EditorPage.this.navCommonBlock));
            }
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            EditorPage.this = EditorPage.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                EditorPage.this.pg.action = "CANCEL";
                ((Component)EditorPage.this.pg).setVisible(false);
            }
        }
    }
}

