/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDesktopPane;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.RootPaneContainer;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.WindowConstants;
import com.sun.java.swing.event.InternalFrameEvent;
import com.sun.java.swing.event.InternalFrameListener;
import com.sun.java.swing.plaf.DesktopIconUI;
import com.sun.java.swing.plaf.InternalFrameUI;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyVetoException;
import java.util.EventListener;

public class JInternalFrame
extends JComponent
implements Accessible,
MouseListener,
MouseMotionListener,
WindowConstants,
RootPaneContainer,
ComponentListener {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected boolean closable;
    protected boolean isClosed;
    protected boolean maximizable;
    protected boolean isMaximum;
    protected boolean iconable;
    protected boolean isIcon;
    protected boolean resizable;
    protected boolean isSelected;
    protected Icon frameIcon;
    protected String title;
    protected JDesktopIcon desktopIcon;
    transient InternalFrameListener internalFrameListener;
    private boolean opened;
    private int defaultCloseOperation = 1;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String MENU_BAR_PROPERTY = "menuBar";
    public static final String TITLE_PROPERTY = "title";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String IS_SELECTED_PROPERTY = "isSelected";
    public static final String IS_CLOSED_PROPERTY = "isClosed";
    public static final String IS_MAXIMUM_PROPERTY = "isMaximum";
    public static final String IS_ICON_PROPERTY = "isIcon";
    private Component mouseEventTarget;
    static /* synthetic */ Class class$com$sun$java$swing$JInternalFrame;

    public JInternalFrame() {
        this("", false, false, false, false);
    }

    public JInternalFrame(String string) {
        this(string, false, false, false, false);
    }

    public JInternalFrame(String string, boolean bl) {
        this(string, bl, false, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3) {
        this(string, bl, bl2, bl3, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setRootPane(this.createRootPane());
        this.setLayout(new BorderLayout());
        this.title = string;
        this.resizable = bl;
        this.closable = bl2;
        this.maximizable = bl3;
        this.isMaximum = false;
        this.iconable = bl4;
        this.isIcon = false;
        this.updateUI();
        this.setRootPaneCheckingEnabled(true);
        this.desktopIcon = new JDesktopIcon(this);
        if (this.isVisible()) {
            this.postInternalFrameEvent(25549);
            this.opened = true;
        }
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public InternalFrameUI getUI() {
        return (InternalFrameUI)this.ui;
    }

    public void setUI(InternalFrameUI internalFrameUI) {
        boolean bl = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.setUI(internalFrameUI);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setRootPaneCheckingEnabled(bl);
            throw throwable;
        }
        Object var4_3 = null;
        this.setRootPaneCheckingEnabled(bl);
    }

    public void updateUI() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.invalidate();
        if (this.desktopIcon != null) {
            this.desktopIcon.updateUIWhenHidden();
        }
    }

    void updateUIWhenHidden() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.invalidate();
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                SwingUtilities.updateComponentTreeUI(componentArray[n]);
                ++n;
            }
        }
    }

    public String getUIClassID() {
        return "InternalFrameUI";
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JMenuBar getMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getMenuBar();
        this.getRootPane().setMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        Container container2 = this.getContentPane();
        this.getRootPane().setContentPane(container);
        this.firePropertyChange(CONTENT_PANE_PROPERTY, container2, container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        JLayeredPane jLayeredPane2 = this.getLayeredPane();
        this.getRootPane().setLayeredPane(jLayeredPane);
        this.firePropertyChange(LAYERED_PANE_PROPERTY, jLayeredPane2, jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        Component component2 = this.getGlassPane();
        this.getRootPane().setGlassPane(component);
        this.firePropertyChange(GLASS_PANE_PROPERTY, component2, component);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane jRootPane2 = this.getRootPane();
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                Object var5_4 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
        this.firePropertyChange(ROOT_PANE_PROPERTY, jRootPane2, jRootPane);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!this.opened) {
            this.postInternalFrameEvent(25549);
            this.opened = true;
        }
    }

    public void setClosable(boolean bl) {
        this.closable = bl;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl) throws PropertyVetoException {
        if (this.isClosed == bl) {
            return;
        }
        Boolean bl2 = this.isClosed ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_CLOSED_PROPERTY, bl2, bl3);
        this.isClosed = bl;
        if (this.isClosed) {
            JInternalFrame jInternalFrame = this;
            synchronized (jInternalFrame) {
                if (this.internalFrameListener != null) {
                    InternalFrameEvent internalFrameEvent = new InternalFrameEvent(this, 25551);
                    this.dispatchEvent(internalFrameEvent);
                }
            }
            this.opened = false;
        } else if (!this.opened) {
            this.postInternalFrameEvent(25549);
            this.opened = true;
        }
        this.firePropertyChange(IS_CLOSED_PROPERTY, bl2, bl3);
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public boolean isResizable() {
        if (this.isMaximum) {
            return false;
        }
        return this.resizable;
    }

    public void setIconifiable(boolean bl) {
        this.iconable = bl;
    }

    public boolean isIconifiable() {
        return this.iconable;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public void setIcon(boolean bl) throws PropertyVetoException {
        if (this.isIcon == bl) {
            return;
        }
        Boolean bl2 = this.isIcon ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_ICON_PROPERTY, bl2, bl3);
        this.isIcon = bl;
        this.firePropertyChange(IS_ICON_PROPERTY, bl2, bl3);
        this.postInternalFrameEvent(bl ? 25552 : 25553);
    }

    public void setMaximizable(boolean bl) {
        this.maximizable = bl;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public void setMaximum(boolean bl) throws PropertyVetoException {
        if (this.isMaximum == bl) {
            return;
        }
        Boolean bl2 = this.isMaximum ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_MAXIMUM_PROPERTY, bl2, bl3);
        this.isMaximum = bl;
        if (bl) {
            this.getDesktopPane().addComponentListener(this);
        } else {
            JDesktopPane jDesktopPane = this.getDesktopPane();
            if (jDesktopPane != null) {
                jDesktopPane.removeComponentListener(this);
            }
        }
        this.firePropertyChange(IS_MAXIMUM_PROPERTY, bl2, bl3);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(TITLE_PROPERTY, string2, string);
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        if (this.isSelected == bl) {
            return;
        }
        Boolean bl2 = this.isSelected ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_SELECTED_PROPERTY, bl2, bl3);
        this.isSelected = bl;
        Component component = this.getGlassPane();
        if (this.isSelected) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            component.setVisible(false);
        } else {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            component.setVisible(true);
        }
        this.firePropertyChange(IS_SELECTED_PROPERTY, bl2, bl3);
        this.postInternalFrameEvent(this.isSelected ? 25554 : 25555);
        this.repaint();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setFrameIcon(Icon icon) {
        this.frameIcon = icon;
    }

    public Icon getFrameIcon() {
        return this.frameIcon;
    }

    public Color getBackground() {
        return this.getContentPane().getBackground();
    }

    public void setBackground(Color color) {
        this.getContentPane().setBackground(color);
    }

    public Color getForeground() {
        return this.getContentPane().getForeground();
    }

    public void setForeground(Color color) {
        this.getContentPane().setForeground(color);
    }

    public void moveToFront() {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.moveToFront(this);
        }
    }

    public void moveToBack() {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.moveToBack(this);
        }
    }

    public void setLayer(Integer n) {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.setLayer(this, n, jLayeredPane.getPosition(this));
            return;
        }
        JLayeredPane.putLayer(this, n);
        if (this.getParent() != null) {
            this.getParent().repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
        }
    }

    public int getLayer() {
        return JLayeredPane.getLayer(this);
    }

    public JDesktopPane getDesktopPane() {
        Container container = this.getParent();
        while (container != null && !(container instanceof JDesktopPane)) {
            container = container.getParent();
        }
        if (container == null) {
            container = this.getDesktopIcon().getParent();
            while (container != null && !(container instanceof JDesktopPane)) {
                container = container.getParent();
            }
        }
        return (JDesktopPane)container;
    }

    public void setDesktopIcon(JDesktopIcon jDesktopIcon) {
        this.desktopIcon = jDesktopIcon;
    }

    public JDesktopIcon getDesktopIcon() {
        return this.desktopIcon;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void startModal() {
        try {
            if (!Thread.currentThread().getClass().getName().endsWith("EventDispatchThread")) ** GOTO lbl17
            var1_1 = this.getToolkit().getSystemEventQueue();
            while (this.isVisible()) {
                var2_2 = var1_1.getNextEvent();
                var3_3 = var2_2.getSource();
                if (var3_3 instanceof Component) {
                    ((Component)var3_3).dispatchEvent(var2_2);
                    continue;
                }
                if (var3_3 instanceof MenuComponent) {
                    ((MenuComponent)var3_3).dispatchEvent(var2_2);
                    continue;
                }
                System.err.println("unable to dispatch event: " + var2_2);
            }
            return;
lbl-1000:
            // 1 sources

            {
                this.wait();
lbl17:
                // 2 sources

                ** while (this.isVisible())
            }
lbl18:
            // 1 sources

            return;
        }
        catch (InterruptedException v0) {
            return;
        }
    }

    synchronized void stopModal() {
        this.notifyAll();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.validate();
        this.repaint();
    }

    public synchronized void addInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.internalFrameListener = MyEventMulticaster.add(this.internalFrameListener, internalFrameListener);
        this.enableEvents(0L);
    }

    public synchronized void removeInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.internalFrameListener = MyEventMulticaster.remove(this.internalFrameListener, internalFrameListener);
    }

    private synchronized void postInternalFrameEvent(int n) {
        if (this.internalFrameListener != null) {
            InternalFrameEvent internalFrameEvent = new InternalFrameEvent(this, n);
            if ((class$com$sun$java$swing$JInternalFrame != null ? class$com$sun$java$swing$JInternalFrame : (class$com$sun$java$swing$JInternalFrame = JComponent.class$("com.sun.java.swing.JInternalFrame"))).getClassLoader() == null) {
                try {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(internalFrameEvent);
                    return;
                }
                catch (SecurityException securityException) {}
            }
            this.dispatchEvent(internalFrameEvent);
        }
    }

    private void doDefaultCloseAction() {
        switch (this.defaultCloseOperation) {
            case 1: {
                try {
                    this.setClosed(true);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            case 2: {
                try {
                    this.setClosed(true);
                    this.dispose();
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processEvent(AWTEvent var1_1) {
        var2_2 = this;
        synchronized (var2_2) {
            if (this.internalFrameListener == null) ** GOTO lbl35
            switch (var1_1.getID()) {
                case 25549: {
                    this.internalFrameListener.internalFrameOpened((InternalFrameEvent)var1_1);
                    return;
                }
                case 25550: {
                    this.internalFrameListener.internalFrameClosing((InternalFrameEvent)var1_1);
                    this.doDefaultCloseAction();
                    return;
                }
                case 25551: {
                    this.internalFrameListener.internalFrameClosed((InternalFrameEvent)var1_1);
                    return;
                }
                case 25552: {
                    this.internalFrameListener.internalFrameIconified((InternalFrameEvent)var1_1);
                    return;
                }
                case 25553: {
                    this.internalFrameListener.internalFrameDeiconified((InternalFrameEvent)var1_1);
                    return;
                }
                case 25554: {
                    this.internalFrameListener.internalFrameActivated((InternalFrameEvent)var1_1);
                    return;
                }
                case 25555: {
                    this.internalFrameListener.internalFrameDeactivated((InternalFrameEvent)var1_1);
                    return;
                }
lbl35:
                // 1 sources

                if (var1_1.getID() != 25550) break;
                this.doDefaultCloseAction();
                break;
            }
        }
        super.processEvent(var1_1);
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public void pack() {
        Container container = this.getParent();
        if (container != null && container.getPeer() == null) {
            container.addNotify();
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void show() {
        this.pack();
        if (this.isVisible()) {
            this.toFront();
        } else {
            super.show();
        }
        if (!this.isSelected()) {
            try {
                this.setSelected(true);
                return;
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
        }
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        if (this.isSelected()) {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        if (!this.isClosed) {
            this.postInternalFrameEvent(25551);
        }
    }

    public void toFront() {
        this.moveToFront();
    }

    public void toBack() {
        this.moveToBack();
    }

    public final String getWarningString() {
        return null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ((MouseListener)((Object)this.ui)).mousePressed(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.forwardMouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.forwardMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.forwardMouseEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private void forwardMouseEvent(MouseEvent mouseEvent) {
        Component component = JInternalFrame.findComponentAt(this.getContentPane(), mouseEvent.getX(), mouseEvent.getY());
        if (component != this.mouseEventTarget) {
            this.setMouseTarget(component, mouseEvent);
        }
        this.retargetMouseEvent(mouseEvent.getID(), mouseEvent);
    }

    private static Component findComponentAt(Container container, int n, int n2) {
        if (!container.contains(n, n2)) {
            return container;
        }
        int n3 = container.getComponentCount();
        Component[] componentArray = container.getComponents();
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            Point point = component.getLocation();
            if (component != null && component.contains(n - point.x, n2 - point.y) && component.getPeer() instanceof LightweightPeer && component.isVisible()) {
                if (component instanceof Container) {
                    Container container2 = (Container)component;
                    Point point2 = container2.getLocation();
                    Component component2 = JInternalFrame.findComponentAt(container2, n - point2.x, n2 - point2.y);
                    if (component2 != null) {
                        return component2;
                    }
                } else {
                    return component;
                }
            }
            ++n4;
        }
        return container;
    }

    private void setMouseTarget(Component component, MouseEvent mouseEvent) {
        if (this.mouseEventTarget != null) {
            this.retargetMouseEvent(505, mouseEvent);
        }
        this.mouseEventTarget = component;
        if (this.mouseEventTarget != null) {
            this.retargetMouseEvent(504, mouseEvent);
        }
    }

    void retargetMouseEvent(int n, MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = new MouseEvent(this.mouseEventTarget, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        this.mouseEventTarget.dispatchEvent(mouseEvent2);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = ((Component)componentEvent.getSource()).getSize();
        this.setBounds(0, 0, dimension.width, dimension.height);
        this.validate();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJInternalFrame();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJInternalFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return JInternalFrame.this.getTitle();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JInternalFrame.this.getLayer());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JInternalFrame.this.setLayer((Integer)number);
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Integer.MIN_VALUE);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Integer.MAX_VALUE);
        }

        AccessibleJInternalFrame() {
            JInternalFrame.this = JInternalFrame.this;
        }
    }

    private static class MyEventMulticaster
    extends AWTEventMulticaster
    implements InternalFrameListener {
        public MyEventMulticaster(EventListener eventListener, EventListener eventListener2) {
            super(eventListener, eventListener2);
        }

        public static InternalFrameListener add(InternalFrameListener internalFrameListener, InternalFrameListener internalFrameListener2) {
            return (InternalFrameListener)MyEventMulticaster.addInternal(internalFrameListener, internalFrameListener2);
        }

        public static InternalFrameListener remove(InternalFrameListener internalFrameListener, InternalFrameListener internalFrameListener2) {
            return (InternalFrameListener)AWTEventMulticaster.removeInternal(internalFrameListener, internalFrameListener2);
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            ((InternalFrameListener)this.a).internalFrameOpened(internalFrameEvent);
            ((InternalFrameListener)this.b).internalFrameOpened(internalFrameEvent);
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            ((InternalFrameListener)this.a).internalFrameClosing(internalFrameEvent);
            ((InternalFrameListener)this.b).internalFrameClosing(internalFrameEvent);
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            ((InternalFrameListener)this.a).internalFrameClosed(internalFrameEvent);
            ((InternalFrameListener)this.b).internalFrameClosed(internalFrameEvent);
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            ((InternalFrameListener)this.a).internalFrameIconified(internalFrameEvent);
            ((InternalFrameListener)this.b).internalFrameIconified(internalFrameEvent);
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            ((InternalFrameListener)this.a).internalFrameDeiconified(internalFrameEvent);
            ((InternalFrameListener)this.b).internalFrameDeiconified(internalFrameEvent);
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            ((InternalFrameListener)this.a).internalFrameActivated(internalFrameEvent);
            ((InternalFrameListener)this.b).internalFrameActivated(internalFrameEvent);
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            ((InternalFrameListener)this.a).internalFrameDeactivated(internalFrameEvent);
            ((InternalFrameListener)this.b).internalFrameDeactivated(internalFrameEvent);
        }

        protected static EventListener addInternal(EventListener eventListener, EventListener eventListener2) {
            if (eventListener == null) {
                return eventListener2;
            }
            if (eventListener2 == null) {
                return eventListener;
            }
            return new MyEventMulticaster(eventListener, eventListener2);
        }
    }

    public static class JDesktopIcon
    extends JComponent
    implements Accessible {
        JInternalFrame internalFrame;

        public JDesktopIcon(JInternalFrame jInternalFrame) {
            this.setInternalFrame(jInternalFrame);
            this.updateUI();
        }

        public DesktopIconUI getUI() {
            return (DesktopIconUI)this.ui;
        }

        public void setUI(DesktopIconUI desktopIconUI) {
            super.setUI(desktopIconUI);
        }

        public JInternalFrame getInternalFrame() {
            return this.internalFrame;
        }

        public void setInternalFrame(JInternalFrame jInternalFrame) {
            this.internalFrame = jInternalFrame;
        }

        public JDesktopPane getDesktopPane() {
            if (this.getInternalFrame() != null) {
                return this.getInternalFrame().getDesktopPane();
            }
            return null;
        }

        public void updateUI() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
            this.invalidate();
            Dimension dimension = this.getPreferredSize();
            this.setSize(dimension.width, dimension.height);
            if (this.internalFrame != null) {
                SwingUtilities.updateComponentTreeUI(this.internalFrame);
            }
        }

        void updateUIWhenHidden() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
            this.invalidate();
            Component[] componentArray = this.getComponents();
            if (componentArray != null) {
                int n = 0;
                while (n < componentArray.length) {
                    SwingUtilities.updateComponentTreeUI(componentArray[n]);
                    ++n;
                }
            }
        }

        public String getUIClassID() {
            return "DesktopIconUI";
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJDesktopIcon();
            }
            return this.accessibleContext;
        }

        protected class AccessibleJDesktopIcon
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.DESKTOP_ICON;
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue != null) {
                    return accessibleValue.getCurrentAccessibleValue();
                }
                return null;
            }

            public boolean setCurrentAccessibleValue(Number number) {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue != null) {
                    return accessibleValue.setCurrentAccessibleValue(number);
                }
                return false;
            }

            public Number getMinimumAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                if (accessibleContext instanceof AccessibleValue) {
                    return ((AccessibleValue)((Object)accessibleContext)).getMinimumAccessibleValue();
                }
                return null;
            }

            public Number getMaximumAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                if (accessibleContext instanceof AccessibleValue) {
                    return ((AccessibleValue)((Object)accessibleContext)).getMaximumAccessibleValue();
                }
                return null;
            }

            AccessibleJDesktopIcon() {
                JDesktopIcon.this = JDesktopIcon.this;
            }
        }
    }
}

