/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.reuse.awt;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class RollOverButton
extends Canvas
implements MouseListener {
    public static final int ENABLED = 0;
    public static final int DISABLED = 1;
    public static final int PRESSED = 2;
    public static final int ROLLOVER = 3;
    Image image;
    Image disabledImage;
    Image rollOverImage;
    Image invokeImage;
    int imageHeight;
    int imageWidth;
    int imageToDisplay;
    Graphics graphics;
    boolean depressed;
    boolean disabled;

    public RollOverButton(Image image, Image image2, Image image3, Image image4) {
        this.image = image;
        this.disabledImage = image2;
        this.rollOverImage = image3;
        this.invokeImage = image4;
        this.prepareImage(image, this);
        this.prepareImage(image2, this);
        this.prepareImage(image3, this);
        this.prepareImage(image4, this);
        this.addMouseListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.graphics = this.getGraphics();
        this.imageHeight = this.image.getHeight(null);
        this.imageWidth = this.image.getWidth(null);
        this.setSize(this.imageWidth, this.imageHeight);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.disabled = false;
            this.imageToDisplay = 0;
        } else {
            this.disabled = true;
            this.imageToDisplay = 1;
        }
        this.repaint();
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void paint(Graphics graphics) {
        if (this.imageToDisplay == 1) {
            graphics.drawImage(this.disabledImage, 0, 0, this);
            return;
        }
        if (this.imageToDisplay == 2) {
            graphics.drawImage(this.invokeImage, 0, 0, this);
            return;
        }
        if (this.imageToDisplay == 3) {
            graphics.drawImage(this.rollOverImage, 0, 0, this);
            return;
        }
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.disabled) {
            this.imageToDisplay = 2;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.disabled) {
            this.imageToDisplay = 0;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.disabled) {
            this.imageToDisplay = 3;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.disabled) {
            this.imageToDisplay = 0;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

