 /*********************************************************/
 /*  CREATED BY C2PLI CONVERSION UTILITY                  */
 /*********************************************************/
 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: SQLENV.CPY                                   */
 /*                                                                  */
 /*    This file is installed in the \IBMPLI\INCLUDE\ directory.     */
 /*                                                                  */
 /*                                                                  */
 /*  NAME - SQLENV.CPY                                               */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*                                                                  */
 /*    This include file is translated into a PL/I include file,     */
 /*    from the C header files supplied with the                     */
 /*    IBM DATABASE 2 SOFTWARE DEVELOPERS KIT/2  product.            */
 /*    This include file is intended for use with the                */
 /*    IBM DATABASE 2 SOFTWARE DEVELOPERS KIT/2 product.             */
 /*                                                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1994, 1996. All Rights Reserved.      */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*  Licensed Materials - Property of IBM                            */
 /*                                                                  */
 /*  Function = Include File defining:                               */
 /*               Environment Commands - Constants                   */
 /*               Environment Commands - Structures                  */
 /*               Environment Commands - Function Prototypes         */
 /*               Environment Commands - Labels for SQLCODES         */
 /*                                                                  */
 /*  Operating System = OS/2                                         */
 /*                                                                  */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 %dcl SQL_H_SQLENV char ext;
 %if SQL_H_SQLENV = '' %then
  %do;
    %dcl SQL_H_SQLENV char ext;
    %SQL_H_SQLENV = 'Y';



 /* System dependent defines  */
 /* %include sqlsystm;        */

 /* Required Include Files */

 /* Includes sqlsystm         */
    %include sql;

 /* Interface Parameters/Structures/Return Codes */

 /* Parameters for START USING DATABASE          */
                              /* USE = Share                         */
    dcl SQL_USE_SHR char value('S');
                              /* USE = Exclusive                     */
    dcl SQL_USE_EXC char value('X');

 /* Sizes for entries in sqledinfo, sqleninfo, sqledbstat,           */
 /* sqleusrstat, sql_dir_entry, sqle_reg_nwbindery */
                              /* Alias name                          */
    dcl SQL_ALIAS_SZ fixed bin(31) value(8);
                              /* User Id                             */
    dcl SQL_USERID_SZ fixed bin(31) value(8);
                              /* Database name                       */
    dcl SQL_DBNAME_SZ fixed bin(31) value(8);

                              /* Drive (Qualified) - OS/2            */
    dcl SQL_DRIVE_SZ_DB2OS2 fixed bin(31) value(2);
                              /* Drive (Qualified) - Windows         */
    dcl SQL_DRIVE_SZ_DB2DOS fixed bin(31) value(2);
                              /* Drive (Qualified) - NT              */
    dcl SQL_DRIVE_SZ_DB2WINT fixed bin(31) value(12);
                              /* Path (Qualified) - AIX/UNIX         */
    dcl SQL_DRIVE_SZ_DB2AIX fixed bin(31) value(215);
 %dcl SQL_DRIVE_SZ char ext;
 %SQL_DRIVE_SZ='SQL_DRIVE_SZ_DB2OS2';
    %dcl @SQL_DRIVE_SZ char ext;
    %@SQL_DRIVE_SZ='@SQL_DRIVE_SZ_DB2OS2';

                              /* Internal db name                    */
    dcl SQL_INAME_SZ fixed bin(31) value(8);
                              /* Node name                           */
    dcl SQL_NNAME_SZ fixed bin(31) value(8);
                              /* Instance Name                       */
    dcl SQL_INSTNAME_SZ fixed bin(31) value(8);
                              /* Type of database                    */
    dcl SQL_DBTYP_SZ fixed bin(31) value(20);
                              /* Comment                             */
    dcl SQL_CMT_SZ fixed bin(31) value(30);
                              /* Local_lu                            */
    dcl SQL_LOCLU_SZ fixed bin(31) value(8);
                              /* Partner_lu                          */
    dcl SQL_RMTLU_SZ fixed bin(31) value(8);
                              /* Mode                                */
    dcl SQL_MODE_SZ fixed bin(31) value(8);
                              /* Reserved                            */
    dcl SQL_NRESERVE_SZ fixed bin(31) value(0);
                              /* Alias name                          */
    dcl SQL_DBSTAT_ALIAS_SZ fixed bin(31) value(16);
                              /* Database name                       */
    dcl SQL_DBSTAT_DBNAME_SZ fixed bin(31) value(16);
                              /* Host database name                  */
    dcl SQL_LONG_NAME_SZ fixed bin(31) value(18);
                              /* collating sequence                  */
    dcl SQL_CS_SZ fixed bin(31) value(256);
                              /* Parameter string                    */
    dcl SQL_PARAMETER_SZ fixed bin(31) value(512);
                              /* Network ID                          */
    dcl SQL_NETID_SZ fixed bin(31) value(8);
                              /* Maximum Path size                   */
    dcl SQL_PATH_SZ fixed bin(31) value(1024);
                              /* Host Name                           */
    dcl SQL_HOSTNAME_SZ fixed bin(31) value(255);
                              /* Service Name                        */
    dcl SQL_SERVICE_NAME_SZ fixed bin(31) value(14);
                              /* TP Monitor Name                     */
    dcl SQL_TPMON_NAME_SZ fixed bin(31) value(19);
                              /* Symbolic Destination Name           */
    dcl SQL_SYM_DEST_NAME_SZ fixed bin(31) value(8);
                              /* TM Database Name                    */
    dcl SQL_TMDATABASE_NAME_SZ fixed bin(31) value(8);
                              /* AR Library Name                     */
    dcl SQL_AR_SZ fixed bin(31) value(8);

                              /* Default DRDA accounting string.     */
    dcl SQL_DFTDRDAACT_SZ fixed bin(31) value(25);
                              /* DCE Principal name                  */
    dcl SQL_DCEPRINCPL_SZ fixed bin(31) value(256);
                              /* Dir/Route Path/Obj Name             */
    dcl SQL_DIR_NAME_SZ fixed bin(31) value(255);
                              /* Client Comm. Protocol               */
    dcl SQL_CLIENT_COMM_SZ fixed bin(31) value(31);
                              /* Sysadm Group name                   */
    dcl SQL_SYSADM_SZ fixed bin(31) value(16);
                              /* Netware fileserver name             */
    dcl SQL_FILESERVER_SZ fixed bin(31) value(48);
                              /* Netware bindery name                */
    dcl SQL_OBJECTNAME_SZ fixed bin(31) value(48);
                              /* Netware IPX socket                  */
    dcl SQL_IPXSOCKET_SZ fixed bin(31) value(4);
                              /* Netware userid                      */
    dcl SQL_NW_UID_SZ fixed bin(31) value(48);
                              /* Netware password                    */
    dcl SQL_NW_PSWD_SZ fixed bin(31) value(128);
                              /* Collate info size (256 + 4)         */
    dcl SQL_COLLATE_INFO_SZ fixed bin(31) value(260);
                              /* Max accounting string               */
    dcl SQL_ACCOUNT_STR_SZ fixed bin(31) value(199);

 /* After an SQL CONNECT, the 5th token in the SQLCA identifies the  */
 /* DBMS an application has connected to.  The following are values  */
 /* returned from IBM DBMS. */
    dcl SQL_DBMS_ES10_OS2 char value("QOS/2 DBM");
    dcl SQL_DBMS_DB2_OS2 char value("QDB2/2");
    dcl SQL_DBMS_DB2_NT char value("QDB2/NT");
    dcl SQL_DBMS_DB2_AIX char value("QDB2/6000");
    dcl SQL_DBMS_DB2_AIX_PE char value("QDB2/6000 PE");
    dcl SQL_DBMS_DB2_HPUX char value("QDB2/HPUX");
    dcl SQL_DBMS_DB2_SUN char value("QDB2/SUN");
    dcl SQL_DBMS_DB2_SNI char value("QDB2/SNI");
    dcl SQL_DBMS_DB2_MVS char value("QDB2");
    dcl SQL_DBMS_OS400 char value("QAS");
    dcl SQL_DBMS_SQLDS_VM char value("QSQLDS/VM");
    dcl SQL_DBMS_SQLDS_VSE char value("QSQLDS/VSE");

 /* Parameters for Entry Type in sqledinfo */
                              /* Database is DCE                     */
    dcl SQL_DCE char value('3');
                              /* Database is Home                    */
    dcl SQL_HOME char value('2');
                              /* Database is Remote                  */
    dcl SQL_REMOTE char value('1');
                              /* Database is Indirect                */
    dcl SQL_INDIRECT char value('0');

 /* Parameters for adapter number in sqlectnd */
                              /* Adapter number 0                    */
    dcl SQL_ADAPTER_0 fixed bin(31) value(0);
                              /* Adapter number 1                    */
    dcl SQL_ADAPTER_1 fixed bin(31) value(1);
                              /* Minimum adapter number              */
    dcl SQL_ADAPTER_MIN fixed bin(31) value(0);
                              /* Maximum adapter number              */
    dcl SQL_ADAPTER_MAX fixed bin(31) value(15);

 /* Definitions of constants used for Structure IDs */
                                           /* DCS directory entry id */
 dcl SQL_NODE_STR_ID fixed bin(15) value('100'xn);
                                           /* Catalog node struct id */
 dcl SQL_DCS_STR_ID fixed bin(15) value('100'xn);

 /* Parameters for protocol types in sqlectnd */
                              /* APPC                                */
    dcl SQL_PROTOCOL_APPC fixed bin(15) value('0'xn);
                              /* NETBIOS                             */
    dcl SQL_PROTOCOL_NETB fixed bin(15) value('1'xn);
                              /* APPN                                */
    dcl SQL_PROTOCOL_APPN fixed bin(15) value('2'xn);
                              /* TCPIP                               */
    dcl SQL_PROTOCOL_TCPIP fixed bin(15) value('3'xn);
                              /* APPC using CPIC                     */
    dcl SQL_PROTOCOL_CPIC fixed bin(15) value('4'xn);
                              /* IPX/SPX                             */
    dcl SQL_PROTOCOL_IPXSPX fixed bin(15) value('5'xn);
                              /* Local IPC                           */
    dcl SQL_PROTOCOL_LOCAL fixed bin(15) value('6'xn);
                              /* Named Pipe                          */
    dcl SQL_PROTOCOL_NPIPE fixed bin(15) value('7'xn);

 /* Security Type for APPC using CPIC */
                                   /* None                           */
    dcl SQL_CPIC_SECURITY_NONE fixed bin(31) value(0);
                                   /* Same                           */
    dcl SQL_CPIC_SECURITY_SAME fixed bin(31) value(1);
                                   /* Program                        */
    dcl SQL_CPIC_SECURITY_PROGRAM fixed bin(31) value(2);

 /* Authentication Types */
                                   /* Authenticate on Server         */
    dcl SQL_AUTHENTICATION_SERVER fixed bin(31) value(0);
                                   /* Authenticate on Client         */
    dcl SQL_AUTHENTICATION_CLIENT fixed bin(31) value(1);
                                   /* Authenticate via DDCS          */
    dcl SQL_AUTHENTICATION_DCS fixed bin(31) value(2);
                                   /* Authentication Not Specified   */
    dcl SQL_AUTHENTICATION_NOT_SPEC fixed bin(31) value(255);

 /* Parameters for Create Database API Collating Sequences */
                              /* Coll. Seq. from System              */
    dcl SQL_CS_SYSTEM fixed bin(31) value(0);
                              /* Coll. Seq. from User                */
    %dcl SQL_CS_USER char ext;
    %SQL_CS_USER = '-1';
                              /* Coll. Seq. (None)                   */
    %dcl SQL_CS_NONE char ext;
    %SQL_CS_NONE = '-2';

 /* Parameters for indicating the stored procedure invocation was via*/
 /* the CALL statement */
    dcl SQL_CALLPROC char value("$SQL$CAL");

 /* Default values for Segmented Tables parameters */
                              /* Default number of segments-OS2      */
    dcl SQL_DEF_NUMSEGS fixed bin(31) value(1);
                              /* OBSOLETE: Default max pages per     */
                              /* seg                                 */
    dcl SQL_DEF_SEGPAGES fixed bin(31) value(76800);
                              /* default extent size                 */
    dcl SQL_DEF_EXTSIZE fixed bin(31) value(32);

 /* DUOW Connection Setting types used by sqleqryc() and */
 /* sqlesetc().Associated values are in sql.h, used in common with  */
 /* the precompiler. */
                              /* Connect type                        */
    dcl SQL_CONNECT_TYPE fixed bin(31) value(1);
                              /* Rules for changing connections      */
    dcl SQL_RULES fixed bin(31) value(2);
                              /* Disconnect type at syncpoint        */
    dcl SQL_DISCONNECT fixed bin(31) value(3);
                              /* Syncpoint type                      */
    dcl SQL_SYNCPOINT fixed bin(31) value(4);
                              /* Maximum concurrent connections      */
    dcl SQL_MAX_NETBIOS_CONNECTIONS fixed bin(31) value(5);

 /* A structure to identify an SQL statement.  The eyecatcher        */
 /* $SQL$CALL         */
 /* identifies this as an EXEC SQL CALL statement. */
 define structure
   1 SQLSTMTID,
        2 sqlcstid char(8) ,                        /* eye catcher */
        2 sqluser char(8) ,                          /* creator id */
        2 pkgname char(8) ,                        /* package name */
        2 contoken char(8) ,                  /* consistency token */
        2 sectnum fixed bin(15),                         /* reserved */
        2 wchar_info char,                               /* reserved */
        2 buffer char(39) ;                            /* reserved */



 /********************************************************************/
 /** Database Description Block structure                            */
 /********************************************************************/
 /* TableSpace types                                                */
    dcl SQL_TBS_TYP_SMS char value('S');
    dcl SQL_TBS_TYP_DMS char value('D');

 /* TableSpace container types                                      */
                              /* path (directory)  SMS only          */
    dcl SQL_TBSC_TYP_PATH char value('P');
                              /* device (raw disk) DMS only          */
    dcl SQL_TBSC_TYP_DEV char value('D');
                              /* file (cooked file) DMS only         */
    dcl SQL_TBSC_TYP_FILE char value('F');

                                 /* version 2 database descriptor    */
    dcl SQLE_DBDESC_2 char value("SQLDBD02");
                                 /* version 2 tableSpace descriptor  */
    dcl SQLE_DBTSDESC_1 char value("SQLTS001");

 /* Initial TableSpace names                                        */
                                    /* system catalogs               */
    dcl SQLCATTS_NAME char value("SYSCATSPACE");
                                   /* user tables                    */
    dcl SQLUSRTS_NAME char value("USERSPACE1");
                                   /* temp tables                    */
    dcl SQLTMPTS_NAME char value("TEMPSPACE1");

 /* tableSpace container descriptor                                 */
 define structure
   1 SQLETSCDESC,
        2 sqlctype char,                           /* container type */
        2 pad1 char(3) ,                               /* reserved */
        2 sqlcsize fixed bin(31),              /* container size (4K */
                                                           /* pages) */
        2 sqlclen fixed bin(15),              /* length of container */
                                                             /* name */
        2 sqlcontr char(256) ,                   /* container name */
        2 pad2 char(2) ;                        /* 2 bytes padding */
                                                      /* before next */
                                                        /* container */



 /* tableSpace descriptor */
 define structure
   1 SQLETSDESC,
        2 sqltsdid char(8) ,                         /* eyecatcher */
                                               /* descriptor version */
        2 sqlextnt fixed bin(31),              /* extent size (in 4K */
                                                           /* pages) */
        2 sqlprftc fixed bin(31),               /* prefetch size (4K */
                                                           /* pages) */
        2 sqlpovhd type double,                      /* i/o overhead */
        2 sqltrfrt type double,                 /* i/o transfer rate */
        2 sqltstyp char,                          /* tableSpace type */
        2 pad1 char,                                     /* reserved */
        2 sqlccnt fixed bin(15),                  /* container count */
        2 containr dim(0:1-1) type SQLETSCDESC;/* array of container */
                                                            /* specs */




 define structure
   1 sqledbdesc,
        2 sqldbdid char(8) ,                        /* eye catcher */
        2 sqldbccp fixed bin(31),               /* comment code page */
        2 sqldbcss fixed bin(31),             /* Source of collating */
                                                              /* seq */
        2 sqldbudc char(SQL_CS_SZ) ,               /* user-defined */
                                                    /* collating seq */
        2 sqldbcmt char(SQL_CMT_SZ+1) ,                 /* comment */
        2 pad char(1) ,                                /* reserved */
        2 sqldbsgp unsigned fixed bin(31) ,         /* obsolete: use */
                                                         /* sqltsext */
        2 sqldbnsg fixed bin(15),              /* number of segments */
        2 pad2 char(2) ,                               /* reserved */
        2 sqltsext fixed bin(31),             /* default extent size */
       2 sqlcatts handle SQLETSDESC,
       2 sqlusrts handle SQLETSDESC,
       2 sqltmpts handle SQLETSDESC;



 /* Database Directory Scan data structure */
 define structure
   1 sqledinfo,
        2 alias char(SQL_ALIAS_SZ) ,                 /* Alias name */
        2 dbname char(SQL_DBNAME_SZ) ,            /* Database name */
        2 drive char(SQL_DRIVE_SZ) ,                 /* Drive/Path */
        2 intname char(SQL_INAME_SZ) ,                 /* Database */
                                                     /* subdirectory */
        2 nodename char(SQL_NNAME_SZ) ,               /* Node name */
       2 dbtype char(SQL_DBTYP_SZ) ,        /* Release information */
        2 comment char(SQL_CMT_SZ) ,                    /* Comment */
        2 com_codepage fixed bin(15),        /* Code page of comment */
        2 type char,                         /* Entry type - defines */
                                                            /* above */
        2 authentication unsigned fixed bin(16) ,       /* Auth.type */
                                             /* Global database name */
        2 glbdbname char(SQL_DIR_NAME_SZ) ;


 /* Node Directory Scan data structure                */
 define structure
   1 sqleninfo,
        2 nodename char(SQL_NNAME_SZ) ,               /* Node name */
        2 local_lu char(SQL_LOCLU_SZ) ,           /* Local_lu_name */
       2 partner_lu char(SQL_RMTLU_SZ) ,        /* Partner_lu_name */
        2 mode char(SQL_MODE_SZ) ,                         /* Mode */
        2 comment char(SQL_CMT_SZ) ,                    /* Comment */
        2 com_codepage unsigned fixed bin(16) , /* Comment code page */
        2 adapter unsigned fixed bin(16) ,      /* NetBIOS Adapter # */
        2 networkid char(SQL_NETID_SZ) ,        /* APPN Network ID */
        2 protocol char,                            /* Protocol type */
                                            /* CPIC Sy m. Dest. Name */
       2 sym_dest_name char(SQL_SYM_DEST_NAME_SZ) ,
       2 security_type unsigned fixed bin(16) ,/* CPIC Security Type */
                                                 /* TCP/IP Host name */
       2 hostname char(SQL_HOSTNAME_SZ) ,
                                                   /* TCP/IP Service */
                                                             /* name */
       2 service_name char(SQL_SERVICE_NAME_SZ) ,
                                               /* IPX/SPX fileserver */
                                                             /* name */
       2 fileserver char(SQL_FILESERVER_SZ) ,
                                               /* IPX/SPX objectname */
       2 objectname char(SQL_OBJECTNAME_SZ) ,
                                                   /* LOCAL Instance */
                                                             /* name */
       2 instance_name char(SQL_INSTNAME_SZ) ;


 /* General Catalog Node structures and defines      */

 define structure
   1 sqle_node_struct,
        2 struct_id unsigned fixed bin(16) , /* Structure Identifier */
        2 codepage unsigned fixed bin(16) ,  /* Codepage for comment */
        2 comment char(SQL_CMT_SZ + 1) ,                /* Comment */
        2 nodename char(SQL_NNAME_SZ + 1) ,           /* Node name */
        2 protocol char;                            /* Protocol Type */


 define structure
    1 sqle_node_appc,                       /* For APPC protocol     */
       2 local_lu char(SQL_LOCLU_SZ + 1) ,        /* Local_lu name */
                                           /* Alias Partner_lu  name */
       2 partner_lu char(SQL_RMTLU_SZ + 1) ,
        2 mode char(SQL_MODE_SZ + 1) ;                     /* Mode */


 define structure
    1 sqle_node_netb,                       /* For NetBIOS Protocol  */
        2 adapter unsigned fixed bin(16) ,         /* Adapter Number */
                                         /* Remote Workstation  name */
       2 remote_nname char(SQL_RMTLU_SZ + 1) ;


 define structure
    1 sqle_node_appn,                       /* For APPN protocol     */
        2 networkid char(SQL_NETID_SZ + 1) ,         /* Network ID */
                                                  /* Remoter lu name */
       2 remote_lu char(SQL_RMTLU_SZ + 1) ,
       2 local_lu char(SQL_LOCLU_SZ + 1) ,        /* Local_lu name */
        2 mode char(SQL_MODE_SZ + 1) ;                     /* Mode */


 define structure
    1 sqle_node_tcpip,                      /* For TCPIP protocol    */
        2 hostname char(SQL_HOSTNAME_SZ+1) ,          /* Host name */
                                                     /* Service Name */
       2 service_name char(SQL_SERVICE_NAME_SZ+1) ;


 define structure
    1 sqle_node_local,                      /* For LOCAL protocol    */
                                                    /* Instance Name */
       2 instance_name char(SQL_INSTNAME_SZ+1) ;


 define structure
    1 sqle_node_cpic,                       /* For APPC using CPIC   */
                                                         /* protocol */
                                                   /* Sym Dest  Name */
       2 sym_dest_name char(SQL_SYM_DEST_NAME_SZ+1) ,
        2 security_type unsigned fixed bin(16) ;    /* Security Type */


 define structure
    1 sqle_node_ipxspx,                     /* For IPX/SPX protocol  */
                                                   /* Fileservername */
       2 fileserver char(SQL_FILESERVER_SZ+1) ,
                                                       /* Object name*/
       2 objectname char(SQL_OBJECTNAME_SZ+1) ;


 /* Values for sqlefrce   */
                              /* Force Mode (Asynchronous)           */
    dcl SQL_ASYNCH fixed bin(31) value(0);
                              /* Force Count (All Users)             */
    %dcl SQL_ALL_USERS char ext;
    %SQL_ALL_USERS = '-1';

                              /* Product name                        */
    dcl SQL_PRODNAME_SZ fixed bin(31) value(30);

 define structure
     1 sql_dir_entry,        /* DDCS Directory Entry Data  Structure */
        2 struct_id unsigned fixed bin(16) , /* Structure Identifier */
        2 release unsigned fixed bin(16) , /* Release level of entry */
        2 codepage unsigned fixed bin(16) ,   /* Codepage of comment */
        2 comment char(SQL_CMT_SZ + 1) ,        /* Directory entry */
                                                          /* comment */
        2 ldb char(SQL_DBNAME_SZ + 1) ,           /* Local DB name */
        2 tdb char(SQL_LONG_NAME_SZ + 1) ,        /* Target (host) */
                                                          /* DB name */
        2 ar char(SQL_AR_SZ + 1) ,              /* AR library name */
        2 parm char(SQL_PARAMETER_SZ + 1) ;           /* Parameter */
                                                           /* string */



 /********************************************************************/
 /** Database Codepage and Country code info structures              */
 /********************************************************************/

 define structure
   1 sqledbcinfo,
        2 sqldbcp char(SQL_CODESET_LEN + 1) ,          /* database */
                                                          /* codeset */
        2 sqldbcc char(SQL_LOCALE_LEN + 1) ;           /* database */
                                                        /* territory */


 /********************************************************************/
 /** V2 Database Codepage and Country code info structure            */
 /********************************************************************/

 define structure
   1 sqledbcountryinfo,
       2 sqldbcodeset char(SQL_CODESET_LEN + 1) ,
       2 sqldblocale char(SQL_LOCALE_LEN + 1) ;        /* database */
                                                        /* territory */


 define structure
    1 sqle_conn_setting,      /* Connection setting structure for    */
                                /* use with distributed unit of work */
        2 type unsigned fixed bin(16) ,   /* Connection setting type */
        2 value unsigned fixed bin(16) ; /* Connection setting value */


 /********************************************************************/
 /** Register/Deregister constants and data structures               */
 /********************************************************************/

 /* Defines for LOCATION TO REGISTER parameter                      */
    dcl SQL_NWBINDERY fixed bin(31) value(0);

 /* Register/deregister info. for NW bindery data structure         */
 define structure
   1 sqle_reg_nwbindery,
       2 uid char(SQL_NW_UID_SZ+1) ,
       2 reserved_len_1 unsigned fixed bin(16) ,
       2 pswd char(SQL_NW_PSWD_SZ+1) ,
       2 reserved_len_2 unsigned fixed bin(16) ;


 %dcl SQLZ_STACK char ext;
    %if (SQLZ_STACK^='') %then
     %do;
       dcl SQLENOP fixed bin(31) value(0);
     %end;
  %else
     %do;

 /********************************************************************/
 /** Database Environment Commands -- Function Prototypes            */
 /********************************************************************/


 %dcl SQL_REL_10 char ext;
 %if (SQL_REL_10^='') %then
  %do;
  %end;
  %end;

                                    /* Catalog Database              */
 dcl   sqlectdd_api  entry (
         pointer,                   /* database                      */
         pointer,                   /* alias                         */
         char,                      /* type                          */
         pointer,                   /* node name                     */
         pointer,                   /* drive/path                    */
         pointer,                   /* comment                       */
        unsigned fixed bin(16),     /* authentication                */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Catalog Node                  */
 dcl   sqlectnd_api  entry (
        handle sqle_node_struct,    /* node structure ptr            */
         pointer,                   /* protocol structure ptr        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Change Database Comment       */
 dcl   sqledcgd_api  entry (
         pointer,                   /* database alias                */
         pointer,                   /* drive/path                    */
         pointer,                   /* comment                       */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Close Directory Scan          */
 dcl   sqledcls_api  entry (
        unsigned fixed bin(16),     /* handle                        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get Next Directory Entry      */
 dcl   sqledgne_api  entry (
        unsigned fixed bin(16),     /* handle                        */
        handle sqledinfo,           /* buffer                        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Open Directory Scan           */
 dcl   sqledosd_api  entry (
        pointer,                    /* drive/path                    */
        pointer,                    /* handle                        */
        pointer,                    /* count                         */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Drop Database                 */
 dcl   sqledrpd_api  entry (
        pointer,                    /* database alias                */
        pointer,                    /* reserved                      */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Force Users                   */
 dcl   sqlefrce_api  entry (
        fixed bin(31),              /* number of users to force      */
        pointer,                    /* array of agent ids            */
        unsigned fixed bin(16),     /* mode of operation             */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Catalog DCS Database          */
 dcl   sqlegdad_api  entry (
        handle sql_dir_entry,       /* pointer to entry structure    */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Close DCS Directory Scan      */
 dcl   sqlegdcl_api  entry (
         pointer )                  /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Uncatalog DCS Database        */
 dcl   sqlegdel_api  entry (
        handle sql_dir_entry,       /* pointer to entry structure    */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get DCS Directory Entry For   */
                                    /* Database                      */
 dcl   sqlegdge_api  entry (
        handle sql_dir_entry,       /* pointer to entry structure    */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get DCS Directory Entries     */
 dcl   sqlegdgt_api  entry (
        pointer,                    /* pointer to count variable     */
        handle sql_dir_entry,       /* pointer to entry structure  */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Open DCS Directory Scan       */
 dcl   sqlegdsc_api  entry (
        pointer,                    /* pointer to count variable     */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get Instance                  */
 dcl   sqlegins_api  entry (
        pointer,                    /* pointer to instance name      */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

 dcl sqleintr_api entry ( )
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Install Signal Handler        */
 dcl   sqleisig_api  entry (
         pointer )                  /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Free Memory                   */
 dcl   sqlefmem_api  entry (
        pointer,                    /* SQLCA                         */
         pointer)                   /* buffer pointer                */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Migrate Database              */
 dcl   sqlemgdb_api  entry (
         pointer,                   /* database alias                */
         pointer,                   /* user name                     */
         pointer,                   /* password                      */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Close Node Directory Scan     */
 dcl   sqlencls_api  entry (
        unsigned fixed bin(16),     /* handle                        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get Next Node Directory       */
                                    /* Entry                         */
 dcl   sqlengne_api  entry (
        unsigned fixed bin(16),     /* handle                        */
        handle sqleninfo,           /* buffer                        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Open Node Directory Scan      */
 dcl   sqlenops_api  entry (
        pointer,                    /* handle                        */
        pointer,                    /* count                         */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Database Application Remote   */
                                    /* Interface                     */
 dcl   sqleproc_api  entry (
        pointer,                    /* Path of program to run        */
        handle sqlchar,             /* variable length area ptr      */
        pointer,                    /* input SQLDA                   */
        pointer,                    /* output SQLDA                  */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Restart Database              */
 dcl   sqlerstd_api  entry (
        pointer,                    /* database alias                */
        pointer,                    /* user name                     */
        pointer,                    /* password                      */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Start Database Manager        */
 dcl   sqlestar_api  entry ( )
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Stop Database Manager         */
 dcl   sqlestop_api  entry (
        pointer )                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Uncatalog Database            */
 dcl   sqleuncd_api  entry (
        pointer,                    /* database alias                */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Uncatalog Node                */
 dcl   sqleuncn_api  entry (
        pointer,                    /* node name                     */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Set Client                    */
 dcl   sqlesetc_api  entry (
        pointer,                    /* conn setting array            */
        unsigned fixed bin(16),     /* number of settings            */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Query Client                  */
 dcl   sqleqryc_api  entry (
        pointer,                    /* conn setting array */
        unsigned fixed bin(16),     /* number of settings            */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Create Database               */
 dcl   sqlecrea_api  entry (
        pointer,                    /* database                      */
        pointer,                    /* local alias                   */
        pointer,                    /* drive/path                    */
        handle sqledbdesc,          /* database descriptor block     */
        handle sqledbcountryinfo,   /* db locale and codeset     */
        char,                       /* reserved                      */
        pointer,                    /* reserved                      */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Attach                        */
 dcl   sqleatin_api  entry (
        pointer,                    /* node name                     */
        pointer,                    /* user name                     */
        pointer,                    /* password                      */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Detach                        */
 dcl   sqledtin_api  entry (
         pointer )                  /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Set Accounting String         */
 dcl   sqlesact_api  entry (
        pointer,                    /* accounting string             */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Register DB2 Server           */
 dcl   sqleregs_api  entry (
        unsigned fixed bin(16),     /* location at which to reg      */
        pointer,                    /* register info.                */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Deregister DB2 Server         */
 dcl   sqledreg_api  entry (
        unsigned fixed bin(16),     /* location at which to dereg    */
        pointer,                    /* deregister info.              */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

 /* GENERIC INTERFACES          */

                                    /* Change Database Comment       */
 dcl   sqlgdcgd  entry (
        unsigned fixed bin(16),     /* comment length                */
        unsigned fixed bin(16),     /* drive/path length             */
        unsigned fixed bin(16),     /* database length               */
        pointer,                    /* SQLCA                         */
        pointer,                    /* comment                       */
        pointer,                    /* drive/path                    */
         pointer)                   /* database                      */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Close Directory Scan          */
 dcl   sqlgdcls  entry (
        unsigned fixed bin(16),     /* handle                        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get Next Database Directory   */
                                    /* Entry                         */
 dcl   sqlgdgne  entry (
        unsigned fixed bin(16),     /* handle                        */
        handle sqledinfo,           /* buffer                        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Drop Database                 */
 dcl   sqlgdrpd  entry (
        unsigned fixed bin(16),     /* reserved                      */
        unsigned fixed bin(16),     /* database alias length         */
        pointer,                    /* SQLCA                         */
        pointer,                    /* reserved                      */
         pointer)                   /* database alias                */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Open Directory Scan           */
 dcl   sqlgdosd  entry (
        unsigned fixed bin(16),     /* drive/path length             */
        pointer,                    /* SQLCA                         */
        pointer,                    /* count                         */
        pointer,                    /* handle                        */
         pointer)                   /* drive/path                    */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Force Users                   */
 dcl   sqlgfrce  entry (
        pointer,                    /* SQLCA                         */
        unsigned fixed bin(16),     /* mode of operation             */
        pointer,                    /* array of agent ids            */
         fixed bin(31))             /* num of users to force         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Catalog DCS Database          */
 dcl   sqlggdad  entry (
         pointer,                   /* SQLCA                         */
         handle sql_dir_entry)       /* directory entry              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Close DCS Directory Scan      */
 dcl   sqlggdcl  entry (
         pointer )                  /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Uncatalog DCS Database        */
 dcl   sqlggdel  entry (
        pointer,                    /* SQLCA                         */
         handle sql_dir_entry)       /* directory entry              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get DCS Directory Entry For   */
                                    /* Database                      */
 dcl   sqlggdge  entry (
        pointer,                    /* SQLCA                         */
         handle sql_dir_entry)       /* directory entry              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get DCS Directory Entries     */
 dcl   sqlggdgt  entry (
         pointer,                   /* SQLCA                         */
        pointer,                    /* count variable                */
         handle sql_dir_entry)         /* entry structure            */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Open DCS Directory Scan       */
 dcl   sqlggdsc  entry (
        pointer,                    /* SQLCA                         */
         pointer)                   /* count variable                */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get Instance                  */
 dcl   sqlggins  entry (
        pointer,                    /* SQLCA                         */
         pointer)                   /* pointer to instance name      */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Catalog Database              */
 dcl   sqlgctdd  entry (
        unsigned fixed bin(16),     /* comment length                */
        unsigned fixed bin(16),     /* drive/path length             */
        unsigned fixed bin(16),     /* node name length              */
        unsigned fixed bin(16),     /* alias length                  */
        unsigned fixed bin(16),     /* database length               */
        pointer,                    /* SQLCA                         */
        unsigned fixed bin(16),     /* authentication                */
        pointer,                    /* comment                       */
        pointer,                    /* drive/path                    */
        pointer,                    /* node name                     */
        char,                       /* type                          */
        pointer,                    /* alias                         */
         pointer)                   /* database                      */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Catalog Node                  */
 dcl   sqlgctnd  entry (
        pointer,                    /* SQLCA                         */
        handle sqle_node_struct,    /* node structure                */
         pointer)                   /* Protocol Structure            */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* CREATE DATABASE               */
 dcl   sqlgdbcr  entry (
        unsigned fixed bin(16),     /* length drive/path             */
        unsigned fixed bin(16),     /* length database               */
        pointer,                    /* SQLCA                         */
        handle sqledbcinfo,         /* database country info         */
        unsigned fixed bin(16),     /* authentication                */
        handle sqledbdesc,          /* db descriptor block           */
        pointer,                    /* drive/path                    */
         pointer)                   /* database                      */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Interrupt                     */
 dcl   sqlgintr  entry (   )
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Install Signal Handler        */
 dcl   sqlgisig  entry (
         pointer )                  /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Migrate Database              */
 dcl   sqlgmgdb  entry (
        unsigned fixed bin(16),     /* password length               */
        unsigned fixed bin(16),     /* user name length              */
        unsigned fixed bin(16),     /* database alias length         */
        pointer,                    /* SQLCA                         */
        pointer,                    /* password                      */
        pointer,                    /* user name                     */
         pointer)                   /* database alias                */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Close Node Directory Scan     */
 dcl   sqlgncls  entry (
        unsigned fixed bin(16),     /* handle                        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Get Next Node Directory       */
                                    /* Entry                         */
 dcl   sqlgngne  entry (
        unsigned fixed bin(16),     /* handle                        */
        handle sqleninfo,           /* buffer                        */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Open Node Directory Scan      */
 dcl   sqlgnops  entry (
        pointer,                    /* handle                        */
        pointer,                    /* count                         */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Database Application Remote   */
                                    /* Interface                     */
 dcl   sqlgproc  entry (
        unsigned fixed bin(16),     /* program name length           */
        pointer,                    /* SQLCA                         */
        pointer,                    /* Path of program to run        */
        pointer,                    /* input SQLDA                   */
        pointer,                    /* output SQLDA                  */
         handle sqlchar)            /* variable length area ptr      */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Restart Database              */
 dcl   sqlgrstd  entry (
        unsigned fixed bin(16),     /* password length               */
        unsigned fixed bin(16),     /* user name length              */
        unsigned fixed bin(16),     /* database alias length         */
        pointer,                    /* SQLCA                         */
        pointer,                    /* password                      */
        pointer,                    /* user name                     */
         pointer)                   /* database alias                */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Set Client                    */
 dcl   sqlgsetc  entry (
        pointer,                    /* conn setting array */
        unsigned fixed bin(16),     /* number of settings            */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Query Client                  */
 dcl   sqlgqryc  entry (
        pointer,                    /* conn setting array */
        unsigned fixed bin(16),     /* number of settings            */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Create Database               */
 dcl   sqlgcrea  entry (
        unsigned fixed bin(16),     /* drive/path length             */
        unsigned fixed bin(16),     /* local alias length            */
        unsigned fixed bin(16),     /* database length               */
        pointer,                    /* SQLCA                         */
        pointer,                    /* reserved                      */
        unsigned fixed bin(16),     /* reserved                      */
        handle sqledbcountryinfo,   /* db locale and codeset     */
        handle sqledbdesc,          /* db description block          */
        pointer,                    /* drive/path                    */
        pointer,                    /* local alias                   */
         pointer)                   /* database                      */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Attach                        */
 dcl   sqlgatin  entry (
        unsigned fixed bin(16),     /* password length               */
        unsigned fixed bin(16),     /* user name length              */
        unsigned fixed bin(16),     /* node name length              */
        pointer,                    /* SQLCA                         */
        pointer,                    /* password                      */
        pointer,                    /* user name                     */
         pointer)                   /* node name                     */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Detach                        */
 dcl   sqlgdtin  entry (
         pointer )                  /* SQLCA                         */
           returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Start Database Manager        */
 dcl   sqlgstar  entry (  )
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Stop Database Manager         */
 dcl   sqlgstdm  entry (
         pointer )                  /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Uncatalog Database            */
 dcl   sqlguncd  entry (
        unsigned fixed bin(16),     /* database alias length         */
        pointer,                    /* SQLCA                         */
         pointer)                   /* database alias                */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Uncatalog Node                */
 dcl   sqlguncn  entry (
        unsigned fixed bin(16),     /* node name length              */
        pointer,                    /* SQLCA                         */
         pointer)                   /* node name                     */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Set Accounting String         */
 dcl   sqlgsact  entry (
        unsigned fixed bin(16),     /* accounting string length      */
        pointer,                    /* accounting string             */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Register DB2 Server           */
 dcl   sqlgregs  entry (
        unsigned fixed bin(16),     /* location at which to reg      */
        pointer,                    /* register info.                */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Deregister DB2 Server         */
 dcl   sqlgdreg  entry (
        unsigned fixed bin(16),     /* location at which to dereg    */
        pointer,                    /* deregister info.              */
         pointer)                   /* SQLCA                         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                    /* Free Memory                   */
 dcl   sqlgfmem  entry (
        pointer,                    /* SQLCA                         */
         pointer)                   /* buffer pointer                */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

 /* SQL Return Codes in SQLCODE for Environment Commands */

 %dcl SQL_RC_OK char ext;
 %if SQL_RC_OK = '' %then
  %do;
 /* everything is ok */
    %SQL_RC_OK = '0';
  %end;
 /* SQL_RC_OK */

 %dcl SQL_RC_INVALID_SQLCA char ext;
 %if SQL_RC_INVALID_SQLCA = '' %then
  %do;
 /* invalid sqlca */
    %dcl SQL_RC_INVALID_SQLCA char ext;
    %SQL_RC_INVALID_SQLCA = '-1';
  %end;
 /* SQL_RC_INVALID_SQLCA */

 %dcl SQLE_RC_INLUW char ext;
 /* Connect to other DB not       */
 /* allowed                       */
 %SQLE_RC_INLUW = '-752';
 /* Only SBCS data allowed        */
 dcl SQLE_RC_W863 fixed bin(31) value(863);

 /* Agent heap too small          */
 %dcl SQLE_RC_E953 char ext;
 %SQLE_RC_E953 = '-953';
 /* Requestor comm heap too       */
 /* small                         */
 %dcl SQLE_RC_E957 char ext;
 %SQLE_RC_E957 = '-957';
 /* Server comm heap too small    */
 %dcl SQLE_RC_E959 char ext;
 %SQLE_RC_E959 = '-959';
 /* Rqstr remote svcs heap too    */
 /* small                         */
 %dcl SQLE_RC_E961 char ext;
 %SQLE_RC_E961 = '-961';
 /* Svr remote svcs heap too      */
 /* small                         */
 %dcl SQLE_RC_E962 char ext;
 %SQLE_RC_E962 = '-962';

                                    /* New log path is invalid       */
 dcl SQLE_RC_INVNEWLOGP fixed bin(31) value(993);
                                    /* Current log path is invalid   */
 dcl SQLE_RC_INVLOGP fixed bin(31) value(995);

                                    /* Invalid alias                 */
 %dcl SQLE_RC_INVALIAS char ext;
 %SQLE_RC_INVALIAS = '-1000';
                                    /* Invalid database name         */
 %dcl SQLE_RC_INVDBNAME char ext;
 %SQLE_RC_INVDBNAME = '-1001';
                                    /* Invalid drive                 */
 %dcl SQLE_RC_INVDRIVE char ext;
 %SQLE_RC_INVDRIVE = '-1002';

                                    /* Invalid password - OS/2       */
 %dcl SQLE_RC_INVPSW_DB2OS2 char ext;
 %SQLE_RC_INVPSW_DB2OS2 = '-1003';
                                    /* Invalid password - NT         */
 %dcl SQLE_RC_INVPSW_DB2NT char ext;
 %SQLE_RC_INVPSW_DB2NT = '-1003';
                                    /* Invalid password - DOS        */
 %dcl SQLE_RC_INVPSW_DB2DOS char ext;
 %SQLE_RC_INVPSW_DB2DOS = '-1003';
                                    /* Invalid password - Windows    */
 %dcl SQLE_RC_INVPSW_DB2WIN char ext;
 %SQLE_RC_INVPSW_DB2WIN = '-1003';
                                    /* Invalid password - AIX        */
 %dcl SQLE_RC_INVPSW_DB2AIX char ext;
 %SQLE_RC_INVPSW_DB2AIX = '-10002';

 %dcl SQLE_RC_INVPSW char ext;
 %SQLE_RC_INVPSW='SQLE_RC_INVPSW_DB2OS2';
 %dcl @SQLE_RC_INVPSW char ext;
 %@SQLE_RC_INVPSW='@SQLE_RC_INVPSW_DB2OS2';

                                    /* Insuf storage on file system  */
 %dcl SQLE_RC_INSSTOR char ext;
 %SQLE_RC_INSSTOR = '-1004';
                                    /* Duplicate alias               */
 %dcl SQLE_RC_DUPALIAS char ext;
 %SQLE_RC_DUPALIAS = '-1005';
                                    /* Appl code page does not       */
                                    /* match db                      */
 %dcl SQLE_RC_WRONGCODEPG char ext;
 %SQLE_RC_WRONGCODEPG = '-1006';
                                    /* Invalid new password          */
 %dcl SQLE_RC_INV_NEWPSW char ext;
 %SQLE_RC_INV_NEWPSW = '-1008';
                                    /* Invalid remote command        */
 %dcl SQLE_RC_INVREMOTE char ext;
 %SQLE_RC_INVREMOTE = '-1009';

                                    /* Invalid type                  */
 %dcl SQLE_RC_INVTYPE char ext;
 %SQLE_RC_INVTYPE = '-1010';
                                    /* No drive for indirect entry   */
 %dcl SQLE_RC_NODRIVE char ext;
 %SQLE_RC_NODRIVE = '-1011';
                                    /* No nodename for remote entry  */
 %dcl SQLE_RC_NONODE char ext;
 %SQLE_RC_NONODE = '-1012';
                                    /* Alias or database name not    */
                                    /* found                         */
 %dcl SQLE_RC_NODB char ext;
 %SQLE_RC_NODB = '-1013';
                                    /* No more entries               */
 dcl SQLE_RC_NOMORE fixed bin(31) value(1014);
                                    /* Database needs restart        */
 %dcl SQLE_RC_DB_RESTART char ext;
 %SQLE_RC_DB_RESTART = '-1015';
                                    /* Invalid local_lu alias        */
 %dcl SQLE_RC_INVLLU char ext;
 %SQLE_RC_INVLLU = '-1016';
                                    /* Invalid mode                  */
 %dcl SQLE_RC_INVMODE char ext;
 %SQLE_RC_INVMODE = '-1017';
                                    /* Duplicate node name           */
 %dcl SQLE_RC_DUPNODE char ext;
 %SQLE_RC_DUPNODE = '-1018';
                                    /* Invalid node name             */
 %dcl SQLE_RC_INVNODE char ext;
 %SQLE_RC_INVNODE = '-1019';

                                    /* Node could not be cataloged   */
 %dcl SQLE_RC_MAXNODE char ext;
 %SQLE_RC_MAXNODE = '-1020';
                                    /* Nodename not found            */
 %dcl SQLE_RC_NOTNODE char ext;
 %SQLE_RC_NOTNODE = '-1021';

 %dcl SQLE_RC_INSSYS_DB2OS2 char ext;
                                    /* Insuf system resources - OS2  */
 %SQLE_RC_INSSYS_DB2OS2 = '-1022';
 %dcl SQLE_RC_INSSYS_DB2NT char ext;
                                    /* Insuf system resources - NT   */
 %SQLE_RC_INSSYS_DB2NT = '-1022';
 %dcl SQLE_RC_INSSYS_DB2DOS char ext;
                                    /* Insuf system resources - DOS  */
 %SQLE_RC_INSSYS_DB2DOS = '-1022';
                                    /* Insuf system resources -      */
                                    /* Windows                       */
 %dcl SQLE_RC_INSSYS_DB2WIN char ext;
 %SQLE_RC_INSSYS_DB2WIN = '-1022';
                                    /* Insuf system resources - AIX  */
 %dcl SQLE_RC_INSSYS_DB2AIX char ext;
 %SQLE_RC_INSSYS_DB2AIX = '-10003';

 %dcl SQLE_RC_INSSYS char ext;
 %SQLE_RC_INSSYS='SQLE_RC_INSSYS_DB2OS2';
 %dcl @SQLE_RC_INSSYS char ext;
 %@SQLE_RC_INSSYS='@SQLE_RC_INSSYS_DB2OS2';

                                    /* Communication conversation    */
                                    /* failed                        */
 %dcl SQLE_RC_NOCONV char ext;
 %SQLE_RC_NOCONV = '-1023';
                                    /* No database connection        */
                                    /* exists                        */
 %dcl SQLE_RC_NOSUDB char ext;
 %SQLE_RC_NOSUDB = '-1024';
                                    /* Databases are active          */
 %dcl SQLE_RC_DBACT char ext;
 %SQLE_RC_DBACT = '-1025';
                                    /* Database manager already      */
                                    /* started                       */
 %dcl SQLE_RC_INVSTRT char ext;
 %SQLE_RC_INVSTRT = '-1026';
                                    /* Node directory not found      */
 %dcl SQLE_RC_NONODEDIR char ext;
 %SQLE_RC_NONODEDIR = '-1027';
                                    /* Partner lu not specified      */
 %dcl SQLE_RC_INVRLU char ext;
 %SQLE_RC_INVRLU = '-1029';

                                    /* Database directory is full    */
 %dcl SQLE_RC_MAXDB char ext;
 %SQLE_RC_MAXDB = '-1030';
                                    /* Database directory not found  */
 %dcl SQLE_RC_NODBDIR char ext;
 %SQLE_RC_NODBDIR = '-1031';
                                    /* Database manager not started  */
 %dcl SQLE_RC_NOSTARTG char ext;
 %SQLE_RC_NOSTARTG = '-1032';
                                    /* Database directory being      */
                                    /* updated                       */
 %dcl SQLE_RC_DIRBUSY char ext;
 %SQLE_RC_DIRBUSY = '-1033';
                                    /* Database is damaged           */
 %dcl SQLE_RC_DBBAD char ext;
 %SQLE_RC_DBBAD = '-1034';
                                    /* Database already in use       */
 %dcl SQLE_RC_DB_INUSE char ext;
 %SQLE_RC_DB_INUSE = '-1035';
                                    /* Database file error           */
 %dcl SQLE_RC_FILEDB char ext;
 %SQLE_RC_FILEDB = '-1036';
                                    /* No entry in Node directory    */
 dcl SQLE_RC_NODE_DIR_EMPTY fixed bin(31) value(1037);
                                    /* Node directory file error     */
 %dcl SQLE_RC_FILENODE char ext;
 %SQLE_RC_FILENODE = '-1038';

                                    /* Directory file error - OS/2   */
 %dcl SQLE_RC_FILEDIR_DB2OS2 char ext;
 %SQLE_RC_FILEDIR_DB2OS2 = '-1039';
                                    /* Directory file error - NT     */
 %dcl SQLE_RC_FILEDIR_DB2NT char ext;
 %SQLE_RC_FILEDIR_DB2NT = '-1039';
                                    /* Directory file error - DOS    */
 %dcl SQLE_RC_FILEDIR_DB2DOS char ext;
 %SQLE_RC_FILEDIR_DB2DOS = '-1039';
                                    /* Directory file error -        */
                                    /* Windows                       */
 %dcl SQLE_RC_FILEDIR_DB2WIN char ext;
 %SQLE_RC_FILEDIR_DB2WIN = '-1039';
                                    /* Directory file error - AIX    */
 %dcl SQLE_RC_FILEDIR_DB2AIX char ext;
 %SQLE_RC_FILEDIR_DB2AIX = '-10004';

 %dcl SQLE_RC_FILEDIR char ext;
 %SQLE_RC_FILEDIR='SQLE_RC_FILEDIR_DB2OS2';
 %dcl @SQLE_RC_FILEDIR char ext;
 %@SQLE_RC_FILEDIR='@SQLE_RC_FILEDIR_DB2OS2';

                                    /* Max number of applications    */
                                    /* reached                       */
 %dcl SQLE_RC_MAXAPPLS char ext;
 %SQLE_RC_MAXAPPLS = '-1040';
                                    /* Max number of databases       */
                                    /* started                       */
 %dcl SQLE_RC_MAXDBS char ext;
 %SQLE_RC_MAXDBS = '-1041';
                                    /* System error                  */
 %dcl SQLE_RC_SYSERR char ext;
 %SQLE_RC_SYSERR = '-1042';
                                    /* Catalog bootstrap failure     */
 %dcl SQLE_RC_CATBOOT char ext;
 %SQLE_RC_CATBOOT = '-1043';
                                    /* Request interrupted by        */
                                    /* ctrl+break                    */
 %dcl SQLE_RC_INTRRPT char ext;
 %SQLE_RC_INTRRPT = '-1044';
                                    /* Invalid level of indirection  */
 %dcl SQLE_RC_INVINDIR char ext;
 %SQLE_RC_INVINDIR = '-1045';
                                    /* Invalid userid                */
 %dcl SQLE_RC_INVAUTHID char ext;
 %SQLE_RC_INVAUTHID = '-1046';
                                    /* Appl already connect to       */
                                    /* another db                    */
 %dcl SQLE_RC_APCONN char ext;
 %SQLE_RC_APCONN = '-1047';

                                    /* Invalid use specified - OS/2  */
 %dcl SQLE_RC_USEINVALID_DB2OS2 char ext;
 %SQLE_RC_USEINVALID_DB2OS2 = '-1048';
                                    /* Invalid use specified - NT    */
 %dcl SQLE_RC_USEINVALID_DB2NT char ext;
 %SQLE_RC_USEINVALID_DB2NT = '-1048';
                                    /* Invalid use specified - DOS   */
 %dcl SQLE_RC_USEINVALID_DB2DOS char ext;
 %SQLE_RC_USEINVALID_DB2DOS = '-1048';
                                    /* Invalid use specified -       */
                                    /* Windows                       */
 %dcl SQLE_RC_USEINVALID_DB2WIN char ext;
 %SQLE_RC_USEINVALID_DB2WIN = '-1048';
                                    /* Invalid use specified - AIX   */
 %dcl SQLE_RC_USEINVALID_DB2AIX char ext;
 %SQLE_RC_USEINVALID_DB2AIX = '-10005';

 %dcl SQLE_RC_USEINVALID char ext;
 %SQLE_RC_USEINVALID='SQLE_RC_USEINVALID_DB2OS2';
 %dcl @SQLE_RC_USEINVALID char ext;
 %@SQLE_RC_USEINVALID='@SQLE_RC_USEINVALID_DB2OS2';

                                    /* Appl state in error           */
 %dcl SQLE_RC_APPSERR char ext;
 %SQLE_RC_APPSERR = '-900';

                                    /* Cannot uncatalog 'Home'       */
                                    /* database                      */
 %dcl SQLE_RC_UNCHOME char ext;
 %SQLE_RC_UNCHOME = '-1050';
                                    /* Db direct. drive does not     */
                                    /* exist                         */
 %dcl SQLE_RC_NODIRDRV char ext;
 %SQLE_RC_NODIRDRV = '-1051';
                                    /* Database drive does not       */
                                    /* exist                         */
 %dcl SQLE_RC_NODBDRV char ext;
 %SQLE_RC_NODBDRV = '-1052';
                                    /* Interrupt already in          */
                                    /* progress                      */
 %dcl SQLE_RC_INTBUSY char ext;
 %SQLE_RC_INTBUSY = '-1053';
                                    /* Commit in progress - no       */
                                    /* int's                         */
 %dcl SQLE_RC_COMMINP char ext;
 %SQLE_RC_COMMINP = '-1054';
                                    /* Rollback in progress - no     */
                                    /* int's                         */
 %dcl SQLE_RC_ROLLINP char ext;
 %SQLE_RC_ROLLINP = '-1055';
                                    /* Cannot be interrupted - no    */
                                    /* int's                         */
 %dcl SQLE_RC_NOINTER char ext;
 %SQLE_RC_NOINTER = '-1360';
                                    /* Windows Client Execution      */
                                    /* Timeout                       */
 dcl SQLE_RC_TIMEOUT fixed bin(31) value(1361);
                                    /* Maximum allowable scans       */
                                    /* exceeded                      */
 %dcl SQLE_RC_MAXSCAN char ext;
 %SQLE_RC_MAXSCAN = '-1056';
                                    /* No entries in directory       */
 dcl SQLE_RC_NODENTRY fixed bin(31) value(1057);
                                    /* Invalid input handle          */
 %dcl SQLE_RC_INVHAND char ext;
 %SQLE_RC_INVHAND = '-1058';
                                    /* Open scan not issued          */
 %dcl SQLE_RC_NOSCAN char ext;
 %SQLE_RC_NOSCAN = '-1059';

                                    /* User lacks connect privilege  */
 %dcl SQLE_RC_NOCONNECT char ext;
 %SQLE_RC_NOCONNECT = '-1060';
                                    /* RESTART was successful, but   */
                                    /* indoubt transactions exist    */
 dcl SQLE_RC_RESTART_WITH_INDOUBTS fixed bin(31) value(1061);
                                    /* Database path not found       */
 %dcl SQLE_RC_BADPATH char ext;
 %SQLE_RC_BADPATH = '-1062';
                                    /* Database manager started OK   */
 %dcl SQLE_RC_START_OK char ext;
 %SQLE_RC_START_OK = '-1063';
                                    /* Database manager stopped OK   */
 %dcl SQLE_RC_STOP_OK char ext;
                                    /* N utilities not bound         */
 %SQLE_RC_STOP_OK = '-1064';
 dcl SQLE_RC_DB_BADBINDS fixed bin(31) value(1065);

                                    /* Message file not found - OS2  */
 %dcl SQLE_RC_NOMSG_DB2OS2 char ext;
 %SQLE_RC_NOMSG_DB2OS2 = '-1068';
                                    /* Message file not found - NT   */
 %dcl SQLE_RC_NOMSG_DB2NT char ext;
 %SQLE_RC_NOMSG_DB2NT = '-1068';
                                    /* Message file not found - DOS  */
 %dcl SQLE_RC_NOMSG_DB2DOS char ext;
 %SQLE_RC_NOMSG_DB2DOS = '-1068';
                                    /* Message file not found -      */
                                    /* Windows                       */
 %dcl SQLE_RC_NOMSG_DB2WIN char ext;
 %SQLE_RC_NOMSG_DB2WIN = '-1068';
                                    /* Message file not found - AIX  */
 %dcl SQLE_RC_NOMSG_DB2AIX char ext;
 %SQLE_RC_NOMSG_DB2AIX = '-10007';

 %dcl SQLE_RC_NOMSG char ext;
 %SQLE_RC_NOMSG='SQLE_RC_NOMSG_DB2OS2';
 %dcl @SQLE_RC_NOMSG char ext;
 %@SQLE_RC_NOMSG='@SQLE_RC_NOMSG_DB2OS2';

                                    /* DB invalid type for Drop      */
 %dcl SQLE_RC_INVDROP char ext;
 %SQLE_RC_INVDROP = '-1069';

                                    /* Invalid Database Name         */
                                    /* pointer                       */
 %dcl SQLE_RC_INVDBNAME_PTR char ext;
 %SQLE_RC_INVDBNAME_PTR = '-1070';
                                    /* Invalid Alias pointer         */
 %dcl SQLE_RC_INVALIAS_PTR char ext;
 %SQLE_RC_INVALIAS_PTR = '-1071';
                                    /* Resources in inconsistent     */
                                    /* state                         */
 %dcl SQLE_RC_RESOURCE_ERROR char ext;
 %SQLE_RC_RESOURCE_ERROR = '-1072';
                                    /* Invalid Node Directory        */
                                    /* release                       */
 %dcl SQLE_RC_BAD_ND_REL char ext;
 %SQLE_RC_BAD_ND_REL = '-1073';
                                    /* Invalid Password pointer      */
 %dcl SQLE_RC_INVPSW_PTR char ext;
 %SQLE_RC_INVPSW_PTR = '-1074';
                                    /* Invalid Comment pointer       */
 %dcl SQLE_RC_INVCOMM_PTR char ext;
 %SQLE_RC_INVCOMM_PTR = '-1075';
                                    /* Invalid Count pointer         */
 %dcl SQLE_RC_INVCNT_PTR char ext;
 %SQLE_RC_INVCNT_PTR = '-1076';
                                    /* Invalid Handle pointer        */
 %dcl SQLE_RC_INVHAND_PTR char ext;
 %SQLE_RC_INVHAND_PTR = '-1077';
                                    /* Invalid Buffer pointer        */
 %dcl SQLE_RC_INVBUFF_PTR char ext;
 %SQLE_RC_INVBUFF_PTR = '-1078';
                                    /* Invalid Node pointer          */
 %dcl SQLE_RC_INVNODE_PTR char ext;
 %SQLE_RC_INVNODE_PTR = '-1079';
                                    /* Invalid Userid pointer        */
 %dcl SQLE_RC_INVUSERID_PTR char ext;
 %SQLE_RC_INVUSERID_PTR = '-1150';

                                    /* Invalid Local Lu pointer      */
 %dcl SQLE_RC_INVLLU_PTR char ext;
 %SQLE_RC_INVLLU_PTR = '-1080';
                                    /* Invalid Remote Lu pointer     */
 %dcl SQLE_RC_INVRLU_PTR char ext;
 %SQLE_RC_INVRLU_PTR = '-1081';
                                    /* Invalid Mode pointer          */
 %dcl SQLE_RC_INVMODE_PTR char ext;
 %SQLE_RC_INVMODE_PTR = '-1082';
                                    /* Bad Database Description      */
                                    /* Block                         */
 %dcl SQLE_RC_BAD_DBDB char ext;
 %SQLE_RC_BAD_DBDB = '-1083';
                                    /* Cannot Allocate Kernel        */
                                    /* Segments                      */
 %dcl SQLE_RC_KSEGSFAIL char ext;
 %SQLE_RC_KSEGSFAIL = '-1084';
                                    /* Cannot Allocate Application   */
                                    /* heap                          */
 %dcl SQLE_RC_APPHEAPFAIL char ext;
 %SQLE_RC_APPHEAPFAIL = '-1085';
                                    /* Unexpected OS/2 error         */
 %dcl SQLE_RC_OS2ERROR char ext;
 %SQLE_RC_OS2ERROR = '-1086';
                                    /* Bind list could not be        */
                                    /* opened                        */
 dcl SQLE_RC_BIND_LIST fixed bin(31) value(1087);
                                    /* Error occurred during bind    */
 dcl SQLE_RC_BIND_ERROR fixed bin(31) value(1088);
                                    /* Binding was interrupted       */
 dcl SQLE_RC_BIND_INTRRPT fixed bin(31) value(1089);

                                    /* Release number of appl is     */
                                    /* invalid                       */
 %dcl SQLE_RC_BAD_APP_REL char ext;
 %SQLE_RC_BAD_APP_REL = '-1090';
                                    /* Release number of database    */
                                    /* bad                           */
 %dcl SQLE_RC_BAD_DB_REL char ext;
 %SQLE_RC_BAD_DB_REL = '-1091';

                                    /* Authorization error           */
 %dcl SQLE_RC_INSAUTH char ext;
 %SQLE_RC_INSAUTH = '-1092';
                                    /* User not logged on            */
 %dcl SQLE_RC_NOLOGON char ext;
 %SQLE_RC_NOLOGON = '-1093';
                                    /* Node directory being updated  */
 %dcl SQLE_RC_NDBUSY char ext;
 %SQLE_RC_NDBUSY = '-1094';
                                    /* Max node scans open           */
 %dcl SQLE_RC_MAX_NDSCAN char ext;
 %SQLE_RC_MAX_NDSCAN = '-1095';
                                    /* Invalid type for requester    */
                                    /* node                          */
 %dcl SQLE_RC_REQTYPE char ext;
 %SQLE_RC_REQTYPE = '-1096';
                                    /* Node not found for remote db  */
 %dcl SQLE_RC_NODERR char ext;
 %SQLE_RC_NODERR = '-1097';
                                    /* Appl is already connected to  */
                                    /* db                            */
 %dcl SQLE_RC_APCONN_SAME char ext;
 %SQLE_RC_APCONN_SAME = '-1098';

                                    /* Write protect error on        */
                                    /* diskette                      */
 %dcl SQLE_RC_WRPROT_ERR_DB2OS2 char ext;
 %SQLE_RC_WRPROT_ERR_DB2OS2 = '-1099';
                                    /* Write protect error on        */
                                    /* diskette                      */
 %dcl SQLE_RC_WRPROT_ERR_DB2NT char ext;
 %SQLE_RC_WRPROT_ERR_DB2NT = '-1099';
                                    /* Write protect error on        */
                                    /* diskette                      */
 %dcl SQLE_RC_WRPROT_ERR_DB2DOS char ext;
 %SQLE_RC_WRPROT_ERR_DB2DOS = '-1099';
                                    /* Write protect error on        */
                                    /* diskette                      */
 %dcl SQLE_RC_WRPROT_ERR_DB2WIN char ext;
 %SQLE_RC_WRPROT_ERR_DB2WIN = '-1099';
                                    /* Write protect error on        */
                                    /* filesystem                    */
 %dcl SQLE_RC_WRPROT_ERR_DB2AIX char ext;
 %SQLE_RC_WRPROT_ERR_DB2AIX = '-10021';

 %dcl SQLE_RC_WRPROT_ERR char ext;
 %SQLE_RC_WRPROT_ERR='SQLE_RC_WRPROT_ERR_DB2OS2';
 %dcl @SQLE_RC_WRPROT_ERR char ext;
 %@SQLE_RC_WRPROT_ERR='@SQLE_RC_WRPROT_ERR_DB2OS2';
                                    /* Node not cataloged for        */
                                    /* database                      */

 dcl SQLE_RC_NODE_WARN fixed bin(31) value(1100);
                                    /* Remote communications error   */
 %dcl SQLE_RC_REMCONN_ERR char ext;
 %SQLE_RC_REMCONN_ERR = '-1101';
                                    /* No database name provided in  */
                                    /* call                          */
 %dcl SQLE_RC_MIG_NODB char ext;
 %SQLE_RC_MIG_NODB = '-1102';
                                    /* Migration was successful      */
 dcl SQLE_RC_MIG_OK fixed bin(31) value(1103);
                                    /* Invalid program name pointer  */
 %dcl SQLE_RC_INVPROG_PTR char ext;
 %SQLE_RC_INVPROG_PTR = '-1104';

                                    /* Invalid disconnect from       */
                                    /* database                      */
 %dcl SQLE_RC_INV_SPDB_DB2OS2 char ext;
 %SQLE_RC_INV_SPDB_DB2OS2 = '-1105';
                                    /* Invalid disconnect from       */
                                    /* database                      */
 %dcl SQLE_RC_INV_SPDB_DB2NT char ext;
 %SQLE_RC_INV_SPDB_DB2NT = '-1105';
                                    /* Invalid disconnect from       */
                                    /* database                      */
 %dcl SQLE_RC_INV_SPDB_DB2DOS char ext;
 %SQLE_RC_INV_SPDB_DB2DOS = '-1105';
                                    /* Invalid disconnect from       */
                                    /* database                      */
 %dcl SQLE_RC_INV_SPDB_DB2WIN char ext;
 %SQLE_RC_INV_SPDB_DB2WIN = '-1105';
                                    /* Invalid disconnect from       */
                                    /* database                      */
 %dcl SQLE_RC_INV_SPDB_DB2AIX char ext;
 %SQLE_RC_INV_SPDB_DB2AIX = '-10017';

 %dcl SQLE_RC_INV_SPDB char ext;
 %SQLE_RC_INV_SPDB='SQLE_RC_INV_SPDB_DB2OS2';
 %dcl @SQLE_RC_INV_SPDB char ext;
 %@SQLE_RC_INV_SPDB='@SQLE_RC_INV_SPDB_DB2OS2';

                                    /* Function could not be         */
                                    /* executed                      */
 %dcl SQLE_RC_INVALID_PROC_DB2OS2 char ext;
 %SQLE_RC_INVALID_PROC_DB2OS2 = '-1106';
                                    /* Function could not be         */
                                    /* executed                      */
 %dcl SQLE_RC_INVALID_PROC_DB2NT char ext;
 %SQLE_RC_INVALID_PROC_DB2NT = '-1106';
                                    /* Function could not be         */
                                    /* executed                      */
 %dcl SQLE_RC_INVALID_PROC_DB2DOS char ext;
 %SQLE_RC_INVALID_PROC_DB2DOS = '-1106';
                                    /* Function could not be         */
                                    /* executed                      */
 %dcl SQLE_RC_INVALID_PROC_DB2WIN char ext;
 %SQLE_RC_INVALID_PROC_DB2WIN = '-1106';
                                    /* Function could not be         */
                                    /* executed                      */
 %dcl SQLE_RC_INVALID_PROC_DB2AIX char ext;
 %SQLE_RC_INVALID_PROC_DB2AIX = '-10010';

 %dcl SQLE_RC_INVALID_PROC char ext;
 %SQLE_RC_INVALID_PROC='SQLE_RC_INVALID_PROC_DB2OS2';
 %dcl @SQLE_RC_INVALID_PROC char ext;
 %@SQLE_RC_INVALID_PROC='@SQLE_RC_INVALID_PROC_DB2OS2';

                                    /* Program interrupted - OS/2    */
 %dcl SQLE_RC_INTRP_PROC_DB2OS2 char ext;
 %SQLE_RC_INTRP_PROC_DB2OS2 = '-1107';
                                    /* Program interrupted - NT      */
 %dcl SQLE_RC_INTRP_PROC_DB2NT char ext;
 %SQLE_RC_INTRP_PROC_DB2NT = '-1107';
                                    /* Program interrupted - DOS     */
 %dcl SQLE_RC_INTRP_PROC_DB2DOS char ext;
 %SQLE_RC_INTRP_PROC_DB2DOS = '-1107';
                                    /* Program interrupted -         */
                                    /* Windows                       */
 %dcl SQLE_RC_INTRP_PROC_DB2WIN char ext;
 %SQLE_RC_INTRP_PROC_DB2WIN = '-1107';
                                    /* Program interrupted - AIX     */
 %dcl SQLE_RC_INTRP_PROC_DB2AIX char ext;
 %SQLE_RC_INTRP_PROC_DB2AIX = '-10011';

 %dcl SQLE_RC_INTRP_PROC char ext;
 %SQLE_RC_INTRP_PROC='SQLE_RC_INVALID_PROC_DB2OS2';
 %dcl @SQLE_RC_INTRP_PROC char ext;
 %@SQLE_RC_INTRP_PROC='@SQLE_RC_INVALID_PROC_DB2OS2';

                                    /* System error on library load  */
 %dcl SQLE_RC_SYSERR_PROC_DB2OS2 char ext;
 %SQLE_RC_SYSERR_PROC_DB2OS2 = '-1108';
                                    /* System error on library load  */
 %dcl SQLE_RC_SYSERR_PROC_DB2NT char ext;
 %SQLE_RC_SYSERR_PROC_DB2NT = '-1108';
                                    /* System error on library load  */
 %dcl SQLE_RC_SYSERR_PROC_DB2DOS char ext;
 %SQLE_RC_SYSERR_PROC_DB2DOS = '-1108';
                                    /* System error on library load  */
 %dcl SQLE_RC_SYSERR_PROC_DB2WIN char ext;
 %SQLE_RC_SYSERR_PROC_DB2WIN = '-1108';
                                    /* System error on library load  */
 %dcl SQLE_RC_SYSERR_PROC_DB2AIX char ext;
 %SQLE_RC_SYSERR_PROC_DB2AIX = '-10012';

 %dcl SQLE_RC_SYSERR_PROC char ext;
 %SQLE_RC_SYSERR_PROC='SQLE_RC_SYSERR_PROC_DB2OS2';
 %dcl @SQLE_RC_SYSERR_PROC char ext;
 %@SQLE_RC_SYSERR_PROC='@SQLE_RC_SYSERR_PROC_DB2OS2';

                                    /* Library could not be loaded   */
 %dcl SQLE_RC_NOFILE_PROC_DB2OS2 char ext;
 %SQLE_RC_NOFILE_PROC_DB2OS2 = '-1109';
                                    /* Library could not be loaded   */
 %dcl SQLE_RC_NOFILE_PROC_DB2NT char ext;
 %SQLE_RC_NOFILE_PROC_DB2NT = '-1109';
                                    /* Library could not be loaded   */
 %dcl SQLE_RC_NOFILE_PROC_DB2DOS char ext;
 %SQLE_RC_NOFILE_PROC_DB2DOS = '-1109';
                                    /* Library could not be loaded   */
 %dcl SQLE_RC_NOFILE_PROC_DB2WIN char ext;
 %SQLE_RC_NOFILE_PROC_DB2WIN = '-1109';
                                    /* Library could not be loaded   */
 %dcl SQLE_RC_NOFILE_PROC_DB2AIX char ext;
 %SQLE_RC_NOFILE_PROC_DB2AIX = '-10013';

 %dcl SQLE_RC_NOFILE_PROC char ext;
 %SQLE_RC_NOFILE_PROC='SQLE_RC_NOFILE_PROC_DB2OS2';
 %dcl @SQLE_RC_NOFILE_PROC char ext;
 %@SQLE_RC_NOFILE_PROC='@SQLE_RC_NOFILE_PROC_DB2OS2';

                                    /* Program error                 */
 %dcl SQLE_RC_ERROR_PROC char ext;
 %SQLE_RC_ERROR_PROC = '-1110';

                                    /* Invalid DARI prog name        */
                                    /* format                        */
 %dcl SQLE_RC_BADPGN_PROC_DB2OS2 char ext;
 %SQLE_RC_BADPGN_PROC_DB2OS2 = '-1111';
                                    /* Invalid DARI prog name        */
                                    /* format                        */
 %dcl SQLE_RC_BADPGN_PROC_DB2NT char ext;
 %SQLE_RC_BADPGN_PROC_DB2NT = '-1111';
                                    /* Invalid DARI prog name        */
                                    /* format                        */
 %dcl SQLE_RC_BADPGN_PROC_DB2DOS char ext;
 %SQLE_RC_BADPGN_PROC_DB2DOS = '-1111';
                                    /* Invalid DARI prog name        */
                                    /* format                        */
 %dcl SQLE_RC_BADPGN_PROC_DB2WIN char ext;
 %SQLE_RC_BADPGN_PROC_DB2WIN = '-1111';
                                    /* Invalid DARI prog name        */
                                    /* format                        */
 %dcl SQLE_RC_BADPGN_PROC_DB2AIX char ext;
 %SQLE_RC_BADPGN_PROC_DB2AIX = '-10014';

 %dcl SQLE_RC_BADPGN_PROC char ext;
 %SQLE_RC_BADPGN_PROC='SQLE_RC_BADPGN_PROC_DB2OS2';
 %dcl @SQLE_RC_BADPGN_PROC char ext;
 %@SQLE_RC_BADPGN_PROC='@SQLE_RC_BADPGN_PROC_DB2OS2';

                                    /* Insuf memory to load lib      */
 %dcl SQLE_RC_INSMEM_PROC_DB2OS2 char ext;
 %SQLE_RC_INSMEM_PROC_DB2OS2 = '-1112';
                                    /* Insuf memory to load lib      */
 %dcl SQLE_RC_INSMEM_PROC_DB2NT char ext;
 %SQLE_RC_INSMEM_PROC_DB2NT = '-1112';
                                    /* Insuf memory to load lib      */
 %dcl SQLE_RC_INSMEM_PROC_DB2DOS char ext;
 %SQLE_RC_INSMEM_PROC_DB2DOS = '-1112';
                                    /* Insuf memory to load lib      */
 %dcl SQLE_RC_INSMEM_PROC_DB2WIN char ext;
 %SQLE_RC_INSMEM_PROC_DB2WIN = '-1112';
                                    /* Insuf memory to load lib      */
 %dcl SQLE_RC_INSMEM_PROC_DB2AIX char ext;
 %SQLE_RC_INSMEM_PROC_DB2AIX = '-10015';

 %dcl SQLE_RC_INSMEM_PROC char ext;
 %SQLE_RC_INSMEM_PROC='SQLE_RC_INSMEM_PROC_DB2OS2';
 %dcl @SQLE_RC_INSMEM_PROC char ext;
 %@SQLE_RC_INSMEM_PROC='@SQLE_RC_INSMEM_PROC_DB2OS2';

                                    /* Data type in output SQLDA     */
                                    /* changed                       */
 %dcl SQLE_RC_SQLDA_DATATYPE char ext;
 %SQLE_RC_SQLDA_DATATYPE = '-1113';
                                    /* Data length in output SQLDA   */
                                    /* changed                       */
 %dcl SQLE_RC_SQLDA_LENGTH char ext;
 %SQLE_RC_SQLDA_LENGTH = '-1114';
                                    /* Num of sqlvars changed in     */
                                    /* SQLDA                         */
 %dcl SQLE_RC_SQLDA_VARS char ext;
 %SQLE_RC_SQLDA_VARS = '-1115';
                                    /* Backup pending                */
 %dcl SQLE_RC_BKP_PEND char ext;
 %SQLE_RC_BKP_PEND = '-1116';
                                    /* Roll forward pending          */
 %dcl SQLE_RC_ROLLFWD_PEND char ext;
 %SQLE_RC_ROLLFWD_PEND = '-1117';
                                    /* Need to rerun the Backup      */
                                    /* process                       */
 %dcl SQLE_RC_BKP_INPROG char ext;
 %SQLE_RC_BKP_INPROG = '-1118';
                                    /* Need to rerun the Restore     */
                                    /* process                       */
 %dcl SQLE_RC_RST_INPROG char ext;
 %SQLE_RC_RST_INPROG = '-1119';
                                    /* Need to rerun either Backup   */
                                    /* or Restore process            */
 %dcl SQLE_RC_BR_INPROG char ext;
 %SQLE_RC_BR_INPROG = '-1120';

                                    /* Invalid Node structure        */
                                    /* pointer                       */
 %dcl SQLE_RC_INVNODESTR_PTR char ext;
 %SQLE_RC_INVNODESTR_PTR = '-1121';
                                    /* Invalid Protocol structure    */
                                    /* pointer                       */
 %dcl SQLE_RC_INVPROTOCOL_PTR char ext;
 %SQLE_RC_INVPROTOCOL_PTR = '-1122';
                                    /* Invalid protocol type         */
 %dcl SQLE_RC_INVPROTOCOL char ext;
 %SQLE_RC_INVPROTOCOL = '-1123';
                                    /* Invalid remote workstation    */
                                    /* name                          */
 %dcl SQLE_RC_INVRNNAME char ext;
 %SQLE_RC_INVRNNAME = '-1124';
                                    /* Invalid adapter number        */
 %dcl SQLE_RC_INVADAPTER char ext;
 %SQLE_RC_INVADAPTER = '-1125';
                                    /* Invalid network id            */
 %dcl SQLE_RC_INVNETID char ext;
 %SQLE_RC_INVNETID = '-1126';
                                    /* Invalid real partner LU name  */
 %dcl SQLE_RC_INVPLU char ext;
 %SQLE_RC_INVPLU = '-1127';

                                    /* Insuf system resources for    */
                                    /* DARI                          */
 %dcl SQLE_RC_DARI_INSSYS char ext;
 %SQLE_RC_DARI_INSSYS = '-1129';
                                    /* Max DARI process limit        */
                                    /* reached                       */
 %dcl SQLE_RC_DARI_MAXDARI char ext;
 %SQLE_RC_DARI_MAXDARI = '-1130';
                                    /* DARI process abnormally       */
                                    /* terminated                    */
 %dcl SQLE_RC_DARI_ABEND char ext;
 %SQLE_RC_DARI_ABEND = '-1131';
                                    /* Invalid DB2 request in DARI   */
 %dcl SQLE_RC_DARI_INV_RQST char ext;
 %SQLE_RC_DARI_INV_RQST = '-1132';
                                    /* SQLVAR's sqldata or sqlind    */
                                    /* ptrs were altered             */
 %dcl SQLE_RC_DARI_VAR_POINTER_CHG char ext;
 %SQLE_RC_DARI_VAR_POINTER_CHG = '-1133';
                                    /* DB2 request is not allowed    */
                                    /* when DB auth is client        */
 %dcl SQLE_RC_DARI_RQST_AUTH_ERR char ext;
 %SQLE_RC_DARI_RQST_AUTH_ERR = '-1134';
                                    /* Invalid numsegs on create db  */
 %dcl SQLE_RC_BAD_NUMSEGS char ext;
 %SQLE_RC_BAD_NUMSEGS = '-1135';
                                    /* Invalid extSize on create db  */
 %dcl SQLE_RC_BAD_EXTSIZE char ext;
 %SQLE_RC_BAD_EXTSIZE = '-1136';
                                    /* Mounted Segment Directories   */
                                    /* on a drop database request    */
 %dcl SQLE_RC_MOUNTED_SEGS char ext;
 %SQLE_RC_MOUNTED_SEGS = '-1137';

                                    /* Invalid object specified      */
 %dcl SQLE_RC_INVOS_OBJ char ext;
 %SQLE_RC_INVOS_OBJ = '-1200';
                                    /* Invalid status specified      */
 %dcl SQLE_RC_INVOS_STAT char ext;
 %SQLE_RC_INVOS_STAT = '-1201';
                                    /* Status has not been           */
                                    /* collected                     */
 %dcl SQLE_RC_INVOS_NOSTAT char ext;
 %SQLE_RC_INVOS_NOSTAT = '-1202';
                                    /* No users connected to         */
                                    /* database                      */
 %dcl SQLE_RC_INVOS_NOUSER char ext;
 %SQLE_RC_INVOS_NOUSER = '-1203';
                                    /* Active codepage is not        */
                                    /* supported                     */
 %dcl SQLE_RC_UNSUPP_CODEPG char ext;
 %SQLE_RC_UNSUPP_CODEPG = '-1204';

                                    /* Invalid country information   */
 %dcl SQLE_RC_INV_CNTRYINFO_DB2OS2 char ext;
 %SQLE_RC_INV_CNTRYINFO_DB2OS2 = '-1205';
                                    /* Invalid country information   */
 %dcl SQLE_RC_INV_CNTRYINFO_DB2NT char ext;
 %SQLE_RC_INV_CNTRYINFO_DB2NT = '-1205';
                                    /* Invalid country information   */
 %dcl SQLE_RC_INV_CNTRYINFO_DB2DOS char ext;
 %SQLE_RC_INV_CNTRYINFO_DB2DOS = '-1205';
                                    /* Invalid country information   */
 %dcl SQLE_RC_INV_CNTRYINFO_DB2WIN char ext;
 %SQLE_RC_INV_CNTRYINFO_DB2WIN = '-1205';
                                    /* Invalid country information   */
 %dcl SQLE_RC_INV_CNTRYINFO_DB2AIX char ext;
 %SQLE_RC_INV_CNTRYINFO_DB2AIX = '-10009';

 %dcl SQLE_RC_INV_CNTRYINFO char ext;
 %SQLE_RC_INV_CNTRYINFO='SQLE_RC_INV_CNTRYINFO_DB2OS2';
 %dcl @SQLE_RC_INV_CNTRYINFO char ext;
 %@SQLE_RC_INV_CNTRYINFO='@SQLE_RC_INV_CNTRYINFO_DB2OS2';

                                    /* DB2 Shared Memory Set alloc   */
                                    /* failed                        */
 %dcl SQLE_RC_NO_SHRD_SEG char ext;
 %SQLE_RC_NO_SHRD_SEG = '-1220';
                                    /* ASL heap cannot be allocated  */
 %dcl SQLE_RC_NO_ASL_HEAP char ext;
 %SQLE_RC_NO_ASL_HEAP = '-1221';
                                    /* ASL heap is too small         */
 %dcl SQLE_RC_ASL_TOO_SMALL char ext;
 %SQLE_RC_ASL_TOO_SMALL = '-1222';
                                    /* No more agents available      */
 %dcl SQLE_RC_NO_AGENT_AVAIL char ext;
 %SQLE_RC_NO_AGENT_AVAIL = '-1223';
                                    /* DB2 agent not active          */
 %dcl SQLE_RC_AGENT_GONE char ext;
 %SQLE_RC_AGENT_GONE = '-1224';
                                    /* Op. Sys. couldn't spawn a     */
                                    /* process                       */
 %dcl SQLE_RC_PROC_LIMIT char ext;
 %SQLE_RC_PROC_LIMIT = '-1225';

                                    /* At least one agent not        */
                                    /* forced                        */
 dcl SQLE_RC_AGENT_NOT_FORCED fixed bin(31) value(1230);
                                    /* Invalid Force Users count     */
 %dcl SQLE_RC_INVCOUNT char ext;
 %SQLE_RC_INVCOUNT = '-1231';
                                    /* Invalid Force Users mode      */
 %dcl SQLE_RC_INVFRCE_MODE char ext;
 %SQLE_RC_INVFRCE_MODE = '-1232';

                                    /* Invalid TableSpace            */
                                    /* descriptor                    */
 %dcl SQLE_RC_INV_TBS_DESC char ext;
 %SQLE_RC_INV_TBS_DESC = '-1241';

                                    /* Cannot set connection         */
                                    /* options - existing            */
                                    /* connections                   */
 %dcl SQLE_RC_NO_SETCONNOPT char ext;
 %SQLE_RC_NO_SETCONNOPT = '-1246';

                                    /* db2uexit file not found       */
 %dcl SQLE_RC_NOUEXIT char ext;
 %SQLE_RC_NOUEXIT = '-1267';

 %dcl SQLC_RC_NPIPE_BROKEN char ext;
 %SQLC_RC_NPIPE_BROKEN = '-1281';
 %dcl SQLC_RC_NPIPE_BUSY char ext;
 %SQLC_RC_NPIPE_BUSY = '-1282';
 %dcl SQLC_RC_NPIPE_PIPE_INUSE char ext;
 %SQLC_RC_NPIPE_PIPE_INUSE = '-1283';
 %dcl SQLC_RC_NPIPE_PIPE_NOT_FOUND char ext;
 %SQLC_RC_NPIPE_PIPE_NOT_FOUND = '-1284';
 %dcl SQLC_RC_NPIPE_INVALID_NAME char ext;
 %SQLC_RC_NPIPE_INVALID_NAME = '-1285';
 %dcl SQLC_RC_NPIPE_NO_RESOURCE char ext;
 %SQLC_RC_NPIPE_NO_RESOURCE = '-1286';

                                    /* Directory Services failed     */
 %dcl SQLE_RC_DS_FAILED char ext;
 %SQLE_RC_DS_FAILED = '-1291';
                                    /* Bad global name               */
 %dcl SQLE_RC_DS_BAD_GLB_NAME char ext;
 %SQLE_RC_DS_BAD_GLB_NAME = '-1292';
                                    /* Bad global directory entry    */
 %dcl SQLE_RC_DS_BAD_GLB_DIR_ENTRY char ext;
 %SQLE_RC_DS_BAD_GLB_DIR_ENTRY = '-1293';
                                    /* Bad DIR_PATH_NAME             */
 %dcl SQLE_RC_DS_BAD_DIR_PATH_NAME char ext;
 %SQLE_RC_DS_BAD_DIR_PATH_NAME = '-1294';
                                    /* Bad ROUTE_OBJ_NAME            */
 %dcl SQLE_RC_DS_BAD_ROUTE_NAME char ext;
 %SQLE_RC_DS_BAD_ROUTE_NAME = '-1295';
                                    /* Command not supported         */
 %dcl SQLE_RC_DS_UNSUPPORTED_CMD char ext;
 %SQLE_RC_DS_UNSUPPORTED_CMD = '-1297';

                                    /* DCS Directory file access     */
                                    /* error                         */
 %dcl SQLE_RC_FILEDCS char ext;
 %SQLE_RC_FILEDCS = '-1310';
                                    /* DCS Directory not found       */
 %dcl SQLE_RC_DCSDIR_NF char ext;
                                    /* DCS Directory is empty        */
 %SQLE_RC_DCSDIR_NF = '-1311';
 dcl SQLE_RC_NO_ENTRY fixed bin(31) value(1312);
                                    /* DCS Directory is full         */
 %dcl SQLE_RC_MAX_ENTRY char ext;
 %SQLE_RC_MAX_ENTRY = '-1313';
                                    /* Entry parameter pointer       */
                                    /* invalid                       */
 %dcl SQLE_RC_INVENTRY_PTR char ext;
 %SQLE_RC_INVENTRY_PTR = '-1314';
                                    /* Local DB name has invalid     */
                                    /* chars                         */
 %dcl SQLE_RC_INVLDB char ext;
 %SQLE_RC_INVLDB = '-1315';
                                    /* DCS Directory entry not       */
                                    /* found                         */
 %dcl SQLE_RC_LDB_NF char ext;
 %SQLE_RC_LDB_NF = '-1316';
                                    /* DCS Directory duplicate       */
                                    /* entry                         */
 %dcl SQLE_RC_DUPLDB char ext;
 %SQLE_RC_DUPLDB = '-1317';
                                    /* Invalid element length        */
 %dcl SQLE_RC_INVLENGTH char ext;
 %SQLE_RC_INVLENGTH = '-1318';
                                    /* Entries have not been         */
                                    /* collected                     */
 %dcl SQLE_RC_ENTRYNOT_COL char ext;
 %SQLE_RC_ENTRYNOT_COL = '-1319';

                                    /* Cannot access DCS Dir at      */
                                    /* this time                     */
 %dcl SQLE_RC_GDBUSY char ext;
 %SQLE_RC_GDBUSY = '-1320';
                                    /* Invalid structure ID          */
 %dcl SQLE_RC_INVSTRUCT_ID char ext;
 %SQLE_RC_INVSTRUCT_ID = '-1321';
                                    /* Remote function not           */
                                    /* supported                     */
 %dcl SQLE_RC_DRDANSP char ext;
 %SQLE_RC_DRDANSP = '-1325';
                                    /* File or directory access      */
                                    /* denied                        */
 %dcl SQLE_RC_ACCD char ext;
 %SQLE_RC_ACCD = '-1326';
                                    /* Implicit connect - invalid    */
                                    /* dbname                        */
 %dcl SQLE_RC_IMPLCONN_INVDB char ext;
 %SQLE_RC_IMPLCONN_INVDB = '-1327';
                                    /* Implicit connect - alias not  */
                                    /* found                         */
 %dcl SQLE_RC_IMPLCONN_NODB char ext;
 %SQLE_RC_IMPLCONN_NODB = '-1328';
                                    /* Input path too long           */
 %dcl SQLE_RC_PATH_TOO_LONG char ext;
 %SQLE_RC_PATH_TOO_LONG = '-1329';

                                    /* Invalid symbolic destination  */
                                    /* name                          */
 %dcl SQLE_RC_INVSDNAME char ext;
 %SQLE_RC_INVSDNAME = '-1330';
                                    /* Invalid CPIC security type    */
 %dcl SQLE_RC_INVSTYPE char ext;
 %SQLE_RC_INVSTYPE = '-1331';
                                    /* Invalid Host Name             */
 %dcl SQLE_RC_INV_HOSTNAME char ext;
 %SQLE_RC_INV_HOSTNAME = '-1332';
                                    /* Invalid Service Name          */
 %dcl SQLE_RC_INV_SERNAME char ext;
 %SQLE_RC_INV_SERNAME = '-1333';

                                    /* Double-hops not allowed       */
 %dcl SQLE_RC_DOUBLE_REMOTE char ext;
 %SQLE_RC_DOUBLE_REMOTE = '-1334';
                                    /* AR name has invalid chars     */
 %dcl SQLE_RC_INVAR char ext;
 %SQLE_RC_INVAR = '-1335';

                                    /* File server is unknown        */
 %dcl SQLE_RC_UNKNOWN_FILESERVER char ext;
 %SQLE_RC_UNKNOWN_FILESERVER = '-1340';
                                    /* Invalid File Server           */
 %dcl SQLE_RC_INV_FSERVER char ext;
 %SQLE_RC_INV_FSERVER = '-1342';
                                    /* Invalid Object Name           */
 %dcl SQLE_RC_INV_OBJNAME char ext;
 %SQLE_RC_INV_OBJNAME = '-1343';

                                    /* Backup or Restore is active   */
 %dcl SQLE_RC_BR_ACTIVE char ext;
 %SQLE_RC_BR_ACTIVE = '-1350';

                                    /* Invalid Instance Name         */
 %dcl SQLE_RC_INV_INSTANCE char ext;
 %SQLE_RC_INV_INSTANCE = '-1390';
                                    /* Another Instance is using     */
                                    /* the DB                        */
 %dcl SQLE_RC_INSTANCE_USING char ext;
 %SQLE_RC_INSTANCE_USING = '-1391';
                                    /* Invalid DB2 Path Name         */
 %dcl SQLE_RC_INV_DB2PATH char ext;
 %SQLE_RC_INV_DB2PATH = '-1393';

                                    /* Unsupported authentication    */
                                    /* type                          */
 %dcl SQLE_RC_BAD_AUTH char ext;
 %SQLE_RC_BAD_AUTH = '-1400';
                                    /* Authentication types do not   */
                                    /* match                         */
 %dcl SQLE_RC_DIFF_AUTH char ext;
 %SQLE_RC_DIFF_AUTH = '-1401';
                                    /* Authentication failed due to  */
                                    /* unexpected error              */
 %dcl SQLE_RC_AUTH_ERR char ext;
 %SQLE_RC_AUTH_ERR = '-1402';
                                    /* Invalid user name and/or      */
                                    /* password                      */
 %dcl SQLE_RC_AUTH_FAILURE char ext;
 %SQLE_RC_AUTH_FAILURE = '-1403';
                                    /* Password has expired          */
 %dcl SQLE_RC_PASSWORD_EXPIRED char ext;
 %SQLE_RC_PASSWORD_EXPIRED = '-1404';
                                          /* Password without        */
                                          /* userid                  */
 %dcl SQLE_RC_PASSWORD_WITHOUT_USERID char ext;
 %SQLE_RC_PASSWORD_WITHOUT_USERID = '-1425';
                                          /* Error getting           */
                                          /* DB2INSTDFT              */
 %dcl SQLE_RC_DB2INSTDFT_ERROR char ext;
 %SQLE_RC_DB2INSTDFT_ERROR = '-1426';
                                          /* No current attachment   */
 %dcl SQLE_RC_NOT_INSTANCE_ATTACHED char ext;
 %SQLE_RC_NOT_INSTANCE_ATTACHED = '-1427';
                                          /* Attached to wrong       */
                                          /* instance                */
 %dcl SQLE_RC_WRONG_ATTACH char ext;
 %SQLE_RC_WRONG_ATTACH = '-1428';
                                          /* Relative path not       */
                                          /* allowed                 */
 %dcl SQLE_RC_RELPATH_NOT_ALLOWED char ext;
 %SQLE_RC_RELPATH_NOT_ALLOWED = '-1431';

                                    /* Invalid registration info.    */
                                    /* ptr.                          */
 %dcl SQLE_RC_INVREGINFO_PTR char ext;
 %SQLE_RC_INVREGINFO_PTR = '-1450';
                                    /* Reg. issued from invalid      */
                                    /* node                          */
 %dcl SQLE_RC_REG_INVNODE char ext;
 %SQLE_RC_REG_INVNODE = '-1451';
                                    /* Invalid registration          */
                                    /* location                      */
 %dcl SQLE_RC_INVREGLOC char ext;
 %SQLE_RC_INVREGLOC = '-1452';
                                    /* Invalid file server in DBM    */
                                    /* cfg.                          */
 %dcl SQLE_RC_INVCFG_FSNAME char ext;
 %SQLE_RC_INVCFG_FSNAME = '-1453';
                                    /* Invalid object name in DBM    */
                                    /* cfg.                          */
 %dcl SQLE_RC_INVCFG_OBJNAME char ext;
 %SQLE_RC_INVCFG_OBJNAME = '-1454';
                                    /* Invalid IPX socket in DBM     */
                                    /* cfg.                          */
 %dcl SQLE_RC_INVCFG_IPXSOCKET char ext;
 %SQLE_RC_INVCFG_IPXSOCKET = '-1455';
                                    /* Object name already exists    */
 %dcl SQLE_RC_DUPLICATE_OBJNAME char ext;
 %SQLE_RC_DUPLICATE_OBJNAME = '-1456';
                                    /* NWDS connection exists,       */
                                    /* cannot log into NW            */
                                    /* fileserver                    */
 %dcl SQLE_RC_NWDS_CONNEXISTS char ext;
 %SQLE_RC_NWDS_CONNEXISTS = '-1457';
                                    /* DB2 server reg./dereg. not    */
                                    /* needed                        */
 %dcl SQLE_RC_REG_NOT_NEEDED char ext;
 %SQLE_RC_REG_NOT_NEEDED = '-1458';

                                    /* Function is no longer         */
                                    /* supported                     */
 %dcl SQLE_RC_UNSUPP_FUNCTION char ext;
 %SQLE_RC_UNSUPP_FUNCTION = '-1650';

                                    /* Invalid Schema name found     */
 %dcl SQLE_RC_INV_SCHEMA char ext;
 %SQLE_RC_INV_SCHEMA = '-1700';
                                    /* DB cannot be migrated         */
 %dcl SQLE_RC_DB_NOT_MIGR char ext;
 %SQLE_RC_DB_NOT_MIGR = '-1701';
                                    /* Fail to create db2event dir   */
 %dcl SQLE_RC_CRT_EVENT_FAIL char ext;
 %SQLE_RC_CRT_EVENT_FAIL = '-1703';
                                    /* DB migration failed           */
 %dcl SQLE_RC_DB_MIG_FAIL char ext;
 %SQLE_RC_DB_MIG_FAIL = '-1704';
                                    /* Fail to update directory      */
                                    /* entry                         */
 dcl SQLE_RC_UPDATE_DIR_FAIL fixed bin(31) value(1705);

                                    /* Communications support        */
                                    /* failed                        */
 dcl SQLE_RC_COMM_FAILED fixed bin(31) value(5043);

                                    /* No DB2/6000 license           */
 %dcl SQLE_RC_DB2_SERVER_LICENSE char ext;
 %SQLE_RC_DB2_SERVER_LICENSE = '-8000';
                                    /* Out of DB2 client licenses    */
 %dcl SQLE_RC_DB2_LICENSE char ext;
 %SQLE_RC_DB2_LICENSE = '-8001';
                                    /* Out of DDCS clients           */
 %dcl SQLE_RC_DDCS_LICENSE char ext;
 %SQLE_RC_DDCS_LICENSE = '-8002';

 /********************************************************************/
 /**                                                                 */
 /** The following functions and symbols are obsolete and may not be */
 /** supported in future releases. The obsolete functions are provide*/
 /** for backward compatibility and exported from DB2API.LIB. All    */
 /** applications should be migrated to use new APIs.                */
 /** Note: Some of the function parameters may be NO-OP.             */
 /**       Some structures are larger (eg. SQLEDINFO) in V2.         */
 /**                                                                 */
 /********************************************************************/
                                    /* Invalid numsegs on create db  */
 %dcl SQLE_RC_BAD_SEGPAGES char ext;
 %SQLE_RC_BAD_SEGPAGES = '-1136';

                                    /* No CS/6000 license            */
 %dcl SQLE_RC_CS_LICENSE char ext;
 %SQLE_RC_CS_LICENSE = '-8003';
                                    /* No SNA/6000 license           */
 %dcl SQLE_RC_SNA_LICENSE char ext;
 %SQLE_RC_SNA_LICENSE = '-8004';

                                    /* Authentication Undefined      */
 dcl SQL_AUTHENTICATION_UNDEF fixed bin(31) value(255);

                                    /* Startdbm OK, but some comm.   */
                                    /* failed                        */
 %dcl SQLE_RC_STARTED_NO_COMM char ext;
 %SQLE_RC_STARTED_NO_COMM = '-1066';
                                    /* Stopdbm failed                */
 %dcl SQLE_RC_STOP_FAILED char ext;
 %SQLE_RC_STOP_FAILED = '-1067';

 %dcl SQLZ_STACK char ext;
 %if ^(SQLZ_STACK^='') %then
  %do;
 %dcl SQL_REL_10 char ext;
    %if (SQL_REL_10^='') %then
     %do;

     %end;
  %else
     %do;

  %end;

  %end;

 /* Sizes for entries in sqlesystat & sqleusrstat */
                                    /* Component Id                  */
 dcl SQL_COMPID_SZ fixed bin(31) value(9);
                                    /* Corrective serv level         */
 dcl SQL_CORRLVL_SZ fixed bin(31) value(8);
                                    /* Release level                 */
 dcl SQL_RLSLVL_SZ fixed bin(31) value(4);

 /* Defines for STATUS parameter on Collect Database Status */
                                    /* Collect system status         */
 dcl SQL_OPSTAT_SYSTEM fixed bin(31) value(1);
                                    /* Collect database stat         */
 dcl SQL_OPSTAT_DATABASE fixed bin(31) value(2);
                                    /* Collect all status            */
 dcl SQL_OPSTAT_ALL fixed bin(31) value(3);

 /* Defines for OBJECT parameter on Collect Database Status  */
                                    /* Specified database            */
 dcl SQL_OBJECT_DATABASE fixed bin(31) value(1);
                                    /* Specified drive               */
 dcl SQL_OBJECT_DRIVE fixed bin(31) value(2);
                                    /* All local databases           */
 dcl SQL_OBJECT_LOCAL fixed bin(31) value(3);

 /* Defines for 'location' field in sqledbstat */
 dcl SQL_LOCAL_TYPE char value('L');
 dcl SQL_REMOTE_TYPE char value('R');

 /* Defines for 'trans_state' field in sqleusrstat */
 dcl SQL_TRANS_STATE_STARTED char value('S');
 dcl SQL_TRANS_STATE_READ char value('R');
 dcl SQL_TRANS_STATE_CHANGED char value('C');

 /* Defines for 'lock_state' field in sqleusrstat  */
 dcl SQL_LOCK_STATE_WAIT char value('W');
 dcl SQL_LOCK_STATE_NOWAIT char value('N');

 /********************************************************************/
 /** Collect Database Status data structures                         */
 /********************************************************************/

 define structure
    1 sqlesystat,                           /* System Status data    */
                                                        /* structure */
    2 current_time unsigned fixed bin(31) ,
    2 time_zone_disp fixed bin(31),
    2 product_name char(SQL_PRODNAME_SZ) ,
    2 component_id char(SQL_COMPID_SZ) ,
    2 reserved char,/* Reserved byte */
    2 release_lvl char(SQL_RLSLVL_SZ) ,
    2 corr_serv_lvl char(SQL_CORRLVL_SZ) ;



 define structure
    1 sqledbstat,                           /* Database Status data  */
                                                        /* structure */
     2 backup_time unsigned fixed bin(31) ,      /* Last backup time */
     2 time_zone_disp fixed bin(31),          /* Time zone of backup */
                                                             /* time */
     2 connects unsigned fixed bin(16) ,        /* Number of current */
                                                            /* users */
     2 db_alias char(SQL_DBSTAT_ALIAS_SZ) ,          /* Alias name */
    2 db_name char(SQL_DBSTAT_DBNAME_SZ) ,        /* Database name */
     2 location char,                              /* Local / Remote */
                                                         /* Database */
     2 reserved char,                               /* Reserved byte */
     2 drive char(SQL_DRIVE_SZ) ,              /* Drive containing */
                                                         /* database */
     2 node char(SQL_NNAME_SZ) ,                /* Node containing */
                                                         /* database */
     2 db_type char(SQL_DBTYP_SZ) ;                     /* OS2 DBM */



 define structure
    1 sqleusrstat,                          /* User Status data      */
                                                        /* structure */
     2 con_trans unsigned fixed bin(31) ,      /* Transactions since */
                                                          /* connect */
     2 con_reqs unsigned fixed bin(31) ,           /* Requests since */
                                                          /* connect */
     2 cur_reqs unsigned fixed bin(31) ,         /* Requests current */
                                                         /* transact */
     2 connect_time unsigned fixed bin(31) ,   /* Time since connect */
     2 trans_time unsigned fixed bin(31) ,     /* Time since current */
                                                         /* transact */
     2 authid char(SQL_USERID_SZ) ,                   /* User's Id */
     2 node char(SQL_NNAME_SZ) ,                    /* Nodename of */
                                                   /* connected user */
     2 authority_lvl unsigned fixed bin(16) ,    /* User's authority */
                                                            /* level */
     2 trans_state char,                        /* Transaction state */
     2 lock_state char;                          /* Transaction lock */
                                                            /* state */


                                            /* ALTER DATABASE        */
                                            /* PASSWORD              */
 dcl   sqlealtd_api  entry (
        pointer,                            /* Database name         */
        pointer,                            /* Old Password          */
        pointer,                            /* New Password          */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CATALOG DATABASE      */
 dcl   sqlecatd_api  entry (
        pointer,                            /* database              */
        pointer,                            /* alias                 */
        char,                               /* type                  */
        pointer,                            /* nodename              */
        char,                               /* drive                 */
        pointer,                            /* comment               */
        fixed bin(15),                      /* comment code page     */
                                            /* (no-op)               */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CATALOG NODE          */
 dcl   sqlecatn_api  entry (
        pointer,                            /* nodename              */
        pointer,                            /* local LU              */
        pointer,                            /* remote LU             */
        pointer,                            /* mode (no-op)          */
        pointer,                            /* comment               */
        fixed bin(15),                      /* comment code page     */
                                            /* (no-op)               */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CREATE DATABASE       */
 dcl   sqlecrdb_api  entry (
        pointer,                            /* database              */
        char,                               /* drive                 */
        handle sqledbdesc,                  /* database description  */
                                            /* block                 */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CREATE DATABASE       */
 dcl   sqlecred_api  entry (
        pointer,                            /* database              */
        char,                               /* drive                 */
        pointer,                            /* password (no-op)      */
        pointer,                            /* comment               */
        fixed bin(15),                      /* comment code page     */
                                            /* (no-op)               */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CHANGE DATABASE       */
                                            /* COMMENT               */
 dcl   sqledchg_api  entry (
        pointer,                            /* database              */
        char,                               /* drive                 */
        pointer,                            /* comment               */
        fixed bin(15),                      /* comment code page     */
                                            /* (no-op)               */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* OPEN DIRECTORY SCAN   */
 dcl   sqledops_api  entry (
        char,                               /* drive                 */
        pointer,                            /* handle                */
        pointer,                            /* count                 */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* FREE DATABASE STATUS  */
                                            /* RESOURCES             */
 dcl   sqlefree_api  entry (
         pointer )                          /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* FORCE USERS OFF       */
                                            /* DATABASE & STOPDBM    */
 dcl   sqlekill  entry (
         pointer )                          /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* MIGRATE DATABASE      */
 dcl   sqlemigd_api  entry (
        pointer,                            /* database name         */
        pointer,                            /* password (no-op)      */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* GET NEXT DATABASE     */
                                            /* STATUS BLOCK          */
 dcl   sqlenext_api  entry (
        pointer,                            /* counter pointer       */
        pointer,                            /* buffer pointer        */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* RESTORE DATABASE      */
 dcl   sqlerest_api  entry (
        pointer,                            /* database              */
        pointer,                            /* password (no-op)      */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* COLLECT DATABASE      */
                                            /* STATUS                */
 dcl   sqlestat_api  entry (
        unsigned fixed bin(16),             /* status requested      */
        unsigned fixed bin(16),             /* object type           */
        unsigned fixed bin(16),             /* length of object      */
        pointer,                            /* object pointer        */
        pointer,                            /* count pointer         */
        pointer,                            /* buffer pointer        */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* STOP USING DATABASE   */
 dcl   sqlestpd_api  entry (
         pointer )                          /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* START USING DATABASE  */
 dcl   sqlestrd_api  entry (
        pointer,                            /* database name         */
        pointer,                            /* password (no-op)      */
        char,                               /* use (no-op)           */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* GET USER STATUS       */
 dcl   sqleuser_api  entry (
        unsigned fixed bin(16),             /* length of db name     */
        pointer,                            /* database name         */
        pointer,                            /* buffer pointer        */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* ALTER DATABASE        */
                                            /* PASSWORD              */
 dcl   SQLGALTD  entry (
        unsigned fixed bin(16),             /* new password length   */
        unsigned fixed bin(16),             /* old password length   */
        unsigned fixed bin(16),             /* database length       */
        pointer,                            /* SQLCA                 */
        pointer,                            /* new password          */
        pointer,                            /* old password          */
         pointer)                           /* database              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CATALOG DATABASE      */
 dcl   SQLGCATD  entry (
        unsigned fixed bin(16),             /* comment length        */
        unsigned fixed bin(16),             /* node name length      */
        unsigned fixed bin(16),             /* alias length          */
        unsigned fixed bin(16),             /* database length       */
        char,                               /* drive                 */
        fixed bin(15),                      /* comment code page     */
                                            /* (no-op)               */
        char,                               /* type                  */
        pointer,                            /* SQLCA                 */
        pointer,                            /* comment               */
        pointer,                            /* nodename              */
        pointer,                            /* alias                 */
         pointer)                           /* database              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CATALOG NODE          */
 dcl   SQLGCATN  entry (
        unsigned fixed bin(16),             /* comment length        */
        unsigned fixed bin(16),             /* mode length           */
        unsigned fixed bin(16),             /* partner LU length     */
        unsigned fixed bin(16),             /* local LU length       */
        unsigned fixed bin(16),             /* Node Name length      */
        unsigned fixed bin(16),             /* Code page             */
        pointer,                            /* SQLCA                 */
        pointer,                            /* comment               */
        pointer,                            /* mode (no-op)          */
        pointer,                            /* nodename              */
        pointer,                            /* partner LU            */
         pointer)                           /* local LU              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CREATE DATABASE       */
 dcl   SQLGCRDB  entry (
        unsigned fixed bin(16),             /* Database Length       */
        char,                               /* drive                 */
        pointer,                            /* SQLCA                 */
        pointer,                            /* database              */
         handle sqledbdesc)                 /* database description  */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;
 /* block                 */

                                            /* CREATE DATABASE       */
 dcl   SQLGCRED  entry (
        unsigned fixed bin(16),             /* comment length        */
        unsigned fixed bin(16),             /* password (no-op)      */
        unsigned fixed bin(16),             /* database length       */
        char,                               /* drive                 */
        fixed bin(15),                      /* comment code page     */
                                            /* (no-op)               */
        pointer,                            /* comment               */
        pointer,                            /* SQLCA                 */
        pointer,                            /* password (no-op)      */
         pointer)                           /* database              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CHANGE DATABASE       */
                                            /* COMMENT               */
 dcl   SQLGDCHG  entry (
        unsigned fixed bin(16),             /* comment length        */
        unsigned fixed bin(16),             /* database length       */
        fixed bin(15),                      /* comment code page     */
                                            /* (no-op)               */
        char,                               /* drive                 */
        pointer,                            /* SQLCA                 */
        pointer,                            /* comment               */
         pointer)                           /* database              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* OPEN DIRECTORY SCAN   */
 dcl   SQLGDOPS  entry (
        char,                               /* drive                 */
        pointer,                            /* handle                */
        pointer,                            /* count                 */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* FREE DATABASE STATUS  */
                                            /* RESOURCES             */
 dcl   SQLGFREE  entry (
         pointer )                          /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* MIGRATE DATABASE      */
 dcl   SQLGMIGD  entry (
        unsigned fixed bin(16),             /* database length       */
        unsigned fixed bin(16),             /* password length       */
        pointer,                            /* database name         */
        pointer,                            /* password (no-op)      */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* GET NE)T DATABASE     */
                                            /* STATUS BLOCK          */
 dcl   SQLGNEXT  entry (
        pointer,                            /* counter pointer       */
        pointer,                            /* buffer pointer        */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* RESTORE DATABASE      */
 dcl   SQLGREST  entry (
        unsigned fixed bin(16),             /* password length       */
        unsigned fixed bin(16),             /* database length       */
        pointer,                            /* SQLCA                 */
        pointer,                            /* password (no-op)      */
         pointer)                           /* database              */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* COLLECT DATABASE      */
                                            /* STATUS                */
 dcl   SQLGOPST  entry (
        unsigned fixed bin(16),             /* status requested      */
        unsigned fixed bin(16),             /* object type           */
        unsigned fixed bin(16),             /* length of object      */
        pointer,                            /* object pointer        */
        pointer,                            /* count pointer         */
        pointer,                            /* buffer pointer        */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* STOP USING DATABASE   */
 dcl   SQLGSTPD  entry (
         pointer )                          /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* START USING DATABASE  */
 dcl   SQLGSTRD  entry (
        unsigned fixed bin(16),             /* password length       */
        unsigned fixed bin(16),             /* database length       */
        char,                               /* use (no-op)           */
        pointer,                            /* SQLCA                 */
        pointer,                            /* password (no-op)      */
         pointer)                           /* database name         */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* GET USER STATUS       */
 dcl   SQLGUSER  entry (
        unsigned fixed bin(16),             /* length of db name     */
        pointer,                            /* database name         */
        pointer,                            /* buffer pointer        */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                            /* CREATE DATABASE       */
 dcl   sqledbcr_api  entry (
        pointer,                            /* database              */
        pointer,                            /* drive/path            */
        handle sqledbdesc,                  /* db description block  */
        unsigned fixed bin(16),             /* authentication        */
        handle sqledbcinfo,                 /* database country      */
                                            /* info                  */
         pointer)                           /* SQLCA                 */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

 /********************************************************************/
 /**                                                                 */
 /** End of obsolete functions and symbols                           */
 /**                                                                 */
 /********************************************************************/

  %end;
 /* SQL_H_SQLENV */
