/*******************************************************************/
/*                                                                 */
/*    Licensed Materials - Property of IBM                         */
/*    5639-A83, 5639-A24 (C) Copyright IBM Corp. 1992,1996.        */
/*    All Rights Reserved.                                         */
/*    US Government Users Restricted Rights-- Use, duplication or  */
/*    disclosure restricted by GSA ADP Schedule Contract with      */
/*    IBM Corp.                                                    */
/*                                                                 */
/*  DISCLAIMER OF WARRANTIES                                       */
/*    The following enclosed code is sample code created by IBM  */
/*    Corporation. This sample code is not part of any standard    */
/*    IBM product and is provided to you solely for the purpose of */
/*    assisting you in the development of your applications.  The  */
/*    code is provided "AS IS", without warranty of any kind.      */
/*    IBM shall not be liable for any damages arising out of your  */
/*    use of the sample code, even if IBM has been advised of the  */
/*    possibility of such damages.                                 */
/*                                                                 */
/*                                                                 */
/* This is a REXX program that calls a PL/I function compiled and  */
/* and linked as a DLL passing it a string "Hello World".  The PL/I*/
/* funtion receives the string and then returns the same string    */
/* to this calling REXX program.  This program prints the string   */
/* before and after the PL/I call to verify that nothing changes.  */
/*                                                                 */
/*******************************************************************/
  signal on error
  signal on notready
  signal on syntax

  say "Rexx program started."

  /***************************************************/
  /*  Initialize Job_parm with 'Hello World' and     */
  /*  pass it to the PL/I program.                   */
  /***************************************************/
  Job_parm ='Hello World'

  /***************************************************/
  /*  Register the function name, making it          */
  /*  available to REXX procedures.  A zero return   */
  /*  value signifies successful registration.       */
  /***************************************************/
  rc = RxFuncAdd('STRING_PASS','REXXPLID','STRING_PASS')
  if rc \= 0 then
    do
      say "RxFuncAdd Failed!"
      exit
    end

  /***************************************************/
  /*  Call PL/I program passing 'Hello World' as a   */
  /*  parameter.  Upon return, Ret_string should     */
  /*  contain the return value 'Hello World'.        */
  /***************************************************/
  say "Calling PL/I program."
  Ret_string = STRING_PASS(Job_parm)

  Say "Parameter passed    = " Job_parm
  Say "Parameter returned  = " Ret_string

  /***************************************************/
  /*  Removes (deregisters) the function name from   */
  /*  the list of available functions. A zero return */
  /*  value signifies successful removal.            */
  /***************************************************/
  rc=RxFuncDrop('STRING_PASS')
  if rc \= 0 then
    do
      say "RxFuncDrop Failed!"
      exit
    end
  say "Rexx program ended."
