 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMBITMAP.CPY                                 */
 /*                                                                  */
 /*  NAME - PMBITMAP.CPY                                             */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* This is the file format structure for Bit Maps, Pointers and     */
 /* Icons as stored in the resource file of a PM application.        */
 /*                                                                  */
 /* Notes on file format:                                            */
 /*                                                                  */
 /* Each BITMAPFILEHEADER entry is immediately followed by the color */
 /* table for the bit map bits it references.                        */
 /* Icons and Pointers contain two BITMAPFILEHEADERs for each        */
 /* ARRAYHEADER item.  The first one is for the ANDXOR mask, the     */
 /* second is for the COLOR mask.  All offsets are absolute based    */
 /* on the start of the FILE.                                        */
 /*                                                                  */
 /* For OS/2 Version 2.0 and later BITMAPFILEHEADER2 and the other   */
 /* '2' versions of each structure are recommended. Use the non-2    */
 /* versions of each structure if compatibility with OS/2 Version    */
 /* 1.X is required.                                                 */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %if PMBITMAP_INCLUDED='Y' %then %do;
   %PMBITMAP_INCLUDED='Y';
   %declare BITMAPINFOHEADER char;
   %BITMAPINFOHEADER='char(stg(#BITMAPINFOHEADER))';
   dcl 1 #BITMAPINFOHEADER based(null()) unaligned,
         2 cbFix ULONG,
         2 cx USHORT,
         2 cy USHORT,
         2 cPlanes USHORT,
         2 cBitCount USHORT;
   %declare PBITMAPINFOHEADER char;
   %PBITMAPINFOHEADER='pointer';
   %declare RGB char;
   %RGB='char(stg(#RGB))';
   dcl 1 #RGB based(null()) unaligned,
         2 bBlue BYTE,
         2 bGreen BYTE,
         2 bRed BYTE;
   %declare BITMAPINFO char;
   %BITMAPINFO='char(stg(#BITMAPINFO))';
   dcl 1 #BITMAPINFO based(null()) unaligned,
         2 cbFix ULONG,
         2 cx USHORT,
         2 cy USHORT,
         2 cPlanes USHORT,
         2 cBitCount USHORT,
         2 argbColor(1) RGB;
   %declare PBITMAPINFO char;
   %PBITMAPINFO='pointer';
   %declare CBD_COMPRESSION char;
   %CBD_COMPRESSION=1;
   %declare CBD_DECOMPRESSION char;
   %CBD_DECOMPRESSION=2;
   %declare CBD_BITS char;
   %CBD_BITS=0;

   declare CBD_COLOR_CONVERSION fixed bin(31) value('00_00_00_01'xn);
   %declare BCA_UNCOMP char;
   %BCA_UNCOMP=0;
   %declare BCA_HUFFMAN1D char;
   %BCA_HUFFMAN1D=3;
   %declare BCA_RLE4 char;
   %BCA_RLE4=2;
   %declare BCA_RLE8 char;
   %BCA_RLE8=1;
   %declare BCA_RLE24 char;
   %BCA_RLE24=4;
   %declare BRU_METRIC char;
   %BRU_METRIC=0;
   %declare BRA_BOTTOMUP char;
   %BRA_BOTTOMUP=0;
   %declare BRH_NOTHALFTONED char;
   %BRH_NOTHALFTONED=0;
   %declare BRH_ERRORDIFFUSION char;
   %BRH_ERRORDIFFUSION=1;
   %declare BRH_PANDA char;
   %BRH_PANDA=2;
   %declare BRH_SUPERCIRCLE char;
   %BRH_SUPERCIRCLE=3;
   %declare BCE_PALETTE char;
   %BCE_PALETTE=-1;
   %declare BCE_RGB char;
   %BCE_RGB=0;
   %declare BITMAPINFOHEADER2 char;
   %BITMAPINFOHEADER2='char(stg(#BITMAPINFOHEADER2))';
   dcl 1 #BITMAPINFOHEADER2 based(null()) unaligned,
         2 cbFix ULONG,
         2 cx ULONG,
         2 cy ULONG,
         2 cPlanes USHORT,
         2 cBitCount USHORT,
         2 ulCompression ULONG,
         2 cbImage ULONG,
         2 cxResolution ULONG,
         2 cyResolution ULONG,
         2 cclrUsed ULONG,
         2 cclrImportant ULONG,
         2 usUnits USHORT,
         2 usReserved USHORT,
         2 usRecording USHORT,
         2 usRendering USHORT,
         2 cSize1 ULONG,
         2 cSize2 ULONG,
         2 ulColorEncoding ULONG,
         2 ulIdentifier ULONG;
   %declare PBITMAPINFOHEADER2 char;
   %PBITMAPINFOHEADER2='pointer';
   %declare RGB2 char;
   %RGB2='char(stg(#RGB2))';
   dcl 1 #RGB2 based(null()) unaligned,
         2 bBlue BYTE,
         2 bGreen BYTE,
         2 bRed BYTE,
         2 fcOptions BYTE;
   %declare PRGB2 char;
   %PRGB2='pointer';
   %declare BITMAPINFO2 char;
   %BITMAPINFO2='char(stg(#BITMAPINFO2))';
   dcl 1 #BITMAPINFO2 based(null()) unaligned,
         2 cbFix ULONG,
         2 cx ULONG,
         2 cy ULONG,
         2 cPlanes USHORT,
         2 cBitCount USHORT,
         2 ulCompression ULONG,
         2 cbImage ULONG,
         2 cxResolution ULONG,
         2 cyResolution ULONG,
         2 cclrUsed ULONG,
         2 cclrImportant ULONG,
         2 usUnits USHORT,
         2 usReserved USHORT,
         2 usRecording USHORT,
         2 usRendering USHORT,
         2 cSize1 ULONG,
         2 cSize2 ULONG,
         2 ulColorEncoding ULONG,
         2 ulIdentifier ULONG,
         2 argbColor(1) RGB2;
   %declare PBITMAPINFO2 char;
   %PBITMAPINFO2='pointer';
   %declare BITMAPFILEHEADER char;
   %BITMAPFILEHEADER='char(stg(#BITMAPFILEHEADER))';
   dcl 1 #BITMAPFILEHEADER based(null()) unaligned,
         2 usType USHORT,
         2 cbSize ULONG,
         2 xHotspot SHORT,
         2 yHotspot SHORT,
         2 offBits ULONG,
         2 bmp BITMAPINFOHEADER;
   %declare PBITMAPFILEHEADER char;
   %PBITMAPFILEHEADER='pointer';
   %declare BITMAPARRAYFILEHEADER char;
   %BITMAPARRAYFILEHEADER='char(stg(#BITMAPARRAYFILEHEADER))';
   dcl 1 #BITMAPARRAYFILEHEADER based(null()) unaligned,
         2 usType USHORT,
         2 cbSize ULONG,
         2 offNext ULONG,
         2 cxDisplay USHORT,
         2 cyDisplay USHORT,
         2 bfh BITMAPFILEHEADER;
   %declare PBITMAPARRAYFILEHEADER char;
   %PBITMAPARRAYFILEHEADER='pointer';
   %declare BITMAPFILEHEADER2 char;
   %BITMAPFILEHEADER2='char(stg(#BITMAPFILEHEADER2))';
   dcl 1 #BITMAPFILEHEADER2 based(null()) unaligned,
         2 usType USHORT,
         2 cbSize ULONG,
         2 xHotspot SHORT,
         2 yHotspot SHORT,
         2 offBits ULONG,
         2 bmp2 BITMAPINFOHEADER2;
   %declare PBITMAPFILEHEADER2 char;
   %PBITMAPFILEHEADER2='pointer';
   %declare BITMAPARRAYFILEHEADER2 char;
   %BITMAPARRAYFILEHEADER2='char(stg(#BITMAPARRAYFILEHEADER2))';
   dcl 1 #BITMAPARRAYFILEHEADER2 based(null()) unaligned,
         2 usType USHORT,
         2 cbSize ULONG,
         2 offNext ULONG,
         2 cxDisplay USHORT,
         2 cyDisplay USHORT,
         2 bfh2 BITMAPFILEHEADER2;
   %declare PBITMAPARRAYFILEHEADER2 char;
   %PBITMAPARRAYFILEHEADER2='pointer';

   declare BFT_ICON fixed bin(16) value('43_49'xn);
   declare BFT_BMAP fixed bin(16) value('4D_42'xn);
   declare BFT_POINTER fixed bin(16) value('54_50'xn);
   declare BFT_COLORICON fixed bin(16) value('49_43'xn);
   declare BFT_COLORPOINTER fixed bin(16) value('50_43'xn);
   declare BFT_BITMAPARRAY fixed bin(16) value('41_42'xn);
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
