 /*****************************************************************/
 /** ODBCTYPE.CPY - This include defines the types used in ODBC.  */
 /**              - ODBC V 2.5 Level                              */
 /**                                                              */
 /*****************************************************************/
 /*                                                               */
 /*  Licensed Materials - Property of IBM                         */
 /*  5639-A83, 5639-A24 (C) Copyright IBM Corp. 1997.             */
 /*  All Rights Reserved.                                         */
 /*   (C) Copyright IBM Corp. 1997. All Rights Reserved.          */
 /*   US Government Users Restricted Rights-- Use, duplication or */
 /*   disclosure restricted by GSA ADP Schedule Contract with     */
 /*   IBM Corp.                                                   */
 /*                                                               */
 /* DISCLAIMER OF WARRANTIES                                      */
 /*   The following enclosed code is sample code created by IBM */
 /*   Corporation. This sample code is not part of any standard   */
 /*   IBM product and is provided to you solely for the purpose of*/
 /*   assisting you in the development of your applications.  The */
 /*   code is provided "AS IS", without warranty of any kind.     */
 /*   IBM shall not be liable for any damages arising out of your */
 /*   use of the sample code, even if IBM has been advised of the */
 /*   possibility of such damages.                                */
 /*                                                               */
 /*****************************************************************/

 /* if ODBCVER is not defined, assume version 2.50 */
     %dcl ODBCVER char ext;
    %if ODBCVER = '' %then
     %do;
       %ODBCVER = '0250'x;
     %end;

 /* Comment out the appropriate sections below according to          */
 /*  targeted operating system.                                      */

 /* Include for OS/2 */
 %dcl OS2ODBC char ext;
 %OS2ODBC = 'Y';

 /* Include for Windows */
 /*
 %dcl WIN32 char ext;
 %WIN32 = 'Y';
 */

  %dcl SQL_API char ext;
  %SQL_API='options(linkage(system) byvalue nodescriptor)';

 %dcl OS2ODBC char ext;
 %if OS2ODBC ^= '' %then %do;
   %dcl SQL_PRE_API char ext;
   %SQL_PRE_API = 'Y';
   %dcl RETCODE_SQL_API char ext;
   %RETCODE_SQL_API='RETCODE SQL_API';
   %dcl @RETCODE_SQL_API char ext;
   %@RETCODE_SQL_API='@RETCODE SQL_API';
 %end;
 /* OS2ODBC */

 /* HWND declares for appropriate platform */

 %dcl OS2ODBC char ext;
 %if OS2ODBC ^= '' %then       /* os2 */
   %do;
      define alias HWND               fixed bin(31) byvalue;
      define alias @HWND              pointer byvalue;
   %end;
  %else                        /* windows */
   %do;
       define alias HWND              pointer byvalue;
       define alias @HWND             pointer byvalue;
   %end;

 /* Define aliases */
  define alias double                 real float bin(53) byvalue;
  define alias @double                pointer byvalue;
  define alias float                  real float bin(53) byvalue;
  define alias @float                 pointer byvalue;
  define alias wchar_t                unsigned fixed bin(16) byvalue;


 /* SQL portable types for C */
  define alias UCHAR                  char;
  define alias @UCHAR                 pointer byvalue;
  define alias SCHAR                  signed fixed bin(7) byvalue;
  define alias @SCHAR                 pointer byvalue;
  define alias SDWORD                 fixed bin(31) byvalue;
  define alias @SDWORD                pointer byvalue;
  define alias SWORD                  fixed bin(15) byvalue;
  define alias @SWORD                 pointer byvalue;
  define alias UDWORD                 unsigned fixed bin(31) byvalue;
  define alias @UDWORD                pointer byvalue;
  define alias UWORD                  unsigned fixed bin(16) byvalue;
  define alias @UWORD                 pointer byvalue;

 %if (ODBCVER >= '0200'x) %then %do;
  define alias SLONG                  signed fixed bin(31) byvalue;
  define alias @SLONG                 pointer byvalue;
  define alias SSHORT                 signed fixed bin(16) byvalue;
  define alias @SSHORT                pointer byvalue;
 %if OS2ODBC = '' %then %do;
  define alias ULONG                  unsigned fixed bin(31) byvalue;
  define alias @ULONG                 pointer byvalue;
  define alias USHORT                 unsigned fixed bin(16) byvalue;
  define alias @USHORT                pointer byvalue;
  %end;
  %end;
  /* ODBCVER >= 0x0200 */
  define alias SDOUBLE                type double;
  define alias @SDOUBLE               type @double;

  define alias LDOUBLE                type double;
  define alias @LDOUBLE               type @double;
  define alias SFLOAT                 type float;
  define alias @SFLOAT                type @float;

  define alias PTR                    pointer byvalue;
  define alias @PTR                   pointer byvalue;

  define alias HENV                   pointer byvalue;
  define alias @HENV                  pointer byvalue;
  define alias HDBC                   pointer byvalue;
  define alias @HDBC                  pointer byvalue;
  define alias HSTMT                  pointer byvalue;
  define alias @HSTMT                 pointer byvalue;

  define alias RETCODE                signed fixed bin(16) byvalue;
  define alias @RETCODE               pointer byvalue;

  define alias SQLCHAR                type UCHAR;
  define alias @SQLCHAR               type @UCHAR;
  define alias SQLSCHAR               type SCHAR;
  define alias @SQLSCHAR              type @SCHAR;
  define alias SQLINTEGER             type SDWORD;
  define alias @SQLINTEGER            type @SDWORD;
  define alias SQLSMALLINT            type SWORD;
  define alias @SQLSMALLINT           type @SWORD;
  define alias SQLUINTEGER            type UDWORD;
  define alias @SQLUINTEGER           type @UDWORD;
  define alias SQLUSMALLINT           type UWORD;
  define alias @SQLUSMALLINT          type @UWORD;

  define alias SQLPOINTER             pointer byvalue;
  define alias @SQLPOINTER            pointer byvalue;

 %dcl WIN32 char ext;
 %if (WIN32^='') %then
  %do;
  define alias SQLHENV                type HENV;
  define alias @SQLHENV               type @HENV;
  define alias SQLHDBC                type HDBC;
  define alias @SQLHDBC               type @HDBC;
  define alias SQLHSTMT               type HSTMT;
  define alias @SQLHSTMT              type @HSTMT;
  %end;
  %else  /* OS2 */
  %do;
  define alias SQLHENV                type SQLINTEGER;
  define alias @SQLHENV               type @SQLINTEGER;
  define alias SQLHDBC                type SQLINTEGER;
  define alias @SQLHDBC               type @SQLINTEGER;
  define alias SQLHSTMT               type SQLINTEGER;
  define alias @SQLHSTMT              type @SQLINTEGER;
  %end;

  define alias SQLRETURN              type SQLSMALLINT;
  define alias @SQLRETURN             type @SQLSMALLINT;

 %dcl WIN32 char ext;
 %dcl OS2ODBC char ext;
 %if (WIN32^='') | (OS2ODBC^='') %then
  %do;
  define alias SQLHWND                type HWND;
  define alias @SQLHWND               type @HWND;
  %end;
 %else   /* AIX */
   %do;
  define alias SQLHWND                type Widget;
  define alias @SQLHWND               type @Widget;
  %end;

 /* transfer types for DATE, TIME, TIMESTAMP */
 define structure
   1 tagDATE_STRUCT,
    2 year type SQLSMALLINT,
    2 month type SQLUSMALLINT,
    2 day type SQLUSMALLINT;

  define alias @tagDATE_STRUCT        handle tagDATE_STRUCT;
  define alias DATE_STRUCT            type tagDATE_STRUCT;
  define alias @DATE_STRUCT           type @tagDATE_STRUCT;

 define structure
   1 tagTIME_STRUCT,
    2 hour type SQLUSMALLINT,
    2 minute type SQLUSMALLINT,
    2 second type SQLUSMALLINT;

  define alias @tagTIME_STRUCT        handle tagTIME_STRUCT;
  define alias TIME_STRUCT            type tagTIME_STRUCT;
  define alias @TIME_STRUCT           type @tagTIME_STRUCT;

 define structure
   1 tagTIMESTAMP_STRUCT,
    2 year type SQLSMALLINT,
    2 month type SQLUSMALLINT,
    2 day type SQLUSMALLINT,
    2 hour type SQLUSMALLINT,
    2 minute type SQLUSMALLINT,
    2 second type SQLUSMALLINT,
    2 fraction type SQLUINTEGER;

  define alias @tagTIMESTAMP_STRUCT   handle tagTIMESTAMP_STRUCT;
  define alias TIMESTAMP_STRUCT       type tagTIMESTAMP_STRUCT;
  define alias @TIMESTAMP_STRUCT      type @tagTIMESTAMP_STRUCT;

 %if (ODBCVER >= '0200'x) %then %do;
  define alias BOOKMARK               unsigned fixed bin(31) byvalue;
  define alias @BOOKMARK              pointer byvalue;
  %end;
  /* ODBCVER >= 0x0200 */

