 /*****************************************************************/
 /** ODBCSQL.CPY - This is the main include for ODBC functions.   */
 /**             - ODBC V 2.5 Level                               */
 /**                                                              */
 /*****************************************************************/
 /*                                                               */
 /*  Licensed Materials - Property of IBM                         */
 /*  5639-A83, 5639-A24 (C) Copyright IBM Corp. 1997.             */
 /*  All Rights Reserved.                                         */
 /*   (C) Copyright IBM Corp. 1997. All Rights Reserved.          */
 /*   US Government Users Restricted Rights-- Use, duplication or */
 /*   disclosure restricted by GSA ADP Schedule Contract with     */
 /*   IBM Corp.                                                   */
 /*                                                               */
 /* DISCLAIMER OF WARRANTIES                                      */
 /*   The following enclosed code is sample code created by IBM */
 /*   Corporation. This sample code is not part of any standard   */
 /*   IBM product and is provided to you solely for the purpose of*/
 /*   assisting you in the development of your applications.  The */
 /*   code is provided "AS IS", without warranty of any kind.     */
 /*   IBM shall not be liable for any damages arising out of your */
 /*   use of the sample code, even if IBM has been advised of the */
 /*   possibility of such damages.                                */
 /*                                                               */
 /*****************************************************************/
 /*                                                               */
 /* ODBCVER                   ODBC version number (0x0200).   To  */
 /*                           exclude definitions introduced in   */
 /*                           version 2.0 (or above)              */
 /*                           %ODBCVER = '0200'X; before          */
 /*                           including ODBCSQL.CPY               */
 /*                                                               */
 /*                                                               */
 /*****************************************************************/

 /* If ODBCVER is not defined, assume version 2.50 */
    %dcl ODBCVER char ext;
    %if ODBCVER = '' %then
     %do;
       %ODBCVER = '0250'x;
     %end;


 /* generally useful constants */
 %if (ODBCVER >= '0200'x)  %then %do;
 /* Major version of specification  */
  dcl SQL_SPEC_MAJOR                  fixed bin(31) value(2);
 /* Minor version of specification  */
  dcl SQL_SPEC_MINOR                  fixed bin(31) value(50);
 /* String constant for version */
  dcl SQL_SPEC_STRING                 char value("02.50");
  %end;
  /* ODBCVER >= 0x0200 */
 /* size of SQLSTATE */
  dcl SQL_SQLSTATE_SIZE               fixed bin(31) value(5);
 /* message buffer size */
  dcl SQL_MAX_MESSAGE_LENGTH          fixed bin(31) value(512);
 /* maximum data source name size*/
  dcl SQL_MAX_DSN_LENGTH              fixed bin(31) value(32);

 /* RETCODEs */
 %dcl SQL_INVALID_HANDLE char ext;
 %SQL_INVALID_HANDLE = '-2 ';
 %dcl SQL_ERROR char ext;
 %SQL_ERROR = '-1 ';
  dcl SQL_SUCCESS                     fixed bin(31) value(0);
  dcl SQL_SUCCESS_WITH_INFO           fixed bin(31) value(1);
  dcl SQL_NO_DATA_FOUND               fixed bin(31) value(100);

 /* Standard SQL datatypes, using ANSI type numbering */
  dcl SQL_CHAR                        fixed bin(31) value(1);
  dcl SQL_NUMERIC                     fixed bin(31) value(2);
  dcl SQL_DECIMAL                     fixed bin(31) value(3);
  dcl SQL_INTEGER                     fixed bin(31) value(4);
  dcl SQL_SMALLINT                    fixed bin(31) value(5);
  dcl SQL_FLOAT                       fixed bin(31) value(6);
  dcl SQL_REAL                        fixed bin(31) value(7);
  dcl SQL_DOUBLE                      fixed bin(31) value(8);
  dcl SQL_VARCHAR                     fixed bin(31) value(12);

  dcl SQL_TYPE_NULL                   fixed bin(31) value(0);
 %dcl SQL_TYPE_MIN char ext;
 %SQL_TYPE_MIN='SQL_BIT';
 %dcl @SQL_TYPE_MIN char ext;
 %@SQL_TYPE_MIN='@SQL_BIT';
 %dcl SQL_TYPE_MAX char ext;
 %SQL_TYPE_MAX='SQL_VARCHAR';
 %dcl @SQL_TYPE_MAX char ext;
 %@SQL_TYPE_MAX='@SQL_VARCHAR';
 %dcl SQL_ALL_TYPES char ext;
 %SQL_ALL_TYPES='0';
 %dcl @SQL_ALL_TYPES char ext;
 %@SQL_ALL_TYPES='@0';

 /* C datatype to SQL datatype mapping */
 /* CHAR, VARCHAR, DECIMAL, NUMERIC */
 %dcl SQL_C_CHAR char ext;
 %SQL_C_CHAR='SQL_CHAR';
 %dcl @SQL_C_CHAR char ext;
 %@SQL_C_CHAR='@SQL_CHAR';
 /* INTEGER                      */
 %dcl SQL_C_LONG char ext;
 %SQL_C_LONG='SQL_INTEGER';
 %dcl @SQL_C_LONG char ext;
 %@SQL_C_LONG='@SQL_INTEGER';
 /* SMALLINT                     */
 %dcl SQL_C_SHORT char ext;
 %SQL_C_SHORT='SQL_SMALLINT';
 %dcl @SQL_C_SHORT char ext;
 %@SQL_C_SHORT='@SQL_SMALLINT';
 /* REAL                         */
 %dcl SQL_C_FLOAT char ext;
 %SQL_C_FLOAT='SQL_REAL';
 %dcl @SQL_C_FLOAT char ext;
 %@SQL_C_FLOAT='@SQL_REAL';
 /* FLOAT, DOUBLE                */
 %dcl SQL_C_DOUBLE char ext;
 %SQL_C_DOUBLE='SQL_DOUBLE';
 %dcl @SQL_C_DOUBLE char ext;
 %@SQL_C_DOUBLE='@SQL_DOUBLE';
  dcl SQL_C_DEFAULT                   fixed bin(31) value(99);

 /* NULL status constants.  These are used in SQLColumns,          */
 /* SQLColAttributes,  SQLDescribeCol, SQLDescribeParam, and       */
 /* SQLSpecialColumns to describe the  nullablity of a column in a */
 /* table.                                                         */
  dcl SQL_NO_NULLS                    fixed bin(31) value(0);
  dcl SQL_NULLABLE                    fixed bin(31) value(1);
  dcl SQL_NULLABLE_UNKNOWN            fixed bin(31) value(2);

 /* Special length values */
 %dcl SQL_NULL_DATA char ext;
 %SQL_NULL_DATA = '-1 ';
 %dcl SQL_DATA_AT_EXEC char ext;
 %SQL_DATA_AT_EXEC = '-2 ';
 %dcl SQL_NTS char ext;
 %SQL_NTS = '-3 ';

 /* SQLFreeStmt defines */
  dcl SQL_CLOSE                       fixed bin(31) value(0);
  dcl SQL_DROP                        fixed bin(31) value(1);
  dcl SQL_UNBIND                      fixed bin(31) value(2);
  dcl SQL_RESET_PARAMS                fixed bin(31) value(3);

 /* SQLTransact defines */
  dcl SQL_COMMIT                      fixed bin(31) value(0);
  dcl SQL_ROLLBACK                    fixed bin(31) value(1);

 /* SQLColAttributes defines */
  dcl SQL_COLUMN_COUNT                fixed bin(31) value(0);
  dcl SQL_COLUMN_NAME                 fixed bin(31) value(1);
  dcl SQL_COLUMN_TYPE                 fixed bin(31) value(2);
  dcl SQL_COLUMN_LENGTH               fixed bin(31) value(3);
  dcl SQL_COLUMN_PRECISION            fixed bin(31) value(4);
  dcl SQL_COLUMN_SCALE                fixed bin(31) value(5);
  dcl SQL_COLUMN_DISPLAY_SIZE         fixed bin(31) value(6);
  dcl SQL_COLUMN_NULLABLE             fixed bin(31) value(7);
  dcl SQL_COLUMN_UNSIGNED             fixed bin(31) value(8);
  dcl SQL_COLUMN_MONEY                fixed bin(31) value(9);
  dcl SQL_COLUMN_UPDATABLE            fixed bin(31) value(10);
  dcl SQL_COLUMN_AUTO_INCREMENT       fixed bin(31) value(11);
  dcl SQL_COLUMN_CASE_SENSITIVE       fixed bin(31) value(12);
  dcl SQL_COLUMN_SEARCHABLE           fixed bin(31) value(13);
  dcl SQL_COLUMN_TYPE_NAME            fixed bin(31) value(14);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_COLUMN_TABLE_NAME           fixed bin(31) value(15);
  dcl SQL_COLUMN_OWNER_NAME           fixed bin(31) value(16);
  dcl SQL_COLUMN_QUALIFIER_NAME       fixed bin(31) value(17);
  dcl SQL_COLUMN_LABEL                fixed bin(31) value(18);
 %dcl SQL_COLATT_OPT_MAX char ext;
 %SQL_COLATT_OPT_MAX='SQL_COLUMN_LABEL';
 %dcl @SQL_COLATT_OPT_MAX char ext;
 %@SQL_COLATT_OPT_MAX='@SQL_COLUMN_LABEL';
  %end;
  %else
  %do;
 %dcl SQL_COLATT_OPT_MAX char ext;
 %SQL_COLATT_OPT_MAX='SQL_COLUMN_TYPE_NAME';
 %dcl @SQL_COLATT_OPT_MAX char ext;
 %@SQL_COLATT_OPT_MAX='@SQL_COLUMN_TYPE_NAME';
  %end;
  /* ODBCVER >= 0x0200 */
  dcl SQL_COLUMN_DRIVER_START         fixed bin(31) value(1000);

 %dcl SQL_COLATT_OPT_MIN char ext;
 %SQL_COLATT_OPT_MIN='SQL_COLUMN_COUNT';
 %dcl @SQL_COLATT_OPT_MIN char ext;
 %@SQL_COLATT_OPT_MIN='@SQL_COLUMN_COUNT';

 /* SQLColAttributes subdefines for SQL_COLUMN_UPDATABLE */
  dcl SQL_ATTR_READONLY               fixed bin(31) value(0);
  dcl SQL_ATTR_WRITE                  fixed bin(31) value(1);
  dcl SQL_ATTR_READWRITE_UNKNOWN      fixed bin(31) value(2);

 /* SQLColAttributes subdefines for SQL_COLUMN_SEARCHABLE */
 /* These are also used by SQLGetInfo                     */
  dcl SQL_UNSEARCHABLE                fixed bin(31) value(0);
  dcl SQL_LIKE_ONLY                   fixed bin(31) value(1);
  dcl SQL_ALL_EXCEPT_LIKE             fixed bin(31) value(2);
  dcl SQL_SEARCHABLE                  fixed bin(31) value(3);

 /* SQLError defines */
  dcl SQL_NULL_HENV                   fixed bin(31) value(0);
  dcl SQL_NULL_HDBC                   fixed bin(31) value(0);
  dcl SQL_NULL_HSTMT                  fixed bin(31) value(0);

 %include odbctype;

 /* Core Function Prototypes */

 dcl SQLAllocConnect entry (
        type SQLHENV,
        type @SQLHDBC)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLAllocConnect');

 dcl SQLAllocEnv entry (
        type @SQLHENV )
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLAllocEnv');

 dcl SQLAllocStmt entry (
        type SQLHDBC,
        type @SQLHSTMT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLAllocStmt');

 dcl SQLBindCol entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLSMALLINT,
        type SQLPOINTER,
        type SQLINTEGER,
        type @SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLBindCol');

 dcl SQLCancel entry (
        type SQLHSTMT )
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLCancel');

 dcl SQLColAttributes entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLUSMALLINT,
        type SQLPOINTER,
        type SQLSMALLINT,
        type @SQLSMALLINT,
        type @SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLColAttributes');

 dcl SQLConnect entry (
        type SQLHDBC,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLConnect');

 dcl SQLDescribeCol entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT,
        type @SQLSMALLINT,
        type @SQLUINTEGER,
        type @SQLSMALLINT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLDescribeCol');

 dcl SQLDisconnect entry (
        type SQLHDBC )
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLDisconnect');

 dcl SQLError entry (
        type SQLHENV,
        type SQLHDBC,
        type SQLHSTMT,
        type @SQLCHAR,
        type @SQLINTEGER,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLError');

 dcl SQLExecDirect entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLExecDirect');

 dcl SQLExecute entry (
        type SQLHSTMT )
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLExecute');

 dcl SQLFetch entry (
        type SQLHSTMT )
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLFetch');

 dcl SQLFreeConnect entry (
        type SQLHDBC )
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLFreeConnect');

 dcl SQLFreeEnv entry (
        type SQLHENV )
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLFreeEnv');

 dcl SQLFreeStmt entry (
        type SQLHSTMT,
        type SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLFreeStmt');

 dcl SQLGetCursorName entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLGetCursorName');

 dcl SQLNumResultCols entry (
        type SQLHSTMT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLNumResultCols');

 dcl SQLPrepare entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLPrepare');

 dcl SQLRowCount entry (
        type SQLHSTMT,
        type @SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLRowCount');

 dcl SQLSetCursorName entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLSetCursorName');

 dcl SQLTransact entry (
        type SQLHENV,
        type SQLHDBC,
        type SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLTransact');


 /*      Deprecrated functions from prior versions of ODBC */

 /*      Use SQLBindParameter */
 dcl SQLSetParam entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLSMALLINT,
        type SQLSMALLINT,
        type SQLUINTEGER,
        type SQLSMALLINT,
        type SQLPOINTER,
        type @SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLSetParam');



 /* Defines used by both Level 1 and Level 2 functions */

 /* generally useful constants */
  dcl SQL_MAX_OPTION_STRING_LENGTH    fixed bin(31) value(256);

 /* Additional return codes */
  dcl SQL_STILL_EXECUTING             fixed bin(31) value(2);
  dcl SQL_NEED_DATA                   fixed bin(31) value(99);

 /* SQL extended datatypes */
  dcl SQL_DATE                        fixed bin(31) value(9);
  dcl SQL_TIME                        fixed bin(31) value(10);
  dcl SQL_TIMESTAMP                   fixed bin(31) value(11);
 %dcl SQL_LONGVARCHAR char ext;
 %SQL_LONGVARCHAR = '-1 ';
 %dcl SQL_BINARY char ext;
 %SQL_BINARY = '-2 ';
 %dcl SQL_VARBINARY char ext;
 %SQL_VARBINARY = '-3 ';
 %dcl SQL_LONGVARBINARY char ext;
 %SQL_LONGVARBINARY = '-4 ';
 %dcl SQL_BIGINT char ext;
 %SQL_BIGINT = '-5 ';
 %dcl SQL_TINYINT char ext;
 %SQL_TINYINT = '-6 ';
 %dcl SQL_BIT char ext;
 %SQL_BIT = '-7 ';

 %dcl SQL_INTERVAL_YEAR char ext;
 %SQL_INTERVAL_YEAR = '-80 ';
 %dcl SQL_INTERVAL_MONTH char ext;
 %SQL_INTERVAL_MONTH = '-81 ';
 %dcl SQL_INTERVAL_YEAR_TO_MONTH char ext;
 %SQL_INTERVAL_YEAR_TO_MONTH = '-82 ';
 %dcl SQL_INTERVAL_DAY char ext;
 %SQL_INTERVAL_DAY = '-83 ';
 %dcl SQL_INTERVAL_HOUR char ext;
 %SQL_INTERVAL_HOUR = '-84 ';
 %dcl SQL_INTERVAL_MINUTE char ext;
 %SQL_INTERVAL_MINUTE = '-85 ';
 %dcl SQL_INTERVAL_SECOND char ext;
 %SQL_INTERVAL_SECOND = '-86 ';
 %dcl SQL_INTERVAL_DAY_TO_HOUR char ext;
 %SQL_INTERVAL_DAY_TO_HOUR = '-87 ';
 %dcl SQL_INTERVAL_DAY_TO_MINUTE char ext;
 %SQL_INTERVAL_DAY_TO_MINUTE = '-88 ';
 %dcl SQL_INTERVAL_DAY_TO_SECOND char ext;
 %SQL_INTERVAL_DAY_TO_SECOND = '-89 ';
 %dcl SQL_INTERVAL_HOUR_TO_MINUTE char ext;
 %SQL_INTERVAL_HOUR_TO_MINUTE = '-90 ';
 %dcl SQL_INTERVAL_HOUR_TO_SECOND char ext;
 %SQL_INTERVAL_HOUR_TO_SECOND = '-91 ';
 %dcl SQL_INTERVAL_MINUTE_TO_SECOND char ext;
 %SQL_INTERVAL_MINUTE_TO_SECOND = '-92 ';
 %dcl SQL_UNICODE char ext;
 %SQL_UNICODE = '-95 ';
 %dcl SQL_UNICODE_VARCHAR char ext;
 %SQL_UNICODE_VARCHAR = '-96 ';
 %dcl SQL_UNICODE_LONGVARCHAR char ext;
 %SQL_UNICODE_LONGVARCHAR = '-97 ';
 %dcl SQL_UNICODE_CHAR char ext;
 %SQL_UNICODE_CHAR='SQL_UNICODE';
 %dcl @SQL_UNICODE_CHAR char ext;
 %@SQL_UNICODE_CHAR='@SQL_UNICODE';

 %dcl SQL_TYPE_DRIVER_START char ext;
 %SQL_TYPE_DRIVER_START='SQL_INTERVAL_YEAR';
 %dcl @SQL_TYPE_DRIVER_START char ext;
 %@SQL_TYPE_DRIVER_START='@SQL_INTERVAL_YEAR';
 %dcl SQL_TYPE_DRIVER_END char ext;
 %SQL_TYPE_DRIVER_END='SQL_UNICODE_LONGVARCHAR';
 %dcl @SQL_TYPE_DRIVER_END char ext;
 %@SQL_TYPE_DRIVER_END='@SQL_UNICODE_LONGVARCHAR';


 %if (ODBCVER >= '0200'x) %then %do;
 %dcl SQL_SIGNED_OFFSET char ext;
 %SQL_SIGNED_OFFSET = '-20 ';
 %dcl SQL_UNSIGNED_OFFSET char ext;
 %SQL_UNSIGNED_OFFSET = '-22 ';
  %end;
  /* ODBCVER >= 0x0200 */

 /* C datatype to SQL datatype mapping */
 %dcl SQL_C_DATE char ext;
 %SQL_C_DATE='SQL_DATE';
 %dcl @SQL_C_DATE char ext;
 %@SQL_C_DATE='@SQL_DATE';
 %dcl SQL_C_TIME char ext;
 %SQL_C_TIME='SQL_TIME';
 %dcl @SQL_C_TIME char ext;
 %@SQL_C_TIME='@SQL_TIME';
 %dcl SQL_C_TIMESTAMP char ext;
 %SQL_C_TIMESTAMP='SQL_TIMESTAMP';
 %dcl @SQL_C_TIMESTAMP char ext;
 %@SQL_C_TIMESTAMP='@SQL_TIMESTAMP';
 %dcl SQL_C_BINARY char ext;
 %SQL_C_BINARY='SQL_BINARY';
 %dcl @SQL_C_BINARY char ext;
 %@SQL_C_BINARY='@SQL_BINARY';
 %dcl SQL_C_BIT char ext;
 %SQL_C_BIT='SQL_BIT';
 %dcl @SQL_C_BIT char ext;
 %@SQL_C_BIT='@SQL_BIT';
 %dcl SQL_C_TINYINT char ext;
 %SQL_C_TINYINT='SQL_TINYINT';
 %dcl @SQL_C_TINYINT char ext;
 %@SQL_C_TINYINT='@SQL_TINYINT';
 %if (ODBCVER >= '0200'x) %then %do;
 /* SIGNED INTEGER   */
 %dcl SQL_C_SLONG char ext;
 %SQL_C_SLONG = 'SQL_C_LONG+SQL_SIGNED_OFFSET';
 /* SIGNED SMALLINT  */
 %dcl SQL_C_SSHORT char ext;
 %SQL_C_SSHORT = 'SQL_C_SHORT+SQL_SIGNED_OFFSET';
 /* SIGNED TINYINT   */
 %dcl SQL_C_STINYINT char ext;
 %SQL_C_STINYINT = 'SQL_TINYINT+SQL_SIGNED_OFFSET';
 /* UNSIGNED INTEGER */
 %dcl SQL_C_ULONG char ext;
 %SQL_C_ULONG = 'SQL_C_LONG+SQL_UNSIGNED_OFFSET';
 /* UNSIGNED SMALLINT*/
 %dcl SQL_C_USHORT char ext;
 %SQL_C_USHORT = 'SQL_C_SHORT+SQL_UNSIGNED_OFFSET';
 /* UNSIGNED TINYINT */
 %dcl SQL_C_UTINYINT char ext;
 %SQL_C_UTINYINT = 'SQL_TINYINT+SQL_UNSIGNED_OFFSET';
 /* BOOKMARK         */
 %dcl SQL_C_BOOKMARK char ext;
 %SQL_C_BOOKMARK='SQL_C_ULONG';
 %dcl @SQL_C_BOOKMARK char ext;
 %@SQL_C_BOOKMARK='@SQL_C_ULONG';
  %end;
  /* ODBCVER >= 0x0200 */


 /* Level 1 Functions                    */

 /* Special return values for SQLGetData */
 %dcl SQL_NO_TOTAL char ext;
 %SQL_NO_TOTAL = '-4 ';

 /* Defines for SQLGetFunctions */
  dcl SQL_API_SQLALLOCCONNECT         fixed bin(31) value(1);
 /* Core Functions           */
  dcl SQL_API_SQLALLOCENV             fixed bin(31) value(2);
  dcl SQL_API_SQLALLOCSTMT            fixed bin(31) value(3);
  dcl SQL_API_SQLBINDCOL              fixed bin(31) value(4);
  dcl SQL_API_SQLCANCEL               fixed bin(31) value(5);
  dcl SQL_API_SQLCOLATTRIBUTES        fixed bin(31) value(6);
  dcl SQL_API_SQLCONNECT              fixed bin(31) value(7);
  dcl SQL_API_SQLDESCRIBECOL          fixed bin(31) value(8);
  dcl SQL_API_SQLDISCONNECT           fixed bin(31) value(9);
  dcl SQL_API_SQLERROR                fixed bin(31) value(10);
  dcl SQL_API_SQLEXECDIRECT           fixed bin(31) value(11);
  dcl SQL_API_SQLEXECUTE              fixed bin(31) value(12);
  dcl SQL_API_SQLFETCH                fixed bin(31) value(13);
  dcl SQL_API_SQLFREECONNECT          fixed bin(31) value(14);
  dcl SQL_API_SQLFREEENV              fixed bin(31) value(15);
  dcl SQL_API_SQLFREESTMT             fixed bin(31) value(16);
  dcl SQL_API_SQLGETCURSORNAME        fixed bin(31) value(17);
  dcl SQL_API_SQLNUMRESULTCOLS        fixed bin(31) value(18);
  dcl SQL_API_SQLPREPARE              fixed bin(31) value(19);
  dcl SQL_API_SQLROWCOUNT             fixed bin(31) value(20);
  dcl SQL_API_SQLSETCURSORNAME        fixed bin(31) value(21);
  dcl SQL_API_SQLSETPARAM             fixed bin(31) value(22);
  dcl SQL_API_SQLTRANSACT             fixed bin(31) value(23);

  dcl SQL_NUM_FUNCTIONS               fixed bin(31) value(23);

  dcl SQL_EXT_API_START               fixed bin(31) value(40);

  dcl SQL_API_SQLCOLUMNS              fixed bin(31) value(40);
 /* Level 1 Functions        */
  dcl SQL_API_SQLDRIVERCONNECT        fixed bin(31) value(41);
  dcl SQL_API_SQLGETCONNECTOPTION     fixed bin(31) value(42);
  dcl SQL_API_SQLGETDATA              fixed bin(31) value(43);
  dcl SQL_API_SQLGETFUNCTIONS         fixed bin(31) value(44);
  dcl SQL_API_SQLGETINFO              fixed bin(31) value(45);
  dcl SQL_API_SQLGETSTMTOPTION        fixed bin(31) value(46);
  dcl SQL_API_SQLGETTYPEINFO          fixed bin(31) value(47);
  dcl SQL_API_SQLPARAMDATA            fixed bin(31) value(48);
  dcl SQL_API_SQLPUTDATA              fixed bin(31) value(49);
  dcl SQL_API_SQLSETCONNECTOPTION     fixed bin(31) value(50);
  dcl SQL_API_SQLSETSTMTOPTION        fixed bin(31) value(51);
  dcl SQL_API_SQLSPECIALCOLUMNS       fixed bin(31) value(52);
  dcl SQL_API_SQLSTATISTICS           fixed bin(31) value(53);
  dcl SQL_API_SQLTABLES               fixed bin(31) value(54);

  dcl SQL_API_SQLBROWSECONNECT        fixed bin(31) value(55);
 /* Level 2 Functions        */
  dcl SQL_API_SQLCOLUMNPRIVILEGES     fixed bin(31) value(56);
  dcl SQL_API_SQLDATASOURCES          fixed bin(31) value(57);
  dcl SQL_API_SQLDESCRIBEPARAM        fixed bin(31) value(58);
  dcl SQL_API_SQLEXTENDEDFETCH        fixed bin(31) value(59);
  dcl SQL_API_SQLFOREIGNKEYS          fixed bin(31) value(60);
  dcl SQL_API_SQLMORERESULTS          fixed bin(31) value(61);
  dcl SQL_API_SQLNATIVESQL            fixed bin(31) value(62);
  dcl SQL_API_SQLNUMPARAMS            fixed bin(31) value(63);
  dcl SQL_API_SQLPARAMOPTIONS         fixed bin(31) value(64);
  dcl SQL_API_SQLPRIMARYKEYS          fixed bin(31) value(65);
  dcl SQL_API_SQLPROCEDURECOLUMNS     fixed bin(31) value(66);
  dcl SQL_API_SQLPROCEDURES           fixed bin(31) value(67);
  dcl SQL_API_SQLSETPOS               fixed bin(31) value(68);
  dcl SQL_API_SQLSETSCROLLOPTIONS     fixed bin(31) value(69);
  dcl SQL_API_SQLTABLEPRIVILEGES      fixed bin(31) value(70);

 /*              SDK 2.0 Additions               */
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_API_SQLDRIVERS              fixed bin(31) value(71);
  dcl SQL_API_SQLBINDPARAMETER        fixed bin(31) value(72);
 %dcl SQL_EXT_API_LAST char ext;
 %SQL_EXT_API_LAST='SQL_API_SQLBINDPARAMETER';
 %dcl @SQL_EXT_API_LAST char ext;
 %@SQL_EXT_API_LAST='@SQL_API_SQLBINDPARAMETER';
  %end;
  %else
  %do;
 %dcl SQL_EXT_API_LAST char ext;
 %SQL_EXT_API_LAST='SQL_API_SQLTABLEPRIVILEGES';
 %dcl @SQL_EXT_API_LAST char ext;
 %@SQL_EXT_API_LAST='@SQL_API_SQLTABLEPRIVILEGES';
  %end;
  /* ODBCVER >= 0x0200 */

  dcl SQL_API_ALL_FUNCTIONS           fixed bin(31) value(0);

 %dcl SQL_NUM_EXTENSIONS char ext;
 %SQL_NUM_EXTENSIONS = 'SQL_EXT_API_LAST-SQL_EXT_API_START+1';
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_API_LOADBYORDINAL           fixed bin(31) value(199);
  %end;
  /* ODBCVER >= 0x0200 */

 /* Defines for SQLGetInfo */
  dcl SQL_INFO_FIRST                  fixed bin(31) value(0);
  dcl SQL_ACTIVE_CONNECTIONS          fixed bin(31) value(0);
  dcl SQL_ACTIVE_STATEMENTS           fixed bin(31) value(1);
  dcl SQL_DATA_SOURCE_NAME            fixed bin(31) value(2);
  dcl SQL_DRIVER_HDBC                 fixed bin(31) value(3);
  dcl SQL_DRIVER_HENV                 fixed bin(31) value(4);
  dcl SQL_DRIVER_HSTMT                fixed bin(31) value(5);
  dcl SQL_DRIVER_NAME                 fixed bin(31) value(6);
  dcl SQL_DRIVER_VER                  fixed bin(31) value(7);
  dcl SQL_FETCH_DIRECTION             fixed bin(31) value(8);
  dcl SQL_ODBC_API_CONFORMANCE        fixed bin(31) value(9);
  dcl SQL_ODBC_VER                    fixed bin(31) value(10);
  dcl SQL_ROW_UPDATES                 fixed bin(31) value(11);
  dcl SQL_ODBC_SAG_CLI_CONFORMANCE    fixed bin(31) value(12);
  dcl SQL_SERVER_NAME                 fixed bin(31) value(13);
  dcl SQL_SEARCH_PATTERN_ESCAPE       fixed bin(31) value(14);
  dcl SQL_ODBC_SQL_CONFORMANCE        fixed bin(31) value(15);

  dcl SQL_DBMS_NAME                   fixed bin(31) value(17);
  dcl SQL_DBMS_VER                    fixed bin(31) value(18);

  dcl SQL_ACCESSIBLE_TABLES           fixed bin(31) value(19);
  dcl SQL_ACCESSIBLE_PROCEDURES       fixed bin(31) value(20);
  dcl SQL_PROCEDURES                  fixed bin(31) value(21);
  dcl SQL_CONCAT_NULL_BEHAVIOR        fixed bin(31) value(22);
  dcl SQL_CURSOR_COMMIT_BEHAVIOR      fixed bin(31) value(23);
  dcl SQL_CURSOR_ROLLBACK_BEHAVIOR    fixed bin(31) value(24);
  dcl SQL_DATA_SOURCE_READ_ONLY       fixed bin(31) value(25);
  dcl SQL_DEFAULT_TXN_ISOLATION       fixed bin(31) value(26);
  dcl SQL_EXPRESSIONS_IN_ORDERBY      fixed bin(31) value(27);
  dcl SQL_IDENTIFIER_CASE             fixed bin(31) value(28);
  dcl SQL_IDENTIFIER_QUOTE_CHAR       fixed bin(31) value(29);
  dcl SQL_MAX_COLUMN_NAME_LEN         fixed bin(31) value(30);
  dcl SQL_MAX_CURSOR_NAME_LEN         fixed bin(31) value(31);
  dcl SQL_MAX_OWNER_NAME_LEN          fixed bin(31) value(32);
  dcl SQL_MAX_PROCEDURE_NAME_LEN      fixed bin(31) value(33);
  dcl SQL_MAX_QUALIFIER_NAME_LEN      fixed bin(31) value(34);
  dcl SQL_MAX_TABLE_NAME_LEN          fixed bin(31) value(35);
  dcl SQL_MULT_RESULT_SETS            fixed bin(31) value(36);
  dcl SQL_MULTIPLE_ACTIVE_TXN         fixed bin(31) value(37);
  dcl SQL_OUTER_JOINS                 fixed bin(31) value(38);
  dcl SQL_OWNER_TERM                  fixed bin(31) value(39);
  dcl SQL_PROCEDURE_TERM              fixed bin(31) value(40);
  dcl SQL_QUALIFIER_NAME_SEPARATOR    fixed bin(31) value(41);
  dcl SQL_QUALIFIER_TERM              fixed bin(31) value(42);
  dcl SQL_SCROLL_CONCURRENCY          fixed bin(31) value(43);
  dcl SQL_SCROLL_OPTIONS              fixed bin(31) value(44);
  dcl SQL_TABLE_TERM                  fixed bin(31) value(45);
  dcl SQL_TXN_CAPABLE                 fixed bin(31) value(46);
  dcl SQL_USER_NAME                   fixed bin(31) value(47);

  dcl SQL_CONVERT_FUNCTIONS           fixed bin(31) value(48);
  dcl SQL_NUMERIC_FUNCTIONS           fixed bin(31) value(49);
  dcl SQL_STRING_FUNCTIONS            fixed bin(31) value(50);
  dcl SQL_SYSTEM_FUNCTIONS            fixed bin(31) value(51);
  dcl SQL_TIMEDATE_FUNCTIONS          fixed bin(31) value(52);

  dcl SQL_CONVERT_BIGINT              fixed bin(31) value(53);
  dcl SQL_CONVERT_BINARY              fixed bin(31) value(54);
  dcl SQL_CONVERT_BIT                 fixed bin(31) value(55);
  dcl SQL_CONVERT_CHAR                fixed bin(31) value(56);
  dcl SQL_CONVERT_DATE                fixed bin(31) value(57);
  dcl SQL_CONVERT_DECIMAL             fixed bin(31) value(58);
  dcl SQL_CONVERT_DOUBLE              fixed bin(31) value(59);
  dcl SQL_CONVERT_FLOAT               fixed bin(31) value(60);
  dcl SQL_CONVERT_INTEGER             fixed bin(31) value(61);
  dcl SQL_CONVERT_LONGVARCHAR         fixed bin(31) value(62);
  dcl SQL_CONVERT_NUMERIC             fixed bin(31) value(63);
  dcl SQL_CONVERT_REAL                fixed bin(31) value(64);
  dcl SQL_CONVERT_SMALLINT            fixed bin(31) value(65);
  dcl SQL_CONVERT_TIME                fixed bin(31) value(66);
  dcl SQL_CONVERT_TIMESTAMP           fixed bin(31) value(67);
  dcl SQL_CONVERT_TINYINT             fixed bin(31) value(68);
  dcl SQL_CONVERT_VARBINARY           fixed bin(31) value(69);
  dcl SQL_CONVERT_VARCHAR             fixed bin(31) value(70);
  dcl SQL_CONVERT_LONGVARBINARY       fixed bin(31) value(71);

  dcl SQL_TXN_ISOLATION_OPTION        fixed bin(31) value(72);
  dcl SQL_ODBC_SQL_OPT_IEF            fixed bin(31) value(73);

 /*** ODBC SDK 1.0 Additions ***/
  dcl SQL_CORRELATION_NAME            fixed bin(31) value(74);
  dcl SQL_NON_NULLABLE_COLUMNS        fixed bin(31) value(75);

 /*** ODBC SDK 2.0 Additions ***/
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_DRIVER_HLIB                 fixed bin(31) value(76);
  dcl SQL_DRIVER_ODBC_VER             fixed bin(31) value(77);
  dcl SQL_LOCK_TYPES                  fixed bin(31) value(78);
  dcl SQL_POS_OPERATIONS              fixed bin(31) value(79);
  dcl SQL_POSITIONED_STATEMENTS       fixed bin(31) value(80);
  dcl SQL_GETDATA_EXTENSIONS          fixed bin(31) value(81);
  dcl SQL_BOOKMARK_PERSISTENCE        fixed bin(31) value(82);
  dcl SQL_STATIC_SENSITIVITY          fixed bin(31) value(83);
  dcl SQL_FILE_USAGE                  fixed bin(31) value(84);
  dcl SQL_NULL_COLLATION              fixed bin(31) value(85);
  dcl SQL_ALTER_TABLE                 fixed bin(31) value(86);
  dcl SQL_COLUMN_ALIAS                fixed bin(31) value(87);
  dcl SQL_GROUP_BY                    fixed bin(31) value(88);
  dcl SQL_KEYWORDS                    fixed bin(31) value(89);
  dcl SQL_ORDER_BY_COLUMNS_IN_SELECT  fixed bin(31) value(90);
  dcl SQL_OWNER_USAGE                 fixed bin(31) value(91);
  dcl SQL_QUALIFIER_USAGE             fixed bin(31) value(92);
  dcl SQL_QUOTED_IDENTIFIER_CASE      fixed bin(31) value(93);
  dcl SQL_SPECIAL_CHARACTERS          fixed bin(31) value(94);
  dcl SQL_SUBQUERIES                  fixed bin(31) value(95);
  dcl SQL_UNION                       fixed bin(31) value(96);
  dcl SQL_MAX_COLUMNS_IN_GROUP_BY     fixed bin(31) value(97);
  dcl SQL_MAX_COLUMNS_IN_INDEX        fixed bin(31) value(98);
  dcl SQL_MAX_COLUMNS_IN_ORDER_BY     fixed bin(31) value(99);
  dcl SQL_MAX_COLUMNS_IN_SELECT       fixed bin(31) value(100);
  dcl SQL_MAX_COLUMNS_IN_TABLE        fixed bin(31) value(101);
  dcl SQL_MAX_INDEX_SIZE              fixed bin(31) value(102);
  dcl SQL_MAX_ROW_SIZE_INCLUDES_LONG  fixed bin(31) value(103);
  dcl SQL_MAX_ROW_SIZE                fixed bin(31) value(104);
  dcl SQL_MAX_STATEMENT_LEN           fixed bin(31) value(105);
  dcl SQL_MAX_TABLES_IN_SELECT        fixed bin(31) value(106);
  dcl SQL_MAX_USER_NAME_LEN           fixed bin(31) value(107);
  dcl SQL_MAX_CHAR_LITERAL_LEN        fixed bin(31) value(108);
  dcl SQL_TIMEDATE_ADD_INTERVALS      fixed bin(31) value(109);
  dcl SQL_TIMEDATE_DIFF_INTERVALS     fixed bin(31) value(110);
  dcl SQL_NEED_LONG_DATA_LEN          fixed bin(31) value(111);
  dcl SQL_MAX_BINARY_LITERAL_LEN      fixed bin(31) value(112);
  dcl SQL_LIKE_ESCAPE_CLAUSE          fixed bin(31) value(113);
  dcl SQL_QUALIFIER_LOCATION          fixed bin(31) value(114);

 %if (ODBCVER >= '0201'x) %then %do;
 /*** ODBC SDK 2.01 Additions ***/
 /* Temp value until ODBC 3.0 */
  dcl SQL_OJ_CAPABILITIES             fixed bin(31) value(65003);
  %end;
  /* ODBCVER >= 0x0201 */

 %dcl SQL_INFO_LAST char ext;
 %SQL_INFO_LAST='SQL_QUALIFIER_LOCATION';
 %dcl @SQL_INFO_LAST char ext;
 %@SQL_INFO_LAST='@SQL_QUALIFIER_LOCATION';
  %end;
  %else
  %do;
 %dcl SQL_INFO_LAST char ext;
 %SQL_INFO_LAST='SQL_NON_NULLABLE_COLUMNS';
 %dcl @SQL_INFO_LAST char ext;
 %@SQL_INFO_LAST='@SQL_NON_NULLABLE_COLUMNS';
  %end;
  /* ODBCVER >= 0x0200 */

  dcl SQL_INFO_DRIVER_START               fixed bin(31) value(1000);

 /* SQL_CONVERT_*  return value bitmasks */

  dcl SQL_CVT_CHAR                    fixed bin(31) value('00000001'xn);
  dcl SQL_CVT_NUMERIC                 fixed bin(31) value('00000002'xn);
  dcl SQL_CVT_DECIMAL                 fixed bin(31) value('00000004'xn);
  dcl SQL_CVT_INTEGER                 fixed bin(31) value('00000008'xn);
  dcl SQL_CVT_SMALLINT                fixed bin(31) value('00000010'xn);
  dcl SQL_CVT_FLOAT                   fixed bin(31) value('00000020'xn);
  dcl SQL_CVT_REAL                    fixed bin(31) value('00000040'xn);
  dcl SQL_CVT_DOUBLE                  fixed bin(31) value('00000080'xn);
  dcl SQL_CVT_VARCHAR                 fixed bin(31) value('00000100'xn);
  dcl SQL_CVT_LONGVARCHAR             fixed bin(31) value('00000200'xn);
  dcl SQL_CVT_BINARY                  fixed bin(31) value('00000400'xn);
  dcl SQL_CVT_VARBINARY               fixed bin(31) value('00000800'xn);
  dcl SQL_CVT_BIT                     fixed bin(31) value('00001000'xn);
  dcl SQL_CVT_TINYINT                 fixed bin(31) value('00002000'xn);
  dcl SQL_CVT_BIGINT                  fixed bin(31) value('00004000'xn);
  dcl SQL_CVT_DATE                    fixed bin(31) value('00008000'xn);
  dcl SQL_CVT_TIME                    fixed bin(31) value('00010000'xn);
  dcl SQL_CVT_TIMESTAMP               fixed bin(31) value('00020000'xn);
  dcl SQL_CVT_LONGVARBINARY           fixed bin(31) value('00040000'xn);

 /* SQL_CONVERT_FUNCTIONS functions */
  dcl SQL_FN_CVT_CONVERT              fixed bin(31) value('00000001'xn);

 /* SQL_STRING_FUNCTIONS functions */

  dcl SQL_FN_STR_CONCAT               fixed bin(31) value('00000001'xn);
  dcl SQL_FN_STR_INSERT               fixed bin(31) value('00000002'xn);
  dcl SQL_FN_STR_LEFT                 fixed bin(31) value('00000004'xn);
  dcl SQL_FN_STR_LTRIM                fixed bin(31) value('00000008'xn);
  dcl SQL_FN_STR_LENGTH               fixed bin(31) value('00000010'xn);
  dcl SQL_FN_STR_LOCATE               fixed bin(31) value('00000020'xn);
  dcl SQL_FN_STR_LCASE                fixed bin(31) value('00000040'xn);
  dcl SQL_FN_STR_REPEAT               fixed bin(31) value('00000080'xn);
  dcl SQL_FN_STR_REPLACE              fixed bin(31) value('00000100'xn);
  dcl SQL_FN_STR_RIGHT                fixed bin(31) value('00000200'xn);
  dcl SQL_FN_STR_RTRIM                fixed bin(31) value('00000400'xn);
  dcl SQL_FN_STR_SUBSTRING            fixed bin(31) value('00000800'xn);
  dcl SQL_FN_STR_UCASE                fixed bin(31) value('00001000'xn);
  dcl SQL_FN_STR_ASCII                fixed bin(31) value('00002000'xn);
  dcl SQL_FN_STR_CHAR                 fixed bin(31) value('00004000'xn);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_FN_STR_DIFFERENCE           fixed bin(31) value('00008000'xn);
  dcl SQL_FN_STR_LOCATE_2             fixed bin(31) value('00010000'xn);
  dcl SQL_FN_STR_SOUNDEX              fixed bin(31) value('00020000'xn);
  dcl SQL_FN_STR_SPACE                fixed bin(31) value('00040000'xn);
  %end;
  /* ODBCVER >= 0x0200 */

 /* SQL_NUMERIC_FUNCTIONS functions */

  dcl SQL_FN_NUM_ABS                  fixed bin(31) value('00000001'xn);
  dcl SQL_FN_NUM_ACOS                 fixed bin(31) value('00000002'xn);
  dcl SQL_FN_NUM_ASIN                 fixed bin(31) value('00000004'xn);
  dcl SQL_FN_NUM_ATAN                 fixed bin(31) value('00000008'xn);
  dcl SQL_FN_NUM_ATAN2                fixed bin(31) value('00000010'xn);
  dcl SQL_FN_NUM_CEILING              fixed bin(31) value('00000020'xn);
  dcl SQL_FN_NUM_COS                  fixed bin(31) value('00000040'xn);
  dcl SQL_FN_NUM_COT                  fixed bin(31) value('00000080'xn);
  dcl SQL_FN_NUM_EXP                  fixed bin(31) value('00000100'xn);
  dcl SQL_FN_NUM_FLOOR                fixed bin(31) value('00000200'xn);
  dcl SQL_FN_NUM_LOG                  fixed bin(31) value('00000400'xn);
  dcl SQL_FN_NUM_MOD                  fixed bin(31) value('00000800'xn);
  dcl SQL_FN_NUM_SIGN                 fixed bin(31) value('00001000'xn);
  dcl SQL_FN_NUM_SIN                  fixed bin(31) value('00002000'xn);
  dcl SQL_FN_NUM_SQRT                 fixed bin(31) value('00004000'xn);
  dcl SQL_FN_NUM_TAN                  fixed bin(31) value('00008000'xn);
  dcl SQL_FN_NUM_PI                   fixed bin(31) value('00010000'xn);
  dcl SQL_FN_NUM_RAND                 fixed bin(31) value('00020000'xn);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_FN_NUM_DEGREES              fixed bin(31) value('00040000'xn);
  dcl SQL_FN_NUM_LOG10                fixed bin(31) value('00080000'xn);
  dcl SQL_FN_NUM_POWER                fixed bin(31) value('00100000'xn);
  dcl SQL_FN_NUM_RADIANS              fixed bin(31) value('00200000'xn);
  dcl SQL_FN_NUM_ROUND                fixed bin(31) value('00400000'xn);
  dcl SQL_FN_NUM_TRUNCATE             fixed bin(31) value('00800000'xn);
  %end;
  /* ODBCVER >= 0x0200 */

 /* SQL_TIMEDATE_FUNCTIONS functions */

  dcl SQL_FN_TD_NOW                   fixed bin(31) value('00000001'xn);
  dcl SQL_FN_TD_CURDATE               fixed bin(31) value('00000002'xn);
  dcl SQL_FN_TD_DAYOFMONTH            fixed bin(31) value('00000004'xn);
  dcl SQL_FN_TD_DAYOFWEEK             fixed bin(31) value('00000008'xn);
  dcl SQL_FN_TD_DAYOFYEAR             fixed bin(31) value('00000010'xn);
  dcl SQL_FN_TD_MONTH                 fixed bin(31) value('00000020'xn);
  dcl SQL_FN_TD_QUARTER               fixed bin(31) value('00000040'xn);
  dcl SQL_FN_TD_WEEK                  fixed bin(31) value('00000080'xn);
  dcl SQL_FN_TD_YEAR                  fixed bin(31) value('00000100'xn);
  dcl SQL_FN_TD_CURTIME               fixed bin(31) value('00000200'xn);
  dcl SQL_FN_TD_HOUR                  fixed bin(31) value('00000400'xn);
  dcl SQL_FN_TD_MINUTE                fixed bin(31) value('00000800'xn);
  dcl SQL_FN_TD_SECOND                fixed bin(31) value('00001000'xn);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_FN_TD_TIMESTAMPADD          fixed bin(31) value('00002000'xn);
  dcl SQL_FN_TD_TIMESTAMPDIFF         fixed bin(31) value('00004000'xn);
  dcl SQL_FN_TD_DAYNAME               fixed bin(31) value('00008000'xn);
  dcl SQL_FN_TD_MONTHNAME             fixed bin(31) value('00010000'xn);
  %end;
  /* ODBCVER >= 0x0200 */

 /* SQL_SYSTEM_FUNCTIONS functions */

  dcl SQL_FN_SYS_USERNAME             fixed bin(31) value('00000001'xn);
  dcl SQL_FN_SYS_DBNAME               fixed bin(31) value('00000002'xn);
  dcl SQL_FN_SYS_IFNULL               fixed bin(31) value('00000004'xn);

 /* SQL_TIMEDATE_ADD_INTERVALS and SQL_TIMEDATE_DIFF_INTERVALS     */
 /* functions                                                      */

 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_FN_TSI_FRAC_SECOND          fixed bin(31) value('00000001'xn);
  dcl SQL_FN_TSI_SECOND               fixed bin(31) value('00000002'xn);
  dcl SQL_FN_TSI_MINUTE               fixed bin(31) value('00000004'xn);
  dcl SQL_FN_TSI_HOUR                 fixed bin(31) value('00000008'xn);
  dcl SQL_FN_TSI_DAY                  fixed bin(31) value('00000010'xn);
  dcl SQL_FN_TSI_WEEK                 fixed bin(31) value('00000020'xn);
  dcl SQL_FN_TSI_MONTH                fixed bin(31) value('00000040'xn);
  dcl SQL_FN_TSI_QUARTER              fixed bin(31) value('00000080'xn);
  dcl SQL_FN_TSI_YEAR                 fixed bin(31) value('00000100'xn);
  %end;
  /* ODBCVER >= 0x0200 */

 /* SQL_ODBC_API_CONFORMANCE values */

  dcl SQL_OAC_NONE                    fixed bin(15) value('0000'xn);
  dcl SQL_OAC_LEVEL1                  fixed bin(15) value('0001'xn);
  dcl SQL_OAC_LEVEL2                  fixed bin(15) value('0002'xn);

 /* SQL_ODBC_SAG_CLI_CONFORMANCE values */

  dcl SQL_OSCC_NOT_COMPLIANT          fixed bin(15) value('0000'xn);
  dcl SQL_OSCC_COMPLIANT              fixed bin(15) value('0001'xn);

 /* SQL_ODBC_SQL_CONFORMANCE values */

  dcl SQL_OSC_MINIMUM                 fixed bin(15) value('0000'xn);
  dcl SQL_OSC_CORE                    fixed bin(15) value('0001'xn);
  dcl SQL_OSC_EXTENDED                fixed bin(15) value('0002'xn);

 /* SQL_CONCAT_NULL_BEHAVIOR values */

  dcl SQL_CB_NULL                     fixed bin(15) value('0000'xn);
  dcl SQL_CB_NON_NULL                 fixed bin(15) value('0001'xn);

 /* SQL_CURSOR_COMMIT_BEHAVIOR and SQL_CURSOR_ROLLBACK_BEHAVIOR    */
 /* values                                                         */

  dcl SQL_CB_DELETE                   fixed bin(15) value('0000'xn);
  dcl SQL_CB_CLOSE                    fixed bin(15) value('0001'xn);
  dcl SQL_CB_PRESERVE                 fixed bin(15) value('0002'xn);

 /* SQL_IDENTIFIER_CASE values */

  dcl SQL_IC_UPPER                    fixed bin(15) value('0001'xn);
  dcl SQL_IC_LOWER                    fixed bin(15) value('0002'xn);
  dcl SQL_IC_SENSITIVE                fixed bin(15) value('0003'xn);
  dcl SQL_IC_MIXED                    fixed bin(15) value('0004'xn);

 /* SQL_TXN_CAPABLE values */

  dcl SQL_TC_NONE                     fixed bin(15) value('0000'xn);
  dcl SQL_TC_DML                      fixed bin(15) value('0001'xn);
  dcl SQL_TC_ALL                      fixed bin(15) value('0002'xn);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_TC_DDL_COMMIT               fixed bin(15) value('0003'xn);
  dcl SQL_TC_DDL_IGNORE               fixed bin(15) value('0004'xn);
  %end;
  /* ODBCVER >= 0x0200 */

 /* SQL_SCROLL_OPTIONS masks */

  dcl SQL_SO_FORWARD_ONLY             fixed bin(31) value('00000001'xn);
  dcl SQL_SO_KEYSET_DRIVEN            fixed bin(31) value('00000002'xn);
  dcl SQL_SO_DYNAMIC                  fixed bin(31) value('00000004'xn);
  dcl SQL_SO_MIXED                    fixed bin(31) value('00000008'xn);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_SO_STATIC                   fixed bin(31) value('00000010'xn);
  %end;
  /* ODBCVER >= 0x0200 */

 /* SQL_SCROLL_CONCURRENCY masks */

  dcl SQL_SCCO_READ_ONLY              fixed bin(31) value('00000001'xn);
  dcl SQL_SCCO_LOCK                   fixed bin(31) value('00000002'xn);
  dcl SQL_SCCO_OPT_ROWVER             fixed bin(31) value('00000004'xn);
  dcl SQL_SCCO_OPT_VALUES             fixed bin(31) value('00000008'xn);

 /* SQL_FETCH_DIRECTION masks */

  dcl SQL_FD_FETCH_NEXT               fixed bin(31) value('00000001'xn);
  dcl SQL_FD_FETCH_FIRST              fixed bin(31) value('00000002'xn);
  dcl SQL_FD_FETCH_LAST               fixed bin(31) value('00000004'xn);
  dcl SQL_FD_FETCH_PRIOR              fixed bin(31) value('00000008'xn);
  dcl SQL_FD_FETCH_ABSOLUTE           fixed bin(31) value('00000010'xn);
  dcl SQL_FD_FETCH_RELATIVE           fixed bin(31) value('00000020'xn);
  dcl SQL_FD_FETCH_RESUME             fixed bin(31) value('00000040'xn);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_FD_FETCH_BOOKMARK           fixed bin(31) value('00000080'xn);
  %end;
  /* ODBCVER >= 0x0200 */

 /* SQL_TXN_ISOLATION_OPTION masks */

  dcl SQL_TXN_READ_UNCOMMITTED        fixed bin(31) value('00000001'xn);
  dcl SQL_TXN_READ_COMMITTED          fixed bin(31) value('00000002'xn);
  dcl SQL_TXN_REPEATABLE_READ         fixed bin(31) value('00000004'xn);
  dcl SQL_TXN_SERIALIZABLE            fixed bin(31) value('00000008'xn);
  dcl SQL_TXN_VERSIONING              fixed bin(31) value('00000010'xn);

 /* SQL_CORRELATION_NAME values */

  dcl SQL_CN_NONE                     fixed bin(15) value('0000'xn);
  dcl SQL_CN_DIFFERENT                fixed bin(15) value('0001'xn);
  dcl SQL_CN_ANY                      fixed bin(15) value('0002'xn);

 /* SQL_NON_NULLABLE_COLUMNS values */

  dcl SQL_NNC_NULL                    fixed bin(15) value('0000'xn);
  dcl SQL_NNC_NON_NULL                fixed bin(15) value('0001'xn);

 %if (ODBCVER >= '0200'x) %then %do;
 /* SQL_NULL_COLLATION values */

  dcl SQL_NC_HIGH                     fixed bin(15) value('0000'xn);
  dcl SQL_NC_LOW                      fixed bin(15) value('0001'xn);
  dcl SQL_NC_START                    fixed bin(15) value('0002'xn);
  dcl SQL_NC_END                      fixed bin(15) value('0004'xn);

 /* SQL_FILE_USAGE values */

  dcl SQL_FILE_NOT_SUPPORTED          fixed bin(15) value('0000'xn);
  dcl SQL_FILE_TABLE                  fixed bin(15) value('0001'xn);
  dcl SQL_FILE_QUALIFIER              fixed bin(15) value('0002'xn);

 /* SQL_GETDATA_EXTENSIONS values */

  dcl SQL_GD_ANY_COLUMN               fixed bin(31) value('00000001'xn);
  dcl SQL_GD_ANY_ORDER                fixed bin(31) value('00000002'xn);
  dcl SQL_GD_BLOCK                    fixed bin(31) value('00000004'xn);
  dcl SQL_GD_BOUND                    fixed bin(31) value('00000008'xn);

 /* SQL_ALTER_TABLE values */

  dcl SQL_AT_ADD_COLUMN               fixed bin(31) value('00000001'xn);
  dcl SQL_AT_DROP_COLUMN              fixed bin(31) value('00000002'xn);

 /* SQL_POSITIONED_STATEMENTS masks */

  dcl SQL_PS_POSITIONED_DELETE        fixed bin(31) value('00000001'xn);
  dcl SQL_PS_POSITIONED_UPDATE        fixed bin(31) value('00000002'xn);
  dcl SQL_PS_SELECT_FOR_UPDATE        fixed bin(31) value('00000004'xn);

 /* SQL_GROUP_BY values */

  dcl SQL_GB_NOT_SUPPORTED            fixed bin(15) value('0000'xn);
  dcl SQL_GB_GROUP_BY_EQUALS_SELECT   fixed bin(15) value('0001'xn);
  dcl SQL_GB_GROUP_BY_CONTAINS_SELECT fixed bin(15) value('0002'xn);
  dcl SQL_GB_NO_RELATION              fixed bin(15) value('0003'xn);

 /* SQL_OWNER_USAGE masks */

  dcl SQL_OU_DML_STATEMENTS           fixed bin(31) value('00000001'xn);
  dcl SQL_OU_PROCEDURE_INVOCATION     fixed bin(31) value('00000002'xn);
  dcl SQL_OU_TABLE_DEFINITION         fixed bin(31) value('00000004'xn);
  dcl SQL_OU_INDEX_DEFINITION         fixed bin(31) value('00000008'xn);
  dcl SQL_OU_PRIVILEGE_DEFINITION     fixed bin(31) value('00000010'xn);

 /* SQL_QUALIFIER_USAGE masks */

  dcl SQL_QU_DML_STATEMENTS           fixed bin(31) value('00000001'xn);
  dcl SQL_QU_PROCEDURE_INVOCATION     fixed bin(31) value('00000002'xn);
  dcl SQL_QU_TABLE_DEFINITION         fixed bin(31) value('00000004'xn);
  dcl SQL_QU_INDEX_DEFINITION         fixed bin(31) value('00000008'xn);
  dcl SQL_QU_PRIVILEGE_DEFINITION     fixed bin(31) value('00000010'xn);

 /* SQL_SUBQUERIES masks */

  dcl SQL_SQ_COMPARISON               fixed bin(31) value('00000001'xn);
  dcl SQL_SQ_EXISTS                   fixed bin(31) value('00000002'xn);
  dcl SQL_SQ_IN                       fixed bin(31) value('00000004'xn);
  dcl SQL_SQ_QUANTIFIED               fixed bin(31) value('00000008'xn);
  dcl SQL_SQ_CORRELATED_SUBQUERIES    fixed bin(31) value('00000010'xn);

 /* SQL_UNION masks */

  dcl SQL_U_UNION                     fixed bin(31) value('00000001'xn);
  dcl SQL_U_UNION_ALL                 fixed bin(31) value('00000002'xn);

 /* SQL_BOOKMARK_PERSISTENCE values */

  dcl SQL_BP_CLOSE                    fixed bin(31) value('00000001'xn);
  dcl SQL_BP_DELETE                   fixed bin(31) value('00000002'xn);
  dcl SQL_BP_DROP                     fixed bin(31) value('00000004'xn);
  dcl SQL_BP_TRANSACTION              fixed bin(31) value('00000008'xn);
  dcl SQL_BP_UPDATE                   fixed bin(31) value('00000010'xn);
  dcl SQL_BP_OTHER_HSTMT              fixed bin(31) value('00000020'xn);
  dcl SQL_BP_SCROLL                   fixed bin(31) value('00000040'xn);

 /* SQL_STATIC_SENSITIVITY values */

  dcl SQL_SS_ADDITIONS                fixed bin(31) value('00000001'xn);
  dcl SQL_SS_DELETIONS                fixed bin(31) value('00000002'xn);
  dcl SQL_SS_UPDATES                  fixed bin(31) value('00000004'xn);

 /* SQL_LOCK_TYPESL masks */

  dcl SQL_LCK_NO_CHANGE               fixed bin(31) value('00000001'xn);
  dcl SQL_LCK_EXCLUSIVE               fixed bin(31) value('00000002'xn);
  dcl SQL_LCK_UNLOCK                  fixed bin(31) value('00000004'xn);

 /* SQL_POS_OPERATIONS masks */

  dcl SQL_POS_POSITION                fixed bin(31) value('00000001'xn);
  dcl SQL_POS_REFRESH                 fixed bin(31) value('00000002'xn);
  dcl SQL_POS_UPDATE                  fixed bin(31) value('00000004'xn);
  dcl SQL_POS_DELETE                  fixed bin(31) value('00000008'xn);
  dcl SQL_POS_ADD                     fixed bin(31) value('00000010'xn);

 /* SQL_QUALIFIER_LOCATION values */

  dcl SQL_QL_START                    fixed bin(31) value('0001'xn);
  dcl SQL_QL_END                      fixed bin(31) value('0002'xn);

 /* SQL_OJ_CAPABILITIES values */

 %if (ODBCVER >= '0201'x) %then %do;
  dcl SQL_OJ_LEFT                     fixed bin(31) value('00000001'xn);
  dcl SQL_OJ_RIGHT                    fixed bin(31) value('00000002'xn);
  dcl SQL_OJ_FULL                     fixed bin(31) value('00000004'xn);
  dcl SQL_OJ_NESTED                   fixed bin(31) value('00000008'xn);
  dcl SQL_OJ_NOT_ORDERED              fixed bin(31) value('00000010'xn);
  dcl SQL_OJ_INNER                    fixed bin(31) value('00000020'xn);
  dcl SQL_OJ_ALL_COMPARISON_OPS       fixed bin(31) value('00000040'xn);
  %end;
  /* ODBCVER >= 0x0201 */
  %end;
  /* ODBCVER >= 0x0200 */

 /* options for SQLGetStmtOption/SQLSetStmtOption */
  dcl SQL_QUERY_TIMEOUT               fixed bin(31) value(0);
  dcl SQL_MAX_ROWS                    fixed bin(31) value(1);
  dcl SQL_NOSCAN                      fixed bin(31) value(2);
  dcl SQL_MAX_LENGTH                  fixed bin(31) value(3);
  dcl SQL_ASYNC_ENABLE                fixed bin(31) value(4);
  dcl SQL_BIND_TYPE                   fixed bin(31) value(5);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_CURSOR_TYPE                 fixed bin(31) value(6);
  dcl SQL_CONCURRENCY                 fixed bin(31) value(7);
  dcl SQL_KEYSET_SIZE                 fixed bin(31) value(8);
  dcl SQL_ROWSET_SIZE                 fixed bin(31) value(9);
  dcl SQL_SIMULATE_CURSOR             fixed bin(31) value(10);
  dcl SQL_RETRIEVE_DATA               fixed bin(31) value(11);
  dcl SQL_USE_BOOKMARKS               fixed bin(31) value(12);
  dcl SQL_GET_BOOKMARK                fixed bin(31) value(13);
 /*      GetStmtOption Only */
  dcl SQL_ROW_NUMBER                  fixed bin(31) value(14);
 /*      GetStmtOption Only */
 %dcl SQL_STMT_OPT_MAX char ext;
 %SQL_STMT_OPT_MAX='SQL_ROW_NUMBER';
 %dcl @SQL_STMT_OPT_MAX char ext;
 %@SQL_STMT_OPT_MAX='@SQL_ROW_NUMBER';
  %end;
  %else
  %do;
 %dcl SQL_STMT_OPT_MAX char ext;
 %SQL_STMT_OPT_MAX='SQL_BIND_TYPE';
 %dcl @SQL_STMT_OPT_MAX char ext;
 %@SQL_STMT_OPT_MAX='@SQL_BIND_TYPE';
  %end;
  /* ODBCVER >= 0x0200 */

 %dcl SQL_STMT_OPT_MIN char ext;
 %SQL_STMT_OPT_MIN='SQL_QUERY_TIMEOUT';
 %dcl @SQL_STMT_OPT_MIN char ext;
 %@SQL_STMT_OPT_MIN='@SQL_QUERY_TIMEOUT';


 /* SQL_QUERY_TIMEOUT options */
  dcl SQL_QUERY_TIMEOUT_DEFAULT       unsigned fixed bin(31) value(0);

 /* SQL_MAX_ROWS options */
  dcl SQL_MAX_ROWS_DEFAULT            unsigned fixed bin(31) value(0);

 /* SQL_NOSCAN options */
 /*      1.0 FALSE */
  dcl SQL_NOSCAN_OFF                  unsigned fixed bin(31) value(0);
 /*      1.0 TRUE */
  dcl SQL_NOSCAN_ON                   unsigned fixed bin(31) value(1);
 %dcl SQL_NOSCAN_DEFAULT char ext;
 %SQL_NOSCAN_DEFAULT='SQL_NOSCAN_OFF';
 %dcl @SQL_NOSCAN_DEFAULT char ext;
 %@SQL_NOSCAN_DEFAULT='@SQL_NOSCAN_OFF';

 /* SQL_MAX_LENGTH options */
  dcl SQL_MAX_LENGTH_DEFAULT          unsigned fixed bin(31) value(0);

 /* SQL_ASYNC_ENABLE options */
  dcl SQL_ASYNC_ENABLE_OFF            unsigned fixed bin(31) value(0);
  dcl SQL_ASYNC_ENABLE_ON             unsigned fixed bin(31) value(1);
 %dcl SQL_ASYNC_ENABLE_DEFAULT char ext;
 %SQL_ASYNC_ENABLE_DEFAULT='SQL_ASYNC_ENABLE_OFF';
 %dcl @SQL_ASYNC_ENABLE_DEFAULT char ext;
 %@SQL_ASYNC_ENABLE_DEFAULT='@SQL_ASYNC_ENABLE_OFF';

 /* SQL_BIND_TYPE options */
  dcl SQL_BIND_BY_COLUMN              unsigned fixed bin(31) value(0);
 %dcl SQL_BIND_TYPE_DEFAULT char ext;
 %SQL_BIND_TYPE_DEFAULT='SQL_BIND_BY_COLUMN';
 %dcl @SQL_BIND_TYPE_DEFAULT char ext;
 %@SQL_BIND_TYPE_DEFAULT='@SQL_BIND_BY_COLUMN';
 /* Default value */

 /* SQL_CONCURRENCY options */
  dcl SQL_CONCUR_READ_ONLY            fixed bin(31) value(1);
  dcl SQL_CONCUR_LOCK                 fixed bin(31) value(2);
  dcl SQL_CONCUR_ROWVER               fixed bin(31) value(3);
  dcl SQL_CONCUR_VALUES               fixed bin(31) value(4);
 /* Default value  */
 %dcl SQL_CONCUR_DEFAULT char ext;
 %SQL_CONCUR_DEFAULT='SQL_CONCUR_READ_ONLY';
 %dcl @SQL_CONCUR_DEFAULT char ext;
 %@SQL_CONCUR_DEFAULT='@SQL_CONCUR_READ_ONLY';

 %if (ODBCVER >= '0200'x) %then %do;
 /* SQL_CURSOR_TYPE options */
  dcl SQL_CURSOR_FORWARD_ONLY         unsigned fixed bin(31) value(0);
  dcl SQL_CURSOR_KEYSET_DRIVEN        unsigned fixed bin(31) value(1);
  dcl SQL_CURSOR_DYNAMIC              unsigned fixed bin(31) value(2);
  dcl SQL_CURSOR_STATIC               unsigned fixed bin(31) value(3);
 /* Default value */
 %dcl SQL_CURSOR_TYPE_DEFAULT char ext;
 %SQL_CURSOR_TYPE_DEFAULT='SQL_CURSOR_FORWARD_ONLY';
 %dcl @SQL_CURSOR_TYPE_DEFAULT char ext;
 %@SQL_CURSOR_TYPE_DEFAULT='@SQL_CURSOR_FORWARD_ONLY';

 /* SQL_ROWSET_SIZE options */
  dcl SQL_ROWSET_SIZE_DEFAULT         unsigned fixed bin(31) value(1);

 /* SQL_KEYSET_SIZE options */
  dcl SQL_KEYSET_SIZE_DEFAULT         unsigned fixed bin(31) value(0);

 /* SQL_SIMULATE_CURSOR options */
  dcl SQL_SC_NON_UNIQUE               unsigned fixed bin(31) value(0);
  dcl SQL_SC_TRY_UNIQUE               unsigned fixed bin(31) value(1);
  dcl SQL_SC_UNIQUE                   unsigned fixed bin(31) value(2);

 /* SQL_RETRIEVE_DATA options */
  dcl SQL_RD_OFF                      unsigned fixed bin(31) value(0);
  dcl SQL_RD_ON                       unsigned fixed bin(31) value(1);
 %dcl SQL_RD_DEFAULT char ext;
 %SQL_RD_DEFAULT='SQL_RD_ON';
 %dcl @SQL_RD_DEFAULT char ext;
 %@SQL_RD_DEFAULT='@SQL_RD_ON';

 /* SQL_USE_BOOKMARKS options */
  dcl SQL_UB_OFF                      unsigned fixed bin(31) value(0);
  dcl SQL_UB_ON                       unsigned fixed bin(31) value(1);
 %dcl SQL_UB_DEFAULT char ext;
 %SQL_UB_DEFAULT='SQL_UB_OFF';
 %dcl @SQL_UB_DEFAULT char ext;
 %@SQL_UB_DEFAULT='@SQL_UB_OFF';

  %end;
  /* ODBCVER >= 0x0200 */

 /* options for SQLSetConnectOption/SQLGetConnectOption */
  dcl SQL_ACCESS_MODE                 fixed bin(31) value(101);
  dcl SQL_AUTOCOMMIT                  fixed bin(31) value(102);
  dcl SQL_LOGIN_TIMEOUT               fixed bin(31) value(103);
  dcl SQL_OPT_TRACE                   fixed bin(31) value(104);
  dcl SQL_OPT_TRACEFILE               fixed bin(31) value(105);
  dcl SQL_TRANSLATE_DLL               fixed bin(31) value(106);
  dcl SQL_TRANSLATE_OPTION            fixed bin(31) value(107);
  dcl SQL_TXN_ISOLATION               fixed bin(31) value(108);
  dcl SQL_CURRENT_QUALIFIER           fixed bin(31) value(109);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_ODBC_CURSORS                fixed bin(31) value(110);
  dcl SQL_QUIET_MODE                  fixed bin(31) value(111);
  dcl SQL_PACKET_SIZE                 fixed bin(31) value(112);
 %dcl SQL_CONN_OPT_MAX char ext;
 %SQL_CONN_OPT_MAX='SQL_PACKET_SIZE';
 %dcl @SQL_CONN_OPT_MAX char ext;
 %@SQL_CONN_OPT_MAX='@SQL_PACKET_SIZE';
  %end;
  %else
  %do;
 %dcl SQL_CONN_OPT_MAX char ext;
 %SQL_CONN_OPT_MAX='SQL_CURRENT_QUALIFIER';
 %dcl @SQL_CONN_OPT_MAX char ext;
 %@SQL_CONN_OPT_MAX='@SQL_CURRENT_QUALIFIER';
  %end;
  /* ODBCVER >= 0x0200 */
  dcl SQL_CONNECT_OPT_DRVR_START      fixed bin(31) value(1000);

 %dcl SQL_CONN_OPT_MIN char ext;
 %SQL_CONN_OPT_MIN='SQL_ACCESS_MODE';
 %dcl @SQL_CONN_OPT_MIN char ext;
 %@SQL_CONN_OPT_MIN='@SQL_ACCESS_MODE';

 /* SQL_ACCESS_MODE options */
  dcl SQL_MODE_READ_WRITE             unsigned fixed bin(31) value(0);
  dcl SQL_MODE_READ_ONLY              unsigned fixed bin(31) value(1);
 %dcl SQL_MODE_DEFAULT char ext;
 %SQL_MODE_DEFAULT='SQL_MODE_READ_WRITE';
 %dcl @SQL_MODE_DEFAULT char ext;
 %@SQL_MODE_DEFAULT='@SQL_MODE_READ_WRITE';

 /* SQL_AUTOCOMMIT options */
  dcl SQL_AUTOCOMMIT_OFF              unsigned fixed bin(31) value(0);
  dcl SQL_AUTOCOMMIT_ON               unsigned fixed bin(31) value(1);
 %dcl SQL_AUTOCOMMIT_DEFAULT char ext;
 %SQL_AUTOCOMMIT_DEFAULT='SQL_AUTOCOMMIT_ON';
 %dcl @SQL_AUTOCOMMIT_DEFAULT char ext;
 %@SQL_AUTOCOMMIT_DEFAULT='@SQL_AUTOCOMMIT_ON';

 /* SQL_LOGIN_TIMEOUT options */
  dcl SQL_LOGIN_TIMEOUT_DEFAULT       unsigned fixed bin(31) value(15);

 /* SQL_OPT_TRACE options */
  dcl SQL_OPT_TRACE_OFF               unsigned fixed bin(31) value(0);
  dcl SQL_OPT_TRACE_ON                unsigned fixed bin(31) value(1);
 %dcl SQL_OPT_TRACE_DEFAULT char ext;
 %SQL_OPT_TRACE_DEFAULT='SQL_OPT_TRACE_OFF';
 %dcl @SQL_OPT_TRACE_DEFAULT char ext;
 %@SQL_OPT_TRACE_DEFAULT='@SQL_OPT_TRACE_OFF';
 dcl SQL_OPT_TRACE_FILE_DEFAULT char value("\\SQL.LOG");

 %if (ODBCVER >= '0200'x) %then %do;
 /* SQL_ODBC_CURSORS options */
  dcl SQL_CUR_USE_IF_NEEDED           unsigned fixed bin(31) value(0);
  dcl SQL_CUR_USE_ODBC                unsigned fixed bin(31) value(1);
  dcl SQL_CUR_USE_DRIVER              unsigned fixed bin(31) value(2);
 %dcl SQL_CUR_DEFAULT char ext;
 %SQL_CUR_DEFAULT='SQL_CUR_USE_DRIVER';
 %dcl @SQL_CUR_DEFAULT char ext;
 %@SQL_CUR_DEFAULT='@SQL_CUR_USE_DRIVER';
  %end;
  /* ODBCVER >= 0x0200 */

 /* Column types and scopes in SQLSpecialColumns.  */
  dcl SQL_BEST_ROWID                  fixed bin(31) value(1);
  dcl SQL_ROWVER                      fixed bin(31) value(2);

  dcl SQL_SCOPE_CURROW                fixed bin(31) value(0);
  dcl SQL_SCOPE_TRANSACTION           fixed bin(31) value(1);
  dcl SQL_SCOPE_SESSION               fixed bin(31) value(2);

 /* Defines for SQLStatistics */
  dcl SQL_INDEX_UNIQUE                fixed bin(31) value(0);
  dcl SQL_INDEX_ALL                   fixed bin(31) value(1);

  dcl SQL_QUICK                       fixed bin(31) value(0);
  dcl SQL_ENSURE                      fixed bin(31) value(1);

 /* Defines for SQLStatistics (returned in the result set) */
  dcl SQL_TABLE_STAT                  fixed bin(31) value(0);
  dcl SQL_INDEX_CLUSTERED             fixed bin(31) value(1);
  dcl SQL_INDEX_HASHED                fixed bin(31) value(2);
  dcl SQL_INDEX_OTHER                 fixed bin(31) value(3);

 %if (ODBCVER >= '0200'x) %then %do;
 /* Defines for SQLSpecialColumns (returned in the result set) */
  dcl SQL_PC_UNKNOWN                  fixed bin(31) value(0);
  dcl SQL_PC_NOT_PSEUDO               fixed bin(31) value(1);
  dcl SQL_PC_PSEUDO                   fixed bin(31) value(2);
  %end;
  /* ODBCVER >= 0x0200 */
 /* SQLDataSources "fDirection" values, also used on               */
 /* SQLExtendedFetch()                                             */
 %dcl SQL_FETCH_NEXT char ext;
 %SQL_FETCH_NEXT = '1';
 %dcl SQL_FETCH_FIRST char ext;
 %SQL_FETCH_FIRST = '2';


 %if (ODBCVER >= '0200'x) %then %do;
 /*      This define is too large for RC */
 %dcl SQL_ODBC_KEYWORDS char ext;
 %SQL_ODBC_KEYWORDS = '"ABSOLUTE,ACTION,ADA,ADD,ALL,ALLOCATE,ALTER,AND,A
 NY,ARE,AS,""ASC,ASSERTION,AT,AUTHORIZATION,AVG,""BEGIN,BETWEEN,BIT,BIT_
 LENGTH,BOTH,BY,CASCADE,CASCADED,CASE,CAST,CATALOG,""CHAR,CHAR_LENGTH,CH
 ARACTER,CHARACTER_LENGTH,CHECK,CLOSE,COALESCE,""COBOL,COLLATE,COLLATION
 ,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,""CONSTRAINTS,CONTINUE,CON
 VERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,""CURRENT_DATE,CURRENT_TI
 ME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,""DATE,DAY,DEALLOCATE,DEC,DECI
 MAL,DECLARE,DEFAULT,DEFERRABLE,""DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPT
 OR,DIAGNOSTICS,DISCONNECT,""DISTINCT,DOMAIN,DOUBLE,DROP,""ELSE,END,END-
 EXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,""EXISTS,EXTERNAL,EXTRACT,""F
 ALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FORTRAN,FOUND,FROM,FULL,""GET,GLOBAL
 ,GO,GOTO,GRANT,GROUP,HAVING,HOUR,""IDENTITY,IMMEDIATE,IN,INCLUDE,INDEX,
 INDICATOR,INITIALLY,INNER,""INPUT,INSENSITIVE,INSERT,INTEGER,INTERSECT,
 INTERVAL,INTO,IS,ISOLATION,""JOIN,KEY,LANGUAGE,LAST,LEADING,LEFT,LEVEL,
 LIKE,LOCAL,LOWER,""MATCH,MAX,MIN,MINUTE,MODULE,MONTH,MUMPS,""NAMES,NATI
 ONAL,NATURAL,NCHAR,NEXT,NO,NONE,NOT,NULL,NULLIF,NUMERIC,""OCTET_LENGTH,
 OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS,""PAD,PARTIAL,PAS
 CAL,PLI,POSITION,PRECISION,PREPARE,PRESERVE,""PRIMARY,PRIOR,PRIVILEGES,
 PROCEDURE,PUBLIC,""REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,R
 OWS,""SCHEMA,SCROLL,SECOND,SECTION,SELECT,SEQUENCE,SESSION,SESSION_USER
 ,SET,SIZE,""SMALLINT,SOME,SPACE,SQL,SQLCA,SQLCODE,SQLERROR,SQLSTATE,SQL
 WARNING,""SUBSTRING,SUM,SYSTEM_USER,""TABLE,TEMPORARY,THEN,TIME,TIMESTA
 MP,TIMEZONE_HOUR,TIMEZONE_MINUTE,""TO,TRAILING,TRANSACTION,TRANSLATE,TR
 ANSLATION,TRIM,TRUE,""UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER,USIN
 G,""VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,YEA
 R"';
  %end;
  /* ODBCVER >= 0x0200 */

 /* Level 1 Prototypes */
 dcl SQLColumns entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLColumns');

 dcl SQLGetConnectOption entry (
        type SQLHDBC,
        type SQLUSMALLINT,
        type SQLPOINTER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLGetConnectOption');

 dcl SQLGetData entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLSMALLINT,
        type SQLPOINTER,
        type SQLINTEGER,
        type @SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLGetData');

 dcl SQLGetFunctions entry (
        type SQLHDBC,
        type SQLUSMALLINT,
        type @SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLGetFunctions');

 dcl SQLGetInfo entry (
        type SQLHDBC,
        type SQLUSMALLINT,
        type SQLPOINTER,
        type SQLSMALLINT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLGetInfo');

 dcl SQLGetStmtOption entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLPOINTER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLGetStmtOption');

 dcl SQLGetTypeInfo entry (
        type SQLHSTMT,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLGetTypeInfo');

 dcl SQLParamData entry (
        type SQLHSTMT,
        type SQLPOINTER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLParamData');

 dcl SQLPutData entry (
        type SQLHSTMT,
        type SQLPOINTER,
        type SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLPutData');

 dcl SQLSetConnectOption entry (
        type SQLHDBC,
        type SQLUSMALLINT,
        type SQLPOINTER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLSetConnectOption');

 dcl SQLSetStmtOption entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLUINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLSetStmtOption');

 dcl SQLSpecialColumns entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type SQLUSMALLINT,
        type SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLSpecialColumns');

 dcl SQLStatistics entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type SQLUSMALLINT,
        type SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLStatistics');

 dcl SQLTables entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLTables');


 /* Level 2 Functions                             */

 dcl SQLDataSources entry (
        type SQLHENV,
        type SQLUSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLDataSources');



 /*      Deprecated defines from prior versions of ODBC */
 /* Use SQLGetConnectOption/SQL_CURRENT_QUALIFIER */
  dcl SQL_DATABASE_NAME               fixed bin(31) value(16);
 %dcl SQL_FD_FETCH_PREV char ext;
 %SQL_FD_FETCH_PREV='SQL_FD_FETCH_PRIOR';
 %dcl @SQL_FD_FETCH_PREV char ext;
 %@SQL_FD_FETCH_PREV='@SQL_FD_FETCH_PRIOR';
 %dcl SQL_FETCH_PREV char ext;
 %SQL_FETCH_PREV='SQL_FETCH_PRIOR';
 %dcl @SQL_FETCH_PREV char ext;
 %@SQL_FETCH_PREV='@SQL_FETCH_PRIOR';
 %dcl SQL_CONCUR_TIMESTAMP char ext;
 %SQL_CONCUR_TIMESTAMP='SQL_CONCUR_ROWVER';
 %dcl @SQL_CONCUR_TIMESTAMP char ext;
 %@SQL_CONCUR_TIMESTAMP='@SQL_CONCUR_ROWVER';
 %dcl SQL_SCCO_OPT_TIMESTAMP char ext;
 %SQL_SCCO_OPT_TIMESTAMP='SQL_SCCO_OPT_ROWVER';
 %dcl @SQL_SCCO_OPT_TIMESTAMP char ext;
 %@SQL_SCCO_OPT_TIMESTAMP='@SQL_SCCO_OPT_ROWVER';
 %dcl SQL_CC_DELETE char ext;
 %SQL_CC_DELETE='SQL_CB_DELETE';
 %dcl @SQL_CC_DELETE char ext;
 %@SQL_CC_DELETE='@SQL_CB_DELETE';
 %dcl SQL_CR_DELETE char ext;
 %SQL_CR_DELETE='SQL_CB_DELETE';
 %dcl @SQL_CR_DELETE char ext;
 %@SQL_CR_DELETE='@SQL_CB_DELETE';
 %dcl SQL_CC_CLOSE char ext;
 %SQL_CC_CLOSE='SQL_CB_CLOSE';
 %dcl @SQL_CC_CLOSE char ext;
 %@SQL_CC_CLOSE='@SQL_CB_CLOSE';
 %dcl SQL_CR_CLOSE char ext;
 %SQL_CR_CLOSE='SQL_CB_CLOSE';
 %dcl @SQL_CR_CLOSE char ext;
 %@SQL_CR_CLOSE='@SQL_CB_CLOSE';
 %dcl SQL_CC_PRESERVE char ext;
 %SQL_CC_PRESERVE='SQL_CB_PRESERVE';
 %dcl @SQL_CC_PRESERVE char ext;
 %@SQL_CC_PRESERVE='@SQL_CB_PRESERVE';
 %dcl SQL_CR_PRESERVE char ext;
 %SQL_CR_PRESERVE='SQL_CB_PRESERVE';
 %dcl @SQL_CR_PRESERVE char ext;
 %@SQL_CR_PRESERVE='@SQL_CB_PRESERVE';
 /* Not supported by 2.0 drivers */
  dcl SQL_FETCH_RESUME                fixed bin(31) value(7);
 /*-SQL_CURSOR_FORWARD_ONLY */
  dcl SQL_SCROLL_FORWARD_ONLY         fixed bin(31) value(0);
 /*-SQL_CURSOR_KEYSET_DRIVEN */
 %dcl SQL_SCROLL_KEYSET_DRIVEN char ext;
 %SQL_SCROLL_KEYSET_DRIVEN = '-1';
 /*-SQL_CURSOR_DYNAMIC */
 %dcl SQL_SCROLL_DYNAMIC char ext;
 %SQL_SCROLL_DYNAMIC = '-2';
 %if (ODBCVER >= '0200'x) %then %do;
 /*-SQL_CURSOR_STATIC */
 %dcl SQL_SCROLL_STATIC char ext;
 %SQL_SCROLL_STATIC = '-3';
 %dcl SQL_PC_NON_PSEUDO char ext;
 %SQL_PC_NON_PSEUDO='SQL_PC_NOT_PSEUDO';
 %dcl @SQL_PC_NON_PSEUDO char ext;
 %@SQL_PC_NON_PSEUDO='@SQL_PC_NOT_PSEUDO';
  %end;
  /* ODBCVER >= 0x0200 */

 /*      Deprecrated functions from prior versions of ODBC */

 /*      Use SQLSetStmtOptions */
 dcl SQLSetScrollOptions entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLINTEGER,
        type SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLSetScrollOptions');


 /* IBM PL/I License Verification Routine */

 dcl ibmODBCLicInfo entry (
        type SQLHDBC )
          returns( fixed bin(15) byvalue )
           SQL_API external('ibmODBCLicInfo');

