;***************************************************************************  
;                                                                             
;  Module Name: MEERROR.H                                                     
;                                                                             
;  OS/2 2.0 Multimedia Extensions Error Return Codes                          
;                                                                             
;  Copyright (c) International Business Machines Corporation 1991, 1992       
;                         All Rights Reserved                                 
;                                                                             
;***************************************************************************  
ifndef _MEERROR_H_
_MEERROR_H_	EQU	1

endif
ifndef NO_ERROR
NO_ERROR	EQU	0 
endif
;****************************************  
;  MCI Device Manager Error Return codes   
;****************************************  
MCIERR_BASE	EQU	5000 
MCIERR_SUCCESS	EQU	0 
MCIERR_INVALID_DEVICE_ID	EQU	(MCIERR_BASE + 1 )
MCIERR_NO_MASTER	EQU	(MCIERR_BASE + 2 )
MCIERR_UNRECOGNIZED_KEYWORD	EQU	(MCIERR_BASE + 3 )
MCIERR_MASTER_CONFLICT	EQU	(MCIERR_BASE + 4 )
MCIERR_UNRECOGNIZED_COMMAND	EQU	(MCIERR_BASE + 5 )
MCIERR_HARDWARE	EQU	(MCIERR_BASE + 6 )
MCIERR_INVALID_DEVICE_NAME	EQU	(MCIERR_BASE + 7 )
MCIERR_OUT_OF_MEMORY	EQU	(MCIERR_BASE + 8 )
MCIERR_DEVICE_OPEN	EQU	(MCIERR_BASE + 9 )
MCIERR_CANNOT_LOAD_DRIVER	EQU	(MCIERR_BASE + 10 )
MCIERR_MISSING_COMMAND_STRING	EQU	(MCIERR_BASE + 11 )
MCIERR_PARAM_OVERFLOW	EQU	(MCIERR_BASE + 12 )
MCIERR_MISSING_STRING_ARGUMENT	EQU	(MCIERR_BASE + 13 )
MCIERR_BAD_INTEGER	EQU	(MCIERR_BASE + 14 )
MCIERR_PARSER_INTERNAL	EQU	(MCIERR_BASE + 15 )
MCIERR_DRIVER_INTERNAL	EQU	(MCIERR_BASE + 16 )
MCIERR_MISSING_PARAMETER	EQU	(MCIERR_BASE + 17 )
MCIERR_UNSUPPORTED_FUNCTION	EQU	(MCIERR_BASE + 18 )
MCIERR_FILE_NOT_FOUND	EQU	(MCIERR_BASE + 19 )
MCIERR_DEVICE_NOT_READY	EQU	(MCIERR_BASE + 20 )
MCIERR_INTERNAL	EQU	(MCIERR_BASE + 21 )
MCIERR_DRIVER	EQU	(MCIERR_BASE + 22 )
MCIERR_CANNOT_USE_ALL	EQU	(MCIERR_BASE + 23 )
MCIERR_MULTIPLE	EQU	(MCIERR_BASE + 24 )
MCIERR_EXTENSION_NOT_FOUND	EQU	(MCIERR_BASE + 25 )
MCIERR_OUTOFRANGE	EQU	(MCIERR_BASE + 26 )
MCIERR_CANNOT_ADD_ALIAS	EQU	(MCIERR_BASE + 27 )
MCIERR_FLAGS_NOT_COMPATIBLE	EQU	(MCIERR_BASE + 28 )
MCIERR_CANNOT_USE_NOUNLOAD	EQU	(MCIERR_BASE + 29 )
MCIERR_FILE_NOT_SAVED	EQU	(MCIERR_BASE + 30 )
MCIERR_DEVICE_TYPE_REQUIRED	EQU	(MCIERR_BASE + 31 )
MCIERR_DEVICE_LOCKED	EQU	(MCIERR_BASE + 32 )
MCIERR_DUPLICATE_ALIAS	EQU	(MCIERR_BASE + 33 )
MCIERR_INSTANCE_INACTIVE	EQU	(MCIERR_BASE + 34 )
MCIERR_COMMAND_TABLE	EQU	(MCIERR_BASE + 35 )
MCIERR_INI_FILE_LOCKED	EQU	(MCIERR_BASE + 37 )
MCIERR_NO_AUDIO_SUPPORT	EQU	(MCIERR_BASE + 40 )
MCIERR_NOT_IN_PM_SESSION	EQU	(MCIERR_BASE + 41 )
MCIERR_DUPLICATE_KEYWORD	EQU	(MCIERR_BASE + 42 )
MCIERR_COMMAND_STRING_OVERFLOW	EQU	(MCIERR_BASE + 43 )
MCIERR_DRIVER_PROC_NOT_FOUND	EQU	(MCIERR_BASE + 44 )
MCIERR_INVALID_DEVICE_TYPE	EQU	(MCIERR_BASE + 45 )
MCIERR_INVALID_DEVICE_ORDINAL	EQU	(MCIERR_BASE + 46 )
MCIERR_HEADPHONES_NOT_SET	EQU	(MCIERR_BASE + 47 )
MCIERR_SPEAKERS_NOT_SET	EQU	(MCIERR_BASE + 48 )
MCIERR_SOUND_NOT_SET	EQU	(MCIERR_BASE + 49 )
MCIERR_INVALID_BUFFER	EQU	(MCIERR_BASE + 50 )
MCIERR_INVALID_MEDIA_TYPE	EQU	(MCIERR_BASE + 51 )
MCIERR_INVALID_CONNECTOR_INDEX	EQU	(MCIERR_BASE + 52 )
MCIERR_NO_CONNECTION	EQU	(MCIERR_BASE + 53 )
MCIERR_INVALID_FLAG	EQU	(MCIERR_BASE + 54 )
MCIERR_CANNOT_LOAD_DSP_MOD	EQU	(MCIERR_BASE + 55 )
MCIERR_ALREADY_CONNECTED	EQU	(MCIERR_BASE + 56 )
MCIERR_INVALID_CALLBACK_HANDLE	EQU	(MCIERR_BASE + 57 )
MCIERR_DRIVER_NOT_FOUND	EQU	(MCIERR_BASE + 58 )
MCIERR_DUPLICATE_DRIVER	EQU	(MCIERR_BASE + 59 )
MCIERR_INI_FILE	EQU	(MCIERR_BASE + 60 )
MCIERR_INVALID_GROUP_ID	EQU	(MCIERR_BASE + 61 )
MCIERR_ID_ALREADY_IN_GROUP	EQU	(MCIERR_BASE + 62 )
MCIERR_MEDIA_CHANGED	EQU	(MCIERR_BASE + 63 )
MCIERR_MISSING_FLAG	EQU	(MCIERR_BASE + 64 )
MCIERR_UNSUPPORTED_FLAG	EQU	(MCIERR_BASE + 65 )
MCIERR_DRIVER_NOT_LOADED	EQU	(MCIERR_BASE + 66 )
MCIERR_INVALID_MODE	EQU	(MCIERR_BASE + 67 )
MCIERR_INVALID_ITEM_FLAG	EQU	(MCIERR_BASE + 68 )
MCIERR_INVALID_TIME_FORMAT_FLAG	EQU	(MCIERR_BASE + 69 )
MCIERR_SPEED_FORMAT_FLAG	EQU	(MCIERR_BASE + 70 )
MCIERR_INVALID_AUDIO_FLAG	EQU	(MCIERR_BASE + 71 )
MCIERR_NODEFAULT_DEVICE	EQU	(MCIERR_BASE + 72 )
MCIERR_DUPLICATE_EXTENSION	EQU	(MCIERR_BASE + 73 )
MCIERR_FILE_ATTRIBUTE	EQU	(MCIERR_BASE + 74 )
MCIERR_DUPLICATE_CUEPOINT	EQU	(MCIERR_BASE + 75 )
MCIERR_INVALID_CUEPOINT	EQU	(MCIERR_BASE + 76 )
MCIERR_CUEPOINT_LIMIT_REACHED	EQU	(MCIERR_BASE + 77 )
MCIERR_MISSING_ITEM	EQU	(MCIERR_BASE + 78 )
MCIERR_MISSING_TIME_FORMAT	EQU	(MCIERR_BASE + 79 )
MCIERR_MISSING_SPEED_FORMAT	EQU	(MCIERR_BASE + 80 )
MCIERR_INVALID_CONNECTOR_TYPE	EQU	(MCIERR_BASE + 81 )
MCIERR_TARGET_DEVICE_FULL	EQU	(MCIERR_BASE + 82 )
MCIERR_UNSUPPORTED_CONN_TYPE	EQU	(MCIERR_BASE + 83 )
MCIERR_CANNOT_MODIFY_CONNECTOR	EQU	(MCIERR_BASE + 84 )
MCIERR_RECORD_ABORTED	EQU	(MCIERR_BASE + 85 )
MCIERR_GROUP_COMMAND	EQU	(MCIERR_BASE + 86 )
MCIERR_DEVICE_NOT_FOUND	EQU	(MCIERR_BASE + 87 )
MCIERR_RESOURCE_NOT_AVAILABLE	EQU	(MCIERR_BASE + 88 )
MCIERR_INVALID_IO_PROC	EQU	(MCIERR_BASE + 89 )
MCIERR_WAVE_OUTPUTSINUSE	EQU	(MCIERR_BASE + 90 )
MCIERR_WAVE_SETOUTPUTINUSE	EQU	(MCIERR_BASE + 91 )
MCIERR_WAVE_INPUTSINUSE	EQU	(MCIERR_BASE + 92 )
MCIERR_WAVE_SETINPUTINUSE	EQU	(MCIERR_BASE + 93 )
MCIERR_WAVE_OUTPUTUNSPECIFIED	EQU	(MCIERR_BASE + 94 )
MCIERR_WAVE_INPUTUNSPECIFIED	EQU	(MCIERR_BASE + 95 )
MCIERR_WAVE_OUTPUTSUNSUITABLE	EQU	(MCIERR_BASE + 96 )
MCIERR_WAVE_SETOUTPUTUNSUITABLE	EQU	(MCIERR_BASE + 97 )
MCIERR_WAVE_INPUTSUNSUITABLE	EQU	(MCIERR_BASE + 98 )
MCIERR_WAVE_SETINPUTUNSUITABLE	EQU	(MCIERR_BASE + 99 )
MCIERR_SEQ_DIV_INCOMPATIBLE	EQU	(MCIERR_BASE + 100 )
MCIERR_SEQ_PORT_INUSE	EQU	(MCIERR_BASE + 101 )
MCIERR_SEQ_PORT_NONEXISTENT	EQU	(MCIERR_BASE + 102 )
MCIERR_SEQ_PORT_MAPNODEVICE	EQU	(MCIERR_BASE + 103 )
MCIERR_SEQ_PORT_MISCERROR	EQU	(MCIERR_BASE + 104 )
MCIERR_SEQ_TIMER	EQU	(MCIERR_BASE + 105 )
MCIERR_VDP_COMMANDCANCELLED	EQU	(MCIERR_BASE + 106 )
MCIERR_VDP_COMMANDFAILURE	EQU	(MCIERR_BASE + 107 )
MCIERR_VDP_NOTSPUNUP	EQU	(MCIERR_BASE + 108 )
MCIERR_VDP_NOCHAPTER	EQU	(MCIERR_BASE + 109 )
MCIERR_VDP_NOSIDE	EQU	(MCIERR_BASE + 110 )
MCIERR_VDP_NOSIZE	EQU	(MCIERR_BASE + 111 )
MCIERR_VDP_INVALID_TIMEFORMAT	EQU	(MCIERR_BASE + 112 )
MCIERR_CLIPBOARD_ERROR	EQU	(MCIERR_BASE + 114 )
MCIERR_CANNOT_CONVERT	EQU	(MCIERR_BASE + 115 )
MCIERR_CANNOT_REDO	EQU	(MCIERR_BASE + 116 )
MCIERR_CANNOT_UNDO	EQU	(MCIERR_BASE + 117 )
MCIERR_CLIPBOARD_EMPTY	EQU	(MCIERR_BASE + 118 )
MCIERR_INVALID_WORKPATH	EQU	(MCIERR_BASE + 119 )
MCIERR_INDETERMINATE_LENGTH	EQU	(MCIERR_BASE + 120 )
MCIERR_DUPLICATE_EA	EQU	(MCIERR_BASE + 121 )
MCIERR_INVALID_CONNECTION	EQU	(MCIERR_BASE + 122 )
MCIERR_CHANNEL_OFF	EQU	(MCIERR_BASE + 123 )
MCIERR_CANNOT_CHANGE_CHANNEL	EQU	(MCIERR_BASE + 124 )
MCIERR_FILE_IO	EQU	(MCIERR_BASE + 125 )
MCIERR_SYSTEM_FILE	EQU	(MCIERR_BASE + 126 )
MCIERR_DISPLAY_RESOLUTION	EQU	(MCIERR_BASE + 127 )
MCIERR_NO_ASYNC_PLAY_ACTIVE	EQU	(MCIERR_BASE + 128 )
MCIERR_UNSUPP_FORMAT_TAG	EQU	(MCIERR_BASE + 129 )
MCIERR_UNSUPP_SAMPLESPERSEC	EQU	(MCIERR_BASE + 130 )
MCIERR_UNSUPP_BITSPERSAMPLE	EQU	(MCIERR_BASE + 131 )
MCIERR_UNSUPP_CHANNELS	EQU	(MCIERR_BASE + 132 )
MCIERR_UNSUPP_FORMAT_MODE	EQU	(MCIERR_BASE + 133 )
MCIERR_NO_DEVICE_DRIVER	EQU	(MCIERR_BASE + 134 )
MCIERR_CODEC_NOT_SUPPORTED	EQU	(MCIERR_BASE + 135 )
MCIERR_TUNER_NO_HW	EQU	(MCIERR_BASE + 136 )
MCIERR_TUNER_NO_AFC	EQU	(MCIERR_BASE + 137 )
MCIERR_TUNER_AFC_ON	EQU	(MCIERR_BASE + 138 )
MCIERR_TUNER_CHANNEL_SKIPPED	EQU	(MCIERR_BASE + 139 )
MCIERR_TUNER_CHANNEL_TOO_LOW	EQU	(MCIERR_BASE + 140 )
MCIERR_TUNER_CHANNEL_TOO_HIGH	EQU	(MCIERR_BASE + 141 )
MCIERR_AUD_CHANNEL_OUTOFRANGE	EQU	(MCIERR_BASE + 142 )
MCIERR_TUNER_INVALID_REGION	EQU	(MCIERR_BASE + 143 )
MCIERR_SIGNAL_INVALID	EQU	(MCIERR_BASE + 144 )
MCIERR_TUNER_MODE	EQU	(MCIERR_BASE + 145 )
MCIERR_TUNER_REGION_NOT_SET	EQU	(MCIERR_BASE + 146 )
MCIERR_TUNER_CHANNEL_NOT_SET	EQU	(MCIERR_BASE + 147 )
MCIERR_UNSUPP_CLASS	EQU	(MCIERR_BASE + 148 )
MCIERR_UNSUPPORTED_ATTRIBUTE	EQU	(MCIERR_BASE + 149 )
MCIERR_CUSTOM_DRIVER_BASE	EQU	(MCIERR_BASE + 256 )
;*****************************************  
;  Sync/Stream Manager Error Return codes   
;*****************************************  
MEBASE	EQU	(MCIERR_BASE + 500 )
ERROR_INVALID_STREAM	EQU	(MEBASE + 1 )
ERROR_INVALID_HID	EQU	(MEBASE + 2 )
ERROR_INVALID_NETWORK	EQU	(MEBASE + 3 )
ERROR_INVALID_OBJTYPE	EQU	(MEBASE + 4 )
ERROR_INVALID_FLAG	EQU	(MEBASE + 5 )
ERROR_INVALID_EVCB	EQU	(MEBASE + 6 )
ERROR_INVALID_EVENT	EQU	(MEBASE + 7 )
ERROR_INVALID_MMTIME	EQU	(MEBASE + 8 )
ERROR_INVALID_NUMSLAVES	EQU	(MEBASE + 9 )
ERROR_INVALID_REQUEST	EQU	(MEBASE + 10 )
ERROR_INVALID_SPCBKEY	EQU	(MEBASE + 11 )
ERROR_INVALID_HNDLR_NAME	EQU	(MEBASE + 12 )
ERROR_INVALID_PROTOCOL	EQU	(MEBASE + 13 )
ERROR_INVALID_BUFFER_SIZE	EQU	(MEBASE + 14 )
ERROR_INVALID_BUFFER_RETURNED	EQU	(MEBASE + 15 )
ERROR_INVALID_ACB	EQU	(MEBASE + 16 )
ERROR_INVALID_RECORD_RETURNED	EQU	(MEBASE + 17 )
ERROR_INVALID_MESSAGE	EQU	(MEBASE + 18 )
ERROR_STREAM_NOT_OWNER	EQU	(MEBASE + 99 )
ERROR_STREAM_USED	EQU	(MEBASE + 100 )
ERROR_STREAM_CREATION	EQU	(MEBASE + 101 )
ERROR_STREAM_NOTMASTER	EQU	(MEBASE + 102 )
ERROR_STREAM_NOT_STOP	EQU	(MEBASE + 103 )
ERROR_STREAM_OPERATION	EQU	(MEBASE + 104 )
ERROR_STREAM_STOP_PENDING	EQU	(MEBASE + 105 )
ERROR_STREAM_ALREADY_STOP	EQU	(MEBASE + 106 )
ERROR_STREAM_ALREADY_PAUSE	EQU	(MEBASE + 107 )
ERROR_STREAM_NOT_STARTED	EQU	(MEBASE + 108 )
ERROR_STREAM_NOT_ACTIVE	EQU	(MEBASE + 109 )
ERROR_START_STREAM	EQU	(MEBASE + 110 )
ERROR_MASTER_USED	EQU	(MEBASE + 111 )
ERROR_SPCBKEY_MISMATCH	EQU	(MEBASE + 112 )
ERROR_INSUFF_BUFFER	EQU	(MEBASE + 113 )
ERROR_ALLOC_RESOURCES	EQU	(MEBASE + 114 )
ERROR_ACCESS_OBJECT	EQU	(MEBASE + 115 )
ERROR_HNDLR_REGISTERED	EQU	(MEBASE + 116 )
ERROR_DATA_ITEM_NOT_SPECIFIED	EQU	(MEBASE + 117 )
ERROR_INVALID_SEQUENCE	EQU	(MEBASE + 118 )
ERROR_INITIALIZATION	EQU	(MEBASE + 119 )
ERROR_READING_INI	EQU	(MEBASE + 120 )
ERROR_LOADING_HNDLR	EQU	(MEBASE + 121 )
ERROR_HNDLR_NOT_FOUND	EQU	(MEBASE + 122 )
ERROR_SPCB_NOT_FOUND	EQU	(MEBASE + 123 )
ERROR_DEVICE_NOT_FOUND	EQU	(MEBASE + 124 )
ERROR_TOO_MANY_EVENTS	EQU	(MEBASE + 125 )
ERROR_DEVICE_OVERRUN	EQU	(MEBASE + 126 )
ERROR_DEVICE_UNDERRUN	EQU	(MEBASE + 127 )
ERROR_HNDLR_NOT_IN_INI	EQU	(MEBASE + 128 )
ERROR_QUERY_STREAM_TIME	EQU	(MEBASE + 129 )
ERROR_DATA_ITEM_NOT_SEEKABLE	EQU	(MEBASE + 130 )
ERROR_NOT_SEEKABLE_BY_TIME	EQU	(MEBASE + 131 )
ERROR_NOT_SEEKABLE_BY_BYTES	EQU	(MEBASE + 132 )
ERROR_STREAM_NOT_SEEKABLE	EQU	(MEBASE + 133 )
ERROR_PLAYLIST_STACK_OVERFLOW	EQU	(MEBASE + 135 )
ERROR_PLAYLIST_STACK_UNDERFLOW	EQU	(MEBASE + 136 )
ERROR_LOCKING_BUFFER	EQU	(MEBASE + 137 )
ERROR_UNLOCKING_BUFFER	EQU	(MEBASE + 138 )
ERROR_SEEK_PAST_END	EQU	(MEBASE + 139 )
ERROR_SEEK_BACK_NOT_SUPPORTED	EQU	(MEBASE + 140 )
ERROR_INTERNAL_ERROR	EQU	(MEBASE + 141 )
ERROR_INTERNAL_CORRUPT	EQU	(MEBASE + 142 )
ERROR_INSUFF_MEM	EQU	(MEBASE + 143 )
ERROR_LARGE_SEEK_BY_TIME	EQU	(MEBASE + 144 )
ERROR_STREAM_PREROLLING	EQU	(MEBASE + 145 )
ERROR_INI_FILE	EQU	(MEBASE + 146 )
ERROR_SEEK_BEFORE_BEGINNING	EQU	(MEBASE + 147 )
ERROR_TOO_MANY_HANDLERS	EQU	(MEBASE + 148 )
ERROR_ALLOC_HEAP	EQU	(MEBASE + 149 )
ERROR_END_OF_PLAYLIST	EQU	(MEBASE + 150 )
ERROR_TOO_MANY_STREAMS	EQU	(MEBASE + 151 )
ERROR_FILE_FORMAT_INCORRECT	EQU	(MEBASE + 152 )
ERROR_DESTROY_STREAM	EQU	(MEBASE + 153 )
ERROR_INVALID_NUMMASTERS	EQU	(MEBASE + 154 )
ERROR_MASTER_CONFLICT	EQU	(MEBASE + 155 )
ERROR_NO_MASTER	EQU	(MEBASE + 156 )
ERROR_NO_SYNC	EQU	(MEBASE + 157 )
ERROR_STREAM_ALREADY_IN_NETWORK	EQU	(MEBASE + 158 )
ERROR_NO_STREAMS_IN_NETWORK	EQU	(MEBASE + 159 )
ERROR_MISSING_EVENT_ROUTINE	EQU	(MEBASE + 160 )
ERROR_CAN_NOT_REMOVE_STREAM	EQU	(MEBASE + 161 )
ERROR_BUFFER_NOT_AVAILABLE	EQU	(MEBASE + 400 )
ERROR_TOO_MANY_BUFFERS	EQU	(MEBASE + 401 )
ERROR_TOO_MANY_RECORDS	EQU	(MEBASE + 402 )
; ----- ERROR_INVALID_PROTOCOL ulErrorStatus defines -----  
; ----- Refer to SHC_NEGOTIATE_RESULT api.  
PROTOCOL_SPCBLENGTH	EQU	1 
PROTOCOL_SPCBKEY	EQU	2 
PROTOCOL_DATAFLAG	EQU	3 
PROTOCOL_NUMRECORDS	EQU	4 
PROTOCOL_BLOCKSIZE	EQU	5 
PROTOCOL_BUFFERSIZE	EQU	6 
PROTOCOL_MINNUMBUFFERS	EQU	7 
PROTOCOL_MAXNUMBUFFERS	EQU	8 
PROTOCOL_SOURCESTART	EQU	9 
PROTOCOL_TARGETSTART	EQU	10 
PROTOCOL_BUFFERFLAG	EQU	11 
PROTOCOL_HANDLERFLAG	EQU	12 
PROTOCOL_SYNCTOLERANCE	EQU	13 
PROTOCOL_SYNCINTERVAL	EQU	14 
PROTOCOL_INTERNALERROR	EQU	-1 
;**********************************  
;  MMIO Manager Error Return codes   
;**********************************  
MMIOERR_BASE	EQU	(MEBASE + 1000 )
MMIOERR_UNBUFFERED	EQU	(MMIOERR_BASE + 1 )
MMIOERR_CANNOTWRITE	EQU	(MMIOERR_BASE + 2 )
MMIOERR_CHUNKNOTFOUND	EQU	(MMIOERR_BASE + 3 )
MMIOERR_INVALID_HANDLE	EQU	(MMIOERR_BASE + 4 )
MMIOERR_INVALID_PARAMETER	EQU	(MMIOERR_BASE + 5 )
MMIOERR_INTERNAL_SYSTEM	EQU	(MMIOERR_BASE + 6 )
MMIOERR_NO_CORE	EQU	(MMIOERR_BASE + 7 )
MMIOERR_INI_OPEN	EQU	(MMIOERR_BASE + 8 )
MMIOERR_INI_READ	EQU	(MMIOERR_BASE + 9 )
MMIOERR_INVALID_BUFFER_LENGTH	EQU	(MMIOERR_BASE + 10 )
MMIOERR_NO_BUFFER_ALLOCATED	EQU	(MMIOERR_BASE + 11 )
MMIOERR_NO_FLUSH_FOR_MEM_FILE	EQU	(MMIOERR_BASE + 12 )
MMIOERR_NO_FLUSH_NEEDED	EQU	(MMIOERR_BASE + 13 )
MMIOERR_READ_ONLY_FILE	EQU	(MMIOERR_BASE + 14 )
MMIOERR_WRITE_ONLY_FILE	EQU	(MMIOERR_BASE + 15 )
MMIOERR_INSTALL_PROC_FAILED	EQU	(MMIOERR_BASE + 16 )
MMIOERR_READ_FAILED	EQU	(MMIOERR_BASE + 17 )
MMIOERR_WRITE_FAILED	EQU	(MMIOERR_BASE + 18 )
MMIOERR_SEEK_FAILED	EQU	(MMIOERR_BASE + 19 )
MMIOERR_CANNOTEXPAND	EQU	(MMIOERR_BASE + 20 )
MMIOERR_FREE_FAILED	EQU	(MMIOERR_BASE + 21 )
MMIOERR_EOF_SEEN	EQU	(MMIOERR_BASE + 22 )
MMIOERR_INVALID_ACCESS_FLAG	EQU	(MMIOERR_BASE + 23 )
MMIOERR_INVALID_STRUCTURE	EQU	(MMIOERR_BASE + 24 )
MMIOERR_INVALID_SIZE	EQU	(MMIOERR_BASE + 25 )
MMIOERR_INVALID_FILENAME	EQU	(MMIOERR_BASE + 26 )
MMIOERR_CF_DUPLICATE_SEEN	EQU	(MMIOERR_BASE + 27 )
MMIOERR_CF_ENTRY_NO_CORE	EQU	(MMIOERR_BASE + 28 )
MMIOERR_CF_WO_UNSUPPORTED	EQU	(MMIOERR_BASE + 29 )
MMIOERR_CF_ELEMENTS_OPEN	EQU	(MMIOERR_BASE + 30 )
MMIOERR_CF_NON_BND_FILE	EQU	(MMIOERR_BASE + 31 )
MMIOERR_CF_ENTRY_NOT_FOUND	EQU	(MMIOERR_BASE + 32 )
MMIOERR_DELETE_FAILED	EQU	(MMIOERR_BASE + 33 )
MMIOERR_OUTOFMEMORY	EQU	(MMIOERR_BASE + 34 )
MMIOERR_INVALID_DLLNAME	EQU	(MMIOERR_BASE + 35 )
MMIOERR_INVALID_PROCEDURENAME	EQU	(MMIOERR_BASE + 36 )
MMIOERR_MATCH_NOT_FOUND	EQU	(MMIOERR_BASE + 37 )
MMIOERR_SEEK_BEFORE_BEGINNING	EQU	(MMIOERR_BASE + 38 )
MMIOERR_INVALID_FILE	EQU	(MMIOERR_BASE + 39 )
MMIOERR_QOSUNAVAILABLE	EQU	(MMIOERR_BASE + 40 )
MMIOERR_MEDIA_NOT_FOUND	EQU	(MMIOERR_BASE + 41 )
MMIOERR_ERROR_IN_FRAME_DATA	EQU	(MMIOERR_BASE + 42 )
MMIOERR_INVALID_DIM_ALIGN	EQU	(MMIOERR_BASE + 43 )
MMIOERR_CODEC_NOT_SUPPORTED	EQU	(MMIOERR_BASE + 44 )
MMIOERR_UNSUPPORTED_FUNCTION	EQU	(MMIOERR_BASE + 45 )
MMIOERR_CLIPBRD_ERROR	EQU	(MMIOERR_BASE + 46 )
MMIOERR_CLIPBRD_ACTIVE	EQU	(MMIOERR_BASE + 47 )
MMIOERR_CLIPBRD_EMPTY	EQU	(MMIOERR_BASE + 48 )
MMIOERR_NEED_NEW_FILENAME	EQU	(MMIOERR_BASE + 49 )
MMIOERR_INVALID_TRACK_OPERATION	EQU	(MMIOERR_BASE + 50 )
MMIOERR_INCOMPATIBLE_DATA	EQU	(MMIOERR_BASE + 51 )
MMIOERR_ACCESS_DENIED	EQU	(MMIOERR_BASE + 52 )
MMIOERR_MISSING_FLAG	EQU	(MMIOERR_BASE + 53 )
MMIOERR_INVALID_ITEM_FLAG	EQU	(MMIOERR_BASE + 54 )
;************************************  
;  Real-Time MIDI Error Return Codes   
;************************************  
MIDIERR_BASE	EQU	(MMIOERR_BASE + 500 )
MIDIERR_DUPLICATE_INSTANCE_NAME	EQU	(MIDIERR_BASE + 1 )
MIDIERR_HARDWARE_FAILED	EQU	(MIDIERR_BASE + 2 )
MIDIERR_INTERNAL_SYSTEM	EQU	(MIDIERR_BASE + 3 )
MIDIERR_INVALID_BUFFER_LENGTH	EQU	(MIDIERR_BASE + 4 )
MIDIERR_INVALID_CLASS_NUMBER	EQU	(MIDIERR_BASE + 5 )
MIDIERR_INVALID_CONFIG_DATA	EQU	(MIDIERR_BASE + 6 )
MIDIERR_INVALID_FLAG	EQU	(MIDIERR_BASE + 7 )
MIDIERR_INVALID_INSTANCE_NAME	EQU	(MIDIERR_BASE + 8 )
MIDIERR_INVALID_INSTANCE_NUMBER	EQU	(MIDIERR_BASE + 9 )
MIDIERR_INVALID_PARAMETER	EQU	(MIDIERR_BASE + 10 )
MIDIERR_INVALID_SETUP	EQU	(MIDIERR_BASE + 11 )
MIDIERR_NO_DRIVER	EQU	(MIDIERR_BASE + 12 )
MIDIERR_NO_DEFAULT_HW_NODE	EQU	(MIDIERR_BASE + 13 )
MIDIERR_NOT_ALLOWED	EQU	(MIDIERR_BASE + 14 )
MIDIERR_NOTIFY_MISSED	EQU	(MIDIERR_BASE + 15 )
MIDIERR_RESOURCE_NOT_AVAILABLE	EQU	(MIDIERR_BASE + 16 )
MIDIERR_SENDONLY	EQU	(MIDIERR_BASE + 17 )
MIDIERR_RECEIVEONLY	EQU	(MIDIERR_BASE + 18 )
TIMERERR_BASE	EQU	(MIDIERR_BASE + 100 )
TIMERERR_INVALID_PARAMETER	EQU	(TIMERERR_BASE + 1 )
TIMERERR_INTERNAL_SYSTEM	EQU	(TIMERERR_BASE + 2 )
;**********************************  
;  User defined Error Return codes   
;**********************************  
USERERR_BASE	EQU	(MMIOERR_BASE + 1000 )
