 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: BSESUB.CPY                                   */
 /*                                                                  */
 /*  NAME - BSESUB.CPY                                               */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    OS/2 base PL/I include file.                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The folowing symbols are used for conditional includes           */
 /*                                                                  */
 /* Subcomponents marked with "+" are partially included by default: */
 /*                                                                  */
 /*   #define:                To include:                            */
 /*                                                                  */
 /*   INCL_KBD                KBD                                    */
 /*   INCL_VIO                VIO                                    */
 /*   INCL_MOU                MOU                                    */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %if BSESUB__='Y' %then %do;
   %BSESUB__='Y';
   %if INCL_SUB='Y' %then %do;
     %INCL_KBD='Y';
     %INCL_VIO='Y';
     %INCL_MOU='Y';
   %end;
   %if INCL_KBD='Y' %then %do;
     %dcl KbdCharIn char;
     %KbdCharIn='KBD16CHARIN';
     %dcl KbdClose char;
     %KbdClose='KBD16CLOSE';
     %dcl KbdDeRegister char;
     %KbdDeRegister='KBD16DEREGISTER';
     %dcl KbdFlushBuffer char;
     %KbdFlushBuffer='KBD16FLUSHBUFFER';
     %dcl KbdFreeFocus char;
     %KbdFreeFocus='KBD16FREEFOCUS';
     %dcl KbdGetCp char;
     %KbdGetCp='KBD16GETCP';
     %dcl KbdGetFocus char;
     %KbdGetFocus='KBD16GETFOCUS';
     %dcl KbdGetHWID char;
     %KbdGetHWID='KBD16GETHWID';
     %dcl KbdGetStatus char;
     %KbdGetStatus='KBD16GETSTATUS';
     %dcl KbdOpen char;
     %KbdOpen='KBD16OPEN';
     %dcl KbdPeek char;
     %KbdPeek='KBD16PEEK';
     %dcl KbdRegister char;
     %KbdRegister='KBD16REGISTER';
     %dcl KbdSetCp char;
     %KbdSetCp='KBD16SETCP';
     %dcl KbdSetCustXt char;
     %KbdSetCustXt='KBD16SETCUSTXT';
     %dcl KbdSetFgnd char;
     %KbdSetFgnd='KBD16SETFGND';
     %dcl KbdSetHWID char;
     %KbdSetHWID='KBD16SETHWID';
     %dcl KbdSetStatus char;
     %KbdSetStatus='KBD16SETSTATUS';
     %dcl KbdStringIn char;
     %KbdStringIn='KBD16STRINGIN';
     %dcl KbdSynch char;
     %KbdSynch='KBD16SYNCH';
     %dcl KbdXlate char;
     %KbdXlate='KBD16XLATE';
     %dcl HKBD char;
     %HKBD='fixed bin(16) unsigned';
     %dcl PHKBD char;
     %PHKBD='pointer';
     dcl KbdRegister entry (
            PSZ,
            PSZ,
            ULONG)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl KR_KBDCHARIN fixed bin(31) value('00_00_00_01'xn);
     dcl KR_KBDPEEK fixed bin(31) value('00_00_00_02'xn);
     dcl KR_KBDFLUSHBUFFER fixed bin(31) value('00_00_00_04'xn);
     dcl KR_KBDGETSTATUS fixed bin(31) value('00_00_00_08'xn);
     dcl KR_KBDSETSTATUS fixed bin(31) value('00_00_00_10'xn);
     dcl KR_KBDSTRINGIN fixed bin(31) value('00_00_00_20'xn);
     dcl KR_KBDOPEN fixed bin(31) value('00_00_00_40'xn);
     dcl KR_KBDCLOSE fixed bin(31) value('00_00_00_80'xn);
     dcl KR_KBDGETFOCUS fixed bin(31) value('00_00_01_00'xn);
     dcl KR_KBDFREEFOCUS fixed bin(31) value('00_00_02_00'xn);
     dcl KR_KBDGETCP fixed bin(31) value('00_00_04_00'xn);
     dcl KR_KBDSETCP fixed bin(31) value('00_00_08_00'xn);
     dcl KR_KBDXLATE fixed bin(31) value('00_00_10_00'xn);
     dcl KR_KBDSETCUSTXT fixed bin(31) value('00_00_20_00'xn);

     %dcl IO_WAIT char;
     %IO_WAIT=0;
     %dcl IO_NOWAIT char;
     %IO_NOWAIT=1;

     dcl KbdDeRegister entry (
            )
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl KBDKEYINFO char;
     %KBDKEYINFO='char(stg(#KBDKEYINFO))';
     dcl 1 #KBDKEYINFO based(null()) unaligned,
           2 chChar UCHAR,
           2 chScan UCHAR,
           2 fbStatus UCHAR,
           2 bNlsShift UCHAR,
           2 fsState USHORT,
           2 time ULONG;
     %dcl PKBDKEYINFO char;
     %PKBDKEYINFO='pointer';
     dcl KbdCharIn entry (
            PKBDKEYINFO,
            USHORT,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdPeek entry (
            PKBDKEYINFO,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl STRINGINBUF char;
     %STRINGINBUF='char(stg(#STRINGINBUF))';
     dcl 1 #STRINGINBUF based(null()) unaligned,
           2 cb USHORT,
           2 cchIn USHORT;
     %dcl PSTRINGINBUF char;
     %PSTRINGINBUF='pointer';
     dcl KbdStringIn entry (
            PCH,
            PSTRINGINBUF,
            USHORT,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdFlushBuffer entry (
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl KEYBOARD_ECHO_ON fixed bin(16) value('00_01'xn);
     dcl KEYBOARD_ECHO_OFF fixed bin(16) value('00_02'xn);
     dcl KEYBOARD_BINARY_MODE fixed bin(16) value('00_04'xn);
     dcl KEYBOARD_ASCII_MODE fixed bin(16) value('00_08'xn);
     dcl KEYBOARD_MODIFY_STATE fixed bin(16) value('00_10'xn);
     dcl KEYBOARD_MODIFY_INTERIM fixed bin(16) value('00_20'xn);
     dcl KEYBOARD_MODIFY_TURNAROUND fixed bin(16) value('00_40'xn);
     dcl KEYBOARD_2B_TURNAROUND fixed bin(16) value('00_80'xn);
     dcl KEYBOARD_SHIFT_REPORT fixed bin(16) value('01_00'xn);

     %if INCL_DOSDEVIOCTL='Y' %then %do;
       dcl KBDSTF_RIGHTSHIFT   fixed bin(16) value('00_01'xn);
       dcl KBDSTF_LEFTSHIFT    fixed bin(16) value('00_02'xn);
       dcl KBDSTF_CONTROL      fixed bin(16) value('00_04'xn);
       dcl KBDSTF_ALT          fixed bin(16) value('00_08'xn);
       dcl KBDSTF_SCROLLLOCK_ON fixed bin(16) value('00_10'xn);
       dcl KBDSTF_NUMLOCK_ON   fixed bin(16) value('00_20'xn);
       dcl KBDSTF_CAPSLOCK_ON  fixed bin(16) value('00_40'xn);
       dcl KBDSTF_INSERT_ON   fixed bin(16) value('00_80'xn);
       dcl KBDSTF_LEFTCONTROL fixed bin(16) value('01_00'xn);
       dcl KBDSTF_LEFTALT     fixed bin(16) value('02_00'xn);
       dcl KBDSTF_RIGHTCONTROL fixed bin(16) value('04_00'xn);
       dcl KBDSTF_RIGHTALT    fixed bin(16) value('08_00'xn);
       dcl KBDSTF_SCROLLLOCK  fixed bin(16) value('10_00'xn);
       dcl KBDSTF_NUMLOCK     fixed bin(16) value('20_00'xn);
       dcl KBDSTF_CAPSLOCK    fixed bin(16) value('40_00'xn);
       dcl KBDSTF_SYSREQ      fixed bin(16) value('80_00'xn);
     %end;
     %dcl KBDINFO char;
     %KBDINFO='char(stg(#KBDINFO))';
     dcl 1 #KBDINFO based(null()) unaligned,
           2 cb USHORT,
           2 fsMask USHORT,
           2 chTurnAround USHORT,
           2 fsInterim USHORT,
           2 fsState USHORT;
     %dcl PKBDINFO char;
     %PKBDINFO='pointer';
     dcl KbdSetStatus entry (
            PKBDINFO,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdGetStatus entry (
            PKBDINFO,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdSetCp entry (
            USHORT,
            USHORT,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdGetCp entry (
            ULONG,
            PUSHORT,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdOpen entry (
            PHKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdClose entry (
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdGetFocus entry (
            USHORT,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdFreeFocus entry (
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdSynch entry (
            USHORT)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdSetFgnd entry (
            )
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl KBDHWID char;
     %KBDHWID='char(stg(#KBDHWID))';
     dcl 1 #KBDHWID based(null()) unaligned,
           2 cb USHORT,
           2 idKbd USHORT,
           2 usReserved1 USHORT,
           2 usReserved2 USHORT;
     %dcl PKBDHWID char;
     %PKBDHWID='pointer';
     dcl KbdGetHWID entry (
            PKBDHWID,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdSetHWID entry (
            PKBDHWID,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl KBDTRF_SHIFT_KEY_IN bit(8) value('00_00_00_01'b);
     dcl KBDTRF_CONVERSION_REQUEST bit(8) value('00_10_00_00'b);
     dcl KBDTRF_FINAL_CHAR_IN bit(8) value('01_00_00_00'b);
     dcl KBDTRF_INTERIM_CHAR_IN bit(8) value('10_00_00_00'b);

     %dcl KBDTRANS char;
     %KBDTRANS='char(stg(#KBDTRANS))';
     dcl 1 #KBDTRANS based(null()) unaligned,
           2 chChar UCHAR,
           2 chScan UCHAR,
           2 fbStatus UCHAR,
           2 bNlsShift UCHAR,
           2 fsState USHORT,
           2 time ULONG,
           2 fsDD USHORT,
           2 fsXlate USHORT,
           2 fsShift USHORT,
           2 sZero USHORT;
     %dcl PKBDTRANS char;
     %PKBDTRANS='pointer';
     dcl KbdXlate entry (
            PKBDTRANS,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl KbdSetCustXt entry (
            PUSHORT,
            HKBD)
            returns(optional byvalue APIRET16)
            APIENTRY16;
   %end;
   %if INCL_VIO='Y' %then %do;
     %dcl VioCheckCharType char;
     %VioCheckCharType='VIO16CHECKCHARTYPE';
     %dcl VioDeRegister char;
     %VioDeRegister='VIO16DEREGISTER';
     %dcl VioEndPopUp char;
     %VioEndPopUp='VIO16ENDPOPUP';
     %dcl VioGetAnsi char;
     %VioGetAnsi='VIO16GETANSI';
     %dcl VioGetBuf char;
     %VioGetBuf='VIO16GETBUF';
     %dcl VioGetConfig char;
     %VioGetConfig='VIO16GETCONFIG';
     %dcl VioGetCp char;
     %VioGetCp='VIO16GETCP';
     %dcl VioGetCurPos char;
     %VioGetCurPos='VIO16GETCURPOS';
     %dcl VioGetCurType char;
     %VioGetCurType='VIO16GETCURTYPE';
     %dcl VioGetFont char;
     %VioGetFont='VIO16GETFONT';
     %dcl VioGetMode char;
     %VioGetMode='VIO16GETMODE';
     %dcl VioGetPhysBuf char;
     %VioGetPhysBuf='VIO16GETPHYSBUF';
     %dcl VioGetState char;
     %VioGetState='VIO16GETSTATE';
     %dcl VioModeUndo char;
     %VioModeUndo='VIO16MODEUNDO';
     %dcl VioModeWait char;
     %VioModeWait='VIO16MODEWAIT';
     %dcl VioPopUp char;
     %VioPopUp='VIO16POPUP';
     %dcl VioPrtSc char;
     %VioPrtSc='VIO16PRTSC';
     %dcl VioPrtScToggle char;
     %VioPrtScToggle='VIO16PRTSCTOGGLE';
     %dcl VioReadCellStr char;
     %VioReadCellStr='VIO16READCELLSTR';
     %dcl VioReadCharStr char;
     %VioReadCharStr='VIO16READCHARSTR';
     %dcl VioRedrawSize char;
     %VioRedrawSize='VIO16REDRAWSIZE';
     %dcl VioRegister char;
     %VioRegister='VIO16REGISTER';
     %dcl VioSavRedrawUndo char;
     %VioSavRedrawUndo='VIO16SAVREDRAWUNDO';
     %dcl VioSavRedrawWait char;
     %VioSavRedrawWait='VIO16SAVREDRAWWAIT';
     %dcl VioScrLock char;
     %VioScrLock='VIO16SCRLOCK';
     %dcl VioScrUnLock char;
     %VioScrUnLock='VIO16SCRUNLOCK';
     %dcl VioScrollDn char;
     %VioScrollDn='VIO16SCROLLDN';
     %dcl VioScrollLf char;
     %VioScrollLf='VIO16SCROLLLF';
     %dcl VioScrollRt char;
     %VioScrollRt='VIO16SCROLLRT';
     %dcl VioScrollUp char;
     %VioScrollUp='VIO16SCROLLUP';
     %dcl VioSetAnsi char;
     %VioSetAnsi='VIO16SETANSI';
     %dcl VioSetCp char;
     %VioSetCp='VIO16SETCP';
     %dcl VioSetCurPos char;
     %VioSetCurPos='VIO16SETCURPOS';
     %dcl VioSetCurType char;
     %VioSetCurType='VIO16SETCURTYPE';
     %dcl VioSetFont char;
     %VioSetFont='VIO16SETFONT';
     %dcl VioSetMode char;
     %VioSetMode='VIO16SETMODE';
     %dcl VioSetState char;
     %VioSetState='VIO16SETSTATE';
     %dcl VioShowBuf char;
     %VioShowBuf='VIO16SHOWBUF';
     %dcl VioWrtCellStr char;
     %VioWrtCellStr='VIO16WRTCELLSTR';
     %dcl VioWrtCharStr char;
     %VioWrtCharStr='VIO16WRTCHARSTR';
     %dcl VioWrtCharStrAtt char;
     %VioWrtCharStrAtt='VIO16WRTCHARSTRATT';
     %dcl VioWrtNAttr char;
     %VioWrtNAttr='VIO16WRTNATTR';
     %dcl VioWrtNCell char;
     %VioWrtNCell='VIO16WRTNCELL';
     %dcl VioWrtNChar char;
     %VioWrtNChar='VIO16WRTNCHAR';
     %dcl VioWrtTTY char;
     %VioWrtTTY='VIO16WRTTTY';
     %dcl HVIO char;
     %HVIO='fixed bin(16) unsigned';
     %dcl PHVIO char;
     %PHVIO='pointer';
     dcl VioRegister entry (
            PSZ,
            PSZ,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioGlobalReg entry (
            PSZ,
            PSZ,
            ULONG,
            ULONG,
            USHORT)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl VR_VIOGETCURPOS fixed bin(31) value('00_00_00_01'xn);
     dcl VR_VIOGETCURTYPE fixed bin(31) value('00_00_00_02'xn);
     dcl VR_VIOGETMODE fixed bin(31) value('00_00_00_04'xn);
     dcl VR_VIOGETBUF fixed bin(31) value('00_00_00_08'xn);
     dcl VR_VIOGETPHYSBUF fixed bin(31) value('00_00_00_10'xn);
     dcl VR_VIOSETCURPOS fixed bin(31) value('00_00_00_20'xn);
     dcl VR_VIOSETCURTYPE fixed bin(31) value('00_00_00_40'xn);
     dcl VR_VIOSETMODE fixed bin(31) value('00_00_00_80'xn);
     dcl VR_VIOSHOWBUF fixed bin(31) value('00_00_01_00'xn);
     dcl VR_VIOREADCHARSTR fixed bin(31) value('00_00_02_00'xn);
     dcl VR_VIOREADCELLSTR fixed bin(31) value('00_00_04_00'xn);
     dcl VR_VIOWRTNCHAR fixed bin(31) value('00_00_08_00'xn);
     dcl VR_VIOWRTNATTR fixed bin(31) value('00_00_10_00'xn);
     dcl VR_VIOWRTNCELL fixed bin(31) value('00_00_20_00'xn);
     dcl VR_VIOWRTTTY fixed bin(31) value('00_00_40_00'xn);
     dcl VR_VIOWRTCHARSTR fixed bin(31) value('00_00_80_00'xn);
     dcl VR_VIOWRTCHARSTRATT fixed bin(31) value('00_01_00_00'xn);
     dcl VR_VIOWRTCELLSTR fixed bin(31) value('00_02_00_00'xn);
     dcl VR_VIOSCROLLUP fixed bin(31) value('00_04_00_00'xn);
     dcl VR_VIOSCROLLDN fixed bin(31) value('00_08_00_00'xn);
     dcl VR_VIOSCROLLLF fixed bin(31) value('00_10_00_00'xn);
     dcl VR_VIOSCROLLRT fixed bin(31) value('00_20_00_00'xn);
     dcl VR_VIOSETANSI fixed bin(31) value('00_40_00_00'xn);
     dcl VR_VIOGETANSI fixed bin(31) value('00_80_00_00'xn);
     dcl VR_VIOPRTSC fixed bin(31) value('01_00_00_00'xn);
     dcl VR_VIOSCRLOCK fixed bin(31) value('02_00_00_00'xn);
     dcl VR_VIOSCRUNLOCK fixed bin(31) value('04_00_00_00'xn);
     dcl VR_VIOSAVREDRAWWAIT fixed bin(31) value('08_00_00_00'xn);
     dcl VR_VIOSAVREDRAWUNDO fixed bin(31) value('10_00_00_00'xn);
     dcl VR_VIOPOPUP fixed bin(31) value('20_00_00_00'xn);
     dcl VR_VIOENDPOPUP fixed bin(31) value('40_00_00_00'xn);
     dcl VR_VIOPRTSCTOGGLE fixed bin(31) value('80_00_00_00'xn);

     dcl VR_VIOMODEWAIT fixed bin(31) value('00_00_00_01'xn);
     dcl VR_VIOMODEUNDO fixed bin(31) value('00_00_00_02'xn);
     dcl VR_VIOGETFONT fixed bin(31) value('00_00_00_04'xn);
     dcl VR_VIOGETCONFIG fixed bin(31) value('00_00_00_08'xn);
     dcl VR_VIOSETCP fixed bin(31) value('00_00_00_10'xn);
     dcl VR_VIOGETCP fixed bin(31) value('00_00_00_20'xn);
     dcl VR_VIOSETFONT fixed bin(31) value('00_00_00_40'xn);
     dcl VR_VIOGETSTATE fixed bin(31) value('00_00_00_80'xn);
     dcl VR_VIOSETSTATE fixed bin(31) value('00_00_01_00'xn);
     dcl VioDeRegister entry (
            )
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioGetBuf entry (
            PULONG,
            PUSHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioGetCurPos entry (
            PUSHORT,
            PUSHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioSetCurPos entry (
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl VIOCURSORINFO char;
     %VIOCURSORINFO='char(stg(#VIOCURSORINFO))';
     dcl 1 #VIOCURSORINFO based(null()) unaligned,
           2 yStart USHORT,
           2 cEnd USHORT,
           2 cx USHORT,
           2 attr USHORT;
     %dcl PVIOCURSORINFO char;
     %PVIOCURSORINFO='pointer';
     dcl VioGetCurType entry (
            PVIOCURSORINFO,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioSetCurType entry (
            PVIOCURSORINFO,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl COLORS_2 fixed bin(16) value('00_01'xn);
     dcl COLORS_4 fixed bin(16) value('00_02'xn);
     dcl COLORS_16 fixed bin(16) value('00_04'xn);
     %dcl VIOMODEINFO char;
     %VIOMODEINFO='char(stg(#VIOMODEINFO))';
     dcl 1 #VIOMODEINFO based(null()) unaligned,
           2 cb USHORT,
           2 fbType UCHAR,
     %deactivate color;
           2 color UCHAR,
     %activate color;
           2 col USHORT,
           2 row USHORT,
           2 hres USHORT,
           2 vres USHORT,
           2 fmt_ID UCHAR,
           2 attrib UCHAR,
           2 buf_addr ULONG,
           2 buf_length ULONG,
           2 full_length ULONG,
           2 partial_length ULONG,
           2 ext_data_addr PCH;
     %dcl PVIOMODEINFO char;
     %PVIOMODEINFO='pointer';

     dcl VGMT_OTHER bit(8) value('00_00_00_01'b);
     dcl VGMT_GRAPHICS bit(8) value('00_00_00_10'b);
     dcl VGMT_DISABLEBURST bit(8) value('00_00_01_00'b);

     dcl VioGetMode entry (
            PVIOMODEINFO,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioSetMode entry (
            PVIOMODEINFO,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl VIOPHYSBUF char;
     %VIOPHYSBUF='char(stg(#VIOPHYSBUF))';
     dcl 1 #VIOPHYSBUF based(null()) unaligned,
           2 pBuf PBYTE,
           2 cb ULONG,
           2 asel(1) SEL;
     %dcl PVIOPHYSBUF char;
     %PVIOPHYSBUF='pointer';
     dcl VioGetPhysBuf entry (
            PVIOPHYSBUF,
            USHORT)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioReadCellStr entry (
            PCH,
            PUSHORT,
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioReadCharStr entry (
            PCH,
            PUSHORT,
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioWrtCellStr entry (
            PCH,
            USHORT,
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioWrtCharStr entry (
            PCH,
            USHORT,
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioScrollDn entry (
            USHORT,
            USHORT,
            USHORT,
            USHORT,
            USHORT,
            PBYTE,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioScrollUp entry (
            USHORT,
            USHORT,
            USHORT,
            USHORT,
            USHORT,
            PBYTE,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioScrollLf entry (
            USHORT,
            USHORT,
            USHORT,
            USHORT,
            USHORT,
            PBYTE,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioScrollRt entry (
            USHORT,
            USHORT,
            USHORT,
            USHORT,
            USHORT,
            PBYTE,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioWrtNAttr entry (
            PBYTE,
            USHORT,
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioWrtNCell entry (
            PBYTE,
            USHORT,
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioWrtNChar entry (
            PCH,
            USHORT,
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioWrtTTY entry (
            PCH,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioWrtCharStrAtt entry (
            PCH,
            USHORT,
            USHORT,
            USHORT,
            PBYTE,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl VCC_SBCSCHAR char;
     %VCC_SBCSCHAR=0;
     %dcl VCC_DBCSFULLCHAR char;
     %VCC_DBCSFULLCHAR=1;
     %dcl VCC_DBCS1STHALF char;
     %VCC_DBCS1STHALF=2;
     %dcl VCC_DBCS2NDHALF char;
     %VCC_DBCS2NDHALF=3;
     dcl VioCheckCharType entry (
            PUSHORT,
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioShowBuf entry (
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl ANSI_ON char;
     %ANSI_ON=1;
     %dcl ANSI_OFF char;
     %ANSI_OFF=0;
     dcl VioSetAnsi entry (
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioGetAnsi entry (
            PUSHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioPrtSc entry (
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioPrtScToggle entry (
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl VSRWI_SAVEANDREDRAW char;
     %VSRWI_SAVEANDREDRAW=0;
     %dcl VSRWI_REDRAW char;
     %VSRWI_REDRAW=1;
     %dcl VSRWN_SAVE char;
     %VSRWN_SAVE=0;
     %dcl VSRWN_REDRAW char;
     %VSRWN_REDRAW=1;
     %dcl UNDOI_GETOWNER char;
     %UNDOI_GETOWNER=0;
     %dcl UNDOI_RELEASEOWNER char;
     %UNDOI_RELEASEOWNER=1;
     %dcl UNDOK_ERRORCODE char;
     %UNDOK_ERRORCODE=0;
     %dcl UNDOK_TERMINATE char;
     %UNDOK_TERMINATE=1;
     dcl VioRedrawSize entry (
            PULONG)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioSavRedrawWait entry (
            USHORT,
            PUSHORT,
            USHORT)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioSavRedrawUndo entry (
            USHORT,
            USHORT,
            USHORT)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl VMWR_POPUP char;
     %VMWR_POPUP=0;
     %dcl VMWN_POPUP char;
     %VMWN_POPUP=0;
     dcl VioModeWait entry (
            USHORT,
            PUSHORT,
            USHORT)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioModeUndo entry (
            USHORT,
            USHORT,
            USHORT)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl LOCKIO_NOWAIT char;
     %LOCKIO_NOWAIT=0;
     %dcl LOCKIO_WAIT char;
     %LOCKIO_WAIT=1;
     %dcl LOCK_SUCCESS char;
     %LOCK_SUCCESS=0;
     %dcl LOCK_FAIL char;
     %LOCK_FAIL=1;
     dcl VioScrLock entry (
            USHORT,
            PUCHAR,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioScrUnLock entry (
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl VP_NOWAIT fixed bin(16) value('00_00'xn);
     dcl VP_WAIT fixed bin(16) value('00_01'xn);
     dcl VP_OPAQUE fixed bin(16) value('00_00'xn);
     dcl VP_TRANSPARENT fixed bin(16) value('00_02'xn);

     dcl VioPopUp entry (
            PUSHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioEndPopUp entry (
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl DISPLAY_MONOCHROME fixed bin(16) value('00_00'xn);
     dcl DISPLAY_CGA fixed bin(16) value('00_01'xn);
     dcl DISPLAY_EGA fixed bin(16) value('00_02'xn);
     dcl DISPLAY_VGA fixed bin(16) value('00_03'xn);
     dcl DISPLAY_8514A fixed bin(16) value('00_07'xn);
     dcl DISPLAY_IMAGEADAPTER fixed bin(16) value('00_08'xn);
     dcl DISPLAY_XGA fixed bin(16) value('00_09'xn);

     dcl MONITOR_MONOCHROME fixed bin(16) value('00_00'xn);
     dcl MONITOR_COLOR fixed bin(16) value('00_01'xn);
     dcl MONITOR_ENHANCED fixed bin(16) value('00_02'xn);
     dcl MONITOR_8503 fixed bin(16) value('00_03'xn);
     dcl MONITOR_851X_COLOR fixed bin(16) value('00_04'xn);
     dcl MONITOR_8514 fixed bin(16) value('00_09'xn);
     dcl MONITOR_FLATPANEL fixed bin(16) value('00_0A'xn);
     dcl MONITOR_8507_8604 fixed bin(16) value('00_0B'xn);
     dcl MONITOR_8515 fixed bin(16) value('00_0C'xn);
     dcl MONITOR_9515 fixed bin(16) value('00_0F'xn);
     dcl MONITOR_9517 fixed bin(16) value('00_11'xn);
     dcl MONITOR_9518 fixed bin(16) value('00_12'xn);

     %dcl VIOCONFIGINFO char;
     %VIOCONFIGINFO='char(stg(#VIOCONFIGINFO))';
     dcl 1 #VIOCONFIGINFO based(null()) unaligned,
           2 cb USHORT,
           2 adapter USHORT,
           2 display USHORT,
           2 cbMemory ULONG,
           2 Configuration USHORT,
           2 VDHVersion USHORT,
           2 Flags USHORT,
           2 HWBufferSize ULONG,
           2 FullSaveSize ULONG,
           2 PartSaveSize ULONG,
           2 EMAdaptersOFF USHORT,
           2 EMDisplaysOFF USHORT;
     %dcl PVIOCONFIGINFO char;
     %PVIOCONFIGINFO='pointer';
     %dcl VIO_CONFIG_CURRENT char;
     %VIO_CONFIG_CURRENT=0;
     %dcl VIO_CONFIG_PRIMARY char;
     %VIO_CONFIG_PRIMARY=1;
     %dcl VIO_CONFIG_SECONDARY char;
     %VIO_CONFIG_SECONDARY=2;
     dcl VioGetConfig entry (
            USHORT,
            PVIOCONFIGINFO,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl VIOFONTINFO char;
     %VIOFONTINFO='char(stg(#VIOFONTINFO))';
     dcl 1 #VIOFONTINFO based(null()) unaligned,
           2 cb USHORT,
           2 type USHORT,
           2 cxCell USHORT,
           2 cyCell USHORT,
           2 pbData PVOID16,
           2 cbData USHORT;
     %dcl PVIOFONTINFO char;
     %PVIOFONTINFO='pointer';
     %dcl VGFI_GETCURFONT char;
     %VGFI_GETCURFONT=0;
     %dcl VGFI_GETROMFONT char;
     %VGFI_GETROMFONT=1;
     dcl VioGetFont entry (
            PVIOFONTINFO,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioSetFont entry (
            PVIOFONTINFO,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioGetCp entry (
            USHORT,
            PUSHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioSetCp entry (
            USHORT,
            USHORT,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl VIOPALSTATE char;
     %VIOPALSTATE='char(stg(#VIOPALSTATE))';
     dcl 1 #VIOPALSTATE based(null()) unaligned,
           2 cb USHORT,
           2 type USHORT,
           2 iFirst USHORT,
           2 acolor(1) USHORT;
     %dcl PVIOPALSTATE char;
     %PVIOPALSTATE='pointer';
     %dcl VIOOVERSCAN char;
     %VIOOVERSCAN='char(stg(#VIOOVERSCAN))';
     dcl 1 #VIOOVERSCAN based(null()) unaligned,
           2 cb USHORT,
           2 type USHORT,
     %deactivate color;
           2 color USHORT;
     %activate color;
     %dcl PVIOOVERSCAN char;
     %PVIOOVERSCAN='pointer';
     %dcl VIOINTENSITY char;
     %VIOINTENSITY='char(stg(#VIOINTENSITY))';
     dcl 1 #VIOINTENSITY based(null()) unaligned,
           2 cb USHORT,
           2 type USHORT,
           2 fs USHORT;
     %dcl PVIOINTENSITY char;
     %PVIOINTENSITY='pointer';
     %dcl VIOCOLORREG char;
     %VIOCOLORREG='char(stg(#VIOCOLORREG))';
     dcl 1 #VIOCOLORREG based(null()) unaligned,
           2 cb USHORT,
           2 type USHORT,
           2 firstcolorreg USHORT,
           2 numcolorregs USHORT,
           2 colorregaddr PCH;
     %dcl PVIOCOLORREG char;
     %PVIOCOLORREG='pointer';
     %dcl VIOSETULINELOC char;
     %VIOSETULINELOC='char(stg(#VIOSETULINELOC))';
     dcl 1 #VIOSETULINELOC based(null()) unaligned,
           2 cb USHORT,
           2 type USHORT,
           2 scanline USHORT;
     %dcl PVIOSETULINELOC char;
     %PVIOSETULINELOC='pointer';
     %dcl VIOSETTARGET char;
     %VIOSETTARGET='char(stg(#VIOSETTARGET))';
     dcl 1 #VIOSETTARGET based(null()) unaligned,
           2 cb USHORT,
           2 type USHORT,
           2 defaultalgorithm USHORT;
     %dcl PVIOSETTARGET char;
     %PVIOSETTARGET='pointer';
     dcl VioGetState entry (
            PVOID,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl VioSetState entry (
            PVOID,
            HVIO)
            returns(optional byvalue APIRET16)
            APIENTRY16;
   %end;
   %if INCL_MOU='Y' %then %do;
     %dcl MouClose char;
     %MouClose='MOU16CLOSE';
     %dcl MouDeRegister char;
     %MouDeRegister='MOU16DEREGISTER';
     %dcl MouDrawPtr char;
     %MouDrawPtr='MOU16DRAWPTR';
     %dcl MouFlushQue char;
     %MouFlushQue='MOU16FLUSHQUE';
     %dcl MouGetDevStatus char;
     %MouGetDevStatus='MOU16GETDEVSTATUS';
     %dcl MouGetEventMask char;
     %MouGetEventMask='MOU16GETEVENTMASK';
     %dcl MouGetNumButtons char;
     %MouGetNumButtons='MOU16GETNUMBUTTONS';
     %dcl MouGetNumMickeys char;
     %MouGetNumMickeys='MOU16GETNUMMICKEYS';
     %dcl MouGetNumQueEl char;
     %MouGetNumQueEl='MOU16GETNUMQUEEL';
     %dcl MouGetPtrPos char;
     %MouGetPtrPos='MOU16GETPTRPOS';
     %dcl MouGetPtrShape char;
     %MouGetPtrShape='MOU16GETPTRSHAPE';
     %dcl MouGetScaleFact char;
     %MouGetScaleFact='MOU16GETSCALEFACT';
     %dcl MouGetThreshold char;
     %MouGetThreshold='MOU16GETTHRESHOLD';
     %dcl MouInitReal char;
     %MouInitReal='MOU16INITREAL';
     %dcl MouOpen char;
     %MouOpen='MOU16OPEN';
     %dcl MouReadEventQue char;
     %MouReadEventQue='MOU16READEVENTQUE';
     %dcl MouRegister char;
     %MouRegister='MOU16REGISTER';
     %dcl MouRemovePtr char;
     %MouRemovePtr='MOU16REMOVEPTR';
     %dcl MouSetDevStatus char;
     %MouSetDevStatus='MOU16SETDEVSTATUS';
     %dcl MouSetEventMask char;
     %MouSetEventMask='MOU16SETEVENTMASK';
     %dcl MouSetPtrPos char;
     %MouSetPtrPos='MOU16SETPTRPOS';
     %dcl MouSetPtrShape char;
     %MouSetPtrShape='MOU16SETPTRSHAPE';
     %dcl MouSetScaleFact char;
     %MouSetScaleFact='MOU16SETSCALEFACT';
     %dcl MouSetThreshold char;
     %MouSetThreshold='MOU16SETTHRESHOLD';
     %dcl MouSynch char;
     %MouSynch='MOU16SYNCH';
     %dcl HMOU char;
     %HMOU='fixed bin(16) unsigned';
     %dcl PHMOU char;
     %PHMOU='pointer';
     dcl MouRegister entry (
            PSZ,
            PSZ,
            ULONG)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl MR_MOUGETNUMBUTTONS fixed bin(31) value('00_00_00_01'xn);
     dcl MR_MOUGETNUMMICKEYS fixed bin(31) value('00_00_00_02'xn);
     dcl MR_MOUGETDEVSTATUS fixed bin(31) value('00_00_00_04'xn);
     dcl MR_MOUGETNUMQUEEL fixed bin(31) value('00_00_00_08'xn);
     dcl MR_MOUREADEVENTQUE fixed bin(31) value('00_00_00_10'xn);
     dcl MR_MOUGETSCALEFACT fixed bin(31) value('00_00_00_20'xn);
     dcl MR_MOUGETEVENTMASK fixed bin(31) value('00_00_00_40'xn);
     dcl MR_MOUSETSCALEFACT fixed bin(31) value('00_00_00_80'xn);
     dcl MR_MOUSETEVENTMASK fixed bin(31) value('00_00_01_00'xn);
     dcl MR_MOUOPEN fixed bin(31) value('00_00_08_00'xn);
     dcl MR_MOUCLOSE fixed bin(31) value('00_00_10_00'xn);
     dcl MR_MOUGETPTRSHAPE fixed bin(31) value('00_00_20_00'xn);
     dcl MR_MOUSETPTRSHAPE fixed bin(31) value('00_00_40_00'xn);
     dcl MR_MOUDRAWPTR fixed bin(31) value('00_00_80_00'xn);
     dcl MR_MOUREMOVEPTR fixed bin(31) value('00_01_00_00'xn);
     dcl MR_MOUGETPTRPOS fixed bin(31) value('00_02_00_00'xn);
     dcl MR_MOUSETPTRPOS fixed bin(31) value('00_04_00_00'xn);
     dcl MR_MOUINITREAL fixed bin(31) value('00_08_00_00'xn);
     dcl MR_MOUSETDEVSTATUS fixed bin(31) value('00_10_00_00'xn);

     dcl MouDeRegister entry (
            )
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouFlushQue entry (
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MHK_BUTTON1 fixed bin(16) value('00_01'xn);
     dcl MHK_BUTTON2 fixed bin(16) value('00_02'xn);
     dcl MHK_BUTTON3 fixed bin(16) value('00_04'xn);

     %dcl PTRLOC char;
     %PTRLOC='char(stg(#PTRLOC))';
     dcl 1 #PTRLOC based(null()) unaligned,
           2 row USHORT,
           2 col USHORT;
     %dcl PPTRLOC char;
     %PPTRLOC='pointer';
     dcl MouGetPtrPos entry (
            PPTRLOC,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouSetPtrPos entry (
            PPTRLOC,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl PTRSHAPE char;
     %PTRSHAPE='char(stg(#PTRSHAPE))';
     dcl 1 #PTRSHAPE based(null()) unaligned,
           2 cb USHORT,
           2 col USHORT,
           2 row USHORT,
           2 colHot USHORT,
           2 rowHot USHORT;
     %dcl PPTRSHAPE char;
     %PPTRSHAPE='pointer';
     dcl MouSetPtrShape entry (
            PBYTE,
            PPTRSHAPE,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouGetPtrShape entry (
            PBYTE,
            PPTRSHAPE,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl MOUSE_QUEUEBUSY fixed bin(16) value('00_01'xn);
     dcl MOUSE_BLOCKREAD fixed bin(16) value('00_02'xn);
     dcl MOUSE_FLUSH fixed bin(16) value('00_04'xn);
     dcl MOUSE_UNSUPPORTED_MODE fixed bin(16) value('00_08'xn);
     dcl MOUSE_DISABLED fixed bin(16) value('01_00'xn);
     dcl MOUSE_MICKEYS fixed bin(16) value('02_00'xn);

     dcl MouGetDevStatus entry (
            PUSHORT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouGetNumButtons entry (
            PUSHORT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouGetNumMickeys entry (
            PUSHORT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl MOU_NOWAIT fixed bin(16) value('00_00'xn);
     dcl MOU_WAIT fixed bin(16) value('00_01'xn);

     %dcl MOUEVENTINFO char;
     %MOUEVENTINFO='char(stg(#MOUEVENTINFO))';
     dcl 1 #MOUEVENTINFO based(null()) unaligned,
           2 fs USHORT,
           2 time ULONG,
           2 row SHORT,
           2 col SHORT;
     %dcl PMOUEVENTINFO char;
     %PMOUEVENTINFO='pointer';
     dcl MouReadEventQue entry (
            PMOUEVENTINFO,
            PUSHORT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl MOUQUEINFO char;
     %MOUQUEINFO='char(stg(#MOUQUEINFO))';
     dcl 1 #MOUQUEINFO based(null()) unaligned,
           2 cEvents USHORT,
           2 cmaxEvents USHORT;
     %dcl PMOUQUEINFO char;
     %PMOUQUEINFO='pointer';
     dcl MouGetNumQueEl entry (
            PMOUQUEINFO,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl MOUSE_MOTION fixed bin(16) value('00_01'xn);
     dcl MOUSE_MOTION_WITH_BN1_DOWN fixed bin(16) value('00_02'xn);
     dcl MOUSE_BN1_DOWN fixed bin(16) value('00_04'xn);
     dcl MOUSE_MOTION_WITH_BN2_DOWN fixed bin(16) value('00_08'xn);
     dcl MOUSE_BN2_DOWN fixed bin(16) value('00_10'xn);
     dcl MOUSE_MOTION_WITH_BN3_DOWN fixed bin(16) value('00_20'xn);
     dcl MOUSE_BN3_DOWN fixed bin(16) value('00_40'xn);

     dcl MouGetEventMask entry (
            PUSHORT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouSetEventMask entry (
            PUSHORT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl SCALEFACT char;
     %SCALEFACT='char(stg(#SCALEFACT))';
     dcl 1 #SCALEFACT based(null()) unaligned,
           2 rowScale USHORT,
           2 colScale USHORT;
     %dcl PSCALEFACT char;
     %PSCALEFACT='pointer';
     dcl MouGetScaleFact entry (
            PSCALEFACT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouSetScaleFact entry (
            PSCALEFACT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouOpen entry (
            PSZ,
            PHMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouClose entry (
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl NOPTRRECT char;
     %NOPTRRECT='char(stg(#NOPTRRECT))';
     dcl 1 #NOPTRRECT based(null()) unaligned,
           2 row USHORT,
           2 col USHORT,
           2 cRow USHORT,
           2 cCol USHORT;
     %dcl PNOPTRRECT char;
     %PNOPTRRECT='pointer';
     dcl MouRemovePtr entry (
            PNOPTRRECT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouDrawPtr entry (
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;

     dcl MOU_NODRAW fixed bin(16) value('00_01'xn);
     dcl MOU_DRAW fixed bin(16) value('00_00'xn);
     dcl MOU_MICKEYS fixed bin(16) value('00_02'xn);
     dcl MOU_PELS fixed bin(16) value('00_00'xn);
     dcl MouSetDevStatus entry (
            PUSHORT,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouInitReal entry (
            PSZ)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouSynch entry (
            USHORT)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     %dcl THRESHOLD char;
     %THRESHOLD='char(stg(#THRESHOLD))';
     dcl 1 #THRESHOLD based(null()) unaligned,
           2 Length USHORT,
           2 Level1 USHORT,
           2 Lev1Mult USHORT,
           2 Level2 USHORT,
           2 lev2Mult USHORT;
     %dcl PTHRESHOLD char;
     %PTHRESHOLD='pointer';
     dcl MouGetThreshold entry (
            PTHRESHOLD,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
     dcl MouSetThreshold entry (
            PTHRESHOLD,
            HMOU)
            returns(optional byvalue APIRET16)
            APIENTRY16;
   %end;
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
