/*NOINC*/
/*
 *  IBM LAN Services
 *  Copyright(c) IBM Corp., 1993-1994
 */
/*INC*/

/*INTERNAL_ONLY*/
/*
 *
 *  Change History:
 *
 *  (f = feature d = defect)
 *  fea/def#  who   when     what
 *  --------  ---   ----     ----
 *  d05988    jc    14Mar94  Added NOINC/INC around this copyright statement;
 *                           added this change section; changed the format of
 *                           the "About this file" section, all so the stupid
 *                           sanitize process doesn't mangle this file.
 *  d07980    mbb   14May94  Added Net32RIPLMachine stuff
 *  d08507    dpd   25May94  Add rmi2_OS2_config_flags to ripl_machine_info_2
 *  d08592    dpd   27May94  Additional support for OS2_config_flags
 *  F05438    MBB   94Aug08  Make .h files compatible with C++
 *  D19871    DPD  06/12/95  Additional OS2_config_flags for DBCS
 */
/*END_INTERNAL*/

/********************************************************************
 *                                                                  *
 *  About this file ...  RIPL.H                                     *
 *                                                                  *
 *  This file contains information about the RIPL (Remote IPL)      *
 *  APIs.  For each API class there is a section on:                *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *       Data structure templates.                                  *
 *                                                                  *
 *        Definition of special values.                             *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *           file depends on values defined in NETCONS.H.           *
 *                                                                  *
 ********************************************************************/


#if !defined NETRIPL_INCLUDED
#define NETRIPL_INCLUDED

#ifdef  ANY_32_BIT
#pragma pack(2)
#endif

/****************************************************************
 *                                                              *
 *              Function prototypes - NetxxxRIPLMachine         *
 *                                    NetxxxRIPLMachineInfo     *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
 NetCreateRIPLMachine (const unsigned char LSFAR *,   /* server               */
                       unsigned short,                /* level (2, 12)        */
                       unsigned char LSFAR *,         /* buffer (send)        */
                       unsigned short);               /* buffer length        */

extern API_FUNCTION
 NetDeleteRIPLMachine (const unsigned char LSFAR *,   /* server               */
                       unsigned char LSFAR *);        /* machine name(client) */

extern API_FUNCTION
 NetGetRIPLMachineInfo (const unsigned char LSFAR *,  /* server               */
                        unsigned char LSFAR *,        /* machine name(client) */
                        unsigned short,               /* level (0, 1, 2)      */
                        unsigned char LSFAR *,        /* buffer (receive)     */
                        unsigned short,               /* buffer length        */
                        unsigned short LSFAR *);      /* bytes available      */

extern API_FUNCTION
 NetSetRIPLMachineInfo (const unsigned char LSFAR *,  /* server               */
                        unsigned char LSFAR *,        /* machine name(client) */
                        unsigned short,               /* level (1, 2)         */
                        unsigned char LSFAR *,        /* buffer (send)        */
                        unsigned short,               /* buffer length        */
                        unsigned short);              /* parameter number     */

extern API_FUNCTION
 NetEnumRIPLMachine (const unsigned char LSFAR *,     /* server               */
                     unsigned short,                  /* level (0, 1, 2)      */
                     unsigned short,                  /* type                 */
                     unsigned char LSFAR *,           /* buffer (receive)     */
                     unsigned short,                  /* buffer length        */
                     unsigned short LSFAR *,          /* entries returned     */
                     unsigned short LSFAR *);         /* entries available    */

/****************************************************************
 *                                                              *
 *              Data structure templates - RIPL                 *
 *                                                              *
 ****************************************************************/

struct ripl_machine_info_0
   {
    unsigned char                     rmi0_name[CNLEN + 1];
   };

struct ripl_machine_info_1
   {
    unsigned char                     rmi1_name[CNLEN + 1];
    unsigned char LSFAR * LSPTR       rmi1_remark;
   };

struct ripl_machine_info_2
   {
    unsigned char                     rmi2_name[CNLEN + 1];
    unsigned char LSFAR * LSPTR       rmi2_remark;
    unsigned char                     rmi2_adapter_address[NNLEN + 1];
    unsigned char                     rmi2_pad_1;
    unsigned char                     rmi2_OS2_boot_drive;
    unsigned char                     rmi2_pad_2;
    unsigned char                     rmi2_DOS_imageid[DOSIMGLEN + 1];
    unsigned char                     rmi2_pad_3;
    unsigned char LSFAR * LSPTR       rmi2_DOS_srv_rec_ID;
    unsigned char LSFAR * LSPTR       rmi2_OS2_srv_rec_ID;
    unsigned long                     rmi2_OS2_config_flags;
   };

struct ripl_machine_info_12
   {
    unsigned char                     rmi12_name[CNLEN + 1];
    unsigned char LSFAR * LSPTR       rmi12_remark;
    unsigned char                     rmi12_adapter_address[NNLEN + 1];
    unsigned char                     rmi12_pad_1;
    unsigned char                     rmi12_model_name[CNLEN + 1];
   };


/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Define PURE_32 temporarily */
#define PURE_32
#endif
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *   32-bit Function prototypes - NetxxxRIPLMachine             *
 *                                NetxxxRIPLMachineInfo         *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
 Net32CreateRIPLMachine (const unsigned char *,       /* server               */
                         unsigned long,               /* level (2, 12)        */
                         unsigned char *,             /* buffer (send)        */
                         unsigned long);              /* buffer length        */

extern API32_FUNCTION
 Net32DeleteRIPLMachine (const unsigned char *,       /* server               */
                         unsigned char LSFAR *);      /* machine name(client) */

extern API32_FUNCTION
 Net32GetRIPLMachineInfo (const unsigned char *,      /* server               */
                          unsigned char       *,      /* machine name(client) */
                          unsigned long,              /* level (0, 1, 2)      */
                          unsigned char       *,      /* buffer (receive)     */
                          unsigned long,              /* buffer length        */
                          unsigned long       *);     /* bytes available      */

extern API32_FUNCTION
 Net32SetRIPLMachineInfo (const unsigned char *,      /* server               */
                          unsigned char       *,      /* machine name(client) */
                          unsigned long,              /* level (1, 2)         */
                          unsigned char       *,      /* buffer (send)        */
                          unsigned long,              /* buffer length        */
                          unsigned long);             /* parameter number     */

extern API32_FUNCTION
 Net32EnumRIPLMachine (const unsigned char *,         /* server               */
                       unsigned long,                 /* level (0, 1, 2)      */
                       unsigned long,                 /* type                 */
                       unsigned char        *,        /* buffer (receive)     */
                       unsigned long,                 /* buffer length        */
                       unsigned long        *,        /* entries returned     */
                       unsigned long        *);       /* entries available    */
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Undefine PURE_32 and pick up data structures */
#undef PURE_32
/****************************************************************
 *                                                              *
 *              Data structure templates - RIPL                 *
 *                                                              *
 ****************************************************************/

struct ripl_machine32_info_0
   {
    unsigned char                     rmi0_name[CNLEN + 1];
   };

struct ripl_machine32_info_1
   {
    unsigned char                     rmi1_name[CNLEN + 1];
    unsigned char       *             rmi1_remark;
   };

struct ripl_machine32_info_2
   {
    unsigned char                     rmi2_name[CNLEN + 1];
    unsigned char       *             rmi2_remark;
    unsigned char                     rmi2_adapter_address[NNLEN + 1];
    unsigned char                     rmi2_pad_1;
    unsigned char                     rmi2_OS2_boot_drive;
    unsigned char                     rmi2_pad_2;
    unsigned char                     rmi2_DOS_imageid[DOSIMGLEN + 1];
    unsigned char                     rmi2_pad_3;
    unsigned char       *             rmi2_DOS_srv_rec_ID;
    unsigned char       *             rmi2_OS2_srv_rec_ID;
    unsigned long                     rmi2_OS2_config_flags;
   };

struct ripl_machine32_info_12
   {
    unsigned char                     rmi12_name[CNLEN + 1];
    unsigned char       *             rmi12_remark;
    unsigned char                     rmi12_adapter_address[NNLEN + 1];
    unsigned char                     rmi12_pad_1;
    unsigned char                     rmi12_model_name[CNLEN + 1];
   };
#endif /* IBMTHUNK */
/**END_INTERNAL**/

/****************************************************************
 *                                                              *
 *              Special values and constants - RIPL             *
 *                                                              *
 ****************************************************************/

/*
 * values for rmi1_machine_type
 */

#define MTYPE_OS2_RIPL_REQ             0x0001
#define MTYPE_DOS_RIPL_REQ             0x0002

/*
 * values for Parmnum
 */

#define RIPL_MACH_REMARK_PARMNUM                 2
#define RIPL_MACH_ADAPTER_PARMNUM                3
#define RIPL_MACH_OS2_BOOTDRIVE_PARMNUM          5
#define RIPL_MACH_DOS_IMAGEID_PARMNUM            7
#define RIPL_MACH_DOS_SRVRECID_PARMNUM           9
#define RIPL_MACH_OS2_SRVRECID_PARMNUM          10

#define RI1_NUM_ELEMENTS            2
#define RI2_NUM_ELEMENTS           10

/*
 * values for rmi2_OS2_config_flags
 */

#define OS2_SWAPPER_LOCAL          0x00000000L
#define OS2_SWAPPER_SERVER         0x00000001L
#define OS2_BUS_MCA                0x00000000L
#define OS2_BUS_ISA                0x00000002L
#define OS2_DISPLAY_IBMVGA32       0x00000000L
#define OS2_DISPLAY_IBMXGA32       0x00000010L
#define OS2_DISPLAY_IBM8514        0x00000020L
#define OS2_DISPLAY_SVGA           0x00000040L
#define OS2_DISPLAY_S3SVGA         0x00000080L
#define OS2_DISPLAY_IBMEGA         0x00000100L
#define OS2_DISPLAY_PS55_16        0x00008010L
#define OS2_DISPLAY_PS55_256       0x00008020L
#define OS2_DISPLAY_PS55_256P      0x00008040L
#define OS2_KEYBOARD_101           0x00000000L
#define OS2_KEYBOARD_DBCS_103      0x00001000L
#define OS2_KEYBOARD_DBCS_106      0x00002000L
#define OS2_KEYBOARD_DBCS_AX       0x00004000L

#ifdef ANY_32_BIT
#pragma pack ()
#endif

#endif
