 /********************************************************************/
 /*                                                                  */
 /*  NAME - winebase.cpy                                             */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Sample PL/I - CGI program.                                    */
 /*                                                                  */
 /*  DEPENDENCIES                                                    */
 /*    See readcgi.txt for details.                                  */
 /*                                                                  */
 /********************************************************************/
 /*                                                                  */
 /*    Licensed Materials - Property of IBM                          */
 /*    5639-A83, 5639-A24 (C) Copyright IBM Corp. 1992,2000.         */
 /*    All Rights Reserved.                                          */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/

 /* include for mini wine database */

 Dcl 1 wineBase(46),
       2  variety  char(10) var,
       2  vintner  char(15) var,
       2  vyear    char(4),
       2  appellat char(15) var,
       2  pdate    char(8) var,
       2  mdate    char(8) var,
       2  numbttl  fixed bin(31),
       2  comments char(200) var;


 /* chardonnays */

 winebase(1).variety = 'chards';
 winebase(1).vintner = 'Windy Ridge';
 winebase(1).vyear   = '1995';
 winebase(1).appellat = 'Estate Bottled';
 winebase(1).pdate   = '1995';
 winebase(1).mdate   = '2001';
 winebase(1).numbttl = 6;
 winebase(1).comments=
 'While intensity and toasty richness have ?' ||
 'been a hallmark of this winery, the current ?' ||
 'offering is rounded on the palate with nice ?'||
 'balance with fresh fruit.';

 winebase(2).variety = 'chards';
 winebase(2).vintner = 'AwBoneClimat';
 winebase(2).vyear   = '1995';
 winebase(2).appellat = 'Santa Barbera';
 winebase(2).pdate   = '1995';
 winebase(2).mdate   = '1997';
 winebase(2).numbttl = 23;
 winebase(2).comments=
 'Light medium in intensity with clean, fresh ?'||
 'and nicely stated appley fruit scents.  Service ?'||
 'with broiled fish or range fed chicken.';

 winebase(3).variety = 'chards';
 winebase(3).vintner = 'Ch. St. Bean';
 winebase(3).vyear   = '1988';
 winebase(3).appellat = 'Sonoma County';
 winebase(3).pdate   = '1988';
 winebase(3).mdate   = '1989';
 winebase(3).numbttl = 2;
 winebase(3).comments=
 'Citrus and oak scents can be found somewhere ?' ||
 'in the mix, but you would need a fine tooth  ?' ||
 'comb and magnifiying glass to track them down.';

 winebase(21).variety = 'chards';
 winebase(21).vintner = 'High Mountain';
 winebase(21).vyear   = '1994';
 winebase(21).appellat = 'Mendocino';
 winebase(21).pdate   = '1994';
 winebase(21).mdate   = '2011';
 winebase(21).numbttl = 1;
 winebase(21).comments=
 'Plesantly scented with soft, cherry-like ?' ||
 'fruit, this mild, medium bodied wine will ?' ||
 'make you want to hike all day to put a good ?'||
 'distance between you and it.';

 winebase(22).variety = 'chards';
 winebase(22).vintner = 'Cutie Pie';
 winebase(22).vyear   = '1992';
 winebase(22).appellat = 'Modesto';
 winebase(22).pdate   = '1996';
 winebase(22).mdate   = '1996';
 winebase(22).numbttl = 2;
 winebase(22).comments=
 'A trim and neatly tailored Chardonnay of good ?'||
 'upbringing, this wine will cloy you right down ?'||
 'the center aisle to wedded bliss.  Goes with chicken.';

 winebase(23).variety = 'chards';
 winebase(23).vintner = 'Brown Hills';
 winebase(23).vyear   = '1982';
 winebase(23).appellat = 'Central Valley';
 winebase(23).pdate   = '1998';
 winebase(23).mdate   = '1999';
 winebase(23).numbttl = 12;
 winebase(23).comments=
 'Somewhere there would be a soul who appreciates ?' ||
 'the drab colors and musty aroma of this effort. ?' ||
 'Not here, not now, no way.';

 winebase(24).variety = 'chards';
 winebase(24).vintner = 'Stone Castle';
 winebase(24).vyear   = '1939';
 winebase(24).appellat = 'River Ranch';
 winebase(24).pdate   = '1992';
 winebase(24).mdate   = '1999';
 winebase(24).numbttl = 11;
 winebase(24).comments=
 'High upon a rugged horse, this wine sits perched ?' ||
 'and ready to do battle with the timid at heart. ?' ||
 'Best to put on your best armor before attempting this one.';

 winebase(46).variety = 'chards';
 winebase(46).vintner = 'A$A!A^A@A(A)';
 winebase(46).vyear   = '1939';
 winebase(46).appellat = 'River Ranch';
 winebase(46).pdate   = '1992';
 winebase(46).mdate   = '1999';
 winebase(46).numbttl = 11;
 winebase(46).comments=
 'High upon a rugged horse, this wine sits perched ?' ||
 'and ready to do battle with the timid at heart. ?' ||
 'Best to put on your best armor before attempting this one.';

 /* cabernets */

 winebase(4).variety = 'cabs';
 winebase(4).vintner = 'Ch. St. Bean';
 winebase(4).vyear   = '1992';
 winebase(4).appellat = 'Alexander Vly';
 winebase(4).pdate   = '1994';
 winebase(4).mdate   = '1998';
 winebase(4).numbttl = 8;
 winebase(4).comments=
 'It is not amoung the biggest and boldest of the ?' ||
 'current crop but at least there is not much of it. ?' ||
 'We all have that to be thankful for.';

 winebase(5).variety = 'cabs';
 winebase(5).vintner = 'Opus OneTwoTree';
 winebase(5).vyear   = '1992';
 winebase(5).appellat = 'Sonoma';
 winebase(5).pdate   = '1993';
 winebase(5).mdate   = '1999';
 winebase(5).numbttl = 25;
 winebase(5).comments=
 'Mild, clean, and somewhat resembling sparkling ?' ||
 'water, this latest offering is a good reason ?' ||
 'not to rush down to the store too fast.';

 winebase(25).variety = 'cabs';
 winebase(25).vintner = 'Frenchy Town';
 winebase(25).vyear   = '1994';
 winebase(25).appellat = 'Ripon';
 winebase(25).pdate   = '1993';
 winebase(25).mdate   = '1992';
 winebase(25).numbttl = 2;
 winebase(25).comments=
 'While winning for both its abundant oak and its ?' ||
 'attractive, slightly festive feel, this foreign ?' ||
 'sounding wine makes a genuine effort.';

 winebase(26).variety = 'cabs';
 winebase(26).vintner = 'Francis Mustang';
 winebase(26).vyear   = '1993';
 winebase(26).appellat = 'AutoMall';
 winebase(26).pdate   = '1992';
 winebase(26).mdate   = '1993';
 winebase(26).numbttl = 5;
 winebase(26).comments=
 'Well-ripened, well-filled, and well to keep a ?' ||
 'safe distance from, the faintly leathery ?' ||
 'feel of this wine will keep you in your seat.';

 winebase(27).variety = 'cabs';
 winebase(27).vintner = 'Arts Choice';
 winebase(27).vyear   = '1994';
 winebase(27).appellat = 'BackRoom';
 winebase(27).pdate   = '1994';
 winebase(27).mdate   = '1994';
 winebase(27).numbttl = 1;
 winebase(27).comments=
 'Bouyant young fruit is given a boost in richness ?' ||
 'by nicely placed oak in the keenly felt aromas of ?' ||
 'this latest effort from Art.';

 winebase(28).variety = 'cabs';
 winebase(28).vintner = 'Splendor Knot';
 winebase(28).vyear   = '1994';
 winebase(28).appellat = 'Solano';
 winebase(28).pdate   = '1992';
 winebase(28).mdate   = '1995';
 winebase(28).numbttl = 45;
 winebase(28).comments=
 'Rumor filled and lasting well into the third ?' ||
 'chapter, this handsome effort is big enough ?' ||
 'to make even Grandma proud.';

 /* zinfandels */

 winebase(6).variety = 'zins';
 winebase(6).vintner = 'Saucy Canyon';
 winebase(6).vyear   = '1992';
 winebase(6).appellat = 'Central Coast';
 winebase(6).pdate   = '1996';
 winebase(6).mdate   = '2002';
 winebase(6).numbttl = 28;
 winebase(6).comments=
 'Young and attrctive, this wine smells of rich ?' ||
 'oak and ripe, beep but direct, almost simple ?' ||
 'fruit.  Time in the bottle is much needed here.';

 winebase(7).variety = 'zins';
 winebase(7).vintner = 'Bunny Ridge';
 winebase(7).vyear   = '1990';
 winebase(7).appellat = 'Rio Strata';
 winebase(7).pdate   = '1996';
 winebase(7).mdate   = '2001';
 winebase(7).numbttl = 29;
 winebase(7).comments=
 'Pleasing notes of bramble and roasted pepper ?' ||
 'are to be discovered in this luscious offering. ?' ||
 'This wine is not for the faint at heart, ?' ||
 'but for the adventurer.';

 winebase(8).variety = 'zins';
 winebase(8).vintner = 'Renderwood';
 winebase(8).vyear   = '1992';
 winebase(8).appellat = 'Almanor Co';
 winebase(8).pdate   = '1993';
 winebase(8).mdate   = '1999';
 winebase(8).numbttl = 20;
 winebase(8).comments=
 'Lemon candies and lollypops come to mind while  ?' ||
 'sipping this giganticly succulent wine.  Be sure ?' ||
 'to have your dental bills paid up to date.';

 winebase(9).variety = 'zins';
 winebase(9).vintner = 'Willies Wed';
 winebase(9).vyear   = '1994';
 winebase(9).appellat = 'Sonoma Co';
 winebase(9).pdate   = '1988';
 winebase(9).mdate   = '1992';
 winebase(9).numbttl = 24;
 winebase(9).comments=
 'A rather surprisingly balanced wine given its ?' ||
 'breeding.  Our hat is off to Willie and the ?' ||
 'gang for a magnificient release!';

 winebase(10).variety = 'zins';
 winebase(10).vintner = 'Neverrold';
 winebase(10).vyear   = '1991';
 winebase(10).appellat = 'Mendocino Co';
 winebase(10).pdate   = '1992';
 winebase(10).mdate   = '2002';
 winebase(10).numbttl = 53;
 winebase(10).comments=
 'Yet another cool area Zinfandel from this premium ?' ||
 'winery.  Harking back to the old Italian rootstock ?' ||
 'this one makes you beg for fresh pasta and pesto.';

 winebase(29).variety = 'zins';
 winebase(29).vintner = 'Bucky Walter';
 winebase(29).vyear   = '1992';
 winebase(29).appellat = 'Two Rocks';
 winebase(29).pdate   = '1992';
 winebase(29).mdate   = '2011';
 winebase(29).numbttl = 21;
 winebase(29).comments=
 'Brushy, somewhat toasty andclose to leesy in ?' ||
 'smell, this muddled wine offers no clear look at ?' ||
 'varietal fruit in either the nose or in ?' ||
 'its soft underbelly.';

 winebase(30).variety = 'zins';
 winebase(30).vintner = 'North Woods';
 winebase(30).vyear   = '1993';
 winebase(30).appellat = 'High Desert';
 winebase(30).pdate   = '1992';
 winebase(30).mdate   = '1992';
 winebase(30).numbttl = 10;
 winebase(30).comments=
 'Dark in color and notably extracted aromas, this ?' ||
 'potent, impressively stuffed, young wine brings ?' ||
 'together elements of ballet and ice hockey in its execution .';

 winebase(31).variety = 'zins';
 winebase(31).vintner = 'Bucking Bronco';
 winebase(31).vyear   = '1992';
 winebase(31).appellat = 'Wild West';
 winebase(31).pdate   = '1981';
 winebase(31).mdate   = '1991';
 winebase(31).numbttl = 14;
 winebase(31).comments=
 'If a bit low-keyed in aroma, this nicely made ?' ||
 'wine does hint at both cherries and the wide ?' ||
 'open range all at the same time!  Best to take the range.';

 /* merlots */

 winebase(11).variety = 'merlot';
 winebase(11).vintner = 'Dilbert Carey';
 winebase(11).vyear   = '1984';
 winebase(11).appellat = 'San Leandro';
 winebase(11).pdate   = '1982';
 winebase(11).mdate   = '1994';
 winebase(11).numbttl = 22;
 winebase(11).comments=
 'Citrus and oak scents can be found somewhere ?' ||
 'in the mix, but you would need a fine tooth  ?' ||
 'comb and magnifiyin glass to track them down.';

 winebase(12).variety = 'merlot';
 winebase(12).vintner = 'Nonesuch Hills';
 winebase(12).vyear   = '1984';
 winebase(12).appellat = '1er';
 winebase(12).pdate   = '1987';
 winebase(12).mdate   = '1997';
 winebase(12).numbttl = 888;
 winebase(12).comments=
 'Yet another cool area Merlot from this premium ?' ||
 'winery.  Harking back to the old Italian rootstock ?' ||
 'this one makes you beg for fresh pasta and pesto.';

 winebase(18).variety = 'merlot';
 winebase(18).vintner = 'Rye Heavenwood';
 winebase(18).vyear   = '1997';
 winebase(18).appellat = 'Amador Co';
 winebase(18).pdate   = '1998';
 winebase(18).mdate   = '1999';
 winebase(18).numbttl = 21;
 winebase(18).comments=
 'Young and attrctive, this wine smells of rich ?' ||
 'oak and ripe, beep but direct, almost simple ?' ||
 'fruit.  Time in the bottle is much needed here.';

 winebase(32).variety = 'merlot';
 winebase(32).vintner = 'Romeo Gorge';
 winebase(32).vyear   = '1954';
 winebase(32).appellat = 'Upper Napa';
 winebase(32).pdate   = '1983';
 winebase(32).mdate   = '1993';
 winebase(32).numbttl = 21;
 winebase(32).comments=
 'Lightly candied and moderately bred, this  ?' ||
 'accessable wine should keep for a few years ?' ||
 'giving you time to move to an address unknown.';

 winebase(33).variety = 'merlot';
 winebase(33).vintner = 'Rover Rounds';
 winebase(33).vyear   = '1994';
 winebase(33).appellat = 'Dog Patch';
 winebase(33).pdate   = '1997';
 winebase(33).mdate   = '1999';
 winebase(33).numbttl = 18;
 winebase(33).comments=
 'Soft, slightly plummy fruit is teamed with touches ?' ||
 'of the absurd making this a finger licking entry to ?' ||
 'the American Kennel Klubs annual fete.';

 winebase(34).variety = 'merlot';
 winebase(34).vintner = 'Morris Dancer';
 winebase(34).vyear   = '1994';
 winebase(34).appellat = 'Gym City';
 winebase(34).pdate   = '1988';
 winebase(34).mdate   = '1998';
 winebase(34).numbttl = 22;
 winebase(34).comments=
 'Nimble and overy flexible, this high stepping entry ?' ||
 'will dance your heart up into your throat with ?' ||
 'its wild turns from fruity to musty.';

 /* pinot noirs */

 winebase(13).variety = 'pnoir';
 winebase(13).vintner = 'Ch. LaLaLu';
 winebase(13).vyear   = '1974';
 winebase(13).appellat = 'Napa Valley';
 winebase(13).pdate   = '1978';
 winebase(13).mdate   = '1999';
 winebase(13).numbttl = 12;
 winebase(13).comments=
 'Mild, clean, and somewhat resembling sparkling ?' ||
 'water, this latest offering is a good reason ?' ||
 'not to rush down to the store too fast.';

 winebase(14).variety = 'pnoir';
 winebase(14).vintner = 'Whispering Bee';
 winebase(14).vyear   = '1991';
 winebase(14).appellat = 'Mannon Vly';
 winebase(14).pdate   = '1994';
 winebase(14).mdate   = '1994';
 winebase(14).numbttl = 75;
 winebase(14).comments=
 'Lemon candies and lollypops come to mind while  ?' ||
 'sipping this giganticly succulent wine.  Be sure ?' ||
 'to have your dental bills paid up to date.';

 winebase(16).variety = 'pnoir';
 winebase(16).vintner = 'Surry Ridge';
 winebase(16).vyear   = '1982';
 winebase(16).appellat = 'Arroyo Grande';
 winebase(16).pdate   = '1984';
 winebase(16).mdate   = '1989';
 winebase(16).numbttl = 2;
 winebase(16).comments=
 'It is not amoung the biggest and boldest of the ?' ||
 'current crop but at least there is not much of it. ?' ||
 'We all have that to be thankful for.';

 winebase(17).variety = 'pnoir';
 winebase(17).vintner = 'Rodent Ravine';
 winebase(17).vyear   = '1991';
 winebase(17).appellat = 'Rio Vista';
 winebase(17).pdate   = '1991';
 winebase(17).mdate   = '2099';
 winebase(17).numbttl = 3;
 winebase(17).comments=
 'Mild, clean, and somewhat resembling sparkling ?' ||
 'water, this latest offering is a good reason ?' ||
 'not to rush down to the store too fast.';

 winebase(35).variety = 'pnoir';
 winebase(35).vintner = 'Monument Valley';
 winebase(35).vyear   = '1992';
 winebase(35).appellat = 'West Ridge';
 winebase(35).pdate   = '1997';
 winebase(35).mdate   = '1999';
 winebase(35).numbttl = 15;
 winebase(35).comments=
 'With scenic vista and breath-taking views, this ?' ||
 'remote wine will make you want to put up your tent ?' ||
 'and stay a while.  Bring extra water.';

 winebase(36).variety = 'pnoir';
 winebase(36).vintner = 'Sunny Bend';
 winebase(36).vyear   = '1992';
 winebase(36).appellat = 'Round River';
 winebase(36).pdate   = '1994';
 winebase(36).mdate   = '1999';
 winebase(36).numbttl = 1;
 winebase(36).comments=
 'Wet and wild are the initial notes from this symphony ?' ||
 'of a wine.  The last movement you will remember will ?' ||
 'be the luscious flowing of this nectar over your tonsils.';

 winebase(37).variety = 'pnoir';
 winebase(37).vintner = 'Umpqua Bumps';
 winebase(37).vyear   = '1994';
 winebase(37).appellat = 'Candy Land';
 winebase(37).pdate   = '1994';
 winebase(37).mdate   = '1994';
 winebase(37).numbttl = 44;
 winebase(37).comments=
 'High is extract, oak, and ripeness, this substantial ?' ||
 'Pinot comes off with touches of pushy tannins and ?' ||
 'cooked fruit as its most attractive elements.';

 /* petite syrah   */

 winebase(15).variety = 'syrah';
 winebase(15).vintner = 'Safeway Select';
 winebase(15).vyear   = '1990';
 winebase(15).appellat = 'Sonoma Place';
 winebase(15).pdate   = '1991';
 winebase(15).mdate   = '1994';
 winebase(15).numbttl = 44;
 winebase(15).comments=
 'Pleasing notes of bramble and roasted pepper ?' ||
 'are to be discovered in this luscious offering. ?' ||
 'This wine is not for the faint at heart, ?' ||
 'but for the adventurer.';

 winebase(38).variety = 'syrah';
 winebase(38).vintner = 'Funny Lady';
 winebase(38).vyear   = '1992';
 winebase(38).appellat = 'Pretoria';
 winebase(38).pdate   = '1992';
 winebase(38).mdate   = '1995';
 winebase(38).numbttl = 11;
 winebase(38).comments=
 'Pleasing notes of bramble and roasted pepper ?' ||
 'are to be discovered in this luscious offering. ?' ||
 'This wine is not for the faint at heart, ?' ||
 'but for the adventurer.';

 winebase(44).variety = 'syrah';
 winebase(44).vintner = 'Titanic Reef';
 winebase(44).vyear   = '1998';
 winebase(44).appellat = 'Blue Sea';
 winebase(44).pdate   = '1998';
 winebase(44).mdate   = '1998';
 winebase(44).numbttl = 4;
 winebase(44).comments=
 'Pleasing notes of bramble and roasted pepper ?' ||
 'are to be discovered in this luscious offering. ?' ||
 'This wine is not for the faint at heart, ?' ||
 'but for the adventurer.';

 winebase(45).variety = 'syrah';
 winebase(45).vintner = 'Over Bearing';
 winebase(45).vyear   = '1998';
 winebase(45).appellat = 'South Bend';
 winebase(45).pdate   = '1999';
 winebase(45).mdate   = '1999';
 winebase(45).numbttl = 19;
 winebase(45).comments=
 'Pleasing notes of bramble and roasted pepper ?' ||
 'are to be discovered in this luscious offering. ?' ||
 'This wine is not for the faint at heart, ?' ||
 'but for the adventurer.';

 /* champagne */

 winebase(39).variety = 'champ';
 winebase(39).vintner = 'Garlic Hills';
 winebase(39).vyear   = '1992';
 winebase(39).appellat = 'Sonoma Co';
 winebase(39).pdate   = '1988';
 winebase(39).mdate   = '1999';
 winebase(39).numbttl = 244;
 winebase(39).comments=
 'While intensity and toasty richness have ?' ||
 'been a hallmark of this winery, the current ?' ||
 'offering is rounded on the palate with nice ?'||
 'balance with fresh fruit.';

 winebase(40).variety = 'champ';
 winebase(40).vintner = 'Neverever Land';
 winebase(40).vyear   = '1992';
 winebase(40).appellat = 'Mendocino Co';
 winebase(40).pdate   = '1992';
 winebase(40).mdate   = '2001';
 winebase(40).numbttl = 13;
 winebase(40).comments=
 'Light-medium in intensity with clean, fresh ?'||
 'and nicely stated appley fruit scents.  Service ?'||
 'with broiled fish or range fed chicken.';

 winebase(41).variety = 'champ';
 winebase(41).vintner = 'Modern Maisey';
 winebase(41).vyear   = '1993';
 winebase(41).appellat = 'Mendocino';
 winebase(41).pdate   = '1997';
 winebase(41).mdate   = '1997';
 winebase(41).numbttl = 4;
 winebase(41).comments=
 'Pleasing notes of bramble and roasted pepper ?' ||
 'are to be discovered in this luscious offering. ?' ||
 'This wine is not for the faint at heart, ?' ||
 'but for the adventurer.';

 winebase(42).variety = 'champ';
 winebase(42).vintner = 'Red Barn';
 winebase(42).vyear   = '1997';
 winebase(42).appellat = 'The Farm';
 winebase(42).pdate   = '1998';
 winebase(42).mdate   = '1999';
 winebase(42).numbttl = 244;
 winebase(42).comments=
 'While intensity and toasty richness have ?' ||
 'been a hallmark of this winery, the current ?' ||
 'offering is rounded on the palate with nice ?'||
 'balance with fresh fruit.';

 winebase(43).variety = 'champ';
 winebase(43).vintner = 'Believe it Not';
 winebase(43).vyear   = '1998';
 winebase(43).appellat = 'San Jose';
 winebase(43).pdate   = '1994';
 winebase(43).mdate   = '2004';
 winebase(43).numbttl = 43;
 winebase(43).comments=
 'Light-medium in intensity with clean, fresh ?'||
 'and nicely stated appley fruit scents.  Service ?'||
 'with broiled fish or range fed chicken.';

