/*****************************************************************************/
/*  Copyright:  Licensed Materials - Property of IBM                         */
/*                                                                           */
/*              This product contains "Restricted Materials of IBM"          */
/*                                                                           */
/*              5639-B94 (C) Copyright IBM Corp. 1996, 1997                  */
/*              All rights reserved.                                         */
/*                                                                           */
/*              U.S. Government Users Restricted Rights - Use,               */
/*              duplication or disclosure restricted by GSA ADP              */
/*              Schedule Contract with IBM Corp.                             */
/*                                                                           */
/*              See Copyright Instructions.                                  */
/*                                                                           */
/* ------------------------------------------------------------------------- */
/*                                                                           */
/*  Filename: tamlib.h                                                       */
/*                                                                           */
/*  Description: Twinax MAC device driver library header file for Win95/WinNT*/
/*                                                                           */
/*****************************************************************************/

#ifndef _tamlib__h
#define _tamlib__h

#ifndef BYTE
typedef unsigned char BYTE;
#endif

/*****************************************************************************/
/* The MAC driver's function prototypes for upper layer device driver        */
/*****************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
ULONG __stdcall GetVersion    (ULONG *pVersion, BYTE *pLevel);
ULONG __stdcall OpenAdapter   (ULONG adapterNumber, ULONG adapterType, ULONG irq,
                               ULONG portAddress, ULONG memoryAddress);
ULONG __stdcall OpenStation   (ULONG adapterNumber, ULONG stationAddress,
                               ULONG connectionType, ULONG keyboardType);
ULONG __stdcall SendData      (ULONG adapterNumber, ULONG stationAddress,
                               UCHAR *pSendData, ULONG dataLength);
ULONG __stdcall CloseAdapter  (ULONG adapterNumber);
ULONG __stdcall CloseStation  (ULONG adapterNumber, ULONG stationAddress);
ULONG __stdcall SendScanCode  (ULONG adapterNumber, ULONG stationAddress,
                               ULONG scanCode);
ULONG __stdcall SendPrtStatus (ULONG adapterNumber, ULONG stationAddress,
                               ULONG rspStatus1, ULONG rspStatus2, ULONG prtStatus);
ULONG __stdcall PrintComplete (ULONG adapterNumber, ULONG stationAddress);
ULONG __stdcall ClearComplete (ULONG adapterNumber, ULONG stationAddress);
#ifdef __cplusplus
}
#endif

/*****************************************************************************/
/* The Common driver's function prototypes for the MAC library               */
/*****************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
ULONG  __stdcall OpenComplete   (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG errorCode);
UCHAR* __stdcall GetBuffer      (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG length);
ULONG  __stdcall ReceiveData    (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG dataLength);
ULONG  __stdcall SendComplete   (ULONG adapterNumber, ULONG stationAddress);
ULONG  __stdcall Timeout        (ULONG adapterNumber, ULONG stationAddress);
ULONG  __stdcall LoadCursor     (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG cursorPosition);
ULONG  __stdcall DisplayControl (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG controlData);
ULONG  __stdcall DisplayMode    (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG displayMode);
ULONG  __stdcall ScreenUpdate   (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG updatePosition, ULONG updateLength);
ULONG  __stdcall OIAUpdate      (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG oiaIndicator, ULONG saIndicator);
ULONG  __stdcall ResetPrinter   (ULONG adapterNumber, ULONG stationAddress);
ULONG  __stdcall ClearBuffer    (ULONG adapterNumber, ULONG stationAddress);
ULONG  __stdcall PrintData      (ULONG adapterNumber, ULONG stationAddress,
                                 ULONG dataLength);
#ifdef __cplusplus
}
#endif

/*****************************************************************************/
/* The MAC library's function prototype for an NT MAC driver                 */
/*****************************************************************************/
#ifdef DLC_NT
#ifdef __cplusplus
extern "C"
#endif (__cplusplus)
NTSTATUS __stdcall SetFunctionTables (PDEVICE_OBJECT device, PIRP irp);
#endif DLC_NT

/*****************************************************************************/
/* The MAC library's function prototype for a Win95 MAC VxD                  */
/*****************************************************************************/
#ifdef DLC_WIN
#ifdef __cplusplus
extern "C"
#endif (__cplusplus)
ULONG __stdcall SetFunctionTables (void *pInBuffer,  ULONG lInBuffer,
                                   void *pOutBuffer, ULONG *plOutBuffer);
#endif DLC_WIN

#endif
