/**********************************************************************/
/*  DISCLAIMER                                                        */
/*                                                                    */
/*  THIS SAMPLE PROGRAM IS PROVIDED FOR TUTORIAL PURPOSES ONLY.  A    */
/*  COMPLETE HANDLING OF ERROR CONDITIONS HAS NOT BEEN SHOWN OR       */
/*  ATTEMPTED, AND THIS PROGRAM HAS NOT BEEN SUBMITTED TO FORMAL IBM  */
/*  TESTING.  THIS PROGRAM IS DISTRIBUTED ON AN 'AS IS' BASIS         */
/*  WITHOUT ANY WARRANTIES EITHER EXPRESSED OR IMPLIED.               */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/*   Program     : APPCCGI.C                                          */
/*   Description : This is a CGI program which converts the output of */
/*                 a Hotel Reservation form, submiitted with a method */
/*                 of POST, to the message format required by a CPIC  */
/*                 subroutine, and display a list of the variables and*/
/*                 values. The CPIC subroutine takes the converted    */
/*                 data and submits IMS transaction and returns the   */
/*                 result in a buffer. The buffer will then be dumpped*/
/*                 out in the returned page. This program is modified */
/*                 from the sample pgram povided by IBM Internet      */
/*                 Connection Server for OS/2 Warp SC31-8245-00       */
/**********************************************************************/
/**********************************************************************/
/*   Includes                                                         */
/**********************************************************************/
#include <doims.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/**********************************************************************/
/*   Global Variables                                                 */
/**********************************************************************/
char *hotelname;             /* Hotel Name                            */
char *fname;                 /* First Name                            */
char *lname;                 /* Last Name                             */
char *bdate;                 /* Arrival Date                          */
char *edate;                 /* Departure Date                        */
char *roomtype;              /* Type of Room                          */
char *bedtype;               /* Type of Bed                           */
char *pnumber;               /* Number of Occupant                    */
int bufferSize = 600;        /* DOIMS Input/Output buffer Size        */

/**********************************************************************/
/*   Function Prototypes                                              */
/**********************************************************************/
void ErrMsg(char *msg);
void ReadArguments(int InputLength);
static void PluseToSpaces(char *Str);
static int HexVal(char c);
static void TranslateEscape(char *Str);
int doIMS (char *in, char *out);

/**********************************************************************/
/*   Function    : main                                               */
/*   Description : This is the main routine that reads input from     */
/*                 envp[], checks all the necessary fields and calls  */
/*                 ReadArguments to parse input arguments. It prepares*/
/*                 message for DOIMS and call DOIMS to get data from  */
/*                 IMS, then display the results.                  /
/**********************************************************************/
void main(int argc, char *argv[], char *envp[])
{
  char *requestMethod;       /* Request method                        */
  char *contentLength;       /* Content length  (in ASCII )           */
  int  argLength;            /* Content length                        */
  char *indata = NULL;       /* Input buffer for DOIMS function       */
  char *outdata = NULL;      /* Output buffer for DOIMS function      */
  int rc;                    /* DOIMS return code                     */
  int i;                     /* Wroking area for integer              */
  char ch;                   /* Working area for char                 */
  HRD1 *pParm;

  /* Begin dynamic document                                           */
  printf("CONTENT-TYPE: text/html\n\n");
  printf("<html>\n");
  printf("<head>\n");
  printf("<title>Hotel Reservation Response Page</title>\n");
  printf("</head>\n");
  printf("<body>\n");

  if (  !(indata = malloc(bufferSize)) ||   /* Allocate input/output  */
        !(outdata = malloc(bufferSize)))    /* buffers for DOIMS      */
  {
    ErrMsg("Sever run out of memory\n");    /* No memory              */
  }
  else {
    requestMethod = getenv("REQUEST_METHOD");    /* Get request method*/

    if ((requestMethod == NULL) ||          /* Check if the method is */
        ((strcmp(requestMethod,"POST")) &&   /* set to POST           */
         (strcmp(requestMethod,"post"))))
    {
      /* Tell user the method is wrong                                */
      ErrMsg("Request_Method environment variable is not POST\n");
    }
    else {
      contentLength = getenv("CONTENT_LENGTH");  /* Get content length*/
      if (contentLength == NULL)       /* Check if content length OK  */
      {

        /* Content length is not good                                 */
        ErrMsg("CONTENT_LENGTH environment variable is not set\n");
      }
      else {

        /* Print out header for input                                 */
        printf("<h1>Hotel Reservation Input are</h1>\n");
        printf("<hr>\n");
        printf("<p>\n");

        argLength = atoi(contentLength);    /* Convert ASCII to int   */
        ReadArguments(argLength);           /* Read input arguments   */

        /* Print out input arguments                                  */
        printf("<pre>Last  Name        : %s</pre><p>",lname);
        printf("<pre>Frist Name        : %s</pre><p>",fname);
        printf("<pre>Hotel Name        : %s</pre><p>",hotelname);
        printf("<pre>Room Type         : %s</pre><p>",roomtype);
        printf("<pre>Bed  Type         : %s</pre><p>",bedtype);
        printf("<pre>Arrival   Date    : %s</pre><p>",bdate);
        printf("<pre>Departure Date    : %s</pre><p>",edate);
        printf("<pre>Number of Person  : %s</pre><p>",pnumber);

        /* Prepare input buffer for DOIMS                             */
        /**************************************************************/
        /* NOTE: The transaction to be scheduled is HRD1              */
        /*       From the IMS applicaton program we know that         */
        /*       the expected format for input data is                */
        /*         Byte   0 - 73   status (we don't use it)           */
        /*         Byte  74 - 95   hotel name                         */
        /*         Byte  96 - 103  arrival date                       */
        /*         Byte 104 - 111  departure date                     */
        /*         Byte 112 - 116  type of room                       */
        /*         Byte 117 - 121  type of bed                        */
        /*         Byte 122 - 125  number of person                   */
        /*       the total length of input data is 126                */
        /*                                                            */
        /*       DOIMS.C needs to know the transaction name, so we    */
        /*       pass it in the buffer 'indata' followed by the       */
        /*       above data                                           */
        /**************************************************************/
        memset(indata,' ',bufferSize);
        memcpy(indata ,"HRD1",4);
        pParm = (HRD1 *)((char*)indata+4);
        memcpy(pParm->hotel, hotelname, strlen(hotelname));
        memcpy(pParm->adate, bdate    , strlen(bdate));
        memcpy(pParm->ddate, edate    , strlen(edate));
        memcpy(pParm->rtype, roomtype , strlen(roomtype));
        memcpy(pParm->btype, bedtype  , strlen(bedtype));
        memcpy(pParm->persons, pnumber  , strlen(pnumber));

        rc = doIMS(indata,outdata);    /* Call DOIMS subroutine to do */
                                       /* APPC connection with IMS    */

        if (rc > 0) {                  /* DOIMS got the data, the     */
                                       /* reservation may not be done,*/
                                       /* but the error is expected   */
                                       /* by IMS transaction          */

          printf("<pre>\n");           /* Print out response          */
          printf("<pre>The response is : %s\n</pre><p>",&outdata[0]);
        }
      }
    }
  }

  /* Finish dynamic document                                          */
  printf("<pre>\n");
  printf("<p>\n");
  printf("<hr>\n");
  printf("</body>\n");
  printf("</html>\n");

  {
  }
  if (indata) {              /* Free input buffer                     */
    free(indata);
    indata = NULL;
  }
  if (outdata) {             /* Free output buffer                    */
    free(outdata);
    outdata = NULL;
  }
}

/**********************************************************************/
/*   Function    : ReadArguments                                      */
/*   Description : This routine reads the arguments from stdin and    */
/*                 parses the input into (Name, Value) pairs that     */
/*                 needed to run DOIMS subroutine. It also handles    */
/*                 translation of all the special characters that     */
/*                 HTTP puts into the input strings.                  */
/*                 The arguments requirement by DOIMS are             */
/*                 1. hotelName                                       */
/*                                                                    */
/*   Input       : InputLength - Length of the input data coming from */
/*                               stdin.                               */
/*   Output      : none                                               */
/**********************************************************************/
void ReadArguments(int InputLength)
{
  char *Input;               /* Input data                            */
  char *pToken;              /* Working area for arguments            */
  char *name;                /* Argument Name                         */
  char *value;               /* Argument Value                        */
  int i=1,x=3;



  if (InputLength <1)        /*  Bad InputLength value                */
    return;
  /* Allocate spaces for input arguments                              */
  Input = malloc(InputLength + 1);

  if (Input == NULL)
        return;

  gets(Input);               /* Get the whole input string            */

  pToken = strtok(Input,"&");
  while(pToken)
    {

        name = pToken;
        pToken = strchr(pToken,'=');
        if (pToken)
          {
          *pToken = '\0';
          value = ++pToken;
          PluseToSpaces(pToken);
          TranslateEscape(pToken);
          }
        else
          {
          value = NULL;
          }
        if (!strcmp(name,"hotelname"))
          {
            hotelname = malloc(strlen(value)+1);
                strcpy(hotelname,value);
          }
        if (!strcmp(name,"bedtype"))
          {
            bedtype = malloc(strlen(value)+1);
                strcpy(bedtype,value);
          }
        if (!strcmp(name,"roomtype"))
          {
            roomtype = malloc(strlen(value)+1);
                strcpy(roomtype,value);
          }
        if (!strcmp(name,"fname"))
          {
            fname = malloc(strlen(value)+1);
                strcpy(fname,value);
          }
        if (!strcmp(name,"lname"))
          {
            lname = malloc(strlen(value)+1);
                strcpy(lname,value);
          }
        if (!strcmp(name,"bdate"))
          {
            bdate = malloc(strlen(value)+1);
                strcpy(bdate,value);
          }
        if (!strcmp(name,"edate"))
          {
            edate = malloc(strlen(value)+1);
                strcpy(edate,value);
          }

        if (!strcmp(name,"pnumber"))
          {
            pnumber = malloc(strlen(value)+1);
                strcpy(pnumber,value);
          }
        pToken = strtok(NULL,"&");
    }

}

/**********************************************************************/
/*   Function    : PlusToSpaces                                       */
/*   Description : This routine translates any '+' characters found   */
/*                 into ' 'characters.                                */
/*   Input       : *str - Pointer to the string to be trasnslated     */
/*   Output      : none                                               */
/**********************************************************************/
static void PluseToSpaces(char *Str)
{
  if (Str != NULL)
    {
    while(*Str != '\0')
      {
      if (*Str =='+')
        {
        *Str = ' ';
        }
      ++Str;
      }
    }
 }

/**********************************************************************/
/*   Function    : HexVal                                             */
/*   Description : This routine returns a number that corresponds to  */
/*                 the value of a character treated as a hex digit.   */
/*                 Characters other than 0-9,a-f,A-F have a value of  */
/*                 0.                                                 */
/*   Input       : char - The character represents number value       */
/*   Output      : int  - The number value                            */
/**********************************************************************/
 static int HexVal(char c)
 {
   int rc;

   switch (c)
     {
     case '1':
       rc = 1;
       break;
     case '2':
       rc = 2;
       break;
     case '3':
       rc = 3;
       break;
     case '4':
       rc = 4;
       break;
     case '5':
       rc = 5;
       break;
     case '6':
       rc = 6;
       break;
     case '7':
       rc = 7;
       break;
     case '8':
       rc = 8;
       break;
     case '9':
       rc = 9;
       break;
     case 'a':
     case 'A':
       rc = 10;
       break;
     case 'b':
     case 'B':
       rc = 11;
       break;
     case 'c':
     case 'C':
       rc = 12;
       break;
     case 'd':
     case 'D':
       rc = 13;
       break;
     case 'e':
     case 'E':
       rc = 14;
       break;
     case 'f':
     case 'F':
       rc = 15;
       break;

     default:
       rc=0;
       break;
         }
   return (rc);
 }

/**********************************************************************/
/*   Function    : TranslateEscapes                                   */
/*   Description : This routine translates the escape sequences       */
/*                 induced by HTTP. The Sequences consist of %xx,     */
/*                 where xx is a nex number. It replaces the %        */
/*                 character with the actual character whose ascii    */
/*                 value is xx, and then shift over the rest of the   */
/*                 string to remove xx.                               */
/*   Input       : *Str - The string to  be translated                */
/*   Output      : none                                               */
/**********************************************************************/
 static void TranslateEscape(char *Str)
 {
   char *NextEscape;
   int   AsciiValue;

   NextEscape = strchr(Str,'%');
   while (NextEscape != NULL)
     {
     AsciiValue = (16*HexVal(NextEscape[1])) + HexVal(NextEscape[2]);
     *NextEscape = (char)AsciiValue;
     memmove(&NextEscape[1],&NextEscape[3],strlen(&NextEscape[3])+1);
     NextEscape = strchr(&NextEscape[1],'%');
     }
 }

/**********************************************************************/
/*   Function    : ErrMsg                                             */
/*   Description : This routine displays a message if an error        */
/*                 occurs in CGI program.                             */
/*   Input       : *msg - The message to be displayed.                */
/*   Output      : none                                               */
/**********************************************************************/
void ErrMsg(char *msg)
{
  printf("<h1>Error</h1>\n");
  printf("<hr>\n");
  printf("<p>\n");

  printf("The CGI program error occured.\n");
  printf("Error Message is shown below:\n");
  printf("<p>\n");
  printf("<pre>%s</pre>\n<p>",msg);

  printf("<p>\n");
  printf("<hr>\n");

}
