/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

class ATransferProcess {
    private static final String HTML_BREAK = "<br>";
    private static final String HTML_PARAGRAPH = "<P>";
    public Vector filesTransferred;
    private static final String SQUOTE = "'";
    private static final String DOT = ".";
    private ATraceFile tf = new ATraceFile(this);
    private InputStream is;
    private OutputStream os;
    private ARepository aRepositorySource;
    private ARepository aRepositoryTarget;
    private AFtp aFtpSource = null;
    private AFtp aFtpTarget = null;
    private String bksDestination;
    private String booDestination;
    private String bkiDestination;
    private String pdfDestination;
    private Vector bksSiteCommands;
    private Vector booSiteCommands;
    private Vector bkiSiteCommands;
    private Vector pdfSiteCommands;
    private String urlPath;
    private URL url;
    private String completeSourceFilename;
    private String completeTargetFilename;
    private String tempTargetFilename;
    private int fileBytesTransferred = 0;
    private int allFilesBytesTransferred = 0;
    private int totalFilesToBeTransferred = 0;
    private int numberOfFileBeingTransferred = 0;
    private int lastTransferRateBytes = 0;
    private long transferStartTime = 0L;
    private long lastTransferRateTime = 0L;
    private long lastTransferRateBps = 0L;
    private boolean aTransferStopped = false;
    private AFileObject originalThisFile = null;
    private ATransferProgressWindow aTransferProgressWindow = null;
    private JFrame owner;
    private ASource aSource;

    public boolean isUsingFtp(ARepository aRepository) {
        return aRepository.hostType() != 5;
    }

    public boolean isShelf(AFileObject aFileObject) {
        return aFileObject.hostFileType().equals("BKSHELF");
    }

    public boolean isTransferStopped() {
        return this.aTransferStopped;
    }

    private void setTransferStopped(boolean bl) {
        this.aTransferStopped = bl;
    }

    private AFtpReturnCode closeSourceFile(AFileObject aFileObject) {
        this.tf.write("closeSourceFile()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        try {
            if (aFileObject.useLocalSource()) {
                this.is.close();
                if (!this.isShelf(aFileObject)) {
                    new File(this.completeSourceFilename).delete();
                }
            } else if (this.aSource == null) {
                if (this.isUsingFtp(this.aRepositorySource)) {
                    aFtpReturnCode = this.aFtpSource.closeSourceFile();
                } else {
                    this.is.close();
                }
            } else if (this.aSource.usingInternet()) {
                try {
                    ((HttpURLConnection)this.url.openConnection()).disconnect();
                }
                catch (Exception exception) {
                    this.tf.write("transferObject()", 0, exception.toString());
                }
            } else {
                this.is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tf.write("closeSourceFile()", 1, "exit.  Process code = " + aFtpReturnCode.getProcessCode());
        return aFtpReturnCode;
    }

    private int queryUserContinue(String string) {
        int n;
        this.tf.write("queryUserContinue()", 1, "entry");
        this.tf.write("queryUserContinue()", 1, "message = " + string);
        Object[] objectArray = new Object[]{"Try again", "Skip this file", "Stop transferring files"};
        int n2 = JOptionPane.showOptionDialog(AUtilities.mainWindow, "<html>" + string + "</html>", "Query", 1, 3, null, objectArray, objectArray[2]);
        switch (n2) {
            case 0: {
                n = 2;
                this.tf.write("queryUserContinue()", 0, "User selected to Try Again.");
                break;
            }
            case 1: {
                n = 0;
                this.tf.write("queryUserContinue()", 0, "User selected Skip This File.");
                break;
            }
            default: {
                n = 1;
                this.tf.write("queryUserContinue()", 0, "User selected Stop Transferring Files.");
            }
        }
        this.tf.write("queryUserContinue()", 1, "exit");
        return n;
    }

    private AFtpReturnCode logonToHost(AFtp aFtp, ARepository aRepository) {
        this.tf.write("logonToHost()", 1, "entry");
        aFtp.setLogonParameters(new AFtpLogonParameters(aRepository));
        AFtpReturnCode aFtpReturnCode = aFtp.logon();
        this.tf.write("logonToHost()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openSourceFileFTP(AFileObject aFileObject) {
        this.tf.write("openSourceFileFTP()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        this.completeSourceFilename = aFileObject.nameInRepository();
        this.tf.write("openSourceFileFTP()", 0, "sourceFile = " + this.completeSourceFilename);
        aFtpReturnCode = this.isShelf(aFileObject) ? this.aFtpSource.ascii() : this.aFtpSource.binary();
        if (aFtpReturnCode.getCommandCode() == 2) {
            aFtpReturnCode = this.aFtpSource.openSourceFile(this.completeSourceFilename);
        }
        if (aFtpReturnCode.getProcessCode() == 0) {
            this.is = this.aFtpSource.dataStreamReader;
        }
        this.tf.write("openSourceFileFTP()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openSourceFileInternet(AFileObject aFileObject) {
        AFtpReturnCode aFtpReturnCode;
        block4: {
            this.tf.write("openSourceFileInternet()", 1, "entry");
            aFtpReturnCode = new AFtpReturnCode();
            this.completeSourceFilename = aFileObject.directName().toLowerCase();
            this.tf.write("openSourceFileInternet()", 0, "completeSourceFilename = " + this.completeSourceFilename);
            try {
                this.url = new URL(this.urlPath + this.completeSourceFilename);
                this.is = this.url.openStream();
                this.completeSourceFilename = this.url.toString();
            }
            catch (Exception exception) {
                this.tf.write("openSourceFileInternet()", 0, exception.toString());
                aFtpReturnCode.setException(exception);
                aFtpReturnCode.setMessage("Error attempting to open source file:<br>" + this.completeSourceFilename + HTML_BREAK + HTML_BREAK);
                String string = exception.getClass().getName();
                if (string.equals("java.io.FileNotFoundException")) {
                    aFtpReturnCode.setProcessCode(303);
                    aFtpReturnCode.setMessage(aFtpReturnCode.getMessage() + "This file is no longer available.");
                }
                if (string.equals("java.net.MalformedURLException")) {
                    aFtpReturnCode.setProcessCode(302);
                }
                if (!string.equals("java.net.UnknownHostException")) break block4;
                aFtpReturnCode.setProcessCode(310);
                aFtpReturnCode.setMessage(aFtpReturnCode.getMessage() + "No path found to host.  Use \"Settings->Proxy\" " + "to verify your Proxy definitions");
            }
        }
        this.tf.write("openSourceFileInternet()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openSourceFileLocal(AFileObject aFileObject) {
        AFtpReturnCode aFtpReturnCode;
        block4: {
            this.tf.write("openSourceFileLocal()", 1, "entry");
            aFtpReturnCode = new AFtpReturnCode();
            this.completeSourceFilename = aFileObject.useLocalSource() || this.aSource != null ? aFileObject.directName() : aFileObject.nameInRepository();
            this.tf.write("openSourceFileLocal()", 0, "completeSourceFilename = " + this.completeSourceFilename);
            try {
                this.url = new URL("file", "", this.completeSourceFilename);
                this.is = this.url.openStream();
            }
            catch (Exception exception) {
                this.tf.write("openSourceFileLocal()", 0, exception.toString());
                aFtpReturnCode.setException(exception);
                if (this.completeSourceFilename.equals("")) {
                    this.completeSourceFilename = aFileObject.fileNameType();
                }
                aFtpReturnCode.setMessage("Error attempting to open source file:<br>" + this.completeSourceFilename);
                String string = exception.getClass().getName();
                if (string.equals("java.io.FileNotFoundException")) {
                    aFtpReturnCode.setProcessCode(301);
                }
                if (!string.equals("java.net.MalformedURLException")) break block4;
                aFtpReturnCode.setProcessCode(300);
            }
        }
        this.tf.write("openSourceFileLocal()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openTargetFileLocal(AFileObject aFileObject) {
        this.tf.write("openTargetFileLocal()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        String string = aFileObject.fileName();
        if (aFileObject.pcFileType().toUpperCase().equals("BOO")) {
            this.completeTargetFilename = this.booDestination + string + ".boo";
        } else if (aFileObject.pcFileType().toUpperCase().equals("BKS")) {
            this.completeTargetFilename = this.bksDestination + string + ".bks";
        } else if (aFileObject.pcFileType().toUpperCase().equals("BKI")) {
            this.completeTargetFilename = this.bkiDestination + string + ".bki";
        }
        this.tf.write("openTargetFileLocal()", 0, "completeTargetFilename = " + this.completeTargetFilename);
        try {
            File file = new File(this.completeTargetFilename);
            this.os = new FileOutputStream(file);
        }
        catch (Exception exception) {
            this.tf.write("openTargetFileLocal()", 0, exception.toString());
            aFtpReturnCode.setException(exception);
            aFtpReturnCode.setMessage("Error attempting to open output file:<br>" + this.completeTargetFilename);
            String string2 = exception.getClass().getName();
            if (string2.equals("java.io.FileNotFoundException")) {
                aFtpReturnCode.setProcessCode(306);
            }
            aFtpReturnCode.setProcessCode(308);
        }
        this.tf.write("openTargetFileLocal()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openTargetFileOS390(AFileObject aFileObject) {
        this.tf.write("openTargetFileOS390()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        String string = aFileObject.fileName().toUpperCase();
        if (aFileObject.hostFileType().equals("BOOK")) {
            this.completeTargetFilename = this.booDestination + DOT + string + ".BOOK";
            this.tf.write("openTargetFileOS390", 0, "completeTargetFilename = " + this.completeTargetFilename);
            this.tempTargetFilename = this.booDestination + ".EBRXTEMP.BOOK";
            aFtpReturnCode = this.aFtpTarget.quote("SITE RECFM=FBS LRECL=4096 BLKSIZE=24576");
            aFtpReturnCode = this.aFtpTarget.quote("SITE BLOCK PRIMARY=" + String.valueOf(aFileObject.sizeAsInt() / Integer.parseInt(this.aRepositoryTarget.ftpBlkSize(1))) + " SECONDARY=1");
            Enumeration enumeration = this.booSiteCommands.elements();
            while (enumeration.hasMoreElements()) {
                aFtpReturnCode = this.aFtpTarget.quote((String)enumeration.nextElement());
            }
            aFtpReturnCode = this.aFtpTarget.binary();
        } else if (aFileObject.hostFileType().equals("BKSHELF")) {
            this.completeTargetFilename = this.bksDestination + DOT + string + ".BKSHELF";
            this.tf.write("openTargetFileOS390()", 0, "completeTargetFilename = " + this.completeTargetFilename);
            this.tempTargetFilename = this.bksDestination + ".EBRXTEMP.BKSHELF";
            aFtpReturnCode = this.aFtpTarget.quote("SITE RECFM=VB LRECL=259");
            aFtpReturnCode = this.aFtpTarget.quote("SITE TRACK PRIMARY=1 SECONDARY=1");
            Enumeration enumeration = this.bksSiteCommands.elements();
            while (enumeration.hasMoreElements()) {
                aFtpReturnCode = this.aFtpTarget.quote((String)enumeration.nextElement());
            }
            aFtpReturnCode = this.aFtpTarget.ascii();
        } else if (aFileObject.hostFileType().equals("BKINDEX")) {
            this.completeTargetFilename = this.bkiDestination + DOT + string + ".BKINDEX";
            this.tf.write("openTargetFileOS390()", 0, "completeTargetFilename = " + this.completeTargetFilename);
            this.tempTargetFilename = this.bkiDestination + ".EBRXTEMP.BKINDEX";
            aFtpReturnCode = this.aFtpTarget.quote("SITE RECFM=FBS LRECL=4096 BLKSIZE=24576");
            Enumeration enumeration = this.bkiSiteCommands.elements();
            while (enumeration.hasMoreElements()) {
                aFtpReturnCode = this.aFtpTarget.quote((String)enumeration.nextElement());
            }
            aFtpReturnCode = this.aFtpTarget.quote("SITE BLOCK PRIMARY=" + String.valueOf(aFileObject.sizeAsInt() / Integer.parseInt(this.aRepositoryTarget.ftpBlkSize(1))) + " SECONDARY=1");
            aFtpReturnCode = this.aFtpTarget.binary();
        }
        this.completeTargetFilename = SQUOTE + this.completeTargetFilename + SQUOTE;
        this.tempTargetFilename = SQUOTE + this.tempTargetFilename + SQUOTE;
        if (aFtpReturnCode.getCommandCode() == 2) {
            aFtpReturnCode = this.aFtpTarget.openTargetFile(this.tempTargetFilename);
        }
        if (aFtpReturnCode.getCommandCode() == 2) {
            this.os = this.aFtpTarget.dataStreamWriter;
        } else {
            aFtpReturnCode.setProcessCode(199);
        }
        this.tf.write("openTargetFileOS390()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openTargetFileOS390OE(AFileObject aFileObject) {
        this.tf.write("openTargetFileOS390OE()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = this.openTargetFileUnix(aFileObject);
        this.tf.write("openTargetFileOS390OE()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openTargetFileUnix(AFileObject aFileObject) {
        this.tf.write("openTargetFileUnix()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        if (aFileObject.hostFileType().equals("BOOK")) {
            this.completeTargetFilename = this.booDestination + aFileObject.fileName() + ".boo";
            this.tf.write("openTargetFileUnix()", 0, "completeTargetFilename = " + this.completeTargetFilename);
            this.tempTargetFilename = this.booDestination + "EBRXTEMP.boo";
            aFtpReturnCode = this.aFtpTarget.binary();
        } else if (aFileObject.hostFileType().equals("BKSHELF")) {
            this.completeTargetFilename = this.bksDestination + aFileObject.fileName() + ".bks";
            this.tf.write("openTargetFileUnix()", 0, "completeTargetFilename = " + this.completeTargetFilename);
            this.tempTargetFilename = this.bksDestination + "EBRXTEMP.bks";
            aFtpReturnCode = this.aFtpTarget.ascii();
        } else if (aFileObject.hostFileType().equals("BKINDEX")) {
            this.completeTargetFilename = this.bkiDestination + aFileObject.fileName() + ".bki";
            this.tf.write("openTargetFileUnix()", 0, "completeTargetFilename = " + this.completeTargetFilename);
            this.tempTargetFilename = this.bkiDestination + "EBRXTEMP.bki";
            aFtpReturnCode = this.aFtpTarget.binary();
        }
        if (aFtpReturnCode.getCommandCode() == 2) {
            aFtpReturnCode = this.aFtpTarget.openTargetFile(this.tempTargetFilename);
        }
        if (aFtpReturnCode.getCommandCode() == 2) {
            this.os = this.aFtpTarget.dataStreamWriter;
        } else {
            aFtpReturnCode.setProcessCode(199);
        }
        this.tf.write("openTargetFileUnix()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode performTransferInitialization(Vector vector) {
        return this.performTransferInitialization(vector, false);
    }

    public AFtpReturnCode performTransferInitialization(Vector vector, boolean bl) {
        Object object;
        this.tf.write("performTransferInitialization()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        long l = 0L;
        int n = 0;
        if (this.aSource == null) {
            if (this.aRepositorySource.hostType() != 5) {
                this.aFtpSource = new AFtp();
                aFtpReturnCode = this.logonToHost(this.aFtpSource, this.aRepositorySource);
                if (aFtpReturnCode.getCommandCode() != 2) {
                    return aFtpReturnCode;
                }
                if (this.aRepositorySource.hostType() == 1) {
                    aFtpReturnCode = this.aFtpSource.quote("SITE AUTORECALL");
                } else if (this.aRepositorySource.hostType() == 3) {
                    aFtpReturnCode = this.aFtpSource.quote("SITE AUTORECALL");
                } else if (this.aRepositorySource.hostType() == 4) {
                    // empty if block
                }
            }
        } else if (this.aSource.usingInternet()) {
            this.urlPath = this.aSource.sourcePath();
            int n2 = this.urlPath.indexOf(32);
            if (n2 != -1) {
                this.urlPath = this.urlPath.substring(0, n2);
            }
        }
        if (this.aRepositoryTarget.hostType() != 5) {
            this.aFtpTarget = new AFtp();
            aFtpReturnCode = this.logonToHost(this.aFtpTarget, this.aRepositoryTarget);
            if (aFtpReturnCode.getCommandCode() != 2) {
                return aFtpReturnCode;
            }
        }
        if (!bl) {
            String string = "";
            string = this.aRepositoryTarget.hostType() == 1 ? this.aRepositoryTarget.fileTypesList().getObject(1).hlqs() : this.aRepositoryTarget.softcopyDirectories();
            object = new StringTokenizer(string, "\n");
            if (((StringTokenizer)object).countTokens() > 1) {
                String string2 = "These are the qualifiers for softcopy files that you specified in Setup. Select the qualifier to use for the files about to be transferred.";
                ADirectorySelect aDirectorySelect = new ADirectorySelect(this.owner, string2, string);
                if (aDirectorySelect.retCode == 1) {
                    aFtpReturnCode.setProcessCode(1);
                    return aFtpReturnCode;
                }
                this.booDestination = AUtilities.strip((String)aDirectorySelect.targetDirectory, '\'');
            }
        }
        if (this.aRepositoryTarget.hostType() == 1) {
            if (this.booDestination == null) {
                this.booDestination = AUtilities.strip((String)this.aRepositoryTarget.fileTypesList().getObject(1).hlqsAsVector().firstElement(), '\'');
            }
            this.bkiDestination = AUtilities.strip(this.aRepositoryTarget.fileTypesList().getObject(5).hlq(), '\'');
            this.bksDestination = AUtilities.strip(this.aRepositoryTarget.fileTypesList().getObject(2).hlq(), '\'');
            this.booSiteCommands = this.aRepositoryTarget.ftpSiteCommands(1);
            this.bkiSiteCommands = this.aRepositoryTarget.ftpSiteCommands(5);
            this.bksSiteCommands = this.aRepositoryTarget.ftpSiteCommands(2);
        } else if (this.aRepositoryTarget.hostType() == 3) {
            if (this.booDestination == null) {
                this.booDestination = this.aRepositoryTarget.softcopyDirectories();
            }
            this.bkiDestination = this.aRepositoryTarget.indexDirectories();
            this.bksDestination = this.aRepositoryTarget.shelvesDirectories();
        } else if (this.aRepositoryTarget.hostType() == 4) {
            if (this.booDestination == null) {
                this.booDestination = this.aRepositoryTarget.softcopyDirectories();
            }
            this.bkiDestination = this.aRepositoryTarget.indexDirectories();
            this.bksDestination = this.aRepositoryTarget.shelvesDirectories();
        } else if (this.aRepositoryTarget.hostType() == 5) {
            if (this.booDestination == null) {
                this.booDestination = this.aRepositoryTarget.softcopyDirectories();
            }
            this.bkiDestination = this.aRepositoryTarget.indexDirectories();
            this.bksDestination = this.aRepositoryTarget.shelvesDirectories();
        }
        this.tf.write("performTransferInitialization()", 0, "booDestination = " + this.booDestination);
        this.tf.write("performTransferInitialization()", 0, "bkiDestination = " + this.bkiDestination);
        this.tf.write("performTransferInitialization()", 0, "bksDestination = " + this.bksDestination);
        if (!bl) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (AFileObject)enumeration.nextElement();
                n += ((ABaseObject)object).sizeAsInt().intValue();
                this.tf.write("performTransferInitialization()", 1, "Transfer file " + ((ABaseObject)object).fileNameType());
            }
            this.totalFilesToBeTransferred = vector.size();
            this.aTransferProgressWindow = new ATransferProgressWindow(this.owner, "Transfer Progress");
            this.aTransferProgressWindow.init(this.totalFilesToBeTransferred, n);
            this.allFilesBytesTransferred = 0;
            this.lastTransferRateBps = 0L;
        } else {
            this.aTransferProgressWindow = null;
        }
        this.tf.write("performTransferInitialization()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode performTransferTermination() {
        this.tf.write("performTransferTermination()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        if (this.aTransferProgressWindow != null) {
            this.aTransferProgressWindow.closeMe();
            this.aTransferProgressWindow = null;
        }
        if (this.aSource == null && this.isUsingFtp(this.aRepositorySource) && this.aFtpSource.isConnected()) {
            this.aFtpSource.quit();
        }
        if (this.isUsingFtp(this.aRepositoryTarget) && this.aFtpTarget.isConnected()) {
            this.aFtpTarget.quit();
        }
        this.tf.write("performTransferTermination()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode readAndWriteFile(InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.tf.write("readAndWriteFile()", 1, "entry");
        int n = 0;
        boolean bl2 = false;
        int n2 = 65536;
        byte[] byArray = new byte[n2];
        boolean bl3 = false;
        boolean bl4 = false;
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        this.fileBytesTransferred = 0;
        this.lastTransferRateBytes = 0;
        this.transferStartTime = this.lastTransferRateTime = System.currentTimeMillis();
        while (true) {
            if (this.aTransferProgressWindow != null && this.aTransferProgressWindow.isCanceled()) {
                aFtpReturnCode.setProcessCode(1);
                aFtpReturnCode.setMessage("User cancel");
                break;
            }
            n = 0;
            try {
                n = inputStream.read(byArray, 0, n2);
                this.tf.write("readAndWriteFile()", 2, "Bytes read: " + n);
            }
            catch (Exception exception) {
                this.tf.write("readAndWriteFile() receive:  ", 0, exception.toString());
                AStatusWindow.write("Error reading from source file: " + exception.toString());
                aFtpReturnCode.setMessage("Error reading source file<br>" + this.completeSourceFilename);
                aFtpReturnCode.setException(exception);
                aFtpReturnCode.setProcessCode(313);
                break;
            }
            if (n == -1) {
                this.tf.write("readAndWriteFile()", 2, "End of input file received");
                this.updateProgressBars(0, true);
                break;
            }
            try {
                outputStream.write(byArray, 0, n);
            }
            catch (Exception exception) {
                this.tf.write("readAndWriteFile() send: ", 0, exception.toString());
                AStatusWindow.write("Error writing to target file: " + exception.toString());
                aFtpReturnCode.setMessage("Error writing to target file<br>" + (this.isUsingFtp(this.aRepositoryTarget) ? this.tempTargetFilename : this.completeTargetFilename));
                aFtpReturnCode.setException(exception);
                aFtpReturnCode.setProcessCode(314);
                break;
            }
            this.updateProgressBars(n, false);
        }
        this.tf.write("readAndWriteFile()", 1, "exit");
        return aFtpReturnCode;
    }

    public int runTransfer(Vector vector) {
        return this.runTransfer(vector, false);
    }

    public int runTransfer(Vector vector, boolean bl) {
        AFtpReturnCode aFtpReturnCode;
        this.tf.write("runTransfer()", 1, "entry");
        if (!bl) {
            AMainWindow aMainWindow = (AMainWindow)AUtilities.mainWindow;
            int n = aMainWindow.listWindow.ValidateCatalog(this.aRepositoryTarget);
            if (n == 1) {
                return n;
            }
            if (n == 0) {
                n = aMainWindow.listWindow.CreateCatalog(this.aRepositoryTarget);
                this.aRepositoryTarget.catalog().clearCatalog();
                this.aRepositoryTarget.catalog().setCatalogValid(false);
            }
        }
        if ((aFtpReturnCode = this.performTransferInitialization(vector, bl)).getProcessCode() == 0) {
            aFtpReturnCode = this.transferLoop(vector);
        }
        aFtpReturnCode = this.performTransferTermination();
        this.tf.write("runTransfer()", 1, "exit");
        return 0;
    }

    public AFtpReturnCode transferLoop(Vector vector) {
        this.tf.write("transferLoop()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        long l = System.currentTimeMillis();
        AFileObject aFileObject = null;
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (this.aTransferProgressWindow != null && this.aTransferProgressWindow.isCanceled()) {
                this.tf.write("transferLoop()", 0, "User cancel detected");
                aFtpReturnCode.setProcessCode(1);
                aFtpReturnCode.setMessage("User cancel");
                break;
            }
            try {
                this.originalThisFile = (AFileObject)enumeration.nextElement();
                aFileObject = (AFileObject)this.originalThisFile.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            int n2 = this.allFilesBytesTransferred;
            ++n;
            int n3 = 0;
            while (true) {
                this.tf.write("transferLoop()", 1, "Call transferObject().  File " + String.valueOf(n) + " Attempt " + String.valueOf(++n3));
                aFtpReturnCode = this.transferObject(aFileObject, n);
                if (aFtpReturnCode.getProcessCode() != 2) break;
                this.allFilesBytesTransferred = n2;
                if (n3 <= 2) continue;
                int n4 = this.queryUserContinue("A transfer has failed three times");
                switch (n4) {
                    case 0: {
                        aFtpReturnCode.setProcessCode(0);
                        break;
                    }
                    case 2: {
                        n3 = 0;
                        break;
                    }
                    default: {
                        aFtpReturnCode.setProcessCode(1);
                    }
                }
                if (aFtpReturnCode.getProcessCode() != 2) break;
            }
            if (aFtpReturnCode.getProcessCode() == 0) continue;
            this.tf.write("transferLoop()", 1, "transfer ended with process code " + String.valueOf(aFtpReturnCode.getProcessCode()));
            this.setTransferStopped(true);
            break;
        }
        this.tf.write("transferLoop()", 1, "Elapsed time: " + String.valueOf(System.currentTimeMillis() - l));
        this.tf.write("transferLoop()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode transferObject(AFileObject aFileObject, int n) {
        int n2;
        int n3;
        int n4;
        Object object;
        Object object2;
        this.tf.write("transferObject()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        AFtpReturnCode aFtpReturnCode2 = new AFtpReturnCode();
        boolean bl = false;
        this.is = null;
        this.os = null;
        if (aFileObject.hostFileType().equals("BKSHELF")) {
            aFtpReturnCode = this.updateBookshelf(aFileObject);
            if (aFtpReturnCode.getProcessCode() == 0) {
                if (aFileObject.sizeAsInt() == 0) {
                    object2 = new Float(new File(aFileObject.directName()).length());
                    aFileObject.setSize((Float)object2);
                    this.originalThisFile.setSize((Float)object2);
                }
                aFtpReturnCode = this.openSourceFileLocal(aFileObject);
            }
        } else if (this.aSource == null) {
            if (!this.isUsingFtp(this.aRepositorySource)) {
                if (aFileObject.sizeAsInt() == 0) {
                    object2 = new Float(new File(aFileObject.nameInRepository()).length());
                    aFileObject.setSize((Float)object2);
                    this.originalThisFile.setSize((Float)object2);
                }
                aFtpReturnCode = this.openSourceFileLocal(aFileObject);
            } else if (this.aRepositoryTarget.hostType() == 1 && aFileObject.sizeAsInt() == 0) {
                AStatusWindow.write("#Downloading " + aFileObject.nameInRepository() + " to get its size.");
                AMainWindow.UpdateStatusInfo("Downloading " + aFileObject.fileNameType());
                object2 = AUtilities.tempDirectory() + File.separator + aFileObject.fileNameType();
                this.aFtpSource.binary();
                aFtpReturnCode = this.aFtpSource.get((String)object2, aFileObject.nameInRepository(), 2);
                AMainWindow.UpdateStatusInfo(" ");
                if (aFtpReturnCode.getProcessCode() == 0) {
                    aFileObject.setUseLocalSource(true);
                    aFileObject.setDirectName((String)object2);
                    object = new Float(new File((String)object2).length());
                    aFileObject.setSize((Float)object);
                    this.originalThisFile.setSize((Float)object);
                    if (this.aTransferProgressWindow != null) {
                        this.aTransferProgressWindow.updateTotalBytes(((Float)object).intValue());
                    }
                    aFtpReturnCode = this.openSourceFileLocal(aFileObject);
                }
            } else {
                aFtpReturnCode = this.openSourceFileFTP(aFileObject);
            }
        } else if (!this.aSource.usingInternet()) {
            aFtpReturnCode = this.openSourceFileLocal(aFileObject);
        } else if (this.aRepositoryTarget.hostType() == 1 && aFileObject.sizeAsInt() == 0) {
            block102: {
                AStatusWindow.write("Downloading " + aFileObject.fileNameType() + " to get its size.");
                AMainWindow.UpdateStatusInfo("Downloading " + aFileObject.fileNameType());
                this.completeSourceFilename = aFileObject.directName().toLowerCase();
                try {
                    this.url = new URL(this.urlPath + this.completeSourceFilename);
                    this.is = this.url.openStream();
                    this.completeSourceFilename = this.url.toString();
                }
                catch (Exception exception) {
                    this.tf.write("transferObject()", 0, exception.toString());
                    aFtpReturnCode.setException(exception);
                    aFtpReturnCode.setMessage("Error attempting to open source file:<br>" + this.completeSourceFilename + HTML_BREAK + HTML_BREAK);
                    String string = exception.getClass().getName();
                    if (string.equals("java.io.FileNotFoundException")) {
                        aFtpReturnCode.setProcessCode(303);
                        aFtpReturnCode.setMessage(aFtpReturnCode.getMessage() + "This file is no longer available.");
                    }
                    if (string.equals("java.net.MalformedURLException")) {
                        aFtpReturnCode.setProcessCode(302);
                        aFtpReturnCode.setMessage(aFtpReturnCode.getMessage() + "This file is no longer available.");
                    }
                    if (!string.equals("java.net.UnknownHostException")) break block102;
                    aFtpReturnCode.setProcessCode(310);
                    aFtpReturnCode.setMessage(aFtpReturnCode.getMessage() + "No path found to host.  Use \"Settings->Proxy\" " + "to verify your Proxy definitions");
                }
            }
            if (aFtpReturnCode.getProcessCode() == 0) {
                object = AUtilities.tempDirectory() + File.separator + aFileObject.fileNameType();
                try {
                    object2 = new File((String)object);
                    this.os = new FileOutputStream((File)object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n4 = 0;
                n3 = 0;
                n2 = 65536;
                byte[] byArray = new byte[n2];
                while (true) {
                    if (this.aTransferProgressWindow != null && this.aTransferProgressWindow.isCanceled()) {
                        aFtpReturnCode.setProcessCode(1);
                        aFtpReturnCode.setMessage("User cancel");
                        break;
                    }
                    n4 = 0;
                    try {
                        n4 = this.is.read(byArray, 0, n2);
                        this.tf.write("transferObject()", 2, "Bytes read: " + n4);
                        if (n4 == -1) {
                            this.tf.write("readAndWriteFile()", 2, "End of input file received");
                            break;
                        }
                        this.os.write(byArray, 0, n4);
                        AMainWindow.UpdateStatusInfo("Downloading " + aFileObject.fileNameType() + " ... " + (n3 += n4) + " bytes");
                    }
                    catch (Exception exception) {
                        this.tf.write("transferObject()", 0, exception.toString());
                        AStatusWindow.write("Error during transfer: " + exception.toString());
                        aFtpReturnCode.setMessage("Error transferring<br>" + this.completeSourceFilename);
                        aFtpReturnCode.setException(exception);
                        aFtpReturnCode.setProcessCode(313);
                        break;
                    }
                }
                try {
                    ((HttpURLConnection)this.url.openConnection()).disconnect();
                    this.os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                aFileObject.setUseLocalSource(true);
                aFileObject.setDirectName((String)object);
                Float f = new Float(new File((String)object).length());
                aFileObject.setSize(f);
                this.originalThisFile.setSize(f);
                if (this.aTransferProgressWindow != null) {
                    this.aTransferProgressWindow.updateTotalBytes(f.intValue());
                }
                aFtpReturnCode = this.openSourceFileLocal(aFileObject);
            }
            AMainWindow.UpdateStatusInfo(" ");
        } else {
            aFtpReturnCode = this.openSourceFileInternet(aFileObject);
        }
        if (aFtpReturnCode.getProcessCode() != 0) {
            object2 = "";
            object2 = aFtpReturnCode.getMessage() + HTML_PARAGRAPH;
            object = aFtpReturnCode.getServerResponse().elements();
            while (object.hasMoreElements()) {
                object2 = (String)object2 + (String)object.nextElement() + HTML_BREAK;
            }
            Exception exception = aFtpReturnCode.getException();
            if (exception != null) {
                object2 = (String)object2 + exception.toString();
            }
            n3 = this.queryUserContinue((String)object2);
            aFtpReturnCode.setProcessCode(n3);
            return aFtpReturnCode;
        }
        if (this.isUsingFtp(this.aRepositoryTarget)) {
            if (this.aRepositoryTarget.hostType() == 1) {
                aFtpReturnCode = this.openTargetFileOS390(aFileObject);
            } else if (this.aRepositoryTarget.hostType() == 3) {
                aFtpReturnCode = this.openTargetFileOS390OE(aFileObject);
            } else if (this.aRepositoryTarget.hostType() == 4) {
                aFtpReturnCode = this.openTargetFileUnix(aFileObject);
            }
            if (aFtpReturnCode.getCommandCode() == 0 && (aFtpReturnCode2 = this.aFtpTarget.verifyConnection(true)).getCommandCode() == 2) {
                aFtpReturnCode.setProcessCode(2);
                return aFtpReturnCode;
            }
            if (aFtpReturnCode.getCommandCode() != 2) {
                object2 = "";
                object2 = aFtpReturnCode.getMessage() + HTML_PARAGRAPH;
                object = aFtpReturnCode.getServerResponse().elements();
                while (object.hasMoreElements()) {
                    object2 = (String)object2 + (String)object.nextElement() + HTML_BREAK;
                }
                Exception exception = aFtpReturnCode.getException();
                if (exception != null) {
                    object2 = (String)object2 + exception.toString();
                }
                n3 = this.queryUserContinue((String)object2);
                aFtpReturnCode.setProcessCode(n3);
                return aFtpReturnCode;
            }
        } else {
            aFtpReturnCode = this.openTargetFileLocal(aFileObject);
            if (aFtpReturnCode.getProcessCode() != 0) {
                object2 = "";
                object2 = aFtpReturnCode.getMessage() + HTML_PARAGRAPH;
                object = aFtpReturnCode.getException();
                if (object != null) {
                    object2 = (String)object2 + ((Throwable)object).toString();
                }
                n4 = this.queryUserContinue((String)object2);
                aFtpReturnCode.setProcessCode(n4);
                return aFtpReturnCode;
            }
        }
        if (this.aTransferProgressWindow != null) {
            this.aTransferProgressWindow.setNewFile(n, this.completeSourceFilename, this.completeTargetFilename, aFileObject.sizeAsInt());
        }
        aFtpReturnCode = this.readAndWriteFile(this.is, this.os, aFileObject.pcFileType() == "BKS");
        this.tf.write("transferObject()", 1, "readAndWriteFile() process code = " + aFtpReturnCode.getProcessCode());
        try {
            this.os.close();
        }
        catch (Exception exception) {
            this.tf.write("transferObject()", 0, "Closing target datastream: " + exception.toString());
        }
        if (aFtpReturnCode.getProcessCode() == 0) {
            this.tf.write("transferObject()", 2, "All bytes were successfully transferred");
            this.closeSourceFile(aFileObject);
            if (this.isUsingFtp(this.aRepositoryTarget)) {
                aFtpReturnCode = this.aFtpTarget.closeTargetFile(this.tempTargetFilename, this.completeTargetFilename);
                if (aFtpReturnCode.getCommandCode() == 2) {
                    if (this.aRepositoryTarget.hostType() == 3 || this.aRepositoryTarget.hostType() == 4) {
                        if (aFileObject.hostFileType().equals("BKSHELF")) {
                            this.aFtpTarget.quote("SITE CHMOD 666 " + this.completeTargetFilename);
                        } else {
                            this.aFtpTarget.quote("SITE CHMOD 644 " + this.completeTargetFilename);
                        }
                    }
                } else {
                    if (aFtpReturnCode.getCommandCode() != 0) {
                        this.aFtpTarget.dele(this.tempTargetFilename);
                        object2 = "";
                        object2 = aFtpReturnCode.getMessage() + HTML_PARAGRAPH;
                        object = aFtpReturnCode.getServerResponse().elements();
                        while (object.hasMoreElements()) {
                            object2 = (String)object2 + (String)object.nextElement() + HTML_BREAK;
                        }
                        Exception exception = aFtpReturnCode.getException();
                        if (exception != null) {
                            object2 = (String)object2 + exception.toString();
                        }
                        n3 = this.queryUserContinue((String)object2);
                        aFtpReturnCode.setProcessCode(n3);
                        return aFtpReturnCode;
                    }
                    AStatusWindow.write("**ERROR**  Apparent lost connection with host.");
                    AStatusWindow.write("           Attempting to restore connection.");
                    aFtpReturnCode2 = this.aFtpTarget.verifyConnection(true);
                    if (aFtpReturnCode2.getCommandCode() == 2) {
                        aFtpReturnCode.setProcessCode(2);
                    } else {
                        object2 = "";
                        object2 = aFtpReturnCode.getMessage() + HTML_PARAGRAPH;
                        object = aFtpReturnCode.getException();
                        if (object != null) {
                            object2 = (String)object2 + ((Throwable)object).toString();
                        }
                        n4 = this.queryUserContinue((String)object2);
                        aFtpReturnCode.setProcessCode(n4);
                        return aFtpReturnCode;
                    }
                }
            }
            aFileObject.setNameInRepository(this.completeTargetFilename);
            aFileObject.setInstallDate(new Date());
            if (aFileObject.hostFileType().equals("BKSHELF")) {
                aFileObject.groupObjectPtr().setInstallDate(new Date());
            }
            this.filesTransferred.addElement(aFileObject);
        } else if (aFtpReturnCode.getProcessCode() == 1) {
            this.tf.write("transferObject()", 0, "User canceled.");
            this.closeSourceFile(aFileObject);
            if (this.isUsingFtp(this.aRepositoryTarget)) {
                this.tf.write("transferObject()", 0, "Attempt to close and delete target file " + this.tempTargetFilename);
                aFtpReturnCode2 = this.aFtpTarget.closeTargetFile(this.tempTargetFilename, "");
                if (aFtpReturnCode2.getCommandCode() == 2) {
                    this.aFtpTarget.dele(this.tempTargetFilename);
                }
            } else {
                this.tf.write("transferObject()", 0, "Attempt to delete target file " + this.completeTargetFilename);
                if (new File(this.completeTargetFilename).delete()) {
                    this.tf.write("transferObject()", 0, "Target file deleted.");
                } else {
                    this.tf.write("transferObject()", 0, "Delete failed.");
                }
            }
        } else if (aFtpReturnCode.getProcessCode() == 313) {
            this.tf.write("transferObject()", 0, "Transfer failed due to Receive error.");
            if (this.isUsingFtp(this.aRepositoryTarget)) {
                aFtpReturnCode2 = this.aFtpTarget.closeTargetFile(this.tempTargetFilename, "");
                if (aFtpReturnCode2.getCommandCode() == 2) {
                    this.aFtpTarget.dele(this.tempTargetFilename);
                }
            } else {
                try {
                    this.os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new File(this.completeTargetFilename).delete();
            }
            int n5 = aFileObject.hostFileType().equals("BKSHELF") ? 0 : (this.aSource == null ? (!this.isUsingFtp(this.aRepositorySource) ? 0 : 1) : (!this.aSource.usingInternet() ? 0 : 2));
            if (n5 == 0) {
                object = "";
                object = aFtpReturnCode.getMessage() + HTML_PARAGRAPH;
                Exception exception = aFtpReturnCode.getException();
                if (exception != null) {
                    object = (String)object + exception.toString();
                }
                n3 = this.queryUserContinue((String)object);
                aFtpReturnCode.setProcessCode(n3);
            } else if (n5 == 1) {
                aFtpReturnCode2 = this.closeSourceFile(aFileObject);
                if (aFtpReturnCode2.getCommandCode() != 0) {
                    object = "";
                    object = aFtpReturnCode.getMessage() + HTML_PARAGRAPH;
                    Enumeration enumeration = aFtpReturnCode2.getServerResponse().elements();
                    while (enumeration.hasMoreElements()) {
                        object = object + (String)enumeration.nextElement() + HTML_BREAK;
                    }
                    Exception exception = aFtpReturnCode.getException();
                    if (exception != null) {
                        object = object + exception.toString();
                    }
                    n2 = this.queryUserContinue((String)object);
                    aFtpReturnCode.setProcessCode(n2);
                    aFtpReturnCode.setServerResponse(aFtpReturnCode2.getServerResponse());
                    aFtpReturnCode.setCommandCode(aFtpReturnCode2.getCommandCode());
                } else {
                    aFtpReturnCode2 = this.aFtpTarget.verifyConnection(true);
                    if (aFtpReturnCode2.getCommandCode() == 2) {
                        aFtpReturnCode.setProcessCode(2);
                    } else {
                        aFtpReturnCode.setProcessCode(1);
                    }
                }
            } else {
                aFtpReturnCode.setProcessCode(2);
            }
        } else if (aFtpReturnCode.getProcessCode() == 314) {
            this.tf.write("transferObject()", 0, "transfer failed due to Send error");
            this.closeSourceFile(aFileObject);
            if (this.isUsingFtp(this.aRepositoryTarget)) {
                this.tf.write("transferObject()", 0, "Attempt to close and delete target file " + this.tempTargetFilename);
                aFtpReturnCode2 = this.aFtpTarget.closeTargetFile(this.tempTargetFilename, "");
                if (aFtpReturnCode2.getCommandCode() != 0) {
                    this.aFtpTarget.dele(this.tempTargetFilename);
                    object2 = "";
                    object2 = aFtpReturnCode.getMessage() + HTML_PARAGRAPH;
                    object = aFtpReturnCode2.getServerResponse().elements();
                    while (object.hasMoreElements()) {
                        object2 = (String)object2 + (String)object.nextElement() + HTML_BREAK;
                    }
                    Exception exception = aFtpReturnCode.getException();
                    if (exception != null) {
                        object2 = (String)object2 + exception.toString();
                    }
                    n3 = this.queryUserContinue((String)object2);
                    aFtpReturnCode.setProcessCode(n3);
                    aFtpReturnCode.setServerResponse(aFtpReturnCode2.getServerResponse());
                    aFtpReturnCode.setCommandCode(aFtpReturnCode2.getCommandCode());
                } else {
                    aFtpReturnCode2 = this.aFtpTarget.verifyConnection(true);
                    if (aFtpReturnCode2.getCommandCode() == 2) {
                        aFtpReturnCode.setProcessCode(2);
                    } else {
                        aFtpReturnCode.setProcessCode(1);
                    }
                }
            } else {
                this.tf.write("transferObject()", 0, "Attempt to delete target file " + this.completeTargetFilename);
                if (new File(this.completeTargetFilename).delete()) {
                    this.tf.write("transferObject()", 0, "Target file deleted.");
                } else {
                    this.tf.write("transferObject()", 0, "Delete failed.");
                }
            }
        }
        this.tf.write("transferObject()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode updateBookshelf(AFileObject aFileObject) {
        Object object;
        PrintStream printStream;
        this.tf.write("updateBookshelf()", 1, "entry");
        AGroupObject aGroupObject = aFileObject.groupObjectPtr();
        AFileObjectsSet aFileObjectsSet = this.aRepositoryTarget.catalog().fileObjectsSet();
        AFtpReturnCode aFtpReturnCode = null;
        aFtpReturnCode = this.aSource == null ? (this.aRepositorySource.hostType() == 5 ? this.openSourceFileLocal(aFileObject) : this.openSourceFileFTP(aFileObject)) : (this.aSource.usingInternet() ? this.openSourceFileInternet(aFileObject) : this.openSourceFileLocal(aFileObject));
        if (aFtpReturnCode.getProcessCode() != 0) {
            this.tf.write("updateBookshelf()", 0, "exit open source error");
            return aFtpReturnCode;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
        String string = this.aRepositoryTarget.hostType() == 1 ? this.aRepositoryTarget.cacheDirectory() + this.bksDestination + DOT + aFileObject.fileName().toUpperCase() + DOT + "BKSHELF" : this.aRepositoryTarget.cacheDirectory() + aFileObject.fileNameType();
        this.tf.write("updateBookshelf()", 1, "shelfNameInCache = " + string);
        try {
            printStream = new PrintStream(new FileOutputStream(new File(string)));
        }
        catch (Exception exception) {
            this.tf.write("updateBookshelf()", 0, exception.toString());
            aFtpReturnCode.setException(exception);
            aFtpReturnCode.setMessage("Error attempting to open output file:<br>" + this.completeTargetFilename);
            aFtpReturnCode.setProcessCode(404);
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.tf.write("updateBookshelf()", 0, "exit open target error");
            return aFtpReturnCode;
        }
        boolean bl = true;
        while (bl) {
            AFileObject aFileObject2;
            Vector vector;
            String string2;
            String string3;
            try {
                string3 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                this.tf.write("updateBookshelf()", 0, exception.toString());
                aFtpReturnCode.setException(exception);
                aFtpReturnCode.setMessage("Error reading source file:\n\n" + aFileObject.fileNameType());
                aFtpReturnCode.setProcessCode(405);
                try {
                    bufferedReader.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    printStream.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                this.tf.write("updateBookshelf()", 0, "exit read source error");
                return aFtpReturnCode;
            }
            if (string3 == null) break;
            if ((string3 = string3.trim()).startsWith("BKSMDSN=") || string3.startsWith("BKSIMDSN=") || string3.startsWith("BKMDSN=")) continue;
            if (string3.startsWith("BKSTITLE=")) {
                string3 = "BKSTITLE=" + aGroupObject.title().trim();
            }
            printStream.println(string3);
            if (this.aRepositoryTarget.hostType() != 1) continue;
            if (string3.startsWith("BKSHELF=")) {
                object = this.bksDestination + DOT + aGroupObject.shelfFileName() + DOT + "BKSHELF";
                object = ((String)object).toUpperCase();
                aGroupObject.setShelfDsn((String)object);
                printStream.println("BKSMDSN=" + (String)object);
                continue;
            }
            if (string3.startsWith("BKSINDEX=")) {
                if (aGroupObject.indexFileName() != "") {
                    string2 = aGroupObject.indexFileName() + DOT + "bki";
                    vector = aFileObjectsSet.getObjects(string2 = string2.toUpperCase());
                    if (vector != null) {
                        aFileObject2 = (AFileObject)vector.firstElement();
                        object = aFileObject2.nameInRepository().replace('\'', ' ').trim();
                    } else {
                        object = this.bkiDestination + DOT + string2 + "NDEX";
                    }
                    object = ((String)object).toUpperCase();
                } else {
                    object = "";
                }
                aGroupObject.setIndexDsn((String)object);
                printStream.println("BKSIMDSN=" + (String)object);
                continue;
            }
            if (!string3.startsWith("BKNAME=")) continue;
            string2 = string3.substring(7).trim() + DOT + "boo";
            vector = aFileObjectsSet.getObjects(string2 = string2.toUpperCase());
            if (vector != null) {
                aFileObject2 = (AFileObject)vector.firstElement();
                object = aFileObject2.nameInRepository().replace('\'', ' ').trim();
            } else {
                object = this.booDestination + DOT + string2 + "K";
            }
            object = ((String)object).toUpperCase();
            printStream.println("BKMDSN=" + (String)object);
        }
        this.closeSourceFile(aFileObject);
        try {
            printStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new File(string);
        aFileObject.setSize(new Float(((File)object).length()));
        aFileObject.setUseLocalSource(true);
        aFileObject.setDirectName(string);
        this.tf.write("updateBookshelf()", 1, "exit");
        return aFtpReturnCode;
    }

    public static AFtpReturnCode updateBookshelf(AFileObject aFileObject, AFileObjectsSet aFileObjectsSet, ARepository aRepository, String string) {
        PrintStream printStream;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ATraceFile aTraceFile = new ATraceFile(aRepository.catalog());
        aTraceFile.write("updateBookshelf()", 1, "entry:" + string);
        AGroupObject aGroupObject = aFileObject.groupObjectPtr();
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        StringBuffer stringBuffer = null;
        try {
            object4 = new FileReader(string);
            object3 = new BufferedReader((Reader)object4);
            object2 = new Long(new File(string).length());
            aTraceFile.write("updateBookshelf() overload", 1, "shelf size:" + String.valueOf(object2));
            object = new char[((Long)object2).intValue()];
            if (((BufferedReader)object3).read((char[])object, 0, ((Long)object2).intValue()) == -1) {
                aTraceFile.write("updateBookshelf overload", 0, "Error reading shelf : " + string);
                aFtpReturnCode.setMessage("Error attempting to open input file:<br>" + string);
                aFtpReturnCode.setProcessCode(404);
                return aFtpReturnCode;
            }
            ((InputStreamReader)object4).close();
            stringBuffer = new StringBuffer(new String((char[])object));
        }
        catch (IOException iOException) {
            aTraceFile.write("updateBookshelf() overload", 0, string + " does not exist. " + iOException);
            aFtpReturnCode.setException(iOException);
            aFtpReturnCode.setMessage("Error attempting to open output file:<br>" + string);
            aFtpReturnCode.setProcessCode(404);
            return aFtpReturnCode;
        }
        try {
            printStream = new PrintStream(new FileOutputStream(new File(string)));
        }
        catch (Exception exception) {
            aTraceFile.write("updateBookshelf()", 0, exception.toString());
            aFtpReturnCode.setException(exception);
            aFtpReturnCode.setMessage("Error attempting to open output file:<br>" + string);
            aFtpReturnCode.setProcessCode(404);
            aTraceFile.write("updateBookshelf() overload", 0, "exit open target error");
            return aFtpReturnCode;
        }
        object4 = new StringTokenizer(stringBuffer.toString(), AUtilities.LINE_SEPARATOR);
        object3 = "";
        object2 = "";
        object = "";
        String string2 = "";
        while (((StringTokenizer)object4).hasMoreTokens()) {
            String string3 = ((StringTokenizer)object4).nextToken().trim();
            if (string3 == null) break;
            if ((string3 = string3.trim()).startsWith("BKSMDSN=") || string3.startsWith("BKSIMDSN=") || string3.startsWith("BKMDSN=")) {
                if (!string3.startsWith("BKMDSN")) continue;
                string2 = "";
                object2 = string3.substring(string3.indexOf("=") + 1).trim();
                string2 = ATransferProcess.getProcessedDsn(aGroupObject, aTraceFile, aFileObjectsSet, aRepository, (String)object2, "BOO", (String)object);
                aTraceFile.write("updateBookshelf() overload", 1, "dsn:" + string2);
                printStream.println("BKMDSN=" + string2);
                continue;
            }
            if (string3.startsWith("BKSTITLE=")) {
                string3 = "BKSTITLE=" + aGroupObject.title().trim();
            }
            printStream.println(string3);
            if (string3.startsWith("BKSHELF=")) {
                object2 = aGroupObject.shelfDsn();
                object = aGroupObject.shelfFileName() + DOT + "bkshelf";
                string2 = ATransferProcess.getProcessedDsn(aGroupObject, aTraceFile, aFileObjectsSet, aRepository, (String)object2, "BKS", (String)object);
                aGroupObject.setShelfDsn(string2);
                printStream.println("BKSMDSN=" + string2);
                continue;
            }
            if (string3.startsWith("BKSINDEX=")) {
                object2 = aGroupObject.indexDsn();
                object = aGroupObject.indexFileName() + DOT + "bkindex";
                object = ((String)object).toUpperCase();
                string2 = ATransferProcess.getProcessedDsn(aGroupObject, aTraceFile, aFileObjectsSet, aRepository, (String)object2, "BKI", (String)object);
                aGroupObject.setIndexDsn(string2);
                printStream.println("BKSIMDSN=" + string2);
                continue;
            }
            if (!string3.startsWith("BKNAME=")) continue;
            object = string3.substring(7).trim() + DOT + "book";
        }
        try {
            printStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = new File(string);
        aFileObject.setSize(new Float(file.length()));
        aFileObject.setUseLocalSource(true);
        aFileObject.setDirectName(string);
        aTraceFile.write("updateBookshelf() overload", 1, "exit:" + string);
        return aFtpReturnCode;
    }

    public static String getProcessedDsn(AGroupObject aGroupObject, ATraceFile aTraceFile, AFileObjectsSet aFileObjectsSet, ARepository aRepository, String string, String string2, String string3) {
        String string4 = "";
        String string5 = "";
        AFileObjectsSet aFileObjectsSet2 = aRepository.catalog().fileObjectsSet();
        string3 = string3.toUpperCase();
        aTraceFile.write("getProcessedDsn()", 1, "Entry refDsn:" + string + ", theKey:" + string3);
        String string6 = string3.substring(0, string3.indexOf(DOT)) + DOT + string2;
        Vector vector = aFileObjectsSet.getObjects(string6);
        aTraceFile.write("getProcessedDsn()", 1, "tempKey:" + string6);
        aTraceFile.write("getProcessedDsn()", 1, "aTempFileSet.size():" + aFileObjectsSet.size());
        aTraceFile.write("getProcessedDsn()", 1, "aTempFileSet keyfield:" + ((AFileObject)aFileObjectsSet.asVector().firstElement()).keyField());
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                AFileObject aFileObject = (AFileObject)enumeration.nextElement();
                if (!aGroupObject.fileObjectsSet().containsKey(aFileObject.nameInRepository()) && !aGroupObject.missingFileObjectsSet().containsKey(aFileObject.nameInRepository()) && !aGroupObject.fileObjectPtr().nameInRepository().equals(aFileObject.nameInRepository())) continue;
                string4 = AUtilities.strip(aFileObject.nameInRepository(), '\'');
            }
        } else if (string2.equals("BOO")) {
            Enumeration enumeration = aRepository.fileTypesList().getObject(1).hlqsAsVector().elements();
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                String string8 = AUtilities.strip(string7, '\'') + DOT + string3;
                aTraceFile.write("getProcessedDsn()", 1, "theKey:" + string8);
                Vector vector2 = aFileObjectsSet2.getObjects(SQUOTE + string8 + SQUOTE);
                if (vector2 == null) continue;
                AFileObject aFileObject = (AFileObject)vector2.firstElement();
                string4 = aFileObject.nameInRepository().replace('\'', ' ').trim();
                aTraceFile.write("getProcessedDsn()", 1, "Test1:" + string4);
                break;
            }
        } else {
            if (string2.equals("BKI")) {
                string5 = AUtilities.strip(aRepository.fileTypesList().getObject(5).hlq(), '\'');
            } else if (string2.equals("BKS")) {
                string5 = AUtilities.strip(aRepository.fileTypesList().getObject(2).hlq(), '\'');
            }
            string5 = string5 + DOT + string3;
            Vector vector3 = aFileObjectsSet2.getObjects(SQUOTE + string5 + SQUOTE);
            if (vector3 != null) {
                AFileObject aFileObject = (AFileObject)vector3.firstElement();
                string4 = aFileObject.nameInRepository().replace('\'', ' ').trim();
            }
        }
        aTraceFile.write("getProcessedDsn()", 1, "Exit refDsn:" + string + ", theKey:" + string3 + ", dsn:" + string4);
        return string4.toUpperCase();
    }

    private void updateProgressBars(int n, boolean bl) {
        this.tf.write("updateProgressBars()", 2, "entry");
        this.fileBytesTransferred += n;
        this.allFilesBytesTransferred += n;
        this.tf.write("updateProgressBars()", 2, this.fileBytesTransferred + " bytes sent");
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTransferRateTime;
        if (l2 == 0L) {
            l2 = 1L;
        }
        if (l2 > 1000L || bl) {
            this.lastTransferRateBps = (long)this.fileBytesTransferred / (l == this.transferStartTime ? 1L : l - this.transferStartTime);
            this.lastTransferRateBytes = this.fileBytesTransferred;
            this.lastTransferRateTime = l;
            if (this.aTransferProgressWindow != null) {
                this.aTransferProgressWindow.updateProgress(this.fileBytesTransferred, this.allFilesBytesTransferred, this.lastTransferRateBps);
            }
        }
        this.tf.write("updateProgressBars()", 2, "exit");
    }

    public ATransferProcess(JFrame jFrame, Object object, ARepository aRepository, ARepository aRepository2) {
        this.tf.write("ATransferProcess()", 1, "ARepository to ARepository, entry");
        this.owner = jFrame;
        this.aSource = null;
        this.aRepositorySource = aRepository;
        this.aRepositoryTarget = aRepository2;
        this.filesTransferred = new Vector();
        this.runTransfer((Vector)object);
        this.tf.write("ATransferProcess()", 1, "exit");
    }

    public ATransferProcess(JFrame jFrame, Object object, ASource aSource, ARepository aRepository) {
        this.tf.write("ATransferProcess()", 1, "ASource to ARepository, entry");
        this.owner = jFrame;
        this.aSource = aSource;
        this.aRepositorySource = null;
        this.aRepositoryTarget = aRepository;
        this.filesTransferred = new Vector();
        this.runTransfer((Vector)object);
        this.tf.write("ATransferProcess()", 1, "exit");
    }

    public ATransferProcess(ARepository aRepository) {
        this.aSource = null;
        this.aRepositorySource = aRepository;
        this.aRepositoryTarget = aRepository;
        this.filesTransferred = new Vector();
    }
}

