/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ASourceWindow
extends ABaseInternalFrame
implements ActionListener {
    private JPopupMenu popup;
    private JMenuBar menuBar1;
    private JMenu fileMenu;
    private JMenu optionsMenu;
    private JMenu compareMenu;
    private JMenu sendToMenu;
    private JMenu editMenu;
    private JMenu helpMenu;
    private JMenuItem item;
    private JMenuItem itemOpen;
    private JMenuItem itemSortCol1;
    private JMenuItem itemSortCol2;
    private JMenuItem itemSortCol3;
    private JMenuItem itemSortCol4;
    private JMenuItem itemSelectAll;
    private JMenuItem itemDeselectAll;
    private JMenuItem itemShowNewUpdated;
    private JMenuItem itemShowAll;
    private JMenuItem itemCut;
    private JMenuItem itemPaste;
    private JMenuItem itemCopy;
    private JMenuItem itemFind;
    private JMenuItem itemFindNext;
    private JMenuItem itemPrint;
    private JMenuItem itemSaveAs;
    private JMenuItem itemEditTitle;
    private JMenuItem itemRefresh;
    private JMenuItem itemClose;
    private JMenuItem itemUserGuide;
    private JMenu subMenu;
    public JMenuItem itemWindow_Source;
    public ADNDTableSource table1;
    private ASourceWindowModel dataModel1;
    private AMainWindow mainWindow;
    private ARepositoryWindow repositoryWindow = null;
    private OurComponentListener compListener;
    private String title;
    public JLabel infoLabel;
    private String drive;
    private ATraceFile tf;
    private AFileObjectsSet softcopyFileNames;
    public ASource aSourceObject;
    private StringBuffer buffer;
    private LineNumberReader lineReader;
    private String aKeyWord = "";
    private String aKeyWordValue = "";
    private APackageObject aPackage = null;
    private AFileObject fileObject = null;
    private AGroupObject groupObject = null;
    private boolean isErrorMessageShown = false;
    private boolean isDescriptorSource = false;
    private Hashtable fileObjectsTable = null;
    private Hashtable groupObjectsTable = null;
    private int shelvesCount = 0;
    public APropertyObject aPropObject = null;
    private boolean showNewUpdated = false;
    private AFindWindow findWindow = null;
    private String searchString = "";
    protected Vector viewContentsVector = new Vector();
    static final String PACKAGE = new String("PACKAGE");
    static final String ELEMENT = new String("ELEMENT");
    static final String PRODUCT = new String("PRODUCT");
    static final String EQUALSTRING = new String("=");
    static final String DOUBLE_QUOTE = new String("\"");
    static final String PKG_NAME = new String("PKG_NAME");
    static final String PKG_NUM = new String("PKG_NUM");
    static final String PKG_TIMESTAMP = new String("PKG_TIMESTAMP");
    static final String PKG_NUM_FILES = new String("PKG_NUM_FILES");
    static final String PKG_NUM_PRODUCTS = new String("PKG_NUM_PRODUCTS");
    static final String PKG_NUM_GROUPS = new String("PKG_NUM_GROUPS");
    static final String PKG_NUM_OF_VOLS = new String("PKG_NUM_OF_VOLS");
    static final String PKG_VOLIDXX = new String("PKG_VOLID");
    static final String PKG_VOLXX_NUM_OF_ELMS = new String("_NUM_OF_ELMS");
    static final String PKG_SAA_DESC_VERSION = new String("PKG_SAA_DESC_VERSION");
    static final String ELM_TYPE = new String("ELM_TYPE");
    static final String ELM_NUM = new String("ELM_NUM");
    static final String ELM_NAME = new String("ELM_NAME");
    static final String ELM_LANG = new String("ELM_LANG");
    static final String ELM_TIMESTAMP = new String("ELM_TIMESTAMP");
    static final String ELM_LOCKED = new String("ELM_LOCKED");
    static final String ELM_OS2DOS_NAME = new String("ELM_OS2DOS_NAME");
    static final String ELM_DIRECT_NAME = new String("ELM_DIRECT_NAME");
    static final String ELM_SIZE = new String("ELM_SIZE");
    static final String ELM_FILENUM = new String("ELM_FILENUM");
    static final String ELM_CHG_STAT = new String("ELM_CHG_STAT");
    static final String ELM_DISPLACED_FILE = new String("ELM_DISPLACED_FILE");
    static final String ELM_BKS_NUM_ASSOC = new String("ELM_BKS_NUM_ASSOC");
    static final String ELM_BKS_LOCKED = new String("ELM_BKS_LOCKED");
    static final String ELM_BKS_CHG_STAT = new String("ELM_BKS_CHG_STAT");
    static final String ELM_BKS_SIZE = new String("ELM_BKS_SIZE");
    static final String ELM_BKS_FILES = new String("ELM_BKS_FILES");
    static final String ELM_UPL_FM = new String("ELM_UPL_FM");
    static final String ELM_UPL_LRECL = new String("ELM_UPL_LRECL");
    static final String ELM_UPL_TYPE = new String("ELM_UPL_TYPE");

    public ASourceWindow(AMainWindow aMainWindow, ASource aSource) {
        super("", true, true, true, true);
        this.mainWindow = aMainWindow;
        this.aSourceObject = aSource;
        this.title = aSource.sourceTitle();
        this.drive = aSource.sourcePath();
        this.tf = new ATraceFile(this);
        if (AMainWindow.userIniFlag) {
            String string = "Source" + new Integer(aSource.index()).toString();
            this.aPropObject = AMainWindow.userProperties.getObject(string);
            if (this.aPropObject == null) {
                this.aPropObject = new APropertyObject();
                this.aPropObject.setTitle("Source - " + aSource.sourceTitle());
                this.aPropObject.setSize(new Dimension(600, 350));
                this.aPropObject.setLocation(new Point(100, 100));
                this.aPropObject.setColumnSequence("0,1,2,3,4,5", 6);
                this.aPropObject.setColumnSort("0 true");
                this.aPropObject.setComparedToRepository("");
            }
        } else {
            this.aPropObject = new APropertyObject();
            this.aPropObject.setTitle("Source - " + aSource.sourceTitle());
            this.aPropObject.setSize(new Dimension(600, 350));
            this.aPropObject.setLocation(new Point(100, 100));
            this.aPropObject.setColumnSequence("0,1,2,3,4,5", 6);
            this.aPropObject.setColumnSort("0 true");
            this.aPropObject.setComparedToRepository("");
        }
        this.setTitle(this.aPropObject.title());
        this.setSize(this.aPropObject.size());
        this.setLocation(this.aPropObject.location());
        this.itemWindow_Source = aMainWindow.windowMenu.add(new JMenuItem(this.getTitle()));
        this.itemWindow_Source.addActionListener(aMainWindow);
        aSource.setSourceWindow(this);
        if (!this.constructRest()) {
            this.dispose();
            aMainWindow.getWindowMenu().remove(this.itemWindow_Source);
            aSource.setSourceWindow(null);
            return;
        }
        try {
            aMainWindow.getDeskTopPane().add(this);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.show();
        }
        catch (Exception exception) {
            this.tf.write("", 0, aSource.sourceTitle() + ", Exception:" + exception.toString());
        }
        this.table1.requestFocus();
        AStatusWindow.write("Source Window added - " + aSource.sourceTitle());
        this.tf.write("Constructor()", 18, "Exit");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tf.write("ASourceWindow actionPerformed() : ", 18, actionEvent.paramString());
        if (actionEvent.getActionCommand().equals("Print")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Printing"){

                public Object construct() {
                    ASourceWindow.this.print();
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Save As")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Save As"){

                public Object construct() {
                    ((ASourceWindow)ASourceWindow.this).mainWindow.listWindow.saveAs(ASourceWindow.this.table1);
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Edit Title")) {
            this.editTitle();
        } else if (actionEvent.getActionCommand().equals("Open")) {
            this.viewContents();
        } else if (actionEvent.getActionCommand().equals("Refresh")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Refresh"){

                public Object construct() {
                    ASourceWindow.this.Refresh();
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.dispose();
        } else if (!(actionEvent.getActionCommand().equals("Cut") || actionEvent.getActionCommand().equals("Paste") || actionEvent.getActionCommand().equals("Copy"))) {
            if (actionEvent.getActionCommand().equals("Find First")) {
                ASwingWorker aSwingWorker = new ASwingWorker("FindFirst"){

                    public Object construct() {
                        ASourceWindow.this.FindFirst();
                        return null;
                    }
                };
            } else if (actionEvent.getActionCommand().equals("Find Next  F3")) {
                this.FindNext();
            } else if (actionEvent.getActionCommand().equals(AMainWindow.messages.getString("SelectAll"))) {
                this.table1.selectAll();
            } else if (actionEvent.getActionCommand().equals(AMainWindow.messages.getString("DeselectAll"))) {
                this.table1.clearSelection();
            } else if (actionEvent.getActionCommand().equals("Show New/Updated  Ctrl+K")) {
                this.showNewUpdated();
            } else if (actionEvent.getActionCommand().equals("Show All")) {
                this.showAll();
            } else if (actionEvent.getActionCommand().equals("User's Guide")) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec("start ebrscl10.boo -t \"12.0\" -s3");
                }
                catch (Exception exception) {
                    this.tf.write("User's Guide", 0, "IOException:" + exception.toString());
                }
            } else {
                final String string = actionEvent.getActionCommand();
                ASwingWorker aSwingWorker = new ASwingWorker("SendTo"){

                    public Object construct() {
                        ASourceWindow.this.sendTo(string);
                        return null;
                    }
                };
            }
        }
    }

    public boolean constructRest() {
        Object object;
        Object object2;
        boolean bl = true;
        this.menuBar1 = new JMenuBar();
        this.menuBar1.getAccessibleContext().setAccessibleName("Menu Bar 1");
        this.fileMenu = this.menuBar1.add(new JMenu("File"));
        this.fileMenu.setMnemonic('F');
        this.itemPrint = this.fileMenu.add(new JMenuItem("Print"));
        this.itemPrint.setMnemonic('P');
        this.itemPrint.addActionListener(this);
        this.itemSaveAs = this.fileMenu.add(new JMenuItem("Save As"));
        this.itemSaveAs.setMnemonic('S');
        this.itemSaveAs.addActionListener(this);
        this.compareMenu = new JMenu("Update Status: Compared To");
        this.compareMenu.setMnemonic('S');
        this.fileMenu.add(this.compareMenu);
        NewMenuListener newMenuListener = new NewMenuListener();
        this.compareMenu.addMenuListener(newMenuListener);
        this.fileMenu.addSeparator();
        this.itemEditTitle = this.fileMenu.add(new JMenuItem("Edit Title"));
        this.itemEditTitle.setMnemonic('E');
        this.itemEditTitle.addActionListener(this);
        this.itemOpen = this.fileMenu.add(new JMenuItem("Open"));
        this.itemOpen.setMnemonic('O');
        this.itemOpen.addActionListener(this);
        this.sendToMenu = new JMenu("Send To");
        this.fileMenu.add(this.sendToMenu);
        this.sendToMenu.addMenuListener(newMenuListener);
        this.fileMenu.addSeparator();
        this.itemRefresh = this.fileMenu.add(new JMenuItem("Refresh"));
        this.itemRefresh.setMnemonic('R');
        this.itemRefresh.addActionListener(this);
        this.itemClose = this.fileMenu.add(new JMenuItem("Close"));
        this.itemClose.setMnemonic('C');
        this.itemClose.addActionListener(this);
        this.editMenu = this.menuBar1.add(new JMenu("Edit"));
        this.editMenu.setMnemonic('E');
        this.itemFind = this.editMenu.add(new JMenuItem("Find First"));
        this.itemFind.setMnemonic('F');
        this.itemFind.addActionListener(this);
        this.itemFindNext = this.editMenu.add(new JMenuItem("Find Next  F3"));
        this.itemFindNext.setMnemonic('N');
        this.itemFindNext.addActionListener(this);
        this.itemFindNext.setEnabled(false);
        this.optionsMenu = this.menuBar1.add(new JMenu(AMainWindow.messages.getString("Options")));
        this.optionsMenu.setMnemonic('P');
        this.itemSelectAll = this.optionsMenu.add(new JMenuItem(AMainWindow.messages.getString("SelectAll")));
        this.itemSelectAll.setMnemonic('E');
        this.itemSelectAll.addActionListener(this);
        this.itemDeselectAll = this.optionsMenu.add(new JMenuItem(AMainWindow.messages.getString("DeselectAll")));
        this.itemDeselectAll.setMnemonic('D');
        this.itemDeselectAll.addActionListener(this);
        this.itemShowNewUpdated = this.optionsMenu.add(new JMenuItem("Show New/Updated  Ctrl+K"));
        this.itemShowNewUpdated.setMnemonic('N');
        this.itemShowNewUpdated.addActionListener(this);
        this.itemShowAll = this.optionsMenu.add(new JMenuItem("Show All"));
        this.itemShowAll.setMnemonic('A');
        this.itemShowAll.addActionListener(this);
        this.helpMenu = this.menuBar1.add(new JMenu("Help"));
        this.helpMenu.setMnemonic('H');
        this.itemUserGuide = this.helpMenu.add(new JMenuItem("User's Guide"));
        this.itemUserGuide.setMnemonic('U');
        this.itemUserGuide.addActionListener(this);
        this.getContentPane().add((Component)this.menuBar1, "North");
        String[] stringArray = new String[]{"Title", "Status", "Filename", "Date", "Size", "Files"};
        this.dataModel1 = new ASourceWindowModel(this.mainWindow, stringArray);
        this.table1 = new ADNDTableSource(this.dataModel1, this.aSourceObject);
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ASwingWorker aSwingWorker = new ASwingWorker(this, "View contents"){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object construct() {
                            ASourceWindow.access$500(6.access$400(this.this$1));
                            return null;
                        }
                    };
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 114) {
                    ASourceWindow.this.FindNext();
                } else if (keyEvent.getKeyCode() == 75 & (keyEvent.getModifiers() & 2) == 2) {
                    ASourceWindow.this.showNewUpdated();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            static /* synthetic */ ASourceWindow access$400(6 var0) {
                return var0.ASourceWindow.this;
            }
        };
        this.table1.addKeyListener(keyListener);
        this.table1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && ASourceWindow.this.table1.rowAtPoint(mouseEvent.getPoint()) != -1) {
                    ASwingWorker aSwingWorker = new ASwingWorker(this, "View contents"){
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object construct() {
                            ASourceWindow.access$500(8.access$800(this.this$1));
                            return null;
                        }
                    };
                }
            }

            static /* synthetic */ ASourceWindow access$800(8 var0) {
                return var0.ASourceWindow.this;
            }
        });
        JTableHeader jTableHeader = this.table1.getTableHeader();
        jTableHeader.addMouseListener(new ASourceWindowModel.ColumnListener(this.dataModel1, this.table1));
        JScrollPane jScrollPane = new JScrollPane();
        this.table1.setAutoResizeMode(0);
        jScrollPane.getViewport().add(this.table1);
        this.compListener = new OurComponentListener(this.table1, jScrollPane);
        this.addComponentListener(this.compListener);
        this.compListener.resizeTableColumns(this.getSize().getWidth());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.infoLabel = new JLabel("Total no. of objects : ");
        this.infoLabel.setHorizontalAlignment(2);
        jPanel.add(this.infoLabel);
        ListSelectionModel listSelectionModel = this.table1.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ASharedListSelectionHandler(this.table1, this.dataModel1, this.infoLabel));
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        MyInternalFrameListener myInternalFrameListener = new MyInternalFrameListener();
        this.addInternalFrameListener(myInternalFrameListener);
        this.popup = new JPopupMenu();
        this.item = new JMenuItem("Open");
        this.item.addActionListener(this);
        this.popup.add(this.item);
        this.item = new JMenuItem("Edit Title");
        this.item.addActionListener(this);
        this.popup.add(this.item);
        this.subMenu = new JMenu("Send To");
        PopupListener popupListener = new PopupListener(this);
        this.table1.addMouseListener(popupListener);
        File file = null;
        if (this.aSourceObject.usingInternet()) {
            int n = this.aSourceObject.sourcePath().indexOf(32);
            object2 = this.aSourceObject.sourcePath();
            if (n != -1) {
                object2 = ((String)object2).substring(0, n);
            }
            this.tf.write("constructRest()", 18, "urlPath:" + (String)object2);
            object = new ADescriptorDownload(this, (String)object2);
            AFtpReturnCode aFtpReturnCode = ((ADescriptorDownload)object).processDescriptor();
            this.tf.write("constructRest()", 18, "ftpRC:" + aFtpReturnCode.getProcessCode());
            if (aFtpReturnCode.getProcessCode() != 0) {
                if (aFtpReturnCode.getProcessCode() > 1) {
                    if (aFtpReturnCode.getProcessCode() == 407) {
                        this.tf.write("constructRest()", 18, "Message:" + aFtpReturnCode.getException().toString());
                        AUtilities.showInfoMessage("No route to the Internet server was found.<br>Use \"Settings->Proxy\" to check your proxy configuration.");
                    } else {
                        AUtilities.showInfoMessage(aFtpReturnCode.getException().toString());
                    }
                }
                return false;
            }
            file = new File(AUtilities.tempDirectory() + File.separator + "ebrscrt.des");
            this.isDescriptorSource = true;
            this.groupObjectsTable = new Hashtable();
            this.fileObjectsTable = new Hashtable();
            try {
                String string = file.getAbsolutePath();
                this.tf.write("constructRest()", 18, "desFileName:" + string);
                AMainWindow.UpdateStatusInfo("Parsing descriptor file ...");
                if (this.readDescriptor(string) > 0) {
                    bl = false;
                    AMainWindow.UpdateStatusInfo("");
                    return bl;
                }
                AMainWindow.UpdateStatusInfo("");
            }
            catch (IOException iOException) {
                this.tf.write("constructRest():", 0, "Exception:" + iOException.toString());
            }
        } else {
            this.softcopyFileNames = new AFileObjectsSet();
            AStatusWindow.write("Searching for softcopy files on " + this.drive + " ...");
            AMainWindow.UpdateStatusInfo("Searching for softcopy files on " + this.drive + " ...");
            bl = this.getShelvesOnDrive(this.drive);
            if (!bl) {
                this.tf.write("constructRest()", 0, "Failed:" + this.drive);
                AMainWindow.UpdateStatusInfo("");
                return bl;
            }
            AMainWindow.UpdateStatusInfo("");
        }
        if (!this.addItemsToSourceWindow()) {
            bl = false;
            return bl;
        }
        String string = "";
        if (this.aPropObject.comparedToRepository().length() > 0) {
            string = this.aPropObject.comparedToRepository().trim();
        } else if (this.mainWindow.listWindow.aRepositoryList.size() == 1) {
            string = ((ARepository)this.mainWindow.listWindow.aRepositoryList.firstElement()).repositoryTitle().trim();
        } else if (this.mainWindow.listWindow.aRepositoryList.size() > 1) {
            object2 = "Select a repository to compare " + this.getTitle() + " against";
            object = new ARepositoryListWindow(this.mainWindow, (String)object2, true);
            if (((ARepositoryListWindow)object).retCode == 0) {
                string = ((String)((ARepositoryListWindow)object).repList.getSelectedValue()).trim();
            }
        }
        if (string.length() > 0) {
            object2 = ((AbstractList)this.mainWindow.listWindow.aRepositoryList).iterator();
            while (object2.hasNext()) {
                object = (ARepository)object2.next();
                if (!string.equals(((ARepository)object).repositoryTitle())) continue;
                if (this.UpdateStatus((ARepository)object) != 1) break;
                return false;
            }
        }
        this.setColumnSizeOrder();
        return bl;
    }

    private void viewContents() {
        if (this.table1.getSelectedRow() == -1 | this.table1.getRowCount() == 0) {
            AUtilities.showInfoMessage("Select at least one item for this operation");
            return;
        }
        this.mainWindow.waitMouseCursor(this, true);
        Vector vector = this.table1.getDataModel().getSelectedObjects(this.table1, this.table1.getSelectedRows());
        this.tf.write("viewContents()", 18, "No. of objects selected:" + vector.size());
        ASourceViewContentsWindow aSourceViewContentsWindow = new ASourceViewContentsWindow(this.mainWindow, vector, this.aSourceObject);
        try {
            this.mainWindow.getDeskTopPane().add(aSourceViewContentsWindow);
            AStatusWindow.write("View Contents Window added");
            aSourceViewContentsWindow.moveToFront();
            aSourceViewContentsWindow.setSelected(true);
        }
        catch (Exception exception) {
            this.tf.write("viewContents()", 0, "Caught IOException: " + exception.getMessage());
        }
        this.mainWindow.waitMouseCursor(this, false);
    }

    public void sendTo(String string) {
        if (this.table1.getSelectedRow() != -1 && this.table1.getRowCount() > 0) {
            Object object;
            Object object2;
            Object object3;
            String string2 = string;
            int n = string2.indexOf("Repository - ");
            if (n != -1) {
                string2 = string2.substring(new String("Repository - ").length());
            }
            if (string2.equals("All")) {
                object3 = this.mainWindow.listWindow.aRepositoryList.elements();
                while (object3.hasMoreElements()) {
                    object2 = (ARepository)object3.nextElement();
                    object = new File(((ARepository)object2).catalogFileName());
                    if (((File)object).exists()) continue;
                    String string3 = "The catalog for this repository:<br>" + ((ARepository)object2).repositoryTitle() + "<br>" + "must be created in order to continue.";
                    AUtilities.showInfoMessage("<html>" + string3 + "</html>");
                    return;
                }
            }
            object3 = new AGroupObjectsSet();
            object2 = this.table1.getDataModel().getSelectedObjects(this.table1, this.table1.getSelectedRows()).elements();
            while (object2.hasMoreElements()) {
                object = (AGroupObject)object2.nextElement();
                this.tf.write("sendTo()", 19, "keyfield:" + ((ABaseObject)object).keyField());
                ((ABaseSet)object3).add(((ABaseObject)object).keyField(), object);
            }
            object = ((AbstractList)this.mainWindow.listWindow.aRepositoryList).iterator();
            while (object.hasNext()) {
                ARepository aRepository = (ARepository)object.next();
                if (!string2.equals(aRepository.repositoryTitle()) && !string2.equals("All")) continue;
                if (null == aRepository.repositoryWindow()) {
                    AMainWindow.setSourceObject(this.aSourceObject);
                    this.repositoryWindow = new ARepositoryWindow(this.mainWindow, aRepository, (ABaseSet)object3);
                } else if (!aRepository.repositoryWindow().isClosed()) {
                    Object object4 = object3;
                    String string4 = string2;
                    try {
                        Thread thread = new Thread((AGroupObjectsSet)object4, aRepository, string4){
                            private final /* synthetic */ AGroupObjectsSet val$sendObjects;
                            private final /* synthetic */ ARepository val$repObject;
                            private final /* synthetic */ String val$key;
                            {
                                this.val$sendObjects = aGroupObjectsSet;
                                this.val$repObject = aRepository;
                                this.val$key = string;
                            }

                            public void run() {
                                AFileObjectsSet aFileObjectsSet = ACatalog.getUniqueObjects(this.val$sendObjects, this.val$repObject);
                                ASourceWindow.this.tf.write("sendTo()", 18, "Send no. of files:" + aFileObjectsSet.size());
                                if (aFileObjectsSet.size() == 0) {
                                    AUtilities.showInfoMessage("No files to transfer to " + this.val$repObject.repositoryTitle());
                                    return;
                                }
                                ATransferProcess aTransferProcess = new ATransferProcess((JFrame)this.val$repObject.repositoryWindow().mainWindow, (Object)aFileObjectsSet.asVector(), ASourceWindow.this.aSourceObject, this.val$repObject);
                                if (aTransferProcess.filesTransferred.size() > 0) {
                                    this.val$repObject.repositoryWindow().addRows(aTransferProcess.filesTransferred);
                                    if (!this.val$key.equals("All") && ASourceWindow.this.UpdateStatus(this.val$repObject) == 1) {
                                        return;
                                    }
                                }
                            }
                        };
                        thread.start();
                        aRepository.repositoryWindow().setIcon(false);
                        aRepository.repositoryWindow().moveToFront();
                        aRepository.repositoryWindow().setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (string2.equals("All")) {
                    continue;
                }
                break;
            }
        } else {
            AUtilities.showInfoMessage("Select at least one item for this operation");
        }
    }

    public int UpdateStatus(ARepository aRepository) {
        Object object;
        AComparisonName aComparisonName;
        Object object2;
        int n = 0;
        this.tf.write("UpdateStatus()", 18, "Entry");
        n = this.mainWindow.listWindow.ValidateCatalog(aRepository);
        if (n == 1) {
            return n;
        }
        if (n == 0) {
            n = this.mainWindow.listWindow.CreateCatalog(aRepository);
        }
        if ((n = this.mainWindow.listWindow.ReadCatalog(aRepository)) > 0) {
            return n;
        }
        this.mainWindow.waitMouseCursor(this, true);
        aRepository.catalog().changeKey(4);
        Vector vector = this.table1.getDataModel().getAllObjects();
        this.tf.write("UpdateStatus()", 19, "Table size:" + String.valueOf(vector.size()));
        this.tf.write("UpdateStatus()", 19, "Catalog group size:" + String.valueOf(aRepository.catalog().groupObjectsSet().size()));
        this.tf.write("UpdateStatus()", 19, "Catalog file size:" + String.valueOf(aRepository.catalog().fileObjectsSet().size()));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (AGroupObject)enumeration.nextElement();
            aComparisonName = new AComparisonName(((ABaseObject)object2).fileName());
            this.tf.write("UpdateStatus()", 19, "1. Stub:" + aComparisonName.stub());
            this.tf.write("UpdateStatus()", 19, "1. Text:" + aComparisonName.text());
            object = "";
            Vector vector2 = aRepository.catalog().groupObjectsSet().getObjects(aComparisonName.stub());
            if (vector2 != null) {
                this.tf.write("UpdateStatus()", 19, "Found size:" + String.valueOf(vector2.size()));
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    AGroupObject aGroupObject = (AGroupObject)enumeration2.nextElement();
                    AComparisonName aComparisonName2 = new AComparisonName(aGroupObject.fileName());
                    this.tf.write("UpdateStatus()", 19, "2. Stub:" + aComparisonName2.stub());
                    this.tf.write("UpdateStatus()", 19, "2. Text:" + aComparisonName2.text());
                    if (aComparisonName.text().equals(aComparisonName2.text())) {
                        this.tf.write("UpdateStatus()", 19, "Missing file objects in group:" + aGroupObject.missingFileObjectsSet().size());
                        if (aGroupObject.missingFileObjectsSet().size() > 0) {
                            object = "Partial";
                            break;
                        }
                        object = "Installed";
                        break;
                    }
                    int n2 = aComparisonName.suffix().compareTo(aComparisonName2.suffix());
                    this.tf.write("UpdateStatus()", 19, "checkSuffix:" + n2);
                    if (n2 < 0) {
                        object = "Downlevel";
                        continue;
                    }
                    if (!((String)object).equals("")) continue;
                    object = "Updated";
                }
            }
            if (((String)object).equals("")) {
                ((ABaseObject)object2).setStatus("New");
                continue;
            }
            ((ABaseObject)object2).setStatus((String)object);
        }
        this.table1.getDataModel().tableRefresh(this.table1);
        object2 = this.viewContentsVector.elements();
        while (object2.hasMoreElements()) {
            aComparisonName = object2.nextElement();
            object = (ASourceViewContentsWindow)((Object)aComparisonName);
            ((ASourceViewContentsWindow)object).UpdateStatus(aRepository);
        }
        if (aRepository.repositoryWindow() != null) {
            aRepository.catalog().changeKey(3);
        }
        this.aPropObject.setComparedToRepository(aRepository.repositoryTitle());
        this.mainWindow.waitMouseCursor(this, false);
        this.tf.write("UpdateStatus()", 18, "Exit");
        return n;
    }

    private void setColumnSizeOrder() {
        if (this.aPropObject.columnSort() != null) {
            int n;
            TableColumnModel tableColumnModel = this.table1.getColumnModel();
            String string = "";
            int n2 = 0;
            while (n2 < tableColumnModel.getColumnCount()) {
                int n3 = this.aPropObject.columnSequence()[n2];
                n = tableColumnModel.getColumn(n3).getModelIndex();
                if (string.indexOf(new Integer(n).toString()) == -1 && n == n3) {
                    this.table1.moveColumn(n3, n2);
                }
                string = string + n3;
                ++n2;
            }
            String string2 = this.aPropObject.columnSort();
            n = string2.indexOf(44);
            if (n != -1) {
                this.table1.getDataModel().sort(this.table1, new Integer(string2.substring(0, n)), new Boolean(string2.substring(n + 1)));
            }
        }
    }

    private void showNewUpdated() {
        Object object;
        if (this.showNewUpdated) {
            return;
        }
        this.mainWindow.waitMouseCursor(this, true);
        int n = this.table1.getDataModel().getRowCount();
        int n2 = this.dataModel1.getColumnCount();
        String[] stringArray = new String[]{"Title", "Status", "Filename", "Date", "Size", "Files"};
        ASourceWindowModel aSourceWindowModel = new ASourceWindowModel(this.mainWindow, stringArray);
        this.tf.write("showNewUpdated()", 19, "Row Count:" + n);
        int n3 = 0;
        while (n3 < n) {
            object = this.table1.getCellRenderer(n3, 0);
            Component component = object.getTableCellRendererComponent(this.table1, "", true, true, n3, 1);
            ABaseObject aBaseObject = (ABaseObject)this.table1.getDataModel().getSelectedObject(n3, this.table1);
            this.tf.write("showNewUpdated()", 19, "Test:" + aBaseObject.status());
            if (aBaseObject.status().equals("New") || aBaseObject.status().equals("Updated")) {
                aSourceWindowModel.addRow(aBaseObject, this.table1);
            }
            ++n3;
        }
        this.table1.setModel(aSourceWindowModel);
        this.setColumnSizeOrder();
        this.compListener.resizeTableColumns(this.getSize().getWidth());
        object = this.table1.getTableHeader();
        ((Component)object).addMouseListener(new ASourceWindowModel.ColumnListener(aSourceWindowModel, this.table1));
        this.showNewUpdated = true;
        this.infoLabel.setText("Total no. of objects : " + this.table1.getRowCount());
        this.mainWindow.waitMouseCursor(this, false);
    }

    private void showAll() {
        this.mainWindow.waitMouseCursor(this, true);
        this.table1.setModel(this.dataModel1);
        this.setColumnSizeOrder();
        this.compListener.resizeTableColumns(this.getSize().getWidth());
        this.showNewUpdated = false;
        this.infoLabel.setText("Total no. of objects : " + this.table1.getRowCount());
        this.mainWindow.waitMouseCursor(this, false);
    }

    private void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new APrintClass(this.table1));
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
                this.tf.write("print()", 18, "Printing user name:" + printerJob.getUserName());
                AStatusWindow.write("Printing job for user : " + printerJob.getUserName());
            }
            catch (Exception exception) {
                this.tf.write("print()", 0, "Printing Exception :" + exception.toString());
            }
        } else {
            this.tf.write("print()", 18, "Printing canceled" + printerJob.getUserName());
            AStatusWindow.write("Printing canceled");
        }
    }

    private void Refresh() {
        Object object;
        if (this.drive.length() == 0) {
            return;
        }
        this.mainWindow.waitMouseCursor(this, true);
        if (this.isDescriptorSource) {
            this.groupObjectsTable.clear();
            this.fileObjectsTable.clear();
            object = null;
            if (this.aSourceObject.usingInternet()) {
                int n = this.aSourceObject.sourcePath().indexOf(32);
                String string = this.aSourceObject.sourcePath();
                if (n != -1) {
                    string = string.substring(0, n);
                }
                this.tf.write("Refresh()", 18, "urlPath:" + string);
                ADescriptorDownload aDescriptorDownload = new ADescriptorDownload(this, string);
                AFtpReturnCode aFtpReturnCode = aDescriptorDownload.processDescriptor();
                if (aFtpReturnCode.getProcessCode() != 0) {
                    if (aFtpReturnCode.getProcessCode() > 1) {
                        AUtilities.showInfoMessage("Error occurred during ftp:" + aFtpReturnCode.getProcessCode());
                    }
                    this.mainWindow.waitMouseCursor(this, false);
                    this.dispose();
                    return;
                }
                object = new File(AUtilities.tempDirectory() + File.separator + "ebrscrt.des");
            } else {
                object = new File(this.drive + File.separator + "ebrscrt.des");
            }
            try {
                if (this.readDescriptor(((File)object).getAbsolutePath()) > 0) {
                    this.dispose();
                    return;
                }
            }
            catch (IOException iOException) {}
        } else {
            this.shelvesCount = 0;
            this.softcopyFileNames.clear();
            AStatusWindow.write("Searching for softcopy files on " + this.drive + " ...");
            AMainWindow.UpdateStatusInfo("Searching for softcopy files on " + this.drive + " ...");
            if (!this.getShelvesOnDrive(this.drive)) {
                this.tf.write("Refresh()", 0, "Failed:" + this.drive);
            }
        }
        this.table1.getDataModel().clearTable(this.table1);
        if (!this.addItemsToSourceWindow()) {
            this.dispose();
            return;
        }
        if (this.aPropObject.comparedToRepository() != null) {
            object = ((AbstractList)this.mainWindow.listWindow.aRepositoryList).iterator();
            while (object.hasNext()) {
                ARepository aRepository = (ARepository)object.next();
                if (!this.aPropObject.comparedToRepository().equals(aRepository.repositoryTitle())) continue;
                if (this.UpdateStatus(aRepository) != 1) break;
                return;
            }
        }
        this.mainWindow.waitMouseCursor(this, false);
    }

    private boolean addItemsToSourceWindow() {
        boolean bl = true;
        this.tf.write("addItemsToSourceWindow()", 18, "Entry");
        int n = 0;
        boolean bl2 = false;
        AProgressObject aProgressObject = null;
        if (this.isDescriptorSource) {
            this.tf.write("addItemToSourceWindow()", 19, "No. of group elements : " + String.valueOf(this.groupObjectsTable.size()));
            this.tf.write("addItemToSourceWindow()", 19, "No. of file elements : " + String.valueOf(this.fileObjectsTable.size()));
            n = this.groupObjectsTable.size();
            if (n >= 50) {
                aProgressObject = new AProgressObject(this.mainWindow, n);
                aProgressObject.setText("Adding objects to Source window");
                bl2 = true;
            }
            int n2 = 0;
            Enumeration enumeration = this.groupObjectsTable.elements();
            while (enumeration.hasMoreElements()) {
                if (bl2 && (++n2 % 10 == 0 && !aProgressObject.update(n2) || aProgressObject.isProcessCanceled())) break;
                AGroupObject aGroupObject = (AGroupObject)enumeration.nextElement();
                this.table1.getDataModel().addRow(aGroupObject, this.table1);
            }
            this.infoLabel.setText("Total no. of objects : " + this.table1.getRowCount());
            if (bl2) {
                aProgressObject.removeProgressObject();
            }
            return bl;
        }
        n = this.shelvesCount;
        if (n >= 50) {
            aProgressObject = new AProgressObject(this.mainWindow, n);
            aProgressObject.setText("Adding objects to Source window");
            bl2 = true;
        }
        Enumeration enumeration = this.softcopyFileNames.elements();
        this.tf.write("addItemToSourceWindow()", 19, "softcopyFileNames:" + this.shelvesCount);
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            ASoftcopyProperties aSoftcopyProperties = (ASoftcopyProperties)enumeration.nextElement();
            String string = aSoftcopyProperties.absoluteFileName();
            if (!aSoftcopyProperties.fileType().toUpperCase().equals("BKS")) continue;
            AGroupObject aGroupObject = new AGroupObject();
            aGroupObject.setPCFileType("BKSHELF");
            aGroupObject.setHostFileType("BKSHELF");
            boolean bl3 = aGroupObject.read(string, this.softcopyFileNames);
            if (!bl3 && !aGroupObject.isCancelled()) continue;
            if (aGroupObject.isCancelled()) {
                bl = false;
                break;
            }
            aGroupObject.setKeyField(aGroupObject.fileNameType());
            this.table1.getDataModel().addRow(aGroupObject, this.table1);
            if (bl2 && (++n3 % 10 == 0 && !aProgressObject.update(n3) || aProgressObject.isProcessCanceled())) break;
            this.tf.write("addItemToSourceWindow()", 19, "Object added to add vector:" + string);
        }
        if (this.showNewUpdated) {
            this.showNewUpdated();
        }
        if (bl2) {
            aProgressObject.removeProgressObject();
        }
        AGroupObject.setIsErrorMessageShown(false);
        this.infoLabel.setText("Total no. of objects : " + this.table1.getRowCount());
        return bl;
    }

    private boolean getShelvesOnDrive(String string) {
        this.tf.write("getShelvesOnDrive", 18, "Start - " + string);
        File file = new File(string);
        if (!file.exists()) {
            this.tf.write("getShelvesOnDrive()", 18, string + " does not exist");
            int n = 1;
            Object[] objectArray = new Object[]{"Retry", "Cancel"};
            n = JOptionPane.showOptionDialog(this, "<html>" + string + " is not accessible.<br>" + "The device is not ready." + "</html>", "SCL - Confirm Dialog", 0, 3, null, objectArray, objectArray[1]);
            if (n == 0) {
                this.getShelvesOnDrive(string);
            } else if (n == 1) {
                return false;
            }
        }
        if (!file.getAbsoluteFile().isDirectory()) {
            return false;
        }
        this.tf.write("getShelvesOnDrive", 19, "Absolute name:" + file.getName());
        String[] stringArray = file.list();
        if (stringArray == null) {
            return true;
        }
        this.tf.write("getShelvesOnDrive", 19, "No. of files in " + file.getName() + " is " + stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            this.tf.write("getShelvesOnDrive", 19, file2.getAbsolutePath() + " : " + file2.isDirectory());
            if (file2.isDirectory()) {
                this.getShelvesOnDrive(file2.getAbsolutePath());
            } else if (file2.isFile()) {
                String string2 = file2.getAbsolutePath();
                int n2 = string2.lastIndexOf(46);
                String string3 = "";
                if (n2 != -1) {
                    string3 = string2.substring(n2 + 1);
                }
                this.tf.write("getShelvesOnDrive", 19, "Filetype:" + string3);
                if (string3.toUpperCase().equals("BKS") || string3.toUpperCase().equals("BOO") || string3.toUpperCase().equals("BKI")) {
                    ASoftcopyProperties aSoftcopyProperties = new ASoftcopyProperties();
                    String string4 = file2.getName();
                    aSoftcopyProperties.setFileName(string4);
                    aSoftcopyProperties.setFileType(string3);
                    aSoftcopyProperties.setAbsoluteFileName(string2);
                    aSoftcopyProperties.setSize(new Float(file2.length()));
                    this.softcopyFileNames.add(string4.toUpperCase(), aSoftcopyProperties);
                    if (string3.toUpperCase().equals("BKS")) {
                        ++this.shelvesCount;
                    }
                    this.tf.write("getShelvesOnDrive", 19, "Object added:" + string2 + ", size:" + file2.length());
                }
            }
            ++n;
        }
        return true;
    }

    private int readDescriptor(String string) throws IOException {
        String string2 = string;
        String string3 = "";
        int n = 0;
        AProgressObject aProgressObject = null;
        AStatusWindow.write("Reading descriptor " + string2 + " ...");
        aProgressObject = new AProgressObject(this.mainWindow, 0, true, true);
        aProgressObject.setText("Reading descriptor file ...");
        FileReader fileReader = null;
        fileReader = new FileReader(string2);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Long l = new Long(new File(string2).length());
        char[] cArray = new char[l.intValue()];
        if (bufferedReader.read(cArray, 0, l.intValue()) == -1) {
            this.tf.write("readDescriptor()", 0, "Error reading descriptor : " + string2);
            return 1;
        }
        bufferedReader.close();
        fileReader.close();
        StringBuffer stringBuffer = new StringBuffer(new String(cArray));
        StringTokenizer stringTokenizer = new StringTokenizer(new String(cArray), "\n");
        if (stringTokenizer.countTokens() > 10) {
            this.lineReader = new LineNumberReader(new StringReader(stringBuffer.toString()));
        } else {
            this.parseBuffer(stringBuffer.toString());
        }
        aProgressObject.removeProgressObject();
        this.parseLine();
        if (this.aKeyWord.equals(PACKAGE) && (n = this.parseLine()) > 0) {
            return n;
        }
        this.parsePackage();
        int n2 = this.aPackage.groupCount() + this.aPackage.fileCount();
        this.tf.write("readDescriptor()", 18, "No. of elements in descriptor file:" + n2);
        boolean bl = false;
        if (n2 > 20) {
            aProgressObject = new AProgressObject(this.mainWindow, n2, "Parsing descriptor file ...");
            bl = true;
        }
        int n3 = 0;
        if (this.aKeyWord.equals(ELEMENT)) {
            do {
                this.fileObject = new AFileObject();
                if (bl && !aProgressObject.update(++n3)) break;
                n = this.parseElement();
                this.tf.write("readDescriptor()", 19, "after call parseElement(), rc:" + n);
                if (n != 1) continue;
                AUtilities.showInfoMessage("Error reading line number " + String.valueOf(this.lineReader.getLineNumber()) + "<br>" + "Keyword:" + this.aKeyWord + ", Keyword value:" + this.aKeyWordValue);
                return n;
            } while (n <= 0 && !this.aKeyWord.equals(PRODUCT));
        }
        if (bl) {
            aProgressObject.removeProgressObject();
        }
        return n;
    }

    private int parseLine() {
        String string = "";
        try {
            string = this.lineReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!string.equals("")) {
            int n = string.indexOf("=");
            if (n != -1) {
                this.aKeyWord = string.substring(0, n);
                this.aKeyWordValue = string.substring(n + 1);
            } else {
                this.aKeyWord = string;
                this.aKeyWordValue = "";
            }
        } else {
            this.aKeyWord = "";
            this.aKeyWordValue = "";
        }
        this.tf.write("parseLine()", 19, "Line Number:" + String.valueOf(this.lineReader.getLineNumber()));
        this.tf.write("parseLine()", 19, "Keyword:" + this.aKeyWord + ", aKeyWordValue:" + this.aKeyWordValue);
        return 0;
    }

    private int parsePackage() throws IOException {
        int n = 0;
        this.aPackage = new APackageObject();
        while (!this.aKeyWord.equals("ELEMENT") && !this.aKeyWord.equals("PRODUCT")) {
            Object object;
            if (this.aKeyWord.equals(PKG_NAME)) {
                object = this.aKeyWordValue.replace('\"', ' ').trim();
                this.aPackage.setPackageName((String)object);
            } else if (this.aKeyWord.equals(PKG_NUM)) {
                this.aPackage.setPackageNumber(this.aKeyWordValue);
            } else if (this.aKeyWord.equals(PKG_TIMESTAMP)) {
                this.aPackage.setPackageDate(this.aKeyWordValue);
            } else if (this.aKeyWord.equals(PKG_NUM_FILES)) {
                object = this.aKeyWordValue.toCharArray();
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    if (!Character.isDigit((char)object[n2])) {
                        return 1;
                    }
                    ++n2;
                }
                this.aPackage.setFileCount(this.aKeyWordValue);
            } else if (this.aKeyWord.equals(PKG_NUM_PRODUCTS)) {
                object = this.aKeyWordValue.toCharArray();
                int n3 = 0;
                while (n3 < ((Object)object).length) {
                    if (!Character.isDigit((char)object[n3])) {
                        return 1;
                    }
                    ++n3;
                }
                this.aPackage.setProductCount(this.aKeyWordValue);
            } else if (this.aKeyWord.equals(PKG_NUM_GROUPS)) {
                object = this.aKeyWordValue.toCharArray();
                int n4 = 0;
                while (n4 < ((Object)object).length) {
                    if (!Character.isDigit((char)object[n4])) {
                        return 1;
                    }
                    ++n4;
                }
                this.aPackage.setGroupCount(this.aKeyWordValue);
            } else if (this.aKeyWord.equals(PKG_NUM_OF_VOLS)) {
                this.aPackage.setNumOfVols(this.aKeyWordValue);
            } else if (this.aKeyWord.startsWith(PKG_VOLIDXX)) {
                object = this.aKeyWord;
                object = ((String)object).substring(9);
                this.tf.write("parsePackage()", 19, "PKG_VOLIDXX:" + (String)object);
                char[] cArray = ((String)object).toCharArray();
                int n5 = 0;
                while (n5 < cArray.length) {
                    if (!Character.isDigit(cArray[n5])) {
                        return 1;
                    }
                    ++n5;
                }
                this.aPackage.setVolNum((String)object);
            } else if (!this.aKeyWord.endsWith(PKG_VOLXX_NUM_OF_ELMS) && !this.aKeyWord.equals(PKG_SAA_DESC_VERSION)) {
                return 1;
            }
            this.parseLine();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int parseElement() throws IOException {
        var1_1 = 0;
        var2_2 = 0;
        this.tf.write("parseElement()", 19, "Entry:" + var1_1);
        if (this.parseLine() <= 0) ** GOTO lbl163
        var1_1 = 1;
        return var1_1;
lbl-1000:
        // 1 sources

        {
            if (this.aKeyWord.equals(ASourceWindow.ELM_TYPE)) {
                this.fileObject.setPCFileType(this.aKeyWordValue);
                this.fileObject.setHostFileType(this.aKeyWordValue);
                if (this.aKeyWordValue.equals("BKSHELF")) {
                    this.groupObject = new AGroupObject();
                    this.groupObject.setPCFileType(this.aKeyWordValue);
                    this.groupObject.setGroupProcessed(true);
                    this.groupObject.setFileObjectPtr(this.fileObject);
                    this.fileObject.setGroupObjectPtr(this.groupObject);
                } else {
                    this.fileObject.setGroupObjectPtr(null);
                }
            } else if (this.aKeyWord.equals(ASourceWindow.ELM_NUM)) {
                var3_3 = this.aKeyWordValue;
                if (!this.aKeyWordValue.equals("N/A")) {
                    // empty if block
                }
                this.fileObject.setOrderNumber((String)var3_3);
            } else if (this.aKeyWord.equals(ASourceWindow.ELM_NAME)) {
                var3_3 = this.aKeyWordValue.replace('\"', ' ').trim();
                this.fileObject.setTitle((String)var3_3);
                if (this.fileObject.pcFileType().toUpperCase().equals("BKS")) {
                    this.groupObject.setTitle((String)var3_3);
                }
            } else if (!this.aKeyWord.equals(ASourceWindow.ELM_LANG)) {
                if (this.aKeyWord.equals(ASourceWindow.ELM_TIMESTAMP)) {
                    var3_3 = new SimpleDateFormat("yyyyMMddHHmmss");
                    var3_3.setLenient(false);
                    var4_4 = null;
                    try {
                        var4_4 = var3_3.parse(this.aKeyWordValue);
                    }
                    catch (ParseException var5_10) {
                        var3_3 = new SimpleDateFormat("yyyyMMdd");
                        try {
                            var4_4 = var3_3.parse(this.aKeyWordValue);
                        }
                        catch (ParseException var6_11) {
                            this.tf.write("parseElement()", 0, "Parse Exception:" + var5_10);
                            this.tf.write("parseElement()", 0, "Retry with yyyyMMdd format");
                        }
                    }
                    this.fileObject.setDate(var4_4);
                    if (this.fileObject.pcFileType().toUpperCase().equals("BKS")) {
                        this.groupObject.setShelfDate(var4_4);
                    }
                } else if (!this.aKeyWord.equals(ASourceWindow.ELM_LOCKED)) {
                    if (this.aKeyWord.equals(ASourceWindow.ELM_OS2DOS_NAME)) {
                        var3_3 = this.aKeyWordValue.replace('\'', ' ').trim();
                        var3_3 = this.aKeyWordValue.replace('\"', ' ').trim();
                        var2_2 = var3_3.lastIndexOf(".");
                        if (var2_2 > 0) {
                            var3_3 = var3_3.substring(0, var2_2);
                        }
                        this.fileObject.setFileName((String)var3_3);
                        this.fileObject.setKeyField(this.fileObject.fileNameType());
                        if (this.fileObject.pcFileType().toUpperCase().equals("BKS")) {
                            this.groupObject.setShelfFileName((String)var3_3);
                            this.groupObject.setKeyField(this.groupObject.fileNameType());
                        }
                    } else if (this.aKeyWord.equals(ASourceWindow.ELM_DIRECT_NAME)) {
                        var3_3 = this.aKeyWordValue.replace('\'', ' ').trim();
                        var3_3 = this.aKeyWordValue.replace('\"', ' ').trim();
                        var2_2 = var3_3.indexOf(":");
                        if (var2_2 > 0) {
                            var3_3 = var3_3.substring(var2_2 + 1);
                        }
                        var4_5 = false;
                        var5_9 = AUtilities.strip(this.aSourceObject.sourcePath(), File.separatorChar) + (String)var3_3;
                        var6_12 = new File((String)var5_9);
                        if (!this.aSourceObject.usingInternet()) {
                            var3_3 = var5_9;
                        }
                        if (!(var6_12.exists() || this.isErrorMessageShown || this.aSourceObject.usingInternet())) {
                            var7_14 = 1;
                            var8_16 = new Object[]{"Yes", "No", "Cancel"};
                            var7_14 = JOptionPane.showOptionDialog(this, "<html>" + (String)var5_9 + " does not exist.<br>" + "The descriptor file contains errors<br><br>" + "Click on Yes to create a new descriptor file.<br>" + "Click on No to continue reading the descriptor file.<br>" + "Click on Cancel to stop the reading process." + "</html>", "SCL - Confirm Dialog", 1, 3, null, var8_16, var8_16[2]);
                            if (var7_14 == 0) {
                                var1_1 = 2;
                                break;
                            }
                            if (var7_14 != 1) {
                                var1_1 = 3;
                                break;
                            }
                            this.isErrorMessageShown = true;
                        }
                        this.fileObject.setDirectName((String)var3_3);
                        if (this.fileObject.pcFileType().toUpperCase().equals("BKS")) {
                            this.groupObject.setFullShelfFileName((String)var3_3);
                        }
                    } else if (this.aKeyWord.equals(ASourceWindow.ELM_SIZE)) {
                        var3_3 = new Float(new Double(this.aKeyWordValue) * 1000000.0);
                        this.fileObject.setSize((Float)var3_3);
                    } else if (this.aKeyWord.equals(ASourceWindow.ELM_FILENUM)) {
                        var3_3 = this.aKeyWordValue.toCharArray();
                        var4_6 = 0;
                        while (var4_6 < ((Object)var3_3).length) {
                            if (!Character.isDigit((char)var3_3[var4_6])) {
                                var1_1 = 1;
                                break;
                            }
                            ++var4_6;
                        }
                        if (var1_1 == 1) break;
                        var5_9 = new Integer(this.aKeyWordValue);
                        this.fileObject.setFileNum((Integer)var5_9);
                        if (this.fileObject.pcFileType().toUpperCase().equals("BKS")) {
                            this.groupObject.setFileNum((Integer)var5_9);
                        }
                    } else if (!this.aKeyWord.equals(ASourceWindow.ELM_CHG_STAT) && !this.aKeyWord.equals(ASourceWindow.ELM_DISPLACED_FILE)) {
                        if (this.aKeyWord.equals(ASourceWindow.ELM_BKS_NUM_ASSOC)) {
                            if (!this.aKeyWordValue.equals("0")) {
                                var3_3 = new StringTokenizer(this.aKeyWordValue, ",");
                                while (var3_3.hasMoreTokens()) {
                                    var4_7 = var3_3.nextToken();
                                    var5_9 = var4_7.toCharArray();
                                    var6_13 = 0;
                                    while (var6_13 < ((Object)var5_9).length) {
                                        if (!Character.isDigit((char)var5_9[var6_13])) {
                                            var1_1 = 1;
                                            break;
                                        }
                                        ++var6_13;
                                    }
                                    if (var1_1 != 1) {
                                        var7_15 = (AFileObject)this.fileObjectsTable.get(new Integer(var4_7));
                                        if (var7_15 != null) {
                                            var7_15.setIncluded(true);
                                            if (var7_15.pcFileType().toUpperCase().equals("BKI")) {
                                                this.groupObject.setIndexFileName(var7_15.fileName());
                                                this.groupObject.setIndexDate(var7_15.date());
                                            }
                                            this.groupObject.bookSet().addElement(var7_15);
                                            continue;
                                        }
                                        this.tf.write("parseElement()", 19, " File object not found in file objects table");
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else if (!this.aKeyWord.equals(ASourceWindow.ELM_BKS_LOCKED) && !this.aKeyWord.equals(ASourceWindow.ELM_BKS_CHG_STAT)) {
                            if (this.aKeyWord.equals(ASourceWindow.ELM_BKS_SIZE)) {
                                var3_3 = new Float(new Double(this.aKeyWordValue) * 1000000.0);
                                this.groupObject.setShelfSize((Float)var3_3);
                            } else if (this.aKeyWord.equals(ASourceWindow.ELM_BKS_FILES)) {
                                var3_3 = this.aKeyWordValue.toCharArray();
                                var4_8 = 0;
                                while (var4_8 < ((Object)var3_3).length) {
                                    if (!Character.isDigit((char)var3_3[var4_8])) {
                                        var1_1 = 1;
                                        break;
                                    }
                                    ++var4_8;
                                }
                                this.groupObject.setNumberOfBooks(new Integer(this.aKeyWordValue));
                            } else if (!this.aKeyWord.equals(ASourceWindow.ELM_UPL_FM) && !this.aKeyWord.equals(ASourceWindow.ELM_UPL_LRECL)) {
                                if (this.aKeyWord.equals(ASourceWindow.ELM_UPL_TYPE)) {
                                    this.fileObjectsTable.put(this.fileObject.fileNum(), this.fileObject);
                                    if (this.fileObject.pcFileType().toUpperCase().equals("BKS")) {
                                        this.groupObjectsTable.put(this.groupObject.fileNum(), this.groupObject);
                                    }
                                } else if (this.aKeyWord.equals(ASourceWindow.ELEMENT) || this.aKeyWord.equals(ASourceWindow.PRODUCT) || this.aKeyWord.equals("")) break;
                            }
                        }
                    }
                }
            }
            this.parseLine();
lbl163:
            // 2 sources

            ** while (!this.aKeyWord.equals((Object)ASourceWindow.PRODUCT) && !this.aKeyWord.equals((Object)ASourceWindow.ELEMENT))
        }
lbl164:
        // 5 sources

        this.tf.write("parseElement()", 19, "Exit:" + var1_1);
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private int parseProduct() throws IOException {
        var1_1 = 0;
        if (this.parseLine() <= 0) ** GOTO lbl7
        var1_1 = 1;
        return var1_1;
lbl-1000:
        // 1 sources

        {
            this.parseLine();
lbl7:
            // 2 sources

            ** while (!this.aKeyWord.equals((Object)"EOF"))
        }
lbl8:
        // 1 sources

        return var1_1;
    }

    private int parseBuffer(String string) throws IOException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        this.buffer = new StringBuffer();
        String string5 = "\" \r\n";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string5);
        this.tf.write("parseBuffer()", 19, "count tokens:" + String.valueOf(stringTokenizer.countTokens()));
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken(string5);
            int n2 = string.indexOf(string3);
            int n3 = n2 + string3.length();
            if (n2 == -1 || n3 >= string.length()) continue;
            if (string.substring(n2 += string3.length(), n2 + 1).equals("\"")) {
                String string6 = string3;
                this.tf.write("parseBuffer()", 19, "1. currentToken:" + string3);
                string3 = stringTokenizer.nextToken("\"");
                int n4 = string.indexOf(string3, n2);
                n = n4 + string3.length() + 1;
                string5 = "\" \r\n";
                string3 = string3.replace('\n', ' ');
                string3 = string3.replace('\r', ' ');
                this.tf.write("parseBuffer()", 19, "3. currentToken:" + string3);
                this.buffer.append(string6 + "\"" + string3 + "\"" + "\n");
                continue;
            }
            this.buffer.append(string3 + "\n");
        }
        this.buffer.append("EOF");
        this.tf.write("parseBuffer()", 19, "buffer:" + this.buffer);
        this.lineReader = new LineNumberReader(new StringReader(this.buffer.toString()));
        return 0;
    }

    private void editTitle() {
        if (this.table1.getSelectedRow() != -1 && this.table1.getRowCount() > 0) {
            AGroupObject aGroupObject = (AGroupObject)this.table1.getDataModel().getSelectedObject(this.table1.getSelectedRow(), this.table1);
            String string = aGroupObject.title();
            String string2 = "";
            AEditWindow aEditWindow = new AEditWindow(this.mainWindow, string);
            if (aEditWindow.retCode == 0 && !(string2 = aEditWindow.updatedTitle()).equals(aGroupObject.title())) {
                aGroupObject.setTitle(string2);
                if (!aGroupObject.write(aGroupObject.fullShelfFileName())) {
                    AUtilities.showInfoMessage("Error updating shelf:" + aGroupObject.fullShelfFileName());
                    return;
                }
                this.table1.getDataModel().tableRefresh(this.table1);
            }
            this.tf.write("updatedTitle:", 19, string2);
        } else {
            AUtilities.showInfoMessage("Select at least one item for this operation");
        }
    }

    private void FindFirst() {
        this.itemFindNext.setEnabled(false);
        this.findWindow = new AFindWindow(this.mainWindow, this.table1, this.searchString);
        if (this.findWindow.retCode == 1) {
            this.findWindow = null;
            return;
        }
        this.searchString = this.findWindow.getFindText();
        if (this.findWindow.findFirst()) {
            this.itemFindNext.setEnabled(true);
        } else {
            AUtilities.showInfoMessage(this.searchString + " not found");
        }
    }

    private void FindNext() {
        if (this.findWindow != null && !this.findWindow.findNext()) {
            AUtilities.showInfoMessage(this.findWindow.getFindText() + " not found");
        }
    }

    static /* synthetic */ void access$500(ASourceWindow aSourceWindow) {
        aSourceWindow.viewContents();
    }

    class NewMenuListener
    implements MenuListener {
        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            String string = ((JMenu)menuEvent.getSource()).getText();
            ASourceWindow.this.tf.write("menuSelected()", 19, "Selected Menu:" + string + ", this:" + this);
            ASourceWindow.this.tf.write("menuSelected()", 19, "List size:" + ((ASourceWindow)ASourceWindow.this).mainWindow.listWindow.aRepositoryList.size() + ", Compare size:" + ASourceWindow.this.compareMenu.getItemCount());
            ASourceWindow.this.compareMenu.removeAll();
            ASourceWindow.this.sendToMenu.removeAll();
            Iterator iterator = ((AbstractList)((ASourceWindow)ASourceWindow.this).mainWindow.listWindow.aRepositoryList).iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                ARepository aRepository = (ARepository)iterator.next();
                String string2 = "Repository - " + aRepository.repositoryTitle();
                JMenuItem jMenuItem = ASourceWindow.this.compareMenu.add(new JMenuItem(string2));
                JMenuItem jMenuItem2 = null;
                if (((ASourceWindow)ASourceWindow.this).mainWindow.listWindow.aRepositoryList.size() > 1 && bl) {
                    jMenuItem2 = ASourceWindow.this.sendToMenu.add(new JMenuItem("All"));
                }
                JMenuItem jMenuItem3 = ASourceWindow.this.sendToMenu.add(new JMenuItem(string2));
                ActionListener actionListener = new ActionListener(this, string){
                    private final /* synthetic */ String val$selectedMenuText;
                    private final /* synthetic */ NewMenuListener this$1;
                    {
                        this.this$1 = newMenuListener;
                        this.val$selectedMenuText = string;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        String string2 = string;
                        int n = string2.indexOf("Repository - ");
                        if (n != -1) {
                            string2 = string2.substring(new String("Repository - ").length());
                        }
                        ASourceWindow.access$900(NewMenuListener.access$1400(this.this$1)).write("NewMenuListener::actionPerformed():", 19, "Key:" + string2);
                        Iterator<E> iterator = ((AbstractList)ASourceWindow.access$100((ASourceWindow)NewMenuListener.access$1400((NewMenuListener)this.this$1)).listWindow.aRepositoryList).iterator();
                        ARepository aRepository = null;
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            aRepository = (ARepository)iterator.next();
                            if (!string2.equals(aRepository.repositoryTitle()) && !string2.equals("All")) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            ARepository aRepository2 = aRepository;
                            ASwingWorker aSwingWorker = new ASwingWorker(this, aRepository2, string, "Menu"){
                                private final /* synthetic */ ARepository val$selectedRepository;
                                private final /* synthetic */ String val$actionCommand;
                                private final /* synthetic */ 11 this$2;
                                {
                                    super(string2);
                                    this.this$2 = var1_1;
                                    this.val$selectedRepository = aRepository;
                                    this.val$actionCommand = string;
                                }

                                public Object construct() {
                                    if (11.access$1500(this.this$2).equals("Update Status: Compared To")) {
                                        NewMenuListener.access$1400(11.access$1600(this.this$2)).UpdateStatus(this.val$selectedRepository);
                                    } else if (11.access$1500(this.this$2).equals("Send To")) {
                                        NewMenuListener.access$1400(11.access$1600(this.this$2)).sendTo(this.val$actionCommand);
                                    }
                                    return null;
                                }
                            };
                        }
                    }

                    static /* synthetic */ String access$1500(11 var0) {
                        return var0.val$selectedMenuText;
                    }

                    static /* synthetic */ NewMenuListener access$1600(11 var0) {
                        return var0.this$1;
                    }
                };
                jMenuItem.addActionListener(actionListener);
                jMenuItem3.addActionListener(actionListener);
                if (((ASourceWindow)ASourceWindow.this).mainWindow.listWindow.aRepositoryList.size() <= 1 || !bl) continue;
                jMenuItem2.addActionListener(actionListener);
                bl = false;
            }
        }

        static /* synthetic */ ASourceWindow access$1400(NewMenuListener newMenuListener) {
            return newMenuListener.ASourceWindow.this;
        }
    }

    class PopupListener
    extends ABasePopupListener {
        ASourceWindow sourceWindow;

        public PopupListener(ASourceWindow aSourceWindow2) {
            super(ASourceWindow.this.popup);
            this.sourceWindow = aSourceWindow2;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkModifier(mouseEvent);
            if (mouseEvent.isPopupTrigger()) {
                Object object;
                int n = ((ASourceWindow)ASourceWindow.this).mainWindow.listWindow.aRepositoryList.size() + 1;
                ASourceWindow.this.subMenu.removeAll();
                if (((ASourceWindow)ASourceWindow.this).mainWindow.listWindow.aRepositoryList.size() > 1) {
                    object = ASourceWindow.this.subMenu.add(new JMenuItem("All"));
                    ((AbstractButton)object).addActionListener(this.sourceWindow);
                }
                object = ((AbstractList)((ASourceWindow)ASourceWindow.this).mainWindow.listWindow.aRepositoryList).iterator();
                while (object.hasNext()) {
                    ARepository aRepository = (ARepository)object.next();
                    String string = "Repository - " + aRepository.repositoryTitle();
                    JMenuItem jMenuItem = ASourceWindow.this.subMenu.add(new JMenuItem(string));
                    jMenuItem.addActionListener(this.sourceWindow);
                }
                ASourceWindow.this.popup.add(ASourceWindow.this.subMenu);
                ASourceWindow.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class MyInternalFrameListener
    extends InternalFrameAdapter {
        MyInternalFrameListener() {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            ASourceWindow.this.table1.dontDrag = false;
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            Object object;
            ASourceWindow.this.mainWindow.getWindowMenu().remove(ASourceWindow.this.itemWindow_Source);
            ASourceWindow.this.aPropObject.setIndex(ASourceWindow.this.aSourceObject.index());
            int n = ((ABaseTableModel)ASourceWindow.this.table1.getModel()).m_sortCol;
            TableColumnModel tableColumnModel = ASourceWindow.this.table1.getColumnModel();
            String string = "";
            int n2 = 0;
            while (n2 < tableColumnModel.getColumnCount()) {
                object = ASourceWindow.this.table1.getColumnModel().getColumn(n2);
                string = string + tableColumnModel.getColumn(n2).getModelIndex() + ",";
                ++n2;
            }
            ASourceWindow.this.aPropObject.setColumnSequence(string, tableColumnModel.getColumnCount());
            ASourceWindow.this.aPropObject.setColumnSort(String.valueOf(n) + "," + ((ABaseTableModel)ASourceWindow.this.table1.getModel()).m_sortAsc);
            object = "Source" + ASourceWindow.this.aPropObject.index();
            ASourceWindow.this.aPropObject.setKeyField((String)object);
            APropertyObject aPropertyObject = AMainWindow.userProperties.getObject(object);
            if (aPropertyObject == null) {
                AMainWindow.userProperties.propertiesTable().addElement(ASourceWindow.this.aPropObject);
            }
            int n3 = ASourceWindow.this.viewContentsVector.size();
            int n4 = 0;
            while (n4 < n3) {
                ASourceViewContentsWindow aSourceViewContentsWindow = (ASourceViewContentsWindow)ASourceWindow.this.viewContentsVector.elementAt(0);
                aSourceViewContentsWindow.dispose();
                ++n4;
            }
            ASourceWindow.this.viewContentsVector.removeAllElements();
            ASourceWindow.this.aSourceObject.setSourceWindow(null);
        }
    }
}

