/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class ARepository
implements Serializable,
Cloneable {
    private ARepositorySettings aRepositorySettingsObject = null;
    private AFileTypeList aFileTypeList;
    private String iRepositoryTitle;
    private hostTypeEnum iHostType;
    private int iIndex;
    private String iFtpHost;
    private String iFtpUserid;
    private String iFtpPassword;
    private String iCommonFtpSiteCommands;
    private String iFtpAccount;
    private String iFtpPort;
    private boolean iFtpPasswordVerified;
    private boolean iFtpSavePassword;
    private String iSoftcopyDirectories;
    private String iShelvesDirectories;
    private String iPDFDirectories;
    private String iIndexDirectories;
    private ACatalog iCatalog;
    private ARepositoryWindow iRepositoryWindow;
    private ASetupWindow iSetupWindow;
    static int indexCounter;
    private boolean iCatalogValid;
    String iValue;
    protected ATraceFile tf = new ATraceFile(this);
    static final long ENCRYPTION_KEY = 9922L;
    static final String LABELREPOSITORYVERSION;
    static final String REPOSITORYVERSION;
    static final String LABELNUMBERREPOSITORIES;
    static final String LABEL_REPOSITORY;
    static final String LABEL_INDEX;
    static final String LABEL_TITLE;
    static final String LABEL_ACCESSMETHOD;
    static final String LABEL_HOSTTYPE;
    static final String LABEL_FTPHOST;
    static final String LABEL_FTPUSERID;
    static final String LABEL_FTPPASSWORD;
    static final String LABEL_FTPSAVEPASSWORD;
    static final String LABEL_FTPACCOUNT;
    static final String LABEL_FTPPORT;
    static final String LABEL_SOFTCOPYDIRECTORIES;
    static final String LABEL_SHELVESDIRECTORIES;
    static final String LABEL_PDFDIRECTORIES;
    static final String LABEL_FTPSITECOMMANDS;
    static final String LABEL_INDEXDIRECTORIES;
    static final String LABEL_FILETYPE;
    static final String LABEL_DATACLASS;
    static final String LABEL_MGMTCLASS;
    static final String LABEL_STORCLASS;
    static final String LABEL_UNIT;
    static final String LABEL_VOLUME;
    static final String LABEL_FTP_CMDS;
    static final String LABEL_HLQS;
    static final String LABEL_HLQ;
    static final String LABEL_BKLSHELFNAME;
    static final String LABEL_BLKSIZE;

    ARepository(String string) {
        this.setIndex(++indexCounter);
        this.setRepositoryTitle(string);
        this.setRepositoryWindow(null);
        this.setSetupWindow(null);
        this.setCatalog(new ACatalog(this));
        this.setCatalogValid(false);
        this.setHostType(new hostTypeEnum(1));
        this.setFtpHost("");
        this.setFtpUserid("");
        this.setFtpPassword("");
        this.setFtpAccount("");
        this.setFtpPort("");
        this.setFtpSavePassword(false);
        this.setCommonFtpSiteCommands("");
        this.setFtpPasswordVerified(false);
        this.setSoftcopyDirectories("");
        this.setIndexDirectories("");
        this.setShelvesDirectories("");
        this.setPDFDirectories("");
        this.aFileTypeList = new AFileTypeList();
        this.aRepositorySettingsObject = new ARepositorySettings(new fileTypeEnum(0));
        this.aFileTypeList.addElement(this.aRepositorySettingsObject);
        this.aRepositorySettingsObject = new ARepositorySettings(new fileTypeEnum(1));
        this.aFileTypeList.addElement(this.aRepositorySettingsObject);
        this.aRepositorySettingsObject = new ARepositorySettings(new fileTypeEnum(2));
        this.aFileTypeList.addElement(this.aRepositorySettingsObject);
        this.aRepositorySettingsObject = new ARepositorySettings(new fileTypeEnum(3));
        this.aFileTypeList.addElement(this.aRepositorySettingsObject);
        this.aRepositorySettingsObject = new ARepositorySettings(new fileTypeEnum(5));
        this.aFileTypeList.addElement(this.aRepositorySettingsObject);
    }

    public static void resetIndexCounter(int n) {
        if (n == 0) {
            indexCounter = 0;
        } else if (indexCounter < n) {
            indexCounter = n;
        }
    }

    public void setCatalog(ACatalog aCatalog) {
        this.iCatalog = aCatalog;
    }

    public ACatalog catalog() {
        return this.iCatalog;
    }

    public void setCatalogValid(boolean bl) {
        this.iCatalogValid = bl;
    }

    public boolean isCatalogValid() {
        return this.iCatalogValid;
    }

    public void setRepositoryWindow(ARepositoryWindow aRepositoryWindow) {
        this.iRepositoryWindow = aRepositoryWindow;
    }

    public ARepositoryWindow repositoryWindow() {
        return this.iRepositoryWindow;
    }

    public void setSetupWindow(ASetupWindow aSetupWindow) {
        this.iSetupWindow = aSetupWindow;
    }

    public ASetupWindow setupWindow() {
        return this.iSetupWindow;
    }

    public void setRepositoryTitle(String string) {
        this.iRepositoryTitle = string;
    }

    public String repositoryTitle() {
        return this.iRepositoryTitle;
    }

    public String catalogFileName() {
        return "output" + File.separator + this.repositoryTitle() + " " + new Integer(this.index()).toString() + ".CAT";
    }

    public String cacheDirectory() {
        return "output" + File.separator + this.repositoryTitle() + " " + new Integer(this.index()).toString() + File.separator;
    }

    public AFileTypeList fileTypesList() {
        return this.aFileTypeList;
    }

    protected AFtpReturnCode putShelfToHost(AGroupObject aGroupObject, String string, AFtp aFtp) {
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        this.tf.write("putShelfToHost()", 12, "Entry : " + string);
        if (this.hostType() == 5) {
            if (!AUtilities.CopyFile(string, aGroupObject.nameInRepository())) {
                this.tf.write("putShelfToHost()", 0, "Error copying " + string + " to " + aGroupObject.nameInRepository());
                aFtpReturnCode.setCommandCode(1);
            }
            aFtpReturnCode.setCommandCode(2);
            return aFtpReturnCode;
        }
        boolean bl = false;
        AStatusWindow.write("Uploading shelf " + aGroupObject.fileNameType() + " ...");
        if (aFtp == null) {
            aFtp = new AFtp();
            aFtp.setLogonParameters(new AFtpLogonParameters(this));
            aFtpReturnCode = aFtp.logon();
            if (aFtpReturnCode.getCommandCode() != 2) {
                this.tf.write("putShelfToHost()", 0, "Ftp logon error:" + aFtpReturnCode.getCommandCode());
                aFtp.quit();
                return aFtpReturnCode;
            }
            bl = true;
        }
        if (this.hostType() == 1) {
            aFtpReturnCode = aFtp.quote("SITE RECFM=VB LRECL=259");
            aFtpReturnCode = aFtp.quote("SITE TRACK PRIMARY=1 SECONDARY=1");
            Vector vector = this.ftpSiteCommands(2);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                aFtpReturnCode = aFtp.quote((String)enumeration.nextElement());
            }
        }
        aFtpReturnCode = aFtp.ascii();
        aFtpReturnCode = aFtp.put(string, aGroupObject.nameInRepository());
        if (aFtpReturnCode.getCommandCode() != 2) {
            this.tf.write("putShelfToHost()", 0, "Ftp put error:" + aFtpReturnCode.getCommandCode());
            AUtilities.showInfoMessage("The shelf was not updated due to an FTP error.");
            return aFtpReturnCode;
        }
        if (bl) {
            aFtp.quit();
        }
        AStatusWindow.write("Uploaded shelf " + aGroupObject.fileNameType());
        this.tf.write("putShelfToHost()", 12, "Exit : " + string);
        return aFtpReturnCode;
    }

    private void setIndex(int n) {
        this.iIndex = n;
    }

    public int index() {
        return this.iIndex;
    }

    public void setHostType(hostTypeEnum hostTypeEnum2) {
        this.iHostType = hostTypeEnum2;
    }

    public int hostType() {
        return this.iHostType.getValue();
    }

    public void setFtpHost(String string) {
        this.iFtpHost = string;
    }

    public String ftpHost() {
        return this.iFtpHost;
    }

    public void setFtpUserid(String string) {
        this.iFtpUserid = string;
    }

    public String ftpUserid() {
        return this.iFtpUserid;
    }

    private void setFtpAccount(String string) {
        this.iFtpAccount = string;
    }

    public String ftpAccount() {
        return this.iFtpAccount;
    }

    public void setFtpPassword(String string) {
        this.iFtpPassword = string;
    }

    public String ftpPassword() {
        return this.iFtpPassword;
    }

    public void setFtpPort(String string) {
        this.iFtpPort = string;
    }

    public String ftpPort() {
        return this.iFtpPort;
    }

    public void setFtpSavePassword(boolean bl) {
        this.iFtpSavePassword = bl;
    }

    public boolean ftpSavePassword() {
        return this.iFtpSavePassword;
    }

    public void setCommonFtpSiteCommands(String string) {
        this.iCommonFtpSiteCommands = string;
    }

    public String commonFtpSiteCommands() {
        return this.iCommonFtpSiteCommands;
    }

    Vector commonFtpSiteCommandsAsVector() {
        String string = this.commonFtpSiteCommands();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2);
        }
        return vector;
    }

    private void setFtpPasswordVerified(boolean bl) {
        this.iFtpPasswordVerified = bl;
    }

    public boolean ftpPasswordVerified() {
        return this.iFtpPasswordVerified;
    }

    public void setSoftcopyDirectories(String string) {
        this.iSoftcopyDirectories = string;
    }

    public String softcopyDirectories() {
        return this.iSoftcopyDirectories;
    }

    public void setIndexDirectories(String string) {
        this.iIndexDirectories = string;
    }

    public String indexDirectories() {
        return this.iIndexDirectories;
    }

    public void setShelvesDirectories(String string) {
        this.iShelvesDirectories = string;
    }

    public String shelvesDirectories() {
        return this.iShelvesDirectories;
    }

    public void setPDFDirectories(String string) {
        this.iPDFDirectories = string;
    }

    public String pdfDirectories() {
        return this.iPDFDirectories;
    }

    public String ftpBlkSize(int n) {
        String string = "";
        ARepositorySettings aRepositorySettings = this.fileTypesList().getObject(n);
        if (n == 3) {
            return "8000";
        }
        string = aRepositorySettings.blkSize();
        int n2 = string.indexOf(32);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    Vector ftpSiteCommands(int n) {
        Vector<String> vector;
        block20: {
            ARepositorySettings aRepositorySettings;
            ARepositorySettings aRepositorySettings2;
            block19: {
                vector = new Vector<String>();
                aRepositorySettings2 = this.fileTypesList().getObject(n);
                aRepositorySettings = this.fileTypesList().getObject(0);
                String string = "SITE ";
                if (aRepositorySettings2.dataClass().length() > 0) {
                    string = string + "DATACLASS=" + aRepositorySettings2.dataClass() + " ";
                } else if (aRepositorySettings.dataClass().length() > 0) {
                    string = string + "DATACLASS=" + aRepositorySettings.dataClass() + " ";
                }
                if (aRepositorySettings2.mgmtClass().length() > 0) {
                    string = string + "MGMTCLASS=" + aRepositorySettings2.mgmtClass() + " ";
                } else if (aRepositorySettings.mgmtClass().length() > 0) {
                    string = string + "MGMTCLASS=" + aRepositorySettings.mgmtClass() + " ";
                }
                if (aRepositorySettings2.storClass().length() > 0) {
                    string = string + "STORCLASS=" + aRepositorySettings2.storClass() + " ";
                } else if (aRepositorySettings.storClass().length() > 0) {
                    string = string + "STORCLASS=" + aRepositorySettings.storClass() + " ";
                }
                if (aRepositorySettings2.blkSize().length() > 0) {
                    string = string + "BLOCKSIZE=" + this.ftpBlkSize(n) + " ";
                }
                if (aRepositorySettings2.volume().length() > 0) {
                    string = string + "VOLUME=" + aRepositorySettings2.volume() + " ";
                } else if (aRepositorySettings.volume().length() > 0) {
                    string = string + "VOLUME=" + aRepositorySettings.volume() + " ";
                }
                if (aRepositorySettings2.unit().length() > 0) {
                    string = string + "UNIT=" + aRepositorySettings2.unit() + " ";
                } else if (aRepositorySettings.unit().length() > 0) {
                    string = string + "UNIT=" + aRepositorySettings.unit() + " ";
                }
                if (!string.equals("SITE ")) {
                    vector.addElement(string);
                }
                if (aRepositorySettings2.siteCommands().length() <= 0) break block19;
                String string2 = aRepositorySettings2.siteCommands();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    vector.addElement(string3);
                }
                break block20;
            }
            if (aRepositorySettings.siteCommands().length() <= 0) break block20;
            String string = aRepositorySettings2.siteCommands();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                vector.addElement(string4);
            }
        }
        return vector;
    }

    public int read(LineNumberReader lineNumberReader, int n) {
        this.tf.write("read()", 12, "Entry");
        int n2 = 0;
        String string = LABEL_REPOSITORY.trim();
        n2 = this.parseValue(lineNumberReader, string, LABEL_INDEX);
        if (n2 > 0) {
            return n2;
        }
        if (this.iValue.length() == 0) {
            return 4;
        }
        this.setIndex(new Integer(this.iValue));
        ARepository.resetIndexCounter(this.index());
        n2 = this.parseValue(lineNumberReader, string, LABEL_TITLE);
        if (n2 > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setRepositoryTitle(this.iValue);
        }
        this.tf.write("read()", 12, "Rep. Title - " + this.repositoryTitle());
        n2 = this.parseValue(lineNumberReader, string, LABEL_ACCESSMETHOD);
        if (n2 > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            // empty if block
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_HOSTTYPE)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setHostType(new hostTypeEnum(new Integer(this.iValue)));
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPHOST)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpHost(this.iValue);
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPUSERID)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpUserid("");
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPPASSWORD)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpPassword("");
        }
        this.tf.write("read() : ", 13, "ftpHost():" + this.ftpHost() + ", ftpUserid():" + this.ftpUserid());
        AHostObject aHostObject = AMainWindow.userProperties.getHostObject(this.ftpHost());
        this.tf.write("read() : ", 13, "ftpHost():" + this.ftpHost() + ", aHostObject:" + aHostObject);
        if (aHostObject != null) {
            this.setFtpUserid(aHostObject.userid());
            this.setFtpPassword(aHostObject.password());
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPSAVEPASSWORD)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            boolean bl = false;
            if (this.iValue.equals("1")) {
                bl = true;
            }
            this.setFtpSavePassword(bl);
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPACCOUNT)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpAccount(this.iValue);
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPPORT)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpPort(this.iValue);
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_SOFTCOPYDIRECTORIES)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setSoftcopyDirectories(this.translate(this.iValue));
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_SHELVESDIRECTORIES)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setShelvesDirectories(this.translate(this.iValue));
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_PDFDIRECTORIES)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setPDFDirectories(this.translate(this.iValue));
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPSITECOMMANDS)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            String string2 = this.iValue.replace('~', '\r');
            string2 = string2.replace('#', '\n');
            this.setCommonFtpSiteCommands(string2);
        }
        if (n > 4) {
            n2 = this.parseValue(lineNumberReader, string, LABEL_INDEXDIRECTORIES);
            if (n2 > 0) {
                return n2;
            }
            if (this.iValue.length() > 0) {
                this.setIndexDirectories(this.translate(this.iValue));
            }
        } else if (this.hostType() != 1) {
            String string3 = this.softcopyDirectories();
            int n3 = string3.indexOf("\t");
            if (n3 != -1) {
                string3 = string3.substring(0, n3);
            }
            this.setIndexDirectories(string3);
        }
        if (this.hostType() == 1) {
            Enumeration enumeration = this.aFileTypeList.elements();
            while (enumeration.hasMoreElements()) {
                this.aRepositorySettingsObject = (ARepositorySettings)enumeration.nextElement();
                n2 = this.readSettingsForFileTypes(lineNumberReader, this.aRepositorySettingsObject, string);
                if (n2 <= 0) continue;
                return n2;
            }
        }
        this.tf.write("read()", 12, "Exit:" + n2);
        return 0;
    }

    public int read(LineNumberReader lineNumberReader, int n, boolean bl) {
        int n2 = 0;
        String string = LABEL_REPOSITORY.trim();
        this.tf.write("read()", 12, "Entry");
        n2 = this.parseValue(lineNumberReader, string, LABEL_INDEX);
        if (n2 > 0) {
            return n2;
        }
        if (this.iValue.length() == 0) {
            return 4;
        }
        this.setIndex(new Integer(this.iValue));
        ARepository.resetIndexCounter(this.index());
        n2 = this.parseValue(lineNumberReader, string, LABEL_TITLE);
        if (n2 > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setRepositoryTitle(this.decrypt(this.iValue).trim());
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_ACCESSMETHOD)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            // empty if block
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_HOSTTYPE)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setHostType(new hostTypeEnum(new Integer(this.iValue)));
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPHOST)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpHost(this.decrypt(this.iValue).trim());
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPUSERID)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpUserid(this.decrypt(this.iValue));
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPPASSWORD)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpPassword(this.decrypt(this.iValue));
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPSAVEPASSWORD)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            boolean bl2 = false;
            if (this.iValue.equals("1")) {
                bl2 = true;
            }
            this.setFtpSavePassword(bl2);
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPACCOUNT)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpAccount(this.iValue);
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_FTPPORT)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setFtpPort(this.iValue);
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_SOFTCOPYDIRECTORIES)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setSoftcopyDirectories(this.translate(this.iValue));
        }
        if ((n2 = this.parseValue(lineNumberReader, string, LABEL_SHELVESDIRECTORIES)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            this.setShelvesDirectories(this.translate(this.iValue));
        }
        this.setPDFDirectories("");
        this.setCommonFtpSiteCommands("");
        this.setIndexDirectories("");
        if (this.hostType() != 1) {
            String string2 = this.softcopyDirectories();
            int n3 = string2.indexOf("\r");
            if (n3 != -1) {
                string2 = string2.substring(0, n3);
            }
            this.setIndexDirectories(string2);
        }
        if (this.hostType() == 1) {
            ARepositorySettings aRepositorySettings = null;
            ARepositorySettings aRepositorySettings2 = null;
            Enumeration enumeration = this.aFileTypeList.elements();
            while (enumeration.hasMoreElements()) {
                this.aRepositorySettingsObject = (ARepositorySettings)enumeration.nextElement();
                if (this.aRepositorySettingsObject.fileType() == 5) {
                    aRepositorySettings = this.aRepositorySettingsObject;
                    continue;
                }
                n2 = this.readSettingsForFileTypes(lineNumberReader, this.aRepositorySettingsObject, string, true);
                if (n2 > 0) {
                    return n2;
                }
                if (this.aRepositorySettingsObject.fileType() != 1) continue;
                aRepositorySettings2 = this.aRepositorySettingsObject;
            }
            aRepositorySettings.setDataClass(aRepositorySettings2.dataClass());
            aRepositorySettings.setMgmtClass(aRepositorySettings2.mgmtClass());
            aRepositorySettings.setStorClass(aRepositorySettings2.storClass());
            aRepositorySettings.setUnit(aRepositorySettings2.unit());
            aRepositorySettings.setVolume(aRepositorySettings2.volume());
            aRepositorySettings.setSiteCommands(aRepositorySettings2.siteCommands());
            String string3 = aRepositorySettings2.hlqs();
            int n4 = string3.indexOf("\r");
            if (n4 != -1) {
                string3 = string3.substring(0, n4);
            }
            aRepositorySettings.setHLQ(string3.trim());
            aRepositorySettings.setBLKSize(aRepositorySettings2.blkSize());
        }
        this.tf.write("read()", 12, "Exit");
        return 0;
    }

    private int readSettingsForFileTypes(BufferedReader bufferedReader, ARepositorySettings aRepositorySettings, String string) {
        int n;
        int n2 = 0;
        n2 = this.parseValue(bufferedReader, string, LABEL_FILETYPE);
        if (n2 > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            int n3 = new Integer(this.iValue.trim());
            aRepositorySettings.setFiletype(new fileTypeEnum(n3));
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_DATACLASS)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setDataClass(this.iValue.trim());
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_MGMTCLASS)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setMgmtClass(this.iValue.trim());
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_STORCLASS)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setStorClass(this.iValue.trim());
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_UNIT)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setUnit(this.iValue.trim());
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_VOLUME)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setVolume(this.iValue.trim());
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_FTP_CMDS)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setSiteCommands(this.iValue.trim());
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_HLQS)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            String string2 = this.translate(this.iValue);
            aRepositorySettings.setHLQS(string2);
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_HLQ)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setHLQ(this.iValue.trim());
        } else {
            String string3 = aRepositorySettings.hlqs();
            n = string3.indexOf("\t");
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
            aRepositorySettings.setHLQ(string3);
        }
        n2 = this.parseValue(bufferedReader, string, LABEL_BKLSHELFNAME);
        if (n2 > 0) {
            return n2;
        }
        if (this.iValue.length() > 0 && aRepositorySettings.fileType() == 3) {
            String string4 = "";
            string4 = aRepositorySettings.hlq().length() == 0 ? this.iValue.trim() : "'" + AUtilities.strip(aRepositorySettings.hlq(), '\'') + "." + this.iValue.trim() + "'";
            n = string4.indexOf(".BKLSHELF");
            if (n != -1) {
                string4 = string4.substring(0, n) + "'";
            }
            aRepositorySettings.setBKLShelfName(string4);
        }
        if ((n2 = this.parseValue(bufferedReader, string, LABEL_BLKSIZE)) > 0) {
            return n2;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setBLKSize(this.iValue.trim());
        }
        if (aRepositorySettings.fileType() == 2 || aRepositorySettings.fileType() == 5) {
            aRepositorySettings.setHLQS("");
        } else if (aRepositorySettings.fileType() == 1) {
            aRepositorySettings.setHLQ("");
        } else if (aRepositorySettings.fileType() == 3) {
            aRepositorySettings.setHLQS("");
            aRepositorySettings.setHLQ("");
        }
        return 0;
    }

    private int readSettingsForFileTypes(BufferedReader bufferedReader, ARepositorySettings aRepositorySettings, String string, boolean bl) {
        int n = 0;
        n = this.parseValue(bufferedReader, string, LABEL_FILETYPE);
        if (n > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            int n2 = new Integer(this.iValue.trim());
            aRepositorySettings.setFiletype(new fileTypeEnum(n2));
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_DATACLASS)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setDataClass(this.iValue.trim());
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_MGMTCLASS)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setMgmtClass(this.iValue.trim());
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_STORCLASS)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setStorClass(this.iValue.trim());
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_UNIT)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setUnit(this.iValue.trim());
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_VOLUME)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setVolume(this.iValue.trim());
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_FTP_CMDS)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setSiteCommands(this.iValue.trim());
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_HLQS)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setHLQS(this.translate(this.iValue));
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_HLQ)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setHLQ(this.iValue.trim());
        }
        if (aRepositorySettings.fileType() == 2) {
            aRepositorySettings.setHLQ(aRepositorySettings.hlqs());
        }
        if ((n = this.parseValue(bufferedReader, string, LABEL_BKLSHELFNAME)) > 0) {
            return n;
        }
        if (this.iValue.length() > 0 && aRepositorySettings.fileType() == 3) {
            String string2 = "";
            string2 = aRepositorySettings.hlq().length() == 0 ? this.iValue.trim() : "'" + AUtilities.strip(aRepositorySettings.hlq(), '\'') + "." + this.iValue.trim() + "'";
            int n3 = string2.indexOf(".BKLSHELF");
            if (n3 != -1) {
                string2 = string2.substring(0, n3) + "'";
            }
            aRepositorySettings.setBKLShelfName(string2);
        }
        if (aRepositorySettings.fileType() == 2) {
            aRepositorySettings.setHLQS("");
        } else if (aRepositorySettings.fileType() == 1) {
            aRepositorySettings.setHLQ("");
        } else if (aRepositorySettings.fileType() == 3) {
            aRepositorySettings.setHLQS("");
            aRepositorySettings.setHLQ("");
        }
        n = this.parseValue(bufferedReader, string, LABEL_BLKSIZE);
        if (n > 0) {
            return n;
        }
        if (this.iValue.length() > 0) {
            aRepositorySettings.setBLKSize(this.iValue.trim());
        }
        return 0;
    }

    private String decrypt(String string) {
        int n = string.length();
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            long l;
            long l2 = Long.parseLong(string.substring(n2, n2 + 4), 16) - 9922L;
            byte[] byArray = new byte[2];
            if (l2 / 256L != 0L) {
                l = l2 / 256L;
                long l3 = l2 % 256L;
                byArray[0] = (byte)l;
                byArray[1] = (byte)l3;
            } else {
                l = l2 % 256L;
                byArray[0] = (byte)l;
            }
            string2 = string2 + new String(byArray);
            n2 += 4;
        }
        return string2;
    }

    public int write(PrintStream printStream) {
        String string = ACatalog.LEFTSQUAREBRACE + LABEL_REPOSITORY + this.index() + ACatalog.SPACE;
        printStream.println(string + LABEL_INDEX + ACatalog.RIGHTSQUAREBRACE + this.index());
        printStream.println(string + LABEL_TITLE + ACatalog.RIGHTSQUAREBRACE + this.repositoryTitle());
        printStream.println(string + LABEL_ACCESSMETHOD + ACatalog.RIGHTSQUAREBRACE + "");
        printStream.println(string + LABEL_HOSTTYPE + ACatalog.RIGHTSQUAREBRACE + this.hostType());
        printStream.println(string + LABEL_FTPHOST + ACatalog.RIGHTSQUAREBRACE + this.ftpHost());
        printStream.println(string + LABEL_FTPUSERID + ACatalog.RIGHTSQUAREBRACE + "");
        printStream.println(string + LABEL_FTPPASSWORD + ACatalog.RIGHTSQUAREBRACE + "");
        int n = 0;
        if (this.ftpSavePassword()) {
            n = 1;
        }
        printStream.println(string + LABEL_FTPSAVEPASSWORD + ACatalog.RIGHTSQUAREBRACE + n);
        printStream.println(string + LABEL_FTPACCOUNT + ACatalog.RIGHTSQUAREBRACE + this.ftpAccount());
        printStream.println(string + LABEL_FTPPORT + ACatalog.RIGHTSQUAREBRACE + this.ftpPort());
        String string2 = this.softcopyDirectories().replace('\n', '\t');
        printStream.println(string + LABEL_SOFTCOPYDIRECTORIES + ACatalog.RIGHTSQUAREBRACE + string2);
        string2 = this.shelvesDirectories().replace('\n', '\t');
        printStream.println(string + LABEL_SHELVESDIRECTORIES + ACatalog.RIGHTSQUAREBRACE + string2);
        string2 = this.pdfDirectories().replace('\n', '\t');
        printStream.println(string + LABEL_PDFDIRECTORIES + ACatalog.RIGHTSQUAREBRACE + string2);
        string2 = this.commonFtpSiteCommands().replace('\n', '\t');
        printStream.println(string + LABEL_FTPSITECOMMANDS + ACatalog.RIGHTSQUAREBRACE + string2);
        printStream.println(string + LABEL_INDEXDIRECTORIES + ACatalog.RIGHTSQUAREBRACE + this.indexDirectories());
        if (this.hostType() == 1) {
            Enumeration enumeration = this.aFileTypeList.elements();
            while (enumeration.hasMoreElements()) {
                ARepositorySettings aRepositorySettings = (ARepositorySettings)enumeration.nextElement();
                int n2 = this.writeSettingsForFileTypes(printStream, aRepositorySettings);
                if (n2 <= 0) continue;
                return n2;
            }
        }
        return 0;
    }

    private int writeSettingsForFileTypes(PrintStream printStream, ARepositorySettings aRepositorySettings) {
        String string = ACatalog.LEFTSQUAREBRACE + LABEL_REPOSITORY + this.index() + ACatalog.SPACE;
        printStream.println(string + LABEL_FILETYPE + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.fileType());
        printStream.println(string + LABEL_DATACLASS + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.dataClass());
        printStream.println(string + LABEL_MGMTCLASS + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.mgmtClass());
        printStream.println(string + LABEL_STORCLASS + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.storClass());
        printStream.println(string + LABEL_UNIT + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.unit());
        printStream.println(string + LABEL_VOLUME + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.volume());
        printStream.println(string + LABEL_FTP_CMDS + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.siteCommands());
        String string2 = aRepositorySettings.hlqs().replace('\n', '\t');
        printStream.println(string + LABEL_HLQS + ACatalog.RIGHTSQUAREBRACE + string2);
        printStream.println(string + LABEL_HLQ + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.hlq());
        printStream.println(string + LABEL_BKLSHELFNAME + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.bklShelfName());
        printStream.println(string + LABEL_BLKSIZE + ACatalog.RIGHTSQUAREBRACE + aRepositorySettings.blkSize());
        return 0;
    }

    private String translate(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < string2.length() && n2 != -1) {
            n2 = string2.indexOf("~#", n);
            if (n2 != -1) {
                if (n == 0) {
                    stringBuffer.append(string2.substring(0, n2) + "\t");
                } else {
                    stringBuffer.append(string2.substring(n, n2) + "\t");
                }
            } else {
                stringBuffer.append(string2.substring(n));
            }
            n = n2 + 2;
        }
        String string3 = stringBuffer.toString().replace('\t', '\n');
        return string3;
    }

    private int parseValue(BufferedReader bufferedReader, String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        try {
            string3 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tf.write("ARepository", 23, "parseValue() aLine:" + string3);
        this.tf.write("ARepository", 23, "parseValue() inType:" + string + ", inKeyWord:" + string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "[] ");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            ++n2;
            if (string6.equals(string)) {
                bl = true;
            } else if (string6.equals(string2) && n2 > 2) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            if (n == 3) {
                string6 = "";
                break;
            }
            if (n2 != 3) break;
            string6 = stringTokenizer.nextToken("]");
            break;
        }
        if (!bl || !bl2) {
            return 4;
        }
        this.iValue = string6.trim();
        this.tf.write("ARepository", 23, "parseValue() Last strToken value:" + this.iValue);
        return 0;
    }

    protected Object clone() throws CloneNotSupportedException {
        ARepository aRepository = (ARepository)super.clone();
        if (this.hostType() == 1) {
            aRepository.aFileTypeList = (AFileTypeList)this.aFileTypeList.clone();
            Enumeration enumeration = this.aFileTypeList.elements();
            while (enumeration.hasMoreElements()) {
                ARepositorySettings aRepositorySettings = (ARepositorySettings)enumeration.nextElement();
                ARepositorySettings aRepositorySettings2 = (ARepositorySettings)aRepositorySettings.clone();
                aRepository.aFileTypeList.set(this.aFileTypeList.indexOf(aRepositorySettings), aRepositorySettings2);
            }
        }
        return aRepository;
    }

    static {
        LABELREPOSITORYVERSION = new String("[repositoryVersion]");
        REPOSITORYVERSION = new String("5");
        LABELNUMBERREPOSITORIES = new String("[numberRepositories]");
        LABEL_REPOSITORY = new String("R ");
        LABEL_INDEX = new String("01");
        LABEL_TITLE = new String("02");
        LABEL_ACCESSMETHOD = new String("03");
        LABEL_HOSTTYPE = new String("04");
        LABEL_FTPHOST = new String("05");
        LABEL_FTPUSERID = new String("06");
        LABEL_FTPPASSWORD = new String("07");
        LABEL_FTPSAVEPASSWORD = new String("08");
        LABEL_FTPACCOUNT = new String("09");
        LABEL_FTPPORT = new String("10");
        LABEL_SOFTCOPYDIRECTORIES = new String("11");
        LABEL_SHELVESDIRECTORIES = new String("12");
        LABEL_PDFDIRECTORIES = new String("13");
        LABEL_FTPSITECOMMANDS = new String("14");
        LABEL_INDEXDIRECTORIES = new String("26");
        LABEL_FILETYPE = new String("15");
        LABEL_DATACLASS = new String("16");
        LABEL_MGMTCLASS = new String("17");
        LABEL_STORCLASS = new String("18");
        LABEL_UNIT = new String("19");
        LABEL_VOLUME = new String("20");
        LABEL_FTP_CMDS = new String("21");
        LABEL_HLQS = new String("22");
        LABEL_HLQ = new String("23");
        LABEL_BKLSHELFNAME = new String("24");
        LABEL_BLKSIZE = new String("25");
    }
}

