/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class AProxyPanel
extends ABaseInternalFrame
implements ActionListener {
    private JLabel mainLabel;
    private JLabel infoLabel;
    private JLabel typeLabel;
    private JLabel proxyNameLabel;
    private JLabel proxyPortLabel;
    private JLabel autoConfigLabel;
    private ButtonGroup radioButtonGroup;
    private JRadioButton directRadioButton;
    private JRadioButton manualRadioButton;
    private JRadioButton autoRadioButton;
    private JButton okButton;
    private JButton cancelButton;
    private AMainWindow owner;
    private AProxy aProxyObject = null;
    private JMenuItem itemProxyPanel;
    private JTextField socksField;
    private JTextField socksPortField;
    private JTextField autoConfigField;
    private JTextField ftpField;
    private JTextField ftpPortField;
    private JTextField httpField;
    private JTextField httpPortField;
    private JLabel ftpLabel;
    private JLabel httpLabel;
    private JLabel socksLabel;
    private ATraceFile tf;

    AProxyPanel(AMainWindow aMainWindow, AProxy aProxy) {
        super("Proxy Settings", true, true, true, true);
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.setSize(new Dimension(650, 450));
        this.setLocation(new Point(80, 80));
        this.tf = new ATraceFile(this);
        this.owner = aMainWindow;
        this.aProxyObject = aProxy;
        this.itemProxyPanel = aMainWindow.getWindowMenu().add(new JMenuItem(this.getTitle()));
        this.itemProxyPanel.addActionListener(aMainWindow);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 20, 10, 0));
        jPanel6.setBorder(compoundBorder);
        JPanel jPanel7 = jPanel5 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel7.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        this.infoLabel = new JLabel("<html><H3>The Softcopy Librarian can connect to the Internet to:</H3><LI>Download and install softcopy files (eg. BookManager books) from<br> Internet into your repository.<LI>Check for and install newer versions of the Softcopy Librarian.</LI><H3>Select your connection type :</H3></HTML>");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel7, this.infoLabel);
        JPanel jPanel8 = jPanel4 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel8.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        this.radioButtonGroup = new ButtonGroup();
        this.directRadioButton = new JRadioButton(" Direct connection to the internet");
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel8, this.directRadioButton);
        this.manualRadioButton = new JRadioButton(" Manual proxy configuration");
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel8, this.manualRadioButton);
        JPanel jPanel9 = jPanel3 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        jPanel9.setLayout(gridBagLayout3);
        gridBagConstraints3.fill = 1;
        this.typeLabel = new JLabel("Type");
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0, 40, 10, 30);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.typeLabel);
        this.proxyNameLabel = new JLabel("Proxy address");
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0, 0, 10, 30);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.proxyNameLabel);
        this.proxyPortLabel = new JLabel("Port");
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 4;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0, 0, 10, 40);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.proxyPortLabel);
        this.httpLabel = new JLabel("HTTP");
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new Insets(0, 40, 0, 40);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.httpLabel);
        this.httpField = new JTextField(25);
        gridBagConstraints3.weightx = 0.1;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 30);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.httpField);
        this.httpPortField = new JTextField(10);
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 4;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 40);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.httpPortField);
        this.socksLabel = new JLabel("Socks");
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.insets = new Insets(0, 40, 0, 40);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.socksLabel);
        this.socksField = new JTextField(25);
        gridBagConstraints3.weightx = 0.1;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 30);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.socksField);
        this.socksPortField = new JTextField(10);
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 4;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 40);
        this.addToGrid(gridBagConstraints3, gridBagLayout3, jPanel9, this.socksPortField);
        JPanel jPanel10 = jPanel2 = new JPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        jPanel10.setLayout(gridBagLayout4);
        gridBagConstraints4.fill = 1;
        this.autoRadioButton = new JRadioButton(" Auto proxy configuration");
        gridBagConstraints4.weightx = 0.1;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
        this.addToGrid(gridBagConstraints4, gridBagLayout4, jPanel10, this.autoRadioButton);
        this.autoConfigLabel = new JLabel("Use automatic configuration script:");
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.insets = new Insets(0, 20, 0, 0);
        this.addToGrid(gridBagConstraints4, gridBagLayout4, jPanel10, this.autoConfigLabel);
        this.autoConfigField = new JTextField(25);
        gridBagConstraints4.weightx = 0.1;
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 10);
        this.addToGrid(gridBagConstraints4, gridBagLayout4, jPanel10, this.autoConfigField);
        this.radioButtonGroup.add(this.directRadioButton);
        this.radioButtonGroup.add(this.manualRadioButton);
        this.radioButtonGroup.add(this.autoRadioButton);
        JPanel jPanel11 = jPanel = new JPanel();
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        jPanel11.setLayout(gridBagLayout5);
        gridBagConstraints5.fill = 2;
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic('O');
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = new Insets(10, 0, 10, 10);
        gridBagLayout5.setConstraints(this.okButton, gridBagConstraints5);
        jPanel11.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        gridBagConstraints5.gridx = 4;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = new Insets(10, 0, 10, 10);
        gridBagLayout5.setConstraints(this.cancelButton, gridBagConstraints5);
        jPanel11.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.directRadioButton.addActionListener(this);
        this.manualRadioButton.addActionListener(this);
        this.autoRadioButton.addActionListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jPanel6);
        jPanel6.add(jPanel5);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel2);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel11, "South");
        MyInternalFrameListener myInternalFrameListener = new MyInternalFrameListener();
        this.addInternalFrameListener(myInternalFrameListener);
        this.preparePanel();
        this.setVisible(true);
    }

    public void preparePanel() {
        if (this.aProxyObject.connectionType() == AProxy.DIRECT) {
            this.directRadioButton.setSelected(true);
            this.direct();
        } else if (this.aProxyObject.connectionType() == AProxy.MANUAL_PROXY) {
            this.manualRadioButton.setSelected(true);
            this.manual();
        } else if (this.aProxyObject.connectionType() == AProxy.AUTO_PROXY) {
            this.autoRadioButton.setSelected(true);
            this.auto();
        }
        this.autoConfigField.setText(this.aProxyObject.urlPath());
        this.httpField.setText(this.aProxyObject.httpProxyName());
        this.httpPortField.setText(String.valueOf(this.aProxyObject.httpProxyPort()));
        this.socksField.setText(this.aProxyObject.socksProxyName());
        this.socksPortField.setText(String.valueOf(this.aProxyObject.socksProxyPort()));
        if (this.httpPortField.getText().length() == 0) {
            this.httpPortField.setText("1080");
        }
        if (this.socksPortField.getText().length() == 0) {
            this.socksPortField.setText("1080");
        }
    }

    public boolean saveSettings() {
        if (this.directRadioButton.isSelected()) {
            this.aProxyObject.setConnectionType(AProxy.DIRECT);
        } else if (this.manualRadioButton.isSelected()) {
            Integer n;
            this.aProxyObject.setConnectionType(AProxy.MANUAL_PROXY);
            if (this.httpField.getText().trim().length() == 0 && this.socksField.getText().trim().length() == 0) {
                AUtilities.showInfoMessage("Enter atleast one proxy name");
                return false;
            }
            this.aProxyObject.setHttpProxyName(this.httpField.getText().trim());
            this.aProxyObject.setSocksProxyName(this.socksField.getText().trim());
            if (this.httpPortField.getText().trim().length() > 0) {
                n = new Integer(this.httpPortField.getText().trim());
                this.aProxyObject.setHttpProxyPort(n);
            }
            if (this.socksPortField.getText().trim().length() > 0) {
                n = new Integer(this.socksPortField.getText().trim());
                this.aProxyObject.setSocksProxyPort(n);
            }
        } else if (this.autoRadioButton.isSelected()) {
            this.aProxyObject.setConnectionType(AProxy.AUTO_PROXY);
            String string = this.autoConfigField.getText().trim();
            if (string.length() == 0) {
                AUtilities.showInfoMessage("Enter the path to the configuration script");
                this.autoConfigField.requestFocus();
                return false;
            }
            this.aProxyObject.setURLPath(string);
        }
        AMainWindow.userProperties.aProxyObject = this.aProxyObject;
        return true;
    }

    private void direct() {
        this.typeLabel.setEnabled(false);
        this.proxyNameLabel.setEnabled(false);
        this.proxyPortLabel.setEnabled(false);
        this.httpLabel.setEnabled(false);
        this.socksLabel.setEnabled(false);
        this.httpField.setEnabled(false);
        this.httpPortField.setEnabled(false);
        this.socksField.setEnabled(false);
        this.socksPortField.setEnabled(false);
        this.autoConfigLabel.setEnabled(false);
        this.autoConfigField.setEnabled(false);
    }

    private void manual() {
        this.typeLabel.setEnabled(true);
        this.proxyNameLabel.setEnabled(true);
        this.proxyPortLabel.setEnabled(true);
        this.httpLabel.setEnabled(true);
        this.socksLabel.setEnabled(true);
        this.httpField.setEnabled(true);
        this.httpPortField.setEnabled(true);
        this.socksField.setEnabled(true);
        this.socksPortField.setEnabled(true);
        this.autoConfigLabel.setEnabled(false);
        this.autoConfigField.setEnabled(false);
    }

    private void auto() {
        this.typeLabel.setEnabled(false);
        this.proxyNameLabel.setEnabled(false);
        this.proxyPortLabel.setEnabled(false);
        this.httpLabel.setEnabled(false);
        this.socksLabel.setEnabled(false);
        this.httpField.setEnabled(false);
        this.httpPortField.setEnabled(false);
        this.socksField.setEnabled(false);
        this.socksPortField.setEnabled(false);
        this.autoConfigLabel.setEnabled(true);
        this.autoConfigField.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand().trim();
        if (string.equals("OK")) {
            if (this.saveSettings()) {
                if (this.aProxyObject.connectionType() == AProxy.MANUAL_PROXY) {
                    AProxy.setProxyProperties("");
                }
                this.dispose();
            }
        } else if (string.equals("Cancel")) {
            this.dispose();
        } else if (string.equals("Direct connection to the internet")) {
            this.direct();
        } else if (string.equals("Manual proxy configuration")) {
            this.manual();
        } else if (string.equals("Auto proxy configuration")) {
            this.auto();
        }
    }

    protected void addToGrid(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, Container container, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    class MyInternalFrameListener
    extends InternalFrameAdapter {
        MyInternalFrameListener() {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            AProxyPanel.this.owner.getWindowMenu().remove(AProxyPanel.this.itemProxyPanel);
            AProxyPanel.this.owner.setProxyPanelClosed();
        }
    }
}

