/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class AProgressObject {
    private JFrame owner;
    private int maxCount;
    private AProgressBarWindow aProgWin;
    private boolean hideProgressBar = false;
    private boolean hideCancelButton = false;
    private int count = 0;
    private boolean processCanceled;
    private String aLabelText;
    private ATraceFile tf;
    private Runnable updateTextThread = new Runnable(){

        public void run() {
            AProgressObject.this.aProgWin.updateText(AProgressObject.this.aLabelText);
        }
    };
    private Runnable updateProgress = new Runnable(){

        public void run() {
            AProgressObject.this.aProgWin.updateProgressBar(AProgressObject.this.count);
        }
    };
    private Runnable closeWindow = new Runnable(){

        public void run() {
            AProgressObject.this.aProgWin.dispose();
        }
    };

    public AProgressObject(JFrame jFrame, int n, boolean bl, boolean bl2) {
        this.tf = new ATraceFile(this);
        this.tf.write("Contructor", 18, "Entry");
        this.maxCount = n;
        this.owner = jFrame;
        this.setHideCancelButton(bl);
        this.setHideProgressBar(bl2);
        this.createWindow();
        this.tf.write("Contructor", 18, "Exit");
    }

    public AProgressObject(JFrame jFrame, int n) {
        this.tf = new ATraceFile(this);
        this.tf.write("Contructor", 18, "Entry");
        this.maxCount = n;
        this.owner = jFrame;
        this.createWindow();
        this.tf.write("Contructor", 18, "Exit");
    }

    public AProgressObject(JFrame jFrame, int n, String string) {
        this.tf = new ATraceFile(this);
        this.tf.write("Contructor", 18, "Entry");
        this.maxCount = n;
        this.owner = jFrame;
        this.createWindow();
        this.setText(string);
        this.tf.write("Contructor", 18, "Exit");
    }

    private void createWindow() {
        this.aProgWin = new AProgressBarWindow(this.maxCount);
        this.processCanceled = false;
        this.aProgWin.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AProgressObject.this.processCanceled = true;
                AProgressObject.this.tf.write("createWindow()", 18, "Process Canceled:" + AProgressObject.this.processCanceled);
            }
        });
    }

    private void setHideProgressBar(boolean bl) {
        this.hideProgressBar = bl;
    }

    public boolean isProgressBarShown() {
        return this.hideProgressBar;
    }

    private void setHideCancelButton(boolean bl) {
        this.hideCancelButton = bl;
    }

    public boolean hideCancelButton() {
        return this.hideCancelButton;
    }

    public void run() {
    }

    public boolean isProcessCanceled() {
        return this.processCanceled;
    }

    public void reSize() {
        Dimension dimension = this.aProgWin.getSize();
        int n = new Double(dimension.getWidth()).intValue() + 20;
        int n2 = new Double(dimension.getHeight()).intValue() + 35;
        this.aProgWin.setSize(n, n2);
    }

    public synchronized void removeProgressObject() {
        this.tf.write("removeProgressObject()", 19, "Entry");
        SwingUtilities.invokeLater(this.closeWindow);
        this.tf.write("removeProgressObject()", 19, "Exit");
    }

    public synchronized void setText(String string) {
        this.aLabelText = string;
        SwingUtilities.invokeLater(this.updateTextThread);
    }

    public synchronized boolean update(int n) {
        if (this.processCanceled) {
            return false;
        }
        this.count = n;
        SwingUtilities.invokeLater(this.updateProgress);
        return true;
    }

    class AProgressBarWindow
    extends ABaseInternalFrame {
        private JProgressBar progressBar;
        private JLabel label;
        JPanel mainpanel;
        JPanel buttonpanel;
        public JButton cancelButton;
        private String newline = "\n";
        public int maxCount;
        private Thread runThread;
        public int INITIAL_WIDTH = 450;
        public int INITIAL_HEIGHT = 175;

        public AProgressBarWindow(int n) {
            super("SCL - Progress Status", true, true, true, true);
            this.maxCount = n;
            AProgressObject.this.tf.write("Contructor", 19, "Entry");
            this.mainpanel = new JPanel();
            this.mainpanel.setLayout(new BoxLayout(this.mainpanel, 1));
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 2;
            AProgressObject.this.tf.write("Contructor", 19, "maxCount:" + n);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = new Dimension(dimension.width, 20);
            this.progressBar = new JProgressBar(0, n);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.insets = new Insets(40, 40, 0, 40);
            this.addToGrid(gridBagConstraints, gridBagLayout, jPanel, this.progressBar);
            this.progressBar.setVisible(!AProgressObject.this.isProgressBarShown());
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            jPanel2.setLayout(gridBagLayout2);
            gridBagConstraints2.fill = 1;
            this.label = new JLabel("");
            this.label.setHorizontalAlignment(0);
            gridBagConstraints2.weightx = 0.1;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
            this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel2, this.label);
            this.buttonpanel = new JPanel(this){
                private final /* synthetic */ AProgressBarWindow this$1;
                {
                    this.this$1 = aProgressBarWindow;
                }

                public Insets getInsets() {
                    return new Insets(0, 0, 40, 0);
                }
            };
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setMnemonic('C');
            this.cancelButton.setHorizontalAlignment(0);
            this.buttonpanel.add((Component)this.cancelButton, "Center");
            this.cancelButton.setVisible(!AProgressObject.this.hideCancelButton());
            this.mainpanel.add(jPanel);
            this.mainpanel.add(jPanel2);
            this.mainpanel.add(this.buttonpanel);
            this.getContentPane().add(this.mainpanel);
            this.setDefaultCloseOperation(0);
            this.setSize(this.INITIAL_WIDTH, this.INITIAL_HEIGHT);
            this.setLocation(10, 25);
            this.setResizable(true);
            try {
                ((AMainWindow)AProgressObject.this.owner).getDeskTopPane().add(this);
                Thread.currentThread();
                Thread.sleep(1000L);
                this.show();
            }
            catch (Exception exception) {
                AProgressObject.this.tf.write("Constructor", 0, this.label.getText() + ", Exception occurred:" + exception.toString());
            }
            AProgressObject.this.tf.write("Contructor", 19, "Exit");
        }

        public void updateText(String string) {
            this.label.setText("<html>" + string + "</html>");
            this.show();
        }

        public void updateProgressBar(int n) {
            try {
                this.progressBar.setValue(n);
            }
            catch (Exception exception) {
                AProgressObject.this.tf.write("updateProgressBar()", 0, "Exception:" + exception.toString());
            }
        }

        protected void addToGrid(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, Container container, Component component) {
            gridBagLayout.setConstraints(component, gridBagConstraints);
            container.add(component);
        }

        class MyInternalFrameListener
        extends InternalFrameAdapter {
            MyInternalFrameListener() {
            }

            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                AProgressObject.this.tf.write("internalFrameClosed()", 19, "Internal frame closed");
            }
        }
    }
}

