/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class AFtpLogonWindow
extends JDialog
implements ActionListener {
    private ATraceFile tf = new ATraceFile(this);
    private JFrame owner;
    private String okayCommand = "okay";
    private String cancelCommand = "cancel";
    private boolean iUserCanceled = true;
    private JPanel mainPanel;
    private Container contentPane;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private JButton buttonOkay;
    private JButton buttonCancel;
    private JPanel buttonPanel;
    private JLabel hostLabel;
    private JLabel portLabel;
    private JLabel useridLabel;
    private JLabel passwordLabel;
    private JTextField hostData;
    private JTextField portData;
    private JTextField useridData;
    private JPasswordField passwordData;
    private JScrollPane messagePane;
    private JEditorPane messageData;
    private String userid;
    private String password;
    private AFtpLogonParameters aFtpLogonParameters;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean getUserCanceled() {
        return this.iUserCanceled;
    }

    public void setUserCanceled(boolean bl) {
        this.iUserCanceled = bl;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String string) {
        this.userid = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tf.write("actionPerformed()", 2, "entry");
        this.tf.write("actionPerformed()", 2, "Command is: \"" + actionEvent.getActionCommand() + "\"");
        if (actionEvent.getActionCommand().equals(this.okayCommand)) {
            this.okayButton();
        } else if (actionEvent.getActionCommand().equals(this.cancelCommand)) {
            this.cancelButton();
        }
        this.tf.write("actionPerformed", 2, "exit");
    }

    private void addToGrid(Component component, int n, int n2, double d, double d2, int n3, int n4) {
        this.c.gridx = n;
        this.c.gridy = n2;
        this.c.weightx = d;
        this.c.weighty = d2;
        this.c.fill = n3;
        this.c.gridwidth = n4;
        this.gridbag.setConstraints(component, this.c);
        this.contentPane.add(component);
    }

    public void cancelButton() {
        this.tf.write("cancelButton()", 1, "entry");
        this.setUserCanceled(true);
        this.closeMe();
        this.tf.write("cancelButton()", 1, "exit");
    }

    public void closeMe() {
        this.tf.write("closeMe()", 2, "entry");
        this.dispose();
        this.tf.write("closeMe()", 2, "exit");
    }

    public void okayButton() {
        this.tf.write("okayButton()", 1, "entry");
        this.setUserCanceled(false);
        String string = this.useridData.getText().trim();
        String string2 = new String(this.passwordData.getPassword()).trim();
        this.aFtpLogonParameters.setChanged(false);
        if (!string.equals(this.getUserid())) {
            this.aFtpLogonParameters.setUserid(string);
            this.setUserid(string);
        }
        if (!string2.equals(this.getPassword())) {
            this.aFtpLogonParameters.setPassword(string2);
            this.setPassword(string2);
        }
        this.closeMe();
        this.tf.write("okayButton()", 1, "exit");
    }

    public void setMessage(String string) {
        this.messageData.setText(string);
    }

    public void setMessage(Vector vector) {
        String string = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = string + (String)enumeration.nextElement() + AUtilities.LINE_SEPARATOR;
        }
        this.messageData.setText(string);
    }

    public AFtpLogonWindow(JFrame jFrame, AFtpLogonParameters aFtpLogonParameters, AFtpReturnCode aFtpReturnCode) {
        super(jFrame, "FTP Logon", true);
        String string = "";
        if (!aFtpReturnCode.getMessage().equals("")) {
            string = aFtpReturnCode.getMessage() + "<P>";
        }
        Enumeration enumeration = aFtpReturnCode.getServerResponse().elements();
        while (enumeration.hasMoreElements()) {
            string = string + (String)enumeration.nextElement() + "<br>";
        }
        Exception exception = aFtpReturnCode.getException();
        if (exception != null) {
            string = string + exception.toString();
        }
        this.doIt(jFrame, aFtpLogonParameters, string);
    }

    public AFtpLogonWindow(JFrame jFrame, AFtpLogonParameters aFtpLogonParameters, String string) {
        super(jFrame, "FTP Logon", true);
        this.doIt(jFrame, aFtpLogonParameters, string);
    }

    public AFtpLogonWindow(JFrame jFrame, AFtpLogonParameters aFtpLogonParameters) {
        super(jFrame, "FTP Logon", true);
        this.doIt(jFrame, aFtpLogonParameters, "");
    }

    private void doIt(JFrame jFrame, AFtpLogonParameters aFtpLogonParameters, String string) {
        this.tf.write("doIt()", 1, "entry");
        this.owner = jFrame;
        this.aFtpLogonParameters = aFtpLogonParameters;
        this.setUserid(aFtpLogonParameters.getUserid());
        this.setPassword(aFtpLogonParameters.getPassword());
        this.hostLabel = new JLabel("Host");
        this.hostData = new JTextField(aFtpLogonParameters.getHost(), 15);
        this.hostData.setEditable(false);
        this.portLabel = new JLabel("Port");
        this.portData = new JTextField(aFtpLogonParameters.getPort(), 4);
        this.portData.setEditable(false);
        this.portData.setMinimumSize(new Dimension(20, 0));
        this.useridLabel = new JLabel("Userid");
        this.useridData = new JTextField(aFtpLogonParameters.getUserid(), 15);
        this.useridData.setRequestFocusEnabled(true);
        this.passwordLabel = new JLabel("Password");
        this.passwordData = new JPasswordField(aFtpLogonParameters.getPassword(), 15);
        this.passwordData.setRequestFocusEnabled(true);
        this.messageData = new JEditorPane("text/html", "<html>" + string + "</html>");
        this.messageData.setMinimumSize(new Dimension(0, 80));
        this.messageData.setEditable(false);
        this.messageData.setBackground(this.passwordLabel.getBackground());
        this.messagePane = new JScrollPane(this.messageData);
        this.messagePane.setVerticalScrollBarPolicy(20);
        this.messagePane.setHorizontalScrollBarPolicy(30);
        this.messagePane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.buttonOkay = new JButton("OK");
        this.buttonOkay.setActionCommand(this.okayCommand);
        this.buttonOkay.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.setActionCommand(this.cancelCommand);
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.setNextFocusableComponent(this.useridData);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
        this.buttonPanel.add(this.buttonOkay);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.buttonPanel.add(this.buttonCancel);
        this.contentPane = this.getContentPane();
        this.gridbag = new GridBagLayout();
        this.contentPane.setLayout(this.gridbag);
        this.c = new GridBagConstraints();
        Dimension dimension = new Dimension(10, 10);
        Insets insets = new Insets(0, 10, 0, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        this.c.anchor = 17;
        this.addToGrid(new Box.Filler(dimension, dimension, dimension), 0, 0, 0.0, 0.2, 3, 1);
        this.c.insets = insets2;
        this.addToGrid(this.messagePane, 1, 1, 1.0, 0.8, 1, 4);
        this.addToGrid(new Box.Filler(dimension, dimension, dimension), 1, 2, 0.0, 0.2, 3, 1);
        this.addToGrid(this.hostLabel, 1, 3, 0.0, 0.0, 2, 1);
        this.c.insets = insets;
        this.addToGrid(this.hostData, 2, 3, 1.0, 0.0, 2, 1);
        this.c.insets = insets;
        this.addToGrid(this.portLabel, 3, 3, 0.0, 0.0, 2, 1);
        this.c.insets = insets;
        this.addToGrid(this.portData, 4, 3, 0.0, 0.0, 2, 1);
        this.addToGrid(new Box.Filler(dimension, dimension, dimension), 1, 4, 0.0, 0.0, 2, 1);
        this.c.insets = insets2;
        this.addToGrid(this.useridLabel, 1, 5, 0.0, 0.0, 2, 1);
        this.c.insets = insets;
        this.addToGrid(this.useridData, 2, 5, 1.0, 0.0, 2, 1);
        this.addToGrid(new Box.Filler(dimension, dimension, dimension), 1, 6, 0.0, 0.0, 2, 1);
        this.c.insets = insets2;
        this.addToGrid(this.passwordLabel, 1, 7, 0.0, 0.0, 2, 1);
        this.c.insets = insets;
        this.addToGrid(this.passwordData, 2, 7, 1.0, 0.0, 2, 1);
        this.addToGrid(new Box.Filler(dimension, dimension, dimension), 1, 8, 0.0, 0.2, 3, 1);
        this.addToGrid(this.buttonPanel, 1, 9, 1.0, 0.0, 2, 4);
        this.addToGrid(new Box.Filler(dimension, dimension, dimension), 5, 10, 0.0, 0.0, 2, 1);
        this.setDefaultCloseOperation(2);
        ((Component)this).setSize(500, 350);
        this.setLocationRelativeTo(jFrame);
        ((Component)this).setVisible(true);
        this.tf.write("doIt", 1, "exit");
    }
}

