/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import java.io.IOException;
import org.xml.sax.Locator;

final class StringReader
extends XMLReader {
    private StringPool fStringPool;
    private XMLDocumentHandler fDocumentHandler;
    private XMLErrorHandler fErrorHandler;
    private String fData;
    private int fEndOffset;
    private boolean oweLeadingSpace = false;
    private boolean oweTrailingSpace = false;

    StringReader(ParserState parserState, boolean bl, Locator locator, int n) {
        super(parserState, locator.getPublicId(), locator.getSystemId());
        this.fLinefeedCounter = locator.getLineNumber();
        this.fCharacterCounter = locator.getColumnNumber();
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fData = this.fStringPool.toString(n);
        this.fCurrentOffset = 0;
        this.fEndOffset = this.fData.length();
        if (bl) {
            this.oweLeadingSpace = true;
            this.oweTrailingSpace = true;
        }
    }

    public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
        chunkyCharArray.append(this.fData.substring(n, n + n2));
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fStringPool.addString(this.fData.substring(n, n + n2));
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fStringPool.addSymbol(this.fData.substring(n, n + n2));
    }

    public int skipOneChar() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return this.fCurrentOffset;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return this.fCurrentOffset;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        return ++this.fCurrentOffset;
    }

    public int skipAsciiChar() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return this.fCurrentOffset;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return this.fCurrentOffset;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        return ++this.fCurrentOffset;
    }

    public int skipToChar(char c) throws IOException {
        if (this.oweLeadingSpace) {
            if (c == ' ') {
                return this.fCurrentOffset;
            }
            this.oweLeadingSpace = false;
        }
        while (true) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    if (c == ' ') {
                        return this.fCurrentOffset;
                    }
                    this.oweTrailingSpace = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            if (c == this.fData.charAt(this.fCurrentOffset)) {
                return this.fCurrentOffset;
            }
            ++this.fCurrentOffset;
        }
    }

    public int skipPastChar(char c) throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            if (c == ' ') {
                return this.fCurrentOffset;
            }
        }
        while (true) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    if (c == ' ') {
                        return this.fCurrentOffset;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            if (c == this.fData.charAt(this.fCurrentOffset)) {
                return ++this.fCurrentOffset;
            }
            ++this.fCurrentOffset;
        }
    }

    public boolean skippedValidChar() throws IOException {
        char c;
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if ((c = this.fData.charAt(this.fCurrentOffset++)) < ' ') {
            if (c == '\t' || c == '\n' || c == '\r') {
                return true;
            }
            --this.fCurrentOffset;
            return false;
        }
        if (c <= '\ud7ff' || c >= '\ue000' && (c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff')) {
            return true;
        }
        --this.fCurrentOffset;
        return false;
    }

    public boolean lookingAtValidChar() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.fData.charAt(this.fCurrentOffset);
        if (c < ' ') {
            return c == '\t' || c == '\n' || c == '\r';
        }
        return c <= '\ud7ff' || c >= '\ue000' && (c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int skipInvalidChar(int n) throws Exception {
        int n2;
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            n2 = 32;
        } else if (this.fCurrentOffset >= this.fEndOffset) {
            if (!this.oweTrailingSpace) throw new ArrayIndexOutOfBoundsException();
            this.oweTrailingSpace = false;
            n2 = 32;
        } else {
            n2 = this.fData.charAt(this.fCurrentOffset++);
        }
        switch (n) {
            case 63: 
            case 85: {
                String string = Integer.toHexString(n2);
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                return this.fCurrentOffset;
            }
            case 80: 
            case 82: 
            case 110: {
                String string = new Character((char)n2).toString();
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                return this.fCurrentOffset;
            }
            case 43: {
                String string = new Character((char)n2).toString();
                String string2 = Integer.toHexString(n2);
                this.fErrorHandler.error2(n, this.fStringPool.addString(string), this.fStringPool.addString(string2));
            }
        }
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char c) throws IOException {
        if (this.oweLeadingSpace) {
            if (c == ' ') {
                this.oweLeadingSpace = false;
                return true;
            }
            return false;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                if (c == ' ') {
                    this.oweTrailingSpace = false;
                    return true;
                }
                return false;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if (c == this.fData.charAt(this.fCurrentOffset)) {
            ++this.fCurrentOffset;
            return true;
        }
        return false;
    }

    public boolean lookingAtChar(char c) throws IOException {
        if (this.oweLeadingSpace) {
            return c == ' ';
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return c == ' ';
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        return c == this.fData.charAt(this.fCurrentOffset);
    }

    public boolean skippedSpace() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.fData.charAt(this.fCurrentOffset);
        if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            ++this.fCurrentOffset;
            return true;
        }
        return false;
    }

    public boolean lookingAtSpace() throws IOException {
        if (this.oweLeadingSpace) {
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.fData.charAt(this.fCurrentOffset);
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public int skipPastSpaces() throws IOException {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
        }
        while (true) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    return this.fCurrentOffset;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            char c = this.fData.charAt(this.fCurrentOffset);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                return this.fCurrentOffset;
            }
            ++this.fCurrentOffset;
        }
    }

    public int skipDecimalDigit() {
        if (this.oweLeadingSpace) {
            return -1;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return -1;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.fData.charAt(this.fCurrentOffset);
        if (c < '0' || c > '9') {
            return -1;
        }
        ++this.fCurrentOffset;
        return c - 48;
    }

    public int skipHexDigit() {
        if (this.oweLeadingSpace) {
            return -1;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return -1;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.fData.charAt(this.fCurrentOffset);
        if (c > 'f' || XMLReader.fgAsciiXDigitChar[c] == 0) {
            return -1;
        }
        ++this.fCurrentOffset;
        return c - (c < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() {
        if (this.oweLeadingSpace) {
            return false;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return false;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.fData.charAt(this.fCurrentOffset);
        if (c <= 'z' && XMLReader.fgAsciiAlphaChar[c] == 1) {
            ++this.fCurrentOffset;
            return true;
        }
        return false;
    }

    private boolean skippedCharWithFlag(byte by) {
        if (this.oweLeadingSpace) {
            if ((XMLReader.fgCharFlags[32] & by) != 0) {
                this.oweLeadingSpace = false;
                return true;
            }
            return false;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                if ((XMLReader.fgCharFlags[32] & by) != 0) {
                    this.oweTrailingSpace = false;
                    return true;
                }
                return false;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.fData.charAt(this.fCurrentOffset);
        if (c < '\u0080' && (XMLReader.fgCharFlags[c] & by) != 0) {
            ++this.fCurrentOffset;
            return true;
        }
        return false;
    }

    public final boolean skippedVersionNum() {
        return this.skippedCharWithFlag((byte)1);
    }

    public final boolean skippedEncName() {
        return this.skippedCharWithFlag((byte)2);
    }

    public final boolean skippedPubidChar() {
        if (this.oweLeadingSpace) {
            this.oweLeadingSpace = false;
            return true;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.fData.charAt(this.fCurrentOffset);
        if (c < '\u0080') {
            if ((XMLReader.fgCharFlags[c] & 4) != 0) {
                ++this.fCurrentOffset;
                return true;
            }
            if (c == '\n') {
                ++this.fCurrentOffset;
                ++this.fLinefeedCounter;
                return true;
            }
            if (c == '\r') {
                ++this.fCurrentOffset;
                ++this.fCarriageReturnCounter;
                return true;
            }
        }
        return false;
    }

    public boolean skippedString(char[] cArray) throws IOException {
        if (this.oweLeadingSpace) {
            return false;
        }
        int n = this.fCurrentOffset;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    return false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.fData.charAt(n) != cArray[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        this.fCurrentOffset = n;
        return true;
    }

    public int skipPastName(char c) throws IOException {
        if (this.oweLeadingSpace) {
            return this.fCurrentOffset;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return this.fCurrentOffset;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c2 = this.fData.charAt(this.fCurrentOffset);
        if ((XMLReader.fgCharFlags[c2] & 0x10) == 0) {
            return this.fCurrentOffset;
        }
        do {
            ++this.fCurrentOffset;
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    return this.fCurrentOffset;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            c2 = this.fData.charAt(this.fCurrentOffset);
            if (c != c2) continue;
            return this.fCurrentOffset;
        } while ((XMLReader.fgCharFlags[c2] & 0x20) != 0);
        return this.fCurrentOffset;
    }

    public int scanName(char c, int n) throws IOException {
        int n2 = this.fCurrentOffset;
        int n3 = this.skipPastName(c) - n2;
        if (n3 == 0) {
            return -1;
        }
        int n4 = this.fStringPool.addSymbol(this.fData.substring(n2, n2 + n3));
        if (n == -1 || n == n4) {
            return n4;
        }
        return -1;
    }

    public int skipPastNmtoken(char c) throws IOException {
        if (this.oweLeadingSpace) {
            return this.fCurrentOffset;
        }
        if (this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                return this.fCurrentOffset;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        char c2 = this.fData.charAt(this.fCurrentOffset);
        while (c != c2) {
            if ((XMLReader.fgCharFlags[c2] & 0x20) == 0) {
                return this.fCurrentOffset;
            }
            ++this.fCurrentOffset;
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    return this.fCurrentOffset;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            c2 = this.fData.charAt(this.fCurrentOffset);
        }
        return this.fCurrentOffset;
    }

    private void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = n2 - n;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int n4 = n3 == 0 ? 0 : this.fStringPool.addString(this.fData.substring(n, n + n3));
            this.fDocumentHandler.characters(n4, bl);
            return;
        }
        this.fDocumentHandler.characters(this.fData.toCharArray(), n, n3, bl);
    }

    private void callWSCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = this.fParserState.getScanner().getCurrentContentSpecType();
        if (n3 != 4) {
            this.callCharDataHandler(n, n2, bl);
            return;
        }
        int n4 = n2 - n;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int n5 = n4 == 0 ? 0 : this.fStringPool.addString(this.fData.substring(n, n + n4));
            this.fDocumentHandler.ignorableWhitespace(n5, bl);
            return;
        }
        this.fDocumentHandler.ignorableWhitespace(this.fData.toCharArray(), n, n4, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanContent(ScanContentState scanContentState) throws Exception {
        byte by;
        char c;
        int n;
        block51: {
            block56: {
                block57: {
                    block55: {
                        block53: {
                            block54: {
                                n = this.fCurrentOffset;
                                if (this.fCurrentOffset >= this.fEndOffset) {
                                    throw new ArrayIndexOutOfBoundsException();
                                }
                                if ((c = this.fData.charAt(this.fCurrentOffset++)) >= '\u0080') break block53;
                                by = XMLReader.fgCharFlags[c];
                                if ((by & 8) != 0 || c == '\n' || c == '\r') break block54;
                                if (c == '<') {
                                    if (!scanContentState.inCDSect) {
                                        return 1;
                                    }
                                    break block51;
                                } else if (c == '&') {
                                    if (!scanContentState.inCDSect) {
                                        return 2;
                                    }
                                    break block51;
                                } else {
                                    if (c != ']') {
                                        --this.fCurrentOffset;
                                        return 4;
                                    }
                                    if (this.fCurrentOffset + 2 <= this.fEndOffset && this.fData.charAt(this.fCurrentOffset) == ']' && this.fData.charAt(this.fCurrentOffset + 1) == '>') {
                                        this.fCurrentOffset += 2;
                                        if (!scanContentState.inCDSect) {
                                            return 3;
                                        }
                                        scanContentState.inCDSect = false;
                                        return this.scanContent(scanContentState);
                                    }
                                }
                                break block51;
                            }
                            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break block51;
                            break block55;
                        }
                        if (c == '\ufffe' || c == '\uffff') {
                            --this.fCurrentOffset;
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(n, this.fCurrentOffset, scanContentState.inCDSect);
                            }
                            return 4;
                        }
                        break block51;
                    }
                    do {
                        if (this.fCurrentOffset >= this.fEndOffset) {
                            if (this.fDocumentHandler != null) {
                                this.callWSCharDataHandler(n, this.fEndOffset, scanContentState.inCDSect);
                            }
                            throw new ArrayIndexOutOfBoundsException();
                        }
                        if (c == '\n') {
                            ++this.fLinefeedCounter;
                            continue;
                        }
                        if (c != '\r') continue;
                        ++this.fCarriageReturnCounter;
                    } while ((c = this.fData.charAt(this.fCurrentOffset++)) == ' ' || c == '\t' || c == '\n' || c == '\r');
                    if (c >= '\u0080') break block56;
                    by = XMLReader.fgCharFlags[c];
                    if ((by & 8) != 0) break block51;
                    if (c != '<') break block57;
                    if (!scanContentState.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(n, this.fCurrentOffset - 1, scanContentState.inCDSect);
                        }
                        return 25;
                    }
                    break block51;
                }
                if (c == '&') {
                    if (!scanContentState.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(n, this.fCurrentOffset - 1, scanContentState.inCDSect);
                        }
                        return 26;
                    }
                    break block51;
                } else if (c == ']') {
                    if (this.fCurrentOffset + 2 <= this.fEndOffset && this.fData.charAt(this.fCurrentOffset) == ']' && this.fData.charAt(this.fCurrentOffset + 1) == '>') {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(n, this.fCurrentOffset - 1, scanContentState.inCDSect);
                        }
                        this.fCurrentOffset += 2;
                        if (!scanContentState.inCDSect) {
                            return 27;
                        }
                        scanContentState.inCDSect = false;
                        return this.scanContent(scanContentState);
                    }
                    break block51;
                } else {
                    --this.fCurrentOffset;
                    if (this.fDocumentHandler != null) {
                        this.callWSCharDataHandler(n, this.fCurrentOffset, scanContentState.inCDSect);
                    }
                    return 28;
                }
            }
            if (c == '\ufffe' || c == '\uffff') {
                --this.fCurrentOffset;
                if (this.fDocumentHandler != null) {
                    this.callWSCharDataHandler(n, this.fCurrentOffset, scanContentState.inCDSect);
                }
                return 28;
            }
        }
        while (true) {
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.fDocumentHandler != null) {
                    this.callCharDataHandler(n, this.fEndOffset, scanContentState.inCDSect);
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            if ((c = this.fData.charAt(this.fCurrentOffset++)) >= '\u0080') break;
            by = XMLReader.fgCharFlags[c];
            if ((by & 8) != 0) continue;
            if (c == '\n') {
                ++this.fLinefeedCounter;
                continue;
            }
            if (c != '\r') break;
            ++this.fCarriageReturnCounter;
        }
        while (true) {
            block52: {
                block58: {
                    block61: {
                        block60: {
                            block59: {
                                if (c >= '\u0080') break block58;
                                by = XMLReader.fgCharFlags[c];
                                if ((by & 8) != 0) break block52;
                                if (c != '<') break block59;
                                if (!scanContentState.inCDSect) {
                                    if (this.fDocumentHandler != null) {
                                        this.callCharDataHandler(n, this.fCurrentOffset - 1, scanContentState.inCDSect);
                                    }
                                    return 9;
                                }
                                break block52;
                            }
                            if (c != '&') break block60;
                            if (!scanContentState.inCDSect) {
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(n, this.fCurrentOffset - 1, scanContentState.inCDSect);
                                }
                                return 10;
                            }
                            break block52;
                        }
                        if (c != '\n') break block61;
                        ++this.fLinefeedCounter;
                        break block52;
                    }
                    if (c == '\r') {
                        ++this.fCarriageReturnCounter;
                        break block52;
                    } else if (c == ']') {
                        if (this.fCurrentOffset + 2 <= this.fEndOffset && this.fData.charAt(this.fCurrentOffset) == ']' && this.fData.charAt(this.fCurrentOffset + 1) == '>') {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(n, this.fCurrentOffset - 1, scanContentState.inCDSect);
                            }
                            this.fCurrentOffset += 2;
                            if (!scanContentState.inCDSect) {
                                return 11;
                            }
                            scanContentState.inCDSect = false;
                            return this.scanContent(scanContentState);
                        }
                        break block52;
                    } else {
                        --this.fCurrentOffset;
                        if (this.fDocumentHandler != null) {
                            this.callCharDataHandler(n, this.fCurrentOffset, scanContentState.inCDSect);
                        }
                        return 12;
                    }
                }
                if (c == '\ufffe' || c == '\uffff') {
                    --this.fCurrentOffset;
                    if (this.fDocumentHandler != null) {
                        this.callCharDataHandler(n, this.fCurrentOffset, scanContentState.inCDSect);
                    }
                    return 12;
                }
            }
            if (this.fCurrentOffset >= this.fEndOffset) {
                if (this.fDocumentHandler != null) {
                    this.callCharDataHandler(n, this.fCurrentOffset, scanContentState.inCDSect);
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            c = this.fData.charAt(this.fCurrentOffset++);
        }
    }
}

