// Last changed: 02/08/19 13:14:45

// Returns the node with specified tag
function getChildNode(parent, childTag) {
  if (parent.nodeName == childTag) {
    return parent;
  }
  var list = parent.childNodes;
  if (list == null) {
    return null;
  }
  else {
    for (var i=0; i < list.length; i++) {
      if (list.item(i).nodeName == childTag) {
        return list.item(i);
      }
    }
  }
  return null;
}

// Returns the containing DIV if any
function IEgetContentNode(srcElement) {
  if (srcElement.nodeName == "LI") {
    return srcElement.lastChild;
  }
  else if (srcElement.nodeName == "A") {
    return srcElement.parentElement.lastChild;
  }
  else if (srcElement.nodeName == "UL") {
    return srcElement;
  }
  return null;
}

// Returns the container if any
function getContentNode(node) {
  if (node.nodeType == 3) {
    return getChildNode(node.parentNode.parentNode, "UL");
  }
  else if (node.nodeName == "LI") {
    return getChildNode(node, "UL");
  }
  else if (node.nodeName == "A") {
    return getChildNode(node.parentNode, "UL");
  }
  else if (node.nodeName == "UL") {
    return node;
  }

  return null;
}

// Returns the anchor of this click
function getAnchorNode(node) {
  if (node.nodeType == "Node.TEXT_NODE" || node.nodeName == "#text") {
    return getChildNode(node.parentNode, "A");
  }
  else if (node.nodeName == "LI" || node.nodeName == "UL" || node.nodeName == "HR") {
    return getChildNode(node, "A");
  }
  else if (node.nodeName == "A") {
    return node;
  }
  return null;
}

// Determines if a given A tag has a target attribute
function hasTarget(srcElement) {
  if (srcElement != null) {
    var attributes = srcElement.attributes;
    for (var i = 0; i < attributes.length; i++) {
      if (attributes[i] == "target") {
        return 1;
      }
    }
  }
  return null;
}

// Synchronize the navigation tree with the displayed topic
function synchronize(id) {
  node = document.getElementById(id);
  highlight(node);
  while (node) {
    if (node.nodeName == "UL" && node.className == "collapsed") {
      node.className = "expanded";
    }
    node = node.parentNode;
  }
  window.location.hash = id;
}

function handleClick(srcElement) {
  if (srcElement != null) {
    if (srcElement.className == "collapsed") {
      srcElement.className = "expanded";
      var anchor = getAnchorNode(srcElement.parentNode);
      if (hasTarget(anchor) != null && anchor != null && anchor.href != null) {
        parent.mainFrame.location.href = anchor.href;
      }
    }
    else if (srcElement.className == "expanded") {
      srcElement.className = "collapsed";
    }
    else if (srcElement.nodeName == "LI") {
      var anchor = getAnchorNode(srcElement);
      if (hasTarget(anchor) != null && anchor != null && anchor.href != null) {
        parent.mainFrame.location.href = anchor.href;
      }
    }
    else if (srcElement.nodeName == "#text" || 
             srcElement.nodeName == "A") {
      var anchor = getAnchorNode(srcElement);
      if (hasTarget(anchor) != null && anchor != null && anchor.href != null) {
        parent.mainFrame.location.href = anchor.href;
      }
    }
    else if (srcElement.nodeName == "HR") {
      srcElement = srcElement.previousSibling;
      handleClick(srcElement);
    }
  }
  highlight(srcElement);
}

// Highlight the current topic in the navigation tree
function highlight(srcElement) {
  if (srcElement != null) {
    var a = getAnchorNode(srcElement);
    if (oldActive) {
      oldActive.className = "";
    }
    if (a != null) {
      a.className = "activeNode";
      oldActive = a;
    }
  }
}

// handler for expanding / collapsing topic tree
function mouseClickHandler(e) {
  var node = getContentNode(e.target);
  if (node != null) {
    handleClick(node);
  }
  else {
    handleClick(e.target);
  }
}

// display topic label in the status line on mouse over topic
function mouseMoveHandler(e) {
  var node = e.target;
  if (node.nodeName == "A") {
    e.cancelBubble = false;
  }
  else if (node.nodeType == "Node.TEXT_NODE" || node.nodeName == "LI") {
    e.cancelBubble = true;
  }
}

// handler for expanding / collapsing topic tree
function IEmouseClickHandler() {
  var srcElement = IEgetContentNode(window.event.srcElement);
  handleClick(srcElement);
}

// display topic label in the status line on mouse over topic
function IEmouseMoveHandler() {
  srcElement = window.event.srcElement;
  if (srcElement.nodeName == "A") {
    event.cancelBubble = true;
  }
}

var ua = navigator.userAgent.toLowerCase();
// listen for clicks
if (ua.indexOf("opera") != -1 || ua.indexOf("konqueror") != -1) {
  document.writeln("<link rel='stylesheet' href='nav-css.css' type='text/css'>");
}
else if (ua.indexOf("gecko") != -1 && parseInt(navigator.appVersion) >= 5) {
  document.addEventListener('click', mouseClickHandler, true);
  document.addEventListener('mousemove', mouseMoveHandler, true);
  document.writeln("<link rel='stylesheet' href='nav.css' type='text/css' />");
}
else if (ua.indexOf("msie") != -1 && parseInt(navigator.appVersion) >= 4) {
  document.onclick = IEmouseClickHandler;
  document.ondblclick = IEmouseClickHandler;
  document.onmousemove = IEmouseMoveHandler;
  document.write("<link rel='stylesheet' href='nav-msie.css' type='text/css' />");
}
else
{
  document.writeln("<link rel='stylesheet' href='nav-netscape.css' type='text/css'>");
}

var oldActive;
