#!/bin/ksh

# Rebuild CD on local disk.

RPMToReplace="db2rte61-6.1.0-0.i386.rpm"
CURDIR=`pwd`

syntax()
{
    cat <<- EOS

$0 [-c CDdir] [-r rpmfile] [-d destination]

where:
    CDdir       where the DB2 CD is mounted
                [${CDDIR?}]
    rpmfile     where the ${RPMToReplace?} file is located
                [${RPMFILE?}]
    destination where to create the fixed CD
                [${DESTDIR?}]

EOS

exit 1

}

# Default options:
CDDIRS=`grep iso9660 /etc/fstab | awk '{ print $2 }'`
RPMFILE=`ls ${RPMToReplace?} 2> /dev/null`
DESTDIR='/tmp/fixdb2'

numcds=`echo "${CDDIRS?}" | wc -w | awk '{ print $1 }'`

CDDIR=""
if [ ${numcds?} -gt 0 ]
then
    # Let's see if the right CD is mounted.
    for DIR in ${CDDIRS?}
    do
        if mount | grep ${DIR?} > /dev/null 2>&1
        then
            if [ -f ${DIR?}/db2/${RPMToReplace?} ]
            then
                CDDIR="${CDDIR?} ${DIR?}"
            fi
        fi
    done
fi

# if we don't start with a slash, add current directory.
if echo "${RPMFILE?}" | grep ^[^/] > /dev/null 2>&1
then
    RPMFILE="${CURDIR?}/${RPMFILE?}"
fi

while getopts :c:r:d: optchar
do
    case $optchar in
        c)
            CDDIR=${OPTARG?}
            # if it doesn't start with a slash, add current directory.
            if echo "${RPMFILE?}" | grep ^[^/]
            then
                RPMFILE="${CURDIR?}/${RPMFILE?}"
            fi
            ;;
        r)
            echo "${OPTARG?}" | grep ${RPMToReplace?} > /dev/null 2>&1
            if [ $? -eq 0 -a -f ${OPTARG?} ]
            then
                RPMFILE="${OPTARG?}"
            else
                echo "Either wrong filename or file doesn't exist:"
                echo "${OPTARG?}"
                echo
                syntax
            fi
            ;;
        d)
            DESTDIR="${OPTARG?}"
            ;;
        *)
            syntax
            ;;
    esac
done

# Check source (CD) directory.
numcds=`echo "${CDDIR?}" | wc -w | awk '{ print $1 }'`
if [ ${numcds?} -lt 1 ]
then
    echo "Unknown which CD to use.  Please insert the DB2 CD and ensure it"
    echo "is mounted."
    echo
    syntax
fi

if [ ${numcds?} -gt 1 ]
then
    echo "Multiple possible CDs.  Please either remove one, or specify which"
    echo "one with the -c option."
    echo
    syntax
fi

# remove any leading/trailing spaces
CDDIR=`echo ${CDDIR?} | awk '{ print $1 }'`

if [ ! -f ${CDDIR?}/db2/${RPMToReplace?} ]
then
    echo "Unknown which CD to use.  Please insert the DB2 CD and ensure it"
    echo "is mounted."
    echo
    syntax
fi

# Check the RPM.
if [ -z "${RPMFILE?}" -o ! -f "${RPMFILE?}" ]
then
    echo "Can't find ${RPMToReplace?}.  Please use -r option to specify."
    syntax
fi

# create destination directory.
if [ ! -d ${DESTDIR?} ]
then
    mkdir ${DESTDIR?}
    if [ $? -ne 0 ]
    then
        echo "Cannot create destination directory: ${DESTDIR?}"
        echo
        syntax
    fi
fi

cp -srf ${CDDIR?}/* ${DESTDIR?}
if [ $? -ne 0 ]
then
    echo "Cannot create links from ${CDDIR?}"
    echo "to ${DESTDIR?}"
    echo "This is most likely a space issue.  Please correct and retry,"
    echo "or choose another mount for the directory with the -d option."
    exit 1
fi

rm -f ${DESTDIR?}/db2/${RPMToReplace?}
ln -s ${RPMFILE?} ${DESTDIR?}/db2/${RPMToReplace?}
if [ $? -ne 0 ]
then
    echo "Cannot create links from ${CDDIR?}"
    echo "to ${DESTDIR?}"
    echo "This is most likely a space issue.  Please correct and retry,"
    echo "or choose another mount for the directory with the -d option."
    exit 1
fi

echo "Completed successfully."
echo
echo "Go to the ${DESTDIR?} directory and run db2setup now."

exit 0
