/*							*/
/*   Licensed Materials - Property of IBM               */
/*							*/
/*   5765-530            				*/
/*   (C) Copyright IBM Corp. 1996 All Rights Reserved.	*/
/*							*/

typedef struct wdg_delete_check {
	int	checknum;		/* Checknum to delete */
	} delete_check_t;

typedef struct wdg_check_time {
	int	start_type;	/* SPEC_FOLLOWS,TIME_ONCE */
	long	start_time;	/* Unix Timestamp if start_type=TIME_ONCE */
	int	repeat_type;	/* SPEC_FOLLOWS,TIME_ONCE */
	long	repeat_time;	/* Unix Timestamp if repeat_type=TIME_ONCE */
	int	end_type;       /* SPEC_FOLLOWS,TIME_FOREVER */
	long	end_time;	/* Unix Timestamp if end_type=TIME_ONCE */
	struct wdg_check_time	*nexttime;
	} wdg_check_time_t;

typedef struct wdg_check {
	int			checknum;	/* New or changed checknumber */
	int			valuetype;	/* CHECK_FLOAT, CHECK_INT, CHECK_STRING */
	int			cmdtype;	/* OS, SQL */
	char			*dbname;	/* database for query if type = SQL */
	char			*cmd;		/* Text of command */
	wdg_check_time_t	schedule;	/* linked list with schedule info */
	} check_t;

typedef struct wdg_value {
	int			checknum;	/* Number of executed check */
	int			type;		/* Type of return value, CHECK_FLOAT, CHECK_INT, CHECK_STRING */
	int			ival;		/* Value, if type is int */
	char			*sval;		/* Value, if type is string */
	float			fval;		/* Value, if type is float */
	int			ts;		/* Timestamp of check */
	} value_t;

typedef struct wdg_register {
	char			*name;		/* Watchdog ID */
	} register_t;

#define CHECK_FLOAT		0
#define CHECK_INT		1
#define CHECK_STRING		2

#define RESET_KWD		"reset"
#define RESET_TYPE		0

#define MSG_ARITY		3
#define MSG_KWD			"msg"

#define DELETE_CHECK_ARITY	1
#define DELETE_CHECK_KWD	"delete_check"
#define DELETE_CHECK_TYPE	1

#define CHECK_ARITY		5
#define CHECK_KWD		"check"
#define CHECK_TYPE		2

#define SCHEDULE_ARITY		6
#define SCHEDULE_KWD		"schedule"

#define SQL_KWD			"sql"
#define SQL_TYPE		0
#define SQL_ARITY		1

#define OS_KWD			"os"
#define OS_TYPE			1

#define INT_KWD			"integer"
#define INT_TYPE		CHECK_INT
#define STRING_KWD		"string"
#define STRING_TYPE		CHECK_STRING
#define FLOAT_KWD		"float"
#define FLOAT_TYPE		CHECK_FLOAT

#define LIST_KWD		"."
#define LIST_ARITY		2

#define INIT_KWD		"init"
#define INIT_TYPE		3

#define REGISTER_KWD		"register"
#define REGISTER_ARITY		1
#define REGISTER_TYPE		4

#define VALUE_KWD		"value"
#define VALUE_ARITY		3
#define VALUE_TYPE		5


#define OK				0	
#define WRONG_ARGUMENT_TYPE		-1
#define WRONG_TERM			-2
#define CANNOT_MALLOC			-3
#define UNKNOWN_MESSAGE			-4
#define WRONG_NUMBER_OF_ARGUMENTS	-5
#define WRITE_FAILED			-6
#define WRITE_ERROR			-6
#define UNKNOWN_TYPE			-7
#define WRONG_ATOM_NUMBER		-8

#define SP_INTEGER	2
#define SP_ATOM		3
#define SP_FLOAT	4
#define SP_COMPOUND	5
#define SP_TYPESIZE	sizeof( char)
