/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11DESedeKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.util.Date;

public final class DESedeKey
implements PKCS11DESedeKey,
Serializable {
    private PKCS11Object object = null;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.DES3;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private Boolean isSensitive = null;
    private Boolean isEncrypt = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isVerify = null;
    private Boolean isWrap = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private byte[] value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DESedeKey";

    DESedeKey(PKCS11Object pKCS11Object, byte[] byArray, String string, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5) throws InvalidKeyException {
        this.object = pKCS11Object;
        if (byArray != null) {
            this.ID = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        } else {
            this.ID = (byte[])this.getAttrValue(this.object, 258);
        }
        this.label = string != null ? string : (String)this.getAttrValue(this.object, 3);
        this.isToken = bl != null ? new Boolean(bl) : (Boolean)this.getAttrValue(this.object, 1);
        this.isSensitive = bl2 != null ? new Boolean(bl2) : (Boolean)this.getAttrValue(this.object, 259);
        this.isEncrypt = bl3 != null ? new Boolean(bl3) : (Boolean)this.getAttrValue(this.object, 260);
        this.isWrap = bl4 != null ? new Boolean(bl4) : (Boolean)this.getAttrValue(this.object, 262);
        this.isExtractable = bl5 != null ? new Boolean(bl5) : (Boolean)this.getAttrValue(this.object, 354);
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isDecrypt = (Boolean)this.getAttrValue(this.object, 261);
        this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        this.isUnwrap = (Boolean)this.getAttrValue(this.object, 263);
        this.isAlwaysSensitive = (Boolean)this.getAttrValue(this.object, 357);
        this.isNeverExtractable = (Boolean)this.getAttrValue(this.object, 356);
    }

    public DESedeKey(PKCS11Object pKCS11Object, byte[] byArray, String string, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, byte[] byArray2) throws InvalidKeyException {
        this(pKCS11Object, byArray, string, bl, bl2, bl3, bl4, bl5);
        if (byArray2 != null) {
            this.value = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.value, 0, byArray2.length);
        }
    }

    public byte[] getEncoded() {
        if (this.value != null) {
            return (byte[])this.value.clone();
        }
        return null;
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        return (Date)this.startDate.clone();
    }

    public Date getEndDate() {
        return (Date)this.endDate.clone();
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public Boolean getSensitive() {
        return new Boolean(this.isSensitive);
    }

    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    public Boolean getDecrypt() {
        return new Boolean(this.isDecrypt);
    }

    public Boolean getSign() {
        return new Boolean(this.isSign);
    }

    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    public Boolean getUnwrap() {
        return new Boolean(this.isUnwrap);
    }

    public Boolean getExtractable() {
        return new Boolean(this.isExtractable);
    }

    public Boolean getAlwaysSensitive() {
        return new Boolean(this.isAlwaysSensitive);
    }

    public Boolean getNeverExtractable() {
        return new Boolean(this.isNeverExtractable);
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        String string = "IBMPKCS11Impl";
        String string2 = string + " DESede Key: ";
        if (this.isToken != null) {
            string2 = string2 + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            string2 = string2 + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            string2 = string2 + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            string2 = string2 + "\n Modifiable: " + this.isModifiable;
        }
        string2 = string2 + "\n KeyType: " + this.keyType.toString();
        if (this.ID != null) {
            string2 = string2 + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            string2 = string2 + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            string2 = string2 + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            string2 = string2 + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            string2 = string2 + "\n Local: " + this.isLocal;
        }
        if (this.isSensitive != null) {
            string2 = string2 + "\n Sensitive: " + this.isSensitive;
        }
        if (this.isEncrypt != null) {
            string2 = string2 + "\n Encrypt: " + this.isEncrypt;
        }
        if (this.isDecrypt != null) {
            string2 = string2 + "\n Decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            string2 = string2 + "\n Sign: " + this.isSign;
        }
        if (this.isVerify != null) {
            string2 = string2 + "\n Verify: " + this.isVerify;
        }
        if (this.isWrap != null) {
            string2 = string2 + "\n Wrap: " + this.isWrap;
        }
        if (this.isUnwrap != null) {
            string2 = string2 + "\n Unwrap: " + this.isUnwrap;
        }
        if (this.isExtractable != null) {
            string2 = string2 + "\n Extractable: " + this.isExtractable;
        }
        if (this.isAlwaysSensitive != null) {
            string2 = string2 + "\n Always Sensitive: " + this.isAlwaysSensitive;
        }
        if (this.isNeverExtractable != null) {
            string2 = string2 + "\n Never Extractable: " + this.isNeverExtractable;
        }
        if (this.value != null) {
            string2 = string2 + "\n value: " + this.value.toString();
        }
        return string2;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "DESede";
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }
}

