/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SelfTest;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class CipherWithWrappingSpi
extends CipherSpi
implements AlgorithmStatus {
    public boolean isFipsApproved() {
        return true;
    }

    protected final byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key);
        }
        throw new FIPSRuntimeException();
    }

    protected final byte[] a(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray2 == null || byArray2.length == 0) {
                throw new InvalidKeyException(CipherWithWrappingSpi.a(" \u0013\u0000z?\u0017R\tq$C\u0013\u000045\r\u0011\u0001p9\r\u0015N{6C\u0006\u0006qp\b\u0017\u00174$\fR\fqp\u0014\u0000\u000fd \u0006\u0016"));
            }
            byArray = this.engineDoFinal(byArray2, 0, byArray2.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return byArray;
    }

    protected final Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(byArray, string, n2);
        }
        throw new FIPSRuntimeException();
    }

    protected final Key a(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        Key key = null;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException();
        }
        switch (n2) {
            case 3: {
                key = this.c(byArray2, string);
                break;
            }
            case 2: {
                key = this.b(byArray2, string);
                break;
            }
            case 1: {
                key = this.a(byArray2, string);
            }
        }
        return key;
    }

    private final PublicKey a(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, CipherWithWrappingSpi.a("*0#^\u0013&4'D\u0003"));
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new NoSuchAlgorithmException(CipherWithWrappingSpi.a("-\u001dN}>\u0010\u0006\u000fx<\u0006\u0016Nd\"\f\u0004\u0007p5\u0011\u0001Nw1\rR\rf5\u0002\u0006\u000b4;\u0006\u000b\u001d46\f\u0000N`8\u0006R") + string + CipherWithWrappingSpi.a("\u0002\u001e\t{\"\n\u0006\u0006y"));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return publicKey;
    }

    private final PrivateKey b(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, CipherWithWrappingSpi.a("*0#^\u0013&4'D\u0003"));
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new NoSuchAlgorithmException(CipherWithWrappingSpi.a("-\u001dN}>\u0010\u0006\u000fx<\u0006\u0016Nd\"\f\u0004\u0007p5\u0011\u0001Nw1\rR\rf5\u0002\u0006\u000b4;\u0006\u000b\u001d46\f\u0000N`8\u0006R") + string + CipherWithWrappingSpi.a("\u0002\u001e\t{\"\n\u0006\u0006y"));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return privateKey;
    }

    private final SecretKey c(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 99;
                        break;
                    }
                    case 1: {
                        n5 = 114;
                        break;
                    }
                    case 2: {
                        n5 = 110;
                        break;
                    }
                    case 3: {
                        n5 = 20;
                        break;
                    }
                    default: {
                        n5 = 80;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

