/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.smime.SMIMEMessage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class SMIMEReceiver
implements Cloneable {
    private SMIMEMessage smimemsg;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.SMIMEReceiver";

    public SMIMEReceiver(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEReceiver", (Object)byArray);
        }
        this.setSMIMEMessage(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(byte[] byArray, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEReceiver", byArray, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.setSMIMEMessage(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEReceiver", inputStream);
        }
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        inputStream.close();
        this.setSMIMEMessage(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(InputStream inputStream, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEReceiver", inputStream, string);
        }
        byte[] byArray = new byte[inputStream.available()];
        if (string != null) {
            this.provider = new String(string);
        }
        inputStream.read(byArray);
        inputStream.close();
        this.setSMIMEMessage(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEReceiver", string);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.setSMIMEMessage(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(String string, String string2) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEReceiver", string, string2);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        if (string2 != null) {
            this.provider = new String(string2);
        }
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.setSMIMEMessage(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(SMIMEMessage sMIMEMessage) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEReceiver", sMIMEMessage);
        }
        this.setSMIMEMessage(sMIMEMessage);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public SMIMEReceiver(SMIMEMessage sMIMEMessage, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEReceiver", sMIMEMessage, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.setSMIMEMessage(sMIMEMessage);
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEReceiver");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            SMIMEMessage sMIMEMessage = (SMIMEMessage)this.getSMIMEMessage().clone();
            SMIMEReceiver sMIMEReceiver = null;
            if (sMIMEMessage != null) {
                sMIMEReceiver = new SMIMEReceiver(sMIMEMessage, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", sMIMEReceiver);
            }
            return sMIMEReceiver;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    private void setSMIMEMessage(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSMIMEMessage", (Object)byArray);
        }
        SMIMEMessage sMIMEMessage = new SMIMEMessage(byArray, this.provider);
        this.setSMIMEMessage(sMIMEMessage);
        if (debug != null) {
            debug.exit(8192L, className, "setSMIMEMessage");
        }
    }

    private void setSMIMEMessage(SMIMEMessage sMIMEMessage) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSMIMEMessage", sMIMEMessage);
        }
        this.smimemsg = sMIMEMessage;
        if (debug != null) {
            debug.exit(8192L, className, "setSMIMEMessage");
        }
    }

    public SMIMEMessage getSMIMEMessage() {
        if (debug != null) {
            debug.entry(16384L, className, "getSMIMEMessage");
            debug.exit(16384L, (Object)className, "getSMIMEMessage", this.smimemsg);
        }
        return this.smimemsg;
    }

    public byte[] getContentInfoBytes() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfoBytes");
        }
        if (this.smimemsg == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfoBytes_1", null);
            }
            return null;
        }
        byte[] byArray = this.smimemsg.getContentInfoBytes();
        if (byArray == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfoBytes_2", null);
            }
            return null;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray2 = null;
        try {
            byArray2 = bASE64Decoder.decodeBuffer(new String(byArray, "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "getContentInfoBytes", unsupportedEncodingException);
            }
            byArray2 = bASE64Decoder.decodeBuffer(new String(byArray));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfoBytes_3", byArray2);
        }
        return byArray2;
    }

    public ContentInfo getContentInfo() throws IOException {
        byte[] byArray;
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if ((byArray = this.getContentInfoBytes()) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", new ContentInfo(byArray, this.provider));
        }
        return new ContentInfo(byArray, this.provider);
    }

    public byte[] getCertificationRequestBytes() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequestBytes");
        }
        if (this.smimemsg == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequestBytes_1", null);
            }
            return null;
        }
        byte[] byArray = this.smimemsg.getCertificationRequestBytes();
        if (byArray == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequestBytes_2", null);
            }
            return null;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray2 = null;
        try {
            byArray2 = bASE64Decoder.decodeBuffer(new String(byArray, "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequestBytes", unsupportedEncodingException);
            }
            byArray2 = bASE64Decoder.decodeBuffer(new String(byArray));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequestBytes_3", byArray2);
        }
        return byArray2;
    }

    public CertificationRequest getCertificationRequest() throws IOException {
        byte[] byArray;
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
        }
        if ((byArray = this.getCertificationRequestBytes()) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequest_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequest_2", new CertificationRequest(byArray, this.provider));
        }
        return new CertificationRequest(byArray, this.provider);
    }

    public byte[] getHeader() {
        if (debug != null) {
            debug.entry(16384L, className, "getHeader");
        }
        if (this.smimemsg == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getHeader_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getHeader_2", this.smimemsg.getHeader());
        }
        return this.smimemsg.getHeader();
    }

    public String toString() {
        String string = "SMIMEReceiver:\r\n";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = string + this.smimemsg.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

