/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.EntityIdentifier;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.MailListKeyIdentifier;
import com.ibm.security.pkcs7.RecipientIdentifier;
import com.ibm.security.pkcs7.RecipientKeyIdentifier;
import com.ibm.security.pkcs7.SubjectKeyIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;

public final class RecipientInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_RKEY = 0;
    private static final byte TAG_MLKEY = 1;
    private static final String ISSUER = "com.ibm.security.pkcs7.IssuerAndSerialNumber";
    private static final String RKEYID = "com.ibm.security.pkcs7.RecipientKeyIdentifier";
    private static final String MLKEYID = "com.ibm.security.pkcs7.MailListKeyIdentifier";
    private static final String SKEYID = "com.ibm.security.pkcs7.SubjectKeyIdentifier";
    private BigInteger version;
    private IssuerAndSerialNumber recipientIdIssuer;
    private RecipientKeyIdentifier recipientIdRKeyId;
    private MailListKeyIdentifier recipientIdMLKeyId;
    private IssuerAndSerialNumber originatorCertIssuer;
    private byte[] originatorCertSKeyId;
    private AlgorithmId keyEncryptionAlgorithm;
    private SmudgedBytes encryptedKey;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.RecipientInfo";

    public RecipientInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RecipientInfo", (Object)byArray);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "RecipientInfo", byArray, string);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(byte[] byArray, Certificate certificate) throws IOException, PKCSException {
        this(byArray, certificate, null);
        if (debug != null) {
            debug.entry(16384L, className, "RecipientInfo", byArray, certificate);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(byte[] byArray, Certificate certificate, String string) throws IOException, PKCSException {
        super(string);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{byArray, certificate, string};
            debug.entry(16384L, (Object)className, "RecipientInfo", objectArray);
        }
        objectArray = (Object[])certificate;
        Principal principal = objectArray.getIssuerDN();
        X500Name x500Name = new X500Name(principal.getName());
        this.recipientIdIssuer = new IssuerAndSerialNumber(x500Name, objectArray.getSerialNumber(), string);
        this.recipientIdRKeyId = null;
        this.recipientIdMLKeyId = null;
        this.originatorCertIssuer = null;
        this.originatorCertSKeyId = null;
        try {
            this.encryptKey(byArray, certificate);
            this.keyEncryptionAlgorithm = AlgorithmId.get(certificate.getPublicKey().getAlgorithm());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "RecipientInfo", exception);
            }
            throw new PKCSException(exception, "Key encryption error (" + exception.toString() + ")");
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(RecipientIdentifier recipientIdentifier, EntityIdentifier entityIdentifier, AlgorithmId algorithmId, byte[] byArray) {
        this(recipientIdentifier, entityIdentifier, algorithmId, byArray, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{recipientIdentifier, entityIdentifier, algorithmId, byArray};
            debug.entry(16384L, (Object)className, "RecipientInfo", objectArray);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public RecipientInfo(RecipientIdentifier recipientIdentifier, EntityIdentifier entityIdentifier, AlgorithmId algorithmId, byte[] byArray, String string) {
        block14: {
            block15: {
                String string2;
                Object object;
                super(string);
                if (debug != null) {
                    object = new Object[]{recipientIdentifier, entityIdentifier, algorithmId, byArray, string};
                    debug.entry(16384L, (Object)className, "RecipientInfo", (Object[])object);
                }
                if ((string2 = ((Class)(object = recipientIdentifier.getClass())).getName()).equals(ISSUER)) {
                    this.recipientIdIssuer = (IssuerAndSerialNumber)recipientIdentifier;
                    this.recipientIdRKeyId = null;
                    this.recipientIdMLKeyId = null;
                } else if (string2.equals(RKEYID)) {
                    this.recipientIdIssuer = null;
                    this.recipientIdRKeyId = (RecipientKeyIdentifier)recipientIdentifier;
                    this.recipientIdMLKeyId = null;
                } else if (string2.equals(MLKEYID)) {
                    this.recipientIdIssuer = null;
                    this.recipientIdRKeyId = null;
                    this.recipientIdMLKeyId = (MailListKeyIdentifier)recipientIdentifier;
                } else {
                    if (debug != null) {
                        debug.text(16384L, className, "RecipientInfo", "Invalid RecipientIdentifier");
                    }
                    throw new IllegalArgumentException("Invalid RecipientIdentifier");
                }
                if (entityIdentifier == null) break block15;
                object = entityIdentifier.getClass();
                string2 = ((Class)object).getName();
                if (string2.equals(ISSUER)) {
                    this.originatorCertIssuer = (IssuerAndSerialNumber)entityIdentifier;
                    this.originatorCertSKeyId = null;
                    break block14;
                } else if (string2.equals(SKEYID)) {
                    this.originatorCertIssuer = null;
                    SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)entityIdentifier;
                    this.originatorCertSKeyId = subjectKeyIdentifier.getIdentifier();
                    break block14;
                } else {
                    if (debug != null) {
                        debug.text(16384L, className, "RecipientInfo", "Invalid EntityIdentifier");
                    }
                    throw new IllegalArgumentException("Invalid EntityIdentifier");
                }
            }
            this.originatorCertIssuer = null;
            this.originatorCertSKeyId = null;
        }
        this.keyEncryptionAlgorithm = algorithmId;
        this.setEncryptedKeyValue(byArray);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "RecipientInfo", string, new Boolean(bl));
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "RecipientInfo", objectArray);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        if (this.recipientIdIssuer != null) {
            this.recipientIdIssuer.encode(derOutputStream2);
        } else if (this.recipientIdRKeyId != null) {
            derOutputStream = new DerOutputStream();
            this.recipientIdRKeyId.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        } else if (this.recipientIdMLKeyId != null) {
            derOutputStream = new DerOutputStream();
            this.recipientIdMLKeyId.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "RecipientInfo encoding error");
            }
            throw new IOException("RecipientInfo encoding error");
        }
        if (this.originatorCertIssuer != null) {
            derOutputStream = new DerOutputStream();
            this.originatorCertIssuer.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        } else if (this.originatorCertSKeyId != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.originatorCertSKeyId);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        this.keyEncryptionAlgorithm.encode(derOutputStream2);
        derOutputStream2.putOctetString(this.getEncryptedKeyValue());
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "RecipientInfo parsing error");
            }
            throw new IOException("RecipientInfo parsing error");
        }
        this.version = derValue.getData().getInteger();
        if (this.version.intValue() != 0 && this.version.intValue() != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "RecipientInfo version must be zero or two");
            }
            throw new IOException("RecipientInfo version must be zero or two");
        }
        int n = derValue.getData().peekByte();
        DerValue derValue2 = derValue.getData().getDerValue();
        if (n == 48) {
            this.recipientIdIssuer = new IssuerAndSerialNumber(derValue2.toByteArray(), this.provider);
            this.recipientIdRKeyId = null;
            this.recipientIdMLKeyId = null;
        } else if ((byte)n == -96) {
            derValue2.resetTag((byte)48);
            this.recipientIdIssuer = null;
            this.recipientIdRKeyId = new RecipientKeyIdentifier(derValue2.toByteArray(), this.provider);
            this.recipientIdMLKeyId = null;
        } else if ((byte)n == -95) {
            derValue2.resetTag((byte)48);
            this.recipientIdIssuer = null;
            this.recipientIdRKeyId = null;
            this.recipientIdMLKeyId = new MailListKeyIdentifier(derValue2.toByteArray(), this.provider);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "RecipientInfo parsing error");
            }
            throw new IOException("RecipientInfo parsing error");
        }
        boolean bl = false;
        derValue2 = derValue.getData().getDerValue();
        if (derValue2.isContextSpecific()) {
            DerValue derValue3 = derValue2.getData().getDerValue();
            if (derValue3.getTag() == 48) {
                this.originatorCertIssuer = new IssuerAndSerialNumber(derValue3.toByteArray(), this.provider);
                this.originatorCertSKeyId = null;
            } else if (derValue3.getTag() == 4) {
                this.originatorCertIssuer = null;
                this.originatorCertSKeyId = derValue3.getOctetString();
            } else {
                this.originatorCertIssuer = null;
                this.originatorCertSKeyId = null;
            }
            bl = true;
        }
        this.keyEncryptionAlgorithm = bl ? AlgorithmId.parse(derValue.getData().getDerValue()) : AlgorithmId.parse(derValue2);
        this.setEncryptedKeyValue(derValue.getData().getOctetString());
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof RecipientInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((RecipientInfo)object)));
            }
            return this.equals((RecipientInfo)object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((RecipientInfo)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "";
        string = string + "\tversion: " + this.version.intValue();
        string = string + "\r\n\trecipient identifier: \r\n";
        if (this.recipientIdIssuer != null) {
            string = string + this.recipientIdIssuer;
        } else if (this.recipientIdRKeyId != null) {
            string = string + this.recipientIdRKeyId;
        } else if (this.recipientIdMLKeyId != null) {
            string = string + this.recipientIdMLKeyId;
        }
        string = string + "\r\n\toriginator certificate: ";
        if (this.originatorCertIssuer == null && this.originatorCertSKeyId == null) {
            string = string + "null";
        } else if (this.originatorCertIssuer != null) {
            string = string + "\r\n" + this.originatorCertIssuer;
        } else if (this.originatorCertSKeyId != null) {
            string = string + "\r\n" + hexDumpEncoder.encode(this.originatorCertSKeyId);
        }
        string = string + "\r\n\tkey encryption algorithm: " + this.keyEncryptionAlgorithm;
        string = string + "\r\n\tencrypted key: \r\n" + hexDumpEncoder.encode(this.getEncryptedKeyValue());
        return string;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            RecipientInfo recipientInfo = new RecipientInfo(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", recipientInfo);
            }
            return recipientInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public byte[] getEncryptedKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedKey");
        }
        if (this.encryptedKey == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptedKey", null);
            }
            return null;
        }
        byte[] byArray = (byte[])this.getEncryptedKeyValue().clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptedKey", byArray);
        }
        return byArray;
    }

    public AlgorithmId getKeyEncryptionAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyEncryptionAlgorithm");
        }
        if (this.keyEncryptionAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyEncryptionAlgorithm", null);
            }
            return null;
        }
        AlgorithmId algorithmId = new AlgorithmId(this.keyEncryptionAlgorithm.getOID(), this.keyEncryptionAlgorithm.getParameters(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getKeyEncryptionAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    public RecipientIdentifier getRecipientIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientIdentifier");
        }
        RecipientIdentifier recipientIdentifier = null;
        if (this.recipientIdIssuer != null) {
            recipientIdentifier = (RecipientIdentifier)this.recipientIdIssuer.clone();
        } else if (this.recipientIdRKeyId != null) {
            recipientIdentifier = (RecipientIdentifier)this.recipientIdRKeyId.clone();
        } else if (this.recipientIdMLKeyId != null) {
            recipientIdentifier = (RecipientIdentifier)this.recipientIdMLKeyId.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientIdentifier", recipientIdentifier);
        }
        return recipientIdentifier;
    }

    public EntityIdentifier getEntityIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getEntityIdentifier");
        }
        if (this.originatorCertIssuer != null) {
            EntityIdentifier entityIdentifier = (EntityIdentifier)this.originatorCertIssuer.clone();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier", entityIdentifier);
            }
            return entityIdentifier;
        }
        if (this.originatorCertSKeyId != null) {
            SubjectKeyIdentifier subjectKeyIdentifier = null;
            try {
                subjectKeyIdentifier = new SubjectKeyIdentifier(this.provider);
                subjectKeyIdentifier.setIdentifier(this.originatorCertSKeyId);
            }
            catch (PKCSException pKCSException) {
                if (debug != null) {
                    debug.exception(16384L, className, "getEntityIdentifier", pKCSException);
                }
                subjectKeyIdentifier = null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier", subjectKeyIdentifier);
            }
            return subjectKeyIdentifier;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEntityIdentifier", null);
        }
        return null;
    }

    public boolean identifies(Certificate certificate) throws IOException {
        BigInteger bigInteger;
        X500Name x500Name;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "identifies", certificate);
        }
        if (this.recipientIdIssuer == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier_1", new Boolean(false));
            }
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        Principal principal = x509Certificate.getIssuerDN();
        X500Name x500Name2 = new X500Name(principal.getName());
        if (!x500Name2.equals(x500Name = this.recipientIdIssuer.getIssuer())) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier_1", new Boolean(false));
            }
            return false;
        }
        BigInteger bigInteger2 = x509Certificate.getSerialNumber();
        if (!bigInteger2.equals(bigInteger = this.recipientIdIssuer.getSerialNumber())) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier_1", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEntityIdentifier", new Boolean(true));
        }
        return true;
    }

    private void encryptKey(byte[] byArray, Certificate certificate) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "encryptKey", byArray, certificate);
        }
        PublicKey publicKey = certificate.getPublicKey();
        String string = certificate.getPublicKey().getAlgorithm();
        try {
            Cipher cipher = this.provider != null ? Cipher.getInstance(string, this.provider) : Cipher.getInstance(string);
            cipher.init(1, publicKey);
            this.setEncryptedKeyValue(cipher.doFinal(byArray));
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "encryptKey", exception);
            }
            throw new PKCSException(exception, "Key encryption error (" + exception.toString() + ")");
        }
        if (debug != null) {
            debug.exit(16384L, className, "encryptKey");
        }
    }

    public byte[] decryptKey(PrivateKey privateKey) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decryptKey", privateKey);
        }
        try {
            String string = this.keyEncryptionAlgorithm.getName();
            Cipher cipher = null;
            cipher = this.provider != null ? Cipher.getInstance(string, this.provider) : Cipher.getInstance(string);
            cipher.init(2, privateKey);
            byte[] byArray = cipher.doFinal(this.getEncryptedKeyValue());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decryptKey", byArray);
            }
            return byArray;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "decryptKey", exception);
            }
            throw new PKCSException(exception, "Key decryption error (" + exception.toString() + ")");
        }
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.valueOf(2L);
        if (this.originatorCertIssuer == null && this.originatorCertSKeyId == null && this.recipientIdIssuer != null) {
            this.version = BigInteger.ZERO;
        }
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }

    private void setEncryptedKeyValue(byte[] byArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncryptedKeyValue", (Object)byArray);
        }
        this.encryptedKey = new SmudgedBytes(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "setEncryptedKeyValue");
        }
    }

    private byte[] getEncryptedKeyValue() {
        if (debug != null) {
            debug.entry(8192L, className, "getEncryptedKeyValue");
        }
        if (this.encryptedKey == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getEncryptedKeyValue", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getEncryptedKeyValue", this.encryptedKey.getClearText());
        }
        return this.encryptedKey.getClearText();
    }

    protected void finalize() {
        this.encryptedKey = null;
    }
}

