/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public final class OriginatorInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_CERTS = 0;
    private static final byte TAG_CRLS = 1;
    private Certificate[] certs;
    private CRL[] crls;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.OriginatorInfo";

    public OriginatorInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "OriginatorInfo", (Object)byArray);
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "OriginatorInfo", byArray, string);
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(Certificate[] certificateArray, CRL[] cRLArray) {
        this(certificateArray, cRLArray, null);
        if (debug != null) {
            debug.entry(16384L, className, "OriginatorInfo", certificateArray, cRLArray);
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(Certificate[] certificateArray, CRL[] cRLArray, String string) {
        super(string);
        int n;
        if (debug != null) {
            Object[] objectArray = new Object[]{certificateArray, cRLArray, string};
            debug.entry(16384L, (Object)className, "OriginatorInfo", objectArray);
        }
        if (certificateArray != null) {
            for (int i = 0; i < certificateArray.length; ++i) {
                if (certificateArray[i] instanceof X509Certificate) continue;
                if (debug != null) {
                    debug.text(16384L, className, "OriginatorInfo", "Invalid certificate type for element " + i + ".  Only X509 certificates are supported.");
                }
                throw new IllegalArgumentException("Invalid certificate type " + certificateArray[i].getClass().getName() + " for element " + i + ".  Only X509 certificates are supported.");
            }
        }
        this.certs = certificateArray;
        if (cRLArray != null && (n = 0) < cRLArray.length) {
            if (!(cRLArray[n] instanceof X509CRL) && debug != null) {
                debug.text(16384L, className, "OriginatorInfo", "Invalid CRL type for element " + n + ".  Only X509 CRLs are supported.");
            }
            throw new IllegalArgumentException("Invalid CRL type for element " + n + ".  Only X509 CRLs are supported.");
        }
        this.crls = cRLArray;
        if (debug != null) {
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "OriginatorInfo", string, new Boolean(bl));
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public OriginatorInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "OriginatorInfo", objectArray);
            debug.exit(16384L, className, "OriginatorInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            OriginatorInfo originatorInfo = new OriginatorInfo(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", originatorInfo);
            }
            return originatorInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerEncoder[] derEncoderArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        try {
            if (this.certs != null && this.certs.length > 0) {
                derEncoderArray = new DerOutputStream[this.certs.length];
                for (int i = 0; i < this.certs.length; ++i) {
                    derEncoderArray[i] = new DerOutputStream();
                    ((OutputStream)((Object)derEncoderArray[i])).write(this.certs[i].getEncoded());
                }
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putOrderedSetOf((byte)49, derEncoderArray);
                derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", certificateEncodingException);
                debug.text(16384L, className, "encode", "Error encoding certificates.");
            }
            throw new IOException("Error encoding certificates.");
        }
        try {
            if (this.crls != null && this.crls.length > 0) {
                derEncoderArray = new DerOutputStream[this.crls.length];
                for (int i = 0; i < this.crls.length; ++i) {
                    if (!(this.crls[i] instanceof X509CRL)) {
                        if (debug != null) {
                            debug.text(16384L, className, "encode", "Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of X509CRL are supported.");
                        }
                        throw new IOException("Element crls[" + i + "] has a type of " + this.crls[i].getClass().getName() + ".  Only instances of X509CRL are supported.");
                    }
                    derEncoderArray[i] = new DerOutputStream();
                    X509CRL x509CRL = (X509CRL)this.crls[i];
                    ((OutputStream)((Object)derEncoderArray[i])).write(x509CRL.getEncoded());
                }
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.putOrderedSetOf((byte)49, derEncoderArray);
                derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream4);
            }
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding crls.");
            }
            throw new IOException("Error encoding crls.");
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "OriginatorInfo parsing error");
            }
            throw new IOException("OriginatorInfo parsing error");
        }
        try {
            while (derValue.getData().available() != 0) {
                DerValue[] derValueArray;
                DerInputStream derInputStream;
                DerValue derValue2 = derValue.getData().getDerValue();
                if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
                    derInputStream = new DerInputStream(derValue2.toByteArray());
                    derValueArray = derInputStream.getSet(1, true);
                    this.certs = new X509Certificate[derValueArray.length];
                    Object var5_7 = null;
                    for (int i = 0; i < derValueArray.length; ++i) {
                        this.certs[i] = new X509CertImpl(derValueArray[i].toByteArray());
                    }
                }
                if (!derValue2.isContextSpecific((byte)1) || !derValue2.isConstructed()) continue;
                derInputStream = new DerInputStream(derValue2.toByteArray());
                derValueArray = derInputStream.getSet(1, true);
                this.crls = new X509CRL[derValueArray.length];
                for (int i = 0; i < derValueArray.length; ++i) {
                    this.crls[i] = new X509CRLImpl(derValueArray[i].toByteArray());
                }
            }
        }
        catch (CertificateException certificateException) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "error decoding certificates " + certificateException);
            }
            throw new IOException("error decoding certificates " + certificateException);
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "error decoding certificates " + cRLException);
            }
            throw new IOException("error decoding crls " + cRLException);
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof OriginatorInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((OriginatorInfo)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public Certificate[] getCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificates");
        }
        if (this.certs == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificates", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates", this.certs.clone());
        }
        return (Certificate[])this.certs.clone();
    }

    public CRL[] getCRLs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCRLs");
        }
        if (this.crls == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCRLs", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs", this.crls.clone());
        }
        return (CRL[])this.crls.clone();
    }

    public String toString() {
        int n;
        String string = "";
        string = string + "\tcertificates: ";
        if (this.certs == null || this.certs.length == 0) {
            string = string + "null";
        } else {
            for (n = 0; n < this.certs.length; ++n) {
                string = string + "\r\n\tcertificate[" + n + "] :\r\n" + this.certs[n];
            }
        }
        string = string + "\r\n\tcertificate revocation lists: ";
        if (this.crls == null || this.crls.length == 0) {
            string = string + "null";
        } else {
            for (n = 0; n < this.crls.length; ++n) {
                string = string + "\r\n\tcrl[" + n + "] :\r\n" + this.crls[n];
            }
        }
        return string;
    }
}

