/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.DSAPKCS11PrivateKey;
import com.ibm.crypto.pkcs11.provider.DSAPKCS11PublicKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;

public class DatawithDSA
extends Signature {
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private boolean isSign;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_SIGN = 1;
    private static final int STATE_VERIFY = 2;
    private int state = 0;
    private static final int ARRAY_SIZE_INC = 256;
    private int dataSize = 0;
    private byte[] data = new byte[256];
    private static final String[] STATE_DESCRIPTION = new String[]{"UNINITIALIZED", "SIGN", "VERIFY"};

    public DatawithDSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        super("SHA/DSA");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        int n = 18;
        if (!(privateKey instanceof DSAPKCS11PrivateKey)) {
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        DSAPKCS11PrivateKey dSAPKCS11PrivateKey = (DSAPKCS11PrivateKey)privateKey;
        this.isSign = true;
        this.session = dSAPKCS11PrivateKey.getSession();
        this.keyObject = dSAPKCS11PrivateKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 17) {
                bl = true;
                n = 17;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new UnsupportedOperationException("The token does not support DSA signature");
        }
        this.session.signInit(n, null, this.keyObject);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        int n = 18;
        if (!(publicKey instanceof DSAPublicKey) && !(publicKey instanceof DSAPKCS11PublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPKCS11PublicKey dSAPKCS11PublicKey = (DSAPKCS11PublicKey)publicKey;
        this.isSign = false;
        this.session = dSAPKCS11PublicKey.getSession();
        this.keyObject = dSAPKCS11PublicKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 17) {
                bl = true;
                n = 17;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new UnsupportedOperationException("The token does not support DSA verification");
        }
        this.session.verifyInit(n, null, this.keyObject);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[40];
        byte[] byArray2 = new byte[200];
        int n = 20;
        byte[] byArray3 = null;
        if (this.dataSize >= n) {
            byArray3 = new byte[n];
            System.arraycopy(this.data, 0, byArray3, 0, n);
        } else {
            byArray3 = new byte[this.dataSize];
            System.arraycopy(this.data, 0, byArray3, 0, this.dataSize);
        }
        n = this.session.sign(this.data, 0, this.data.length, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray, 0, n);
        try {
            byte[] byArray4 = new byte[20];
            byte[] byArray5 = new byte[20];
            System.arraycopy(byArray, 0, byArray4, 0, 20);
            System.arraycopy(byArray, 20, byArray5, 0, 20);
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(new BigInteger(1, byArray4));
            derOutputStream.putInteger(new BigInteger(1, byArray5));
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.data.length <= this.dataSize + 1) {
            int n = this.dataSize + 256;
            byte[] byArray = new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, this.dataSize);
            this.data = byArray;
        }
        this.data[this.dataSize] = by;
        ++this.dataSize;
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.data.length <= this.dataSize + n2) {
            int n3 = this.dataSize + n2 + 256;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.data, 0, byArray2, 0, this.dataSize);
            this.data = byArray2;
        }
        System.arraycopy(byArray, n, this.data, this.dataSize, n2);
        this.dataSize += n2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object[] objectArray;
        byte[] byArray2 = new byte[40];
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            objectArray = derInputStream.getSequence(2);
            byte[] byArray3 = objectArray[0].getInteger().toByteArray();
            byte[] byArray4 = objectArray[1].getInteger().toByteArray();
            int n = byArray3.length;
            if (n > 20) {
                System.arraycopy(byArray3, n - 20, byArray2, 0, 20);
            } else {
                System.arraycopy(byArray3, 0, byArray2, 20 - n, n);
            }
            n = byArray4.length;
            if (n > 20) {
                System.arraycopy(byArray4, n - 20, byArray2, 20, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray2, 40 - n, n);
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature :" + iOException);
        }
        int n = 20;
        objectArray = null;
        if (this.dataSize >= n) {
            objectArray = new byte[n];
            System.arraycopy(this.data, 0, objectArray, 0, n);
        } else {
            if (this.dataSize == 0) {
                return false;
            }
            objectArray = new byte[this.dataSize];
            System.arraycopy(this.data, 0, objectArray, 0, this.dataSize);
        }
        this.dataSize = 0;
        return this.session.verify((byte[])objectArray, 0, objectArray.length, byArray2, 0, byArray2.length);
    }

    private BigInteger multiplicativeInverse(BigInteger bigInteger, BigInteger bigInteger2) {
        boolean bl;
        BigInteger bigInteger3 = bigInteger2;
        BigInteger bigInteger4 = bigInteger;
        BigInteger bigInteger5 = BigInteger.ZERO;
        BigInteger bigInteger6 = BigInteger.ONE;
        do {
            BigInteger bigInteger7 = bigInteger3.divide(bigInteger4);
            BigInteger bigInteger8 = bigInteger4;
            bigInteger4 = bigInteger3.subtract(bigInteger7.multiply(bigInteger8));
            bigInteger3 = bigInteger8;
            bigInteger8 = bigInteger6;
            bigInteger6 = bigInteger5.subtract(bigInteger7.multiply(bigInteger8));
            bigInteger5 = bigInteger8;
        } while (bl = bigInteger4.compareTo(BigInteger.ZERO) > 0);
        return bigInteger5.mod(bigInteger2);
    }
}

