/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvEnvData;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.Sdff;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class SDFFEnvData
extends DvEnvData {
    private int java_version_size;
    private byte[] java_version;
    private int jhd_size;
    private byte[] java_home_dir;
    private int jdd_size;
    private byte[] java_dll_dir;
    private int env_var_size;
    private byte[] env_var;
    private int classpath_size;
    private byte[] classpath;
    private byte[] metadata;
    private long metadata_offset;

    public String javaHomeDir() {
        String string;
        block2: {
            string = null;
            if (null == this.java_home_dir) break block2;
            try {
                string = new String(this.java_home_dir, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = " !!! Encoding exception caught !!!";
            }
        }
        return string;
    }

    public String javaDllDir() {
        String string;
        block2: {
            string = null;
            if (null == this.java_dll_dir) break block2;
            try {
                string = new String(this.java_dll_dir, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = " !!! Encoding exception caught !!!";
            }
        }
        return string;
    }

    public String javaVersion() {
        String string;
        block2: {
            string = null;
            if (null == this.java_version) break block2;
            try {
                string = new String(this.java_version, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = " !!! Encoding exception caught !!!";
            }
        }
        return string;
    }

    public Vector envVars() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        int n3 = 0;
        while (n3 < this.env_var.length) {
            if (this.env_var[n3] != 0) {
                ++n;
            } else {
                if (n != 0) {
                    byArray = new byte[n + 1];
                    int n4 = 0;
                    while (n4 < n + 1) {
                        byArray[n4] = this.env_var[n4 + n2];
                        ++n4;
                    }
                    String string = "";
                    try {
                        string = new String(byArray, "ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        DvUtils.writetoTrace("\tUnsupportedEncodingException (ASCII)");
                    }
                    DvUtils.writetoTrace("\tAdding environment variable:" + string);
                    vector.add(string);
                    byArray = null;
                }
                n = 0;
                n2 = n3;
            }
            ++n3;
        }
        return vector;
    }

    public String classpath() {
        String string;
        block2: {
            string = null;
            if (null == this.classpath) break block2;
            try {
                string = new String(this.classpath, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = " !!! Encoding exception caught !!!";
            }
        }
        return string;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public static SDFFEnvData loadFromFile(long l, RandomAccessFile randomAccessFile) {
        DvUtils.writetoTrace("Entry to SDFFEnvData:loadFromFile...");
        long l2 = l;
        DvUtils.writetoTrace("  .... Loading SDFFEnvData object from file :" + l);
        SDFFEnvData sDFFEnvData = new SDFFEnvData();
        try {
            randomAccessFile.seek(l2);
            long l3 = randomAccessFile.readLong();
            DvUtils.writetoTrace("\tEnvData length is:" + l3);
            if (l3 >= 48L) {
                randomAccessFile.skipBytes(8);
                sDFFEnvData.java_version_size = 32;
                sDFFEnvData.java_version = new byte[sDFFEnvData.java_version_size];
                randomAccessFile.read(sDFFEnvData.java_version);
                sDFFEnvData.jhd_size = randomAccessFile.readInt();
                sDFFEnvData.java_home_dir = new byte[sDFFEnvData.jhd_size];
                randomAccessFile.read(sDFFEnvData.java_home_dir);
                sDFFEnvData.jdd_size = randomAccessFile.readInt();
                sDFFEnvData.java_dll_dir = new byte[sDFFEnvData.jdd_size];
                randomAccessFile.read(sDFFEnvData.java_dll_dir);
                sDFFEnvData.env_var_size = randomAccessFile.readInt();
                DvUtils.writetoTrace("\t Environment variable length is:" + sDFFEnvData.env_var_size);
                if (0 == sDFFEnvData.env_var_size) {
                    DvUtils.writetoTrace("\tAlternative loading of EnvData");
                    sDFFEnvData.env_var = new byte[(int)l3 - 52];
                    randomAccessFile.read(sDFFEnvData.env_var);
                } else {
                    sDFFEnvData.env_var = new byte[sDFFEnvData.env_var_size];
                    randomAccessFile.read(sDFFEnvData.env_var);
                }
                sDFFEnvData.classpath_size = randomAccessFile.readInt();
                sDFFEnvData.classpath = new byte[sDFFEnvData.classpath_size];
                randomAccessFile.read(sDFFEnvData.classpath);
                randomAccessFile.seek(l2 + l3 - 8L);
                sDFFEnvData.metadata_offset = randomAccessFile.readLong();
                if (-1L != sDFFEnvData.metadata_offset) {
                    sDFFEnvData.metadata = new byte[(int)sDFFEnvData.metadata_offset];
                    randomAccessFile.seek(l2 + l3 - 8L - sDFFEnvData.metadata_offset);
                    randomAccessFile.read(sDFFEnvData.metadata);
                }
            }
        }
        catch (IOException iOException) {
            DvUtils.errorMsg("IOException in SDFFEnvData: loadFromFile", 0);
            String string = iOException.getMessage();
            if (null != string) {
                System.out.println(string);
            }
            iOException.printStackTrace(System.out);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            DvUtils.errorMsg("OutOfMemoryError in SDFFEnvData: loadFromFile", 0);
        }
        DvUtils.writetoTrace("Exit from SDFFEnvData:loadFromFile");
        return sDFFEnvData;
    }

    void printSdff(Sdff sdff) throws IOException {
        System.out.println("print Environment TBD");
    }
}

