/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvMenuItem;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmds;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmdsGui;
import java.util.Vector;
import javax.swing.JInternalFrame;

public class DvBaseFmtCmdsSovGui
extends DvBaseFmtCmdsGui {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvBaseFmtCmdsSovGui";
    public static DvBaseFmtCmdsSovGui selfRef;

    public DvBaseFmtCmdsSovGui() {
        selfRef = this;
    }

    public Vector guiMenus() {
        Vector vector = super.guiMenus();
        vector.add(new DvMenuItem("Format", "Execenv (current thread)", -1, null, false, "formatExecEnv", thisName, null, "formatDoubleClick", null, null, false, "Format the execenv for current thread"));
        vector.add(new DvMenuItem("Format", "JVM", -1, null, false, "formatJVM", thisName, null, "formatDoubleClick", null, null, false, "Format the JVM control block"));
        return vector;
    }

    public static void formatExecEnv(String string) {
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (null != dvAddressSpace && null != dvThread) {
            long l = dvThread.eeAddress().getAddressAsLong();
            DvAddress dvAddress = dvAddressSpace.createAddress(l);
            String string2 = "Format execenv @0x" + Long.toHexString(l);
            if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                String string3 = "Error Format of execenv failed\n";
                CTypeObject cTypeObject = DvBaseFmtCmds.formatGeneric(dvAddress, "execenv", dvAddressSpace);
                if (null != cTypeObject) {
                    DvUtils.writetoTrace("  ... CTypeObject obtained");
                    string3 = cTypeObject.toString();
                } else {
                    DvUtils.writetoTrace(" Format of execenv failed!!!!");
                }
                JInternalFrame jInternalFrame = DvBaseFmtCmdsGui.setupFormatFrame(string3, string2, string);
            } else {
                DvUtils.writetoTrace(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
            }
        } else {
            DvUtils.writetoTrace(" formatExecEnv:No valid address space/thread found");
        }
    }

    public static void formatJVM(String string) {
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        if (null != dvThread) {
            long l = DvUtils.jvmFromThreadId(dvThread.id());
            String string2 = "Error Format of JVM failed\n";
            String string3 = DvUtils.getJVMHint(l, "JVM");
            if (null != string3) {
                long l2 = Long.parseLong(string3, 16);
                DvAddress dvAddress = dvAddressSpace.createAddress(l2);
                String string4 = "Format jvm @0x" + Long.toHexString(l2);
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvBaseFmtCmds.formatGeneric(dvAddress, "Jvm", dvAddressSpace);
                    if (null != cTypeObject) {
                        DvUtils.writetoTrace("  ... CTypeObject obtained");
                        string2 = cTypeObject.toString();
                    } else {
                        DvUtils.writetoTrace(" Format of jvm failed!!!!");
                    }
                    JInternalFrame jInternalFrame = DvBaseFmtCmdsGui.setupFormatFrame(string2, string4, string);
                } else {
                    DvUtils.writetoTrace(" Address " + Long.toHexString(l2) + " is not available in the dump");
                }
            } else {
                DvUtils.writetoTrace(" Unable to comply - no hint found for JVM");
            }
        } else {
            DvUtils.writetoTrace(" formatExecEnv:No valid address space found");
        }
    }
}

