/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import java.io.File;
import java.io.IOException;

class AIXLdInfo {
    long next;
    long ldinfo_flags;
    long core_offset;
    long textorg;
    long textsize;
    long dataorg;
    long datasize;
    File library;
    String member;

    AIXLdInfo(DvFileReader dvFileReader) throws IOException {
        boolean bl = dvFileReader.wordLength.size == 8;
        this.next = dvFileReader.readWord();
        if (bl) {
            this.ldinfo_flags = dvFileReader.readWord();
            this.core_offset = dvFileReader.readLong();
            this.textorg = dvFileReader.readAddress();
            this.textsize = dvFileReader.readLong();
            this.dataorg = dvFileReader.readAddress();
            this.datasize = dvFileReader.readLong();
        } else {
            this.core_offset = dvFileReader.readWord();
            this.textorg = dvFileReader.readAddress();
            this.textsize = dvFileReader.readWord();
            this.dataorg = dvFileReader.readAddress();
            this.datasize = dvFileReader.readWord();
        }
        this.library = new File(dvFileReader.readString());
        this.member = dvFileReader.readString();
    }

    String filename() {
        return this.library.getName();
    }

    String directory() {
        return this.library.getParent();
    }

    String pathname() {
        return this.library.getPath();
    }

    String name() {
        StringBuffer stringBuffer = new StringBuffer(this.library.getPath().length() + this.member.length() + 2);
        stringBuffer.append(this.library.getPath());
        if (this.member.length() != 0) {
            stringBuffer.append("(" + this.member + ")");
        }
        return stringBuffer.toString();
    }

    void dump() {
        DvUtils.trace("Library " + this.name(), 2, false);
        DvUtils.trace("Text @ 0x" + Long.toHexString(this.textorg) + " Size 0x" + Long.toHexString(this.textsize), 2, false);
        DvUtils.trace("Data @ 0x" + Long.toHexString(this.dataorg) + " Size 0x" + Long.toHexString(this.datasize), 2, false);
        DvUtils.trace("core_offset = 0x" + Long.toHexString(this.core_offset), 2, false);
        DvUtils.trace("next = " + this.next, 2, false);
    }
}

