/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.ExEnvData;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.Sdff;
import java.io.File;
import java.io.IOException;

public class AIXEnvData
extends ExEnvData {
    byte[] javaVersion = new byte[32];
    StringBuffer javaDLLDir;
    StringBuffer javaHome;
    static String threeSpaces = "   ";

    AIXEnvData(String string) {
        this.javaDLLDir = new StringBuffer(string);
        if (string.length() % 4 != 0) {
            this.javaDLLDir.append(threeSpaces.substring(0, 4 - string.length() % 4));
        }
        this.javaHome = new StringBuffer(new File(string).getParent());
        if (this.javaHome.length() % 4 != 0) {
            this.javaHome.append(threeSpaces.substring(0, 4 - this.javaHome.length() % 4));
        }
        this.javaVersion = "-|java-version|--|java-version|-".getBytes();
    }

    void printSdff(Sdff sdff) throws IOException {
        DvUtils.trace("Printing Environment", 2, false);
        DvUtils.trace("java version is " + new String(this.javaVersion) + "\njavaHome is " + this.javaHome + "\njavaDLLDir is " + this.javaDLLDir, 2, false);
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeBytes("ENVDATA ");
        sdff.write(this.javaVersion);
        sdff.writeInt(this.javaHome.length());
        sdff.writeBytes(this.javaHome.toString());
        sdff.writeInt(this.javaDLLDir.length());
        sdff.writeBytes(this.javaDLLDir.toString());
        sdff.align(4);
        sdff.writeInt(0);
        sdff.writeInt(0);
        sdff.writeLong(-1L);
        sdff.printLength(l);
        sdff.align(8);
        DvUtils.trace("Environment: wrote " + (sdff.getFilePointer() - l) + "bytes", 2, false);
    }
}

