/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.ASN1OID;
import com.ibm.asn1.DEREncoder;
import com.ibm.cfwk.CFWKException;
import com.ibm.cfwk.InterfaceErrorException;
import com.ibm.cfwk.KeyMaterial;
import com.ibm.cfwk.MalformedDataException;
import com.ibm.cfwk.key.RSAKey;
import com.ibm.cfwk.pkcs.PKCS12PBE;
import com.ibm.cfwk.pki.AlgId;
import com.ibm.cfwk.pki.X509Cert;
import com.ibm.cfwk.pki.X509Chain;
import com.ibm.cfwk.pki.X509Exception;
import com.ibm.cfwk.pki.X509Extension;
import com.ibm.cfwk.pki.X509Extensions;
import com.ibm.cfwk.pki.ce.AltNames;
import com.ibm.cfwk.pki.ce.GeneralName;
import com.ibm.cfwk.tools.KeyCertGen;
import com.ibm.cfwk.tools.PrivateKeyAndCertificateChain;
import com.ibm.cfwk.tools.cr.pkcs10.CertificationRequest;
import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMExtensionItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.WEBDBKeyDatabase;
import com.ibm.gsk_sslight.KeyStore;
import com.ibm.gsk_sslight.KeyStoreException;
import com.ibm.gsk_sslight.SSLCert;
import com.ibm.gsk_sslight.SSLException;
import com.ibm.sslight.SSLightKeyRing;
import com.ibm.util.x500name.X500Name;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class SSLightKeyDatabase
extends KeyDatabase
implements KeyDatabaseOperator {
    static final String BASE64BEGINCERT = "-----BEGIN CERTIFICATE-----";
    static final String BASE64ENDCERT = "-----END CERTIFICATE-----";
    static final String BASE64BEGIN = "-----BEGIN";
    static final String BASE64END = "-----END";
    static final String BASE64BEGINPEM = "-----BEGIN PRIVACY-ENHANCED MESSAGE-----";
    static final String BASE64ENDPEM = "-----END PRIVACY-ENHANCED MESSAGE-----";
    static final String BASE64BEGINX509CERT = "-----BEGIN X509 CERTIFICATE-----";
    static final String BASE64ENDX509CERT = "-----END X509 CERTIFICATE-----";
    static final String BASE64BEGINPKCS7SIGNEDDATA = "-----BEGIN PKCS #7 SIGNED DATA-----";
    static final String BASE64ENDPKCS7SIGNEDDATA = "-----END PKCS #7 SIGNED DATA-----";
    static final String[][] BeginEndCertificateIndicator = new String[][]{{"-----BEGIN PRIVACY-ENHANCED MESSAGE-----", "-----END PRIVACY-ENHANCED MESSAGE-----"}, {"-----BEGIN PKCS #7 SIGNED DATA-----", "-----END PKCS #7 SIGNED DATA-----"}, {"-----BEGIN X509 CERTIFICATE-----", "-----END X509 CERTIFICATE-----"}, {"-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----"}, {"-----BEGIN", "-----END"}};
    static final String Armored64RdChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static final String Armored64WrChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    static final int Armored64PadIndx = 64;
    static final int Armored64MaxLine = 64;
    static final int[] nameComps = new int[]{3, 7, 11, 10, 6};
    static final String[] compLabs = new String[]{"CN=", "L=", "OU=", "O=", "C="};
    static String classPackage = KeyDatabase.DEFAULT_SSLIGHT_PACKAGE_NAME;
    static String className = null;
    private KeyStore ks = null;
    private Vector certList = null;
    private boolean databaseUpdated = false;
    public static boolean nopassword = true;
    static final String CLASS1_ROOT_LABEL = "Verisign Class 1 Public Primary Certification Authority";
    static final String CLASS2_ROOT_LABEL = "Verisign Class 2 Public Primary Certification Authority";
    static String CLASS3_ROOT_LABEL = "Verisign Class 3 Public Primary Certification Authority";
    static final String RSA_SECURE_SERVER_CA_LABEL = "RSA Secure Server Certification Authority";
    static final String VERISIGN_TEST_CA_LABEL = "Verisign Test CA Root Certificate";
    static final String THAWTE_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Server CA";
    static final String THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Premium Server CA";
    static final String THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Basic CA";
    static final String THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Freemail CA";
    static final String THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Premium CA";
    static final String CLASS1_INTERMEDIATE_LABEL = "VeriSign Class 1 CA Individual Subscriber-Persona Not Validated";
    static final String CLASS2_INTERMEDIATE_LABEL = "VeriSign Class 2 CA Individual Subscriber-Persona Not Validated";
    static final String CLASS3_INTERMEDIATE_LABEL = "VeriSign Class 3 CA Individual Subscriber-Persona Not Validated";

    public SSLightKeyDatabase() {
        this.type = 3;
        this.op = this;
        this.ks = new KeyStore();
    }

    public SSLightKeyDatabase(String string) {
        super(3, string);
        this.op = this;
        this.ks = new KeyStore();
    }

    public SSLightKeyDatabase(KeyDatabase keyDatabase) {
        super(keyDatabase);
        this.type = 3;
        this.op = this;
        this.ks = new KeyStore();
        this.databaseUpdated = true;
    }

    public SSLightKeyDatabase(String string, String string2) {
        super(3, string, string2);
        this.op = this;
        this.ks = new KeyStore();
    }

    public SSLightKeyDatabase(String string, String string2, long l) {
        super(3, string, string2, l);
        this.op = this;
        this.ks = new KeyStore();
    }

    public void setPackageName(String string) {
        classPackage = string;
    }

    public void create() throws SSLightKeyDatabaseException {
        String string = KMSystem.getInitSetting("DEFAULT_SSLIGHT_CREATE_EMPTY");
        if (string == null || !string.equalsIgnoreCase("true")) {
            this.create(true);
        } else {
            this.create(false);
        }
    }

    private void create(boolean bl) throws SSLightKeyDatabaseException {
        try {
            this.ssltCreateNewKeyDb(this.keyDbFileName, this.keyDbPwd, this.keyDbPwdExpireTime);
            if (bl) {
                this.ssltAddDefaultRootCertificates();
            }
            this.databaseUpdated = true;
            this.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                this.delete();
            }
            catch (IOException iOException2) {
            }
            catch (KeyDatabaseException keyDatabaseException) {
                // empty catch block
            }
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (X509Exception x509Exception) {
            x509Exception.printStackTrace();
            try {
                this.delete();
            }
            catch (IOException iOException) {
            }
            catch (KeyDatabaseException keyDatabaseException) {
                // empty catch block
            }
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        this.buildKeyLabelList();
    }

    public static boolean isPasswordNeeded(String string) throws SSLightKeyDatabaseException, KeyDatabaseException {
        String string2 = "";
        boolean bl = true;
        try {
            LocalClassLoader localClassLoader = new LocalClassLoader(string);
            className = SSLightKeyDatabase.getFullyQualifiedClassName(string);
            Class clazz = localClassLoader.loadClass(SSLightKeyDatabase.getFullyQualifiedClassName(string), false);
            className = null;
            SSLightKeyRing sSLightKeyRing = (SSLightKeyRing)clazz.newInstance();
            String string3 = sSLightKeyRing.getKeyRingData();
            KeyStore keyStore = new KeyStore();
            keyStore.engineLoad(string3, string2.toCharArray());
            bl = false;
        }
        catch (SSLException sSLException) {
            bl = sSLException.getCategory() == 7 && sSLException.getError() == 1012 && KeyDatabase.isPasswordNeededInSetting(3);
        }
        catch (IOException iOException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (Exception exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OPEN"));
        }
        return bl;
    }

    public void open() throws SSLightKeyDatabaseException {
        try {
            LocalClassLoader localClassLoader = new LocalClassLoader(this.keyDbFileName);
            className = SSLightKeyDatabase.getFullyQualifiedClassName(this.keyDbFileName);
            Class clazz = localClassLoader.loadClass(SSLightKeyDatabase.getFullyQualifiedClassName(this.keyDbFileName), false);
            className = null;
            SSLightKeyRing sSLightKeyRing = (SSLightKeyRing)clazz.newInstance();
            String string = sSLightKeyRing.getKeyRingData();
            this.ks = new KeyStore();
            this.ks.engineLoad(string, this.keyDbPwd.toCharArray());
            if (this.keyDbPwd == "") {
                nopassword = true;
            }
        }
        catch (SSLException sSLException) {
            if (sSLException.getCategory() == 7 && sSLException.getError() == 1012) {
                if (this.keyDbPwd != "") {
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INVALID_PASSWORD"));
                }
                nopassword = false;
            }
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (IOException iOException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (Exception exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OPEN"));
        }
        this.buildKeyLabelList();
    }

    public void close() throws SSLightKeyDatabaseException {
        this.save();
    }

    public void save() throws SSLightKeyDatabaseException {
        if (this.databaseUpdated) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.keyDbFileName);
                this.ks.engineStore((OutputStream)fileOutputStream, this.keyDbPwd.toCharArray(), SSLightKeyDatabase.getFullyQualifiedClassName(this.keyDbFileName));
                fileOutputStream.close();
                this.databaseUpdated = false;
            }
            catch (IOException iOException) {
                if (iOException instanceof SSLException && ((SSLException)((Object)iOException)).getError() == 1014) {
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_TOO_LARGE"));
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
            }
            catch (X509Exception x509Exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void reCreate(KeyDatabase var1_1) throws SSLightKeyDatabaseException {
        block37: {
            if (this.keyDbFileName == null || this.keyDbFileName.equals(var1_1.getKeyDbFileName())) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
            }
            try {
                block38: {
                    block39: {
                        if (this.type == var1_1.getType()) break block38;
                        if (var1_1.getType() != 1 && var1_1.getType() != 2) break block39;
                        var2_2 = (KeyDatabaseOperator)var1_1;
                        var2_2.open();
                        this.create(false);
                        var3_5 = null;
                        var4_8 = new Enumeration[3];
                        var5_11 = var1_1.getCaCertLabelList();
                        if (var5_11 != null) {
                            var4_8[0] = var5_11.elements();
                        }
                        if ((var5_11 = var1_1.getMyCertLabelList()) != null) {
                            var4_8[1] = var5_11.elements();
                        }
                        if ((var5_11 = var1_1.getReqKeyLabelList()) != null) {
                            var4_8[2] = var5_11.elements();
                        }
                        var6_14 = 0;
                        while (var6_14 < 3) {
                            block40: {
                                if (var4_8[var6_14] != null) ** GOTO lbl48
                                break block40;
lbl-1000:
                                // 1 sources

                                {
                                    var7_17 = (String)var4_8[var6_14].nextElement();
                                    var8_21 = var2_2.getKeyItemByLabel(var7_17);
                                    if (var6_14 == 1) {
                                        var9_25 /* !! */  = var2_2.getKeyItemListByLabel(var7_17);
                                        var10_28 = var9_25 /* !! */ .length - 1;
                                        while (var10_28 > 0) {
                                            var8_21.addCertificate((CertificateItem)var9_25 /* !! */ [var10_28].getCertificateChain().elementAt(0));
                                            --var10_28;
                                        }
                                    }
                                    if (var8_21.isDefault()) {
                                        var3_5 = var8_21.getKeyLabel();
                                    }
                                    if (var8_21.hasPrivateKey()) {
                                        var9_25 /* !! */  = var8_21.getEncryptedPrivateKeyInfoItem();
                                        var10_29 = null;
                                        if (var1_1.getType() == 1) {
                                            var10_29 = ((CMSKeyDatabase)var1_1).decryptPrivateKey((EncryptedPrivateKeyInfoItem)var9_25 /* !! */ );
                                        } else if (var1_1.getType() == 2) {
                                            var10_29 = ((WEBDBKeyDatabase)var1_1).decryptPrivateKey((EncryptedPrivateKeyInfoItem)var9_25 /* !! */ );
                                        } else {
                                            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
                                        }
                                        var11_31 = KeyCertGen.generateEncryptedPrivateKeyInfo((byte[])var10_29.getEncoded(), (String)this.keyDbPwd, (ASN1OID)PKCS12PBE.SHA1_3DES3);
                                        var12_32 = new EncryptedPrivateKeyInfoItem(var11_31);
                                        var8_21.setEncryptedPrivateKeyInfoItem(var12_32);
                                    }
                                    this.insertKey(var8_21);
lbl48:
                                    // 2 sources

                                    ** while (var4_8[var6_14].hasMoreElements())
                                }
                            }
                            ++var6_14;
                        }
                        var2_2.close();
                        this.save();
                        if (var3_5 != null) {
                            this.setDefaultKey(var3_5);
                        }
                        this.buildKeyLabelList();
                        break block37;
                    }
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
                }
                var2_3 = new KeyStore();
                var3_6 = new File(this.keyDbFileName);
                var4_9 = var3_6.exists();
                var5_12 = null;
                try {
                    var6_15 = var1_1.getKeyDbFileName();
                    var7_18 = new LocalClassLoader(var6_15);
                    SSLightKeyDatabase.className = SSLightKeyDatabase.getFullyQualifiedClassName(var6_15);
                    var8_22 = var7_18.loadClass(SSLightKeyDatabase.getFullyQualifiedClassName(var6_15), false);
                    SSLightKeyDatabase.className = null;
                    var9_26 = (SSLightKeyRing)var8_22.newInstance();
                    var10_30 = var9_26.getKeyRingData();
                    var2_3.engineLoad(var10_30, var1_1.getKeyDbPwd().toCharArray());
                    var5_12 = new FileOutputStream(var3_6);
                    var2_3.engineStore((OutputStream)var5_12, this.keyDbPwd.toCharArray(), SSLightKeyDatabase.getFullyQualifiedClassName(this.keyDbFileName));
                    var5_12.close();
                    this.buildKeyLabelList();
                    this.databaseUpdated = true;
                }
                catch (IOException var6_16) {
                    try {
                        if (var5_12 != null) {
                            var5_12.close();
                        }
                    }
                    catch (IOException var7_19) {
                        var7_19.printStackTrace();
                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
                    }
                    if (!var4_9 && var3_6.exists()) {
                        var3_6.delete();
                    }
                    var6_16.printStackTrace();
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
                }
                catch (X509Exception var7_20) {
                    try {
                        if (var5_12 != null) {
                            var5_12.close();
                        }
                    }
                    catch (IOException var8_23) {
                        var8_23.printStackTrace();
                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
                    }
                    if (!var4_9 && var3_6.exists()) {
                        var3_6.delete();
                    }
                    var7_20.printStackTrace();
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
                }
                catch (Exception var8_24) {
                    try {
                        if (var5_12 != null) {
                            var5_12.close();
                        }
                    }
                    catch (IOException var9_27) {
                        var9_27.printStackTrace();
                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
                    }
                    if (!var4_9 && var3_6.exists()) {
                        var3_6.delete();
                    }
                    var8_24.printStackTrace();
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
                }
            }
            catch (InterfaceErrorException var2_4) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
            }
            catch (CFWKException var3_7) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            }
            catch (ASN1Exception var4_10) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
            }
            catch (KeyDatabaseException var5_13) {
                if (var5_13 instanceof SSLightKeyDatabaseException && var5_13.getMessage().compareTo(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_TOO_LARGE")) == 0) {
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_TOO_LARGE"));
                }
                var5_13.printStackTrace();
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
            }
        }
    }

    public void changeKeyDbPwd(String string, long l) throws SSLightKeyDatabaseException {
        this.changeKeyDbPwd(null, string, l);
    }

    public void changeKeyDbPwd(String string, String string2, long l) throws SSLightKeyDatabaseException {
        if (string != null && !string.equals(this.keyDbPwd)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_OLD_PASSWORD"));
        }
        this.keyDbPwd = string2;
        this.keyDbPwdExpireTime = l;
        this.databaseUpdated = true;
        this.save();
    }

    public static boolean stashKeyDbPwd(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null || string2.length() == 0 || string.length() == 0) {
            return false;
        }
        String string3 = KMUtil.changeFileNameExtension(string, ".sth");
        int n = -11;
        byte[] byArray = new byte[129];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)n2;
            ++n2;
        }
        byte[] byArray2 = string2.getBytes();
        n2 = 0;
        while (n2 < byArray2.length && n2 < byArray.length) {
            byArray[n2] = byArray2[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)(n2 ^ n);
            ++n2;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void buildKeyLabelList() throws SSLightKeyDatabaseException {
        this.keyLabelList = new Vector();
        this.certList = new Vector();
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        this.siteCertLabelList = null;
        this.reqKeyLabelList = null;
        String string = "";
        try {
            Enumeration enumeration = this.ks.engineAliases();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.keyLabelList.addElement(string);
                if (this.ks.engineIsKeyEntry(string)) {
                    X509Cert[] x509CertArray = this.ks.engineGetCertificateChain(string);
                    this.certList.addElement(x509CertArray[0]);
                    X509Extensions x509Extensions = x509CertArray[0].extensions();
                    X509Extension x509Extension = x509Extensions.findExtension(KeyCertGen.GSKCertificationRequestOID);
                    if (x509Extension != null) {
                        this.addReqKeyLabel(string);
                        continue;
                    }
                    this.addMyCertLabel(string);
                    continue;
                }
                if (this.ks.engineIsSiteCertificateEntry(string)) {
                    this.addSiteCertLabel(string);
                    this.certList.addElement(this.ks.engineGetCertificate(string));
                    continue;
                }
                if (this.ks.engineIsCertificateEntry(string)) {
                    this.addCaCertLabel(string);
                    this.certList.addElement(this.ks.engineGetCertificate(string));
                    continue;
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
            }
        }
        catch (ASN1Exception aSN1Exception) {
            aSN1Exception.printStackTrace();
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, String string2, boolean bl2) throws SSLightKeyDatabaseException {
        this.createNewSelfSignedCertificate(n, string, bl, n2, dNItem, n3, 1, string2, bl2, null);
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, int n4, String string2, boolean bl2, Vector vector) throws SSLightKeyDatabaseException {
        String string3;
        if (n2 != 512 && n2 != 1024) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_KEY_SIZE"));
        }
        if (this.ks.engineContainsAlias(string)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
        }
        switch (n4) {
            case 1: {
                string3 = "MD5 with RSA";
                break;
            }
            case 2: {
                string3 = "SHA1 with RSA";
                break;
            }
            default: {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_SIGNATURE_ALGORITHM"));
            }
        }
        try {
            Object object;
            Object object2;
            X500Name x500Name = new X500Name(dNItem.getRFC1779String());
            String string4 = "RSA/512";
            if (n2 == 1024) {
                string4 = "RSA/1024";
            }
            KeyMaterial keyMaterial = KeyCertGen.generateKeyPair((String)string4);
            X509Cert x509Cert = null;
            if (vector != null && vector.size() > 0) {
                object2 = new GeneralName[vector.size()];
                object = new X509Extension[1];
                int n5 = 0;
                while (n5 < vector.size()) {
                    int n6 = ((KMExtensionItem)vector.elementAt(n5)).getFieldType();
                    String string5 = (String)((KMExtensionItem)vector.elementAt(n5)).getFieldValue();
                    object2[n5] = new GeneralName(n6, string5);
                    ++n5;
                }
                object[0] = new AltNames(X509Extension.SUBJECT_ALT_NAMES, false, (GeneralName[])object2);
                x509Cert = KeyCertGen.generateCertificate((KeyMaterial)keyMaterial, (X500Name)x500Name, (int)(n - 1), (int)n3, (String)string3, (X509Extension[])object);
            } else {
                x509Cert = KeyCertGen.generateCertificate((KeyMaterial)keyMaterial, (X500Name)x500Name, (int)(n - 1), (int)n3, (String)string3, null);
            }
            X509Cert[] x509CertArray = new X509Cert[]{x509Cert};
            this.ks.engineSetKeyEntry(string, keyMaterial, this.keyDbPwd.toCharArray(), x509CertArray);
            if (bl) {
                this.ks.engineSetDefaultKeyEntry(string);
            }
            keyMaterial.destroy();
            if (string2 != null) {
                boolean bl3 = true;
                object2 = new File(string2);
                try {
                    bl3 = ((File)object2).exists();
                    object = new FileOutputStream((File)object2);
                    if (bl2) {
                        String string6 = x509Cert.getEncoded("base64");
                        ((FileOutputStream)object).write(string6.getBytes());
                    } else {
                        byte[] byArray = x509Cert.getEncoded();
                        ((FileOutputStream)object).write(byArray);
                    }
                    ((FileOutputStream)object).close();
                }
                catch (IOException iOException) {
                    this.ks.engineDeleteEntry(string);
                    if (!bl3 && ((File)object2).exists()) {
                        ((File)object2).delete();
                    }
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
                }
            }
            this.addKeyLabelAt(string, 0);
            this.addMyCertLabelAt(string, 0);
            this.certList.insertElementAt(x509Cert, 0);
            this.databaseUpdated = true;
            this.resetDefaultKey();
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DN_INPUT"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
        catch (MalformedDataException malformedDataException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, String string2, boolean bl) throws SSLightKeyDatabaseException {
        this.createNewCertRequest(string, n, dNItem, 1, string2, bl, null);
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, int n2, String string2, boolean bl, Vector vector) throws SSLightKeyDatabaseException {
        block21: {
            String string3;
            if (n != 512 && n != 1024) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_KEY_SIZE"));
            }
            if (this.ks.engineContainsAlias(string)) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
            }
            switch (n2) {
                case 1: {
                    string3 = "MD5 with RSA";
                    break;
                }
                case 2: {
                    string3 = "SHA1 with RSA";
                    break;
                }
                default: {
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_SIGNATURE_ALGORITHM"));
                }
            }
            try {
                if (bl) {
                    Object object;
                    Object object2;
                    X500Name x500Name = new X500Name(dNItem.getRFC1779String());
                    String string4 = "RSA/512";
                    if (n == 1024) {
                        string4 = "RSA/1024";
                    }
                    KeyMaterial keyMaterial = KeyCertGen.generateKeyPair((String)string4);
                    X509Cert x509Cert = null;
                    CertificationRequest certificationRequest = null;
                    X509Extension x509Extension = new X509Extension(KeyCertGen.GSKCertificationRequestOID, false);
                    if (vector != null && vector.size() > 0) {
                        GeneralName[] generalNameArray = new GeneralName[vector.size()];
                        object2 = new X509Extension[2];
                        object2[0] = x509Extension;
                        int n3 = 0;
                        while (n3 < vector.size()) {
                            int n4 = ((KMExtensionItem)vector.elementAt(n3)).getFieldType();
                            object = (String)((KMExtensionItem)vector.elementAt(n3)).getFieldValue();
                            generalNameArray[n3] = new GeneralName(n4, (String)object);
                            ++n3;
                        }
                        object2[1] = new AltNames(X509Extension.SUBJECT_ALT_NAMES, false, generalNameArray);
                        certificationRequest = KeyCertGen.generateCertificationRequest((KeyMaterial)keyMaterial, (X500Name)x500Name, (String)string3, (X509Extension[])object2);
                        x509Cert = KeyCertGen.generateCertificate((KeyMaterial)keyMaterial, (X500Name)x500Name, (int)2, (int)365, (String)string3, (X509Extension[])object2);
                    } else {
                        X509Extension[] x509ExtensionArray = new X509Extension[]{x509Extension};
                        certificationRequest = KeyCertGen.generateCertificationRequest((KeyMaterial)keyMaterial, (X500Name)x500Name, (String)string3, null);
                        x509Cert = KeyCertGen.generateCertificate((KeyMaterial)keyMaterial, (X500Name)x500Name, (int)2, (int)365, (String)string3, (X509Extension[])x509ExtensionArray);
                    }
                    X509Cert[] x509CertArray = new X509Cert[]{x509Cert};
                    this.ks.engineSetKeyEntry(string, keyMaterial, this.keyDbPwd.toCharArray(), x509CertArray);
                    keyMaterial.destroy();
                    if (string2 != null) {
                        object = new File(string2);
                        boolean bl2 = ((File)object).exists();
                        try {
                            object2 = new FileOutputStream((File)object);
                            String string5 = certificationRequest.getEncoded("base64");
                            ((FileOutputStream)object2).write(string5.getBytes());
                            ((FileOutputStream)object2).close();
                        }
                        catch (IOException iOException) {
                            this.ks.engineDeleteEntry(string);
                            if (!bl2 && ((File)object).exists()) {
                                ((File)object).delete();
                            }
                            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
                        }
                    }
                    this.addKeyLabelAt(string, 0);
                    this.addReqKeyLabelAt(string, 0);
                    this.databaseUpdated = true;
                    break block21;
                }
                this.extractCertificateRequest(string, n2, string2);
            }
            catch (InterfaceErrorException interfaceErrorException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DN_INPUT"));
            }
            catch (CFWKException cFWKException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            }
            catch (KeyStoreException keyStoreException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
            }
            catch (MalformedDataException malformedDataException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
            }
        }
    }

    public void issueCertificate(String string, int n, String string2, int n2, String string3, String string4, boolean bl) throws SSLightKeyDatabaseException {
        this.issueCertificate(string, n, string2, n2, 1, string3, string4, bl);
    }

    public void issueCertificate(String string, int n, String string2, int n2, int n3, String string3, String string4, boolean bl) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_ISSUE_CERT"));
    }

    public boolean isPrivateKeyPresent(String string) {
        return this.ks.engineIsKeyEntry(string);
    }

    public void refreshKeyLabelList() throws SSLightKeyDatabaseException {
        this.buildKeyLabelList();
    }

    public KeyItem getKeyItemByLabel(String string) throws SSLightKeyDatabaseException {
        if (string == null || !this.ks.engineContainsAlias(string)) {
            return null;
        }
        String string2 = this.ks.engineGetDefaultKeyEntry();
        try {
            KeyItem keyItem = new KeyItem();
            keyItem.setKeyLabel(string);
            X509Cert x509Cert = this.ks.engineGetCertificate(string);
            if (this.ks.engineIsKeyEntry(string)) {
                String string3;
                KeyMaterial keyMaterial = this.ks.engineGetKey(string, this.keyDbPwd.toCharArray());
                byte[] byArray = KeyCertGen.generateEncryptedPrivateKeyInfo((KeyMaterial)keyMaterial, (String)this.keyDbPwd, (ASN1OID)PKCS12PBE.SHA1_RC4_128);
                EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = new EncryptedPrivateKeyInfoItem(byArray);
                keyItem.setEncryptedPrivateKeyInfoItem(encryptedPrivateKeyInfoItem);
                if (x509Cert == null) {
                    return keyItem;
                }
                X500Name x500Name = x509Cert.subject();
                X509Extensions x509Extensions = x509Cert.extensions();
                if (x509Extensions == null || x509Extensions.findExtension(KeyCertGen.GSKCertificationRequestOID) == null) {
                    keyMaterial.destroy();
                    X509Cert[] x509CertArray = this.ks.engineGetCertificateChain(string);
                    keyItem.setKeySize((short)x509CertArray[0].subjectKeySize());
                    int n = 0;
                    while (n < x509CertArray.length) {
                        byte[] byArray2 = x509CertArray[n].getEncoded();
                        CertificateItem certificateItem = this.parseCertificate(x509CertArray[n], byArray2);
                        keyItem.addCertificate(certificateItem);
                        ++n;
                    }
                    keyItem.setTrusted(true);
                    if (string2 != null && string.equals(string2)) {
                        keyItem.setDefault(true);
                    }
                    return keyItem;
                }
                String string4 = x509Cert.signatureKeyAlgId().asn1oid().toString();
                if (string4.equals("1.2.840.113549.1.1.4")) {
                    string3 = "MD5 with RSA";
                } else if (string4.equals("1.2.840.113549.1.1.5")) {
                    string3 = "SHA1 with RSA";
                } else {
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_SIGNATURE_ALGORITHM"));
                }
                CertificationRequest certificationRequest = KeyCertGen.generateCertificationRequest((KeyMaterial)keyMaterial, (X500Name)x500Name, (String)string3, null);
                keyMaterial.destroy();
                byte[] byArray3 = certificationRequest.getEncoded();
                CertificateRequestItem certificateRequestItem = this.parseCertRequest(x509Cert, byArray3);
                return new KeyItem(string, 0, (short)x509Cert.subjectKeySize(), encryptedPrivateKeyInfoItem, certificateRequestItem, null);
            }
            if (x509Cert != null) {
                byte[] byArray = x509Cert.getEncoded();
                CertificateItem certificateItem = new CertificateItem(byArray);
                keyItem.setKeySize((short)x509Cert.subjectKeySize());
                CertificateItem certificateItem2 = this.parseCertificate(x509Cert, byArray);
                keyItem.addCertificate(certificateItem2);
                if (this.ks.engineIsCertificateEntry(string)) {
                    keyItem.setTrusted(true);
                    return keyItem;
                }
                if (this.ks.engineIsSiteCertificateEntry(string)) {
                    keyItem.setSiteCertificate(true);
                    return keyItem;
                }
                return null;
            }
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (CFWKException cFWKException) {
            cFWKException.printStackTrace();
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        return null;
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws SSLightKeyDatabaseException {
        return this.getKeyItemByLabel(string).getKeyItemsForCertChain();
    }

    public KeyItem[] getKeyItemChain(KeyItem keyItem) throws SSLightKeyDatabaseException {
        Vector vector = keyItem.getCertificateChain();
        if (vector == null) {
            KeyItem[] keyItemArray = new KeyItem[]{keyItem};
            return keyItemArray;
        }
        int n = vector.size();
        KeyItem[] keyItemArray = new KeyItem[n];
        int n2 = 0;
        while (n2 < n) {
            CertificateItem certificateItem = (CertificateItem)vector.elementAt(n2);
            KeyItem keyItem2 = new KeyItem((String)null, 0, 0, (EncryptedPrivateKeyInfoItem)null, (Vector)null, new BERObject(certificateItem.getEncoded()), true, false);
            keyItem2.addCertificate(certificateItem);
            keyItem2.setKeySize(certificateItem.getKeySize());
            if (n2 == 0) {
                keyItem2.setKeyLabel(keyItem.getKeyLabel());
                keyItem2.setEncryptedPrivateKeyInfoItem(keyItem.getEncryptedPrivateKeyInfoItem());
            }
            keyItemArray[n2] = keyItem2;
            ++n2;
        }
        return keyItemArray;
    }

    public CertificateItem parseCertificate(X509Cert x509Cert, byte[] byArray) throws SSLightKeyDatabaseException {
        try {
            if (x509Cert == null) {
                return null;
            }
            short s = (short)x509Cert.subjectKeySize();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            if (x509Cert.issuer().attribute(X500Name.COMMON_NAME) != null) {
                string = x509Cert.issuer().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.ORGANIZATIONAL_UNIT) != null) {
                string2 = x509Cert.issuer().attribute(X500Name.ORGANIZATIONAL_UNIT).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.ORGANIZATION) != null) {
                string3 = x509Cert.issuer().attribute(X500Name.ORGANIZATION).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.COUNTRY) != null) {
                string4 = x509Cert.issuer().attribute(X500Name.COUNTRY).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.COMMON_NAME) != null) {
                string5 = x509Cert.subject().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT) != null) {
                string6 = x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATION) != null) {
                string7 = x509Cert.subject().attribute(X500Name.ORGANIZATION).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.COUNTRY) != null) {
                string8 = x509Cert.subject().attribute(X500Name.COUNTRY).valueToString();
            }
            DNItem dNItem = new DNItem(string, string2, string3, string4);
            DNItem dNItem2 = new DNItem(string5, string6, string7, string8);
            Date date = new Date(x509Cert.notBefore());
            Date date2 = new Date(x509Cert.notAfter());
            byte[] byArray2 = null;
            DEREncoder dEREncoder = new DEREncoder();
            x509Cert.extensions().encode((ASN1Encoder)dEREncoder);
            byArray2 = dEREncoder.toByteArray();
            AlgId algId = x509Cert.signatureKeyAlgId();
            byte[] byArray3 = null;
            DEREncoder dEREncoder2 = new DEREncoder();
            algId.encode((ASN1Encoder)dEREncoder2);
            byArray3 = dEREncoder2.toByteArray();
            CertificateItem certificateItem = new CertificateItem((short)x509Cert.version(), (short)x509Cert.subjectKeySize(), x509Cert.serialNo().toString(), dNItem, dNItem2, date, date2, new BERObject(x509Cert.subjectPublicKeyInfo()), new BERObject(byArray2), x509Cert.signature(), new BERObject(byArray3), algId.toString(), algId.asn1oid().name(), byArray);
            return certificateItem;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public CertificateRequestItem parseCertRequest(X509Cert x509Cert, byte[] byArray) throws SSLightKeyDatabaseException {
        try {
            if (x509Cert == null) {
                return null;
            }
            short s = (short)x509Cert.subjectKeySize();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (x509Cert.subject().attribute(X500Name.COMMON_NAME) != null) {
                string = x509Cert.subject().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT) != null) {
                string2 = x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATION) != null) {
                string3 = x509Cert.subject().attribute(X500Name.ORGANIZATION).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.COUNTRY) != null) {
                string4 = x509Cert.subject().attribute(X500Name.COUNTRY).valueToString();
            }
            DNItem dNItem = new DNItem(string, string2, string3, string4);
            byte[] byArray2 = null;
            DEREncoder dEREncoder = new DEREncoder();
            x509Cert.extensions().encode((ASN1Encoder)dEREncoder);
            byArray2 = dEREncoder.toByteArray();
            AlgId algId = x509Cert.signatureKeyAlgId();
            byte[] byArray3 = null;
            DEREncoder dEREncoder2 = new DEREncoder();
            algId.encode((ASN1Encoder)dEREncoder2);
            byArray3 = dEREncoder2.toByteArray();
            CertificateRequestItem certificateRequestItem = new CertificateRequestItem((short)x509Cert.subjectKeySize(), dNItem, new BERObject(x509Cert.subjectPublicKeyInfo()), new BERObject(byArray2), x509Cert.signature(), new BERObject(byArray3), algId.toString(), algId.asn1oid().name(), byArray, null);
            return certificateRequestItem;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws SSLightKeyDatabaseException {
        Enumeration enumeration = this.ks.engineAliases();
        Vector<KeyItem> vector = null;
        while (enumeration.hasMoreElements()) {
            KeyMaterial keyMaterial;
            String string = (String)enumeration.nextElement();
            X509Cert x509Cert = this.ks.engineGetCertificate(string);
            if (x509Cert == null || !(keyMaterial = x509Cert.subjectKeyMaterial()).equals((Object)bERObject)) continue;
            KeyItem keyItem = this.getKeyItemByLabel(string);
            if (vector == null) {
                vector = new Vector<KeyItem>();
            }
            vector.addElement(keyItem);
        }
        return vector;
    }

    public KeyItem getDefaultKeyItem() throws SSLightKeyDatabaseException {
        String string = this.ks.engineGetDefaultKeyEntry();
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public synchronized KeyItem getFirstKeyItem() throws SSLightKeyDatabaseException {
        this.currentKeyIndex = 0;
        if (this.keyLabelList == null) {
            return null;
        }
        String string = (String)this.keyLabelList.elementAt(0);
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public synchronized KeyItem getNextKeyItem() throws SSLightKeyDatabaseException {
        ++this.currentKeyIndex;
        if (this.currentKeyIndex < this.keyLabelList.size()) {
            String string = (String)this.keyLabelList.elementAt(this.currentKeyIndex);
            if (string == null) {
                return null;
            }
            return this.getKeyItemByLabel(string);
        }
        return null;
    }

    public void deleteKeyByLabel(String string) throws SSLightKeyDatabaseException {
        if (string == null) {
            return;
        }
        int n = this.keyLabelList.indexOf(string);
        if (n == -1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
        }
        try {
            this.ks.engineDeleteEntry(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_DELETE"));
        }
        this.keyLabelList.removeElementAt(n);
        this.certList.removeElementAt(n);
        if (this.caCertLabelList != null && this.caCertLabelList.contains(string)) {
            this.caCertLabelList.removeElement(string);
        } else if (this.myCertLabelList != null && this.myCertLabelList.contains(string)) {
            this.myCertLabelList.removeElement(string);
        } else if (this.siteCertLabelList != null && this.siteCertLabelList.contains(string)) {
            this.siteCertLabelList.removeElement(string);
        } else if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
            this.reqKeyLabelList.removeElement(string);
        }
        this.databaseUpdated = true;
        this.resetDefaultKey();
    }

    public void insertKey(KeyItem keyItem) throws SSLightKeyDatabaseException {
        if (keyItem == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        String string = keyItem.getKeyLabel();
        if (this.ks.engineContainsAlias(string)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_LABEL"));
        }
        try {
            if (!keyItem.hasPrivateKey() && keyItem.hasCertificate()) {
                X509Cert x509Cert = new X509Cert(((CertificateItem)keyItem.getCertificateChain().elementAt(0)).getEncoded());
                if (keyItem.isTrusted() && !keyItem.isSiteCertificate()) {
                    this.ks.engineSetCertificateEntry(string, x509Cert);
                    this.addKeyLabelAt(string, 0);
                    this.addCaCertLabelAt(string, 0);
                    this.certList.insertElementAt(x509Cert, 0);
                } else if (keyItem.isSiteCertificate()) {
                    this.ks.engineSetSiteCertificateEntry(string, x509Cert);
                    this.addKeyLabelAt(string, 0);
                    this.addSiteCertLabelAt(string, 0);
                    this.certList.insertElementAt(x509Cert, 0);
                }
                this.databaseUpdated = true;
                this.resetDefaultKey();
            } else if (keyItem.hasPrivateKey()) {
                byte[] byArray = keyItem.getEncryptedPrivateKeyInfoItem().getEncoded();
                KeyMaterial keyMaterial = KeyCertGen.generateKeyMaterial((byte[])byArray, (String)this.keyDbPwd);
                CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
                if (certificateRequestItem != null) {
                    String string2;
                    CertificationRequest certificationRequest = KeyCertGen.generateCertificationRequest((byte[])certificateRequestItem.getEncoded());
                    X500Name x500Name = certificationRequest.certificationRequestInfo.subject;
                    X509Extension x509Extension = new X509Extension(KeyCertGen.GSKCertificationRequestOID, false);
                    X509Extension[] x509ExtensionArray = new X509Extension[]{x509Extension};
                    X509Cert x509Cert = null;
                    X509Cert[] x509CertArray = new X509Cert[1];
                    String string3 = certificateRequestItem.getSigAlgorithmIdOID();
                    if (string3.equals("1.2.840.113549.1.1.4")) {
                        string2 = "MD5 with RSA";
                    } else if (string3.equals("1.2.840.113549.1.1.5")) {
                        string2 = "SHA1 with RSA";
                    } else {
                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_SIGNATURE_ALGORITHM"));
                    }
                    x509CertArray[0] = x509Cert = KeyCertGen.generateCertificate((KeyMaterial)keyMaterial, (X500Name)x500Name, (int)2, (int)365, (String)string2, (X509Extension[])x509ExtensionArray);
                    this.ks.engineSetKeyEntry(string, keyMaterial, this.keyDbPwd.toCharArray(), x509CertArray);
                    this.addKeyLabelAt(string, 0);
                    this.addMyCertLabelAt(string, 0);
                    this.certList.insertElementAt(x509Cert, 0);
                    this.databaseUpdated = true;
                    this.resetDefaultKey();
                } else if (keyItem.hasCertificate()) {
                    Vector vector = keyItem.getCertificateChain();
                    int n = vector.size();
                    X509Cert[] x509CertArray = new X509Cert[n];
                    int n2 = 0;
                    while (n2 < n) {
                        x509CertArray[n2] = new X509Cert(((CertificateItem)vector.elementAt(n2)).getEncoded());
                        ++n2;
                    }
                    this.ks.engineSetKeyEntry(string, keyMaterial, this.keyDbPwd.toCharArray(), x509CertArray);
                    if (keyItem.isDefault()) {
                        this.ks.engineSetDefaultKeyEntry(string);
                    }
                    this.addKeyLabelAt(string, 0);
                    this.addMyCertLabelAt(string, 0);
                    this.certList.insertElementAt(x509CertArray[0], 0);
                    this.databaseUpdated = true;
                    this.resetDefaultKey();
                }
                keyMaterial.destroy();
            }
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    public void resetDefaultKey() throws SSLightKeyDatabaseException {
        String string = this.ks.engineGetDefaultKeyEntry();
        if (string != null) {
            return;
        }
        if (this.myCertLabelList == null || this.myCertLabelList.isEmpty()) {
            return;
        }
        String string2 = (String)this.myCertLabelList.elementAt(0);
        if (string2 != null) {
            // empty if block
        }
    }

    public void setDefaultKey(String string) throws SSLightKeyDatabaseException {
        try {
            this.ks.engineSetDefaultKeyEntry(string);
            this.databaseUpdated = true;
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_DEFAULT_KEY"));
        }
    }

    public void setKeyTrust(String string, boolean bl) throws SSLightKeyDatabaseException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportToPFXFile(String string, String string2, String[] stringArray) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null || string.length() < 1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        String string3 = stringArray[0];
        if (string3 == null || string3.length() <= 0) throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
        try {
            X509Cert[] x509CertArray;
            if (!this.ks.engineIsKeyEntry(string3)) throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
            KeyMaterial keyMaterial = this.ks.engineGetKey(string3, this.keyDbPwd.toCharArray());
            if (keyMaterial == null || (x509CertArray = this.ks.engineGetCertificateChain(string3)) == null || x509CertArray.length <= 0) return;
            X509Chain x509Chain = new X509Chain(x509CertArray);
            String[] stringArray2 = new String[x509CertArray.length];
            stringArray2[0] = string3;
            byte[] byArray = string3.getBytes();
            PrivateKeyAndCertificateChain privateKeyAndCertificateChain = new PrivateKeyAndCertificateChain((RSAKey)keyMaterial, x509Chain, stringArray2, byArray);
            int n = 1;
            ASN1OID aSN1OID = PKCS12PBE.SHA1_RC2_40;
            byte[] byArray2 = privateKeyAndCertificateChain.makePKCS12PDU(string2, aSN1OID, null, n);
            keyMaterial.destroy();
            if (byArray2 == null || byArray2.length <= 0) return;
            File file = new File(string);
            boolean bl = file.exists();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray2);
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                if (bl || !file.exists()) throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
                file.delete();
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
            }
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importFromPFXFile(String string, String string2) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null || string.length() < 1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        byte[] byArray = SSLightKeyDatabase.fileToBuf(string);
        if (byArray == null || byArray.length <= 0) return;
        try {
            PrivateKeyAndCertificateChain privateKeyAndCertificateChain = new PrivateKeyAndCertificateChain(byArray, string2);
            X509Chain x509Chain = privateKeyAndCertificateChain.getCertificateChain();
            String[] stringArray = privateKeyAndCertificateChain.getFriendlyNames();
            if (stringArray == null || stringArray.length <= 0) throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY_FROM_PFX"));
            X509Cert[] x509CertArray = x509Chain.getCertArray();
            if (this.ks.engineGetCertificateAlias(x509CertArray[0]) != null) throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
            String string3 = stringArray[0];
            if (string3 == null) {
                string3 = x509CertArray[0].subject().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (string3 == null || this.ks.engineContainsAlias(string3)) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_LABEL"));
            }
            RSAKey rSAKey = privateKeyAndCertificateChain.getPrivateRSAKey();
            this.ks.engineSetKeyEntry(string3, (KeyMaterial)rSAKey, this.keyDbPwd.toCharArray(), x509CertArray);
            this.keyLabelList.addElement(string3);
            this.certList.addElement(x509CertArray[0]);
            this.addMyCertLabel(string3);
            this.databaseUpdated = true;
            this.resetDefaultKey();
            privateKeyAndCertificateChain.destroyPrivateKey();
            return;
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    public void receiveCertificate(String string, boolean bl, boolean bl2) throws SSLightKeyDatabaseException {
        block21: {
            if (string == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
            }
            try {
                String string2 = null;
                string2 = bl ? "base64" : "unknown";
                FileInputStream fileInputStream = new FileInputStream(string);
                X509Cert[] x509CertArray = KeyCertGen.generateCertificates((InputStream)fileInputStream, (String)string2);
                fileInputStream.close();
                if (x509CertArray != null && x509CertArray[0] != null) {
                    KeyMaterial keyMaterial = x509CertArray[0].subjectKeyMaterial();
                    String string3 = "";
                    boolean bl3 = false;
                    Enumeration enumeration = this.ks.engineAliases();
                    while (enumeration.hasMoreElements() && !bl3) {
                        KeyMaterial keyMaterial2;
                        X509Cert[] x509CertArray2;
                        X509Extensions x509Extensions;
                        string3 = (String)enumeration.nextElement();
                        if (!this.ks.engineIsKeyEntry(string3) || (x509Extensions = (x509CertArray2 = this.ks.engineGetCertificateChain(string3))[0].extensions()) == null) continue;
                        KeyMaterial keyMaterial3 = x509CertArray2[0].subjectKeyMaterial();
                        X509Extension x509Extension = x509Extensions.findExtension(KeyCertGen.GSKCertificationRequestOID);
                        if (x509Extension != null) {
                            if (keyMaterial.equals((Object)keyMaterial3)) {
                                keyMaterial2 = this.ks.engineGetKey(string3, this.keyDbPwd.toCharArray());
                                this.ks.engineSetKeyEntry(string3, keyMaterial2, this.keyDbPwd.toCharArray(), x509CertArray);
                                if (bl2) {
                                    this.ks.engineSetDefaultKeyEntry(string3);
                                }
                                this.certList.addElement(x509CertArray[0]);
                                this.addMyCertLabel(string3);
                                if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string3)) {
                                    this.reqKeyLabelList.removeElement(string3);
                                }
                                keyMaterial2.destroy();
                                bl3 = true;
                            }
                        } else if (keyMaterial.equals((Object)keyMaterial3)) {
                            keyMaterial2 = this.ks.engineGetKey(string3, this.keyDbPwd.toCharArray());
                            if (x509CertArray[0].notAfter() >= x509CertArray2[0].notAfter()) {
                                this.ks.engineSetKeyEntry(string3, keyMaterial2, this.keyDbPwd.toCharArray(), x509CertArray);
                                if (bl2) {
                                    this.ks.engineSetDefaultKeyEntry(string3);
                                }
                                keyMaterial2.destroy();
                                bl3 = true;
                            } else {
                                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
                            }
                        }
                        keyMaterial3.destroy();
                    }
                    keyMaterial.destroy();
                    if (!bl3) {
                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEY_FOR_CERT_NULL"));
                    }
                    this.databaseUpdated = true;
                    this.resetDefaultKey();
                    break block21;
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
            }
            catch (InterfaceErrorException interfaceErrorException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
            }
            catch (X509Exception x509Exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (CFWKException cFWKException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            }
            catch (ASN1Exception aSN1Exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
            }
            catch (IOException iOException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_OPEN_TO_READ"));
            }
            catch (KeyStoreException keyStoreException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
            }
            catch (Exception exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
            }
        }
    }

    public void addCACertificate(String string, String string2, boolean bl) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        if (this.ks.engineContainsAlias(string)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_LABEL"));
        }
        try {
            String string3 = null;
            string3 = bl ? "base64" : "unknown";
            FileInputStream fileInputStream = new FileInputStream(string2);
            X509Cert[] x509CertArray = KeyCertGen.generateCertificates((InputStream)fileInputStream, (String)string3);
            fileInputStream.close();
            if (x509CertArray == null || x509CertArray[0] == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_STORE"));
            }
            this.ks.engineSetCertificateEntry(string, x509CertArray[0]);
            this.keyLabelList.addElement(string);
            this.certList.addElement(x509CertArray[0]);
            this.addCaCertLabel(string);
            this.databaseUpdated = true;
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
        catch (IOException iOException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_OPEN_TO_READ"));
        }
    }

    public void addSiteCertificate(String string, String string2, boolean bl) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        if (this.ks.engineContainsAlias(string)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_LABEL"));
        }
        try {
            String string3 = null;
            string3 = bl ? "base64" : "unknown";
            FileInputStream fileInputStream = new FileInputStream(string2);
            X509Cert[] x509CertArray = KeyCertGen.generateCertificates((InputStream)fileInputStream, (String)string3);
            fileInputStream.close();
            if (x509CertArray == null || x509CertArray[0] == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_STORE"));
            }
            this.ks.engineSetSiteCertificateEntry(string, x509CertArray[0]);
            this.keyLabelList.addElement(string);
            this.certList.addElement(x509CertArray[0]);
            this.addSiteCertLabel(string);
            this.databaseUpdated = true;
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
        catch (IOException iOException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_OPEN_TO_READ"));
        }
    }

    public void extractCertificate(String string, String string2, boolean bl) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        try {
            X509Cert x509Cert = this.ks.engineGetCertificate(string);
            if (x509Cert == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYREC_CERTIFICATE_NULL"));
            }
            File file = new File(string2);
            boolean bl2 = file.exists();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (bl) {
                    String string3 = x509Cert.getEncoded("base64");
                    fileOutputStream.write(string3.getBytes());
                } else {
                    byte[] byArray = x509Cert.getEncoded();
                    fileOutputStream.write(byArray);
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                if (!bl2 && file.exists()) {
                    file.delete();
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
            }
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public void extractCertificateRequest(String string, String string2) throws SSLightKeyDatabaseException {
        this.extractCertificateRequest(string, 1, string2);
    }

    public void extractCertificateRequest(String string, int n, String string2) throws SSLightKeyDatabaseException {
        String string3;
        if (string == null || string2 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        switch (n) {
            case 1: {
                string3 = "MD5 with RSA";
                break;
            }
            case 2: {
                string3 = "SHA1 with RSA";
                break;
            }
            default: {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_SIGNATURE_ALGORITHM"));
            }
        }
        File file = new File(string2);
        boolean bl = file.exists();
        try {
            if (!this.ks.engineIsKeyEntry(string)) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            X509Cert[] x509CertArray = this.ks.engineGetCertificateChain(string);
            if (x509CertArray == null || x509CertArray[0] == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYREC_CERTIFICATE_NULL"));
            }
            X509Extensions x509Extensions = x509CertArray[0].extensions();
            if (x509Extensions == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            X500Name x500Name = x509CertArray[0].subject();
            KeyMaterial keyMaterial = this.ks.engineGetKey(string, this.keyDbPwd.toCharArray());
            CertificationRequest certificationRequest = KeyCertGen.generateCertificationRequest((KeyMaterial)keyMaterial, (X500Name)x500Name, (String)string3, (X509Extension[])x509Extensions.extensions());
            keyMaterial.destroy();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String string4 = certificationRequest.getEncoded("base64");
            fileOutputStream.write(string4.getBytes());
            fileOutputStream.close();
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (IOException iOException) {
            if (!bl && file.exists()) {
                file.delete();
            }
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
        }
    }

    public static boolean promptForPW() {
        return true;
    }

    public static boolean promptForLabel() {
        return true;
    }

    static long msbf(byte[] byArray, int n, int n2) {
        long l = 0L;
        do {
            l |= (long)(byArray[n++] & 0xFF) << --n2 * 8;
        } while (n2 > 0);
        return l;
    }

    static byte getBits(byte[] byArray, int n, int n2) {
        int n3 = n / 7;
        byte by = byArray[n3];
        int n4 = n % 7;
        by = (byte)(by & 127 >>> n4);
        if ((n4 = n2 - (7 - n4)) > 0) {
            return (byte)(by << n4 | (byte)(byArray[n3 + 1] >>> 7 - n4));
        }
        if (n4 < 0) {
            return (byte)(by >>> -n4);
        }
        return by;
    }

    private static int putByte(byte[] byArray, int n, int n2) {
        byArray[n2++] = (byte)n;
        return n2;
    }

    private static int putShort(byte[] byArray, int n, int n2) {
        int n3 = 8;
        while (n3 >= 0) {
            byArray[n2++] = (byte)(n >> n3);
            n3 -= 8;
        }
        return n2;
    }

    private static int putLong(byte[] byArray, long l, int n) {
        int n2 = 56;
        while (n2 >= 0) {
            byArray[n++] = (byte)(l >> n2);
            n2 -= 8;
        }
        return n;
    }

    private static int putLong(byte[] byArray, long l, int n, int n2) {
        int n3 = n * 8 - 8;
        while (n3 >= 0) {
            byArray[n2++] = (byte)(l >> n3);
            n3 -= 8;
        }
        return n2;
    }

    private static int putString(byte[] byArray, String string, int n) {
        int n2 = string.length();
        byte[] byArray2 = string.getBytes();
        try {
            System.arraycopy(byArray2, 0, byArray, n, n2);
        }
        catch (Exception exception) {
            return n;
        }
        return n + n2;
    }

    public static byte[] fileToBuf(String string) throws SSLightKeyDatabaseException {
        int n;
        File file = new File(string);
        if (!file.exists()) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_FILE_NOT_FOUND"));
        }
        int n2 = (int)file.length();
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[n2];
        try {
            fileInputStream = new FileInputStream(file);
            n = 0;
            int n3 = 0;
            while (n < byArray.length && (n3 = fileInputStream.read(byArray, n, byArray.length - n)) != -1) {
                n += n3;
            }
            fileInputStream.close();
            fileInputStream = null;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            fileInputStream = null;
            n = 0;
        }
        if (n != byArray.length) {
            return null;
        }
        return byArray;
    }

    public static byte[] base64DearmorFileToBuf(String string) throws SSLightKeyDatabaseException {
        byte[] byArray;
        byte[] byArray2 = SSLightKeyDatabase.fileToBuf(string);
        if (byArray2 == null) {
            return null;
        }
        int[] nArray = new int[2];
        SSLightKeyDatabase.findCertificateBeginEnd(byArray2, nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        if (n == -1 || n2 == -1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        int n3 = n2 - n;
        byte[] byArray3 = new byte[n3];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3 + n) {
            int n6 = Armored64RdChars.indexOf(byArray2[n4]);
            if (n6 != -1) {
                byArray3[n5] = (byte)n6;
                ++n5;
            }
            ++n4;
        }
        int n7 = n5;
        int n8 = n7 % 4;
        int n9 = (n7 - n8) * 3 / 4;
        if (n8 == 1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        if (n8 == 2) {
            byArray = new byte[++n9];
            byArray[n9 - 1] = (byte)(byArray3[n5 - 2] << 2 | byArray3[n5 - 1] >>> 4);
        } else if (n8 == 3) {
            byArray = new byte[n9 += 2];
            byArray[n9 - 2] = (byte)(byArray3[n5 - 3] << 2 | byArray3[n5 - 2] >>> 4);
            byArray[n9 - 1] = (byte)(byArray3[n5 - 2] << 4 | byArray3[n5 - 1] >>> 2);
        } else {
            byArray = new byte[n9];
        }
        int n10 = 0;
        n5 = 0;
        n10 = 0;
        while (n5 + 3 < n7) {
            byArray[n10] = (byte)(byArray3[n5] << 2 | byArray3[n5 + 1] >>> 4);
            byArray[n10 + 1] = (byte)(byArray3[n5 + 1] << 4 | byArray3[n5 + 2] >>> 2);
            byArray[n10 + 2] = (byte)(byArray3[n5 + 2] << 6 | byArray3[n5 + 3]);
            n5 += 4;
            n10 += 3;
        }
        return byArray;
    }

    private static void findCertificateBeginEnd(byte[] byArray, int[] nArray) {
        int n;
        byte by;
        nArray[0] = -1;
        nArray[1] = -1;
        int n2 = 0;
        int n3 = 0;
        n2 = 0;
        while (n2 < byArray.length && nArray[0] == -1) {
            n3 = 0;
            while (n3 < BeginEndCertificateIndicator.length && nArray[0] == -1) {
                by = (byte)BeginEndCertificateIndicator[n3][0].charAt(0);
                if (byArray[n2] == by) {
                    n = 0;
                    while (n + n2 < byArray.length && n < BeginEndCertificateIndicator[n3][0].length() && Character.toUpperCase((char)byArray[n2 + n]) == BeginEndCertificateIndicator[n3][0].charAt(n)) {
                        ++n;
                    }
                    if (n == BeginEndCertificateIndicator[n3][0].length()) {
                        nArray[0] = n2 + BeginEndCertificateIndicator[n3][0].length();
                    }
                }
                ++n3;
            }
            ++n2;
        }
        if (nArray[0] != -1) {
            by = (byte)BeginEndCertificateIndicator[--n3][1].charAt(0);
            n2 = nArray[0];
            while (n2 < byArray.length && nArray[1] == -1) {
                if (byArray[n2] == by) {
                    n = 0;
                    while (n + n2 < byArray.length && n < BeginEndCertificateIndicator[n3][1].length() && Character.toUpperCase((char)byArray[n2 + n]) == BeginEndCertificateIndicator[n3][1].charAt(n)) {
                        ++n;
                    }
                    if (n == BeginEndCertificateIndicator[n3][1].length()) {
                        nArray[1] = n2;
                    }
                }
                ++n2;
            }
        }
    }

    private static int PutSextWithNL(PrintWriter printWriter, int n, int n2) {
        printWriter.print(Armored64WrChars.charAt(n));
        if (++n2 == 64) {
            printWriter.println();
            n2 = 0;
        }
        return n2;
    }

    private static byte[] BufToBase64ArmorBuf(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println(BASE64BEGINCERT);
        int n = 0;
        int n2 = 0;
        while (n + 2 < byArray.length) {
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[n] >>> 2 & 0x3F, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[n] << 4 & 0x30 | byArray[n + 1] >>> 4 & 0xF, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[n + 1] << 2 & 0x3C | byArray[n + 2] >>> 6 & 3, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[n + 2] & 0x3F, n2);
            n += 3;
        }
        int n3 = byArray.length % 3;
        if (n3 == 1) {
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[byArray.length - 1] >>> 2 & 0x3F, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[byArray.length - 1] << 4 & 0x30, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, 64, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, 64, n2);
        } else {
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[byArray.length - 2] >>> 2 & 0x3F, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[byArray.length - 2] << 4 & 0x30 | byArray[byArray.length - 1] >>> 4 & 0xF, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, byArray[byArray.length - 1] << 2 & 0x3C, n2);
            n2 = SSLightKeyDatabase.PutSextWithNL(printWriter, 64, n2);
        }
        if (n2 != 0) {
            printWriter.println();
        }
        printWriter.println(BASE64ENDCERT);
        printWriter.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private static String getLabel(SSLCert sSLCert) {
        StringBuffer stringBuffer = new StringBuffer(20);
        boolean bl = true;
        int n = 0;
        while (n < nameComps.length) {
            String string = sSLCert.getNameComponent(1, nameComps[n]);
            if (string != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                bl = false;
                stringBuffer.append(compLabs[n]);
                stringBuffer.append(string);
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    private void ssltCheckName(String string) throws SSLightKeyDatabaseException {
        File file = new File(string);
        String string2 = file.getName();
        if (!string2.endsWith(KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT)) {
            String string3 = KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_EXT");
            Object[] objectArray = new Object[]{KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT};
            String string4 = MessageFormat.format(string3, objectArray);
            throw new SSLightKeyDatabaseException(string4);
        }
        String string5 = string2.substring(0, string2.lastIndexOf(KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT));
        int n = string5.length();
        while (--n >= 0) {
            char c = string2.charAt(n);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || (c >= '0' && c <= '9' || c == '.') && n > 0) continue;
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
    }

    private static String getFullyQualifiedClassName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (classPackage != null) {
            string2 = classPackage + "." + file.getName();
        }
        return string2.substring(0, string2.lastIndexOf(KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT));
    }

    private void ssltCreateNewKeyDb(String string, String string2, long l) throws SSLightKeyDatabaseException, X509Exception, IOException {
        this.ssltCheckName(string);
        File file = new File(string);
        if (file.exists()) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_ALREADY_EXISTS"));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.ks = new KeyStore();
        this.ks.engineStore((OutputStream)fileOutputStream, string2.toCharArray(), SSLightKeyDatabase.getFullyQualifiedClassName(string));
        fileOutputStream.close();
        this.databaseUpdated = true;
    }

    private void ssltAddDefaultRootCertificates() throws SSLightKeyDatabaseException {
        try {
            this.ks.engineSetCertificateEntry(CLASS3_ROOT_LABEL, new X509Cert(SSLightKeyDatabase.getClass3RootSelfSignedCert()));
            this.ks.engineSetCertificateEntry(CLASS2_ROOT_LABEL, new X509Cert(SSLightKeyDatabase.getClass2RootSelfSignedCert()));
            this.ks.engineSetCertificateEntry(CLASS1_ROOT_LABEL, new X509Cert(SSLightKeyDatabase.getClass1RootSelfSignedCert()));
            this.ks.engineSetCertificateEntry(RSA_SECURE_SERVER_CA_LABEL, new X509Cert(SSLightKeyDatabase.getRSASecureServerCASelfSignedCert()));
            this.ks.engineSetCertificateEntry(VERISIGN_TEST_CA_LABEL, new X509Cert(SSLightKeyDatabase.getVerisignTestCASelfSignedCert()));
            this.ks.engineSetCertificateEntry(THAWTE_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(SSLightKeyDatabase.getThawteRootSelfSignedCert()));
            this.ks.engineSetCertificateEntry(THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(SSLightKeyDatabase.getThawteSPRRootSelfSignedCert()));
            this.ks.engineSetCertificateEntry(THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(SSLightKeyDatabase.getThawtePBasicRootSelfSignedCert()));
            this.ks.engineSetCertificateEntry(THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(SSLightKeyDatabase.getThawtePFreeRootSelfSignedCert()));
            this.ks.engineSetCertificateEntry(THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(SSLightKeyDatabase.getThawtePPRRootSelfSignedCert()));
            this.ks.engineSetCertificateEntry(CLASS1_INTERMEDIATE_LABEL, new X509Cert(SSLightKeyDatabase.getClass1IntermediateCert()));
            this.ks.engineSetCertificateEntry(CLASS2_INTERMEDIATE_LABEL, new X509Cert(SSLightKeyDatabase.getClass2IntermediateCert()));
            this.ks.engineSetCertificateEntry(CLASS3_INTERMEDIATE_LABEL, new X509Cert(SSLightKeyDatabase.getClass3IntermediateCert()));
            this.databaseUpdated = true;
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    private static byte[] getClass1RootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 61, 48, -126, 1, -90, 2, 17, 0, -51, -70, 127, 86, -16, -33, -28, -68, 84, -2, 34, -84, -77, 114, -86, 85, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -27, 25, -65, 109, -93, 86, 97, 45, -103, 72, 113, -10, 103, -34, -71, -115, -21, -73, -98, -122, -128, 10, -111, 14, -6, 56, 37, -81, 70, -120, -126, -27, 115, -88, -96, -101, 36, 93, 13, 31, -52, 101, 110, 12, -80, -48, 86, -124, 24, -121, -102, 6, -101, 16, -95, 115, -33, -76, 88, 57, 107, 110, -63, -10, 21, -43, -88, -88, 63, -86, 18, 6, -115, 49, -84, 127, -80, 52, -41, -113, 52, 103, -120, 9, -51, 20, 17, -30, 78, 69, 86, 105, 31, 120, 2, -128, -38, -36, 71, -111, 41, -69, 54, -55, 99, 92, -59, -32, -41, 45, -121, 123, -95, -73, 50, -80, 123, 48, -70, 42, 47, 49, -86, -18, -93, 103, -38, -37, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, 76, 63, -72, -117, -58, 104, -33, -18, 67, 51, 14, 93, -23, -90, -53, 7, -124, 77, 122, 51, -1, -110, 27, -12, 54, -83, -40, -107, 34, 54, 104, 17, 108, 124, 66, -52, -13, -100, 46, -60, 7, 63, 20, -80, 15, 79, -1, -112, -110, 118, -7, -30, -68, 74, -23, -113, -51, -96, -128, 10, -9, -59, 41, -15, -126, 34, 93, -72, -79, -35, -127, 35, -93, 123, 37, 21, 70, 48, 121, 22, -8, -22, 5, 75, -108, 127, 29, -62, 28, -56, -29, -73, -12, 16, 64, 60, 19, -61, 95, 31, 83, -24, 72, -28, -122, -76, 123, -95, 53, -80, 123, 37, -70, -72, -45, -114, -85, 63, 56, -99, 0, 52, 0, -104, -13, -47, 113, -108};
        return byArray;
    }

    private static byte[] getClass2RootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 60, 48, -126, 1, -91, 2, 16, 45, 27, -4, 74, 23, -115, -93, -111, -21, -25, -1, -11, -117, 69, -66, 11, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -74, 90, -117, -93, 13, 106, 35, -125, -128, 107, -49, 57, -121, -12, 33, 19, 51, 6, 76, 37, -94, -19, 85, 18, -105, -59, -89, -128, -71, -6, -125, -63, 32, -96, -6, 47, 21, 13, 124, -95, 96, 107, 126, 121, 44, -6, 6, 15, 58, -82, -10, 27, 111, -79, -46, -1, 47, 40, 82, 95, -125, 125, 75, -60, 122, -73, -8, 102, 31, -128, 84, -4, -73, -62, -114, 89, 74, 20, 87, 70, -47, -102, -109, -66, 65, -111, 3, -69, 21, -128, -109, 92, -21, -25, -52, 8, 108, 63, 62, -77, 74, -4, -1, 75, 108, 35, -43, 80, -126, 38, 68, 25, -114, 35, -61, 113, -22, 25, 36, 71, 4, -98, 117, -65, -56, -90, 0, 31, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -118, 27, 43, -6, 57, -63, 116, -41, 94, -40, 25, 100, -94, 88, 74, 45, 55, -32, 51, 71, 15, -84, -19, -9, -86, -37, 30, -28, -117, 6, 92, 96, 39, -54, 69, 82, -50, 22, -17, 63, 6, 100, -25, -108, 104, 124, 96, 51, 21, 17, 105, -81, -99, 98, -115, -93, 3, 84, 107, -90, -66, -27, -18, 5, 24, 96, 4, -65, 66, -128, -3, -48, -88, -88, 30, 1, 59, -9, -93, 92, -81, -93, -36, -26, 38, -128, 35, 60, -72, 68, 116, -9, 10, -82, 73, -117, 97, 120, -52, 36, -65, -120, -118, -89, 14, -22, 115, 25, 65, -3, 77, 3, -16, -120, -47, -27, 120, -115, -91, 42, 79, -10, -105, 13, 23, 119, -54, -40};
        return byArray;
    }

    private static byte[] getClass3RootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 60, 48, -126, 1, -91, 2, 16, 112, -70, -28, 29, 16, -39, 41, 52, -74, 56, -54, 123, 3, -52, -70, -65, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -55, 92, 89, -98, -14, 27, -118, 1, 20, -76, 16, -33, 4, 64, -37, -29, 87, -81, 106, 69, 64, -113, -124, 12, 11, -47, 51, -39, -39, 17, -49, -18, 2, 88, 31, 37, -9, 42, -88, 68, 5, -86, -20, 3, 31, 120, 127, -98, -109, -71, -102, 0, -86, 35, 125, -42, -84, -123, -94, 99, 69, -57, 114, 39, -52, -12, 76, -58, 117, 113, -46, 57, -17, 79, 66, -16, 117, -33, 10, -112, -58, -114, 32, 111, -104, 15, -8, -84, 35, 95, 112, 41, 54, -92, -55, -122, -25, -79, -102, 32, -53, 83, -91, -123, -25, 61, -66, 125, -102, -2, 36, 69, 51, -36, 118, 21, -19, 15, -94, 113, 100, 76, 101, 46, -127, 104, 69, -89, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -69, 76, 18, 43, -49, 44, 38, 0, 79, 20, 19, -35, -90, -5, -4, 10, 17, -124, -116, -13, 40, 28, 103, -110, 47, 124, -74, -59, -6, -33, -16, -24, -107, -68, 29, -113, 108, 44, -88, 81, -52, 115, -40, -92, -64, 83, -16, 78, -42, 38, -64, 118, 1, 87, -127, -110, 94, 33, -15, -47, -79, -1, -25, -48, 33, 88, -51, 105, 23, -29, 68, 28, -100, 25, 68, 57, -119, 92, -36, -100, 0, 15, 86, -115, 2, -103, -19, -94, -112, 69, 76, -28, -69, 16, -92, 61, -16, 50, 3, 14, -15, -50, -8, -24, -55, 81, -116, -26, 98, -97, -26, -97, -64, 125, -73, 114, -100, -55, 54, 58, 107, -97, 78, -88, -1, 100, 13, 100};
        return byArray;
    }

    private static byte[] getRSASecureServerCASelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 52, 48, -126, 1, -95, 2, 16, 2, -83, 102, 126, 78, 69, -2, 94, 87, 111, 60, -104, 25, 94, -35, -64, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 32, 48, 30, 6, 3, 85, 4, 10, 19, 23, 82, 83, 65, 32, 68, 97, 116, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 44, 32, 73, 110, 99, 46, 49, 46, 48, 44, 6, 3, 85, 4, 11, 19, 37, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 52, 49, 49, 48, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 49, 48, 48, 49, 48, 55, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 32, 48, 30, 6, 3, 85, 4, 10, 19, 23, 82, 83, 65, 32, 68, 97, 116, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 44, 32, 73, 110, 99, 46, 49, 46, 48, 44, 6, 3, 85, 4, 11, 19, 37, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -101, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -119, 0, 48, -127, -123, 2, 126, 0, -110, -50, 122, -63, -82, -125, 62, 90, -86, -119, -125, 87, -84, 37, 1, 118, 12, -83, -82, -114, 44, 55, -50, -21, 53, 120, 100, 84, 3, -27, -124, 64, 81, -55, -65, -113, 8, -30, -118, -126, 8, -46, 22, -122, 55, 85, -23, -79, 33, 2, -83, 118, 104, -127, -102, 5, -94, 75, -55, 75, 37, 102, 34, 86, 108, -120, 7, -113, -9, -127, 89, 109, -124, 7, 101, 112, 19, 113, 118, 62, -101, 119, 76, -29, 80, -119, 86, -104, 72, -71, 29, -89, 41, 26, 19, 46, 74, 17, 89, -100, 30, 21, -43, 73, 84, 44, 115, 58, 105, -126, -79, -105, 57, -100, 109, 112, 103, 72, -27, -35, 45, -42, -56, 30, 123, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, 126, 0, 101, -35, 126, -31, -78, -20, -80, -30, 58, -32, -20, 113, 70, -102, 25, 17, -72, -45, -57, -96, -76, 3, 64, 38, 2, 62, 9, -100, -31, 18, -77, -47, 90, -10, 55, -91, -73, 97, 3, -74, 91, 22, 105, 59, -58, 68, 8, 12, -120, 83, 12, 107, -105, 73, -57, 62, 53, -36, 108, -71, -69, -86, -33, 92, -69, 58, 47, -109, 96, -74, -87, 75, 77, -14, 32, -9, -51, 95, 127, 100, 123, -114, -36, 0, 92, -41, -6, 119, -54, 57, 22, 89, 111, 14, -22, -45, -75, -125, 127, 77, 77, 66, 86, 118, -76, -55, 95, 4, -8, 56, -8, -21, -46, 95, 117, 95, -51, 123, -4, -27, -114, -128, 124, -4, 80};
        return byArray;
    }

    private static byte[] getVerisignTestCASelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 82, 48, -126, 1, -4, -96, 3, 2, 1, 2, 2, 16, 2, -59, -15, 98, 57, -11, -31, 9, -68, -6, -58, 92, -124, 26, 98, 102, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -87, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 49, 71, 48, 69, 6, 3, 85, 4, 11, 19, 62, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 84, 101, 115, 116, 67, 80, 83, 32, 73, 110, 99, 111, 114, 112, 46, 32, 66, 121, 32, 82, 101, 102, 46, 32, 76, 105, 97, 98, 46, 32, 76, 84, 68, 46, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 70, 111, 114, 32, 86, 101, 114, 105, 83, 105, 103, 110, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 116, 101, 115, 116, 105, 110, 103, 32, 111, 110, 108, 121, 46, 32, 78, 111, 32, 97, 115, 115, 117, 114, 97, 110, 99, 101, 115, 32, 40, 67, 41, 86, 83, 49, 57, 57, 55, 48, 30, 23, 13, 57, 56, 48, 50, 48, 52, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 51, 48, 51, 48, 52, 50, 51, 53, 57, 53, 57, 90, 48, -127, -87, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 49, 71, 48, 69, 6, 3, 85, 4, 11, 19, 62, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 84, 101, 115, 116, 67, 80, 83, 32, 73, 110, 99, 111, 114, 112, 46, 32, 66, 121, 32, 82, 101, 102, 46, 32, 76, 105, 97, 98, 46, 32, 76, 84, 68, 46, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 70, 111, 114, 32, 86, 101, 114, 105, 83, 105, 103, 110, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 116, 101, 115, 116, 105, 110, 103, 32, 111, 110, 108, 121, 46, 32, 78, 111, 32, 97, 115, 115, 117, 114, 97, 110, 99, 101, 115, 32, 40, 67, 41, 86, 83, 49, 57, 57, 55, 48, 92, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, 75, 0, 48, 72, 2, 65, 0, -58, -92, -21, 18, 38, 39, 30, 56, -116, -62, -100, 110, 64, 2, -53, -97, -62, -56, -64, 54, 126, -91, -54, -32, -7, 115, 78, -48, -79, 70, -82, 109, 22, 64, -13, -99, -18, -20, 112, -113, 40, 20, -81, -55, -6, 1, 89, 52, 77, -37, -114, 39, 67, -59, -3, 59, 59, 114, 78, 96, 111, 81, 27, 31, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, 65, 0, 109, 36, 103, 36, -46, 93, 127, -7, 117, 112, -123, -24, -72, 121, 8, -85, 59, -108, 16, -10, 19, 78, 52, -57, 12, -127, -46, -40, -81, -62, -81, -38, -29, -57, -118, -22, 103, -23, 11, -120, 123, 114, -6, -105, 71, 99, 123, 72, 76, -118, 47, -39, -120, 81, 57, -125, -4, -118, 32, 117, -81, -23, -12, -17};
        return byArray;
    }

    private static byte[] getThawteRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 19, 48, -126, 2, 124, -96, 3, 2, 1, 2, 2, 1, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -60, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 3, 19, 16, 84, 104, 97, 119, 116, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 38, 48, 36, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 23, 115, 101, 114, 118, 101, 114, 45, 99, 101, 114, 116, 115, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 56, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -60, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 3, 19, 16, 84, 104, 97, 119, 116, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 38, 48, 36, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 23, 115, 101, 114, 118, 101, 114, 45, 99, 101, 114, 116, 115, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -45, -92, 80, 110, -56, -1, 86, 107, -26, -49, 93, -74, -22, 12, 104, 117, 71, -94, -86, -62, -38, -124, 37, -4, -88, -12, 71, 81, -38, -123, -75, 32, 116, -108, -122, 30, 15, 117, -55, -23, 8, 97, -11, 6, 109, 48, 110, 21, 25, 2, -23, 82, -64, 98, -37, 77, -103, -98, -30, 106, 12, 68, 56, -51, -2, -66, -29, 100, 9, 112, -59, -2, -79, 107, 41, -74, 47, 73, -56, 59, -44, 39, 4, 37, 16, -105, 47, -25, -112, 109, -64, 40, 66, -103, -41, 76, 67, -34, -61, -11, 33, 109, 84, -97, 93, -61, 88, -31, -64, -28, -39, 91, -80, -72, -36, -76, 123, -33, 54, 58, -62, -75, 102, 34, 18, -42, -121, 13, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 7, -6, 76, 105, 92, -5, -107, -52, 70, -18, -123, -125, 77, 33, 48, -114, -54, -39, -88, 111, 73, 26, -26, -38, 81, -29, 96, 112, 108, -124, 97, 17, -95, 26, -56, 72, 62, 89, 67, 125, 79, -107, 61, -95, -117, -73, 11, 98, -104, 122, 117, -118, -35, -120, 78, 78, -98, 64, -37, -88, -52, 50, 116, -71, 111, 13, -58, -29, -77, 68, 11, -39, -118, 111, -102, 41, -101, -103, 24, 40, 59, -47, -29, 64, 40, -102, 90, 60, -43, -75, -25, 32, 27, -117, -54, -92, -85, -115, -23, 81, -39, -30, 76, 44, 89, -87, -38, -71, -78, 117, 27, -10, 66, -14, -17, -57, -14, 24, -7, -119, -68, -93, -1, -118, 35, 46, 112, 71};
        return byArray;
    }

    private static byte[] getThawteSPRRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 39, 48, -126, 2, -112, -96, 3, 2, 1, 2, 2, 1, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -50, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 114, 101, 109, 105, 117, 109, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 114, 101, 109, 105, 117, 109, 45, 115, 101, 114, 118, 101, 114, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 56, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -50, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 114, 101, 109, 105, 117, 109, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 114, 101, 109, 105, 117, 109, 45, 115, 101, 114, 118, 101, 114, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -46, 54, 54, 106, -117, -41, -62, 91, -98, -38, -127, 65, 98, -113, 56, -18, 73, 4, 85, -42, -48, -17, 28, 27, -107, 22, 71, -17, 24, 72, 53, 58, 82, -12, 43, 106, 6, -113, 59, 47, -22, 86, -29, -81, -122, -115, -98, 23, -9, -98, -76, 101, 117, 2, 77, -17, -53, 9, -94, 33, 81, -40, -101, -48, 103, -48, -70, 13, -110, 6, 20, 115, -44, -109, -53, -105, 42, 0, -100, 92, 78, 12, -68, -6, 21, 82, -4, -14, 68, 110, -38, 17, 74, 110, 8, -97, 47, 45, -29, -7, -86, 58, -122, 115, -74, 70, 83, 88, -56, -119, 5, -67, -125, 17, -72, 115, 63, -86, 7, -115, -12, 66, 77, -25, 64, -99, 28, 55, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 38, 72, 44, 22, -62, 88, -6, -24, 22, 116, 12, -86, -86, 95, 84, 63, -14, -41, -55, 120, 96, 94, 94, 110, 55, 99, 34, 119, 54, 126, -78, 23, -60, 52, -71, -11, 8, -123, -4, -55, 1, 56, -1, 77, -66, -14, 22, 66, 67, -25, -69, 90, 70, -5, -63, -58, 17, 31, -15, 74, -80, 40, 70, -55, -61, -60, 66, 125, -68, -6, -85, 89, 110, -43, -73, 81, -120, 17, -29, -92, -123, 25, 107, -126, 76, -92, 12, 18, -83, -23, -92, -82, 63, -15, -61, 73, 101, -102, -116, -59, -56, 62, 37, -73, -108, -103, -69, -110, 50, 113, 7, -16, -122, 94, -19, 80, 39, -90, 13, -90, 35, -7, -69, -53, -90, 7, 20, 66};
        return byArray;
    }

    private static byte[] getThawtePBasicRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 33, 48, -126, 2, -118, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -53, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 66, 97, 115, 105, 99, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 101, 114, 115, 111, 110, 97, 108, 45, 98, 97, 115, 105, 99, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 49, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -53, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 66, 97, 115, 105, 99, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 101, 114, 115, 111, 110, 97, 108, 45, 98, 97, 115, 105, 99, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -68, -68, -109, 83, 109, -64, 80, 79, -126, 21, -26, 72, -108, 53, -90, 90, -66, 111, 66, -6, 15, 71, -18, 119, 117, 114, -35, -115, 73, -101, -106, 87, -96, 120, -44, -54, 63, 81, -77, 105, 11, -111, 118, 23, 34, 7, -105, 106, -60, 81, -109, 75, -32, -115, -17, 55, -107, -95, 12, 77, -38, 52, -112, 29, 23, -119, -105, -32, 53, 56, 87, 74, -64, -12, 8, 112, -23, 60, 68, 123, 80, 126, 97, -102, -112, -29, 35, -45, -120, 17, 70, 39, -11, 11, 7, 14, -69, -35, -47, 127, 32, 10, -120, -71, 86, 11, 46, 28, -128, -38, -15, -29, -98, 41, -17, 20, -67, 10, 68, -5, 27, 91, 24, -47, -65, 35, -109, 33, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 45, -30, -103, 107, -80, 61, 122, -119, -41, 89, -94, -108, 1, 31, 43, -35, 18, 75, 83, -62, -83, 127, -86, -89, 0, 92, -111, 64, 87, 37, 74, 56, -86, -124, 112, -71, -39, -128, 15, -91, 123, 92, -5, 115, -58, -67, -41, -118, 97, 92, 3, -29, 45, 39, -88, 23, -32, -124, -123, 66, -36, 94, -101, -58, -73, -78, 109, -69, 116, -81, -28, 63, -53, -89, -73, -80, -32, 93, -66, 120, -125, 37, -108, -46, -37, -127, 15, 121, 7, 109, 79, -12, 57, 21, 90, 82, 1, 123, -34, 50, -42, 77, 56, -10, 18, 92, 6, 80, -33, 5, 91, -67, 20, 75, -95, -33, 41, -70, 59, 65, -115, -9, 99, 86, -95, -33, 34, -79};
        return byArray;
    }

    private static byte[] getThawtePFreeRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 45, 48, -126, 2, -106, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -47, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 70, 114, 101, 101, 109, 97, 105, 108, 32, 67, 65, 49, 43, 48, 41, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 28, 112, 101, 114, 115, 111, 110, 97, 108, 45, 102, 114, 101, 101, 109, 97, 105, 108, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 49, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -47, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 70, 114, 101, 101, 109, 97, 105, 108, 32, 67, 65, 49, 43, 48, 41, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 28, 112, 101, 114, 115, 111, 110, 97, 108, 45, 102, 114, 101, 101, 109, 97, 105, 108, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -44, 105, -41, -44, -80, -108, 100, 91, 113, -23, 71, -40, 12, 81, -74, -22, 114, -111, -80, -124, 94, 125, 45, 13, -113, 123, 18, -33, -123, 37, 117, 40, 116, 58, 66, 44, 99, 39, -97, -107, 123, 75, -17, 126, 25, -121, 29, -122, -22, -93, -35, -71, -50, -106, 100, 26, -62, 20, 110, 68, -84, 124, -26, -113, -24, 77, 15, 113, 31, 64, 56, -90, 0, -93, -121, 120, -10, -7, -108, -122, 94, -83, -22, -64, 94, 118, -21, -39, 20, -93, 93, 110, 122, 124, 12, -91, 75, 85, 127, 6, 25, 41, 127, -98, -102, 38, -43, 106, -69, 56, 36, 8, 106, -104, -57, -79, -38, -93, -104, -111, -3, 121, -37, -27, 90, -60, 28, -71, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, -57, -20, -110, 126, 78, -8, -11, -106, -91, 103, 98, 42, -92, -16, 77, 17, 96, -48, 111, -115, 96, 88, 97, -84, 38, -69, 82, 53, 92, 8, -49, 48, -5, -88, 74, -106, -118, 31, 98, 66, 35, -116, 23, 15, -12, -70, 100, -100, 23, -84, 71, 41, -33, -99, -104, 94, -46, 108, 96, 113, 92, -94, -84, -36, 121, -29, -25, 110, 0, 71, 31, -75, 13, 40, -24, 2, -99, -28, -102, -3, 19, -12, -90, -39, 124, -79, -8, -36, 95, 35, 38, 9, -111, -128, 115, -48, 20, 27, -34, 67, -87, -125, 37, -14, -26, -100, 47, 21, -54, -2, -90, -85, -118, 7, 117, -117, 12, -35, 81, -124, 107, -28, -8, -47, -50, 119, -94, -127};
        return byArray;
    }

    private static byte[] getThawtePPRRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 41, 48, -126, 2, -110, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -49, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 35, 48, 33, 6, 3, 85, 4, 3, 19, 26, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 80, 114, 101, 109, 105, 117, 109, 32, 67, 65, 49, 42, 48, 40, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 27, 112, 101, 114, 115, 111, 110, 97, 108, 45, 112, 114, 101, 109, 105, 117, 109, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 49, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -49, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 35, 48, 33, 6, 3, 85, 4, 3, 19, 26, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 80, 114, 101, 109, 105, 117, 109, 32, 67, 65, 49, 42, 48, 40, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 27, 112, 101, 114, 115, 111, 110, 97, 108, 45, 112, 114, 101, 109, 105, 117, 109, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -55, 102, -39, -8, 7, 68, -49, -71, -116, 46, -16, -95, -17, 19, 69, 108, 5, -33, -34, 39, 22, 81, 54, 65, 17, 108, 108, 59, -19, -2, 16, 125, 18, -98, -27, -101, 66, -102, -2, 96, 49, -61, 102, -73, 115, 58, 72, -82, 78, -48, 50, 55, -108, -120, -75, 13, -74, -39, -13, -14, 68, -39, -43, -120, 18, -35, 118, 77, -14, 26, -4, 111, 35, 30, 122, -15, -40, -104, 69, 78, 7, 16, -17, 22, 66, -48, 67, 117, 109, 74, -34, -30, -86, -55, 49, -1, 31, 0, 112, 124, 102, -49, 16, 37, 8, -70, -6, -18, 0, -23, 70, 3, 102, 39, 17, 21, 59, -86, 91, -14, -104, -35, 54, 66, -78, -38, -120, 117, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 105, 54, -119, -9, 52, 42, 51, 114, 47, 109, 59, -44, 34, -78, -72, 111, -102, -59, 54, 102, 14, 27, 60, -95, -79, 117, 90, -26, -3, 53, -45, -8, -88, -14, 7, 111, -123, 103, -114, -34, 43, -71, -30, 23, -80, 58, -96, -16, 14, -94, 0, -102, -33, -13, 20, 21, 110, -69, -56, -123, 90, -104, -128, -7, -1, -66, 116, 29, 61, -13, -2, 48, 37, -47, 55, 52, 103, -6, -91, 113, 121, 48, 97, 41, 114, -64, -32, 44, 76, -5, 86, -28, 58, -88, 111, -27, 50, 89, 82, -37, 117, 40, 80, 89, 12, -8, 11, 25, -28, -84, -39, -81, -106, -115, 47, 80, -37, 7, -61, -22, 31, -85, 51, -32, -11, 43, 49, -119};
        return byArray;
    }

    private static byte[] getClass1IntermediateCert() {
        byte[] byArray = new byte[]{48, -126, 3, 102, 48, -126, 2, -49, -96, 3, 2, 1, 2, 2, 16, 13, -117, 79, -18, -86, -46, 24, 91, -12, 117, 106, -99, 41, -31, 127, -5, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 56, 48, 53, 49, 50, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 56, 48, 53, 49, 50, 50, 51, 53, 57, 53, 57, 90, 48, -127, -52, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 82, 80, 65, 32, 73, 110, 99, 111, 114, 112, 46, 32, 66, 121, 32, 82, 101, 102, 46, 44, 76, 73, 65, 66, 46, 76, 84, 68, 40, 99, 41, 57, 56, 49, 72, 48, 70, 6, 3, 85, 4, 3, 19, 63, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 49, 32, 67, 65, 32, 73, 110, 100, 105, 118, 105, 100, 117, 97, 108, 32, 83, 117, 98, 115, 99, 114, 105, 98, 101, 114, 45, 80, 101, 114, 115, 111, 110, 97, 32, 78, 111, 116, 32, 86, 97, 108, 105, 100, 97, 116, 101, 100, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -69, 90, 68, -118, 4, 22, -69, 85, -3, 3, 122, -118, 45, -108, 79, 21, 120, 54, -72, 13, 74, -78, 111, -100, 84, -65, -68, -24, 119, 42, -99, -71, -16, 104, -69, -107, -39, 49, 65, 112, 122, -127, 75, -71, 72, 19, 86, 45, -57, 8, -31, -124, 66, -85, -64, -94, -110, -85, 68, 92, -86, 66, -16, -126, 14, 2, -23, 47, -5, -62, 59, -69, -66, -55, 39, 10, 93, -74, -80, 54, 66, 51, -75, 110, 84, -120, 79, -121, 74, -65, 25, -38, -7, 21, -24, 15, -121, -74, 28, -29, -52, -58, -102, -114, 127, 106, 36, -110, -29, -4, -32, 101, -70, -89, -79, 126, -17, -55, -37, 55, 106, -56, 74, -56, 9, 6, -28, -103, 2, 3, 1, 0, 1, -93, -127, -76, 48, -127, -79, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 53, 6, 3, 85, 29, 31, 4, 46, 48, 44, 48, 42, -96, 40, -96, 38, -122, 36, 104, 116, 116, 112, 58, 47, 47, 99, 114, 108, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 112, 99, 97, 49, 46, 49, 46, 49, 46, 99, 114, 108, 48, 71, 6, 3, 85, 29, 32, 4, 64, 48, 62, 48, 60, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 1, 1, 48, 45, 48, 43, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 31, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 82, 80, 65, 48, 15, 6, 3, 85, 29, 19, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, 66, 124, 14, -33, -116, 121, 76, -84, -65, 8, -20, 77, 85, 47, 80, -119, -96, -59, 94, 78, 46, 94, -107, 50, -101, 121, -83, 101, 17, 11, 28, 74, 82, -60, -43, -88, 49, 33, -114, -34, 16, -101, 108, 8, -59, 7, -26, 3, -71, -25, -56, 52, 120, 9, 9, -14, -68, 6, 66, -8, 90, -116, -125, -47, -118, -34, -86, 34, -11, -39, -29, 33, -46, -49, 101, -116, 6, 51, -80, -51, 32, -78, 51, -51, 10, -67, 62, -31, -99, -63, 53, -87, 100, -80, -89, -91, 36, 91, -23, -15, 104, -21, 19, -60, 124, 55, -12, -108, 100, 13, -102, -59, -67, 51, 23, -17, -125, 51, -96, 62, -27, -86, 62, -82, -40, 115, 31, -83};
        return byArray;
    }

    private static byte[] getClass2IntermediateCert() {
        byte[] byArray = new byte[]{48, -126, 3, 82, 48, -126, 2, -69, -96, 3, 2, 1, 2, 2, 16, 82, -56, 32, 19, 124, -123, -89, -19, -14, 23, -50, -126, -56, 69, 22, 115, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 56, 48, 53, 49, 50, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 52, 48, 49, 48, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -72, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 82, 80, 65, 32, 73, 110, 99, 111, 114, 112, 46, 32, 66, 121, 32, 82, 101, 102, 46, 44, 76, 73, 65, 66, 46, 76, 84, 68, 40, 99, 41, 57, 56, 49, 52, 48, 50, 6, 3, 85, 4, 3, 19, 43, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 50, 32, 67, 65, 32, 45, 32, 73, 110, 100, 105, 118, 105, 100, 117, 97, 108, 32, 83, 117, 98, 115, 99, 114, 105, 98, 101, 114, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -75, -53, 26, 84, 94, 37, -80, 44, 89, 95, 9, 107, -48, -38, -42, 74, 75, 17, -99, 26, 10, 62, 126, 47, -73, 101, 95, 23, 99, 21, -27, 44, -48, 32, 0, 12, -16, -70, 107, -86, 94, 73, -79, 104, -109, -125, 37, -84, 36, 95, -94, 35, 28, 105, 77, -72, 59, -37, 125, -38, -113, -63, 9, -49, -91, 88, 58, -74, 75, -60, -44, -37, -40, -82, 117, -6, -122, 34, -103, 34, 1, 40, 96, -91, -37, -43, 48, -33, 33, 112, 94, 72, -103, -83, 33, 84, -111, -47, -34, 95, -5, 56, 41, 83, 27, -30, 122, 83, 88, -59, 13, 93, 19, 7, -77, 80, -60, 6, 75, 57, -8, 84, -85, -71, -117, 105, 18, 19, 2, 3, 1, 0, 1, -93, -127, -76, 48, -127, -79, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 53, 6, 3, 85, 29, 31, 4, 46, 48, 44, 48, 42, -96, 40, -96, 38, -122, 36, 104, 116, 116, 112, 58, 47, 47, 99, 114, 108, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 112, 99, 97, 50, 46, 49, 46, 49, 46, 99, 114, 108, 48, 71, 6, 3, 85, 29, 32, 4, 64, 48, 62, 48, 60, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 1, 1, 48, 45, 48, 43, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 31, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 82, 80, 65, 48, 15, 6, 3, 85, 29, 19, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, -110, 11, 99, 81, 34, -22, -40, -23, 85, 95, -6, 56, -51, -45, 36, 94, -31, -12, 59, 24, -76, 73, -90, -88, -116, 20, 68, 17, 55, 20, -113, -102, 82, -72, -78, -124, -50, -35, -20, 23, -119, -43, 117, -60, -118, 82, -127, 7, -44, 88, 5, -39, -82, -97, -69, 8, -48, 100, -101, -103, -126, 86, 1, 47, -65, -34, 52, -95, -63, -119, 72, -41, -113, -117, 98, 22, -58, -123, -112, 101, 8, -40, 29, -7, -64, -73, 108, -53, 64, 126, 104, -17, -105, 33, 27, 52, -2, 90, -13, -96, -57, 95, 112, 3, 32, -19, -94, -126, -20, -26, -80, -63, -67, -13, 76, -21, -36, -96, 8, -95, 24, 65, 40, 47, -110, 127, 12, -71};
        return byArray;
    }

    private static byte[] getClass3IntermediateCert() {
        byte[] byArray = new byte[]{48, -126, 4, 49, 48, -126, 3, -102, -96, 3, 2, 1, 2, 2, 16, 35, 108, -105, 30, 43, -58, 13, 11, -7, 116, 96, -34, -15, 8, -61, -61, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 55, 48, 52, 49, 55, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 52, 48, 49, 48, 55, 50, 51, 53, 57, 53, 57, 90, 48, -127, -70, 49, 31, 48, 29, 6, 3, 85, 4, 10, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 23, 48, 21, 6, 3, 85, 4, 11, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 51, 48, 49, 6, 3, 85, 4, 11, 19, 42, 86, 101, 114, 105, 83, 105, 103, 110, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 32, 45, 32, 67, 108, 97, 115, 115, 32, 51, 49, 73, 48, 71, 6, 3, 85, 4, 11, 19, 64, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 67, 80, 83, 32, 73, 110, 99, 111, 114, 112, 46, 98, 121, 32, 82, 101, 102, 46, 32, 76, 73, 65, 66, 73, 76, 73, 84, 89, 32, 76, 84, 68, 46, 40, 99, 41, 57, 55, 32, 86, 101, 114, 105, 83, 105, 103, 110, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -40, -126, -128, -24, -42, 25, 2, 125, 31, -123, 24, 57, 37, -94, 101, 43, -31, -65, -44, 5, -45, -68, -26, 54, 59, -86, -16, 76, 108, 91, -74, -25, -86, 60, 115, 69, 85, -78, -15, -67, -22, -105, 66, -19, -102, 52, 10, 21, -44, -87, 92, -11, 64, 37, -35, -39, 7, -63, 50, -78, 117, 108, -60, -54, -69, -93, -2, 86, 39, 113, 67, -86, 99, -11, 48, 62, -109, 40, -27, -6, -15, 9, 59, -13, -73, 77, 78, 57, -9, 92, 73, 90, -72, -63, 29, -45, -78, -118, -2, 112, 48, -107, 66, -53, -2, 43, 81, -117, 90, 60, 58, -7, 34, 79, -112, -78, 2, -89, 83, -100, 79, 52, -25, -85, 4, -78, 123, 111, 2, 3, 1, 0, 1, -93, -126, 1, -112, 48, -126, 1, -116, 48, 15, 6, 3, 85, 29, 19, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 32, 6, 3, 85, 29, 37, 4, 25, 48, 23, 6, 10, 96, -122, 72, 1, -122, -8, 69, 1, 8, 1, 6, 9, 96, -122, 72, 1, -122, -8, 66, 4, 1, 48, -126, 1, 53, 6, 3, 85, 29, 32, 4, -126, 1, 44, 48, -126, 1, 40, 48, -126, 1, 36, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 1, 1, 48, -126, 1, 19, 48, 40, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 28, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 67, 80, 83, 48, -127, -26, 6, 8, 43, 6, 1, 5, 5, 7, 2, 2, 48, -127, -39, 48, 21, 22, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 48, 3, 2, 1, 1, 26, -127, -65, 86, 101, 114, 105, 83, 105, 103, 110, 39, 115, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 80, 114, 97, 99, 116, 105, 99, 101, 32, 83, 116, 97, 116, 101, 109, 101, 110, 116, 44, 32, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 67, 80, 83, 44, 32, 103, 111, 118, 101, 114, 110, 115, 32, 116, 104, 105, 115, 32, 99, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 38, 32, 105, 115, 32, 105, 110, 99, 111, 114, 112, 111, 114, 97, 116, 101, 100, 32, 98, 121, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 104, 101, 114, 101, 105, 110, 46, 32, 83, 79, 77, 69, 32, 87, 65, 82, 82, 65, 78, 84, 73, 69, 83, 32, 68, 73, 83, 67, 76, 65, 73, 77, 69, 68, 32, 38, 32, 76, 73, 65, 66, 73, 76, 73, 84, 89, 32, 76, 84, 68, 46, 32, 40, 99, 41, 49, 57, 57, 55, 32, 86, 101, 114, 105, 83, 105, 103, 110, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -72, -116, -104, -61, 43, 72, -11, 114, -51, 104, 13, 26, -77, 116, 99, -69, -79, 88, -74, -104, 69, 34, -20, 17, -115, -57, 78, 51, -117, 98, 90, 33, 36, 108, -102, -64, 66, -76, 69, -87, 58, -5, 103, -16, -111, -66, 24, 31, -43, 72, 25, -109, 107, -115, -53, 55, 75, -122, -26, 125, -101, -3, -116, 120, -103, -1, -125, -62, -4, -39, 85, 6, -98, 49, 102, 70, 125, 27, 120, 96, -12, 85, -44, 108, 85, -56, 105, 98, 112, 124, 77, -74, -119, 6, 5, -101, -56, 67, -114, -52, 12, 40, -43, -47, -116, -51, 70, 80, -29, 49, -106, 102, -110, 17, 36, 30, 74, 91, 75, 102, 94, 101, 85, 30, 95, 55, -102, -82};
        return byArray;
    }

    public static class LocalClassLoader
    extends ClassLoader {
        String fullPathFileName;

        public LocalClassLoader(String string) {
            this.fullPathFileName = string;
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return this.loadClass(string, true);
        }

        public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            try {
                Class<?> clazz = null;
                if (!(className != null && string.equals(className) || (clazz = this.findLoadedClass(string)) != null)) {
                    try {
                        clazz = this.findSystemClass(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    File file = new File(this.fullPathFileName);
                    int n = (int)file.length();
                    byte[] byArray = new byte[n];
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                    dataInputStream.readFully(byArray);
                    dataInputStream.close();
                    clazz = this.defineClass(string, byArray, 0, n);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassNotFoundException(classFormatError.toString());
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.toString());
            }
        }
    }
}

