/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class LastReqEntry {
    private int a;
    private KerberosTime b;

    private LastReqEntry() {
    }

    public LastReqEntry(int n2, KerberosTime kerberosTime) {
        this.a = n2;
        this.b = kerberosTime;
    }

    public LastReqEntry(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.a = derValue2.getData().getBigInteger().intValue();
        this.b = KerberosTime.parse(derValue.getData(), (byte)1, false);
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.a);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.b.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public Object clone() {
        LastReqEntry lastReqEntry = new LastReqEntry();
        lastReqEntry.a = this.a;
        lastReqEntry.b = (KerberosTime)this.b.clone();
        return lastReqEntry;
    }
}

