/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import sun.text.ComposeData;
import sun.text.DecompData;

public final class Normalizer
implements Cloneable {
    public static final char DONE = '\uffff';
    private static final int COMPAT_BIT = 1;
    private static final int DECOMP_BIT = 2;
    private static final int COMPOSE_BIT = 4;
    public static final Mode NO_OP = new Mode(0);
    public static final Mode COMPOSE = new Mode(4);
    public static final Mode COMPOSE_COMPAT = new Mode(5);
    public static final Mode DECOMP = new Mode(2);
    public static final Mode DECOMP_COMPAT = new Mode(3);
    public static final int IGNORE_HANGUL = 1;
    static final char HANGUL_BASE = '\uac00';
    static final char HANGUL_LIMIT = '\ud7a4';
    private static final char JAMO_LBASE = '\u1100';
    private static final char JAMO_VBASE = '\u1161';
    private static final char JAMO_TBASE = '\u11a7';
    private static final int JAMO_LCOUNT = 19;
    private static final int JAMO_VCOUNT = 21;
    private static final int JAMO_TCOUNT = 28;
    private static final int JAMO_NCOUNT = 588;
    private static final boolean DEBUG = false;
    private Mode mode = DECOMP;
    private int options = 0;
    private transient int minDecomp;
    private int currentIndex = 0;
    private int nextIndex = 0;
    private CharacterIterator text;
    private boolean atEnd = false;
    private StringBuffer buffer = null;
    private int bufferPos = 0;
    private char currentChar;
    private static final int EMPTY = -1;
    private StringBuffer explodeBuf = null;
    static final int STR_INDEX_SHIFT = 2;
    static final int STR_LENGTH_MASK = 3;

    public Normalizer(String string, Mode mode) {
        this(new StringCharacterIterator(string), mode, 0);
    }

    public Normalizer(String string, Mode mode, int n) {
        this(new StringCharacterIterator(string), mode, n);
    }

    public Normalizer(CharacterIterator characterIterator, Mode mode) {
        this(characterIterator, mode, 0);
    }

    public Normalizer(CharacterIterator characterIterator, Mode mode, int n) {
        this.text = characterIterator;
        this.mode = mode;
        this.options = n;
        this.minDecomp = mode.compat() ? 0 : 11177;
    }

    public Object clone() {
        try {
            Normalizer normalizer = (Normalizer)super.clone();
            normalizer.text = (CharacterIterator)this.text.clone();
            if (this.buffer != null) {
                normalizer.buffer = new StringBuffer();
                if (this.buffer.length() > 0) {
                    normalizer.buffer.append(this.buffer);
                }
            }
            return normalizer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static String normalize(String string, Mode mode, int n) {
        return Normalizer.normalize(string, mode, n, false);
    }

    public static String normalize(String string, Mode mode, int n, boolean bl) {
        if (mode.compose()) {
            return Normalizer.compose(string, mode.compat(), n);
        }
        if (mode.decomp()) {
            return Normalizer.decompose(string, mode.compat(), n, bl);
        }
        return string;
    }

    public static String compose(String string, boolean bl, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = bl ? 0 : 4341;
        int n8 = bl ? 0 : 11177;
        int n9 = 0;
        while (n9 < string.length() || n2 != -1) {
            int n10;
            int n11;
            char c;
            char c2;
            if (n2 == -1) {
                c2 = string.charAt(n9++);
            } else {
                c2 = stringBuffer2.charAt(n2++);
                if (n2 >= stringBuffer2.length()) {
                    n2 = -1;
                    stringBuffer2.setLength(0);
                }
            }
            int n12 = Normalizer.composeLookup(c2);
            int n13 = n12 & 7;
            int n14 = n12 >>> 3;
            if (n13 == 1 || n13 == 2 && n14 < n7) {
                n6 = 0;
                n5 = 0;
                n4 = n14;
                n3 = stringBuffer.length();
                stringBuffer.append(c2);
                continue;
            }
            if (n13 == 3) {
                int n15;
                c = ComposeData.typeBit[n14];
                int n16 = n11 = 0 != (c < ' ' ? n5 & 1 << c : n6 & 1 << (c & 0x1F)) ? 1 : 0;
                if (n14 < 55 && n11 == 0 && (n15 = Normalizer.composeAction(n4, n14)) > 0) {
                    if (n15 > 64285) {
                        n10 = Normalizer.pairExplode(stringBuffer2, n15);
                        n2 = 0;
                        stringBuffer.setCharAt(n3, (char)n10);
                        n4 = Normalizer.composeLookup((char)n10) >>> 3;
                    } else {
                        n10 = n15;
                        stringBuffer.setCharAt(n3, (char)n10);
                        n4 = Normalizer.composeLookup((char)n10) >>> 3;
                    }
                    n10 = stringBuffer.length();
                    if (n10 - n3 <= 1) continue;
                    int n17 = n3 + 1;
                    while (n17 < n10) {
                        stringBuffer2.append(stringBuffer.charAt(n17));
                        ++n17;
                    }
                    stringBuffer.setLength(n3 + 1);
                    n6 = 0;
                    n5 = 0;
                    if (n2 != -1) continue;
                    n2 = 0;
                    continue;
                }
                Normalizer.bubbleAppend(stringBuffer, c2, c);
                if (c < ' ') {
                    n5 |= 1 << c;
                    continue;
                }
                n6 |= 1 << (c & 0x1F);
                continue;
            }
            if (n14 > n7) {
                Normalizer.explode(stringBuffer2, n14);
                n2 = 0;
                continue;
            }
            if (n13 == 7 && n7 == 0) {
                Normalizer.hangulToJamo(c2, stringBuffer2, n8);
                n2 = 0;
                continue;
            }
            if (n13 == 4) {
                n6 = 0;
                n5 = 0;
                n4 = 8983;
                n3 = stringBuffer.length();
                stringBuffer.append(c2);
                continue;
            }
            if (n13 == 5 && n5 == 0 && n6 == 0 && n4 == 8983) {
                c = stringBuffer.charAt(n3) - 4352;
                n11 = c2 - 4449;
                n10 = (char)(44032 + (c * 21 + n11) * 28);
                stringBuffer.setCharAt(n3, (char)n10);
                n4 = 8984;
                continue;
            }
            if (n13 == 6 && n5 == 0 && n6 == 0 && n4 == 8984) {
                c = (char)(stringBuffer.charAt(n3) + (c2 - 4519));
                stringBuffer.setCharAt(n3, c);
                n4 = 0;
                n3 = -1;
                n6 = 0;
                n5 = 0;
                continue;
            }
            n4 = 0;
            n3 = -1;
            n6 = 0;
            n5 = 0;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private char nextCompose() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = true;
        this.currentIndex = this.nextIndex;
        this.text.setIndex(this.currentIndex);
        int n7 = this.mode.compat() ? 0 : 4341;
        int n8 = this.mode.compat() ? 0 : 11177;
        this.initBuffer();
        if (this.explodeBuf == null) {
            this.explodeBuf = new StringBuffer();
        } else {
            this.explodeBuf.setLength(0);
        }
        int n9 = this.curForward();
        while (n9 != 65535) {
            int n10;
            int n11;
            char c;
            int n12 = Normalizer.composeLookup((char)n9);
            int n13 = n12 & 7;
            int n14 = n12 >>> 3;
            if (n13 == 1 || n13 == 2 && n14 < n7) {
                if (this.getBufferLength() > 0 && bl && n == -1) break;
                n5 = 0;
                n4 = 0;
                n3 = n14;
                n2 = this.getBufferLength();
                this.buffer.append((char)n9);
                n6 = n9;
            } else if (n13 == 3) {
                int n15;
                c = ComposeData.typeBit[n14];
                int n16 = n11 = 0 != (c < ' ' ? n4 & 1 << c : n5 & 1 << (c & 0x1F)) ? 1 : 0;
                if (n14 < 55 && n11 == 0 && (n15 = Normalizer.composeAction(n3, n14)) > 0) {
                    if (n15 > 64285) {
                        n10 = Normalizer.pairExplode(this.explodeBuf, n15);
                        n = 0;
                        this.buffer.setCharAt(n2, (char)n10);
                        n3 = Normalizer.composeLookup((char)n10) >>> 3;
                        n6 = n10;
                    } else {
                        n10 = n15;
                        this.buffer.setCharAt(n2, (char)n10);
                        n3 = Normalizer.composeLookup((char)n10) >>> 3;
                        n6 = n10;
                    }
                    n10 = this.getBufferLength();
                    if (n10 - n2 > 1) {
                        int n17 = n2 + 1;
                        while (n17 < n10) {
                            this.explodeBuf.append(this.buffer.charAt(n17));
                            ++n17;
                        }
                        this.buffer.setLength(n2 + 1);
                        n5 = 0;
                        n4 = 0;
                        if (n == -1) {
                            n = 0;
                        }
                    }
                } else {
                    Normalizer.bubbleAppend(this.buffer, (char)n9, c);
                    if (c < ' ') {
                        n4 |= 1 << c;
                    } else {
                        n5 |= 1 << (c & 0x1F);
                    }
                }
            } else if (n14 > n7) {
                Normalizer.explode(this.explodeBuf, n14);
                n = 0;
            } else if (n13 == 7 && n7 == 0) {
                Normalizer.hangulToJamo((char)n9, this.explodeBuf, n8);
                n = 0;
            } else if (n13 == 4) {
                if (this.getBufferLength() > 0 && bl && n == -1) break;
                n5 = 0;
                n4 = 0;
                n3 = 8983;
                n2 = this.getBufferLength();
                this.buffer.append((char)n9);
            } else if (n13 == 5 && n4 == 0 && n5 == 0 && n3 == 8983) {
                c = this.buffer.charAt(n2) - 4352;
                n11 = n9 - 4449;
                n10 = (char)(44032 + (c * 21 + n11) * 28);
                this.buffer.setCharAt(n2, (char)n10);
                n3 = 8984;
            } else if (n13 == 6 && n4 == 0 && n5 == 0 && n3 == 8984) {
                c = (char)(this.buffer.charAt(n2) + (n9 - 4519));
                this.buffer.setCharAt(n2, c);
                n3 = 0;
                n2 = -1;
                n5 = 0;
                n4 = 0;
            } else {
                n3 = 0;
                n2 = -1;
                n5 = 0;
                n4 = 0;
                this.buffer.append((char)n9);
            }
            if (n == -1) {
                n9 = this.text.next();
                bl = true;
                continue;
            }
            n9 = this.explodeBuf.charAt(n++);
            if (n >= this.explodeBuf.length()) {
                n = -1;
                this.explodeBuf.setLength(0);
            }
            bl = false;
        }
        n9 = this.getBufferLength() > 0 ? (int)this.buffer.charAt(0) : 65535;
        this.nextIndex = this.text.getIndex();
        return (char)n9;
    }

    private char prevCompose() {
        char c;
        int n = this.mode.compat() ? 0 : 4341;
        this.nextIndex = this.currentIndex;
        this.initBuffer();
        while ((c = this.curBackward()) != '\uffff') {
            this.buffer.insert(0, c);
            int n2 = Normalizer.composeLookup(c);
            int n3 = n2 & 7;
            int n4 = n2 >>> 3;
            if (n3 == 1 || n3 == 2 && n4 < n || n3 == 7 || n3 == 4) break;
        }
        if (this.getBufferLength() > 0) {
            String string = Normalizer.compose(this.buffer.toString(), this.mode.compat(), this.options);
            this.buffer.setLength(0);
            this.buffer.append(string);
            if (this.getBufferLength() > 1) {
                this.bufferPos = this.getBufferLength() - 1;
                c = this.buffer.charAt(this.bufferPos);
            } else {
                c = this.buffer.charAt(0);
            }
        } else {
            c = '\uffff';
        }
        this.currentIndex = this.text.getIndex();
        return c;
    }

    private static void bubbleAppend(StringBuffer stringBuffer, char c, int n) {
        int n2 = stringBuffer.length() - 1;
        if (n != 1) {
            while (n2 >= 0) {
                int n3 = Normalizer.getComposeClass(stringBuffer.charAt(n2));
                if (n3 <= n) break;
                --n2;
            }
        }
        stringBuffer.insert(n2 + 1, c);
    }

    private static int getComposeClass(char c) {
        int n = 0;
        int n2 = Normalizer.composeLookup(c);
        int n3 = n2 & 7;
        if (n3 == 3) {
            n = ComposeData.typeBit[n2 >>> 3];
        }
        return n;
    }

    static final int composeLookup(char c) {
        return ComposeData.lookup.elementAt(c);
    }

    static final int composeAction(int n, int n2) {
        return ComposeData.actions.elementAt((char)(n + 1024 * n2));
    }

    static final void explode(StringBuffer stringBuffer, int n) {
        char c;
        while ((c = "  \u0308\u0000s\u0000\u03a5\u0000 \u0313\u0000 \u0314\u0000 \u0000a\u0000 \u0304\u00002\u00003\u0000 \u0301\u0000\u03bc\u0000 \u0327\u00001\u0000o\u00001\u20444\u00001\u20442\u00003\u20444\u0000IJ\u0000ij\u0000L\u00b7\u0000l\u00b7\u0000\u02bcn\u0000DZ\u030c\u0000Dz\u030c\u0000dz\u030c\u0000LJ\u0000Lj\u0000lj\u0000NJ\u0000Nj\u0000nj\u0000DZ\u0000Dz\u0000dz\u0000h\u0000\u0266\u0000r\u0000\u0279\u0000\u027b\u0000\u0281\u0000w\u0000y\u0000 \u0306\u0000 \u0307\u0000 \u030a\u0000 \u0328\u0000 \u0303\u0000 \u030b\u0000\u0263\u0000l\u0000x\u0000\u0295\u0000 \u0345\u0000 \u0308\u0301\u0000\u03b2\u0000\u03b8\u0000\u03a5\u0301\u0000\u03a5\u0308\u0000\u03c6\u0000\u03c0\u0000\u03ba\u0000\u03c1\u0000\u03c2\u0000\u0565\u0582\u0000\u0627\u0674\u0000\u0648\u0674\u0000\u06c7\u0674\u0000\u064a\u0674\u0000\u0e4d\u0e32\u0000\u0ecd\u0eb2\u0000\u0eab\u0e99\u0000\u0eab\u0ea1\u0000\u0f0b\u0000\u0fb2\u0f71\u0f80\u0000\u0fb3\u0f71\u0f80\u0000a\u02be\u0000s\u0307\u0000 \u0342\u0000 \u0308\u0342\u0000 \u0313\u0300\u0000 \u0313\u0301\u0000 \u0313\u0342\u0000 \u0314\u0300\u0000 \u0314\u0301\u0000 \u0314\u0342\u0000 \u0308\u0300\u0000\u2010\u0000 \u0333\u0000.\u0000..\u0000...\u0000\u2032\u2032\u0000\u2032\u2032\u2032\u0000\u2035\u2035\u0000\u2035\u2035\u2035\u0000!!\u0000 \u0305\u0000?!\u0000!?\u00000\u00005\u00006\u00007\u00008\u00009\u0000+\u0000\u2212\u0000=\u0000(\u0000)\u0000Rs\u0000a/c\u0000a/s\u0000C\u0000\u00b0C\u0000c/o\u0000c/u\u0000\u0190\u0000\u00b0F\u0000g\u0000H\u0000\u0127\u0000I\u0000L\u0000N\u0000No\u0000P\u0000Q\u0000R\u0000SM\u0000TEL\u0000TM\u0000B\u0000e\u0000E\u0000\u05d0\u0000\u05d1\u0000\u05d2\u0000\u05d3\u0000i\u00001\u20443\u00002\u20443\u00001\u20445\u00002\u20445\u00003\u20445\u00004\u20445\u00001\u20446\u00005\u20446\u00001\u20448\u00003\u20448\u00005\u20448\u00007\u20448\u00001\u2044\u0000II\u0000III\u0000IV\u0000VI\u0000VII\u0000VIII\u0000IX\u0000XI\u0000XII\u0000D\u0000ii\u0000iii\u0000iv\u0000vi\u0000vii\u0000viii\u0000ix\u0000xi\u0000xii\u0000d\u0000m\u0000\u222b\u222b\u0000\u222b\u222b\u222b\u0000\u222e\u222e\u0000\u222e\u222e\u222e\u000010\u000011\u000012\u000013\u000014\u000015\u000016\u000017\u000018\u000019\u000020\u0000(1)\u0000(2)\u0000(3)\u0000(4)\u0000(5)\u0000(6)\u0000(7)\u0000(8)\u0000(9)\u0000(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.\u00002.\u00003.\u00004.\u00005.\u00006.\u00007.\u00008.\u00009.\u000010.\u000011.\u000012.\u000013.\u000014.\u000015.\u000016.\u000017.\u000018.\u000019.\u000020.\u0000(a)\u0000(b)\u0000(c)\u0000(d)\u0000(e)\u0000(f)\u0000(g)\u0000(h)\u0000(i)\u0000(j)\u0000(k)\u0000(l)\u0000(m)\u0000(n)\u0000(o)\u0000(p)\u0000(q)\u0000(r)\u0000(s)\u0000(t)\u0000(u)\u0000(v)\u0000(w)\u0000(x)\u0000(y)\u0000(z)\u0000A\u0000G\u0000K\u0000O\u0000S\u0000T\u0000U\u0000W\u0000Y\u0000b\u0000f\u0000k\u0000p\u0000q\u0000t\u0000\u6bcd\u0000\u9f9f\u0000\u4e00\u0000\u4e28\u0000\u4e36\u0000\u4e3f\u0000\u4e59\u0000\u4e85\u0000\u4e8c\u0000\u4ea0\u0000\u4eba\u0000\u513f\u0000\u5165\u0000\u516b\u0000\u5182\u0000\u5196\u0000\u51ab\u0000\u51e0\u0000\u51f5\u0000\u5200\u0000\u529b\u0000\u52f9\u0000\u5315\u0000\u531a\u0000\u5338\u0000\u5341\u0000\u535c\u0000\u5369\u0000\u5382\u0000\u53b6\u0000\u53c8\u0000\u53e3\u0000\u56d7\u0000\u571f\u0000\u58eb\u0000\u5902\u0000\u590a\u0000\u5915\u0000\u5927\u0000\u5973\u0000\u5b50\u0000\u5b80\u0000\u5bf8\u0000\u5c0f\u0000\u5c22\u0000\u5c38\u0000\u5c6e\u0000\u5c71\u0000\u5ddb\u0000\u5de5\u0000\u5df1\u0000\u5dfe\u0000\u5e72\u0000\u5e7a\u0000\u5e7f\u0000\u5ef4\u0000\u5efe\u0000\u5f0b\u0000\u5f13\u0000\u5f50\u0000\u5f61\u0000\u5f73\u0000\u5fc3\u0000\u6208\u0000\u6236\u0000\u624b\u0000\u652f\u0000\u6534\u0000\u6587\u0000\u6597\u0000\u65a4\u0000\u65b9\u0000\u65e0\u0000\u65e5\u0000\u66f0\u0000\u6708\u0000\u6728\u0000\u6b20\u0000\u6b62\u0000\u6b79\u0000\u6bb3\u0000\u6bcb\u0000\u6bd4\u0000\u6bdb\u0000\u6c0f\u0000\u6c14\u0000\u6c34\u0000\u706b\u0000\u722a\u0000\u7236\u0000\u723b\u0000\u723f\u0000\u7247\u0000\u7259\u0000\u725b\u0000\u72ac\u0000\u7384\u0000\u7389\u0000\u74dc\u0000\u74e6\u0000\u7518\u0000\u751f\u0000\u7528\u0000\u7530\u0000\u758b\u0000\u7592\u0000\u7676\u0000\u767d\u0000\u76ae\u0000\u76bf\u0000\u76ee\u0000\u77db\u0000\u77e2\u0000\u77f3\u0000\u793a\u0000\u79b8\u0000\u79be\u0000\u7a74\u0000\u7acb\u0000\u7af9\u0000\u7c73\u0000\u7cf8\u0000\u7f36\u0000\u7f51\u0000\u7f8a\u0000\u7fbd\u0000\u8001\u0000\u800c\u0000\u8012\u0000\u8033\u0000\u807f\u0000\u8089\u0000\u81e3\u0000\u81ea\u0000\u81f3\u0000\u81fc\u0000\u820c\u0000\u821b\u0000\u821f\u0000\u826e\u0000\u8272\u0000\u8278\u0000\u864d\u0000\u866b\u0000\u8840\u0000\u884c\u0000\u8863\u0000\u897e\u0000\u898b\u0000\u89d2\u0000\u8a00\u0000\u8c37\u0000\u8c46\u0000\u8c55\u0000\u8c78\u0000\u8c9d\u0000\u8d64\u0000\u8d70\u0000\u8db3\u0000\u8eab\u0000\u8eca\u0000\u8f9b\u0000\u8fb0\u0000\u8fb5\u0000\u9091\u0000\u9149\u0000\u91c6\u0000\u91cc\u0000\u91d1\u0000\u9577\u0000\u9580\u0000\u961c\u0000\u96b6\u0000\u96b9\u0000\u96e8\u0000\u9751\u0000\u975e\u0000\u9762\u0000\u9769\u0000\u97cb\u0000\u97ed\u0000\u97f3\u0000\u9801\u0000\u98a8\u0000\u98db\u0000\u98df\u0000\u9996\u0000\u9999\u0000\u99ac\u0000\u9aa8\u0000\u9ad8\u0000\u9adf\u0000\u9b25\u0000\u9b2f\u0000\u9b32\u0000\u9b3c\u0000\u9b5a\u0000\u9ce5\u0000\u9e75\u0000\u9e7f\u0000\u9ea5\u0000\u9ebb\u0000\u9ec3\u0000\u9ecd\u0000\u9ed1\u0000\u9ef9\u0000\u9efd\u0000\u9f0e\u0000\u9f13\u0000\u9f20\u0000\u9f3b\u0000\u9f4a\u0000\u9f52\u0000\u9f8d\u0000\u9f9c\u0000\u9fa0\u0000\u3012\u0000\u5344\u0000\u5345\u0000 \u3099\u0000 \u309a\u0000\u1100\u0000\u1101\u0000\u11aa\u0000\u1102\u0000\u11ac\u0000\u11ad\u0000\u1103\u0000\u1104\u0000\u1105\u0000\u11b0\u0000\u11b1\u0000\u11b2\u0000\u11b3\u0000\u11b4\u0000\u11b5\u0000\u111a\u0000\u1106\u0000\u1107\u0000\u1108\u0000\u1121\u0000\u1109\u0000\u110a\u0000\u110b\u0000\u110c\u0000\u110d\u0000\u110e\u0000\u110f\u0000\u1110\u0000\u1111\u0000\u1112\u0000\u1161\u0000\u1162\u0000\u1163\u0000\u1164\u0000\u1165\u0000\u1166\u0000\u1167\u0000\u1168\u0000\u1169\u0000\u116a\u0000\u116b\u0000\u116c\u0000\u116d\u0000\u116e\u0000\u116f\u0000\u1170\u0000\u1171\u0000\u1172\u0000\u1173\u0000\u1174\u0000\u1175\u0000\u1160\u0000\u1114\u0000\u1115\u0000\u11c7\u0000\u11c8\u0000\u11cc\u0000\u11ce\u0000\u11d3\u0000\u11d7\u0000\u11d9\u0000\u111c\u0000\u11dd\u0000\u11df\u0000\u111d\u0000\u111e\u0000\u1120\u0000\u1122\u0000\u1123\u0000\u1127\u0000\u1129\u0000\u112b\u0000\u112c\u0000\u112d\u0000\u112e\u0000\u112f\u0000\u1132\u0000\u1136\u0000\u1140\u0000\u1147\u0000\u114c\u0000\u11f1\u0000\u11f2\u0000\u1157\u0000\u1158\u0000\u1159\u0000\u1184\u0000\u1185\u0000\u1188\u0000\u1191\u0000\u1192\u0000\u1194\u0000\u119e\u0000\u11a1\u0000\u4e09\u0000\u56db\u0000\u4e0a\u0000\u4e2d\u0000\u4e0b\u0000\u7532\u0000\u4e19\u0000\u4e01\u0000\u5929\u0000\u5730\u0000(\u1100)\u0000(\u1102)\u0000(\u1103)\u0000(\u1105)\u0000(\u1106)\u0000(\u1107)\u0000(\u1109)\u0000(\u110b)\u0000(\u110c)\u0000(\u110e)\u0000(\u110f)\u0000(\u1110)\u0000(\u1111)\u0000(\u1112)\u0000(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)\u0000(\u4e8c)\u0000(\u4e09)\u0000(\u56db)\u0000(\u4e94)\u0000(\u516d)\u0000(\u4e03)\u0000(\u516b)\u0000(\u4e5d)\u0000(\u5341)\u0000(\u6708)\u0000(\u706b)\u0000(\u6c34)\u0000(\u6728)\u0000(\u91d1)\u0000(\u571f)\u0000(\u65e5)\u0000(\u682a)\u0000(\u6709)\u0000(\u793e)\u0000(\u540d)\u0000(\u7279)\u0000(\u8ca1)\u0000(\u795d)\u0000(\u52b4)\u0000(\u4ee3)\u0000(\u547c)\u0000(\u5b66)\u0000(\u76e3)\u0000(\u4f01)\u0000(\u8cc7)\u0000(\u5354)\u0000(\u796d)\u0000(\u4f11)\u0000(\u81ea)\u0000(\u81f3)\u0000\u1100\u1161\u0000\u1102\u1161\u0000\u1103\u1161\u0000\u1105\u1161\u0000\u1106\u1161\u0000\u1107\u1161\u0000\u1109\u1161\u0000\u110b\u1161\u0000\u110c\u1161\u0000\u110e\u1161\u0000\u110f\u1161\u0000\u1110\u1161\u0000\u1111\u1161\u0000\u1112\u1161\u0000\u4e94\u0000\u516d\u0000\u4e03\u0000\u4e5d\u0000\u682a\u0000\u6709\u0000\u793e\u0000\u540d\u0000\u7279\u0000\u8ca1\u0000\u795d\u0000\u52b4\u0000\u79d8\u0000\u7537\u0000\u9069\u0000\u512a\u0000\u5370\u0000\u6ce8\u0000\u9805\u0000\u4f11\u0000\u5199\u0000\u6b63\u0000\u5de6\u0000\u53f3\u0000\u533b\u0000\u5b97\u0000\u5b66\u0000\u76e3\u0000\u4f01\u0000\u8cc7\u0000\u5354\u0000\u591c\u00001\u6708\u00002\u6708\u00003\u6708\u00004\u6708\u00005\u6708\u00006\u6708\u00007\u6708\u00008\u6708\u00009\u6708\u000010\u6708\u000011\u6708\u000012\u6708\u0000\u30a2\u0000\u30a4\u0000\u30a6\u0000\u30a8\u0000\u30aa\u0000\u30ab\u0000\u30ad\u0000\u30af\u0000\u30b1\u0000\u30b3\u0000\u30b5\u0000\u30b7\u0000\u30b9\u0000\u30bb\u0000\u30bd\u0000\u30bf\u0000\u30c1\u0000\u30c4\u0000\u30c6\u0000\u30c8\u0000\u30ca\u0000\u30cb\u0000\u30cc\u0000\u30cd\u0000\u30ce\u0000\u30cf\u0000\u30d2\u0000\u30d5\u0000\u30d8\u0000\u30db\u0000\u30de\u0000\u30df\u0000\u30e0\u0000\u30e1\u0000\u30e2\u0000\u30e4\u0000\u30e6\u0000\u30e8\u0000\u30e9\u0000\u30ea\u0000\u30eb\u0000\u30ec\u0000\u30ed\u0000\u30ef\u0000\u30f0\u0000\u30f1\u0000\u30f2\u0000\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u0000\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u0000\u30a6\u30a9\u30f3\u0000\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u0000\u30aa\u30fc\u30e0\u0000\u30ab\u30a4\u30ea\u0000\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u0000\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u0000\u30b3\u30eb\u30ca\u0000\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u0000\u30bb\u30f3\u30c8\u0000\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u0000\u30c8\u3099\u30eb\u0000\u30ca\u30ce\u0000\u30ce\u30c3\u30c8\u0000\u30cf\u30a4\u30c4\u0000\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u0000\u30d2\u3099\u30eb\u0000\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u0000\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u0000\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u0000\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u0000\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u0000\u30db\u30fc\u30f3\u0000\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u0000\u30de\u30c3\u30cf\u0000\u30de\u30eb\u30af\u0000\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u0000\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u0000\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u0000\u30e6\u30a2\u30f3\u0000\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u0000\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u0000\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b9\u00001\u70b9\u00002\u70b9\u00003\u70b9\u00004\u70b9\u00005\u70b9\u00006\u70b9\u00007\u70b9\u00008\u70b9\u00009\u70b9\u000010\u70b9\u000011\u70b9\u000012\u70b9\u000013\u70b9\u000014\u70b9\u000015\u70b9\u000016\u70b9\u000017\u70b9\u000018\u70b9\u000019\u70b9\u000020\u70b9\u000021\u70b9\u000022\u70b9\u000023\u70b9\u000024\u70b9\u0000hPa\u0000da\u0000AU\u0000bar\u0000oV\u0000pc\u0000\u5e73\u6210\u0000\u662d\u548c\u0000\u5927\u6b63\u0000\u660e\u6cbb\u0000\u682a\u5f0f\u4f1a\u793e\u0000pA\u0000nA\u0000\u03bcA\u0000mA\u0000kA\u0000KB\u0000MB\u0000GB\u0000cal\u0000kcal\u0000pF\u0000nF\u0000\u03bcF\u0000\u03bcg\u0000mg\u0000kg\u0000Hz\u0000kHz\u0000MHz\u0000GHz\u0000THz\u0000\u03bcl\u0000ml\u0000dl\u0000kl\u0000fm\u0000nm\u0000\u03bcm\u0000mm\u0000cm\u0000km\u0000mm2\u0000cm2\u0000km2\u0000mm3\u0000cm3\u0000km3\u0000m\u2215s\u0000m\u2215s2\u0000kPa\u0000MPa\u0000GPa\u0000rad\u0000rad\u2215s\u0000rad\u2215s2\u0000ps\u0000ns\u0000\u03bcs\u0000ms\u0000pV\u0000nV\u0000\u03bcV\u0000mV\u0000kV\u0000MV\u0000pW\u0000nW\u0000\u03bcW\u0000mW\u0000kW\u0000MW\u0000k\u03a9\u0000M\u03a9\u0000a.m.\u0000Bq\u0000cc\u0000cd\u0000C\u2215kg\u0000Co.\u0000dB\u0000Gy\u0000ha\u0000HP\u0000in\u0000KK\u0000KM\u0000kt\u0000lm\u0000ln\u0000log\u0000lx\u0000mb\u0000mil\u0000mol\u0000PH\u0000p.m.\u0000PPM\u0000PR\u0000sr\u0000Sv\u0000Wb\u00001\u65e5\u00002\u65e5\u00003\u65e5\u00004\u65e5\u00005\u65e5\u00006\u65e5\u00007\u65e5\u00008\u65e5\u00009\u65e5\u000010\u65e5\u000011\u65e5\u000012\u65e5\u000013\u65e5\u000014\u65e5\u000015\u65e5\u000016\u65e5\u000017\u65e5\u000018\u65e5\u000019\u65e5\u000020\u65e5\u000021\u65e5\u000022\u65e5\u000023\u65e5\u000024\u65e5\u000025\u65e5\u000026\u65e5\u000027\u65e5\u000028\u65e5\u000029\u65e5\u000030\u65e5\u000031\u65e5\u0000ff\u0000fi\u0000fl\u0000ffi\u0000ffl\u0000st\u0000\u0574\u0576\u0000\u0574\u0565\u0000\u0574\u056b\u0000\u057e\u0576\u0000\u0574\u056d\u0000\u05e2\u0000\u05d4\u0000\u05db\u0000\u05dc\u0000\u05dd\u0000\u05e8\u0000\u05ea\u0000\u05d0\u05dc\u0000\u0671\u0000\u067b\u0000\u067e\u0000\u0680\u0000\u067a\u0000\u067f\u0000\u0679\u0000\u06a4\u0000\u06a6\u0000\u0684\u0000\u0683\u0000\u0686\u0000\u0687\u0000\u068d\u0000\u068c\u0000\u068e\u0000\u0688\u0000\u0698\u0000\u0691\u0000\u06a9\u0000\u06af\u0000\u06b3\u0000\u06b1\u0000\u06ba\u0000\u06bb\u0000\u06d5\u0654\u0000\u06c1\u0000\u06be\u0000\u06d2\u0000\u06d2\u0654\u0000\u06ad\u0000\u06c7\u0000\u06c6\u0000\u06c8\u0000\u06cb\u0000\u06c5\u0000\u06c9\u0000\u06d0\u0000\u0649\u0000\u064a\u0654\u0627\u0000\u064a\u0654\u06d5\u0000\u064a\u0654\u0648\u0000\u064a\u0654\u06c7\u0000\u064a\u0654\u06c6\u0000\u064a\u0654\u06c8\u0000\u064a\u0654\u06d0\u0000\u064a\u0654\u0649\u0000\u06cc\u0000\u064a\u0654\u062c\u0000\u064a\u0654\u062d\u0000\u064a\u0654\u0645\u0000\u064a\u0654\u064a\u0000\u0628\u062c\u0000\u0628\u062d\u0000\u0628\u062e\u0000\u0628\u0645\u0000\u0628\u0649\u0000\u0628\u064a\u0000\u062a\u062c\u0000\u062a\u062d\u0000\u062a\u062e\u0000\u062a\u0645\u0000\u062a\u0649\u0000\u062a\u064a\u0000\u062b\u062c\u0000\u062b\u0645\u0000\u062b\u0649\u0000\u062b\u064a\u0000\u062c\u062d\u0000\u062c\u0645\u0000\u062d\u062c\u0000\u062d\u0645\u0000\u062e\u062c\u0000\u062e\u062d\u0000\u062e\u0645\u0000\u0633\u062c\u0000\u0633\u062d\u0000\u0633\u062e\u0000\u0633\u0645\u0000\u0635\u062d\u0000\u0635\u0645\u0000\u0636\u062c\u0000\u0636\u062d\u0000\u0636\u062e\u0000\u0636\u0645\u0000\u0637\u062d\u0000\u0637\u0645\u0000\u0638\u0645\u0000\u0639\u062c\u0000\u0639\u0645\u0000\u063a\u062c\u0000\u063a\u0645\u0000\u0641\u062c\u0000\u0641\u062d\u0000\u0641\u062e\u0000\u0641\u0645\u0000\u0641\u0649\u0000\u0641\u064a\u0000\u0642\u062d\u0000\u0642\u0645\u0000\u0642\u0649\u0000\u0642\u064a\u0000\u0643\u0627\u0000\u0643\u062c\u0000\u0643\u062d\u0000\u0643\u062e\u0000\u0643\u0644\u0000\u0643\u0645\u0000\u0643\u0649\u0000\u0643\u064a\u0000\u0644\u062c\u0000\u0644\u062d\u0000\u0644\u062e\u0000\u0644\u0645\u0000\u0644\u0649\u0000\u0644\u064a\u0000\u0645\u062c\u0000\u0645\u062d\u0000\u0645\u062e\u0000\u0645\u0645\u0000\u0645\u0649\u0000\u0645\u064a\u0000\u0646\u062c\u0000\u0646\u062d\u0000\u0646\u062e\u0000\u0646\u0645\u0000\u0646\u0649\u0000\u0646\u064a\u0000\u0647\u062c\u0000\u0647\u0645\u0000\u0647\u0649\u0000\u0647\u064a\u0000\u064a\u062c\u0000\u064a\u062d\u0000\u064a\u062e\u0000\u064a\u0645\u0000\u064a\u0649\u0000\u064a\u064a\u0000\u0630\u0670\u0000\u0631\u0670\u0000\u0649\u0670\u0000 \u064c\u0651\u0000 \u064d\u0651\u0000 \u064e\u0651\u0000 \u064f\u0651\u0000 \u0650\u0651\u0000 \u0651\u0670\u0000\u064a\u0654\u0631\u0000\u064a\u0654\u0632\u0000\u064a\u0654\u0646\u0000\u0628\u0631\u0000\u0628\u0632\u0000\u0628\u0646\u0000\u062a\u0631\u0000\u062a\u0632\u0000\u062a\u0646\u0000\u062b\u0631\u0000\u062b\u0632\u0000\u062b\u0646\u0000\u0645\u0627\u0000\u0646\u0631\u0000\u0646\u0632\u0000\u0646\u0646\u0000\u064a\u0631\u0000\u064a\u0632\u0000\u064a\u0646\u0000\u064a\u0654\u062e\u0000\u064a\u0654\u0647\u0000\u0628\u0647\u0000\u062a\u0647\u0000\u0635\u062e\u0000\u0644\u0647\u0000\u0646\u0647\u0000\u0647\u0670\u0000\u064a\u0647\u0000\u062b\u0647\u0000\u0633\u0647\u0000\u0634\u0645\u0000\u0634\u0647\u0000\u0640\u064e\u0651\u0000\u0640\u064f\u0651\u0000\u0640\u0650\u0651\u0000\u0637\u0649\u0000\u0637\u064a\u0000\u0639\u0649\u0000\u0639\u064a\u0000\u063a\u0649\u0000\u063a\u064a\u0000\u0633\u0649\u0000\u0633\u064a\u0000\u0634\u0649\u0000\u0634\u064a\u0000\u062d\u0649\u0000\u062d\u064a\u0000\u062c\u0649\u0000\u062c\u064a\u0000\u062e\u0649\u0000\u062e\u064a\u0000\u0635\u0649\u0000\u0635\u064a\u0000\u0636\u0649\u0000\u0636\u064a\u0000\u0634\u062c\u0000\u0634\u062d\u0000\u0634\u062e\u0000\u0634\u0631\u0000\u0633\u0631\u0000\u0635\u0631\u0000\u0636\u0631\u0000\u0627\u064b\u0000\u062a\u062c\u0645\u0000\u062a\u062d\u062c\u0000\u062a\u062d\u0645\u0000\u062a\u062e\u0645\u0000\u062a\u0645\u062c\u0000\u062a\u0645\u062d\u0000\u062a\u0645\u062e\u0000\u062c\u0645\u062d\u0000\u062d\u0645\u064a\u0000\u062d\u0645\u0649\u0000\u0633\u062d\u062c\u0000\u0633\u062c\u062d\u0000\u0633\u062c\u0649\u0000\u0633\u0645\u062d\u0000\u0633\u0645\u062c\u0000\u0633\u0645\u0645\u0000\u0635\u062d\u062d\u0000\u0635\u0645\u0645\u0000\u0634\u062d\u0645\u0000\u0634\u062c\u064a\u0000\u0634\u0645\u062e\u0000\u0634\u0645\u0645\u0000\u0636\u062d\u0649\u0000\u0636\u062e\u0645\u0000\u0637\u0645\u062d\u0000\u0637\u0645\u0645\u0000\u0637\u0645\u064a\u0000\u0639\u062c\u0645\u0000\u0639\u0645\u0645\u0000\u0639\u0645\u0649\u0000\u063a\u0645\u0645\u0000\u063a\u0645\u064a\u0000\u063a\u0645\u0649\u0000\u0641\u062e\u0645\u0000\u0642\u0645\u062d\u0000\u0642\u0645\u0645\u0000\u0644\u062d\u0645\u0000\u0644\u062d\u064a\u0000\u0644\u062d\u0649\u0000\u0644\u062c\u062c\u0000\u0644\u062e\u0645\u0000\u0644\u0645\u062d\u0000\u0645\u062d\u062c\u0000\u0645\u062d\u0645\u0000\u0645\u062d\u064a\u0000\u0645\u062c\u062d\u0000\u0645\u062c\u0645\u0000\u0645\u062e\u062c\u0000\u0645\u062e\u0645\u0000\u0645\u062c\u062e\u0000\u0647\u0645\u062c\u0000\u0647\u0645\u0645\u0000\u0646\u062d\u0645\u0000\u0646\u062d\u0649\u0000\u0646\u062c\u0645\u0000\u0646\u062c\u0649\u0000\u0646\u0645\u064a\u0000\u0646\u0645\u0649\u0000\u064a\u0645\u0645\u0000\u0628\u062e\u064a\u0000\u062a\u062c\u064a\u0000\u062a\u062c\u0649\u0000\u062a\u062e\u064a\u0000\u062a\u062e\u0649\u0000\u062a\u0645\u064a\u0000\u062a\u0645\u0649\u0000\u062c\u0645\u064a\u0000\u062c\u062d\u0649\u0000\u062c\u0645\u0649\u0000\u0633\u062e\u0649\u0000\u0635\u062d\u064a\u0000\u0634\u062d\u064a\u0000\u0636\u062d\u064a\u0000\u0644\u062c\u064a\u0000\u0644\u0645\u064a\u0000\u064a\u062d\u064a\u0000\u064a\u062c\u064a\u0000\u064a\u0645\u064a\u0000\u0645\u0645\u064a\u0000\u0642\u0645\u064a\u0000\u0646\u062d\u064a\u0000\u0639\u0645\u064a\u0000\u0643\u0645\u064a\u0000\u0646\u062c\u062d\u0000\u0645\u062e\u064a\u0000\u0644\u062c\u0645\u0000\u0643\u0645\u0645\u0000\u062c\u062d\u064a\u0000\u062d\u062c\u064a\u0000\u0645\u062c\u064a\u0000\u0641\u0645\u064a\u0000\u0628\u062d\u064a\u0000\u0633\u062e\u064a\u0000\u0646\u062c\u064a\u0000\u0635\u0644\u06d2\u0000\u0642\u0644\u06d2\u0000\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0000\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u0000\u2013\u0000_\u0000{\u0000}\u0000\u3014\u0000\u3015\u0000\u3010\u0000\u3011\u0000\u300a\u0000\u300b\u0000\u3008\u0000\u3009\u0000\u300c\u0000\u300d\u0000\u300e\u0000\u300f\u0000,\u0000\u3001\u0000;\u0000:\u0000#\u0000&\u0000*\u0000-\u0000<\u0000>\u0000\\\u0000$\u0000%\u0000@\u0000 \u064b\u0000\u0640\u064b\u0000 \u064c\u0000 \u064d\u0000 \u064e\u0000\u0640\u064e\u0000 \u064f\u0000\u0640\u064f\u0000 \u0650\u0000\u0640\u0650\u0000 \u0651\u0000\u0640\u0651\u0000 \u0652\u0000\u0640\u0652\u0000\u0621\u0000\u0627\u0653\u0000\u0627\u0654\u0000\u0648\u0654\u0000\u0627\u0655\u0000\u064a\u0654\u0000\u0628\u0000\u0629\u0000\u062a\u0000\u062b\u0000\u0630\u0000\u0633\u0000\u0634\u0000\u0635\u0000\u0636\u0000\u0637\u0000\u0638\u0000\u0639\u0000\u063a\u0000\u0641\u0000\u0642\u0000\u0643\u0000\u0644\u0627\u0653\u0000\u0644\u0627\u0654\u0000\u0644\u0627\u0655\u0000\u0644\u0627\u0000\"\u0000'\u0000/\u0000[\u0000]\u0000^\u0000`\u0000|\u0000~\u0000\u3002\u0000\u30fb\u0000\u30a3\u0000\u30a5\u0000\u30a7\u0000\u30a9\u0000\u30e3\u0000\u30e5\u0000\u30e7\u0000\u30c3\u0000\u00a2\u0000\u00a3\u0000\u00ac\u0000\u00a6\u0000\u00a5\u0000\u20a9\u0000\u2502\u0000\u2190\u0000\u2191\u0000\u2192\u0000\u2193\u0000\u25a0\u0000\u25cb\u0000\u0300\u0000\u0301\u0000\u0313\u0000\u0308\u0301\u0000\u02b9\u0000;\u0000\u00b7\u0000\u0915\u093c\u0000\u0916\u093c\u0000\u0917\u093c\u0000\u091c\u093c\u0000\u0921\u093c\u0000\u0922\u093c\u0000\u092b\u093c\u0000\u092f\u093c\u0000\u09a1\u09bc\u0000\u09a2\u09bc\u0000\u09af\u09bc\u0000\u0a32\u0a3c\u0000\u0a38\u0a3c\u0000\u0a16\u0a3c\u0000\u0a17\u0a3c\u0000\u0a1c\u0a3c\u0000\u0a2b\u0a3c\u0000\u0b21\u0b3c\u0000\u0b22\u0b3c\u0000\u0f42\u0fb7\u0000\u0f4c\u0fb7\u0000\u0f51\u0fb7\u0000\u0f56\u0fb7\u0000\u0f5b\u0fb7\u0000\u0f40\u0fb5\u0000\u0f71\u0f72\u0000\u0f71\u0f74\u0000\u0fb2\u0f80\u0000\u0fb3\u0f80\u0000\u0f71\u0f80\u0000\u0f92\u0fb7\u0000\u0f9c\u0fb7\u0000\u0fa1\u0fb7\u0000\u0fa6\u0fb7\u0000\u0fab\u0fb7\u0000\u0f90\u0fb5\u0000\u03b1\u0301\u0000\u03b5\u0301\u0000\u03b7\u0301\u0000\u03b9\u0301\u0000\u03bf\u0301\u0000\u03c5\u0301\u0000\u03c9\u0301\u0000\u0391\u0301\u0000\u03b9\u0000\u0395\u0301\u0000\u0397\u0301\u0000\u03b9\u0308\u0301\u0000\u0399\u0301\u0000\u03c5\u0308\u0301\u0000\u03a5\u0301\u0000`\u0000\u039f\u0301\u0000\u03a9\u0301\u0000\u03a9\u0000K\u0000A\u030a\u0000\u3008\u0000\u3009\u0000\u8c48\u0000\u66f4\u0000\u8eca\u0000\u8cc8\u0000\u6ed1\u0000\u4e32\u0000\u53e5\u0000\u9f9c\u0000\u9f9c\u0000\u5951\u0000\u91d1\u0000\u5587\u0000\u5948\u0000\u61f6\u0000\u7669\u0000\u7f85\u0000\u863f\u0000\u87ba\u0000\u88f8\u0000\u908f\u0000\u6a02\u0000\u6d1b\u0000\u70d9\u0000\u73de\u0000\u843d\u0000\u916a\u0000\u99f1\u0000\u4e82\u0000\u5375\u0000\u6b04\u0000\u721b\u0000\u862d\u0000\u9e1e\u0000\u5d50\u0000\u6feb\u0000\u85cd\u0000\u8964\u0000\u62c9\u0000\u81d8\u0000\u881f\u0000\u5eca\u0000\u6717\u0000\u6d6a\u0000\u72fc\u0000\u90ce\u0000\u4f86\u0000\u51b7\u0000\u52de\u0000\u64c4\u0000\u6ad3\u0000\u7210\u0000\u76e7\u0000\u8001\u0000\u8606\u0000\u865c\u0000\u8def\u0000\u9732\u0000\u9b6f\u0000\u9dfa\u0000\u788c\u0000\u797f\u0000\u7da0\u0000\u83c9\u0000\u9304\u0000\u9e7f\u0000\u8ad6\u0000\u58df\u0000\u5f04\u0000\u7c60\u0000\u807e\u0000\u7262\u0000\u78ca\u0000\u8cc2\u0000\u96f7\u0000\u58d8\u0000\u5c62\u0000\u6a13\u0000\u6dda\u0000\u6f0f\u0000\u7d2f\u0000\u7e37\u0000\u96fb\u0000\u52d2\u0000\u808b\u0000\u51dc\u0000\u51cc\u0000\u7a1c\u0000\u7dbe\u0000\u83f1\u0000\u9675\u0000\u8b80\u0000\u62cf\u0000\u8afe\u0000\u4e39\u0000\u5be7\u0000\u6012\u0000\u7387\u0000\u7570\u0000\u5317\u0000\u78fb\u0000\u4fbf\u0000\u5fa9\u0000\u4e0d\u0000\u6ccc\u0000\u6578\u0000\u7d22\u0000\u53c3\u0000\u585e\u0000\u7701\u0000\u8449\u0000\u8aaa\u0000\u6bba\u0000\u8fb0\u0000\u6c88\u0000\u62fe\u0000\u82e5\u0000\u63a0\u0000\u7565\u0000\u4eae\u0000\u5169\u0000\u51c9\u0000\u6881\u0000\u7ce7\u0000\u826f\u0000\u8ad2\u0000\u91cf\u0000\u52f5\u0000\u5442\u0000\u5973\u0000\u5eec\u0000\u65c5\u0000\u6ffe\u0000\u792a\u0000\u95ad\u0000\u9a6a\u0000\u9e97\u0000\u9ece\u0000\u529b\u0000\u66c6\u0000\u6b77\u0000\u8f62\u0000\u5e74\u0000\u6190\u0000\u6200\u0000\u649a\u0000\u6f23\u0000\u7149\u0000\u7489\u0000\u79ca\u0000\u7df4\u0000\u806f\u0000\u8f26\u0000\u84ee\u0000\u9023\u0000\u934a\u0000\u5217\u0000\u52a3\u0000\u54bd\u0000\u70c8\u0000\u88c2\u0000\u5ec9\u0000\u5ff5\u0000\u637b\u0000\u6bae\u0000\u7c3e\u0000\u7375\u0000\u4ee4\u0000\u56f9\u0000\u5dba\u0000\u601c\u0000\u73b2\u0000\u7469\u0000\u7f9a\u0000\u8046\u0000\u9234\u0000\u96f6\u0000\u9748\u0000\u9818\u0000\u4f8b\u0000\u79ae\u0000\u91b4\u0000\u96b8\u0000\u60e1\u0000\u4e86\u0000\u50da\u0000\u5bee\u0000\u5c3f\u0000\u6599\u0000\u71ce\u0000\u7642\u0000\u84fc\u0000\u907c\u0000\u9f8d\u0000\u6688\u0000\u962e\u0000\u5289\u0000\u677b\u0000\u67f3\u0000\u6d41\u0000\u6e9c\u0000\u7409\u0000\u7559\u0000\u786b\u0000\u7d10\u0000\u985e\u0000\u516d\u0000\u622e\u0000\u9678\u0000\u502b\u0000\u5d19\u0000\u6dea\u0000\u8f2a\u0000\u5f8b\u0000\u6144\u0000\u6817\u0000\u9686\u0000\u5229\u0000\u540f\u0000\u5c65\u0000\u6613\u0000\u674e\u0000\u68a8\u0000\u6ce5\u0000\u7406\u0000\u75e2\u0000\u7f79\u0000\u88cf\u0000\u88e1\u0000\u91cc\u0000\u96e2\u0000\u533f\u0000\u6eba\u0000\u541d\u0000\u71d0\u0000\u7498\u0000\u85fa\u0000\u96a3\u0000\u9c57\u0000\u9e9f\u0000\u6797\u0000\u6dcb\u0000\u81e8\u0000\u7acb\u0000\u7b20\u0000\u7c92\u0000\u72c0\u0000\u7099\u0000\u8b58\u0000\u4ec0\u0000\u8336\u0000\u523a\u0000\u5207\u0000\u5ea6\u0000\u62d3\u0000\u7cd6\u0000\u5b85\u0000\u6d1e\u0000\u66b4\u0000\u8f3b\u0000\u884c\u0000\u964d\u0000\u898b\u0000\u5ed3\u0000\u5140\u0000\u55c0\u0000\u585a\u0000\u6674\u0000\u51de\u0000\u732a\u0000\u76ca\u0000\u793c\u0000\u795e\u0000\u7965\u0000\u798f\u0000\u9756\u0000\u7cbe\u0000\u7fbd\u0000\u8612\u0000\u8af8\u0000\u9038\u0000\u90fd\u0000\u98ef\u0000\u98fc\u0000\u9928\u0000\u9db4\u0000\u05f2\u05b7\u0000\u05e9\u05c1\u0000\u05e9\u05c2\u0000\u05e9\u05bc\u05c1\u0000\u05e9\u05bc\u05c2\u0000\u05d0\u05b7\u0000\u05d0\u05b8\u0000\u05d0\u05bc\u0000\u05d1\u05bc\u0000\u05d2\u05bc\u0000\u05d3\u05bc\u0000\u05d4\u05bc\u0000\u05d5\u05bc\u0000\u05d6\u05bc\u0000\u05d8\u05bc\u0000\u05d9\u05bc\u0000\u05da\u05bc\u0000\u05db\u05bc\u0000\u05dc\u05bc\u0000\u05de\u05bc\u0000\u05e0\u05bc\u0000\u05e1\u05bc\u0000\u05e3\u05bc\u0000\u05e4\u05bc\u0000\u05e6\u05bc\u0000\u05e7\u05bc\u0000\u05e8\u05bc\u0000\u05e9\u05bc\u0000\u05ea\u05bc\u0000\u05d5\u05b9\u0000\u05d1\u05bf\u0000\u05db\u05bf\u0000\u05e4\u05bf\u0000\u0385\u0000\u00b4\u0000\u2002\u0000\u2003\u0000\u0172\u0303\u0301\u0000\u1e76\u0308\u0304\u0000\u01eb\u031b\u0301\u0000\u1eb9\u0304\u0300\u0000\u1e72\u0303\u0301\u0000\u1e11\u030c\u0000\u1ee4\u0303\u0301\u0000\u1ee3\u0301\u0000\u0172\u0308\u0304\u0000\u1e0d\u030c\u0000\u1e72\u0308\u0304\u0000\u1ee4\u0308\u0304\u0000\u1eee\u0301\u0000\u01af\u0308\u0304\u0000\u1e1a\u0304\u0300\u0000\u1e18\u0304\u0300\u0000\u1e0e\u030c\u0000\u1e75\u030b\u0000\u0118\u0304\u0300\u0000\u1e12\u030c\u0000\u0228\u0304\u0300\u0000\u1e75\u030c\u0000\u0173\u032d\u0000\u1e77\u030b\u0000\u01ea\u031b\u0301\u0000\u1e77\u030c\u0000\u1eb8\u0304\u0300\u0000\u1e10\u030c\u0000\u0173\u030b\u0000\u1ee2\u0301\u0000\u0173\u030c\u0000\u1e0c\u030c\u0000\u1e73\u030b\u0000\u1ee5\u030b\u0000\u1e73\u030c\u0000\u1ee5\u030c\u0000\u01b0\u032d\u0000\u01b0\u030b\u0000\u01b0\u030c\u0000\u1e74\u030b\u0000\u1e11\u032d\u0000\u1e74\u030c\u0000\u0172\u032d\u0000\u1e76\u030b\u0000\u01eb\u0323\u0302\u0000\u1e76\u030c\u0000\u00e7\u030c\u0000\u0172\u030b\u0000\u0172\u030c\u0000\u1e72\u030b\u0000\u1ee4\u030b\u0000\u1e72\u030c\u0000\u1ee4\u030c\u0000\u01af\u032d\u0000\u1ee3\u0302\u0000\u01af\u030b\u0000\u01af\u030c\u0000\u1e75\u030a\u0000\u1e10\u032d\u0000\u1e77\u030a\u0000\u0173\u0330\u0000\u01ea\u0323\u0302\u0000\u00c7\u030c\u0000\u0173\u030a\u0000\u01eb\u030c\u0000\u1e73\u030a\u0000\u1ee5\u030a\u0000\u1ecd\u030c\u0000\u01b0\u0330\u0000\u1ee2\u0302\u0000\u01b0\u030a\u0000\u01a1\u030c\u0000\u1e74\u030a\u0000\u1e76\u030a\u0000\u0172\u0330\u0000\u01eb\u0302\u0303\u0000\u00e7\u0307\u0000\u0172\u030a\u0000\u01ea\u030c\u0000\u1ed9\u0303\u0000\u1e72\u030a\u0000\u1ee4\u030a\u0000\u1ecc\u030c\u0000\u01af\u0330\u0000\u01a1\u0302\u0303\u0000\u01af\u030a\u0000\u01a0\u030c\u0000\u0dde\u0dca\u0000\u1e75\u0306\u0000\u1e2d\u030c\u0000\u1e77\u0306\u0000\u0173\u0324\u0000\u01ea\u0302\u0303\u0000\u00c7\u0307\u0000\u0173\u0306\u0000\u012f\u030c\u0000\u1ed8\u0303\u0000\u1e73\u0306\u0000\u1ee5\u0306\u0000\u1ecb\u030c\u0000\u01b0\u0324\u0000\u1ef5\u0304\u0000\u01a0\u0302\u0303\u0000\u01b0\u0306\u0000\u1e74\u0306\u0000\u1e2c\u030c\u0000\u1e11\u0331\u0000\u1e76\u0306\u0000\u0172\u0324\u0000\u01eb\u0302\u0309\u0000\u00e7\u0302\u0000\u0172\u0306\u0000\u012e\u030c\u0000\u1ed9\u0309\u0000\u1e72\u0306\u0000\u1ee4\u0306\u0000\u1eca\u030c\u0000\u01af\u0324\u0000\u1ef4\u0304\u0000\u01a1\u0302\u0309\u0000\u01af\u0306\u0000\u1e75\u0304\u0000\u1e10\u0331\u0000\u1e77\u0304\u0000\u0163\u032d\u0000\u01ea\u0302\u0309\u0000\u00c7\u0302\u0000\u0173\u0304\u0000\u0105\u030c\u0000\u1ed8\u0309\u0000\u1e73\u0304\u0000\u01eb\u0307\u0304\u0000\u1ee5\u0304\u0000\u1e01\u030c\u0000\u1ea1\u030c\u0000\u1ecd\u0307\u0304\u0000\u01a0\u0302\u0309\u0000\u01b0\u0304\u0000\u01a1\u0307\u0304\u0000\u1e74\u0304\u0000\u1e11\u0323\u0000\u1e76\u0304\u0000\u0162\u032d\u0000\u01eb\u0302\u0300\u0000\u0172\u0304\u0000\u0104\u030c\u0000\u1ed9\u0300\u0000\u1e72\u0304\u0000\u01ea\u0307\u0304\u0000\u1ee4\u0304\u0000\u1e00\u030c\u0000\u1ea0\u030c\u0000\u1ecc\u0307\u0304\u0000\u01a1\u0302\u0300\u0000\u01af\u0304\u0000\u01a0\u0307\u0304\u0000\u1e75\u0303\u0000\u1e10\u0323\u0000\u1e77\u0303\u0000\u0163\u0331\u0000\u01ea\u0302\u0300\u0000\u0173\u0303\u0000\u1ed8\u0300\u0000\u1e73\u0303\u0000\u01eb\u0307\u0000\u1ee5\u0303\u0000\u1ecd\u0307\u0000\u01a0\u0302\u0300\u0000\u038f\u0345\u0000\u1ffa\u0345\u0000\u1e0f\u0307\u0000\u01a1\u0307\u0000\u1e13\u0307\u0000\u1e74\u0303\u0000\u1e11\u0307\u0000\u1e76\u0303\u0000\u0162\u0331\u0000\u01eb\u0302\u0301\u0000\u1e0d\u0307\u0000\u0172\u0303\u0000\u1ed9\u0301\u0000\u1e72\u0303\u0000\u01ea\u0307\u0000\u1ee4\u0303\u0000\u1ecc\u0307\u0000\u01a1\u0302\u0301\u0000\u1e0e\u0307\u0000\u01a0\u0307\u0000\u1e12\u0307\u0000\u1e10\u0307\u0000\u0163\u0323\u0000\u01ea\u0302\u0301\u0000\u1e0c\u0307\u0000\u1ed8\u0301\u0000\u01eb\u0303\u0304\u0000\u1ecd\u0303\u0304\u0000\u01a0\u0302\u0301\u0000\u1ee1\u0304\u0000\u0162\u0323\u0000\u01eb\u0309\u0000\u0105\u0306\u0000\u1e01\u0306\u0000\u1ecd\u0309\u0000\u01ea\u0303\u0304\u0000\u1ecc\u0303\u0304\u0000\u1e6f\u0307\u0000\u1ee0\u0304\u0000\u1e71\u0307\u0000\u1e6f\u030c\u0000\u1e71\u030c\u0000\u0163\u0307\u0000\u021b\u0307\u0000\u01ea\u0309\u0000\u0104\u0306\u0000\u1e6d\u0307\u0000\u1e00\u0306\u0000\u0163\u030c\u0000\u021b\u030c\u0000\u1ecc\u0309\u0000\u01eb\u0308\u0304\u0000\u1e6d\u030c\u0000\u1ecd\u0308\u0304\u0000\u1e6e\u0307\u0000\u01a1\u0308\u0304\u0000\u1e70\u0307\u0000\u1e6e\u030c\u0000\u1e70\u030c\u0000\u0162\u0307\u0000\u021a\u0307\u0000\u01eb\u0323\u0000\u0105\u0304\u0000\u1e6c\u0307\u0000\u1e01\u0304\u0000\u0162\u030c\u0000\u021a\u030c\u0000\u1ea1\u0304\u0000\u01ea\u0308\u0304\u0000\u1e6c\u030c\u0000\u1ecc\u0308\u0304\u0000\u01a0\u0308\u0304\u0000\u015f\u0323\u0307\u0000\u01ea\u0323\u0000\u0104\u0304\u0000\u1e00\u0304\u0000\u1ea0\u0304\u0000\u015e\u0323\u0307\u0000\u012f\u0323\u0000\u1ef5\u0308\u0000\u015f\u030c\u0307\u0000\u0219\u030c\u0307\u0000\u012e\u0323\u0000\u1e63\u030c\u0307\u0000\u015f\u030c\u0000\u0219\u030c\u0000\u0105\u0307\u0000\u1e63\u030c\u0000\u1e01\u0307\u0000\u1ea1\u0307\u0000\u1e07\u0307\u0000\u1e2d\u0309\u0000\u015e\u030c\u0307\u0000\u0218\u030c\u0307\u0000\u012f\u0309\u0000\u1e05\u0307\u0000\u1e62\u030c\u0307\u0000\u015e\u030c\u0000\u0218\u030c\u0000\u1ecb\u0309\u0000\u1ef5\u0301\u0000\u0104\u0307\u0000\u1e62\u030c\u0000\u1e00\u0307\u0000\u1ea0\u0307\u0000\u1e06\u0307\u0000\u1e2c\u0309\u0000\u1e75\u0308\u0000\u1e77\u0308\u0000\u015f\u0301\u0307\u0000\u0219\u0301\u0307\u0000\u012e\u0309\u0000\u0173\u0308\u0000\u1e04\u0307\u0000\u1e63\u0301\u0307\u0000\u1e73\u0308\u0000\u1eca\u0309\u0000\u1ee5\u0308\u0000\u01b0\u0308\u0000\u1e75\u0302\u0000\u1e77\u0302\u0000\u0105\u0325\u0000\u015e\u0301\u0307\u0000\u0218\u0301\u0307\u0000\u0119\u0323\u0302\u0000\u0173\u0302\u0000\u0229\u0323\u0302\u0000\u1e62\u0301\u0307\u0000\u1e73\u0302\u0000\u1ee5\u0302\u0000\u01b0\u0302\u0000\u1e75\u0301\u0000\u1e77\u0301\u0000\u0104\u0325\u0000\u015f\u0323\u0000\u0118\u0323\u0302\u0000\u0173\u0301\u0000\u0228\u0323\u0302\u0000\u015f\u0302\u0000\u1e73\u0301\u0000\u0219\u0302\u0000\u1ee5\u0301\u0000\u1e63\u0302\u0000\u1e1b\u0302\u0303\u0000\u1e75\u0300\u0000\u1e19\u0302\u0303\u0000\u1e77\u0300\u0000\u015e\u0323\u0000\u0119\u0302\u0303\u0000\u0173\u0300\u0000\u0229\u0302\u0303\u0000\u015e\u0302\u0000\u1e73\u0300\u0000\u0218\u0302\u0000\u1ec7\u0303\u0000\u1ee5\u0300\u0000\u1e62\u0302\u0000\u1e1a\u0302\u0303\u0000\u1e18\u0302\u0303\u0000\u015f\u0307\u0000\u0219\u0307\u0000\u0118\u0302\u0303\u0000\u0228\u0302\u0303\u0000\u015f\u0301\u0000\u0219\u0301\u0000\u1ec6\u0303\u0000\u1e63\u0301\u0000\u1e1b\u0302\u0309\u0000\u1e19\u0302\u0309\u0000\u015e\u0307\u0000\u0218\u0307\u0000\u0119\u0302\u0309\u0000\u0229\u0302\u0309\u0000\u015e\u0301\u0000\u0218\u0301\u0000\u1ec7\u0309\u0000\u1e62\u0301\u0000\u1e1a\u0302\u0309\u0000\u1e5f\u030c\u0000\u1e18\u0302\u0309\u0000\u1e96\u030c\u0000\u0157\u0331\u0000\u0118\u0302\u0309\u0000\u01eb\u0308\u0000\u1e2b\u030c\u0000\u0228\u0302\u0309\u0000\u0157\u030c\u0000\u1ec6\u0309\u0000\u1ecd\u0308\u0000\u1e5b\u030c\u0000\u1e29\u030c\u0000\u1e25\u030c\u0000\u01a1\u0308\u0000\u1e1b\u0302\u0300\u0000\u1e5e\u030c\u0000\u1e19\u0302\u0300\u0000\u0156\u0331\u0000\u0119\u0302\u0300\u0000\u01eb\u0303\u0000\u1e2a\u030c\u0000\u0229\u0302\u0300\u0000\u0156\u030c\u0000\u1ec7\u0300\u0000\u1ecd\u0303\u0000\u1e5a\u030c\u0000\u1e28\u030c\u0000\u1e24\u030c\u0000\u1e1a\u0302\u0300\u0000\u1e18\u0302\u0300\u0000\u0157\u0323\u0304\u0000\u0118\u0302\u0300\u0000\u01eb\u0302\u0000\u0228\u0302\u0300\u0000\u1ec6\u0300\u0000\u01a1\u0302\u0000\u1e1b\u0302\u0301\u0000\u1e19\u0302\u0301\u0000\u0156\u0323\u0304\u0000\u0119\u0302\u0301\u0000\u01eb\u0301\u0000\u0229\u0302\u0301\u0000\u1ec7\u0301\u0000\u1ecd\u0301\u0000\u1e1a\u0302\u0301\u0000\u1e5f\u0301\u0000\u1e18\u0302\u0301\u0000\u0157\u0323\u0000\u0118\u0302\u0301\u0000\u01eb\u0300\u0000\u0228\u0302\u0301\u0000\u0157\u0301\u0000\u1ec6\u0301\u0000\u1ecd\u0300\u0000\u1e5b\u0301\u0000\u0163\u0326\u0000\u1e49\u0303\u0000\u1e1b\u0303\u0000\u1e5e\u0301\u0000\u1e19\u0303\u0000\u1e4b\u0303\u0000\u0156\u0323\u0000\u0119\u0303\u0000\u0229\u0303\u0000\u0146\u0303\u0000\u0156\u0301\u0000\u1eb9\u0303\u0000\u1e47\u0303\u0000\u1e5a\u0301\u0000\u0162\u0326\u0000\u1e5f\u0307\u0000\u1e1a\u0303\u0000\u1e18\u0303\u0000\u0157\u0307\u0000\u0118\u0303\u0000\u0228\u0303\u0000\u1e5b\u0307\u0000\u1eb8\u0303\u0000\u015f\u0326\u0000\u1e5e\u0307\u0000\u1e1b\u0309\u0000\u1e2d\u0308\u0000\u1e19\u0309\u0000\u0156\u0307\u0000\u0119\u0309\u0000\u012f\u0308\u0000\u0229\u0309\u0000\u1e5a\u0307\u0000\u1eb9\u0309\u0000\u1ecb\u0308\u0000\u015e\u0326\u0000\u1e1a\u0309\u0000\u1e2d\u0302\u0000\u1e18\u0309\u0000\u1e75\u0311\u0000\u0118\u0309\u0000\u012f\u0302\u0000\u0228\u0309\u0000\u1e77\u0311\u0000\u01eb\u030b\u0000\u1eb8\u0309\u0000\u1ecb\u0302\u0000\u0173\u0311\u0000\u1ecd\u030b\u0000\u1e73\u0311\u0000\u1ee5\u0311\u0000\u01a1\u030b\u0000\u01b0\u0311\u0000\u1e2d\u0301\u0000\u1e74\u0311\u0000\u0119\u0323\u0000\u012f\u0301\u0000\u0229\u0323\u0000\u1e76\u0311\u0000\u01ea\u030b\u0000\u1ecb\u0301\u0000\u0172\u0311\u0000\u1ecc\u030b\u0000\u1e72\u0311\u0000\u1ee4\u0311\u0000\u01a0\u030b\u0000\u01af\u0311\u0000\u1e2d\u0300\u0000\u1e75\u030f\u0000\u0118\u0323\u0000\u012f\u0300\u0000\u0228\u0323\u0000\u1e77\u030f\u0000\u01eb\u0306\u0000\u1ecb\u0300\u0000\u0173\u030f\u0000\u1ecd\u0306\u0000\u1e73\u030f\u0000\u1ee5\u030f\u0000\u01a1\u0306\u0000\u01b0\u030f\u0000\u1e1b\u0308\u0000\u1e19\u0308\u0000\u1e74\u030f\u0000\u0105\u0323\u0306\u0000\u0119\u0308\u0000\u0229\u0308\u0000\u1e76\u030f\u0000\u01ea\u0306\u0000\u1eb9\u0308\u0000\u0172\u030f\u0000\u1ecc\u0306\u0000\u1e72\u030f\u0000\u1ee4\u030f\u0000\u01a0\u0306\u0000\u01af\u030f\u0000\u1e1b\u0302\u0000\u1e19\u0302\u0000\u1e5f\u0311\u0000\u01ed\u0301\u0000\u0104\u0323\u0306\u0000\u0119\u0302\u0000\u0229\u0302\u0000\u1ecd\u0304\u0301\u0000\u0173\u031b\u0000\u1ecd\u0304\u0000\u0157\u0311\u0000\u01a1\u0304\u0301\u0000\u1e5b\u0311\u0000\u01a1\u0304\u0000\u1e1b\u0301\u0000\u1e19\u0301\u0000\u1e5e\u0311\u0000\u01ec\u0301\u0000\u0105\u0306\u0303\u0000\u0119\u0301\u0000\u0229\u0301\u0000\u1ecc\u0304\u0301\u0000\u1e01\u0306\u0303\u0000\u0172\u031b\u0000\u1eb7\u0303\u0000\u1eb9\u0301\u0000\u1ecc\u0304\u0000\u0156\u0311\u0000\u01a0\u0304\u0301\u0000\u1e5a\u0311\u0000\u01a0\u0304\u0000\u1e1b\u0300\u0000\u1e19\u0300\u0000\u1e5f\u030f\u0000\u01ed\u0300\u0000\u0104\u0306\u0303\u0000\u0119\u0300\u0000\u0229\u0300\u0000\u1ecd\u0304\u0300\u0000\u1e00\u0306\u0303\u0000\u1eb6\u0303\u0000\u1eb9\u0300\u0000\u0157\u030f\u0000\u01a1\u0304\u0300\u0000\u1e5b\u030f\u0000\u1e5e\u030f\u0000\u01ec\u0300\u0000\u0105\u0306\u0309\u0000\u1ecc\u0304\u0300\u0000\u1e01\u0306\u0309\u0000\u1eb7\u0309\u0000\u0156\u030f\u0000\u01a0\u0304\u0300\u0000\u1e5a\u030f\u0000\u01eb\u0303\u0308\u0000\u0104\u0306\u0309\u0000\u1ecd\u0303\u0308\u0000\u1e00\u0306\u0309\u0000\u1eb6\u0309\u0000\u01eb\u0311\u0000\u1ee1\u0308\u0000\u1ecd\u0311\u0000\u01a1\u0311\u0000\u1e49\u030c\u0000\u1e4b\u030c\u0000\u01ea\u0303\u0308\u0000\u0105\u0306\u0300\u0000\u0105\u030a\u0000\u1ecc\u0303\u0308\u0000\u1e01\u0306\u0300\u0000\u1e01\u030a\u0000\u0146\u030c\u0000\u1eb7\u0300\u0000\u1ea1\u030a\u0000\u01ea\u0311\u0000\u1e47\u030c\u0000\u1ee0\u0308\u0000\u1ecc\u0311\u0000\u01a0\u0311\u0000\u1e48\u030c\u0000\u1e4a\u030c\u0000\u01eb\u0303\u0301\u0000\u0104\u0306\u0300\u0000\u0105\u0308\u0000\u1ecd\u0303\u0301\u0000\u1e00\u0306\u0300\u0000\u1e01\u0308\u0000\u0145\u030c\u0000\u1eb6\u0300\u0000\u1ea1\u0308\u0000\u01eb\u030f\u0000\u1e46\u030c\u0000\u1ee1\u0301\u0000\u1ecd\u030f\u0000\u01a1\u030f\u0000\u01ea\u0303\u0301\u0000\u0105\u0306\u0301\u0000\u0105\u0303\u0000\u1ecc\u0303\u0301\u0000\u1e01\u0306\u0301\u0000\u1e01\u0303\u0000\u1eb7\u0301\u0000\u1ea1\u0303\u0000\u01ea\u030f\u0000\u1ee0\u0301\u0000\u1ecc\u030f\u0000\u01a0\u030f\u0000\u1e2d\u0311\u0000\u0146\u032d\u0000\u0104\u0306\u0301\u0000\u0105\u0302\u0000\u1e00\u0306\u0301\u0000\u1e01\u0302\u0000\u1eb6\u0301\u0000\u012f\u0311\u0000\u1ecb\u0311\u0000\u1e49\u0301\u0000\u1e4b\u0301\u0000\u1e2c\u0311\u0000\u0145\u032d\u0000\u0105\u0323\u0302\u0000\u0105\u0301\u0000\u1e01\u0301\u0000\u0146\u0301\u0000\u1ea1\u0301\u0000\u012e\u0311\u0000\u1e47\u0301\u0000\u1eca\u0311\u0000\u1e48\u0301\u0000\u1e4a\u0301\u0000\u1e2d\u030f\u0000\u0146\u0331\u0000\u0104\u0323\u0302\u0000\u0105\u0300\u0000\u1e01\u0300\u0000\u0145\u0301\u0000\u1ea1\u0300\u0000\u012f\u030f\u0000\u1e46\u0301\u0000\u1ecb\u030f\u0000\u1e2c\u030f\u0000\u0145\u0331\u0000\u0105\u0302\u0303\u0000\u1e01\u0302\u0303\u0000\u1ead\u0303\u0000\u012e\u030f\u0000\u1eca\u030f\u0000\u1e1b\u0311\u0000\u0146\u0323\u0000\u0104\u0302\u0303\u0000\u1e19\u0311\u0000\u1e00\u0302\u0303\u0000\u1eac\u0303\u0000\u0119\u0311\u0000\u0229\u0311\u0000\u1eb9\u0311\u0000\u0145\u0323\u0000\u1e1a\u0311\u0000\u0105\u0302\u0309\u0000\u1e18\u0311\u0000\u1e01\u0302\u0309\u0000\u1ead\u0309\u0000\u1ef4\u0301\u0000\u0118\u0311\u0000\u0228\u0311\u0000\u1eb8\u0311\u0000\u1e49\u0307\u0000\u1e4b\u0307\u0000\u1e74\u0308\u0000\u1e76\u0308\u0000\u0146\u0307\u0000\u1e1b\u030f\u0000\u0104\u0302\u0309\u0000\u0172\u0308\u0000\u1e19\u030f\u0000\u1e47\u0307\u0000\u1e00\u0302\u0309\u0000\u1eac\u0309\u0000\u1e72\u0308\u0000\u1ee4\u0308\u0000\u0119\u030f\u0000\u0229\u030f\u0000\u1eb9\u030f\u0000\u01af\u0308\u0000\u1e48\u0307\u0000\u1e4a\u0307\u0000\u1e74\u0302\u0000\u1e3b\u030c\u0000\u1e76\u0302\u0000\u1e3d\u030c\u0000\u0145\u0307\u0000\u1e1a\u030f\u0000\u0105\u0302\u0300\u0000\u0172\u0302\u0000\u1e18\u030f\u0000\u1e46\u0307\u0000\u1e01\u0302\u0300\u0000\u013c\u030c\u0000\u1e72\u0302\u0000\u01eb\u031b\u0000\u1ead\u0300\u0000\u1ee4\u0302\u0000\u0118\u030f\u0000\u1e37\u030c\u0000\u0228\u030f\u0000\u1eb8\u030f\u0000\u01af\u0302\u0000\u1e74\u0301\u0000\u1e3a\u030c\u0000\u1e76\u0301\u0000\u1e3c\u030c\u0000\u0104\u0302\u0300\u0000\u0172\u0301\u0000\u1e00\u0302\u0300\u0000\u013b\u030c\u0000\u1e72\u0301\u0000\u01ea\u031b\u0000\u1eac\u0300\u0000\u1ee4\u0301\u0000\u0105\u0311\u0000\u1e36\u030c\u0000\u1e01\u0311\u0000\u1ea1\u0311\u0000\u1e74\u0300\u0000\u1e76\u0300\u0000\u0105\u0302\u0301\u0000\u0172\u0300\u0000\u1e01\u0302\u0301\u0000\u1e72\u0300\u0000\u1ead\u0301\u0000\u1ee4\u0300\u0000\u0104\u0311\u0000\u1e00\u0311\u0000\u1ea0\u0311\u0000\u0104\u0302\u0301\u0000\u1e43\u0307\u0000\u1e00\u0302\u0301\u0000\u1eac\u0301\u0000\u0105\u030f\u0000\u1e01\u030f\u0000\u1ea1\u030f\u0000\u1e3b\u0301\u0000\u1e3d\u0301\u0000\u0105\u0309\u0000\u1e42\u0307\u0000\u1e01\u0309\u0000\u013c\u0301\u0000\u1ea1\u0309\u0000\u0104\u030f\u0000\u1e37\u0301\u0000\u1e00\u030f\u0000\u1ea0\u030f\u0000\u1e3a\u0301\u0000\u1e3c\u0301\u0000\u0104\u0309\u0000\u01ea\u0308\u0000\u1e43\u0301\u0000\u1e00\u0309\u0000\u013b\u0301\u0000\u1ea0\u0309\u0000\u1ecc\u0308\u0000\u1e36\u0301\u0000\u01a0\u0308\u0000\u0389\u0345\u0000\u1fca\u0345\u0000\u0105\u0323\u0000\u01ea\u0303\u0000\u1e42\u0301\u0000\u1ecc\u0303\u0000\u013c\u032d\u0000\u0104\u0323\u0000\u01ea\u0302\u0000\u01a0\u0302\u0000\u013b\u032d\u0000\u01ea\u0301\u0000\u1ecc\u0301\u0000\u0625\u0654\u0000\u013c\u0331\u0000\u01ea\u0300\u0000\u1ecc\u0300\u0000\u0105\u030a\u0301\u0000\u1e01\u030a\u0301\u0000\u1ea1\u030a\u0301\u0000\u0625\u0653\u0000\u1e48\u0303\u0000\u1e4a\u0303\u0000\u013b\u0331\u0000\u0145\u0303\u0000\u1e46\u0303\u0000\u0104\u030a\u0301\u0000\u1e00\u030a\u0301\u0000\u1ea0\u030a\u0301\u0000\u1e49\u0300\u0000\u013c\u0323\u0304\u0000\u1e4b\u0300\u0000\u0146\u0300\u0000\u1e47\u0300\u0000\u1e2c\u0308\u0000\u1e48\u0300\u0000\u013b\u0323\u0304\u0000\u012e\u0308\u0000\u1e4a\u0300\u0000\u1eca\u0308\u0000\u0145\u0300\u0000\u1e46\u0300\u0000\u1e2c\u0302\u0000\u013c\u0323\u0000\u012e\u0302\u0000\u1eca\u0302\u0000\u1e2c\u0301\u0000\u1e2c\u0307\u0000\u013b\u0323\u0000\u012e\u0301\u0000\u012e\u0307\u0000\u1ef5\u030a\u0000\u1eca\u0301\u0000\u1eca\u0307\u0000\u1e2c\u0300\u0000\u0137\u0331\u0000\u012e\u0300\u0000\u1e89\u030a\u0000\u1eca\u0300\u0000\u0123\u0301\u0000\u1e6f\u0308\u0000\u1e1a\u0308\u0000\u1e71\u0308\u0000\u1e18\u0308\u0000\u0136\u0331\u0000\u0118\u0308\u0000\u0163\u0308\u0000\u0228\u0308\u0000\u021b\u0308\u0000\u1e6d\u0308\u0000\u1eb8\u0308\u0000\u0122\u0301\u0000\u1e1a\u0302\u0000\u1e2d\u0306\u0000\u1e18\u0302\u0000\u0137\u0323\u0000\u0118\u0302\u0000\u1e29\u0331\u0000\u0228\u0302\u0000\u012f\u0306\u0000\u1ef5\u0303\u0000\u1ecb\u0306\u0000\u1e1a\u0301\u0000\u1e2c\u0306\u0000\u1e18\u0301\u0000\u0136\u0323\u0000\u0118\u0301\u0000\u0228\u0301\u0000\u012e\u0306\u0000\u1eb8\u0301\u0000\u1ef4\u0303\u0000\u1eca\u0306\u0000\u1e35\u0301\u0000\u1e1a\u0300\u0000\u1e2d\u0304\u0000\u1e18\u0300\u0000\u0137\u0301\u0000\u0118\u0300\u0000\u0228\u0300\u0000\u012f\u0304\u0000\u1e33\u0301\u0000\u1eb8\u0300\u0000\u1ef5\u0309\u0000\u1ecb\u0304\u0000\u1e34\u0301\u0000\u1e2c\u0304\u0000\u0136\u0301\u0000\u012e\u0304\u0000\u1e32\u0301\u0000\u1ef4\u0309\u0000\u1eca\u0304\u0000\u1e2d\u0308\u0301\u0000\u1e2d\u0303\u0000\u012f\u0308\u0301\u0000\u012f\u0303\u0000\u1ecb\u0308\u0301\u0000\u1ecb\u0303\u0000\u1fb8\u0345\u0000\u1fb9\u0345\u0000\u0386\u0345\u0000\u1fba\u0345\u0000\u1e2c\u0308\u0301\u0000\u1e95\u0302\u0000\u1e2c\u0303\u0000\u012e\u0308\u0301\u0000\u0104\u030a\u0000\u012e\u0303\u0000\u1eca\u0308\u0301\u0000\u1e00\u030a\u0000\u1e93\u0302\u0000\u1ea0\u030a\u0000\u1eca\u0303\u0000\u1e94\u0302\u0000\u012f\u0330\u0000\u0104\u0308\u0000\u1e00\u0308\u0000\u1e92\u0302\u0000\u1ea0\u0308\u0000\u1ef5\u0300\u0000\u012e\u0330\u0000\u0104\u0303\u0000\u1e00\u0303\u0000\u1ef5\u0307\u0000\u1ea0\u0303\u0000\u1ef4\u0300\u0000\u1e96\u0302\u0000\u1e2b\u0302\u0000\u1e29\u032e\u0000\u0104\u0302\u0000\u0173\u031b\u0323\u0000\u1e00\u0302\u0000\u1e29\u0302\u0000\u1ef4\u0307\u0000\u1e25\u0302\u0000\u1e2a\u0302\u0000\u1e28\u032e\u0000\u0104\u0301\u0000\u0172\u031b\u0323\u0000\u1e00\u0301\u0000\u1e28\u0302\u0000\u1ea0\u0301\u0000\u1e24\u0302\u0000\u1e35\u030c\u0000\u0104\u0300\u0000\u0173\u031b\u0303\u0000\u1e00\u0300\u0000\u1ea0\u0300\u0000\u1ef1\u0303\u0000\u0137\u030c\u0000\u1e33\u030c\u0000\u1e34\u030c\u0000\u0172\u031b\u0303\u0000\u1ef0\u0303\u0000\u0136\u030c\u0000\u1e32\u030c\u0000\u1e96\u0308\u0000\u1e2b\u0308\u0000\u1e29\u0308\u0000\u0173\u031b\u0309\u0000\u1e25\u0308\u0000\u0123\u0307\u0000\u1ef1\u0309\u0000\u0123\u030c\u0000\u1e2a\u0308\u0000\u1e28\u0308\u0000\u0172\u031b\u0309\u0000\u1e24\u0308\u0000\u0122\u0307\u0000\u1ef0\u0309\u0000\u0122\u030c\u0000\u1fb0\u0345\u0000\u1fb1\u0345\u0000\u1e29\u0323\u0000\u0173\u031b\u0300\u0000\u0123\u0306\u0000\u1ef1\u0300\u0000\u1e28\u0323\u0000\u0172\u031b\u0300\u0000\u0122\u0306\u0000\u1e89\u0307\u0000\u1ef0\u0300\u0000\u1e96\u0307\u0000\u1e2b\u0307\u0000\u1e29\u0307\u0000\u0173\u031b\u0301\u0000\u1e25\u0307\u0000\u0123\u0302\u0000\u1e88\u0307\u0000\u1ef1\u0301\u0000\u1e2a\u0307\u0000\u1e28\u0307\u0000\u0172\u031b\u0301\u0000\u1e24\u0307\u0000\u0122\u0302\u0000\u1e89\u0308\u0000\u1ef0\u0301\u0000\u1e75\u0309\u0000\u1e1b\u030c\u0000\u1e95\u030c\u0000\u1e77\u0309\u0000\u1e19\u030c\u0000\u0123\u0304\u0000\u0173\u0309\u0000\u0119\u030c\u0000\u0229\u030c\u0000\u1e88\u0308\u0000\u1e73\u0309\u0000\u0105\u0307\u0304\u0000\u1ee5\u0309\u0000\u1eb9\u030c\u0000\u1e93\u030c\u0000\u1e01\u0307\u0304\u0000\u1ea1\u0307\u0304\u0000\u1e74\u0309\u0000\u1e1a\u030c\u0000\u1e94\u030c\u0000\u1e76\u0309\u0000\u1e18\u030c\u0000\u0122\u0304\u0000\u0172\u0309\u0000\u0118\u030c\u0000\u0228\u030c\u0000\u1e89\u0301\u0000\u1e72\u0309\u0000\u0104\u0307\u0304\u0000\u1ee4\u0309\u0000\u1eb8\u030c\u0000\u1e92\u030c\u0000\u1e00\u0307\u0304\u0000\u1ea0\u0307\u0304\u0000\u1e95\u0307\u0000\u0173\u0323\u0000\u1e88\u0301\u0000\u0105\u0308\u0304\u0000\u1e93\u0307\u0000\u1e01\u0308\u0304\u0000\u1ea1\u0308\u0304\u0000\u1e94\u0307\u0000\u0172\u0323\u0000\u1e89\u0300\u0000\u0104\u0308\u0304\u0000\u1e92\u0307\u0000\u1e00\u0308\u0304\u0000\u1ea0\u0308\u0304\u0000\u1e1b\u0307\u0000\u1e95\u0301\u0000\u1e19\u0307\u0000\u01eb\u031b\u0323\u0000\u0119\u0307\u0000\u0229\u0307\u0000\u1e88\u0300\u0000\u1eb9\u0307\u0000\u1e93\u0301\u0000\u1e1a\u0307\u0000\u1e94\u0301\u0000\u1e18\u0307\u0000\u1e75\u0308\u0300\u0000\u1e77\u0308\u0300\u0000\u01ea\u031b\u0323\u0000\u0118\u0307\u0000\u0228\u0307\u0000\u0173\u0308\u0300\u0000\u1eb8\u0307\u0000\u1e92\u0301\u0000\u1e73\u0308\u0300\u0000\u1ee5\u0308\u0300\u0000\u01b0\u0308\u0300\u0000\u1e1b\u0306\u0000\u1e19\u0306\u0000\u0119\u0330\u0000\u1e74\u0308\u0300\u0000\u0229\u0330\u0000\u1e76\u0308\u0300\u0000\u01eb\u031b\u0303\u0000\u0119\u0306\u0000\u0172\u0308\u0300\u0000\u1ee3\u0303\u0000\u1eb9\u0306\u0000\u1ef4\u0308\u0000\u1e72\u0308\u0300\u0000\u1ee4\u0308\u0300\u0000\u01af\u0308\u0300\u0000\u1e1a\u0306\u0000\u1e18\u0306\u0000\u0118\u0330\u0000\u1e75\u0308\u030c\u0000\u0228\u0330\u0000\u1e77\u0308\u030c\u0000\u01ea\u031b\u0303\u0000\u0118\u0306\u0000\u1e7f\u0303\u0000\u0173\u0308\u030c\u0000\u1ee2\u0303\u0000\u1eb8\u0306\u0000\u1ef5\u0302\u0000\u1e73\u0308\u030c\u0000\u1ee5\u0308\u030c\u0000\u01b0\u0308\u030c\u0000\u1e1b\u0304\u0000\u1e19\u0304\u0000\u0119\u032d\u0000\u1e74\u0308\u030c\u0000\u0229\u032d\u0000\u1e76\u0308\u030c\u0000\u01eb\u031b\u0309\u0000\u0119\u0304\u0000\u0229\u0304\u0000\u1e7e\u0303\u0000\u0172\u0308\u030c\u0000\u1ee3\u0309\u0000\u1eb9\u0304\u0000\u1ef4\u0302\u0000\u1e72\u0308\u030c\u0000\u1ee4\u0308\u030c\u0000\u01af\u0308\u030c\u0000\u1e75\u0304\u0308\u0000\u1e1a\u0304\u0000\u1e77\u0304\u0308\u0000\u1e18\u0304\u0000\u0118\u032d\u0000\u1e75\u0308\u0301\u0000\u0228\u032d\u0000\u0173\u0304\u0308\u0000\u1e77\u0308\u0301\u0000\u01ea\u031b\u0309\u0000\u0118\u0304\u0000\u0228\u0304\u0000\u1e73\u0304\u0308\u0000\u1ee5\u0304\u0308\u0000\u0173\u0308\u0301\u0000\u1ee2\u0309\u0000\u1eb8\u0304\u0000\u1e89\u0302\u0000\u1e73\u0308\u0301\u0000\u1ee5\u0308\u0301\u0000\u01b0\u0304\u0308\u0000\u01b0\u0308\u0301\u0000\u1e1b\u0304\u0301\u0000\u1e74\u0304\u0308\u0000\u1e19\u0304\u0301\u0000\u1e76\u0304\u0308\u0000\u0119\u0304\u0301\u0000\u1e74\u0308\u0301\u0000\u0229\u0304\u0301\u0000\u0172\u0304\u0308\u0000\u1e76\u0308\u0301\u0000\u01eb\u031b\u0300\u0000\u1eb9\u0304\u0301\u0000\u1e72\u0304\u0308\u0000\u1ee4\u0304\u0308\u0000\u0172\u0308\u0301\u0000\u1ee3\u0300\u0000\u1e88\u0302\u0000\u1e72\u0308\u0301\u0000\u1ee4\u0308\u0301\u0000\u01af\u0304\u0308\u0000\u01af\u0308\u0301\u0000\u1e1a\u0304\u0301\u0000\u1e75\u0303\u0301\u0000\u1e18\u0304\u0301\u0000\u1e77\u0303\u0301\u0000\u0118\u0304\u0301\u0000\u1e75\u0308\u0304\u0000\u0228\u0304\u0301\u0000\u0173\u0303\u0301\u0000\u1e77\u0308\u0304\u0000\u01ea\u031b\u0300\u0000\u1eb8\u0304\u0301\u0000\u1e73\u0303\u0301\u0000\u1ee5\u0303\u0301\u0000\u0173\u0308\u0304\u0000\u1ee2\u0300\u0000\u1e73\u0308\u0304\u0000\u1ee5\u0308\u0304\u0000\u1eef\u0301\u0000\u01b0\u0308\u0304\u0000\u1e1b\u0304\u0300\u0000\u1e74\u0303\u0301\u0000\u1e19\u0304\u0300\u0000\u1e0f\u030c\u0000\u1e76\u0303\u0301\u0000\u1e13\u030c\u0000\u0119\u0304\u0300\u0000\u1e74\u0308\u0304\u0000\u0229\u0304\u0300\u0000".charAt(n++)) != '\u0000') {
            stringBuffer.append(c);
        }
    }

    static final char pairExplode(StringBuffer stringBuffer, int n) {
        char c = ComposeData.actionIndex[n - 64285];
        Normalizer.explode(stringBuffer, c + '\u0001');
        return "  \u0308\u0000s\u0000\u03a5\u0000 \u0313\u0000 \u0314\u0000 \u0000a\u0000 \u0304\u00002\u00003\u0000 \u0301\u0000\u03bc\u0000 \u0327\u00001\u0000o\u00001\u20444\u00001\u20442\u00003\u20444\u0000IJ\u0000ij\u0000L\u00b7\u0000l\u00b7\u0000\u02bcn\u0000DZ\u030c\u0000Dz\u030c\u0000dz\u030c\u0000LJ\u0000Lj\u0000lj\u0000NJ\u0000Nj\u0000nj\u0000DZ\u0000Dz\u0000dz\u0000h\u0000\u0266\u0000r\u0000\u0279\u0000\u027b\u0000\u0281\u0000w\u0000y\u0000 \u0306\u0000 \u0307\u0000 \u030a\u0000 \u0328\u0000 \u0303\u0000 \u030b\u0000\u0263\u0000l\u0000x\u0000\u0295\u0000 \u0345\u0000 \u0308\u0301\u0000\u03b2\u0000\u03b8\u0000\u03a5\u0301\u0000\u03a5\u0308\u0000\u03c6\u0000\u03c0\u0000\u03ba\u0000\u03c1\u0000\u03c2\u0000\u0565\u0582\u0000\u0627\u0674\u0000\u0648\u0674\u0000\u06c7\u0674\u0000\u064a\u0674\u0000\u0e4d\u0e32\u0000\u0ecd\u0eb2\u0000\u0eab\u0e99\u0000\u0eab\u0ea1\u0000\u0f0b\u0000\u0fb2\u0f71\u0f80\u0000\u0fb3\u0f71\u0f80\u0000a\u02be\u0000s\u0307\u0000 \u0342\u0000 \u0308\u0342\u0000 \u0313\u0300\u0000 \u0313\u0301\u0000 \u0313\u0342\u0000 \u0314\u0300\u0000 \u0314\u0301\u0000 \u0314\u0342\u0000 \u0308\u0300\u0000\u2010\u0000 \u0333\u0000.\u0000..\u0000...\u0000\u2032\u2032\u0000\u2032\u2032\u2032\u0000\u2035\u2035\u0000\u2035\u2035\u2035\u0000!!\u0000 \u0305\u0000?!\u0000!?\u00000\u00005\u00006\u00007\u00008\u00009\u0000+\u0000\u2212\u0000=\u0000(\u0000)\u0000Rs\u0000a/c\u0000a/s\u0000C\u0000\u00b0C\u0000c/o\u0000c/u\u0000\u0190\u0000\u00b0F\u0000g\u0000H\u0000\u0127\u0000I\u0000L\u0000N\u0000No\u0000P\u0000Q\u0000R\u0000SM\u0000TEL\u0000TM\u0000B\u0000e\u0000E\u0000\u05d0\u0000\u05d1\u0000\u05d2\u0000\u05d3\u0000i\u00001\u20443\u00002\u20443\u00001\u20445\u00002\u20445\u00003\u20445\u00004\u20445\u00001\u20446\u00005\u20446\u00001\u20448\u00003\u20448\u00005\u20448\u00007\u20448\u00001\u2044\u0000II\u0000III\u0000IV\u0000VI\u0000VII\u0000VIII\u0000IX\u0000XI\u0000XII\u0000D\u0000ii\u0000iii\u0000iv\u0000vi\u0000vii\u0000viii\u0000ix\u0000xi\u0000xii\u0000d\u0000m\u0000\u222b\u222b\u0000\u222b\u222b\u222b\u0000\u222e\u222e\u0000\u222e\u222e\u222e\u000010\u000011\u000012\u000013\u000014\u000015\u000016\u000017\u000018\u000019\u000020\u0000(1)\u0000(2)\u0000(3)\u0000(4)\u0000(5)\u0000(6)\u0000(7)\u0000(8)\u0000(9)\u0000(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.\u00002.\u00003.\u00004.\u00005.\u00006.\u00007.\u00008.\u00009.\u000010.\u000011.\u000012.\u000013.\u000014.\u000015.\u000016.\u000017.\u000018.\u000019.\u000020.\u0000(a)\u0000(b)\u0000(c)\u0000(d)\u0000(e)\u0000(f)\u0000(g)\u0000(h)\u0000(i)\u0000(j)\u0000(k)\u0000(l)\u0000(m)\u0000(n)\u0000(o)\u0000(p)\u0000(q)\u0000(r)\u0000(s)\u0000(t)\u0000(u)\u0000(v)\u0000(w)\u0000(x)\u0000(y)\u0000(z)\u0000A\u0000G\u0000K\u0000O\u0000S\u0000T\u0000U\u0000W\u0000Y\u0000b\u0000f\u0000k\u0000p\u0000q\u0000t\u0000\u6bcd\u0000\u9f9f\u0000\u4e00\u0000\u4e28\u0000\u4e36\u0000\u4e3f\u0000\u4e59\u0000\u4e85\u0000\u4e8c\u0000\u4ea0\u0000\u4eba\u0000\u513f\u0000\u5165\u0000\u516b\u0000\u5182\u0000\u5196\u0000\u51ab\u0000\u51e0\u0000\u51f5\u0000\u5200\u0000\u529b\u0000\u52f9\u0000\u5315\u0000\u531a\u0000\u5338\u0000\u5341\u0000\u535c\u0000\u5369\u0000\u5382\u0000\u53b6\u0000\u53c8\u0000\u53e3\u0000\u56d7\u0000\u571f\u0000\u58eb\u0000\u5902\u0000\u590a\u0000\u5915\u0000\u5927\u0000\u5973\u0000\u5b50\u0000\u5b80\u0000\u5bf8\u0000\u5c0f\u0000\u5c22\u0000\u5c38\u0000\u5c6e\u0000\u5c71\u0000\u5ddb\u0000\u5de5\u0000\u5df1\u0000\u5dfe\u0000\u5e72\u0000\u5e7a\u0000\u5e7f\u0000\u5ef4\u0000\u5efe\u0000\u5f0b\u0000\u5f13\u0000\u5f50\u0000\u5f61\u0000\u5f73\u0000\u5fc3\u0000\u6208\u0000\u6236\u0000\u624b\u0000\u652f\u0000\u6534\u0000\u6587\u0000\u6597\u0000\u65a4\u0000\u65b9\u0000\u65e0\u0000\u65e5\u0000\u66f0\u0000\u6708\u0000\u6728\u0000\u6b20\u0000\u6b62\u0000\u6b79\u0000\u6bb3\u0000\u6bcb\u0000\u6bd4\u0000\u6bdb\u0000\u6c0f\u0000\u6c14\u0000\u6c34\u0000\u706b\u0000\u722a\u0000\u7236\u0000\u723b\u0000\u723f\u0000\u7247\u0000\u7259\u0000\u725b\u0000\u72ac\u0000\u7384\u0000\u7389\u0000\u74dc\u0000\u74e6\u0000\u7518\u0000\u751f\u0000\u7528\u0000\u7530\u0000\u758b\u0000\u7592\u0000\u7676\u0000\u767d\u0000\u76ae\u0000\u76bf\u0000\u76ee\u0000\u77db\u0000\u77e2\u0000\u77f3\u0000\u793a\u0000\u79b8\u0000\u79be\u0000\u7a74\u0000\u7acb\u0000\u7af9\u0000\u7c73\u0000\u7cf8\u0000\u7f36\u0000\u7f51\u0000\u7f8a\u0000\u7fbd\u0000\u8001\u0000\u800c\u0000\u8012\u0000\u8033\u0000\u807f\u0000\u8089\u0000\u81e3\u0000\u81ea\u0000\u81f3\u0000\u81fc\u0000\u820c\u0000\u821b\u0000\u821f\u0000\u826e\u0000\u8272\u0000\u8278\u0000\u864d\u0000\u866b\u0000\u8840\u0000\u884c\u0000\u8863\u0000\u897e\u0000\u898b\u0000\u89d2\u0000\u8a00\u0000\u8c37\u0000\u8c46\u0000\u8c55\u0000\u8c78\u0000\u8c9d\u0000\u8d64\u0000\u8d70\u0000\u8db3\u0000\u8eab\u0000\u8eca\u0000\u8f9b\u0000\u8fb0\u0000\u8fb5\u0000\u9091\u0000\u9149\u0000\u91c6\u0000\u91cc\u0000\u91d1\u0000\u9577\u0000\u9580\u0000\u961c\u0000\u96b6\u0000\u96b9\u0000\u96e8\u0000\u9751\u0000\u975e\u0000\u9762\u0000\u9769\u0000\u97cb\u0000\u97ed\u0000\u97f3\u0000\u9801\u0000\u98a8\u0000\u98db\u0000\u98df\u0000\u9996\u0000\u9999\u0000\u99ac\u0000\u9aa8\u0000\u9ad8\u0000\u9adf\u0000\u9b25\u0000\u9b2f\u0000\u9b32\u0000\u9b3c\u0000\u9b5a\u0000\u9ce5\u0000\u9e75\u0000\u9e7f\u0000\u9ea5\u0000\u9ebb\u0000\u9ec3\u0000\u9ecd\u0000\u9ed1\u0000\u9ef9\u0000\u9efd\u0000\u9f0e\u0000\u9f13\u0000\u9f20\u0000\u9f3b\u0000\u9f4a\u0000\u9f52\u0000\u9f8d\u0000\u9f9c\u0000\u9fa0\u0000\u3012\u0000\u5344\u0000\u5345\u0000 \u3099\u0000 \u309a\u0000\u1100\u0000\u1101\u0000\u11aa\u0000\u1102\u0000\u11ac\u0000\u11ad\u0000\u1103\u0000\u1104\u0000\u1105\u0000\u11b0\u0000\u11b1\u0000\u11b2\u0000\u11b3\u0000\u11b4\u0000\u11b5\u0000\u111a\u0000\u1106\u0000\u1107\u0000\u1108\u0000\u1121\u0000\u1109\u0000\u110a\u0000\u110b\u0000\u110c\u0000\u110d\u0000\u110e\u0000\u110f\u0000\u1110\u0000\u1111\u0000\u1112\u0000\u1161\u0000\u1162\u0000\u1163\u0000\u1164\u0000\u1165\u0000\u1166\u0000\u1167\u0000\u1168\u0000\u1169\u0000\u116a\u0000\u116b\u0000\u116c\u0000\u116d\u0000\u116e\u0000\u116f\u0000\u1170\u0000\u1171\u0000\u1172\u0000\u1173\u0000\u1174\u0000\u1175\u0000\u1160\u0000\u1114\u0000\u1115\u0000\u11c7\u0000\u11c8\u0000\u11cc\u0000\u11ce\u0000\u11d3\u0000\u11d7\u0000\u11d9\u0000\u111c\u0000\u11dd\u0000\u11df\u0000\u111d\u0000\u111e\u0000\u1120\u0000\u1122\u0000\u1123\u0000\u1127\u0000\u1129\u0000\u112b\u0000\u112c\u0000\u112d\u0000\u112e\u0000\u112f\u0000\u1132\u0000\u1136\u0000\u1140\u0000\u1147\u0000\u114c\u0000\u11f1\u0000\u11f2\u0000\u1157\u0000\u1158\u0000\u1159\u0000\u1184\u0000\u1185\u0000\u1188\u0000\u1191\u0000\u1192\u0000\u1194\u0000\u119e\u0000\u11a1\u0000\u4e09\u0000\u56db\u0000\u4e0a\u0000\u4e2d\u0000\u4e0b\u0000\u7532\u0000\u4e19\u0000\u4e01\u0000\u5929\u0000\u5730\u0000(\u1100)\u0000(\u1102)\u0000(\u1103)\u0000(\u1105)\u0000(\u1106)\u0000(\u1107)\u0000(\u1109)\u0000(\u110b)\u0000(\u110c)\u0000(\u110e)\u0000(\u110f)\u0000(\u1110)\u0000(\u1111)\u0000(\u1112)\u0000(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)\u0000(\u4e8c)\u0000(\u4e09)\u0000(\u56db)\u0000(\u4e94)\u0000(\u516d)\u0000(\u4e03)\u0000(\u516b)\u0000(\u4e5d)\u0000(\u5341)\u0000(\u6708)\u0000(\u706b)\u0000(\u6c34)\u0000(\u6728)\u0000(\u91d1)\u0000(\u571f)\u0000(\u65e5)\u0000(\u682a)\u0000(\u6709)\u0000(\u793e)\u0000(\u540d)\u0000(\u7279)\u0000(\u8ca1)\u0000(\u795d)\u0000(\u52b4)\u0000(\u4ee3)\u0000(\u547c)\u0000(\u5b66)\u0000(\u76e3)\u0000(\u4f01)\u0000(\u8cc7)\u0000(\u5354)\u0000(\u796d)\u0000(\u4f11)\u0000(\u81ea)\u0000(\u81f3)\u0000\u1100\u1161\u0000\u1102\u1161\u0000\u1103\u1161\u0000\u1105\u1161\u0000\u1106\u1161\u0000\u1107\u1161\u0000\u1109\u1161\u0000\u110b\u1161\u0000\u110c\u1161\u0000\u110e\u1161\u0000\u110f\u1161\u0000\u1110\u1161\u0000\u1111\u1161\u0000\u1112\u1161\u0000\u4e94\u0000\u516d\u0000\u4e03\u0000\u4e5d\u0000\u682a\u0000\u6709\u0000\u793e\u0000\u540d\u0000\u7279\u0000\u8ca1\u0000\u795d\u0000\u52b4\u0000\u79d8\u0000\u7537\u0000\u9069\u0000\u512a\u0000\u5370\u0000\u6ce8\u0000\u9805\u0000\u4f11\u0000\u5199\u0000\u6b63\u0000\u5de6\u0000\u53f3\u0000\u533b\u0000\u5b97\u0000\u5b66\u0000\u76e3\u0000\u4f01\u0000\u8cc7\u0000\u5354\u0000\u591c\u00001\u6708\u00002\u6708\u00003\u6708\u00004\u6708\u00005\u6708\u00006\u6708\u00007\u6708\u00008\u6708\u00009\u6708\u000010\u6708\u000011\u6708\u000012\u6708\u0000\u30a2\u0000\u30a4\u0000\u30a6\u0000\u30a8\u0000\u30aa\u0000\u30ab\u0000\u30ad\u0000\u30af\u0000\u30b1\u0000\u30b3\u0000\u30b5\u0000\u30b7\u0000\u30b9\u0000\u30bb\u0000\u30bd\u0000\u30bf\u0000\u30c1\u0000\u30c4\u0000\u30c6\u0000\u30c8\u0000\u30ca\u0000\u30cb\u0000\u30cc\u0000\u30cd\u0000\u30ce\u0000\u30cf\u0000\u30d2\u0000\u30d5\u0000\u30d8\u0000\u30db\u0000\u30de\u0000\u30df\u0000\u30e0\u0000\u30e1\u0000\u30e2\u0000\u30e4\u0000\u30e6\u0000\u30e8\u0000\u30e9\u0000\u30ea\u0000\u30eb\u0000\u30ec\u0000\u30ed\u0000\u30ef\u0000\u30f0\u0000\u30f1\u0000\u30f2\u0000\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u0000\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u0000\u30a6\u30a9\u30f3\u0000\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u0000\u30aa\u30fc\u30e0\u0000\u30ab\u30a4\u30ea\u0000\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u0000\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u0000\u30b3\u30eb\u30ca\u0000\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u0000\u30bb\u30f3\u30c8\u0000\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u0000\u30c8\u3099\u30eb\u0000\u30ca\u30ce\u0000\u30ce\u30c3\u30c8\u0000\u30cf\u30a4\u30c4\u0000\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u0000\u30d2\u3099\u30eb\u0000\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u0000\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u0000\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u0000\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u0000\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u0000\u30db\u30fc\u30f3\u0000\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u0000\u30de\u30c3\u30cf\u0000\u30de\u30eb\u30af\u0000\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u0000\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u0000\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u0000\u30e6\u30a2\u30f3\u0000\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u0000\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u0000\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b9\u00001\u70b9\u00002\u70b9\u00003\u70b9\u00004\u70b9\u00005\u70b9\u00006\u70b9\u00007\u70b9\u00008\u70b9\u00009\u70b9\u000010\u70b9\u000011\u70b9\u000012\u70b9\u000013\u70b9\u000014\u70b9\u000015\u70b9\u000016\u70b9\u000017\u70b9\u000018\u70b9\u000019\u70b9\u000020\u70b9\u000021\u70b9\u000022\u70b9\u000023\u70b9\u000024\u70b9\u0000hPa\u0000da\u0000AU\u0000bar\u0000oV\u0000pc\u0000\u5e73\u6210\u0000\u662d\u548c\u0000\u5927\u6b63\u0000\u660e\u6cbb\u0000\u682a\u5f0f\u4f1a\u793e\u0000pA\u0000nA\u0000\u03bcA\u0000mA\u0000kA\u0000KB\u0000MB\u0000GB\u0000cal\u0000kcal\u0000pF\u0000nF\u0000\u03bcF\u0000\u03bcg\u0000mg\u0000kg\u0000Hz\u0000kHz\u0000MHz\u0000GHz\u0000THz\u0000\u03bcl\u0000ml\u0000dl\u0000kl\u0000fm\u0000nm\u0000\u03bcm\u0000mm\u0000cm\u0000km\u0000mm2\u0000cm2\u0000km2\u0000mm3\u0000cm3\u0000km3\u0000m\u2215s\u0000m\u2215s2\u0000kPa\u0000MPa\u0000GPa\u0000rad\u0000rad\u2215s\u0000rad\u2215s2\u0000ps\u0000ns\u0000\u03bcs\u0000ms\u0000pV\u0000nV\u0000\u03bcV\u0000mV\u0000kV\u0000MV\u0000pW\u0000nW\u0000\u03bcW\u0000mW\u0000kW\u0000MW\u0000k\u03a9\u0000M\u03a9\u0000a.m.\u0000Bq\u0000cc\u0000cd\u0000C\u2215kg\u0000Co.\u0000dB\u0000Gy\u0000ha\u0000HP\u0000in\u0000KK\u0000KM\u0000kt\u0000lm\u0000ln\u0000log\u0000lx\u0000mb\u0000mil\u0000mol\u0000PH\u0000p.m.\u0000PPM\u0000PR\u0000sr\u0000Sv\u0000Wb\u00001\u65e5\u00002\u65e5\u00003\u65e5\u00004\u65e5\u00005\u65e5\u00006\u65e5\u00007\u65e5\u00008\u65e5\u00009\u65e5\u000010\u65e5\u000011\u65e5\u000012\u65e5\u000013\u65e5\u000014\u65e5\u000015\u65e5\u000016\u65e5\u000017\u65e5\u000018\u65e5\u000019\u65e5\u000020\u65e5\u000021\u65e5\u000022\u65e5\u000023\u65e5\u000024\u65e5\u000025\u65e5\u000026\u65e5\u000027\u65e5\u000028\u65e5\u000029\u65e5\u000030\u65e5\u000031\u65e5\u0000ff\u0000fi\u0000fl\u0000ffi\u0000ffl\u0000st\u0000\u0574\u0576\u0000\u0574\u0565\u0000\u0574\u056b\u0000\u057e\u0576\u0000\u0574\u056d\u0000\u05e2\u0000\u05d4\u0000\u05db\u0000\u05dc\u0000\u05dd\u0000\u05e8\u0000\u05ea\u0000\u05d0\u05dc\u0000\u0671\u0000\u067b\u0000\u067e\u0000\u0680\u0000\u067a\u0000\u067f\u0000\u0679\u0000\u06a4\u0000\u06a6\u0000\u0684\u0000\u0683\u0000\u0686\u0000\u0687\u0000\u068d\u0000\u068c\u0000\u068e\u0000\u0688\u0000\u0698\u0000\u0691\u0000\u06a9\u0000\u06af\u0000\u06b3\u0000\u06b1\u0000\u06ba\u0000\u06bb\u0000\u06d5\u0654\u0000\u06c1\u0000\u06be\u0000\u06d2\u0000\u06d2\u0654\u0000\u06ad\u0000\u06c7\u0000\u06c6\u0000\u06c8\u0000\u06cb\u0000\u06c5\u0000\u06c9\u0000\u06d0\u0000\u0649\u0000\u064a\u0654\u0627\u0000\u064a\u0654\u06d5\u0000\u064a\u0654\u0648\u0000\u064a\u0654\u06c7\u0000\u064a\u0654\u06c6\u0000\u064a\u0654\u06c8\u0000\u064a\u0654\u06d0\u0000\u064a\u0654\u0649\u0000\u06cc\u0000\u064a\u0654\u062c\u0000\u064a\u0654\u062d\u0000\u064a\u0654\u0645\u0000\u064a\u0654\u064a\u0000\u0628\u062c\u0000\u0628\u062d\u0000\u0628\u062e\u0000\u0628\u0645\u0000\u0628\u0649\u0000\u0628\u064a\u0000\u062a\u062c\u0000\u062a\u062d\u0000\u062a\u062e\u0000\u062a\u0645\u0000\u062a\u0649\u0000\u062a\u064a\u0000\u062b\u062c\u0000\u062b\u0645\u0000\u062b\u0649\u0000\u062b\u064a\u0000\u062c\u062d\u0000\u062c\u0645\u0000\u062d\u062c\u0000\u062d\u0645\u0000\u062e\u062c\u0000\u062e\u062d\u0000\u062e\u0645\u0000\u0633\u062c\u0000\u0633\u062d\u0000\u0633\u062e\u0000\u0633\u0645\u0000\u0635\u062d\u0000\u0635\u0645\u0000\u0636\u062c\u0000\u0636\u062d\u0000\u0636\u062e\u0000\u0636\u0645\u0000\u0637\u062d\u0000\u0637\u0645\u0000\u0638\u0645\u0000\u0639\u062c\u0000\u0639\u0645\u0000\u063a\u062c\u0000\u063a\u0645\u0000\u0641\u062c\u0000\u0641\u062d\u0000\u0641\u062e\u0000\u0641\u0645\u0000\u0641\u0649\u0000\u0641\u064a\u0000\u0642\u062d\u0000\u0642\u0645\u0000\u0642\u0649\u0000\u0642\u064a\u0000\u0643\u0627\u0000\u0643\u062c\u0000\u0643\u062d\u0000\u0643\u062e\u0000\u0643\u0644\u0000\u0643\u0645\u0000\u0643\u0649\u0000\u0643\u064a\u0000\u0644\u062c\u0000\u0644\u062d\u0000\u0644\u062e\u0000\u0644\u0645\u0000\u0644\u0649\u0000\u0644\u064a\u0000\u0645\u062c\u0000\u0645\u062d\u0000\u0645\u062e\u0000\u0645\u0645\u0000\u0645\u0649\u0000\u0645\u064a\u0000\u0646\u062c\u0000\u0646\u062d\u0000\u0646\u062e\u0000\u0646\u0645\u0000\u0646\u0649\u0000\u0646\u064a\u0000\u0647\u062c\u0000\u0647\u0645\u0000\u0647\u0649\u0000\u0647\u064a\u0000\u064a\u062c\u0000\u064a\u062d\u0000\u064a\u062e\u0000\u064a\u0645\u0000\u064a\u0649\u0000\u064a\u064a\u0000\u0630\u0670\u0000\u0631\u0670\u0000\u0649\u0670\u0000 \u064c\u0651\u0000 \u064d\u0651\u0000 \u064e\u0651\u0000 \u064f\u0651\u0000 \u0650\u0651\u0000 \u0651\u0670\u0000\u064a\u0654\u0631\u0000\u064a\u0654\u0632\u0000\u064a\u0654\u0646\u0000\u0628\u0631\u0000\u0628\u0632\u0000\u0628\u0646\u0000\u062a\u0631\u0000\u062a\u0632\u0000\u062a\u0646\u0000\u062b\u0631\u0000\u062b\u0632\u0000\u062b\u0646\u0000\u0645\u0627\u0000\u0646\u0631\u0000\u0646\u0632\u0000\u0646\u0646\u0000\u064a\u0631\u0000\u064a\u0632\u0000\u064a\u0646\u0000\u064a\u0654\u062e\u0000\u064a\u0654\u0647\u0000\u0628\u0647\u0000\u062a\u0647\u0000\u0635\u062e\u0000\u0644\u0647\u0000\u0646\u0647\u0000\u0647\u0670\u0000\u064a\u0647\u0000\u062b\u0647\u0000\u0633\u0647\u0000\u0634\u0645\u0000\u0634\u0647\u0000\u0640\u064e\u0651\u0000\u0640\u064f\u0651\u0000\u0640\u0650\u0651\u0000\u0637\u0649\u0000\u0637\u064a\u0000\u0639\u0649\u0000\u0639\u064a\u0000\u063a\u0649\u0000\u063a\u064a\u0000\u0633\u0649\u0000\u0633\u064a\u0000\u0634\u0649\u0000\u0634\u064a\u0000\u062d\u0649\u0000\u062d\u064a\u0000\u062c\u0649\u0000\u062c\u064a\u0000\u062e\u0649\u0000\u062e\u064a\u0000\u0635\u0649\u0000\u0635\u064a\u0000\u0636\u0649\u0000\u0636\u064a\u0000\u0634\u062c\u0000\u0634\u062d\u0000\u0634\u062e\u0000\u0634\u0631\u0000\u0633\u0631\u0000\u0635\u0631\u0000\u0636\u0631\u0000\u0627\u064b\u0000\u062a\u062c\u0645\u0000\u062a\u062d\u062c\u0000\u062a\u062d\u0645\u0000\u062a\u062e\u0645\u0000\u062a\u0645\u062c\u0000\u062a\u0645\u062d\u0000\u062a\u0645\u062e\u0000\u062c\u0645\u062d\u0000\u062d\u0645\u064a\u0000\u062d\u0645\u0649\u0000\u0633\u062d\u062c\u0000\u0633\u062c\u062d\u0000\u0633\u062c\u0649\u0000\u0633\u0645\u062d\u0000\u0633\u0645\u062c\u0000\u0633\u0645\u0645\u0000\u0635\u062d\u062d\u0000\u0635\u0645\u0645\u0000\u0634\u062d\u0645\u0000\u0634\u062c\u064a\u0000\u0634\u0645\u062e\u0000\u0634\u0645\u0645\u0000\u0636\u062d\u0649\u0000\u0636\u062e\u0645\u0000\u0637\u0645\u062d\u0000\u0637\u0645\u0645\u0000\u0637\u0645\u064a\u0000\u0639\u062c\u0645\u0000\u0639\u0645\u0645\u0000\u0639\u0645\u0649\u0000\u063a\u0645\u0645\u0000\u063a\u0645\u064a\u0000\u063a\u0645\u0649\u0000\u0641\u062e\u0645\u0000\u0642\u0645\u062d\u0000\u0642\u0645\u0645\u0000\u0644\u062d\u0645\u0000\u0644\u062d\u064a\u0000\u0644\u062d\u0649\u0000\u0644\u062c\u062c\u0000\u0644\u062e\u0645\u0000\u0644\u0645\u062d\u0000\u0645\u062d\u062c\u0000\u0645\u062d\u0645\u0000\u0645\u062d\u064a\u0000\u0645\u062c\u062d\u0000\u0645\u062c\u0645\u0000\u0645\u062e\u062c\u0000\u0645\u062e\u0645\u0000\u0645\u062c\u062e\u0000\u0647\u0645\u062c\u0000\u0647\u0645\u0645\u0000\u0646\u062d\u0645\u0000\u0646\u062d\u0649\u0000\u0646\u062c\u0645\u0000\u0646\u062c\u0649\u0000\u0646\u0645\u064a\u0000\u0646\u0645\u0649\u0000\u064a\u0645\u0645\u0000\u0628\u062e\u064a\u0000\u062a\u062c\u064a\u0000\u062a\u062c\u0649\u0000\u062a\u062e\u064a\u0000\u062a\u062e\u0649\u0000\u062a\u0645\u064a\u0000\u062a\u0645\u0649\u0000\u062c\u0645\u064a\u0000\u062c\u062d\u0649\u0000\u062c\u0645\u0649\u0000\u0633\u062e\u0649\u0000\u0635\u062d\u064a\u0000\u0634\u062d\u064a\u0000\u0636\u062d\u064a\u0000\u0644\u062c\u064a\u0000\u0644\u0645\u064a\u0000\u064a\u062d\u064a\u0000\u064a\u062c\u064a\u0000\u064a\u0645\u064a\u0000\u0645\u0645\u064a\u0000\u0642\u0645\u064a\u0000\u0646\u062d\u064a\u0000\u0639\u0645\u064a\u0000\u0643\u0645\u064a\u0000\u0646\u062c\u062d\u0000\u0645\u062e\u064a\u0000\u0644\u062c\u0645\u0000\u0643\u0645\u0645\u0000\u062c\u062d\u064a\u0000\u062d\u062c\u064a\u0000\u0645\u062c\u064a\u0000\u0641\u0645\u064a\u0000\u0628\u062d\u064a\u0000\u0633\u062e\u064a\u0000\u0646\u062c\u064a\u0000\u0635\u0644\u06d2\u0000\u0642\u0644\u06d2\u0000\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0000\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u0000\u2013\u0000_\u0000{\u0000}\u0000\u3014\u0000\u3015\u0000\u3010\u0000\u3011\u0000\u300a\u0000\u300b\u0000\u3008\u0000\u3009\u0000\u300c\u0000\u300d\u0000\u300e\u0000\u300f\u0000,\u0000\u3001\u0000;\u0000:\u0000#\u0000&\u0000*\u0000-\u0000<\u0000>\u0000\\\u0000$\u0000%\u0000@\u0000 \u064b\u0000\u0640\u064b\u0000 \u064c\u0000 \u064d\u0000 \u064e\u0000\u0640\u064e\u0000 \u064f\u0000\u0640\u064f\u0000 \u0650\u0000\u0640\u0650\u0000 \u0651\u0000\u0640\u0651\u0000 \u0652\u0000\u0640\u0652\u0000\u0621\u0000\u0627\u0653\u0000\u0627\u0654\u0000\u0648\u0654\u0000\u0627\u0655\u0000\u064a\u0654\u0000\u0628\u0000\u0629\u0000\u062a\u0000\u062b\u0000\u0630\u0000\u0633\u0000\u0634\u0000\u0635\u0000\u0636\u0000\u0637\u0000\u0638\u0000\u0639\u0000\u063a\u0000\u0641\u0000\u0642\u0000\u0643\u0000\u0644\u0627\u0653\u0000\u0644\u0627\u0654\u0000\u0644\u0627\u0655\u0000\u0644\u0627\u0000\"\u0000'\u0000/\u0000[\u0000]\u0000^\u0000`\u0000|\u0000~\u0000\u3002\u0000\u30fb\u0000\u30a3\u0000\u30a5\u0000\u30a7\u0000\u30a9\u0000\u30e3\u0000\u30e5\u0000\u30e7\u0000\u30c3\u0000\u00a2\u0000\u00a3\u0000\u00ac\u0000\u00a6\u0000\u00a5\u0000\u20a9\u0000\u2502\u0000\u2190\u0000\u2191\u0000\u2192\u0000\u2193\u0000\u25a0\u0000\u25cb\u0000\u0300\u0000\u0301\u0000\u0313\u0000\u0308\u0301\u0000\u02b9\u0000;\u0000\u00b7\u0000\u0915\u093c\u0000\u0916\u093c\u0000\u0917\u093c\u0000\u091c\u093c\u0000\u0921\u093c\u0000\u0922\u093c\u0000\u092b\u093c\u0000\u092f\u093c\u0000\u09a1\u09bc\u0000\u09a2\u09bc\u0000\u09af\u09bc\u0000\u0a32\u0a3c\u0000\u0a38\u0a3c\u0000\u0a16\u0a3c\u0000\u0a17\u0a3c\u0000\u0a1c\u0a3c\u0000\u0a2b\u0a3c\u0000\u0b21\u0b3c\u0000\u0b22\u0b3c\u0000\u0f42\u0fb7\u0000\u0f4c\u0fb7\u0000\u0f51\u0fb7\u0000\u0f56\u0fb7\u0000\u0f5b\u0fb7\u0000\u0f40\u0fb5\u0000\u0f71\u0f72\u0000\u0f71\u0f74\u0000\u0fb2\u0f80\u0000\u0fb3\u0f80\u0000\u0f71\u0f80\u0000\u0f92\u0fb7\u0000\u0f9c\u0fb7\u0000\u0fa1\u0fb7\u0000\u0fa6\u0fb7\u0000\u0fab\u0fb7\u0000\u0f90\u0fb5\u0000\u03b1\u0301\u0000\u03b5\u0301\u0000\u03b7\u0301\u0000\u03b9\u0301\u0000\u03bf\u0301\u0000\u03c5\u0301\u0000\u03c9\u0301\u0000\u0391\u0301\u0000\u03b9\u0000\u0395\u0301\u0000\u0397\u0301\u0000\u03b9\u0308\u0301\u0000\u0399\u0301\u0000\u03c5\u0308\u0301\u0000\u03a5\u0301\u0000`\u0000\u039f\u0301\u0000\u03a9\u0301\u0000\u03a9\u0000K\u0000A\u030a\u0000\u3008\u0000\u3009\u0000\u8c48\u0000\u66f4\u0000\u8eca\u0000\u8cc8\u0000\u6ed1\u0000\u4e32\u0000\u53e5\u0000\u9f9c\u0000\u9f9c\u0000\u5951\u0000\u91d1\u0000\u5587\u0000\u5948\u0000\u61f6\u0000\u7669\u0000\u7f85\u0000\u863f\u0000\u87ba\u0000\u88f8\u0000\u908f\u0000\u6a02\u0000\u6d1b\u0000\u70d9\u0000\u73de\u0000\u843d\u0000\u916a\u0000\u99f1\u0000\u4e82\u0000\u5375\u0000\u6b04\u0000\u721b\u0000\u862d\u0000\u9e1e\u0000\u5d50\u0000\u6feb\u0000\u85cd\u0000\u8964\u0000\u62c9\u0000\u81d8\u0000\u881f\u0000\u5eca\u0000\u6717\u0000\u6d6a\u0000\u72fc\u0000\u90ce\u0000\u4f86\u0000\u51b7\u0000\u52de\u0000\u64c4\u0000\u6ad3\u0000\u7210\u0000\u76e7\u0000\u8001\u0000\u8606\u0000\u865c\u0000\u8def\u0000\u9732\u0000\u9b6f\u0000\u9dfa\u0000\u788c\u0000\u797f\u0000\u7da0\u0000\u83c9\u0000\u9304\u0000\u9e7f\u0000\u8ad6\u0000\u58df\u0000\u5f04\u0000\u7c60\u0000\u807e\u0000\u7262\u0000\u78ca\u0000\u8cc2\u0000\u96f7\u0000\u58d8\u0000\u5c62\u0000\u6a13\u0000\u6dda\u0000\u6f0f\u0000\u7d2f\u0000\u7e37\u0000\u96fb\u0000\u52d2\u0000\u808b\u0000\u51dc\u0000\u51cc\u0000\u7a1c\u0000\u7dbe\u0000\u83f1\u0000\u9675\u0000\u8b80\u0000\u62cf\u0000\u8afe\u0000\u4e39\u0000\u5be7\u0000\u6012\u0000\u7387\u0000\u7570\u0000\u5317\u0000\u78fb\u0000\u4fbf\u0000\u5fa9\u0000\u4e0d\u0000\u6ccc\u0000\u6578\u0000\u7d22\u0000\u53c3\u0000\u585e\u0000\u7701\u0000\u8449\u0000\u8aaa\u0000\u6bba\u0000\u8fb0\u0000\u6c88\u0000\u62fe\u0000\u82e5\u0000\u63a0\u0000\u7565\u0000\u4eae\u0000\u5169\u0000\u51c9\u0000\u6881\u0000\u7ce7\u0000\u826f\u0000\u8ad2\u0000\u91cf\u0000\u52f5\u0000\u5442\u0000\u5973\u0000\u5eec\u0000\u65c5\u0000\u6ffe\u0000\u792a\u0000\u95ad\u0000\u9a6a\u0000\u9e97\u0000\u9ece\u0000\u529b\u0000\u66c6\u0000\u6b77\u0000\u8f62\u0000\u5e74\u0000\u6190\u0000\u6200\u0000\u649a\u0000\u6f23\u0000\u7149\u0000\u7489\u0000\u79ca\u0000\u7df4\u0000\u806f\u0000\u8f26\u0000\u84ee\u0000\u9023\u0000\u934a\u0000\u5217\u0000\u52a3\u0000\u54bd\u0000\u70c8\u0000\u88c2\u0000\u5ec9\u0000\u5ff5\u0000\u637b\u0000\u6bae\u0000\u7c3e\u0000\u7375\u0000\u4ee4\u0000\u56f9\u0000\u5dba\u0000\u601c\u0000\u73b2\u0000\u7469\u0000\u7f9a\u0000\u8046\u0000\u9234\u0000\u96f6\u0000\u9748\u0000\u9818\u0000\u4f8b\u0000\u79ae\u0000\u91b4\u0000\u96b8\u0000\u60e1\u0000\u4e86\u0000\u50da\u0000\u5bee\u0000\u5c3f\u0000\u6599\u0000\u71ce\u0000\u7642\u0000\u84fc\u0000\u907c\u0000\u9f8d\u0000\u6688\u0000\u962e\u0000\u5289\u0000\u677b\u0000\u67f3\u0000\u6d41\u0000\u6e9c\u0000\u7409\u0000\u7559\u0000\u786b\u0000\u7d10\u0000\u985e\u0000\u516d\u0000\u622e\u0000\u9678\u0000\u502b\u0000\u5d19\u0000\u6dea\u0000\u8f2a\u0000\u5f8b\u0000\u6144\u0000\u6817\u0000\u9686\u0000\u5229\u0000\u540f\u0000\u5c65\u0000\u6613\u0000\u674e\u0000\u68a8\u0000\u6ce5\u0000\u7406\u0000\u75e2\u0000\u7f79\u0000\u88cf\u0000\u88e1\u0000\u91cc\u0000\u96e2\u0000\u533f\u0000\u6eba\u0000\u541d\u0000\u71d0\u0000\u7498\u0000\u85fa\u0000\u96a3\u0000\u9c57\u0000\u9e9f\u0000\u6797\u0000\u6dcb\u0000\u81e8\u0000\u7acb\u0000\u7b20\u0000\u7c92\u0000\u72c0\u0000\u7099\u0000\u8b58\u0000\u4ec0\u0000\u8336\u0000\u523a\u0000\u5207\u0000\u5ea6\u0000\u62d3\u0000\u7cd6\u0000\u5b85\u0000\u6d1e\u0000\u66b4\u0000\u8f3b\u0000\u884c\u0000\u964d\u0000\u898b\u0000\u5ed3\u0000\u5140\u0000\u55c0\u0000\u585a\u0000\u6674\u0000\u51de\u0000\u732a\u0000\u76ca\u0000\u793c\u0000\u795e\u0000\u7965\u0000\u798f\u0000\u9756\u0000\u7cbe\u0000\u7fbd\u0000\u8612\u0000\u8af8\u0000\u9038\u0000\u90fd\u0000\u98ef\u0000\u98fc\u0000\u9928\u0000\u9db4\u0000\u05f2\u05b7\u0000\u05e9\u05c1\u0000\u05e9\u05c2\u0000\u05e9\u05bc\u05c1\u0000\u05e9\u05bc\u05c2\u0000\u05d0\u05b7\u0000\u05d0\u05b8\u0000\u05d0\u05bc\u0000\u05d1\u05bc\u0000\u05d2\u05bc\u0000\u05d3\u05bc\u0000\u05d4\u05bc\u0000\u05d5\u05bc\u0000\u05d6\u05bc\u0000\u05d8\u05bc\u0000\u05d9\u05bc\u0000\u05da\u05bc\u0000\u05db\u05bc\u0000\u05dc\u05bc\u0000\u05de\u05bc\u0000\u05e0\u05bc\u0000\u05e1\u05bc\u0000\u05e3\u05bc\u0000\u05e4\u05bc\u0000\u05e6\u05bc\u0000\u05e7\u05bc\u0000\u05e8\u05bc\u0000\u05e9\u05bc\u0000\u05ea\u05bc\u0000\u05d5\u05b9\u0000\u05d1\u05bf\u0000\u05db\u05bf\u0000\u05e4\u05bf\u0000\u0385\u0000\u00b4\u0000\u2002\u0000\u2003\u0000\u0172\u0303\u0301\u0000\u1e76\u0308\u0304\u0000\u01eb\u031b\u0301\u0000\u1eb9\u0304\u0300\u0000\u1e72\u0303\u0301\u0000\u1e11\u030c\u0000\u1ee4\u0303\u0301\u0000\u1ee3\u0301\u0000\u0172\u0308\u0304\u0000\u1e0d\u030c\u0000\u1e72\u0308\u0304\u0000\u1ee4\u0308\u0304\u0000\u1eee\u0301\u0000\u01af\u0308\u0304\u0000\u1e1a\u0304\u0300\u0000\u1e18\u0304\u0300\u0000\u1e0e\u030c\u0000\u1e75\u030b\u0000\u0118\u0304\u0300\u0000\u1e12\u030c\u0000\u0228\u0304\u0300\u0000\u1e75\u030c\u0000\u0173\u032d\u0000\u1e77\u030b\u0000\u01ea\u031b\u0301\u0000\u1e77\u030c\u0000\u1eb8\u0304\u0300\u0000\u1e10\u030c\u0000\u0173\u030b\u0000\u1ee2\u0301\u0000\u0173\u030c\u0000\u1e0c\u030c\u0000\u1e73\u030b\u0000\u1ee5\u030b\u0000\u1e73\u030c\u0000\u1ee5\u030c\u0000\u01b0\u032d\u0000\u01b0\u030b\u0000\u01b0\u030c\u0000\u1e74\u030b\u0000\u1e11\u032d\u0000\u1e74\u030c\u0000\u0172\u032d\u0000\u1e76\u030b\u0000\u01eb\u0323\u0302\u0000\u1e76\u030c\u0000\u00e7\u030c\u0000\u0172\u030b\u0000\u0172\u030c\u0000\u1e72\u030b\u0000\u1ee4\u030b\u0000\u1e72\u030c\u0000\u1ee4\u030c\u0000\u01af\u032d\u0000\u1ee3\u0302\u0000\u01af\u030b\u0000\u01af\u030c\u0000\u1e75\u030a\u0000\u1e10\u032d\u0000\u1e77\u030a\u0000\u0173\u0330\u0000\u01ea\u0323\u0302\u0000\u00c7\u030c\u0000\u0173\u030a\u0000\u01eb\u030c\u0000\u1e73\u030a\u0000\u1ee5\u030a\u0000\u1ecd\u030c\u0000\u01b0\u0330\u0000\u1ee2\u0302\u0000\u01b0\u030a\u0000\u01a1\u030c\u0000\u1e74\u030a\u0000\u1e76\u030a\u0000\u0172\u0330\u0000\u01eb\u0302\u0303\u0000\u00e7\u0307\u0000\u0172\u030a\u0000\u01ea\u030c\u0000\u1ed9\u0303\u0000\u1e72\u030a\u0000\u1ee4\u030a\u0000\u1ecc\u030c\u0000\u01af\u0330\u0000\u01a1\u0302\u0303\u0000\u01af\u030a\u0000\u01a0\u030c\u0000\u0dde\u0dca\u0000\u1e75\u0306\u0000\u1e2d\u030c\u0000\u1e77\u0306\u0000\u0173\u0324\u0000\u01ea\u0302\u0303\u0000\u00c7\u0307\u0000\u0173\u0306\u0000\u012f\u030c\u0000\u1ed8\u0303\u0000\u1e73\u0306\u0000\u1ee5\u0306\u0000\u1ecb\u030c\u0000\u01b0\u0324\u0000\u1ef5\u0304\u0000\u01a0\u0302\u0303\u0000\u01b0\u0306\u0000\u1e74\u0306\u0000\u1e2c\u030c\u0000\u1e11\u0331\u0000\u1e76\u0306\u0000\u0172\u0324\u0000\u01eb\u0302\u0309\u0000\u00e7\u0302\u0000\u0172\u0306\u0000\u012e\u030c\u0000\u1ed9\u0309\u0000\u1e72\u0306\u0000\u1ee4\u0306\u0000\u1eca\u030c\u0000\u01af\u0324\u0000\u1ef4\u0304\u0000\u01a1\u0302\u0309\u0000\u01af\u0306\u0000\u1e75\u0304\u0000\u1e10\u0331\u0000\u1e77\u0304\u0000\u0163\u032d\u0000\u01ea\u0302\u0309\u0000\u00c7\u0302\u0000\u0173\u0304\u0000\u0105\u030c\u0000\u1ed8\u0309\u0000\u1e73\u0304\u0000\u01eb\u0307\u0304\u0000\u1ee5\u0304\u0000\u1e01\u030c\u0000\u1ea1\u030c\u0000\u1ecd\u0307\u0304\u0000\u01a0\u0302\u0309\u0000\u01b0\u0304\u0000\u01a1\u0307\u0304\u0000\u1e74\u0304\u0000\u1e11\u0323\u0000\u1e76\u0304\u0000\u0162\u032d\u0000\u01eb\u0302\u0300\u0000\u0172\u0304\u0000\u0104\u030c\u0000\u1ed9\u0300\u0000\u1e72\u0304\u0000\u01ea\u0307\u0304\u0000\u1ee4\u0304\u0000\u1e00\u030c\u0000\u1ea0\u030c\u0000\u1ecc\u0307\u0304\u0000\u01a1\u0302\u0300\u0000\u01af\u0304\u0000\u01a0\u0307\u0304\u0000\u1e75\u0303\u0000\u1e10\u0323\u0000\u1e77\u0303\u0000\u0163\u0331\u0000\u01ea\u0302\u0300\u0000\u0173\u0303\u0000\u1ed8\u0300\u0000\u1e73\u0303\u0000\u01eb\u0307\u0000\u1ee5\u0303\u0000\u1ecd\u0307\u0000\u01a0\u0302\u0300\u0000\u038f\u0345\u0000\u1ffa\u0345\u0000\u1e0f\u0307\u0000\u01a1\u0307\u0000\u1e13\u0307\u0000\u1e74\u0303\u0000\u1e11\u0307\u0000\u1e76\u0303\u0000\u0162\u0331\u0000\u01eb\u0302\u0301\u0000\u1e0d\u0307\u0000\u0172\u0303\u0000\u1ed9\u0301\u0000\u1e72\u0303\u0000\u01ea\u0307\u0000\u1ee4\u0303\u0000\u1ecc\u0307\u0000\u01a1\u0302\u0301\u0000\u1e0e\u0307\u0000\u01a0\u0307\u0000\u1e12\u0307\u0000\u1e10\u0307\u0000\u0163\u0323\u0000\u01ea\u0302\u0301\u0000\u1e0c\u0307\u0000\u1ed8\u0301\u0000\u01eb\u0303\u0304\u0000\u1ecd\u0303\u0304\u0000\u01a0\u0302\u0301\u0000\u1ee1\u0304\u0000\u0162\u0323\u0000\u01eb\u0309\u0000\u0105\u0306\u0000\u1e01\u0306\u0000\u1ecd\u0309\u0000\u01ea\u0303\u0304\u0000\u1ecc\u0303\u0304\u0000\u1e6f\u0307\u0000\u1ee0\u0304\u0000\u1e71\u0307\u0000\u1e6f\u030c\u0000\u1e71\u030c\u0000\u0163\u0307\u0000\u021b\u0307\u0000\u01ea\u0309\u0000\u0104\u0306\u0000\u1e6d\u0307\u0000\u1e00\u0306\u0000\u0163\u030c\u0000\u021b\u030c\u0000\u1ecc\u0309\u0000\u01eb\u0308\u0304\u0000\u1e6d\u030c\u0000\u1ecd\u0308\u0304\u0000\u1e6e\u0307\u0000\u01a1\u0308\u0304\u0000\u1e70\u0307\u0000\u1e6e\u030c\u0000\u1e70\u030c\u0000\u0162\u0307\u0000\u021a\u0307\u0000\u01eb\u0323\u0000\u0105\u0304\u0000\u1e6c\u0307\u0000\u1e01\u0304\u0000\u0162\u030c\u0000\u021a\u030c\u0000\u1ea1\u0304\u0000\u01ea\u0308\u0304\u0000\u1e6c\u030c\u0000\u1ecc\u0308\u0304\u0000\u01a0\u0308\u0304\u0000\u015f\u0323\u0307\u0000\u01ea\u0323\u0000\u0104\u0304\u0000\u1e00\u0304\u0000\u1ea0\u0304\u0000\u015e\u0323\u0307\u0000\u012f\u0323\u0000\u1ef5\u0308\u0000\u015f\u030c\u0307\u0000\u0219\u030c\u0307\u0000\u012e\u0323\u0000\u1e63\u030c\u0307\u0000\u015f\u030c\u0000\u0219\u030c\u0000\u0105\u0307\u0000\u1e63\u030c\u0000\u1e01\u0307\u0000\u1ea1\u0307\u0000\u1e07\u0307\u0000\u1e2d\u0309\u0000\u015e\u030c\u0307\u0000\u0218\u030c\u0307\u0000\u012f\u0309\u0000\u1e05\u0307\u0000\u1e62\u030c\u0307\u0000\u015e\u030c\u0000\u0218\u030c\u0000\u1ecb\u0309\u0000\u1ef5\u0301\u0000\u0104\u0307\u0000\u1e62\u030c\u0000\u1e00\u0307\u0000\u1ea0\u0307\u0000\u1e06\u0307\u0000\u1e2c\u0309\u0000\u1e75\u0308\u0000\u1e77\u0308\u0000\u015f\u0301\u0307\u0000\u0219\u0301\u0307\u0000\u012e\u0309\u0000\u0173\u0308\u0000\u1e04\u0307\u0000\u1e63\u0301\u0307\u0000\u1e73\u0308\u0000\u1eca\u0309\u0000\u1ee5\u0308\u0000\u01b0\u0308\u0000\u1e75\u0302\u0000\u1e77\u0302\u0000\u0105\u0325\u0000\u015e\u0301\u0307\u0000\u0218\u0301\u0307\u0000\u0119\u0323\u0302\u0000\u0173\u0302\u0000\u0229\u0323\u0302\u0000\u1e62\u0301\u0307\u0000\u1e73\u0302\u0000\u1ee5\u0302\u0000\u01b0\u0302\u0000\u1e75\u0301\u0000\u1e77\u0301\u0000\u0104\u0325\u0000\u015f\u0323\u0000\u0118\u0323\u0302\u0000\u0173\u0301\u0000\u0228\u0323\u0302\u0000\u015f\u0302\u0000\u1e73\u0301\u0000\u0219\u0302\u0000\u1ee5\u0301\u0000\u1e63\u0302\u0000\u1e1b\u0302\u0303\u0000\u1e75\u0300\u0000\u1e19\u0302\u0303\u0000\u1e77\u0300\u0000\u015e\u0323\u0000\u0119\u0302\u0303\u0000\u0173\u0300\u0000\u0229\u0302\u0303\u0000\u015e\u0302\u0000\u1e73\u0300\u0000\u0218\u0302\u0000\u1ec7\u0303\u0000\u1ee5\u0300\u0000\u1e62\u0302\u0000\u1e1a\u0302\u0303\u0000\u1e18\u0302\u0303\u0000\u015f\u0307\u0000\u0219\u0307\u0000\u0118\u0302\u0303\u0000\u0228\u0302\u0303\u0000\u015f\u0301\u0000\u0219\u0301\u0000\u1ec6\u0303\u0000\u1e63\u0301\u0000\u1e1b\u0302\u0309\u0000\u1e19\u0302\u0309\u0000\u015e\u0307\u0000\u0218\u0307\u0000\u0119\u0302\u0309\u0000\u0229\u0302\u0309\u0000\u015e\u0301\u0000\u0218\u0301\u0000\u1ec7\u0309\u0000\u1e62\u0301\u0000\u1e1a\u0302\u0309\u0000\u1e5f\u030c\u0000\u1e18\u0302\u0309\u0000\u1e96\u030c\u0000\u0157\u0331\u0000\u0118\u0302\u0309\u0000\u01eb\u0308\u0000\u1e2b\u030c\u0000\u0228\u0302\u0309\u0000\u0157\u030c\u0000\u1ec6\u0309\u0000\u1ecd\u0308\u0000\u1e5b\u030c\u0000\u1e29\u030c\u0000\u1e25\u030c\u0000\u01a1\u0308\u0000\u1e1b\u0302\u0300\u0000\u1e5e\u030c\u0000\u1e19\u0302\u0300\u0000\u0156\u0331\u0000\u0119\u0302\u0300\u0000\u01eb\u0303\u0000\u1e2a\u030c\u0000\u0229\u0302\u0300\u0000\u0156\u030c\u0000\u1ec7\u0300\u0000\u1ecd\u0303\u0000\u1e5a\u030c\u0000\u1e28\u030c\u0000\u1e24\u030c\u0000\u1e1a\u0302\u0300\u0000\u1e18\u0302\u0300\u0000\u0157\u0323\u0304\u0000\u0118\u0302\u0300\u0000\u01eb\u0302\u0000\u0228\u0302\u0300\u0000\u1ec6\u0300\u0000\u01a1\u0302\u0000\u1e1b\u0302\u0301\u0000\u1e19\u0302\u0301\u0000\u0156\u0323\u0304\u0000\u0119\u0302\u0301\u0000\u01eb\u0301\u0000\u0229\u0302\u0301\u0000\u1ec7\u0301\u0000\u1ecd\u0301\u0000\u1e1a\u0302\u0301\u0000\u1e5f\u0301\u0000\u1e18\u0302\u0301\u0000\u0157\u0323\u0000\u0118\u0302\u0301\u0000\u01eb\u0300\u0000\u0228\u0302\u0301\u0000\u0157\u0301\u0000\u1ec6\u0301\u0000\u1ecd\u0300\u0000\u1e5b\u0301\u0000\u0163\u0326\u0000\u1e49\u0303\u0000\u1e1b\u0303\u0000\u1e5e\u0301\u0000\u1e19\u0303\u0000\u1e4b\u0303\u0000\u0156\u0323\u0000\u0119\u0303\u0000\u0229\u0303\u0000\u0146\u0303\u0000\u0156\u0301\u0000\u1eb9\u0303\u0000\u1e47\u0303\u0000\u1e5a\u0301\u0000\u0162\u0326\u0000\u1e5f\u0307\u0000\u1e1a\u0303\u0000\u1e18\u0303\u0000\u0157\u0307\u0000\u0118\u0303\u0000\u0228\u0303\u0000\u1e5b\u0307\u0000\u1eb8\u0303\u0000\u015f\u0326\u0000\u1e5e\u0307\u0000\u1e1b\u0309\u0000\u1e2d\u0308\u0000\u1e19\u0309\u0000\u0156\u0307\u0000\u0119\u0309\u0000\u012f\u0308\u0000\u0229\u0309\u0000\u1e5a\u0307\u0000\u1eb9\u0309\u0000\u1ecb\u0308\u0000\u015e\u0326\u0000\u1e1a\u0309\u0000\u1e2d\u0302\u0000\u1e18\u0309\u0000\u1e75\u0311\u0000\u0118\u0309\u0000\u012f\u0302\u0000\u0228\u0309\u0000\u1e77\u0311\u0000\u01eb\u030b\u0000\u1eb8\u0309\u0000\u1ecb\u0302\u0000\u0173\u0311\u0000\u1ecd\u030b\u0000\u1e73\u0311\u0000\u1ee5\u0311\u0000\u01a1\u030b\u0000\u01b0\u0311\u0000\u1e2d\u0301\u0000\u1e74\u0311\u0000\u0119\u0323\u0000\u012f\u0301\u0000\u0229\u0323\u0000\u1e76\u0311\u0000\u01ea\u030b\u0000\u1ecb\u0301\u0000\u0172\u0311\u0000\u1ecc\u030b\u0000\u1e72\u0311\u0000\u1ee4\u0311\u0000\u01a0\u030b\u0000\u01af\u0311\u0000\u1e2d\u0300\u0000\u1e75\u030f\u0000\u0118\u0323\u0000\u012f\u0300\u0000\u0228\u0323\u0000\u1e77\u030f\u0000\u01eb\u0306\u0000\u1ecb\u0300\u0000\u0173\u030f\u0000\u1ecd\u0306\u0000\u1e73\u030f\u0000\u1ee5\u030f\u0000\u01a1\u0306\u0000\u01b0\u030f\u0000\u1e1b\u0308\u0000\u1e19\u0308\u0000\u1e74\u030f\u0000\u0105\u0323\u0306\u0000\u0119\u0308\u0000\u0229\u0308\u0000\u1e76\u030f\u0000\u01ea\u0306\u0000\u1eb9\u0308\u0000\u0172\u030f\u0000\u1ecc\u0306\u0000\u1e72\u030f\u0000\u1ee4\u030f\u0000\u01a0\u0306\u0000\u01af\u030f\u0000\u1e1b\u0302\u0000\u1e19\u0302\u0000\u1e5f\u0311\u0000\u01ed\u0301\u0000\u0104\u0323\u0306\u0000\u0119\u0302\u0000\u0229\u0302\u0000\u1ecd\u0304\u0301\u0000\u0173\u031b\u0000\u1ecd\u0304\u0000\u0157\u0311\u0000\u01a1\u0304\u0301\u0000\u1e5b\u0311\u0000\u01a1\u0304\u0000\u1e1b\u0301\u0000\u1e19\u0301\u0000\u1e5e\u0311\u0000\u01ec\u0301\u0000\u0105\u0306\u0303\u0000\u0119\u0301\u0000\u0229\u0301\u0000\u1ecc\u0304\u0301\u0000\u1e01\u0306\u0303\u0000\u0172\u031b\u0000\u1eb7\u0303\u0000\u1eb9\u0301\u0000\u1ecc\u0304\u0000\u0156\u0311\u0000\u01a0\u0304\u0301\u0000\u1e5a\u0311\u0000\u01a0\u0304\u0000\u1e1b\u0300\u0000\u1e19\u0300\u0000\u1e5f\u030f\u0000\u01ed\u0300\u0000\u0104\u0306\u0303\u0000\u0119\u0300\u0000\u0229\u0300\u0000\u1ecd\u0304\u0300\u0000\u1e00\u0306\u0303\u0000\u1eb6\u0303\u0000\u1eb9\u0300\u0000\u0157\u030f\u0000\u01a1\u0304\u0300\u0000\u1e5b\u030f\u0000\u1e5e\u030f\u0000\u01ec\u0300\u0000\u0105\u0306\u0309\u0000\u1ecc\u0304\u0300\u0000\u1e01\u0306\u0309\u0000\u1eb7\u0309\u0000\u0156\u030f\u0000\u01a0\u0304\u0300\u0000\u1e5a\u030f\u0000\u01eb\u0303\u0308\u0000\u0104\u0306\u0309\u0000\u1ecd\u0303\u0308\u0000\u1e00\u0306\u0309\u0000\u1eb6\u0309\u0000\u01eb\u0311\u0000\u1ee1\u0308\u0000\u1ecd\u0311\u0000\u01a1\u0311\u0000\u1e49\u030c\u0000\u1e4b\u030c\u0000\u01ea\u0303\u0308\u0000\u0105\u0306\u0300\u0000\u0105\u030a\u0000\u1ecc\u0303\u0308\u0000\u1e01\u0306\u0300\u0000\u1e01\u030a\u0000\u0146\u030c\u0000\u1eb7\u0300\u0000\u1ea1\u030a\u0000\u01ea\u0311\u0000\u1e47\u030c\u0000\u1ee0\u0308\u0000\u1ecc\u0311\u0000\u01a0\u0311\u0000\u1e48\u030c\u0000\u1e4a\u030c\u0000\u01eb\u0303\u0301\u0000\u0104\u0306\u0300\u0000\u0105\u0308\u0000\u1ecd\u0303\u0301\u0000\u1e00\u0306\u0300\u0000\u1e01\u0308\u0000\u0145\u030c\u0000\u1eb6\u0300\u0000\u1ea1\u0308\u0000\u01eb\u030f\u0000\u1e46\u030c\u0000\u1ee1\u0301\u0000\u1ecd\u030f\u0000\u01a1\u030f\u0000\u01ea\u0303\u0301\u0000\u0105\u0306\u0301\u0000\u0105\u0303\u0000\u1ecc\u0303\u0301\u0000\u1e01\u0306\u0301\u0000\u1e01\u0303\u0000\u1eb7\u0301\u0000\u1ea1\u0303\u0000\u01ea\u030f\u0000\u1ee0\u0301\u0000\u1ecc\u030f\u0000\u01a0\u030f\u0000\u1e2d\u0311\u0000\u0146\u032d\u0000\u0104\u0306\u0301\u0000\u0105\u0302\u0000\u1e00\u0306\u0301\u0000\u1e01\u0302\u0000\u1eb6\u0301\u0000\u012f\u0311\u0000\u1ecb\u0311\u0000\u1e49\u0301\u0000\u1e4b\u0301\u0000\u1e2c\u0311\u0000\u0145\u032d\u0000\u0105\u0323\u0302\u0000\u0105\u0301\u0000\u1e01\u0301\u0000\u0146\u0301\u0000\u1ea1\u0301\u0000\u012e\u0311\u0000\u1e47\u0301\u0000\u1eca\u0311\u0000\u1e48\u0301\u0000\u1e4a\u0301\u0000\u1e2d\u030f\u0000\u0146\u0331\u0000\u0104\u0323\u0302\u0000\u0105\u0300\u0000\u1e01\u0300\u0000\u0145\u0301\u0000\u1ea1\u0300\u0000\u012f\u030f\u0000\u1e46\u0301\u0000\u1ecb\u030f\u0000\u1e2c\u030f\u0000\u0145\u0331\u0000\u0105\u0302\u0303\u0000\u1e01\u0302\u0303\u0000\u1ead\u0303\u0000\u012e\u030f\u0000\u1eca\u030f\u0000\u1e1b\u0311\u0000\u0146\u0323\u0000\u0104\u0302\u0303\u0000\u1e19\u0311\u0000\u1e00\u0302\u0303\u0000\u1eac\u0303\u0000\u0119\u0311\u0000\u0229\u0311\u0000\u1eb9\u0311\u0000\u0145\u0323\u0000\u1e1a\u0311\u0000\u0105\u0302\u0309\u0000\u1e18\u0311\u0000\u1e01\u0302\u0309\u0000\u1ead\u0309\u0000\u1ef4\u0301\u0000\u0118\u0311\u0000\u0228\u0311\u0000\u1eb8\u0311\u0000\u1e49\u0307\u0000\u1e4b\u0307\u0000\u1e74\u0308\u0000\u1e76\u0308\u0000\u0146\u0307\u0000\u1e1b\u030f\u0000\u0104\u0302\u0309\u0000\u0172\u0308\u0000\u1e19\u030f\u0000\u1e47\u0307\u0000\u1e00\u0302\u0309\u0000\u1eac\u0309\u0000\u1e72\u0308\u0000\u1ee4\u0308\u0000\u0119\u030f\u0000\u0229\u030f\u0000\u1eb9\u030f\u0000\u01af\u0308\u0000\u1e48\u0307\u0000\u1e4a\u0307\u0000\u1e74\u0302\u0000\u1e3b\u030c\u0000\u1e76\u0302\u0000\u1e3d\u030c\u0000\u0145\u0307\u0000\u1e1a\u030f\u0000\u0105\u0302\u0300\u0000\u0172\u0302\u0000\u1e18\u030f\u0000\u1e46\u0307\u0000\u1e01\u0302\u0300\u0000\u013c\u030c\u0000\u1e72\u0302\u0000\u01eb\u031b\u0000\u1ead\u0300\u0000\u1ee4\u0302\u0000\u0118\u030f\u0000\u1e37\u030c\u0000\u0228\u030f\u0000\u1eb8\u030f\u0000\u01af\u0302\u0000\u1e74\u0301\u0000\u1e3a\u030c\u0000\u1e76\u0301\u0000\u1e3c\u030c\u0000\u0104\u0302\u0300\u0000\u0172\u0301\u0000\u1e00\u0302\u0300\u0000\u013b\u030c\u0000\u1e72\u0301\u0000\u01ea\u031b\u0000\u1eac\u0300\u0000\u1ee4\u0301\u0000\u0105\u0311\u0000\u1e36\u030c\u0000\u1e01\u0311\u0000\u1ea1\u0311\u0000\u1e74\u0300\u0000\u1e76\u0300\u0000\u0105\u0302\u0301\u0000\u0172\u0300\u0000\u1e01\u0302\u0301\u0000\u1e72\u0300\u0000\u1ead\u0301\u0000\u1ee4\u0300\u0000\u0104\u0311\u0000\u1e00\u0311\u0000\u1ea0\u0311\u0000\u0104\u0302\u0301\u0000\u1e43\u0307\u0000\u1e00\u0302\u0301\u0000\u1eac\u0301\u0000\u0105\u030f\u0000\u1e01\u030f\u0000\u1ea1\u030f\u0000\u1e3b\u0301\u0000\u1e3d\u0301\u0000\u0105\u0309\u0000\u1e42\u0307\u0000\u1e01\u0309\u0000\u013c\u0301\u0000\u1ea1\u0309\u0000\u0104\u030f\u0000\u1e37\u0301\u0000\u1e00\u030f\u0000\u1ea0\u030f\u0000\u1e3a\u0301\u0000\u1e3c\u0301\u0000\u0104\u0309\u0000\u01ea\u0308\u0000\u1e43\u0301\u0000\u1e00\u0309\u0000\u013b\u0301\u0000\u1ea0\u0309\u0000\u1ecc\u0308\u0000\u1e36\u0301\u0000\u01a0\u0308\u0000\u0389\u0345\u0000\u1fca\u0345\u0000\u0105\u0323\u0000\u01ea\u0303\u0000\u1e42\u0301\u0000\u1ecc\u0303\u0000\u013c\u032d\u0000\u0104\u0323\u0000\u01ea\u0302\u0000\u01a0\u0302\u0000\u013b\u032d\u0000\u01ea\u0301\u0000\u1ecc\u0301\u0000\u0625\u0654\u0000\u013c\u0331\u0000\u01ea\u0300\u0000\u1ecc\u0300\u0000\u0105\u030a\u0301\u0000\u1e01\u030a\u0301\u0000\u1ea1\u030a\u0301\u0000\u0625\u0653\u0000\u1e48\u0303\u0000\u1e4a\u0303\u0000\u013b\u0331\u0000\u0145\u0303\u0000\u1e46\u0303\u0000\u0104\u030a\u0301\u0000\u1e00\u030a\u0301\u0000\u1ea0\u030a\u0301\u0000\u1e49\u0300\u0000\u013c\u0323\u0304\u0000\u1e4b\u0300\u0000\u0146\u0300\u0000\u1e47\u0300\u0000\u1e2c\u0308\u0000\u1e48\u0300\u0000\u013b\u0323\u0304\u0000\u012e\u0308\u0000\u1e4a\u0300\u0000\u1eca\u0308\u0000\u0145\u0300\u0000\u1e46\u0300\u0000\u1e2c\u0302\u0000\u013c\u0323\u0000\u012e\u0302\u0000\u1eca\u0302\u0000\u1e2c\u0301\u0000\u1e2c\u0307\u0000\u013b\u0323\u0000\u012e\u0301\u0000\u012e\u0307\u0000\u1ef5\u030a\u0000\u1eca\u0301\u0000\u1eca\u0307\u0000\u1e2c\u0300\u0000\u0137\u0331\u0000\u012e\u0300\u0000\u1e89\u030a\u0000\u1eca\u0300\u0000\u0123\u0301\u0000\u1e6f\u0308\u0000\u1e1a\u0308\u0000\u1e71\u0308\u0000\u1e18\u0308\u0000\u0136\u0331\u0000\u0118\u0308\u0000\u0163\u0308\u0000\u0228\u0308\u0000\u021b\u0308\u0000\u1e6d\u0308\u0000\u1eb8\u0308\u0000\u0122\u0301\u0000\u1e1a\u0302\u0000\u1e2d\u0306\u0000\u1e18\u0302\u0000\u0137\u0323\u0000\u0118\u0302\u0000\u1e29\u0331\u0000\u0228\u0302\u0000\u012f\u0306\u0000\u1ef5\u0303\u0000\u1ecb\u0306\u0000\u1e1a\u0301\u0000\u1e2c\u0306\u0000\u1e18\u0301\u0000\u0136\u0323\u0000\u0118\u0301\u0000\u0228\u0301\u0000\u012e\u0306\u0000\u1eb8\u0301\u0000\u1ef4\u0303\u0000\u1eca\u0306\u0000\u1e35\u0301\u0000\u1e1a\u0300\u0000\u1e2d\u0304\u0000\u1e18\u0300\u0000\u0137\u0301\u0000\u0118\u0300\u0000\u0228\u0300\u0000\u012f\u0304\u0000\u1e33\u0301\u0000\u1eb8\u0300\u0000\u1ef5\u0309\u0000\u1ecb\u0304\u0000\u1e34\u0301\u0000\u1e2c\u0304\u0000\u0136\u0301\u0000\u012e\u0304\u0000\u1e32\u0301\u0000\u1ef4\u0309\u0000\u1eca\u0304\u0000\u1e2d\u0308\u0301\u0000\u1e2d\u0303\u0000\u012f\u0308\u0301\u0000\u012f\u0303\u0000\u1ecb\u0308\u0301\u0000\u1ecb\u0303\u0000\u1fb8\u0345\u0000\u1fb9\u0345\u0000\u0386\u0345\u0000\u1fba\u0345\u0000\u1e2c\u0308\u0301\u0000\u1e95\u0302\u0000\u1e2c\u0303\u0000\u012e\u0308\u0301\u0000\u0104\u030a\u0000\u012e\u0303\u0000\u1eca\u0308\u0301\u0000\u1e00\u030a\u0000\u1e93\u0302\u0000\u1ea0\u030a\u0000\u1eca\u0303\u0000\u1e94\u0302\u0000\u012f\u0330\u0000\u0104\u0308\u0000\u1e00\u0308\u0000\u1e92\u0302\u0000\u1ea0\u0308\u0000\u1ef5\u0300\u0000\u012e\u0330\u0000\u0104\u0303\u0000\u1e00\u0303\u0000\u1ef5\u0307\u0000\u1ea0\u0303\u0000\u1ef4\u0300\u0000\u1e96\u0302\u0000\u1e2b\u0302\u0000\u1e29\u032e\u0000\u0104\u0302\u0000\u0173\u031b\u0323\u0000\u1e00\u0302\u0000\u1e29\u0302\u0000\u1ef4\u0307\u0000\u1e25\u0302\u0000\u1e2a\u0302\u0000\u1e28\u032e\u0000\u0104\u0301\u0000\u0172\u031b\u0323\u0000\u1e00\u0301\u0000\u1e28\u0302\u0000\u1ea0\u0301\u0000\u1e24\u0302\u0000\u1e35\u030c\u0000\u0104\u0300\u0000\u0173\u031b\u0303\u0000\u1e00\u0300\u0000\u1ea0\u0300\u0000\u1ef1\u0303\u0000\u0137\u030c\u0000\u1e33\u030c\u0000\u1e34\u030c\u0000\u0172\u031b\u0303\u0000\u1ef0\u0303\u0000\u0136\u030c\u0000\u1e32\u030c\u0000\u1e96\u0308\u0000\u1e2b\u0308\u0000\u1e29\u0308\u0000\u0173\u031b\u0309\u0000\u1e25\u0308\u0000\u0123\u0307\u0000\u1ef1\u0309\u0000\u0123\u030c\u0000\u1e2a\u0308\u0000\u1e28\u0308\u0000\u0172\u031b\u0309\u0000\u1e24\u0308\u0000\u0122\u0307\u0000\u1ef0\u0309\u0000\u0122\u030c\u0000\u1fb0\u0345\u0000\u1fb1\u0345\u0000\u1e29\u0323\u0000\u0173\u031b\u0300\u0000\u0123\u0306\u0000\u1ef1\u0300\u0000\u1e28\u0323\u0000\u0172\u031b\u0300\u0000\u0122\u0306\u0000\u1e89\u0307\u0000\u1ef0\u0300\u0000\u1e96\u0307\u0000\u1e2b\u0307\u0000\u1e29\u0307\u0000\u0173\u031b\u0301\u0000\u1e25\u0307\u0000\u0123\u0302\u0000\u1e88\u0307\u0000\u1ef1\u0301\u0000\u1e2a\u0307\u0000\u1e28\u0307\u0000\u0172\u031b\u0301\u0000\u1e24\u0307\u0000\u0122\u0302\u0000\u1e89\u0308\u0000\u1ef0\u0301\u0000\u1e75\u0309\u0000\u1e1b\u030c\u0000\u1e95\u030c\u0000\u1e77\u0309\u0000\u1e19\u030c\u0000\u0123\u0304\u0000\u0173\u0309\u0000\u0119\u030c\u0000\u0229\u030c\u0000\u1e88\u0308\u0000\u1e73\u0309\u0000\u0105\u0307\u0304\u0000\u1ee5\u0309\u0000\u1eb9\u030c\u0000\u1e93\u030c\u0000\u1e01\u0307\u0304\u0000\u1ea1\u0307\u0304\u0000\u1e74\u0309\u0000\u1e1a\u030c\u0000\u1e94\u030c\u0000\u1e76\u0309\u0000\u1e18\u030c\u0000\u0122\u0304\u0000\u0172\u0309\u0000\u0118\u030c\u0000\u0228\u030c\u0000\u1e89\u0301\u0000\u1e72\u0309\u0000\u0104\u0307\u0304\u0000\u1ee4\u0309\u0000\u1eb8\u030c\u0000\u1e92\u030c\u0000\u1e00\u0307\u0304\u0000\u1ea0\u0307\u0304\u0000\u1e95\u0307\u0000\u0173\u0323\u0000\u1e88\u0301\u0000\u0105\u0308\u0304\u0000\u1e93\u0307\u0000\u1e01\u0308\u0304\u0000\u1ea1\u0308\u0304\u0000\u1e94\u0307\u0000\u0172\u0323\u0000\u1e89\u0300\u0000\u0104\u0308\u0304\u0000\u1e92\u0307\u0000\u1e00\u0308\u0304\u0000\u1ea0\u0308\u0304\u0000\u1e1b\u0307\u0000\u1e95\u0301\u0000\u1e19\u0307\u0000\u01eb\u031b\u0323\u0000\u0119\u0307\u0000\u0229\u0307\u0000\u1e88\u0300\u0000\u1eb9\u0307\u0000\u1e93\u0301\u0000\u1e1a\u0307\u0000\u1e94\u0301\u0000\u1e18\u0307\u0000\u1e75\u0308\u0300\u0000\u1e77\u0308\u0300\u0000\u01ea\u031b\u0323\u0000\u0118\u0307\u0000\u0228\u0307\u0000\u0173\u0308\u0300\u0000\u1eb8\u0307\u0000\u1e92\u0301\u0000\u1e73\u0308\u0300\u0000\u1ee5\u0308\u0300\u0000\u01b0\u0308\u0300\u0000\u1e1b\u0306\u0000\u1e19\u0306\u0000\u0119\u0330\u0000\u1e74\u0308\u0300\u0000\u0229\u0330\u0000\u1e76\u0308\u0300\u0000\u01eb\u031b\u0303\u0000\u0119\u0306\u0000\u0172\u0308\u0300\u0000\u1ee3\u0303\u0000\u1eb9\u0306\u0000\u1ef4\u0308\u0000\u1e72\u0308\u0300\u0000\u1ee4\u0308\u0300\u0000\u01af\u0308\u0300\u0000\u1e1a\u0306\u0000\u1e18\u0306\u0000\u0118\u0330\u0000\u1e75\u0308\u030c\u0000\u0228\u0330\u0000\u1e77\u0308\u030c\u0000\u01ea\u031b\u0303\u0000\u0118\u0306\u0000\u1e7f\u0303\u0000\u0173\u0308\u030c\u0000\u1ee2\u0303\u0000\u1eb8\u0306\u0000\u1ef5\u0302\u0000\u1e73\u0308\u030c\u0000\u1ee5\u0308\u030c\u0000\u01b0\u0308\u030c\u0000\u1e1b\u0304\u0000\u1e19\u0304\u0000\u0119\u032d\u0000\u1e74\u0308\u030c\u0000\u0229\u032d\u0000\u1e76\u0308\u030c\u0000\u01eb\u031b\u0309\u0000\u0119\u0304\u0000\u0229\u0304\u0000\u1e7e\u0303\u0000\u0172\u0308\u030c\u0000\u1ee3\u0309\u0000\u1eb9\u0304\u0000\u1ef4\u0302\u0000\u1e72\u0308\u030c\u0000\u1ee4\u0308\u030c\u0000\u01af\u0308\u030c\u0000\u1e75\u0304\u0308\u0000\u1e1a\u0304\u0000\u1e77\u0304\u0308\u0000\u1e18\u0304\u0000\u0118\u032d\u0000\u1e75\u0308\u0301\u0000\u0228\u032d\u0000\u0173\u0304\u0308\u0000\u1e77\u0308\u0301\u0000\u01ea\u031b\u0309\u0000\u0118\u0304\u0000\u0228\u0304\u0000\u1e73\u0304\u0308\u0000\u1ee5\u0304\u0308\u0000\u0173\u0308\u0301\u0000\u1ee2\u0309\u0000\u1eb8\u0304\u0000\u1e89\u0302\u0000\u1e73\u0308\u0301\u0000\u1ee5\u0308\u0301\u0000\u01b0\u0304\u0308\u0000\u01b0\u0308\u0301\u0000\u1e1b\u0304\u0301\u0000\u1e74\u0304\u0308\u0000\u1e19\u0304\u0301\u0000\u1e76\u0304\u0308\u0000\u0119\u0304\u0301\u0000\u1e74\u0308\u0301\u0000\u0229\u0304\u0301\u0000\u0172\u0304\u0308\u0000\u1e76\u0308\u0301\u0000\u01eb\u031b\u0300\u0000\u1eb9\u0304\u0301\u0000\u1e72\u0304\u0308\u0000\u1ee4\u0304\u0308\u0000\u0172\u0308\u0301\u0000\u1ee3\u0300\u0000\u1e88\u0302\u0000\u1e72\u0308\u0301\u0000\u1ee4\u0308\u0301\u0000\u01af\u0304\u0308\u0000\u01af\u0308\u0301\u0000\u1e1a\u0304\u0301\u0000\u1e75\u0303\u0301\u0000\u1e18\u0304\u0301\u0000\u1e77\u0303\u0301\u0000\u0118\u0304\u0301\u0000\u1e75\u0308\u0304\u0000\u0228\u0304\u0301\u0000\u0173\u0303\u0301\u0000\u1e77\u0308\u0304\u0000\u01ea\u031b\u0300\u0000\u1eb8\u0304\u0301\u0000\u1e73\u0303\u0301\u0000\u1ee5\u0303\u0301\u0000\u0173\u0308\u0304\u0000\u1ee2\u0300\u0000\u1e73\u0308\u0304\u0000\u1ee5\u0308\u0304\u0000\u1eef\u0301\u0000\u01b0\u0308\u0304\u0000\u1e1b\u0304\u0300\u0000\u1e74\u0303\u0301\u0000\u1e19\u0304\u0300\u0000\u1e0f\u030c\u0000\u1e76\u0303\u0301\u0000\u1e13\u030c\u0000\u0119\u0304\u0300\u0000\u1e74\u0308\u0304\u0000\u0229\u0304\u0300\u0000".charAt(c);
    }

    public static String decompose(String string, boolean bl, int n) {
        return Normalizer.decompose(string, bl, n, false);
    }

    public static String decompose(String string, boolean bl, int n, boolean bl2) {
        boolean bl3 = (n & 1) == 0;
        int n2 = bl ? 0 : 11177;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        int n3 = 0;
        int n4 = -1;
        if (bl2) {
            stringBuffer3 = new StringBuffer();
        }
        while (n3 < string.length() || n4 >= 0) {
            char c;
            int n5;
            char c2;
            if (n4 >= 0) {
                c2 = stringBuffer2.charAt(n4++);
                if (n4 == stringBuffer2.length()) {
                    n4 = -1;
                }
            } else {
                c2 = string.charAt(n3++);
            }
            if ((n5 = (c = DecompData.offsets.elementAt(c2)) & Short.MAX_VALUE) > n2) {
                if ((c & 0x8000) != 0) {
                    if (stringBuffer2 == null) {
                        stringBuffer2 = new StringBuffer();
                    } else {
                        stringBuffer2.setLength(0);
                    }
                    Normalizer.doAppend("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", n5, stringBuffer2);
                    n4 = 0;
                    continue;
                }
                if (!bl2) {
                    Normalizer.doAppend("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", n5, stringBuffer);
                    continue;
                }
                stringBuffer3.setLength(0);
                Normalizer.doAppend("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", n5, stringBuffer3);
                if (stringBuffer3.length() > 1 || c2 == '\u037e' || c2 == '\u1fef') {
                    int n6 = 0;
                    while (n6 < stringBuffer3.length()) {
                        char c3 = stringBuffer3.charAt(n6);
                        if (c3 >= '\t' && c3 <= '\r' || c3 >= ' ' && c3 <= '/' || c3 >= ':' && c3 <= '@' || c3 >= '[' && c3 <= '`' || c3 >= '{' && c3 <= '~') {
                            stringBuffer.append('\'');
                            stringBuffer.append(c3);
                            stringBuffer.append('\'');
                        } else {
                            stringBuffer.append(c3);
                        }
                        ++n6;
                    }
                    continue;
                }
                stringBuffer.append(stringBuffer3);
                continue;
            }
            if (c2 >= '\uac00' && c2 < '\ud7a4' && bl3) {
                Normalizer.hangulToJamo(c2, stringBuffer, n2);
                continue;
            }
            stringBuffer.append(c2);
        }
        Normalizer.fixCanonical(stringBuffer);
        return stringBuffer.toString();
    }

    private char nextDecomp() {
        boolean bl = (this.options & 1) == 0;
        this.currentIndex = this.nextIndex;
        char c = this.curForward();
        char c2 = DecompData.offsets.elementAt(c);
        int n = c2 & Short.MAX_VALUE;
        this.initBuffer();
        if (n > this.minDecomp || DecompData.canonClass.elementAt(c) != 0) {
            int n2;
            if (n > this.minDecomp) {
                Normalizer.doAppend("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", n, this.buffer);
                if ((c2 & 0x8000) != 0) {
                    n2 = 0;
                    while (n2 < this.getBufferLength()) {
                        c = this.buffer.charAt(n2);
                        n = DecompData.offsets.elementAt(c) & Short.MAX_VALUE;
                        if (n > this.minDecomp) {
                            n2 += Normalizer.doReplace("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", n, this.buffer, n2);
                        }
                        ++n2;
                    }
                }
            } else {
                this.buffer.append(c);
            }
            n2 = 0;
            while ((c = this.text.next()) != '\uffff' && DecompData.canonClass.elementAt(c) != 0) {
                n2 = 1;
                n = DecompData.offsets.elementAt(c) & Short.MAX_VALUE;
                if (n > this.minDecomp) {
                    Normalizer.doAppend("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", n, this.buffer);
                    continue;
                }
                this.buffer.append(c);
            }
            if (this.getBufferLength() > 1 && n2 != 0) {
                Normalizer.fixCanonical(this.buffer);
            }
            c = this.buffer.charAt(0);
        } else {
            this.text.next();
            this.buffer.setLength(0);
            this.buffer.append(c);
            if (bl && c >= '\uac00' && c < '\ud7a4') {
                this.clearBuffer();
                Normalizer.hangulToJamo(c, this.buffer, this.minDecomp);
                c = this.buffer.charAt(0);
            }
        }
        this.nextIndex = this.text.getIndex();
        return c;
    }

    private char prevDecomp() {
        boolean bl = (this.options & 1) == 0;
        this.nextIndex = this.currentIndex;
        char c = this.curBackward();
        char c2 = DecompData.offsets.elementAt(c);
        int n = c2 & Short.MAX_VALUE;
        this.initBuffer();
        if (n > this.minDecomp || DecompData.canonClass.elementAt(c) != 0) {
            while (c != '\uffff') {
                this.buffer.insert(0, c);
                if (DecompData.canonClass.elementAt(c) == 0) break;
                c = this.text.previous();
            }
            int n2 = 0;
            while (n2 < this.getBufferLength()) {
                c = this.buffer.charAt(n2);
                c2 = DecompData.offsets.elementAt(c);
                n = c2 & Short.MAX_VALUE;
                if (n > this.minDecomp) {
                    int n3 = Normalizer.doReplace("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", n, this.buffer, n2);
                    if ((c2 & 0x8000) != 0) {
                        while (n2 < n3) {
                            c = this.buffer.charAt(n2);
                            n = DecompData.offsets.elementAt(c) & Short.MAX_VALUE;
                            if (n > this.minDecomp) {
                                n2 += Normalizer.doReplace("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", n, this.buffer, n2);
                            }
                            ++n2;
                        }
                    }
                    n2 = n3;
                }
                ++n2;
            }
            if (this.getBufferLength() > 1) {
                Normalizer.fixCanonical(this.buffer);
            }
            this.bufferPos = this.getBufferLength() - 1;
            c = this.buffer.charAt(this.bufferPos);
        } else if (bl && c >= '\uac00' && c < '\ud7a4') {
            Normalizer.hangulToJamo(c, this.buffer, this.minDecomp);
            this.getBufferLength();
            this.bufferPos = this.getBufferLength() - 1;
            c = this.buffer.charAt(this.bufferPos);
        } else {
            this.buffer.append(c);
            this.getBufferLength();
            this.bufferPos = this.getBufferLength() - 1;
        }
        this.currentIndex = this.text.getIndex();
        return c;
    }

    public static final int getClass(char c) {
        int n = DecompData.canonClass.elementAt(c);
        return n >= 0 ? n : n + 256;
    }

    public char current() {
        if (this.bufferPos >= this.getBufferLength() || this.getBufferLength() == 0) {
            this.bufferPos = 0;
            if (this.mode.compose()) {
                this.currentChar = this.nextCompose();
                this.text.setIndex(this.currentIndex);
            } else if (this.mode.decomp()) {
                this.currentChar = this.nextDecomp();
                this.text.setIndex(this.currentIndex);
            } else {
                this.currentChar = this.currentIndex == 0 ? this.text.current() : this.text.current();
            }
        } else {
            this.currentChar = this.buffer.charAt(this.bufferPos);
        }
        return this.currentChar;
    }

    public char first() {
        this.reset();
        return this.next();
    }

    public char last() {
        this.currentIndex = this.nextIndex = this.text.getEndIndex() - 1;
        this.text.setIndex(this.currentIndex);
        this.atEnd = true;
        this.currentChar = (char)65535;
        this.clearBuffer();
        return this.previous();
    }

    public char next() {
        if (this.buffer != null && ++this.bufferPos < this.buffer.length()) {
            this.currentChar = this.buffer.charAt(this.bufferPos);
        } else {
            this.bufferPos = 0;
            if (this.mode.compose()) {
                this.currentChar = this.nextCompose();
            } else if (this.mode.decomp()) {
                this.currentChar = this.nextDecomp();
            } else {
                this.currentChar = this.text.current();
                this.text.next();
                if (this.currentChar != '\uffff') {
                    this.currentIndex = ++this.nextIndex;
                }
            }
        }
        return this.currentChar;
    }

    public char previous() {
        if (this.bufferPos > 0) {
            this.currentChar = this.buffer.charAt(--this.bufferPos);
        } else {
            this.bufferPos = 0;
            if (this.mode.compose()) {
                this.currentChar = this.prevCompose();
            } else if (this.mode.decomp()) {
                this.currentChar = this.prevDecomp();
            } else {
                this.text.setIndex(this.currentIndex);
                this.currentChar = this.text.previous();
                if (this.currentIndex != 0) {
                    this.currentIndex = --this.nextIndex;
                }
            }
        }
        return this.currentChar;
    }

    private int getBufferLength() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length();
    }

    public char setIndex(int n) {
        this.setIndexOnly(n);
        return this.current();
    }

    public void setIndexOnly(int n) {
        this.currentIndex = this.nextIndex = n;
        this.text.setIndex(n);
        this.currentChar = (char)65535;
        this.clearBuffer();
    }

    public final int getIndex() {
        return this.text.getIndex();
    }

    public final int getBeginIndex() {
        return this.text.getBeginIndex();
    }

    public final int getEndIndex() {
        return this.text.getEndIndex();
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.minDecomp = this.mode.compat() ? 0 : 11177;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setOption(int n, boolean bl) {
        if (n != 1) {
            throw new IllegalArgumentException("Illegal option");
        }
        this.options = bl ? (this.options |= n) : (this.options &= ~n);
    }

    public boolean getOption(int n) {
        return (this.options & n) != 0;
    }

    public void setText(String string) {
        this.text = new StringCharacterIterator(string);
        this.reset();
    }

    public void setText(CharacterIterator characterIterator) {
        this.text = characterIterator;
        this.reset();
    }

    private final char curForward() {
        char c = this.text.current();
        return c;
    }

    private final char curBackward() {
        char c = this.atEnd ? this.text.current() : this.text.previous();
        this.atEnd = false;
        return c;
    }

    static final int doAppend(String string, int n, StringBuffer stringBuffer) {
        int n2 = n >>> 2;
        int n3 = n & 3;
        if (n3 == 0) {
            char c;
            while ((c = "\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf".charAt(n2++)) != '\u0000') {
                stringBuffer.append(c);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.append("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf".charAt(n2++));
                ++n4;
            }
        }
        return n3;
    }

    static final int doInsert(String string, int n, StringBuffer stringBuffer, int n2) {
        int n3 = n >>> 2;
        int n4 = n & 3;
        if (n4 == 0) {
            char c;
            while ((c = "\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf".charAt(n3++)) != '\u0000') {
                stringBuffer.insert(n2++, c);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.insert(n2++, "\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf".charAt(n3++));
                ++n5;
            }
        }
        return n4;
    }

    static final int doReplace(String string, int n, StringBuffer stringBuffer, int n2) {
        int n3 = n >>> 2;
        int n4 = n & 3;
        stringBuffer.setCharAt(n2++, "\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf".charAt(n3++));
        if (n4 == 0) {
            char c;
            while ((c = "\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf".charAt(n3++)) != '\u0000') {
                stringBuffer.insert(n2++, c);
                ++n4;
            }
        } else {
            int n5 = 1;
            while (n5 < n4) {
                stringBuffer.insert(n2++, "\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf".charAt(n3++));
                ++n5;
            }
        }
        return n4;
    }

    public void reset() {
        this.currentIndex = this.nextIndex = this.text.getBeginIndex();
        this.text.setIndex(this.currentIndex);
        this.atEnd = false;
        this.bufferPos = 0;
        this.clearBuffer();
    }

    private final void initBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(10);
        } else {
            this.buffer.setLength(0);
        }
        this.clearBuffer();
    }

    private final void clearBuffer() {
        this.bufferPos = 0;
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
    }

    private static void fixCanonical(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        int n = stringBuffer.length() - 1;
        int n2 = Normalizer.getClass(stringBuffer.charAt(n));
        --n;
        while (n >= 0) {
            int n3 = n2;
            n2 = Normalizer.getClass(stringBuffer.charAt(n));
            if (n2 > n3 && n3 != 0) {
                char c = stringBuffer.charAt(n);
                stringBuffer.setCharAt(n, stringBuffer.charAt(n + 1));
                stringBuffer.setCharAt(n + 1, c);
                if (n < stringBuffer.length() - 2) {
                    n += 2;
                }
                n2 = Normalizer.getClass(stringBuffer.charAt(n));
            }
            --n;
        }
    }

    static int hangulToJamo(char c, StringBuffer stringBuffer, int n) {
        char c2 = (char)(c - 44032);
        char c3 = (char)(4352 + c2 / 588);
        char c4 = (char)(4449 + c2 % 588 / 28);
        char c5 = (char)(4519 + c2 % 28);
        int n2 = 0;
        n2 += Normalizer.jamoAppend(c3, n, stringBuffer);
        n2 += Normalizer.jamoAppend(c4, n, stringBuffer);
        if (c5 != '\u11a7') {
            n2 += Normalizer.jamoAppend(c5, n, stringBuffer);
        }
        return n2;
    }

    static final int jamoAppend(char c, int n, StringBuffer stringBuffer) {
        char c2 = DecompData.offsets.elementAt(c);
        if (c2 > n) {
            return Normalizer.doAppend("\uffff  \u0308a \u030423 \u0301\u03bc \u03271o1\u204441\u204423\u20444IJijL\u00b7l\u00b7\u02bcnsDZ\u030cDz\u030cdz\u030cLJLjljNJNjnjh\u0266r\u0279\u027b\u0281wy \u0306 \u0307 \u030a \u0328 \u0303 \u030b\u0263x\u0295 \u0345\u03b2\u03b8\u03a5\u03c6\u03c0\u03ba\u03c1\u03c2\u0565\u0582\u0627\u0674\u0648\u0674\u06c7\u0674\u064a\u0674\u0e4d\u0e32\u0ecd\u0eb2\u0eab\u0e99\u0eab\u0ea1\u0f0b\u0fb2\u0f71\u0f80\u0fb3\u0f71\u0f80a\u02be \u0313 \u0342 \u0314\u2010 \u0333...\u2032\u2032\u2032\u2032\u2032\u2035\u2035\u2035\u2035\u2035!! \u0305?!!?056789+\u2212=()Rsa/ca/sC\u00b0Cc/oc/u\u0190\u00b0FgH\u0127NoPQSMTELTMBe\u05d0\u05d1\u05d2\u05d31\u204432\u204431\u204452\u204453\u204454\u204451\u204465\u204461\u204483\u204485\u204487\u20448IIIIIIVVIVIIVIII\u0000IXXIXIIiiiiiivviviiviii\u0000ixxixiim\u222b\u222b\u222b\u222b\u222b\u222e\u222e\u222e\u222e\u222e1011121314151617181920(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\u0000(11)\u0000(12)\u0000(13)\u0000(14)\u0000(15)\u0000(16)\u0000(17)\u0000(18)\u0000(19)\u0000(20)\u00001.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20.(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)(m)(n)(o)(p)(q)(r)(s)(t)(u)(v)(w)(x)(y)(z)AGKOUWY\u6bcd\u9f9f\u4e00\u4e28\u4e36\u4e3f\u4e59\u4e85\u4e8c\u4ea0\u4eba\u513f\u5165\u516b\u5182\u5196\u51ab\u51e0\u51f5\u5200\u529b\u52f9\u5315\u531a\u5338\u5341\u535c\u5369\u5382\u53b6\u53c8\u53e3\u56d7\u571f\u58eb\u5902\u590a\u5915\u5927\u5973\u5b50\u5b80\u5bf8\u5c0f\u5c22\u5c38\u5c6e\u5c71\u5ddb\u5de5\u5df1\u5dfe\u5e72\u5e7a\u5e7f\u5ef4\u5efe\u5f0b\u5f13\u5f50\u5f61\u5f73\u5fc3\u6208\u6236\u624b\u652f\u6534\u6587\u6597\u65a4\u65b9\u65e0\u65e5\u66f0\u6708\u6728\u6b20\u6b62\u6b79\u6bb3\u6bcb\u6bd4\u6bdb\u6c0f\u6c14\u6c34\u706b\u722a\u7236\u723b\u723f\u7247\u7259\u725b\u72ac\u7384\u7389\u74dc\u74e6\u7518\u751f\u7528\u7530\u758b\u7592\u7676\u767d\u76ae\u76bf\u76ee\u77db\u77e2\u77f3\u793a\u79b8\u79be\u7a74\u7acb\u7af9\u7c73\u7cf8\u7f36\u7f51\u7f8a\u7fbd\u8001\u800c\u8012\u8033\u807f\u8089\u81e3\u81ea\u81f3\u81fc\u820c\u821b\u821f\u826e\u8272\u8278\u864d\u866b\u8840\u884c\u8863\u897e\u898b\u89d2\u8a00\u8c37\u8c46\u8c55\u8c78\u8c9d\u8d64\u8d70\u8db3\u8eab\u8eca\u8f9b\u8fb0\u8fb5\u9091\u9149\u91c6\u91cc\u91d1\u9577\u9580\u961c\u96b6\u96b9\u96e8\u9751\u975e\u9762\u9769\u97cb\u97ed\u97f3\u9801\u98a8\u98db\u98df\u9996\u9999\u99ac\u9aa8\u9ad8\u9adf\u9b25\u9b2f\u9b32\u9b3c\u9b5a\u9ce5\u9e75\u9e7f\u9ea5\u9ebb\u9ec3\u9ecd\u9ed1\u9ef9\u9efd\u9f0e\u9f13\u9f20\u9f3b\u9f4a\u9f52\u9f8d\u9f9c\u9fa0\u3012\u5344\u5345 \u3099 \u309a\u1100\u1101\u11aa\u1102\u11ac\u11ad\u1103\u1104\u1105\u11b0\u11b1\u11b2\u11b3\u11b4\u11b5\u111a\u1106\u1107\u1108\u1121\u1109\u110a\u110b\u110c\u110d\u110e\u110f\u1110\u1111\u1112\u1161\u1162\u1163\u1164\u1165\u1166\u1167\u1168\u1169\u116a\u116b\u116c\u116d\u116e\u116f\u1170\u1171\u1172\u1173\u1174\u1175\u1160\u1114\u1115\u11c7\u11c8\u11cc\u11ce\u11d3\u11d7\u11d9\u111c\u11dd\u11df\u111d\u111e\u1120\u1122\u1123\u1127\u1129\u112b\u112c\u112d\u112e\u112f\u1132\u1136\u1140\u1147\u114c\u11f1\u11f2\u1157\u1158\u1159\u1184\u1185\u1188\u1191\u1192\u1194\u119e\u11a1\u4e09\u56db\u4e0a\u4e2d\u4e0b\u7532\u4e19\u4e01\u5929\u5730(\u1100)(\u1102)(\u1103)(\u1105)(\u1106)(\u1107)(\u1109)(\u110b)(\u110c)(\u110e)(\u110f)(\u1110)(\u1111)(\u1112)(\u1100\u1161)\u0000(\u1102\u1161)\u0000(\u1103\u1161)\u0000(\u1105\u1161)\u0000(\u1106\u1161)\u0000(\u1107\u1161)\u0000(\u1109\u1161)\u0000(\u110b\u1161)\u0000(\u110c\u1161)\u0000(\u110e\u1161)\u0000(\u110f\u1161)\u0000(\u1110\u1161)\u0000(\u1111\u1161)\u0000(\u1112\u1161)\u0000(\u110c\u116e)\u0000(\u4e00)(\u4e8c)(\u4e09)(\u56db)(\u4e94)(\u516d)(\u4e03)(\u516b)(\u4e5d)(\u5341)(\u6708)(\u706b)(\u6c34)(\u6728)(\u91d1)(\u571f)(\u65e5)(\u682a)(\u6709)(\u793e)(\u540d)(\u7279)(\u8ca1)(\u795d)(\u52b4)(\u4ee3)(\u547c)(\u5b66)(\u76e3)(\u4f01)(\u8cc7)(\u5354)(\u796d)(\u4f11)(\u81ea)(\u81f3)\u79d8\u7537\u9069\u512a\u5370\u6ce8\u9805\u5199\u6b63\u5de6\u53f3\u533b\u5b97\u591c1\u67082\u67083\u67084\u67085\u67086\u67087\u67088\u67089\u670810\u670811\u670812\u6708\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f0\u30f1\u30f2\u30a2\u30cf\u309a\u30fc\u30c8\u0000\u30a2\u30eb\u30d5\u30a1\u0000\u30a2\u30f3\u30d8\u309a\u30a2\u0000\u30a2\u30fc\u30eb\u30a4\u30cb\u30f3\u30af\u3099\u0000\u30a4\u30f3\u30c1\u30a6\u30a9\u30f3\u30a8\u30b9\u30af\u30fc\u30c8\u3099\u0000\u30a8\u30fc\u30ab\u30fc\u0000\u30aa\u30f3\u30b9\u30aa\u30fc\u30e0\u30ab\u30a4\u30ea\u30ab\u30e9\u30c3\u30c8\u0000\u30ab\u30ed\u30ea\u30fc\u0000\u30ab\u3099\u30ed\u30f3\u0000\u30ab\u3099\u30f3\u30de\u0000\u30ad\u3099\u30ab\u3099\u0000\u30ad\u3099\u30cb\u30fc\u0000\u30ad\u30e5\u30ea\u30fc\u0000\u30ad\u3099\u30eb\u30bf\u3099\u30fc\u0000\u30ad\u30ed\u30ad\u30ed\u30af\u3099\u30e9\u30e0\u0000\u30ad\u30ed\u30e1\u30fc\u30c8\u30eb\u0000\u30ad\u30ed\u30ef\u30c3\u30c8\u0000\u30af\u3099\u30e9\u30e0\u30c8\u30f3\u0000\u30af\u30eb\u30bb\u3099\u30a4\u30ed\u0000\u30af\u30ed\u30fc\u30cd\u0000\u30b1\u30fc\u30b9\u30b3\u30eb\u30ca\u30b3\u30fc\u30db\u309a\u0000\u30b5\u30a4\u30af\u30eb\u0000\u30b5\u30f3\u30c1\u30fc\u30e0\u0000\u30b7\u30ea\u30f3\u30af\u3099\u0000\u30bb\u30f3\u30c1\u30bb\u30f3\u30c8\u30bf\u3099\u30fc\u30b9\u0000\u30c6\u3099\u30b7\u30c8\u3099\u30eb\u30ca\u30ce\u30ce\u30c3\u30c8\u30cf\u30a4\u30c4\u30cf\u309a\u30fc\u30bb\u30f3\u30c8\u0000\u30cf\u309a\u30fc\u30c4\u0000\u30cf\u3099\u30fc\u30ec\u30eb\u0000\u30d2\u309a\u30a2\u30b9\u30c8\u30eb\u0000\u30d2\u309a\u30af\u30eb\u0000\u30d2\u309a\u30b3\u30d2\u3099\u30eb\u30d5\u30a1\u30e9\u30c3\u30c8\u3099\u0000\u30d5\u30a3\u30fc\u30c8\u0000\u30d5\u3099\u30c3\u30b7\u30a7\u30eb\u0000\u30d5\u30e9\u30f3\u30d8\u30af\u30bf\u30fc\u30eb\u0000\u30d8\u309a\u30bd\u30d8\u309a\u30cb\u30d2\u0000\u30d8\u30eb\u30c4\u30d8\u309a\u30f3\u30b9\u0000\u30d8\u309a\u30fc\u30b7\u3099\u0000\u30d8\u3099\u30fc\u30bf\u0000\u30db\u309a\u30a4\u30f3\u30c8\u0000\u30db\u3099\u30eb\u30c8\u0000\u30db\u30f3\u30db\u309a\u30f3\u30c8\u3099\u0000\u30db\u30fc\u30eb\u30db\u30fc\u30f3\u30de\u30a4\u30af\u30ed\u0000\u30de\u30a4\u30eb\u30de\u30c3\u30cf\u30de\u30eb\u30af\u30de\u30f3\u30b7\u30e7\u30f3\u0000\u30df\u30af\u30ed\u30f3\u0000\u30df\u30ea\u30df\u30ea\u30cf\u3099\u30fc\u30eb\u0000\u30e1\u30ab\u3099\u30e1\u30ab\u3099\u30c8\u30f3\u0000\u30e4\u30fc\u30c8\u3099\u0000\u30e4\u30fc\u30eb\u30e6\u30a2\u30f3\u30ea\u30c3\u30c8\u30eb\u0000\u30ea\u30e9\u30eb\u30d2\u309a\u30fc\u0000\u30eb\u30fc\u30d5\u3099\u30eb\u0000\u30ec\u30e0\u30ec\u30f3\u30c8\u30b1\u3099\u30f3\u00000\u70b91\u70b92\u70b93\u70b94\u70b95\u70b96\u70b97\u70b98\u70b99\u70b910\u70b911\u70b912\u70b913\u70b914\u70b915\u70b916\u70b917\u70b918\u70b919\u70b920\u70b921\u70b922\u70b923\u70b924\u70b9hPadaAUbaroVpc\u5e73\u6210\u662d\u548c\u5927\u6b63\u660e\u6cbb\u682a\u5f0f\u4f1a\u793e\u0000pAnA\u03bcAmAkAKBGBcalkcal\u0000pFnF\u03bcF\u03bcgmgkgHzkHzMHzGHzTHz\u03bclmldlklfmnm\u03bcmmmcmkmmm2cm2km2mm3cm3km3m\u2215sm\u2215s2\u0000kPaMPaGParadrad\u2215s\u0000rad\u2215s2\u0000ps\u03bcsmspVnV\u03bcVmVkVMVpWnW\u03bcWmWkWMWk\u03a9M\u03a9a.m.\u0000BqcccdC\u2215kg\u0000Co.dBGyhaHPinKKKMktlnloglxmbmilmolPHp.m.\u0000PPMPRsrSvWb1\u65e52\u65e53\u65e54\u65e55\u65e56\u65e57\u65e58\u65e59\u65e510\u65e511\u65e512\u65e513\u65e514\u65e515\u65e516\u65e517\u65e518\u65e519\u65e520\u65e521\u65e522\u65e523\u65e524\u65e525\u65e526\u65e527\u65e528\u65e529\u65e530\u65e531\u65e5fffiflfflst\u0574\u0576\u0574\u0565\u0574\u056b\u057e\u0576\u0574\u056d\u05e2\u05d4\u05db\u05dc\u05dd\u05e8\u05ea\u05d0\u05dc\u0671\u067b\u067e\u0680\u067a\u067f\u0679\u06a4\u06a6\u0684\u0683\u0686\u0687\u068d\u068c\u068e\u0688\u0698\u0691\u06a9\u06af\u06b3\u06b1\u06ba\u06bb\u06d5\u0654\u06c1\u06be\u06d2\u06d2\u0654\u06ad\u06c6\u06c8\u06cb\u06c5\u06c9\u06d0\u0649\u064a\u0654\u0627\u064a\u0654\u06d5\u064a\u0654\u0648\u064a\u0654\u06c7\u064a\u0654\u06c6\u064a\u0654\u06c8\u064a\u0654\u06d0\u064a\u0654\u0649\u06cc\u064a\u0654\u062c\u064a\u0654\u062d\u064a\u0654\u0645\u064a\u0654\u064a\u0628\u062c\u0628\u062d\u0628\u062e\u0628\u0645\u0628\u0649\u0628\u064a\u062a\u062c\u062a\u062d\u062a\u062e\u062a\u0645\u062a\u0649\u062a\u064a\u062b\u062c\u062b\u0645\u062b\u0649\u062b\u064a\u062c\u062d\u062c\u0645\u062d\u0645\u062e\u062c\u062e\u062d\u062e\u0645\u0633\u062c\u0633\u062d\u0633\u062e\u0633\u0645\u0635\u062d\u0635\u0645\u0636\u062c\u0636\u062d\u0636\u062e\u0636\u0645\u0637\u062d\u0637\u0645\u0638\u0645\u0639\u062c\u0639\u0645\u063a\u062c\u063a\u0645\u0641\u062c\u0641\u062d\u0641\u062e\u0641\u0645\u0641\u0649\u0641\u064a\u0642\u062d\u0642\u0645\u0642\u0649\u0642\u064a\u0643\u0627\u0643\u062c\u0643\u062d\u0643\u062e\u0643\u0644\u0643\u0645\u0643\u0649\u0643\u064a\u0644\u062c\u0644\u062d\u0644\u062e\u0644\u0645\u0644\u0649\u0644\u064a\u0645\u062c\u0645\u0645\u0645\u0649\u0646\u062c\u0646\u062d\u0646\u062e\u0646\u0645\u0646\u0649\u0646\u064a\u0647\u062c\u0647\u0645\u0647\u0649\u0647\u064a\u064a\u062d\u064a\u062e\u064a\u0649\u0630\u0670\u0631\u0670\u0649\u0670 \u064c\u0651 \u064d\u0651 \u064e\u0651 \u064f\u0651 \u0650\u0651 \u0651\u0670\u064a\u0654\u0631\u064a\u0654\u0632\u064a\u0654\u0646\u0628\u0631\u0628\u0632\u0628\u0646\u062a\u0631\u062a\u0632\u062a\u0646\u062b\u0631\u062b\u0632\u062b\u0646\u0645\u0627\u0646\u0631\u0646\u0632\u0646\u0646\u064a\u0631\u064a\u0632\u064a\u0646\u064a\u0654\u062e\u064a\u0654\u0647\u0628\u0647\u062a\u0647\u0635\u062e\u0644\u0647\u0646\u0647\u0647\u0670\u062b\u0647\u0633\u0647\u0634\u0645\u0634\u0647\u0640\u064e\u0651\u0640\u064f\u0651\u0640\u0650\u0651\u0637\u0649\u0637\u064a\u0639\u0649\u0639\u064a\u063a\u0649\u063a\u064a\u0633\u0649\u0633\u064a\u0634\u0649\u0634\u064a\u062d\u0649\u062c\u0649\u062e\u0649\u0635\u0649\u0635\u064a\u0636\u0649\u0636\u064a\u0634\u062c\u0634\u062d\u0634\u062e\u0634\u0631\u0633\u0631\u0635\u0631\u0636\u0631\u0627\u064b\u062a\u062c\u0645\u062a\u062d\u062c\u062a\u062d\u0645\u062a\u062e\u0645\u062a\u0645\u062c\u062a\u0645\u062d\u062a\u0645\u062e\u062d\u0645\u064a\u062d\u0645\u0649\u0633\u062d\u062c\u0633\u062c\u062d\u0633\u062c\u0649\u0633\u0645\u062d\u0633\u0645\u062c\u0633\u0645\u0645\u0635\u062d\u062d\u0635\u0645\u0645\u0634\u062d\u0645\u0634\u062c\u064a\u0634\u0645\u062e\u0634\u0645\u0645\u0636\u062d\u0649\u0636\u062e\u0645\u0637\u0645\u062d\u0637\u0645\u0645\u0637\u0645\u064a\u0639\u062c\u0645\u0639\u0645\u0645\u0639\u0645\u0649\u063a\u0645\u0645\u063a\u0645\u064a\u063a\u0645\u0649\u0641\u062e\u0645\u0642\u0645\u062d\u0642\u0645\u0645\u0644\u062d\u0645\u0644\u062d\u064a\u0644\u062d\u0649\u0644\u062c\u062c\u0644\u062e\u0645\u0644\u0645\u062d\u0645\u062d\u062c\u0645\u062d\u064a\u0645\u062c\u062d\u0645\u062e\u0645\u0645\u062c\u062e\u0647\u0645\u062c\u0647\u0645\u0645\u0646\u062d\u0645\u0646\u062d\u0649\u0646\u062c\u0645\u0646\u062c\u0649\u0646\u0645\u064a\u0646\u0645\u0649\u064a\u0645\u0645\u0628\u062e\u064a\u062a\u062c\u064a\u062a\u062c\u0649\u062a\u062e\u064a\u062a\u062e\u0649\u062a\u0645\u064a\u062a\u0645\u0649\u062c\u0645\u064a\u062c\u062d\u0649\u062c\u0645\u0649\u0633\u062e\u0649\u0635\u062d\u064a\u0634\u062d\u064a\u0636\u062d\u064a\u0644\u062c\u064a\u0644\u0645\u064a\u064a\u062c\u064a\u064a\u0645\u064a\u0645\u0645\u064a\u0642\u0645\u064a\u0646\u062d\u064a\u0639\u0645\u064a\u0643\u0645\u064a\u0646\u062c\u062d\u0645\u062e\u064a\u0644\u062c\u0645\u0643\u0645\u0645\u062c\u062d\u064a\u062d\u062c\u064a\u0645\u062c\u064a\u0641\u0645\u064a\u0628\u062d\u064a\u0633\u062e\u064a\u0646\u062c\u064a\u0635\u0644\u06d2\u0642\u0644\u06d2\u0627\u0644\u0644\u0647\u0000\u0627\u0643\u0628\u0631\u0000\u0645\u062d\u0645\u062f\u0000\u0635\u0644\u0639\u0645\u0000\u0631\u0633\u0648\u0644\u0000\u0639\u0644\u064a\u0647\u0000\u0648\u0633\u0644\u0645\u0000\u0635\u0644\u0649\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u0000\u062c\u0644 \u062c\u0644\u0627\u0644\u0647\u0000\u2014\u2013_{}\u3014\u3015\u3010\u3011\u300a\u300b\u3008\u3009\u300c\u300d\u300e\u300f,\u3001;:#&*-<>\\$%@ \u064b\u0640\u064b\u0640\u0651 \u0652\u0640\u0652\u0621\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u0629\u0644\u0627\u0653\u0644\u0627\u0654\u0644\u0627\u0655\"'[]^`|~\u3002\u30fb\u30a5\u30e3\u00a2\u00a3\u00ac\u00a6\u00a5\u20a9\u2502\u2190\u2191\u2192\u2193\u25a0\u25cbA\u0300A\u0301A\u0302A\u0303A\u0308A\u030aC\u0327E\u0300E\u0301E\u0302E\u0308I\u0300I\u0301I\u0302I\u0308N\u0303O\u0300O\u0301O\u0302O\u0303O\u0308U\u0300U\u0301U\u0302U\u0308Y\u0301a\u0300a\u0301a\u0302a\u0303a\u0308a\u030ac\u0327e\u0300e\u0301e\u0302e\u0308i\u0300i\u0301i\u0302i\u0308n\u0303o\u0300o\u0301o\u0302o\u0303o\u0308u\u0300u\u0301u\u0302u\u0308y\u0301y\u0308A\u0304a\u0304A\u0306a\u0306A\u0328a\u0328C\u0301c\u0301C\u0302c\u0302C\u0307c\u0307C\u030cc\u030cD\u030cd\u030cE\u0304e\u0304E\u0306e\u0306E\u0307e\u0307E\u0328e\u0328E\u030ce\u030cG\u0302g\u0302G\u0306g\u0306G\u0307g\u0307G\u0327g\u0327H\u0302h\u0302I\u0303i\u0303I\u0304i\u0304I\u0306i\u0306I\u0328i\u0328I\u0307J\u0302j\u0302K\u0327k\u0327L\u0301l\u0301L\u0327l\u0327L\u030cl\u030cN\u0301n\u0301N\u0327n\u0327N\u030cn\u030cO\u0304o\u0304O\u0306o\u0306O\u030bo\u030bR\u0301r\u0301R\u0327r\u0327R\u030cr\u030cS\u0301s\u0301S\u0302s\u0302S\u0327s\u0327S\u030cs\u030cT\u0327t\u0327T\u030ct\u030cU\u0303u\u0303U\u0304u\u0304U\u0306u\u0306U\u030au\u030aU\u030bu\u030bU\u0328u\u0328W\u0302w\u0302Y\u0302y\u0302Y\u0308Z\u0301z\u0301Z\u0307z\u0307Z\u030cz\u030cO\u031bo\u031bU\u031bu\u031bA\u030ca\u030cI\u030ci\u030cO\u030co\u030cU\u030cu\u030cU\u0308\u0304u\u0308\u0304U\u0308\u0301u\u0308\u0301U\u0308\u030cu\u0308\u030cU\u0308\u0300u\u0308\u0300A\u0308\u0304a\u0308\u0304A\u0307\u0304a\u0307\u0304\u00c6\u0304\u00e6\u0304G\u030cg\u030cK\u030ck\u030cO\u0328o\u0328O\u0328\u0304o\u0328\u0304\u01b7\u030c\u0292\u030cj\u030cG\u0301g\u0301N\u0300n\u0300A\u030a\u0301a\u030a\u0301\u00c6\u0301\u00e6\u0301\u00d8\u0301\u00f8\u0301A\u030fa\u030fA\u0311a\u0311E\u030fe\u030fE\u0311e\u0311I\u030fi\u030fI\u0311i\u0311O\u030fo\u030fO\u0311o\u0311R\u030fr\u030fR\u0311r\u0311U\u030fu\u030fU\u0311u\u0311S\u0326s\u0326T\u0326t\u0326H\u030ch\u030cA\u0307a\u0307E\u0327e\u0327O\u0308\u0304o\u0308\u0304O\u0303\u0304o\u0303\u0304O\u0307o\u0307O\u0307\u0304o\u0307\u0304Y\u0304y\u0304\u0300\u0301\u0313\u0308\u0301\u02b9;\u00a8\u0301\u0391\u0301\u00b7\u0395\u0301\u0397\u0301\u0399\u0301\u039f\u0301\u03a5\u0301\u03a9\u0301\u03b9\u0308\u0301\u0399\u0308\u03a5\u0308\u03b1\u0301\u03b5\u0301\u03b7\u0301\u03b9\u0301\u03c5\u0308\u0301\u03b9\u0308\u03c5\u0308\u03bf\u0301\u03c5\u0301\u03c9\u0301\u03d2\u0301\u03d2\u0308\u0415\u0300\u0415\u0308\u0413\u0301\u0406\u0308\u041a\u0301\u0418\u0300\u0423\u0306\u0418\u0306\u0438\u0306\u0435\u0300\u0435\u0308\u0433\u0301\u0456\u0308\u043a\u0301\u0438\u0300\u0443\u0306\u0474\u030f\u0475\u030f\u0416\u0306\u0436\u0306\u0410\u0306\u0430\u0306\u0410\u0308\u0430\u0308\u0415\u0306\u0435\u0306\u04d8\u0308\u04d9\u0308\u0416\u0308\u0436\u0308\u0417\u0308\u0437\u0308\u0418\u0304\u0438\u0304\u0418\u0308\u0438\u0308\u041e\u0308\u043e\u0308\u04e8\u0308\u04e9\u0308\u042d\u0308\u044d\u0308\u0423\u0304\u0443\u0304\u0423\u0308\u0443\u0308\u0423\u030b\u0443\u030b\u0427\u0308\u0447\u0308\u042b\u0308\u044b\u0308\u0627\u0653\u0627\u0654\u0648\u0654\u0627\u0655\u064a\u0654\u06d5\u0654\u06c1\u0654\u06d2\u0654\u0928\u093c\u0930\u093c\u0933\u093c\u0915\u093c\u0916\u093c\u0917\u093c\u091c\u093c\u0921\u093c\u0922\u093c\u092b\u093c\u092f\u093c\u09c7\u09be\u09c7\u09d7\u09a1\u09bc\u09a2\u09bc\u09af\u09bc\u0a32\u0a3c\u0a38\u0a3c\u0a16\u0a3c\u0a17\u0a3c\u0a1c\u0a3c\u0a2b\u0a3c\u0b47\u0b56\u0b47\u0b3e\u0b47\u0b57\u0b21\u0b3c\u0b22\u0b3c\u0b92\u0bd7\u0bc6\u0bbe\u0bc7\u0bbe\u0bc6\u0bd7\u0c46\u0c56\u0cbf\u0cd5\u0cc6\u0cd5\u0cc6\u0cd6\u0cc6\u0cc2\u0cc6\u0cc2\u0cd5\u0d46\u0d3e\u0d47\u0d3e\u0d46\u0d57\u0dd9\u0dca\u0dd9\u0dcf\u0dd9\u0dcf\u0dca\u0dd9\u0ddf\u0f42\u0fb7\u0f4c\u0fb7\u0f51\u0fb7\u0f56\u0fb7\u0f5b\u0fb7\u0f40\u0fb5\u0f71\u0f72\u0f71\u0f74\u0fb2\u0f80\u0fb3\u0f80\u0f71\u0f80\u0f92\u0fb7\u0f9c\u0fb7\u0fa1\u0fb7\u0fa6\u0fb7\u0fab\u0fb7\u0f90\u0fb5\u1025\u102eA\u0325a\u0325B\u0307b\u0307B\u0323b\u0323B\u0331b\u0331C\u0327\u0301c\u0327\u0301D\u0307d\u0307D\u0323d\u0323D\u0331d\u0331D\u0327d\u0327D\u032dd\u032dE\u0304\u0300e\u0304\u0300E\u0304\u0301e\u0304\u0301E\u032de\u032dE\u0330e\u0330E\u0327\u0306e\u0327\u0306F\u0307f\u0307G\u0304g\u0304H\u0307h\u0307H\u0323h\u0323H\u0308h\u0308H\u0327h\u0327H\u032eh\u032eI\u0330i\u0330I\u0308\u0301i\u0308\u0301K\u0301k\u0301K\u0323k\u0323K\u0331k\u0331L\u0323l\u0323L\u0323\u0304l\u0323\u0304L\u0331l\u0331L\u032dl\u032dM\u0301m\u0301M\u0307m\u0307M\u0323m\u0323N\u0307n\u0307N\u0323n\u0323N\u0331n\u0331N\u032dn\u032dO\u0303\u0301o\u0303\u0301O\u0303\u0308o\u0303\u0308O\u0304\u0300o\u0304\u0300O\u0304\u0301o\u0304\u0301P\u0301p\u0301P\u0307p\u0307R\u0307r\u0307R\u0323r\u0323R\u0323\u0304r\u0323\u0304R\u0331r\u0331S\u0307s\u0307S\u0323s\u0323S\u0301\u0307s\u0301\u0307S\u030c\u0307s\u030c\u0307S\u0323\u0307s\u0323\u0307T\u0307t\u0307T\u0323t\u0323T\u0331t\u0331T\u032dt\u032dU\u0324u\u0324U\u0330u\u0330U\u032du\u032dU\u0303\u0301u\u0303\u0301U\u0304\u0308u\u0304\u0308V\u0303v\u0303V\u0323v\u0323W\u0300w\u0300W\u0301w\u0301W\u0308w\u0308W\u0307w\u0307W\u0323w\u0323X\u0307x\u0307X\u0308x\u0308Y\u0307y\u0307Z\u0302z\u0302Z\u0323z\u0323Z\u0331z\u0331h\u0331t\u0308w\u030ay\u030a\u017f\u0307A\u0323a\u0323A\u0309a\u0309A\u0302\u0301a\u0302\u0301A\u0302\u0300a\u0302\u0300A\u0302\u0309a\u0302\u0309A\u0302\u0303a\u0302\u0303A\u0323\u0302a\u0323\u0302A\u0306\u0301a\u0306\u0301A\u0306\u0300a\u0306\u0300A\u0306\u0309a\u0306\u0309A\u0306\u0303a\u0306\u0303A\u0323\u0306a\u0323\u0306E\u0323e\u0323E\u0309e\u0309E\u0303e\u0303E\u0302\u0301e\u0302\u0301E\u0302\u0300e\u0302\u0300E\u0302\u0309e\u0302\u0309E\u0302\u0303e\u0302\u0303E\u0323\u0302e\u0323\u0302I\u0309i\u0309I\u0323i\u0323O\u0323o\u0323O\u0309o\u0309O\u0302\u0301o\u0302\u0301O\u0302\u0300o\u0302\u0300O\u0302\u0309o\u0302\u0309O\u0302\u0303o\u0302\u0303O\u0323\u0302o\u0323\u0302O\u031b\u0301o\u031b\u0301O\u031b\u0300o\u031b\u0300O\u031b\u0309o\u031b\u0309O\u031b\u0303o\u031b\u0303O\u031b\u0323o\u031b\u0323U\u0323u\u0323U\u0309u\u0309U\u031b\u0301u\u031b\u0301U\u031b\u0300u\u031b\u0300U\u031b\u0309u\u031b\u0309U\u031b\u0303u\u031b\u0303U\u031b\u0323u\u031b\u0323Y\u0300y\u0300Y\u0323y\u0323Y\u0309y\u0309Y\u0303y\u0303\u03b1\u0313\u03b1\u0314\u03b1\u0313\u0300\u03b1\u0314\u0300\u03b1\u0313\u0301\u03b1\u0314\u0301\u03b1\u0313\u0342\u03b1\u0314\u0342\u0391\u0313\u0391\u0314\u0391\u0313\u0300\u0391\u0314\u0300\u0391\u0313\u0301\u0391\u0314\u0301\u0391\u0313\u0342\u0391\u0314\u0342\u03b5\u0313\u03b5\u0314\u03b5\u0313\u0300\u03b5\u0314\u0300\u03b5\u0313\u0301\u03b5\u0314\u0301\u0395\u0313\u0395\u0314\u0395\u0313\u0300\u0395\u0314\u0300\u0395\u0313\u0301\u0395\u0314\u0301\u03b7\u0313\u03b7\u0314\u03b7\u0313\u0300\u03b7\u0314\u0300\u03b7\u0313\u0301\u03b7\u0314\u0301\u03b7\u0313\u0342\u03b7\u0314\u0342\u0397\u0313\u0397\u0314\u0397\u0313\u0300\u0397\u0314\u0300\u0397\u0313\u0301\u0397\u0314\u0301\u0397\u0313\u0342\u0397\u0314\u0342\u03b9\u0313\u03b9\u0314\u03b9\u0313\u0300\u03b9\u0314\u0300\u03b9\u0313\u0301\u03b9\u0314\u0301\u03b9\u0313\u0342\u03b9\u0314\u0342\u0399\u0313\u0399\u0314\u0399\u0313\u0300\u0399\u0314\u0300\u0399\u0313\u0301\u0399\u0314\u0301\u0399\u0313\u0342\u0399\u0314\u0342\u03bf\u0313\u03bf\u0314\u03bf\u0313\u0300\u03bf\u0314\u0300\u03bf\u0313\u0301\u03bf\u0314\u0301\u039f\u0313\u039f\u0314\u039f\u0313\u0300\u039f\u0314\u0300\u039f\u0313\u0301\u039f\u0314\u0301\u03c5\u0313\u03c5\u0314\u03c5\u0313\u0300\u03c5\u0314\u0300\u03c5\u0313\u0301\u03c5\u0314\u0301\u03c5\u0313\u0342\u03c5\u0314\u0342\u03a5\u0314\u03a5\u0314\u0300\u03a5\u0314\u0301\u03a5\u0314\u0342\u03c9\u0313\u03c9\u0314\u03c9\u0313\u0300\u03c9\u0314\u0300\u03c9\u0313\u0301\u03c9\u0314\u0301\u03c9\u0313\u0342\u03c9\u0314\u0342\u03a9\u0313\u03a9\u0314\u03a9\u0313\u0300\u03a9\u0314\u0300\u03a9\u0313\u0301\u03a9\u0314\u0301\u03a9\u0313\u0342\u03a9\u0314\u0342\u03b1\u0300\u03b1\u0301\u03b5\u0300\u03b5\u0301\u03b7\u0300\u03b7\u0301\u03b9\u0300\u03b9\u0301\u03bf\u0300\u03bf\u0301\u03c5\u0300\u03c5\u0301\u03c9\u0300\u03c9\u0301\u03b1\u0313\u0345\u03b1\u0314\u0345\u03b1\u0313\u0300\u0345\u0000\u03b1\u0314\u0300\u0345\u0000\u03b1\u0313\u0301\u0345\u0000\u03b1\u0314\u0301\u0345\u0000\u03b1\u0313\u0342\u0345\u0000\u03b1\u0314\u0342\u0345\u0000\u0391\u0313\u0345\u0391\u0314\u0345\u0391\u0313\u0300\u0345\u0000\u0391\u0314\u0300\u0345\u0000\u0391\u0313\u0301\u0345\u0000\u0391\u0314\u0301\u0345\u0000\u0391\u0313\u0342\u0345\u0000\u0391\u0314\u0342\u0345\u0000\u03b7\u0313\u0345\u03b7\u0314\u0345\u03b7\u0313\u0300\u0345\u0000\u03b7\u0314\u0300\u0345\u0000\u03b7\u0313\u0301\u0345\u0000\u03b7\u0314\u0301\u0345\u0000\u03b7\u0313\u0342\u0345\u0000\u03b7\u0314\u0342\u0345\u0000\u0397\u0313\u0345\u0397\u0314\u0345\u0397\u0313\u0300\u0345\u0000\u0397\u0314\u0300\u0345\u0000\u0397\u0313\u0301\u0345\u0000\u0397\u0314\u0301\u0345\u0000\u0397\u0313\u0342\u0345\u0000\u0397\u0314\u0342\u0345\u0000\u03c9\u0313\u0345\u03c9\u0314\u0345\u03c9\u0313\u0300\u0345\u0000\u03c9\u0314\u0300\u0345\u0000\u03c9\u0313\u0301\u0345\u0000\u03c9\u0314\u0301\u0345\u0000\u03c9\u0313\u0342\u0345\u0000\u03c9\u0314\u0342\u0345\u0000\u03a9\u0313\u0345\u03a9\u0314\u0345\u03a9\u0313\u0300\u0345\u0000\u03a9\u0314\u0300\u0345\u0000\u03a9\u0313\u0301\u0345\u0000\u03a9\u0314\u0301\u0345\u0000\u03a9\u0313\u0342\u0345\u0000\u03a9\u0314\u0342\u0345\u0000\u03b1\u0306\u03b1\u0304\u03b1\u0300\u0345\u03b1\u0345\u03b1\u0301\u0345\u03b1\u0342\u03b1\u0342\u0345\u0391\u0306\u0391\u0304\u0391\u0300\u0391\u0301\u0391\u0345\u03b9\u00a8\u0342\u03b7\u0300\u0345\u03b7\u0345\u03b7\u0301\u0345\u03b7\u0342\u03b7\u0342\u0345\u0395\u0300\u0395\u0301\u0397\u0300\u0397\u0301\u0397\u0345\u1fbf\u0300\u1fbf\u0301\u1fbf\u0342\u03b9\u0306\u03b9\u0304\u03b9\u0308\u0300\u03b9\u0308\u0301\u03b9\u0342\u03b9\u0308\u0342\u0399\u0306\u0399\u0304\u0399\u0300\u0399\u0301\u1ffe\u0300\u1ffe\u0301\u1ffe\u0342\u03c5\u0306\u03c5\u0304\u03c5\u0308\u0300\u03c5\u0308\u0301\u03c1\u0313\u03c1\u0314\u03c5\u0342\u03c5\u0308\u0342\u03a5\u0306\u03a5\u0304\u03a5\u0300\u03a5\u0301\u03a1\u0314\u00a8\u0300\u00a8\u0301`\u03c9\u0300\u0345\u03c9\u0345\u03c9\u0301\u0345\u03c9\u0342\u03c9\u0342\u0345\u039f\u0300\u039f\u0301\u03a9\u0300\u03a9\u0301\u03a9\u0345\u00b4\u2002\u2003\u03a9KA\u030a\u2190\u0338\u2192\u0338\u2194\u0338\u21d0\u0338\u21d4\u0338\u21d2\u0338\u2203\u0338\u2208\u0338\u220b\u0338\u2223\u0338\u2225\u0338\u223c\u0338\u2243\u0338\u2245\u0338\u2248\u0338=\u0338\u2261\u0338\u224d\u0338<\u0338>\u0338\u2264\u0338\u2265\u0338\u2272\u0338\u2273\u0338\u2276\u0338\u2277\u0338\u227a\u0338\u227b\u0338\u2282\u0338\u2283\u0338\u2286\u0338\u2287\u0338\u22a2\u0338\u22a8\u0338\u22a9\u0338\u22ab\u0338\u227c\u0338\u227d\u0338\u2291\u0338\u2292\u0338\u22b2\u0338\u22b3\u0338\u22b4\u0338\u22b5\u0338\u3008\u3009\u304b\u3099\u304d\u3099\u304f\u3099\u3051\u3099\u3053\u3099\u3055\u3099\u3057\u3099\u3059\u3099\u305b\u3099\u305d\u3099\u305f\u3099\u3061\u3099\u3064\u3099\u3066\u3099\u3068\u3099\u306f\u3099\u306f\u309a\u3072\u3099\u3072\u309a\u3075\u3099\u3075\u309a\u3078\u3099\u3078\u309a\u307b\u3099\u307b\u309a\u3046\u3099\u309d\u3099\u30ab\u3099\u30ad\u3099\u30af\u3099\u30b1\u3099\u30b3\u3099\u30b5\u3099\u30b7\u3099\u30b9\u3099\u30bb\u3099\u30bd\u3099\u30bf\u3099\u30c1\u3099\u30c4\u3099\u30c6\u3099\u30c8\u3099\u30cf\u3099\u30cf\u309a\u30d2\u3099\u30d2\u309a\u30d5\u3099\u30d5\u309a\u30d8\u3099\u30d8\u309a\u30db\u3099\u30db\u309a\u30a6\u3099\u30ef\u3099\u30f0\u3099\u30f1\u3099\u30f2\u3099\u30fd\u3099\u8c48\u66f4\u8eca\u8cc8\u6ed1\u4e32\u53e5\u9f9c\u9f9c\u5951\u91d1\u5587\u5948\u61f6\u7669\u7f85\u863f\u87ba\u88f8\u908f\u6a02\u6d1b\u70d9\u73de\u843d\u916a\u99f1\u4e82\u5375\u6b04\u721b\u862d\u9e1e\u5d50\u6feb\u85cd\u8964\u62c9\u81d8\u881f\u5eca\u6717\u6d6a\u72fc\u90ce\u4f86\u51b7\u52de\u64c4\u6ad3\u7210\u76e7\u8001\u8606\u865c\u8def\u9732\u9b6f\u9dfa\u788c\u797f\u7da0\u83c9\u9304\u9e7f\u8ad6\u58df\u5f04\u7c60\u807e\u7262\u78ca\u8cc2\u96f7\u58d8\u5c62\u6a13\u6dda\u6f0f\u7d2f\u7e37\u96fb\u52d2\u808b\u51dc\u51cc\u7a1c\u7dbe\u83f1\u9675\u8b80\u62cf\u6a02\u8afe\u4e39\u5be7\u6012\u7387\u7570\u5317\u78fb\u4fbf\u5fa9\u4e0d\u6ccc\u6578\u7d22\u53c3\u585e\u7701\u8449\u8aaa\u6bba\u8fb0\u6c88\u62fe\u82e5\u63a0\u7565\u4eae\u5169\u51c9\u6881\u7ce7\u826f\u8ad2\u91cf\u52f5\u5442\u5973\u5eec\u65c5\u6ffe\u792a\u95ad\u9a6a\u9e97\u9ece\u529b\u66c6\u6b77\u8f62\u5e74\u6190\u6200\u649a\u6f23\u7149\u7489\u79ca\u7df4\u806f\u8f26\u84ee\u9023\u934a\u5217\u52a3\u54bd\u70c8\u88c2\u8aaa\u5ec9\u5ff5\u637b\u6bae\u7c3e\u7375\u4ee4\u56f9\u5be7\u5dba\u601c\u73b2\u7469\u7f9a\u8046\u9234\u96f6\u9748\u9818\u4f8b\u79ae\u91b4\u96b8\u60e1\u4e86\u50da\u5bee\u5c3f\u6599\u6a02\u71ce\u7642\u84fc\u907c\u9f8d\u6688\u962e\u5289\u677b\u67f3\u6d41\u6e9c\u7409\u7559\u786b\u7d10\u985e\u516d\u622e\u9678\u502b\u5d19\u6dea\u8f2a\u5f8b\u6144\u6817\u7387\u9686\u5229\u540f\u5c65\u6613\u674e\u68a8\u6ce5\u7406\u75e2\u7f79\u88cf\u88e1\u91cc\u96e2\u533f\u6eba\u541d\u71d0\u7498\u85fa\u96a3\u9c57\u9e9f\u6797\u6dcb\u81e8\u7acb\u7b20\u7c92\u72c0\u7099\u8b58\u4ec0\u8336\u523a\u5207\u5ea6\u62d3\u7cd6\u5b85\u6d1e\u66b4\u8f3b\u884c\u964d\u898b\u5ed3\u5140\u55c0\u585a\u6674\u51de\u732a\u76ca\u793c\u795e\u7965\u798f\u9756\u7cbe\u7fbd\u8612\u8af8\u9038\u90fd\u98ef\u98fc\u9928\u9db4\u05d9\u05b4\u05f2\u05b7\u05e9\u05c1\u05e9\u05c2\u05e9\u05bc\u05c1\u05e9\u05bc\u05c2\u05d0\u05b7\u05d0\u05b8\u05d0\u05bc\u05d1\u05bc\u05d2\u05bc\u05d3\u05bc\u05d4\u05bc\u05d5\u05bc\u05d6\u05bc\u05d8\u05bc\u05d9\u05bc\u05da\u05bc\u05db\u05bc\u05dc\u05bc\u05de\u05bc\u05e0\u05bc\u05e1\u05bc\u05e3\u05bc\u05e4\u05bc\u05e6\u05bc\u05e7\u05bc\u05e8\u05bc\u05e9\u05bc\u05ea\u05bc\u05d5\u05b9\u05d1\u05bf\u05db\u05bf\u05e4\u05bf", c2, stringBuffer);
        }
        stringBuffer.append(c);
        return 1;
    }

    private static void jamoToHangul(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        int n3 = stringBuffer.length() - 1;
        int n4 = n;
        while (n4 < n3) {
            int n5;
            char c = stringBuffer.charAt(n4);
            int n6 = c - 4352;
            if (n6 >= 0 && n6 < 19 && (n5 = stringBuffer.charAt(n4 + 1) - 4449) >= 0 && n5 < 21) {
                int n7;
                int n8 = n7 = ++n4 < n3 ? (int)stringBuffer.charAt(n4 + 1) : 0;
                if ((n7 -= 4519) >= 0 && n7 < 28) {
                    ++n4;
                } else {
                    n7 = 0;
                }
                stringBuffer.setCharAt(n2++, (char)((n6 * 21 + n5) * 28 + n7 + 44032));
            } else {
                stringBuffer.setCharAt(n2++, c);
            }
            ++n4;
        }
        while (n4 < stringBuffer.length()) {
            stringBuffer.setCharAt(n2++, stringBuffer.charAt(n4++));
        }
        stringBuffer.setLength(n2);
    }

    public static final class Mode {
        final int mode;

        Mode(int n) {
            this.mode = n;
        }

        final boolean compat() {
            return (this.mode & 1) != 0;
        }

        final boolean compose() {
            return (this.mode & 4) != 0;
        }

        final boolean decomp() {
            return (this.mode & 2) != 0;
        }
    }
}

