/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.HashMap;

public class ManifestDigester {
    byte[] rawBytes;
    HashMap entries;

    private boolean findSection(int n, Position position) {
        int n2 = n;
        int n3 = this.rawBytes.length;
        int n4 = n;
        boolean bl = true;
        position.endOfFirstLine = -1;
        while (n2 < n3) {
            byte by = this.rawBytes[n2];
            switch (by) {
                case 13: {
                    if (position.endOfFirstLine == -1) {
                        position.endOfFirstLine = n2 - 1;
                    }
                    if (n2 < n3 && this.rawBytes[n2 + 1] == 10) {
                        ++n2;
                    }
                }
                case 10: {
                    if (position.endOfFirstLine == -1) {
                        position.endOfFirstLine = n2 - 1;
                    }
                    if (bl || n2 == n3 - 1) {
                        position.endOfSection = n2 == n3 - 1 ? n2 : n4;
                        position.startOfNext = n2 + 1;
                        return true;
                    }
                    n4 = n2;
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            ++n2;
        }
        return false;
    }

    public ManifestDigester(byte[] byArray) {
        this.rawBytes = byArray;
        this.entries = new HashMap();
        Position position = new Position();
        if (!this.findSection(0, position)) {
            return;
        }
        int n = position.startOfNext;
        while (this.findSection(n, position)) {
            int n2 = position.endOfFirstLine - n + 1;
            int n3 = position.endOfSection - n + 1;
            int n4 = position.startOfNext - n;
            if (n2 > 6 && this.isNameAttr(byArray, n)) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    stringBuffer.append(new String(byArray, n + 6, n2 - 6, "ISO8859_1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                int n5 = n + n2;
                if (n5 - n < n3) {
                    n5 = byArray[n5] == 13 ? (n5 += 2) : ++n5;
                }
                while (n5 - n < n3) {
                    if (byArray[n5++] != 32) break;
                    int n6 = n5;
                    while (n5 - n < n3 && byArray[n5++] != 10) {
                    }
                    if (byArray[n5 - 1] != 10) {
                        return;
                    }
                    int n7 = byArray[n5 - 2] == 13 ? n5 - n6 - 2 : n5 - n6 - 1;
                    try {
                        stringBuffer.append(new String(byArray, n6, n7, "ISO8859_1"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                String string = stringBuffer.toString();
                this.entries.put(string, new Entry(n, n3, n4, this.rawBytes));
            }
            n = position.startOfNext;
        }
    }

    private boolean isNameAttr(byte[] byArray, int n) {
        return !(byArray[n] != 78 && byArray[n] != 110 || byArray[n + 1] != 97 && byArray[n + 1] != 65 || byArray[n + 2] != 109 && byArray[n + 2] != 77 || byArray[n + 3] != 101 && byArray[n + 3] != 69 || byArray[n + 4] != 58 || byArray[n + 5] != 32);
    }

    public Entry get(String string, boolean bl) {
        Entry entry = (Entry)this.entries.get(string);
        if (entry != null) {
            entry.oldStyle = bl;
        }
        return entry;
    }

    public byte[] manifestDigest(MessageDigest messageDigest) {
        messageDigest.reset();
        messageDigest.update(this.rawBytes, 0, this.rawBytes.length);
        return messageDigest.digest();
    }

    public static class Entry {
        int offset;
        int length;
        int lengthWithBlankLine;
        byte[] rawBytes;
        boolean oldStyle;

        public Entry(int n, int n2, int n3, byte[] byArray) {
            this.offset = n;
            this.length = n2;
            this.lengthWithBlankLine = n3;
            this.rawBytes = byArray;
        }

        public byte[] digest(MessageDigest messageDigest) {
            messageDigest.reset();
            if (this.oldStyle) {
                this.doOldStyle(messageDigest, this.rawBytes, this.offset, this.lengthWithBlankLine);
            } else {
                messageDigest.update(this.rawBytes, this.offset, this.lengthWithBlankLine);
            }
            return messageDigest.digest();
        }

        private void doOldStyle(MessageDigest messageDigest, byte[] byArray, int n, int n2) {
            int n3 = n;
            int n4 = n;
            int n5 = n + n2;
            int n6 = -1;
            while (n3 < n5) {
                if (byArray[n3] == 13 && n6 == 32) {
                    messageDigest.update(byArray, n4, n3 - n4 - 1);
                    n4 = n3;
                }
                n6 = byArray[n3];
                ++n3;
            }
            messageDigest.update(byArray, n4, n3 - n4);
        }

        public byte[] digestWorkaround(MessageDigest messageDigest) {
            messageDigest.reset();
            messageDigest.update(this.rawBytes, this.offset, this.length);
            return messageDigest.digest();
        }
    }

    static class Position {
        int endOfFirstLine;
        int endOfSection;
        int startOfNext;

        Position() {
        }
    }
}

