/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc.ee;

import java.sql.SQLException;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnection;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.ee.PooledConnection;
import sun.jdbc.odbc.ee.PooledObject;

public class ConnectionHandler
extends JdbcOdbcConnection {
    private JdbcOdbcConnection con;
    private JdbcOdbcTracer tracer = new JdbcOdbcTracer();
    final int NOTOPEN = 0;
    final int OPEN = 1;
    final int CLOSING = 2;
    final int CLOSED = 3;
    final int DESTROYING = 4;
    final int DESTROYED = 5;
    private int state = 0;
    private PooledObject jpo;

    public ConnectionHandler(JdbcOdbc jdbcOdbc, long l, JdbcOdbcDriverInterface jdbcOdbcDriverInterface) {
        super(jdbcOdbc, l, jdbcOdbcDriverInterface);
        this.tracer = jdbcOdbc.getTracer();
    }

    public synchronized void close() {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        try {
            if (this.tracer.isTracing()) {
                this.tracer.trace("*Releasing all resources to this connection Connection.close");
            }
            super.setFreeStmtsFromConnectionOnly();
            super.closeAllStatements();
            super.setFreeStmtsFromAnyWhere();
            if (this.tracer.isTracing()) {
                this.tracer.trace("*Releasing all resources to this connection Connection.close");
            }
            this.jpo.markUsable();
            this.state = 3;
            ((PooledConnection)this.jpo).connectionClosed();
        }
        catch (Exception exception) {
            this.tracer.trace("Error occured while closing the connection " + this + " " + exception.getMessage());
            ((PooledConnection)this.jpo).connectionErrorOccurred(new SQLException(exception.getMessage()));
        }
    }

    public boolean isClosed() throws SQLException {
        return this.state != 1;
    }

    public synchronized void actualClose() throws SQLException {
        if (this.state == 4 || this.state == 5) {
            return;
        }
        if (this.state == 1) {
            this.jpo.markForSweep();
            this.close();
        }
        this.state = 4;
        try {
            if (this.tracer.isTracing()) {
                this.tracer.trace("*Actual Connection.close");
            }
            super.close();
            this.state = 5;
        }
        catch (SQLException sQLException) {
            this.state = 5;
            this.tracer.trace("Error occured while closing the connection " + this + " " + sQLException.getMessage());
            throw sQLException;
        }
        catch (Exception exception) {
            this.state = 5;
            this.tracer.trace("Error occured while closing the connection " + this + " " + exception.getMessage());
            throw new SQLException("Unexpected exception:" + exception.getMessage());
        }
    }

    public void destroy() throws SQLException {
        if (this.state == 4 || this.state == 5) {
            return;
        }
        this.state = 4;
        try {
            if (this.tracer.isTracing()) {
                this.tracer.trace("*ConnectionHandler.destroy");
            }
            super.close();
            this.state = 5;
        }
        catch (SQLException sQLException) {
            this.state = 5;
            this.tracer.trace("Error occured while closing the connection " + this + " " + sQLException.getMessage());
            throw sQLException;
        }
        catch (Exception exception) {
            this.state = 5;
            this.tracer.trace("Error occured while closing the connection " + this + " " + exception.getMessage());
            throw new SQLException("Unexpected exception:" + exception.getMessage());
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void setPooledObject(PooledObject pooledObject) {
        this.jpo = pooledObject;
    }

    public void finalize() {
        this.tracer.trace("Connectionhandler Finalize....");
        try {
            this.destroy();
        }
        catch (Exception exception) {}
    }
}

